/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widgets;

import com.twosigma.beakerx.widgets.ValueWidget;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class DatePicker
extends ValueWidget<Date> {
    public static final String VIEW_NAME_VALUE = "DatePickerView";
    public static final String MODEL_NAME_VALUE = "DatePickerModel";
    public static final String SHOW_TIME = "showTime";
    public static final String YYYY_MM_DD = "yyyyMMdd";
    private Boolean showTime;

    public DatePicker() {
        this.value = null;
        this.openComm();
    }

    @Override
    public String getModelModuleValue() {
        return "beakerx";
    }

    @Override
    public String getViewModuleValue() {
        return "beakerx";
    }

    @Override
    public void updateValue(Object value) {
        this.value = this.getValueFromObject(value);
    }

    @Override
    public Date getValueFromObject(Object input) {
        try {
            return new SimpleDateFormat(YYYY_MM_DD).parse((String)input);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected HashMap<String, Serializable> content(HashMap<String, Serializable> content) {
        super.content(content);
        content.put("value", this.value);
        return content;
    }

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public void setShowTime(Boolean showTime) {
        this.showTime = showTime;
        this.sendUpdate(SHOW_TIME, showTime);
    }

    public Boolean getShowTime() {
        return this.showTime;
    }
}

