/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.util.Collections;
import java.util.List;

public class MagicCommandExecutor {
    public static void sendRepliesWithStatus(List<MagicCommandOutcomeItem> errors, KernelFunctionality kernel, Message message, int executionCount) {
        errors.forEach(item -> {
            if (item.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
                MagicCommandExecutor.handleOkStatus(kernel, message, executionCount, item);
            } else {
                MagicCommandExecutor.handleErrorStatus(kernel, message, executionCount, item);
            }
        });
    }

    public static void sendMagicCommandOutcome(MagicCommandOutcomeItem item, KernelFunctionality kernel, Message message, int executionCount) {
        boolean hasError = item.getStatus().equals((Object)MagicCommandOutcomeItem.Status.ERROR);
        MagicCommandExecutor.publishOutcome(kernel, message, executionCount, item, hasError);
    }

    private static void handleErrorStatus(KernelFunctionality kernel, Message message, int executionCount, MagicCommandOutcomeItem item) {
        MagicCommandExecutor.publishOutcome(kernel, message, executionCount, item, true);
        kernel.send(MessageCreator.buildReplyWithErrorStatus(message, executionCount));
    }

    private static void handleOkStatus(KernelFunctionality kernel, Message message, int executionCount, MagicCommandOutcomeItem item) {
        MagicCommandExecutor.publishOutcome(kernel, message, executionCount, item, false);
        kernel.send(MessageCreator.buildReplyWithOkStatus(message, executionCount));
    }

    private static void publishOutcome(KernelFunctionality kernel, Message message, int executionCount, MagicCommandOutcomeItem item, boolean hasError) {
        if (item.getMIMEContainer().isPresent()) {
            if (item.getOutcome().equals((Object)MagicCommandOutcomeItem.Outcome.OUTPUT)) {
                kernel.publish(MessageCreator.buildOutputMessage(message, (String)item.getMIMEContainer().get().getData(), hasError));
            } else {
                MIMEContainer mimeContainer = item.getMIMEContainer().get();
                kernel.publish(MessageCreator.buildMessage(message, Collections.singletonList(mimeContainer), executionCount));
            }
        }
    }
}

