/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.evaluator;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.clojure.evaluator.ClojureEvaluator;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;

class ClojureCodeRunner
implements Callable<TryResult> {
    private ClojureEvaluator clojureEvaluator;
    private final String theCode;
    private final SimpleEvaluationObject theOutput;

    ClojureCodeRunner(ClojureEvaluator clojureEvaluator, String code, SimpleEvaluationObject out) {
        this.clojureEvaluator = clojureEvaluator;
        this.theCode = code;
        this.theOutput = out;
    }

    @Override
    public TryResult call() throws Exception {
        TryResult.CellError either;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.clojureEvaluator.getClassLoader());
        this.theOutput.setOutputHandler();
        try {
            InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
            Object o = this.clojureEvaluator.runCode(this.theCode);
            try {
                this.checkingOfCorruptedClojureObjects(o);
                either = TryResult.createResult((Object)o);
            }
            catch (Exception e) {
                either = TryResult.createError((String)("Object: " + o.getClass() + ", value cannot be displayed due to following error: " + e.getMessage()));
            }
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException || e instanceof InvocationTargetException || e instanceof ThreadDeath) {
                either = TryResult.createError((String)BaseEvaluator.INTERUPTED_MSG);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (null != e.getCause()) {
                e.getCause().printStackTrace(pw);
            } else {
                e.printStackTrace(pw);
            }
            either = TryResult.createError((String)sw.toString());
        }
        this.theOutput.setOutputHandler();
        Thread.currentThread().setContextClassLoader(oldLoader);
        return either;
    }

    private void checkingOfCorruptedClojureObjects(Object o) {
        if (null != o) {
            o.hashCode();
        }
    }
}

