/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.easyform;

import com.twosigma.beakerx.easyform.formitem.EasyFormListener;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widgets.CommFunctionality;
import com.twosigma.beakerx.widgets.DOMWidget;
import com.twosigma.beakerx.widgets.UpdateValueCallback;
import com.twosigma.beakerx.widgets.ValueWidget;
import com.twosigma.beakerx.widgets.Widget;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EasyFormComponent<T extends ValueWidget<?>>
implements CommFunctionality {
    protected T widget;
    private boolean enabled = true;
    private List<EasyFormListener> onChangeListeners = new LinkedList<EasyFormListener>();
    private List<EasyFormListener> onInitListeners = new LinkedList<EasyFormListener>();

    public EasyFormComponent(T widget) {
        this.widget = widget;
        ((Widget)widget).getComm().addMsgCallbackList(this::setupNewValue);
    }

    public EasyFormComponent() {
    }

    public String getLabel() {
        return ((ValueWidget)this.widget).getDescription();
    }

    public void setLabel(String label) {
        ((ValueWidget)this.widget).setDescription(label);
    }

    public Object getValue() {
        return ((ValueWidget)this.widget).getValue();
    }

    public void setValue(Object value) {
        ((ValueWidget)this.widget).setValue(value);
    }

    public T getWidget() {
        return this.widget;
    }

    public void fireInit() {
        for (EasyFormListener listener : this.onInitListeners) {
            listener.execute(this.getValue() != null ? this.getValue().toString() : null);
        }
    }

    public EasyFormComponent onInit(EasyFormListener listener) {
        this.addOnInitListener(listener);
        return this;
    }

    public void addOnInitListener(EasyFormListener listener) {
        if (listener != null) {
            this.onInitListeners.add(listener);
        }
    }

    public void removeOnInitListener(EasyFormListener listener) {
        if (this.onInitListeners.contains(listener)) {
            this.onInitListeners.remove(listener);
        }
    }

    public EasyFormComponent onChange(EasyFormListener listener) {
        this.addOnChangeListener(listener);
        return this;
    }

    public void fireChanged() {
        for (EasyFormListener listener : this.onChangeListeners) {
            listener.execute(this.getValue() != null ? this.getValue().toString() : null);
        }
    }

    public void addOnChangeListener(EasyFormListener listener) {
        if (listener != null) {
            this.onChangeListeners.add(listener);
        }
    }

    public void removeOnChangeListener(EasyFormListener listener) {
        if (this.onChangeListeners.contains(listener)) {
            this.onChangeListeners.remove(listener);
        }
    }

    public void clearListeners() {
        this.onChangeListeners.clear();
        this.onInitListeners.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Object formatValue(Object value) {
        return String.class.cast(value);
    }

    protected boolean checkValue(Object value) {
        return true;
    }

    public void registerUpdateValueCallback(UpdateValueCallback updateValueCallback) {
        ((DOMWidget)this.getWidget()).register(updateValueCallback);
    }

    public boolean isButton() {
        return false;
    }

    @Override
    public Comm getComm() {
        return ((Widget)this.getWidget()).getComm();
    }

    @Override
    public void close() {
        this.getComm().close();
    }

    private void setupNewValue(Message message) {
        Map stateMap;
        if (message.getContent() == null) {
            return;
        }
        Map dataMap = (Map)((Object)message.getContent().get("data"));
        if (dataMap != null && !dataMap.isEmpty() && (stateMap = (Map)dataMap.get("state")) != null && !stateMap.isEmpty()) {
            this.getNewValue(stateMap).ifPresent(newValue -> ((ValueWidget)this.widget).setValue(newValue));
        }
    }

    private Optional<Object> getNewValue(Map<String, String> stateMap) {
        if (stateMap.containsKey("value")) {
            return Optional.of(stateMap.get("value"));
        }
        if (stateMap.containsKey("index")) {
            return Optional.of(stateMap.get("index"));
        }
        return Optional.empty();
    }
}

