/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.kotlin.evaluator.KotlinCodeRunner;
import com.twosigma.beakerx.kotlin.evaluator.KotlinEvaluator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

class KotlinWorkerThread
extends WorkerThread {
    private static final String WRAPPER_CLASS_NAME = "BeakerWrapperClass1261714175";
    private KotlinEvaluator kotlinEvaluator;
    protected boolean exit;

    public KotlinWorkerThread(KotlinEvaluator kotlinEvaluator) {
        super("kotlin worker");
        this.kotlinEvaluator = kotlinEvaluator;
        this.exit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JobDescriptor j = null;
        NamespaceClient nc = null;
        while (!this.exit) {
            try {
                this.syncObject.acquire();
                j = (JobDescriptor)this.jobQueue.poll();
                if (j == null) continue;
                nc = NamespaceClient.getBeaker((String)this.kotlinEvaluator.getSessionId());
                nc.setOutputObj(j.outputObject);
                j.outputObject.started();
                try {
                    if (!this.kotlinEvaluator.executeTask(new KotlinCodeRunner(j.outputObject, this.kotlinEvaluator.getClassLoader(), this.kotlinEvaluator.getRepl(), j.codeToBeExecuted))) {
                        j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
                    }
                    if (nc != null) {
                        nc.setOutputObj(null);
                        nc = null;
                    }
                }
                catch (Exception e) {
                    j.outputObject.error((Object)e);
                }
                j = null;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (nc == null) continue;
                nc.setOutputObj(null);
                nc = null;
            }
        }
        NamespaceClient.delBeaker((String)this.kotlinEvaluator.getSessionId());
    }

    public void doExit() {
        this.exit = true;
        this.removeKtFile();
    }

    private void removeKtFile() {
        try {
            Files.deleteIfExists(new File(this.kotlinEvaluator.getOutDir() + "\\" + WRAPPER_CLASS_NAME + ".kt").toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

