/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.javash.evaluator.Codev;
import com.twosigma.beakerx.javash.evaluator.CompilationException;
import com.twosigma.beakerx.javash.evaluator.JavaEvaluator;
import com.twosigma.beakerx.javash.evaluator.JavaSourceCompiler;
import com.twosigma.beakerx.javash.evaluator.ParserUtil;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler;

class JavaCodeRunner
implements Runnable {
    private final SimpleEvaluationObject theOutput;
    private JobDescriptor j;
    private JavaEvaluator javaEvaluator;

    public JavaCodeRunner(JavaEvaluator javaEvaluator, SimpleEvaluationObject out, JobDescriptor j) {
        this.javaEvaluator = javaEvaluator;
        this.theOutput = (SimpleEvaluationObject)Preconditions.checkNotNull((Object)out);
        this.j = j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldld = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.javaEvaluator.getJavaClassLoader());
        this.theOutput.setOutputHandler();
        InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
        try {
            InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
            this.runCode(this.j);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof InterruptedException || e instanceof ThreadDeath) {
                this.theOutput.error((Object)BaseEvaluator.INTERUPTED_MSG);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.theOutput.error((Object)sw.toString());
            }
        }
        finally {
            this.theOutput.executeCodeCallback();
        }
        this.theOutput.clrOutputHandler();
        Thread.currentThread().setContextClassLoader(oldld);
    }

    private void runCode(JobDescriptor j) {
        j.outputObject.started();
        String code = ParserUtil.normalizeCode(j.codeToBeExecuted).replaceAll("\r\n", "\n");
        Codev codev = new Codev(code, this.javaEvaluator);
        try {
            this.compileCode(j, codev);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compileCode(JobDescriptor j, Codev codev) throws InvocationTargetException, IllegalAccessException {
        if (codev.hasLineToProcess()) {
            Codev.CodeLine codeLine = codev.getNotBlankLine();
            Pattern p = Pattern.compile("(?:^|.*\\s+)(?:(?:class)|(?:interface))\\s+([a-zA-Z]\\w*).*");
            Matcher m = p.matcher(codeLine.getLine());
            if (m.matches()) {
                this.compileNewDefinitionClass(j, m, codev);
            } else {
                this.compileAndRunCode(j, codev);
            }
        } else {
            this.compileAndRunCode(j, codev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method compileAndRunCode(JobDescriptor j, Codev codev) {
        String classId = this.generateClassId();
        String returnType = "Object";
        Codev copyCodev = new Codev(codev.getCode(), this.javaEvaluator);
        boolean compile = this.compile(codev, classId, returnType);
        if (!compile) {
            classId = this.generateClassId();
            returnType = "void";
            copyCodev = new Codev(codev.getCode(), this.javaEvaluator);
            this.compile(copyCodev, classId, returnType);
        }
        try {
            Class fooClass = this.javaEvaluator.getJavaClassLoader().loadClass(copyCodev.getPname() + "." + "BeakerWrapperClass1261714175" + classId);
            Method mth = fooClass.getDeclaredMethod("beakerRun", null);
            Object o = mth.invoke(null, (Object[])null);
            if (returnType.equals("Object")) {
                this.theOutput.finished(o);
            } else {
                this.theOutput.finished(null);
            }
        }
        catch (CompilationException e) {
            j.outputObject.error((Object)this.buildErrorMessage(e, copyCodev.lineNumbersMapping));
        }
        catch (Exception e) {
            j.outputObject.error((Object)("ERROR: " + e.getCause()));
        }
        finally {
            if (j.outputObject != null) {
                j.outputObject.executeCodeCallback();
            }
        }
        return null;
    }

    private boolean compile(Codev codev, String classId, String ret) {
        JavaSourceCompiler javaSourceCompiler = new JavaSourceCompiler();
        JavaSourceCompiler.CompilationUnit compilationUnit = javaSourceCompiler.createCompilationUnit(new File(this.javaEvaluator.getOutDir()));
        this.buildClasspath(compilationUnit);
        codev.javaSourceCode.append("public class BeakerWrapperClass1261714175" + classId + " {\n");
        codev.javaSourceCode.append("public static ");
        codev.javaSourceCode.append(ret);
        codev.javaSourceCode.append(" beakerRun() throws Exception {\n");
        this.addTheRestOfCode(codev);
        codev.javaSourceCode.append("}\n");
        codev.javaSourceCode.append("}\n");
        compilationUnit.addJavaSource(codev.getPname() + "." + "BeakerWrapperClass1261714175" + classId, codev.javaSourceCode.toString());
        boolean compile = javaSourceCompiler.compile(compilationUnit, new String[0]);
        if (compile) {
            javaSourceCompiler.persistCompiledClasses(compilationUnit);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileNewDefinitionClass(JobDescriptor j, Matcher m, Codev codev) {
        String cname = m.group(1);
        this.addTheRestOfCode(codev);
        JavaSourceCompiler javaSourceCompiler = new JavaSourceCompiler();
        JavaSourceCompiler.CompilationUnit compilationUnit = javaSourceCompiler.createCompilationUnit(new File(this.javaEvaluator.getOutDir()));
        this.buildClasspath(compilationUnit);
        compilationUnit.addJavaSource(codev.getPname() + "." + cname, codev.javaSourceCode.toString());
        try {
            javaSourceCompiler.compile(compilationUnit, new String[0]);
            javaSourceCompiler.persistCompiledClasses(compilationUnit);
            j.outputObject.finished((Object)(codev.getPname() + "." + cname));
        }
        catch (CompilationException e) {
            j.outputObject.error((Object)this.buildErrorMessage(e, codev.lineNumbersMapping));
        }
        catch (Exception e) {
            j.outputObject.error((Object)("ERROR: " + e.toString()));
        }
        finally {
            if (j.outputObject != null) {
                j.outputObject.executeCodeCallback();
            }
        }
    }

    private void buildClasspath(JavaSourceCompiler.CompilationUnit compilationUnit) {
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(File.pathSeparator);
        if (classpathEntries != null && classpathEntries.length > 0) {
            compilationUnit.addClassPathEntries(Arrays.asList(classpathEntries));
        }
        if (!this.javaEvaluator.getClasspath().isEmpty()) {
            compilationUnit.addClassPathEntries(this.javaEvaluator.getClasspath().getPathsAsStrings());
        }
    }

    private String generateClassId() {
        return "Id" + UUID.randomUUID().toString().replace("-", "");
    }

    private String buildErrorMessage(CompilationException exception, Map<Integer, Integer> lineNumbersMapping) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ERROR: ").append(exception.getMessage()).append('\n');
        for (CompilationException.CompilationError compilationError : exception.getCompilationErrors()) {
            stringBuilder.append("error at line ").append(this.mapLineNumber(lineNumbersMapping, compilationError.getLineNumber())).append(": ").append(this.prepareForFrontend(compilationError.getErrorMessage())).append('\n').append(compilationError.getCode());
        }
        return stringBuilder.toString();
    }

    private String prepareForFrontend(String errorMessage) {
        return errorMessage.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private Integer mapLineNumber(Map<Integer, Integer> lineNumbersMapping, int ourNumber) {
        Integer usersNumber = lineNumbersMapping.get(ourNumber);
        return usersNumber == null ? ourNumber : usersNumber + 1;
    }

    private void addTheRestOfCode(Codev codev) {
        while (codev.hasLineToProcess()) {
            codev.javaSourceCode.append(codev.getNotBlankLine().getLine());
            codev.javaSourceCode.append("\n");
            codev.lineNumbersMapping.put(codev.javaSourceCode.getLinesCount(), codev.getNotBlankLine().getIndex());
            codev.moveToNextLine();
        }
    }
}

