/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.javash.evaluator.JavaCodeRunner;
import com.twosigma.beakerx.javash.evaluator.JavaEvaluator;

class JavaWorkerThread
extends WorkerThread {
    private JavaEvaluator javaEvaluator;
    private boolean exit;

    public JavaWorkerThread(JavaEvaluator javaEvaluator) {
        super("javash worker");
        this.javaEvaluator = javaEvaluator;
        this.exit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        NamespaceClient nc = null;
        while (!this.exit) {
            try {
                this.syncObject.acquire();
                JobDescriptor j = (JobDescriptor)this.jobQueue.poll();
                if (j == null) continue;
                nc = NamespaceClient.getBeaker((String)this.javaEvaluator.getSessionId());
                nc.setOutputObj(j.outputObject);
                if (this.javaEvaluator.executeTask(new JavaCodeRunner(this.javaEvaluator, j.outputObject, j))) continue;
                j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (nc == null) continue;
                nc.setOutputObj(null);
                nc = null;
            }
        }
        NamespaceClient.delBeaker((String)this.javaEvaluator.getSessionId());
    }

    public void doExit() {
        this.exit = true;
    }
}

