/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class PomFactory {
    public String createPom(String pathToMavenRepo, MavenJarResolver.Dependency dependency, Map<String, String> repos) throws IOException {
        InputStream pom = this.getClass().getClassLoader().getResourceAsStream("PomTemplateMagicCommand.xml");
        String pomAsString = IOUtils.toString((InputStream)pom, (Charset)StandardCharsets.UTF_8);
        pomAsString = this.configureOutputDir(pathToMavenRepo, pomAsString);
        pomAsString = this.configureDependencies(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), pomAsString);
        pomAsString = this.configureRepos(repos, pomAsString);
        return pomAsString;
    }

    private String configureDependencies(String groupId, String artifactId, String version, String pomAsString) {
        return pomAsString.replace("<dependencies></dependencies>", "<dependencies>\n  <dependency>\n    <groupId>" + groupId + "</groupId>\n    <artifactId>" + artifactId + "</artifactId>\n    <version>" + version + "</version>\n  </dependency>\n</dependencies>");
    }

    private String configureOutputDir(String pathToMavenRepo, String pomAsString) {
        String absolutePath = new File(pathToMavenRepo).getAbsolutePath();
        return pomAsString.replace("<outputDirectory>pathToNotebookJars</outputDirectory>", "<outputDirectory>" + absolutePath + "</outputDirectory>");
    }

    private String configureRepos(Map<String, String> repos, String pomAsString) {
        for (Map.Entry<String, String> entry : repos.entrySet()) {
            pomAsString = this.configureRepos(pomAsString, entry.getKey(), entry.getValue());
        }
        return pomAsString;
    }

    private String configureRepos(String pomAsString, String name, String url) {
        String repoPattern = "<repository>\n    <id>%s</id>\n    <url>%s</url>\n</repository>\n";
        return pomAsString.replace("</repositories>", String.format(repoPattern, name, url) + "</repositories>");
    }
}

