/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommand;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CodeFactory {
    public static final String CELL_COMMAND_MAGIC = "%%";
    public static final ArrayList<MagicCommand> NO_MAGIC_COMMANDS = new ArrayList();
    private static List<MagicCommandOutcomeItem> NO_ERRORS = new ArrayList<MagicCommandOutcomeItem>();

    private CodeFactory() {
    }

    public static Code create(String allCode, Message message, KernelFunctionality kernel) {
        Scanner scanner = new Scanner(allCode);
        List<String> commandsList = CodeFactory.takeCommands(scanner);
        Optional<String> codeWithoutCommands = CodeFactory.codeWithoutCommands(scanner);
        if (!commandsList.isEmpty()) {
            return CodeFactory.createCodeWithCommands(allCode, message, kernel, commandsList, codeWithoutCommands);
        }
        return CodeFactory.createCodeWithoutCommands(allCode, message, codeWithoutCommands);
    }

    private static Code createCodeWithCommands(String allCode, Message message, KernelFunctionality kernel, List<String> commandsList, Optional<String> codeWithoutCommands) {
        String firstCommand = commandsList.get(0);
        if (CodeFactory.isCellCommand(firstCommand)) {
            return CodeFactory.createCodeWithCellCommand(allCode, message, kernel, commandsList, codeWithoutCommands, firstCommand);
        }
        return CodeFactory.createCodeWithLineMagicCommands(allCode, message, kernel, commandsList, codeWithoutCommands);
    }

    private static Code createCodeWithoutCommands(String allCode, Message message, Optional<String> codeWithoutCommands) {
        if (!codeWithoutCommands.isPresent()) {
            throw new RuntimeException("No code");
        }
        return Code.createCode(allCode, codeWithoutCommands.get(), NO_MAGIC_COMMANDS, NO_ERRORS, message);
    }

    private static Code createCodeWithLineMagicCommands(String allCode, Message message, KernelFunctionality kernel, List<String> commandsList, Optional<String> codeWithoutCommands) {
        ArrayList<MagicCommand> magicCommands = new ArrayList<MagicCommand>();
        ArrayList<MagicCommandOutcomeItem> errors = new ArrayList<MagicCommandOutcomeItem>();
        commandsList.forEach(command -> {
            Optional<MagicCommandFunctionality> mcOption = CodeFactory.findMagicCommandFunctionality(kernel.getMagicCommandTypes(), command);
            if (mcOption.isPresent()) {
                magicCommands.add(new MagicCommand(mcOption.get(), (String)command));
            } else {
                errors.add(CodeFactory.processIllegalCommand("Cell magic " + command + " not found"));
            }
        });
        if (codeWithoutCommands.isPresent()) {
            return Code.createCode(allCode, codeWithoutCommands.get(), magicCommands, errors, message);
        }
        return Code.createCodeWithoutCodeBlock(allCode, magicCommands, errors, message);
    }

    private static Code createCodeWithCellCommand(String allCode, Message message, KernelFunctionality kernel, List<String> commandsList, Optional<String> codeWithoutCommands, String firstCommand) {
        ArrayList<MagicCommandOutcomeItem> errors = new ArrayList<MagicCommandOutcomeItem>();
        ArrayList<MagicCommand> magicCommands = new ArrayList<MagicCommand>();
        StringBuilder restOfTheCode = new StringBuilder();
        restOfTheCode.append(String.join((CharSequence)System.lineSeparator(), commandsList.subList(1, commandsList.size())));
        codeWithoutCommands.ifPresent(code -> restOfTheCode.append((String)code));
        Optional<MagicCommandFunctionality> mcOption = CodeFactory.findMagicCommandFunctionality(kernel.getMagicCommandTypes(), firstCommand);
        if (mcOption.isPresent()) {
            magicCommands.add(new MagicCommand(mcOption.get(), firstCommand, restOfTheCode.toString()));
        } else {
            errors.add(CodeFactory.processIllegalCommand("Cell magic " + firstCommand + " not found"));
        }
        return Code.createCodeWithoutCodeBlock(allCode, magicCommands, errors, message);
    }

    private static boolean isCellCommand(String command) {
        return command.startsWith(CELL_COMMAND_MAGIC);
    }

    private static Optional<String> codeWithoutCommands(Scanner scanner) {
        ArrayList<String> codeWithoutCommands = new ArrayList<String>();
        while (scanner.hasNext()) {
            codeWithoutCommands.add(scanner.nextLine());
        }
        if (codeWithoutCommands.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(StringUtils.join(codeWithoutCommands, (String)System.lineSeparator()));
    }

    private static List<String> takeCommands(Scanner scanner) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile("^%.*", 8);
        while (scanner.hasNext(p)) {
            result.add(CodeFactory.removeExtraWhitespaces(scanner.nextLine()));
        }
        return result;
    }

    private static String removeExtraWhitespaces(String command) {
        return command.replaceAll("\\s+", " ");
    }

    private static Optional<MagicCommandFunctionality> findMagicCommandFunctionality(List<MagicCommandType> commands, String command) {
        return commands.stream().filter(c -> c.getMagicCommandFunctionality().matchCommand(command)).map(MagicCommandType::getMagicCommandFunctionality).findFirst();
    }

    private static MagicCommandOutcomeItem processIllegalCommand(String errorMessage) {
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, errorMessage);
    }
}

