/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.groovy.evaluator.GroovyEvaluator;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import groovy.lang.Script;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroovyCodeRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyCodeRunner.class.getName());
    private GroovyEvaluator groovyEvaluator;
    private final String theCode;
    private final SimpleEvaluationObject theOutput;

    public GroovyCodeRunner(GroovyEvaluator groovyEvaluator, String code, SimpleEvaluationObject out) {
        this.groovyEvaluator = groovyEvaluator;
        this.theCode = code;
        this.theOutput = out;
    }

    @Override
    public void run() {
        ClassLoader oldld = Thread.currentThread().getContextClassLoader();
        this.theOutput.setOutputHandler();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.groovyEvaluator.getGroovyClassLoader());
            Class parsedClass = this.groovyEvaluator.getGroovyClassLoader().parseClass(this.theCode);
            Script instance = (Script)parsedClass.newInstance();
            if (GroovyEvaluator.LOCAL_DEV) {
                this.groovyEvaluator.getScriptBinding().setVariable("beakerx", new HashMap());
            } else {
                this.groovyEvaluator.getScriptBinding().setVariable("beakerx", (Object)NamespaceClient.getBeaker((String)this.groovyEvaluator.getSessionId()));
            }
            instance.setBinding(this.groovyEvaluator.getScriptBinding());
            InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
            Object result = instance.run();
            if (GroovyEvaluator.LOCAL_DEV) {
                logger.info("Result: {}", result);
                logger.info("Variables: {}", (Object)this.groovyEvaluator.getScriptBinding().getVariables());
            }
            this.theOutput.finished(result);
        }
        catch (Throwable e) {
            if (GroovyEvaluator.LOCAL_DEV) {
                logger.warn(e.getMessage());
                e.printStackTrace();
            }
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof InterruptedException || e instanceof InvocationTargetException || e instanceof ThreadDeath) {
                this.theOutput.error((Object)BaseEvaluator.INTERUPTED_MSG);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceUtils.sanitize((Throwable)e).printStackTrace(pw);
            this.theOutput.error((Object)sw.toString());
        }
        this.theOutput.clrOutputHandler();
        Thread.currentThread().setContextClassLoader(oldld);
    }
}

