/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableCollection;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AssignmentTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtBinaryExpression expression;
    protected final boolean isVariableReassignment;

    public static boolean isAssignmentOperator(KtToken operationToken) {
        return ((ImmutableCollection)((Object)OperatorConventions.ASSIGNMENT_OPERATIONS.keySet())).contains(operationToken) || PsiUtils.isAssignment(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        CallableDescriptor operationDescriptor;
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression2) && ((operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression2)) == null || operationDescriptor.getExtensionReceiverParameter() == null)) {
            return IntrinsicAssignmentTranslator.doTranslate(expression2, context);
        }
        return OverloadedAssignmentTranslator.doTranslate(expression2, context);
    }

    protected AssignmentTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression2;
        this.isVariableReassignment = BindingUtils.isVariableReassignment(context.bindingContext(), expression2);
        assert (expression2.getLeft() != null) : "No left-hand side: " + expression2.getText();
    }

    protected final AccessTranslator createAccessTranslator(@NotNull KtExpression left, boolean forceOrderOfEvaluation) {
        if (AssignmentTranslator.isReferenceToBackingFieldFromConstructor(left, this.context())) {
            KtSimpleNameExpression simpleName = PsiUtils.getSimpleName(left);
            assert (simpleName != null);
            return BackingFieldAccessTranslator.newInstance(simpleName, this.context());
        }
        return AccessTranslationUtils.getAccessTranslator(left, this.context(), forceOrderOfEvaluation);
    }

    private static boolean isReferenceToBackingFieldFromConstructor(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        KtDotQualifiedExpression qualifiedExpression;
        if (expression2 instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)expression2;
            DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), nameExpression);
            return AssignmentTranslator.isReferenceToBackingFieldFromConstructor(descriptor2, context);
        }
        if (expression2 instanceof KtDotQualifiedExpression && (qualifiedExpression = (KtDotQualifiedExpression)expression2).getReceiverExpression() instanceof KtThisExpression && qualifiedExpression.getSelectorExpression() instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)qualifiedExpression.getSelectorExpression();
            DeclarationDescriptor descriptor3 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), nameExpression);
            return AssignmentTranslator.isReferenceToBackingFieldFromConstructor(descriptor3, context);
        }
        return false;
    }

    private static boolean isReferenceToBackingFieldFromConstructor(@Nullable DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
        if (!(context.getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)context.getDeclarationDescriptor();
        if (classDescriptor != propertyDescriptor.getContainingDeclaration()) {
            return false;
        }
        return !propertyDescriptor.isVar();
    }
}

