/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.classloader;

import com.google.common.io.ByteStreams;
import com.twosigma.beakerx.jvm.classloader.BeakerxUrlClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClassLoaderSimple
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger((String)DynamicClassLoaderSimple.class.getName());
    private BeakerxUrlClassLoader myloader = new BeakerxUrlClassLoader(new URL[0], null);
    private String outDir;
    protected final Map<String, Class<?>> classes = Collections.synchronizedMap(new HashMap());

    public DynamicClassLoaderSimple(ClassLoader classLoader) {
        super(classLoader);
    }

    public void addJars(List<String> dirs) {
        for (String dir : dirs) {
            try {
                this.myloader.addJar(Paths.get(dir, new String[0]).toUri().toURL());
            }
            catch (MalformedURLException e) {
                logger.error(e.getMessage());
            }
        }
    }

    public void addDynamicDir(String o) {
        this.outDir = o + File.separator;
    }

    private Class<?> getClass(String cname, byte[] bytes, boolean resolveIt) {
        Class<?> result = this.defineClass(cname, bytes, 0, bytes.length);
        if (result == null) {
            return null;
        }
        if (result.getPackage() == null) {
            String packageName;
            int lastDotIndex = cname.lastIndexOf(46);
            String string = packageName = lastDotIndex >= 0 ? cname.substring(0, lastDotIndex) : "";
            if (!packageName.isEmpty()) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
        }
        if (resolveIt) {
            this.resolveClass(result);
        }
        return result;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!name.startsWith("java")) {
                String cname = this.formatClassName(name);
                String fname = this.outDir + cname;
                File f = new File(fname);
                if (f.exists() && f.isFile()) {
                    try {
                        FileInputStream fis = new FileInputStream(f);
                        byte[] bytes = ByteStreams.toByteArray((InputStream)fis);
                        Class<?> result = this.getClass(name, bytes, true);
                        if (result != null) {
                            return result;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.myloader != null) {
                    Class<?> result = this.classes.get(name);
                    if (result != null) {
                        return result;
                    }
                    InputStream is = this.myloader.getResourceAsStream(cname);
                    if (is != null) {
                        try {
                            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
                            result = this.getClass(name, bytes, true);
                            if (result != null) {
                                this.classes.put(name, result);
                                return result;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            throw new ClassNotFoundException();
        }
    }

    @Override
    public URL getResource(String name) {
        URL c = this.getParent().getResource(name);
        if (c == null && this.myloader != null) {
            c = this.myloader.getResource(name);
        }
        return c;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream c = this.getParent().getResourceAsStream(name);
        if (c == null && this.myloader != null) {
            c = this.myloader.getResourceAsStream(name);
        }
        return c;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> c = this.getParent().getResources(name);
        if (!(c != null && c.hasMoreElements() || this.myloader == null)) {
            try {
                c = this.myloader.getResources(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return c;
    }

    protected String formatClassName(String className) {
        className = className.replace('/', '~');
        className = className.replace('.', '/') + ".class";
        className = className.replace('~', '/');
        return className;
    }
}

