/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.evaluator;

import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObjectWithTime;
import com.twosigma.beakerx.kernel.AddImportStatus;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.kernel.Repos;
import com.twosigma.beakerx.message.Message;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluatorManager {
    public static Logger logger = LoggerFactory.getLogger(EvaluatorManager.class);
    protected Evaluator evaluator = null;
    protected KernelFunctionality kernel;

    public EvaluatorManager(KernelFunctionality kernel, Evaluator evaluator) {
        this.kernel = kernel;
        this.evaluator = evaluator;
    }

    public synchronized void setShellOptions(EvaluatorParameters kernelParameters) {
        try {
            this.evaluator.setShellOptions(kernelParameters);
        }
        catch (IOException e) {
            logger.error("Error while setting Shell Options", (Throwable)e);
        }
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.evaluator.autocomplete(code, caretPosition);
    }

    public void cancelExecution() {
        this.evaluator.cancelExecution();
    }

    public synchronized void killAllThreads() {
        this.evaluator.killAllThreads();
    }

    public synchronized SimpleEvaluationObject executeCode(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallback executeCodeCallback) {
        return this.execute(code, message, executionCount, executeCodeCallback);
    }

    public synchronized SimpleEvaluationObjectWithTime executeCodeWithTimeMeasurement(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallbackWithTime executeCodeCallbackWithTime) {
        return this.executeWithTimeMeasurement(code, message, executionCount, executeCodeCallbackWithTime);
    }

    public void exit() {
        this.evaluator.exit();
    }

    private SimpleEvaluationObject execute(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallback executeCodeCallback) {
        SimpleEvaluationObject seo = this.createSimpleEvaluationObject(code, message, executionCount, executeCodeCallback);
        this.evaluator.evaluate(seo, code);
        return seo;
    }

    private SimpleEvaluationObjectWithTime executeWithTimeMeasurement(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallbackWithTime executeCodeCallbackWithTime) {
        SimpleEvaluationObjectWithTime seowt = this.createSimpleEvaluationObjectWithTime(code, message, executionCount, executeCodeCallbackWithTime);
        this.evaluator.evaluate(seowt, code);
        return seowt;
    }

    private SimpleEvaluationObject createSimpleEvaluationObject(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallback executeCodeCallback) {
        SimpleEvaluationObject seo = new SimpleEvaluationObject(code, executeCodeCallback);
        seo.setJupyterMessage(message);
        seo.setExecutionCount(executionCount);
        seo.addObserver(this.kernel.getExecutionResultSender());
        return seo;
    }

    private SimpleEvaluationObjectWithTime createSimpleEvaluationObjectWithTime(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallbackWithTime executeCodeCallbackWithTime) {
        SimpleEvaluationObjectWithTime seowt = new SimpleEvaluationObjectWithTime(code, executeCodeCallbackWithTime);
        seowt.setJupyterMessage(message);
        seowt.setExecutionCount(executionCount);
        return seowt;
    }

    public List<Path> addJarsToClasspath(List<PathToJar> paths) {
        return this.evaluator.addJarsToClasspath(paths);
    }

    public Classpath getClasspath() {
        return this.evaluator.getClasspath();
    }

    public Imports getImports() {
        return this.evaluator.getImports();
    }

    public Repos getRepos() {
        return this.evaluator.getRepos();
    }

    public AddImportStatus addImport(ImportPath anImport) {
        return this.evaluator.addImport(anImport);
    }

    public void removeImport(ImportPath anImport) {
        this.evaluator.removeImport(anImport);
    }

    public Path getTempFolder() {
        return this.evaluator.getTempFolder();
    }

    public Class<?> loadClass(String clazzName) throws ClassNotFoundException {
        return this.evaluator.loadClass(clazzName);
    }

    public String addRepo(String name, String url) {
        return this.evaluator.addRepo(name, url);
    }
}

