/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.common.PGClassLoaderSingleton;
import com.amazon.redshift.common.PGCommonDataSource;
import com.amazon.redshift.jdbc.Driver;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.PooledConnection;

public class DataSource
implements PGCommonDataSource {
    private static final String DATASOURCE_CLASS = "com.amazon.redshift.core.jdbc42.PGJDBC42DataSource";
    private static Constructor<? extends PGCommonDataSource> s_dataSourceCtor;
    private static Exception s_classLoadExc;
    private final PGCommonDataSource m_dataSource;

    public DataSource() {
        if (s_classLoadExc != null) {
            PGClassLoaderSingleton.validateTempDir();
            throw new RuntimeException("Failed to load DataSource class. This error may be caused by all-in-one JAR packaging. Please try again with the lean package.", s_classLoadExc);
        }
        try {
            this.m_dataSource = s_dataSourceCtor.newInstance(new Object[0]);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_dataSource.getLogWriter();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.m_dataSource.getPooledConnection();
    }

    @Override
    public String getCustomProperty(String string) {
        return this.m_dataSource.getCustomProperty(string);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return this.m_dataSource.unwrap(clazz);
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return this.m_dataSource.getPooledConnection(string, string2);
    }

    @Override
    public String getLanguage() {
        return this.m_dataSource.getLanguage();
    }

    @Override
    public String getLogDirectory() {
        return this.m_dataSource.getLogDirectory();
    }

    @Override
    public String getLogLevelString() {
        return this.m_dataSource.getLogLevelString();
    }

    @Override
    public String getPassword() {
        return this.m_dataSource.getPassword();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.m_dataSource.setLogWriter(printWriter);
    }

    @Override
    public String getUserID() {
        return this.m_dataSource.getUserID();
    }

    @Override
    public void removeCustomProperty(String string) {
        this.m_dataSource.removeCustomProperty(string);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.m_dataSource.isWrapperFor(clazz);
    }

    @Override
    public void setCustomProperty(String string, String string2) {
        this.m_dataSource.setCustomProperty(string, string2);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.m_dataSource.setLoginTimeout(n);
    }

    @Override
    public void setLanguage(String string) {
        this.m_dataSource.setLanguage(string);
    }

    @Override
    public void setLogDirectory(String string) {
        this.m_dataSource.setLogDirectory(string);
    }

    @Override
    public void setLogLevel(String string) {
        this.m_dataSource.setLogLevel(string);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.m_dataSource.getConnection(string, string2);
    }

    @Override
    public void setPassword(String string) {
        this.m_dataSource.setPassword(string);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_dataSource.getLoginTimeout();
    }

    @Override
    public void setURL(String string) {
        this.m_dataSource.setURL(string);
    }

    @Override
    public void setUserID(String string) {
        this.m_dataSource.setUserID(string);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.m_dataSource.getParentLogger();
    }

    static {
        try {
            URL uRL = Driver.class.getProtectionDomain().getCodeSource().getLocation();
            String string = uRL.getPath();
            if (!"file".equalsIgnoreCase(uRL.getProtocol()) || !string.toLowerCase().endsWith(".jar")) {
                Class<?> clazz = Class.forName(DATASOURCE_CLASS);
                s_dataSourceCtor = clazz.asSubclass(PGCommonDataSource.class).getConstructor(new Class[0]);
            } else {
                Class<?> clazz = Class.forName(DATASOURCE_CLASS, true, PGClassLoaderSingleton.getInstance());
                s_dataSourceCtor = clazz.asSubclass(PGCommonDataSource.class).getConstructor(new Class[0]);
            }
        }
        catch (Exception exception) {
            s_classLoadExc = exception;
        }
    }
}

