/*
 * Decompiled with CFR 0.152.
 */
package org.abstractmeta.toolbox.compilation.compiler.impl;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler;
import org.abstractmeta.toolbox.compilation.compiler.impl.JavaCodeFileObject;
import org.abstractmeta.toolbox.compilation.compiler.impl.JavaSourceFileObject;
import org.abstractmeta.toolbox.compilation.compiler.impl.SimpleClassLoader;
import org.abstractmeta.toolbox.compilation.compiler.impl.SimpleJavaFileManager;
import org.abstractmeta.toolbox.compilation.compiler.registry.JavaFileObjectRegistry;
import org.abstractmeta.toolbox.compilation.compiler.registry.impl.JavaFileObjectRegistryImpl;
import org.abstractmeta.toolbox.compilation.compiler.util.ClassPathUtil;
import org.abstractmeta.toolbox.compilation.compiler.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourceCompilerImpl
implements JavaSourceCompiler {
    private final Logger logger = LoggerFactory.getLogger((String)JavaSourceCompilerImpl.class.getName());
    private static final List<String> CLASS_PATH_OPTIONS = new ArrayList<String>(Arrays.asList("cp", "classpath"));
    private static final String CLASS_PATH_DELIMITER = ClassPathUtil.getClassPathSeparator();

    @Override
    public boolean compile(JavaSourceCompiler.CompilationUnit compilationUnit, String ... options) {
        return this.compile(this.getClass().getClassLoader(), compilationUnit, options);
    }

    @Override
    public boolean compile(ClassLoader parentClassLoader, JavaSourceCompiler.CompilationUnit compilationUnit, String ... options) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        return this.compile(compiler, parentClassLoader, compilationUnit, options);
    }

    protected boolean compile(JavaCompiler compiler, ClassLoader parentClassLoader, JavaSourceCompiler.CompilationUnit compilationUnit, String ... options) {
        if (compiler == null) {
            throw new IllegalStateException("Failed to create the system Java compiler. Check that your class path includes tools.jar");
        }
        JavaFileObjectRegistry registry = compilationUnit.getRegistry();
        SimpleClassLoader result = new SimpleClassLoader(parentClassLoader, registry, compilationUnit.getOutputClassDirectory());
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        SimpleJavaFileManager javaFileManager = new SimpleJavaFileManager(standardFileManager, result, registry);
        Collection<JavaFileObject> sources = registry.get(JavaFileObject.Kind.SOURCE);
        Collection<String> compilationOptions = this.buildOptions(compilationUnit, result, options);
        JavaCompiler.CompilationTask task = compiler.getTask(null, javaFileManager, diagnostics, compilationOptions, null, sources);
        task.call();
        if (this.getDiagnosticCountByType(diagnostics, Diagnostic.Kind.ERROR) > 0L) {
            String diagnosticString = this.getDiagnosticString(registry, diagnostics);
            if (diagnosticString.contains("missing return statement")) {
                return false;
            }
            throw new IllegalStateException(diagnosticString);
        }
        if (this.getDiagnosticCountByType(diagnostics, Diagnostic.Kind.WARNING) > 0L) {
            this.logger.warn(this.getDiagnosticString(registry, diagnostics));
        }
        result.addClassPathEntries(compilationUnit.getClassPathsEntries());
        return true;
    }

    protected boolean buildDiagnosticMessage(Diagnostic diagnostic, StringBuilder diagnosticBuilder, JavaFileObjectRegistry registry) {
        Object source = diagnostic.getSource();
        String sourceErrorDetails = "";
        if (source != null) {
            JavaSourceFileObject sourceFile = (JavaSourceFileObject)JavaSourceFileObject.class.cast(source);
            CharSequence sourceCode = sourceFile.getCharContent(true);
            int startPosition = Math.max((int)diagnostic.getStartPosition() - 10, 0);
            int endPosition = Math.min(sourceCode.length(), (int)diagnostic.getEndPosition() + 10);
            sourceErrorDetails = sourceCode.subSequence(startPosition, endPosition) + "";
        }
        diagnosticBuilder.append(diagnostic.getMessage(null));
        diagnosticBuilder.append("\n");
        diagnosticBuilder.append(sourceErrorDetails);
        return diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR);
    }

    protected Collection<String> buildOptions(JavaSourceCompiler.CompilationUnit compilationUnit, SimpleClassLoader classLoader, String ... options) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        for (int i = 0; i < options.length; i += 2) {
            optionsMap.put(options[i], options[i + 1]);
        }
        for (String classPathKey : CLASS_PATH_OPTIONS) {
            if (!optionsMap.containsKey(classPathKey)) continue;
            this.addClassPath(compilationUnit, (String)optionsMap.get(classPathKey));
        }
        for (String key : optionsMap.keySet()) {
            if (CLASS_PATH_OPTIONS.contains(key)) continue;
            result.addAll(Arrays.asList(key, (String)optionsMap.get(key)));
        }
        this.addClassPath(result, compilationUnit);
        return result;
    }

    private void addClassPath(List<String> result, JavaSourceCompiler.CompilationUnit compilationUnit) {
        StringBuilder classPathBuilder = new StringBuilder();
        for (String entry : compilationUnit.getClassPathsEntries()) {
            if (classPathBuilder.length() > 0) {
                classPathBuilder.append(CLASS_PATH_DELIMITER);
            }
            classPathBuilder.append(entry);
        }
        if (classPathBuilder.length() > 0) {
            result.addAll(Arrays.asList("-cp", classPathBuilder.toString()));
        }
    }

    protected void addClassPath(JavaSourceCompiler.CompilationUnit result, String classPath) {
        String[] classPathEntries;
        for (String classPathEntry : classPathEntries = classPath.split(CLASS_PATH_DELIMITER)) {
            result.addClassPathEntry(classPathEntry);
        }
    }

    @Override
    public JavaSourceCompiler.CompilationUnit createCompilationUnit() {
        File outputDirectory = new File(System.getProperty("java.io.tmpdir"), "compiled-code_" + System.currentTimeMillis());
        return this.createCompilationUnit(outputDirectory);
    }

    @Override
    public JavaSourceCompiler.CompilationUnit createCompilationUnit(File outputClassDirectory) {
        return new CompilationUnitImpl(outputClassDirectory);
    }

    protected IllegalStateException createCompilationErrorException(JavaFileObjectRegistry registry, DiagnosticCollector<JavaFileObject> diagnostics) {
        return new IllegalStateException(this.getDiagnosticString(registry, diagnostics));
    }

    private String getDiagnosticString(JavaFileObjectRegistry registry, DiagnosticCollector<JavaFileObject> diagnostics) {
        StringBuilder diagnosticBuilder = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            this.buildDiagnosticMessage(diagnostic, diagnosticBuilder, registry);
        }
        return diagnosticBuilder.toString();
    }

    private long getDiagnosticCountByType(DiagnosticCollector<JavaFileObject> diagnostics, Diagnostic.Kind kind) {
        long result = 0L;
        for (Diagnostic<JavaFileObject> e : diagnostics.getDiagnostics()) {
            if (!e.getKind().equals((Object)kind)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void persistCompiledClasses(JavaSourceCompiler.CompilationUnit compilationUnit) {
        JavaFileObjectRegistry registry = compilationUnit.getRegistry();
        File classOutputDirectory = compilationUnit.getOutputClassDirectory();
        if (!classOutputDirectory.exists() && !classOutputDirectory.mkdirs()) {
            throw new IllegalStateException("Failed to create directory " + classOutputDirectory.getAbsolutePath());
        }
        for (JavaFileObject javaFileObject : registry.get(JavaFileObject.Kind.CLASS)) {
            String internalName = javaFileObject.getName().substring(1);
            File compiledClassFile = new File(classOutputDirectory, internalName);
            if (!compiledClassFile.getParentFile().exists() && !compiledClassFile.getParentFile().mkdirs()) {
                throw new IllegalStateException("Failed to create directories " + compiledClassFile.getParent());
            }
            try {
                Files.write((byte[])((JavaCodeFileObject)JavaCodeFileObject.class.cast(javaFileObject)).getByteCode(), (File)compiledClassFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write to file " + compiledClassFile, e);
            }
        }
    }

    public static class CompilationUnitImpl
    implements JavaSourceCompiler.CompilationUnit {
        private final List<String> classPathEntries = new ArrayList<String>();
        private final JavaFileObjectRegistry registry = new JavaFileObjectRegistryImpl();
        private final File outputClassDirectory;

        public CompilationUnitImpl(File outputClassDirectory) {
            this.outputClassDirectory = outputClassDirectory;
        }

        @Override
        public void addClassPathEntry(String classPathEntry) {
            this.classPathEntries.add(classPathEntry);
        }

        @Override
        public void addClassPathEntries(Collection<String> classPathEntries) {
            this.classPathEntries.addAll(classPathEntries);
        }

        @Override
        public void addJavaSource(String className, String source) {
            URI sourceUri = URIUtil.buildUri(StandardLocation.SOURCE_OUTPUT, className);
            this.registry.register(new JavaSourceFileObject(sourceUri, source));
        }

        @Override
        public JavaFileObjectRegistry getRegistry() {
            return this.registry;
        }

        @Override
        public List<String> getClassPathsEntries() {
            return this.classPathEntries;
        }

        @Override
        public File getOutputClassDirectory() {
            return this.outputClassDirectory;
        }
    }
}

