/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;

public class LoadMagicMagicCommand
implements MagicCommandFunctionality {
    public static final String LOAD_MAGIC = "%load_magic";
    private KernelFunctionality kernel;

    public LoadMagicMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    @Override
    public String getMagicCommandName() {
        return LOAD_MAGIC;
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath(command);
        if (split.length != 2) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %load_magic");
        }
        String clazzName = split[1];
        try {
            Class<?> aClass = this.kernel.loadClass(clazzName);
            Object instance = aClass.newInstance();
            if (instance instanceof MagicCommandFunctionality) {
                MagicCommandFunctionality commandFunctionality = (MagicCommandFunctionality)instance;
                this.kernel.registerMagicCommandType(new MagicCommandType(commandFunctionality.getMagicCommandName(), "", commandFunctionality));
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, "Magic command " + commandFunctionality.getMagicCommandName() + " was successfully added.");
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Magic command have to implement " + MagicCommandFunctionality.class + " interface.");
        }
        catch (Exception e) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, e.toString());
        }
    }
}

