/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcome;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.util.Collections;

public class MagicCommandExecutor {
    public static MagicCommandOutcome executeMagicCommands(Code code, int executionCount, KernelFunctionality kernel) {
        MagicCommandOutcome result = new MagicCommandOutcome();
        if (code.hasErrors()) {
            code.getErrors().forEach(result::addItem);
            MagicCommandExecutor.sendMagicCommandsResult(result, kernel, code.getMessage(), executionCount);
        } else {
            code.getMagicCommands().forEach(magicCommand -> {
                MagicCommandExecutionParam param = new MagicCommandExecutionParam(code, magicCommand.getCommand(), magicCommand.getCommandCodeBlock(), executionCount);
                MagicCommandOutcomeItem item = magicCommand.execute(param);
                result.addItem(item);
                MagicCommandExecutor.sendMagicCommandOutcome(item, kernel, code.getMessage(), executionCount);
            });
            MagicCommandExecutor.sendRepliesWithStatus(result, kernel, code.getMessage(), executionCount);
        }
        return result;
    }

    private static void sendMagicCommandsResult(MagicCommandOutcome magicCommandResult, KernelFunctionality kernel, Message message, int executionCount) {
        magicCommandResult.getItems().forEach(item -> {
            if (item.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
                MagicCommandExecutor.handleOkStatus(kernel, message, executionCount, item);
            } else {
                MagicCommandExecutor.handleErrorStatus(kernel, message, executionCount, item);
            }
        });
    }

    private static void sendMagicCommandOutcome(MagicCommandOutcomeItem item, KernelFunctionality kernel, Message message, int executionCount) {
        boolean hasError = item.getStatus().equals((Object)MagicCommandOutcomeItem.Status.ERROR);
        MagicCommandExecutor.publishOutcome(kernel, message, executionCount, item, hasError);
    }

    private static void sendRepliesWithStatus(MagicCommandOutcome magicCommandResult, KernelFunctionality kernel, Message message, int executionCount) {
        magicCommandResult.getItems().forEach(item -> {
            if (item.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
                kernel.send(MessageCreator.buildReplyWithOkStatus(message, executionCount));
            } else {
                kernel.send(MessageCreator.buildReplyWithErrorStatus(message, executionCount));
            }
        });
    }

    private static void handleErrorStatus(KernelFunctionality kernel, Message message, int executionCount, MagicCommandOutcomeItem item) {
        MagicCommandExecutor.publishOutcome(kernel, message, executionCount, item, true);
        kernel.send(MessageCreator.buildReplyWithErrorStatus(message, executionCount));
    }

    private static void handleOkStatus(KernelFunctionality kernel, Message message, int executionCount, MagicCommandOutcomeItem item) {
        MagicCommandExecutor.publishOutcome(kernel, message, executionCount, item, false);
        kernel.send(MessageCreator.buildReplyWithOkStatus(message, executionCount));
    }

    private static void publishOutcome(KernelFunctionality kernel, Message message, int executionCount, MagicCommandOutcomeItem item, boolean hasError) {
        if (item.getMIMEContainer().isPresent()) {
            if (item.getOutcome().equals((Object)MagicCommandOutcomeItem.Outcome.OUTPUT)) {
                kernel.publish(MessageCreator.buildOutputMessage(message, (String)item.getMIMEContainer().get().getData(), hasError));
            } else {
                MIMEContainer mimeContainer = item.getMIMEContainer().get();
                kernel.publish(MessageCreator.buildMessage(message, Collections.singletonList(mimeContainer), executionCount));
            }
        }
    }
}

