/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommInfoHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(CommInfoHandler.class);

    public CommInfoHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        logger.debug("Processing CommInfoHandler");
        Message reply = new Message();
        reply.setHeader(new Header(JupyterMessages.COMM_INFO_REPLY, message.getHeader().getSession()));
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        content.put("comms", new HashMap());
        String target = this.getMessageTarget(message);
        this.kernel.getCommHashSet().stream().map(hash -> this.kernel.getComm((String)hash)).filter(comm -> target == null || target.isEmpty() || comm.getTargetName().equals(target)).forEach(comm -> {
            HashMap<String, String> commRepDetails = new HashMap<String, String>();
            commRepDetails.put("target_name", comm.getTargetName());
            ((HashMap)content.get("comms")).put(comm.getCommId(), commRepDetails);
        });
        reply.setContent(content);
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        this.send(reply);
    }

    private String getMessageTarget(Message message) {
        Map<String, Serializable> content = message.getContent();
        return content == null ? null : (String)((Object)message.getContent().get("target_name"));
    }
}

