/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.easyform.formitem.widgets;

import com.twosigma.beakerx.easyform.EasyFormComponent;
import com.twosigma.beakerx.easyform.formitem.widgets.CheckBoxWidget;
import com.twosigma.beakerx.widgets.ValueWidget;
import com.twosigma.beakerx.widgets.Widget;
import com.twosigma.beakerx.widgets.box.Box;
import com.twosigma.beakerx.widgets.box.HBox;
import com.twosigma.beakerx.widgets.box.VBox;
import com.twosigma.beakerx.widgets.strings.Label;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class CheckBoxGroupWidget
extends EasyFormComponent<Box> {
    private List<CheckBoxWidget> checkboxes = new ArrayList<CheckBoxWidget>();
    private Label label = new Label();
    private boolean horizontal;

    public CheckBoxGroupWidget(Collection<String> values) {
        this(values, false);
    }

    public CheckBoxGroupWidget(Collection<String> values, boolean horizontal) {
        this.horizontal = horizontal;
        this.createWidget(values);
    }

    public Boolean getHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(Boolean horizontal) {
        this.horizontal = horizontal;
    }

    @Override
    public String getLabel() {
        return (String)this.label.getValue();
    }

    @Override
    public void setLabel(String label) {
        this.label.setValue(label);
    }

    @Override
    public Object getValue() {
        return new ArrayList<String>(this.getValues());
    }

    private Collection<String> getValues() {
        return this.checkboxes.stream().map(EasyFormComponent::getWidget).filter(ValueWidget::getValue).map(ValueWidget::getDescription).collect(Collectors.toList());
    }

    public void setValues(Collection<String> values) {
        values.forEach(item -> {
            CheckBoxWidget checkbox = new CheckBoxWidget((String)item);
            this.checkboxes.add(checkbox);
        });
    }

    private void createWidget(Collection<String> values) {
        this.setValues(values);
        List<Widget> comms = this.checkboxes.stream().map(EasyFormComponent::getWidget).collect(Collectors.toList());
        Box rightSide = this.getHorizontal() != false ? new HBox(comms) : new VBox(comms);
        this.widget = new HBox(Arrays.asList(this.label, rightSide));
    }
}

