/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.evaluator;

import com.google.inject.Provider;
import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.jvm.classloader.BeakerxUrlClassLoader;
import com.twosigma.beakerx.jvm.classloader.DynamicClassLoaderSimple;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.scala.evaluator.BeakerxObjectFactory;
import com.twosigma.beakerx.scala.evaluator.BeakerxObjectFactoryImpl;
import com.twosigma.beakerx.scala.evaluator.ScalaEvaluatorGlue;
import com.twosigma.beakerx.scala.evaluator.ScalaWorkerThread;
import com.twosigma.beakerx.scala.serializers.ScalaCollectionDeserializer;
import com.twosigma.beakerx.scala.serializers.ScalaCollectionSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaListOfPrimitiveTypeMapsSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaMapDeserializer;
import com.twosigma.beakerx.scala.serializers.ScalaMapSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaPrimitiveTypeListOfListSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaPrimitiveTypeMapSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaTableDeSerializer;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaEvaluator
extends BaseEvaluator {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaEvaluator.class.getName());
    private BeakerxObjectFactory beakerxObjectFactory;
    private ScalaWorkerThread workerThread;
    private final Provider<BeakerObjectConverter> objectSerializerProvider;
    private static boolean autoTranslationSetup = false;
    private BeakerxUrlClassLoader classLoader;
    private ScalaEvaluatorGlue shell;
    private ScalaEvaluatorGlue acshell;

    public ScalaEvaluator(String id, String sId, Provider<BeakerObjectConverter> osp, EvaluatorParameters evaluatorParameters) {
        this(id, sId, osp, (CellExecutor)new BeakerCellExecutor("scala"), new BeakerxObjectFactoryImpl(), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters);
    }

    public ScalaEvaluator(String id, String sId, Provider<BeakerObjectConverter> osp, CellExecutor cellExecutor, BeakerxObjectFactory beakerxObjectFactory, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters);
        this.objectSerializerProvider = osp;
        this.beakerxObjectFactory = beakerxObjectFactory;
        this.classLoader = this.newClassLoader();
        this.shell = this.createNewEvaluator();
        this.acshell = this.newAutoCompleteEvaluator();
        this.workerThread = new ScalaWorkerThread(this);
        this.workerThread.start();
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        this.workerThread.add(new JobDescriptor(code, seo));
    }

    protected void addJarToClassLoader(PathToJar pathToJar) {
        this.classLoader.addJar(pathToJar);
    }

    protected void addImportToClassLoader(ImportPath anImport) {
        this.addImportToShell(this.shell, anImport);
    }

    protected void doReloadEvaluator() {
        this.classLoader = this.newClassLoader();
        this.shell = this.createNewEvaluator();
    }

    protected void doResetEnvironment() {
        this.classLoader = this.newClassLoader();
        this.shell = this.createNewEvaluator();
        this.acshell = this.newAutoCompleteEvaluator();
        this.workerThread.halt();
    }

    public void exit() {
        super.exit();
        this.workerThread.doExit();
        this.cancelExecution();
        this.workerThread.halt();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    ScalaEvaluatorGlue getShell() {
        return this.shell;
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        int lineStart = 0;
        String[] sv = code.substring(0, caretPosition).split("\n");
        for (int i = 0; i < sv.length - 1; ++i) {
            this.acshell.evaluate2(sv[i]);
            caretPosition -= sv[i].length() + 1;
            lineStart += sv[i].length() + 1;
        }
        AutocompleteResult lineCompletion = this.acshell.autocomplete(sv[sv.length - 1], caretPosition);
        return new AutocompleteResult(lineCompletion.getMatches(), lineCompletion.getStartIndex() + lineStart);
    }

    private String adjustImport(String imp) {
        if (imp.startsWith("import")) {
            imp = imp.substring(6).trim();
        }
        if (imp.startsWith("static")) {
            imp = imp.substring(6).trim();
        }
        if (imp.contains(".object.")) {
            imp = imp.replace(".object.", ".`object`.");
        }
        if (imp.endsWith(".*")) {
            imp = imp.substring(0, imp.length() - 1) + "_";
        }
        return imp;
    }

    private ScalaEvaluatorGlue newAutoCompleteEvaluator() {
        logger.debug("creating new autocomplete evaluator");
        String acloader_cp = this.createAutoCompleteClassLoader();
        ScalaEvaluatorGlue acshell = new ScalaEvaluatorGlue(this.newAutoCompleteClassLoader(), acloader_cp, this.outDir);
        if (!this.imports.isEmpty()) {
            String[] strings = (String[])this.imports.getImportPaths().stream().map(importPath -> {
                String trim = importPath.asString().trim();
                return this.adjustImport(trim);
            }).toArray(String[]::new);
            acshell.addImports(strings);
        }
        NamespaceClient.getBeaker((String)this.sessionId);
        String r = acshell.evaluate2(this.beakerxObjectFactory.create(this.sessionId));
        if (r != null && !r.isEmpty()) {
            logger.warn("ERROR creating beaker beaker: {}", (Object)r);
        }
        return acshell;
    }

    private ClassLoader newAutoCompleteClassLoader() {
        logger.debug("creating new autocomplete loader");
        DynamicClassLoaderSimple cl = new DynamicClassLoaderSimple(ClassLoader.getSystemClassLoader());
        cl.addJars(this.classPath.getPathsAsStrings());
        cl.addDynamicDir(this.outDir);
        return cl;
    }

    private String createAutoCompleteClassLoader() {
        String acloader_cp = "";
        for (int i = 0; i < this.classPath.size(); ++i) {
            acloader_cp = acloader_cp + this.classPath.get(i);
            acloader_cp = acloader_cp + File.pathSeparatorChar;
        }
        acloader_cp = acloader_cp + this.outDir;
        return acloader_cp + File.pathSeparatorChar + System.getProperty("java.class.path");
    }

    private ScalaEvaluatorGlue createNewEvaluator() {
        logger.debug("creating new evaluator");
        String loader_cp = this.createLoaderCp();
        ScalaEvaluatorGlue shell = new ScalaEvaluatorGlue((ClassLoader)this.classLoader, loader_cp, this.getOutDir());
        if (!this.getImports().isEmpty()) {
            this.addImportsToShell(shell, this.getImports().getImportPaths());
        }
        logger.debug("creating beaker object");
        NamespaceClient.getBeaker((String)this.getSessionId());
        String r = shell.evaluate2(this.beakerxObjectFactory.create(this.getSessionId()));
        if (r != null && !r.isEmpty()) {
            logger.warn("ERROR creating beaker object: {}", (Object)r);
        }
        return shell;
    }

    private void addImportsToShell(ScalaEvaluatorGlue shell, List<ImportPath> importsPaths) {
        if (!importsPaths.isEmpty()) {
            String[] imp = (String[])importsPaths.stream().map(importPath -> this.adjustImport(importPath.asString())).toArray(String[]::new);
            logger.debug("importing : {}", importsPaths);
            if (!shell.addImports(imp)) {
                logger.warn("ERROR: cannot add import '{}'", (Object[])imp);
            }
        }
    }

    private void addImportToShell(ScalaEvaluatorGlue shell, ImportPath importPath) {
        String imp = importPath.asString().trim();
        if (!(imp = this.adjustImport(imp)).isEmpty()) {
            logger.debug("importing : {}", (Object)imp);
            if (!shell.addImport(imp)) {
                logger.warn("ERROR: cannot add import '{}'", (Object)imp);
            }
        }
    }

    private BeakerxUrlClassLoader newClassLoader() {
        logger.debug("creating new loader");
        BeakerxUrlClassLoader cl = new BeakerxUrlClassLoader(ClassLoader.getSystemClassLoader());
        cl.addPathToJars(this.getClasspath().getPaths());
        return cl;
    }

    private String createLoaderCp() {
        String loader_cp = "";
        for (int i = 0; i < this.getClasspath().size(); ++i) {
            loader_cp = loader_cp + this.getClasspath().get(i);
            loader_cp = loader_cp + File.pathSeparatorChar;
        }
        return loader_cp + File.pathSeparatorChar + System.getProperty("java.class.path");
    }

    public void setupAutoTranslation() {
        if (autoTranslationSetup) {
            return;
        }
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaCollectionSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaMapSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaPrimitiveTypeListOfListSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaListOfPrimitiveTypeMapsSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaPrimitiveTypeMapSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeDeserializer((ObjectDeserializer)new ScalaCollectionDeserializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeDeserializer((ObjectDeserializer)new ScalaMapDeserializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeDeserializer((ObjectDeserializer)new ScalaTableDeSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        autoTranslationSetup = true;
    }
}

