/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public class StringFactory {
    private static final Constructor<String> ourConstructor;

    @NotNull
    public static String createShared(@NotNull char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "org/jetbrains/kotlin/com/intellij/util/text/StringFactory", "createShared"));
        }
        if (ourConstructor != null) {
            String string;
            try {
                string = ourConstructor.newInstance(chars, Boolean.TRUE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/StringFactory", "createShared"));
            }
            return string;
        }
        String string = new String(chars);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/StringFactory", "createShared"));
        }
        return string;
    }

    static {
        Constructor constructor;
        try {
            constructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            constructor.setAccessible(true);
        }
        catch (Throwable ignored) {
            constructor = null;
        }
        ourConstructor = constructor;
    }
}

