/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.twosigma.beakerx.jvm.classloader.BeakerxUrlClassLoader;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kotlin.evaluator.KotlinEvaluator;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplClassLoader;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.repl.ConsoleReplConfiguration;
import org.jetbrains.kotlin.cli.jvm.repl.ReplConfiguration;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.utils.PathUtil;

public class ReplWithClassLoaderFactory {
    @NotNull
    public static ReplWithClassLoader createReplWithKotlinParentClassLoader(KotlinEvaluator kotlinEvaluator, BeakerxUrlClassLoader parent) {
        return ReplWithClassLoaderFactory.createReplInterpreter(ReplWithClassLoaderFactory.getClasspath(), (ClassLoader)parent, kotlinEvaluator);
    }

    public static ReplInterpreter createReplWithReplClassLoader(KotlinEvaluator kotlinEvaluator, ReplClassLoader classLoader) {
        CompilerConfiguration compilerConfiguration = ReplWithClassLoaderFactory.getCompilerConfiguration(ReplWithClassLoaderFactory.getClasspath(), kotlinEvaluator);
        ReplInterpreter replInterpreter = new ReplInterpreter(Disposer.newDisposable(), compilerConfiguration, (ReplConfiguration)new ConsoleReplConfiguration());
        ReplWithClassLoaderFactory.setupReplClassLoader(classLoader, replInterpreter);
        replInterpreter.eval(ReplWithClassLoaderFactory.getImportString(kotlinEvaluator.getImports().getImportPaths()));
        return replInterpreter;
    }

    @NotNull
    private static ReplClassLoader setupReplClassLoader(ReplClassLoader classLoader, ReplInterpreter replInterpreter) {
        try {
            Field classLoaderField = replInterpreter.getClass().getDeclaredField("classLoader");
            classLoaderField.setAccessible(true);
            classLoaderField.set(replInterpreter, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return classLoader;
    }

    @NotNull
    private static String[] getClasspath() {
        String classpath = System.getProperty("java.class.path");
        return classpath.split(File.pathSeparator);
    }

    @NotNull
    public static BeakerxUrlClassLoader createParentClassLoader(KotlinEvaluator kotlinEvaluator) {
        List urls = BeakerxUrlClassLoader.createUrls((List)kotlinEvaluator.getClasspath().getPaths());
        BeakerxUrlClassLoader parent = new BeakerxUrlClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
        return parent;
    }

    private static ReplWithClassLoader createReplInterpreter(String[] classpathEntries, ClassLoader parent, KotlinEvaluator kotlinEvaluator) {
        CompilerConfiguration compilerConfiguration = ReplWithClassLoaderFactory.getCompilerConfiguration(classpathEntries, kotlinEvaluator);
        ReplInterpreter replInterpreter = new ReplInterpreter(Disposer.newDisposable(), compilerConfiguration, (ReplConfiguration)new ConsoleReplConfiguration());
        ReplClassLoader loader = ReplWithClassLoaderFactory.getReplClassLoader(parent, replInterpreter);
        replInterpreter.eval(ReplWithClassLoaderFactory.getImportString(kotlinEvaluator.getImports().getImportPaths()));
        return new ReplWithClassLoader(replInterpreter, loader);
    }

    @NotNull
    public static String getImportString(List<ImportPath> importPaths) {
        StringBuilder javaSourceCode = new StringBuilder();
        for (ImportPath i : importPaths) {
            javaSourceCode.append("import ");
            javaSourceCode.append(ReplWithClassLoaderFactory.adjustImport(i));
            javaSourceCode.append("\n");
        }
        return javaSourceCode.toString();
    }

    @NotNull
    private static ReplClassLoader getReplClassLoader(ClassLoader parent, ReplInterpreter replInterpreter) {
        ReplClassLoader classLoader = null;
        try {
            Field classLoaderField = replInterpreter.getClass().getDeclaredField("classLoader");
            classLoaderField.setAccessible(true);
            classLoader = (ReplClassLoader)classLoaderField.get(replInterpreter);
            Field urlClassLoaderField = classLoader.getClass().getSuperclass().getDeclaredField("parent");
            urlClassLoaderField.setAccessible(true);
            Object urlClassLoader = urlClassLoaderField.get(classLoader);
            urlClassLoaderField.set(urlClassLoader, parent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return classLoader;
    }

    @NotNull
    private static CompilerConfiguration getCompilerConfiguration(String[] classpathEntries, KotlinEvaluator kotlinEvaluator) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.put(CommonConfigurationKeys.MODULE_NAME, (Object)("kotlinModule" + System.currentTimeMillis()));
        compilerConfiguration.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, (Object)true);
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)compilerConfiguration, (List)PathUtil.getJdkClassesRootsFromCurrentJre());
        Arrays.stream(classpathEntries).forEach(x -> JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)new File((String)x)));
        kotlinEvaluator.getClasspath().getPathsAsStrings().forEach(x -> JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)new File((String)x)));
        return compilerConfiguration;
    }

    private static String adjustImport(ImportPath importPath) {
        String currentImportPath = importPath.asString();
        if (currentImportPath.startsWith("import")) {
            currentImportPath = currentImportPath.substring(6).trim();
        }
        if (currentImportPath.startsWith("static")) {
            currentImportPath = currentImportPath.substring(6).trim();
        }
        if (currentImportPath.contains(".object.")) {
            currentImportPath = currentImportPath.replace(".object.", ".`object`.");
        }
        return currentImportPath;
    }

    public static class ReplWithClassLoader {
        private ReplClassLoader loader;
        private ReplInterpreter repl;

        public ReplWithClassLoader(ReplInterpreter repl, ReplClassLoader loader) {
            this.loader = loader;
            this.repl = repl;
        }

        public ReplClassLoader getLoader() {
            return this.loader;
        }

        public ReplInterpreter getRepl() {
            return this.repl;
        }
    }
}

