/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.autocomplete.db;

import com.twosigma.beakerx.sql.autocomplete.db.DbCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DbRequestCache
implements DbCache {
    private final ConcurrentHashMap<String, Map<String, Map<String, Map<String, List<String>>>>> fieldsCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Map<String, Map<String, List<String>>>> tablesCache = new ConcurrentHashMap();
    private static final long serialVersionUID = -8164467511255046521L;

    @Override
    public List<String> getTableNames(Connection conn, String schemaName, String key) throws SQLException {
        String uri = conn.getMetaData().getURL();
        Map<String, Map<String, List<String>>> uriCache = this.tablesCache.get(uri);
        if (uriCache == null) {
            return null;
        }
        Map<String, List<String>> schemaCache = uriCache.get(schemaName);
        if (schemaCache == null) {
            return null;
        }
        return schemaCache.get(key);
    }

    @Override
    public void putTableNames(Connection conn, String schemaName, String key, List<String> values) throws SQLException {
        if (values != null) {
            Map<String, List<String>> schemaCache;
            Map<Object, Object> uriCache;
            String uri = conn.getMetaData().getURL();
            if (this.tablesCache.putIfAbsent(uri, uriCache = new ConcurrentHashMap()) != null) {
                uriCache = this.tablesCache.get(uri);
            }
            if (((ConcurrentHashMap)uriCache).putIfAbsent(schemaName, schemaCache = new ConcurrentHashMap<String, List<String>>()) != null) {
                schemaCache = (Map)uriCache.get(schemaName);
            }
            schemaCache.put(key, values);
        }
    }

    @Override
    public List<String> getTableFieldNames(Connection conn, String schemaName, String tableName, String key) throws SQLException {
        String uri = conn.getMetaData().getURL();
        Map<String, Map<String, Map<String, List<String>>>> uriCache = this.fieldsCache.get(uri);
        if (uriCache == null) {
            return null;
        }
        Map<String, Map<String, List<String>>> schemaCache = uriCache.get(schemaName);
        if (schemaCache == null) {
            return null;
        }
        Map<String, List<String>> tablesCache = schemaCache.get(tableName);
        if (tablesCache == null) {
            return null;
        }
        return tablesCache.get(key);
    }

    @Override
    public void putTableFieldNames(Connection conn, String schemaName, String tableName, String key, List<String> values) throws SQLException {
        if (values != null) {
            Map<String, List<String>> tableCache;
            Map<String, ConcurrentHashMap<String, List<String>>> schemaCache;
            Map<Object, Object> uriCache;
            String uri = conn.getMetaData().getURL();
            if (this.fieldsCache.putIfAbsent(uri, uriCache = new ConcurrentHashMap()) != null) {
                uriCache = this.fieldsCache.get(uri);
            }
            if (((ConcurrentHashMap)uriCache).putIfAbsent(schemaName, schemaCache = new ConcurrentHashMap()) != null) {
                schemaCache = (Map)uriCache.get(schemaName);
            }
            if (((ConcurrentHashMap)schemaCache).putIfAbsent(tableName, tableCache = new ConcurrentHashMap<String, List<String>>()) != null) {
                tableCache = (Map)schemaCache.get(tableName);
            }
            tableCache.put(key, values);
        }
    }
}

