"""Unicode Properties from Unicode version 12.1.0 (autogen)."""
from typing import Dict

unicode_indic_syllabic_category: Dict[str, str] = {
    "^avagraha": "\x00-\u093c\u093e-\u09bc\u09be-\u0abc\u0abe-\u0b3c\u0b3e-\u0c3c\u0c3e-\u0cbc\u0cbe-\u0d3c\u0d3e-\u0f84\u0f86-\u17db\u17dd-\u1bb9\u1bbb-\U000111c0\U000111c2-\U0001133c\U0001133e-\U00011446\U00011448-\U000114c3\U000114c5-\U000119e0\U000119e2-\U00011a9c\U00011a9e-\U00011c3f\U00011c41-\U0010ffff",
    "^bindu": "\x00-\u08ff\u0903-\u0980\u0983-\u09fb\u09fd-\u0a00\u0a03-\u0a6f\u0a71-\u0a80\u0a83-\u0b00\u0b03-\u0b81\u0b83-\u0bff\u0c03\u0c05-\u0c7f\u0c83-\u0cff\u0d03-\u0d81\u0d83-\u0e4c\u0e4e-\u0ecc\u0ece-\u0f7d\u0f7f-\u0f81\u0f84-\u1035\u1037-\u17c5\u17c7-\u1931\u1933-\u1a73\u1a75-\u1aff\u1b03-\u1b7f\u1b81-\u1c33\u1c36-\ua80a\ua80c-\ua872\ua874-\ua87f\ua881-\ua8c4\ua8c6-\ua8f1\ua8f4-\ua97f\ua982-\U00010a0d\U00010a0f-\U00010fff\U00011002-\U0001107f\U00011082-\U000110ff\U00011102-\U0001117f\U00011182-\U00011233\U00011235-\U000112de\U000112e0-\U000112ff\U00011303-\U0001135d\U00011360-\U00011442\U00011445-\U0001145e\U00011460-\U000114be\U000114c1-\U000115bb\U000115be-\U0001163c\U0001163e-\U000116aa\U000116ac-\U00011836\U00011838-\U000119dd\U000119df-\U00011a34\U00011a39-\U00011a95\U00011a97-\U00011c3b\U00011c3e-\U00011cb4\U00011cb7-\U00011d3f\U00011d41-\U00011d94\U00011d96-\U0010ffff",
    "^brahmijoiningnumber": "\x00-\U00011051\U00011066-\U0010ffff",
    "^cantillationmark": "\x00-\u0950\u0953-\u0a50\u0a52-\u0af9\u0afd-\u1ccf\u1cd3\u1ce2-\u1cf3\u1cf5-\u1cf6\u1cfa-\u20ef\u20f1-\ua8df\ua8f2-\U0001123d\U0001123f-\U00011365\U0001136d-\U0001136f\U00011375-\U0010ffff",
    "^consonant": "\x00-\u0914\u093a-\u0957\u0960-\u0977\u0980-\u0994\u09a9\u09b1\u09b3-\u09b5\u09ba-\u09db\u09de\u09e0-\u09ef\u09f2-\u0a14\u0a29\u0a31\u0a34\u0a37\u0a3a-\u0a58\u0a5d\u0a5f-\u0a94\u0aa9\u0ab1\u0ab4\u0aba-\u0af8\u0afa-\u0b14\u0b29\u0b31\u0b34\u0b3a-\u0b5b\u0b5e\u0b60-\u0b70\u0b72-\u0b94\u0b96-\u0b98\u0b9b\u0b9d\u0ba0-\u0ba2\u0ba5-\u0ba7\u0bab-\u0bad\u0bba-\u0c14\u0c29\u0c3a-\u0c57\u0c5b-\u0c94\u0ca9\u0cb4\u0cba-\u0cdd\u0cdf-\u0d14\u0d3b-\u0d99\u0db2\u0dbc\u0dbe-\u0dbf\u0dc7-\u0e00\u0e2f-\u0e80\u0e83\u0e85\u0e8b\u0ea4\u0ea6\u0eaf-\u0edb\u0ee0-\u0f3f\u0f48\u0f6d-\u0fff\u1021-\u103e\u1040-\u104f\u1052-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u1702\u170d\u1712-\u1722\u1732-\u1742\u1752-\u1762\u176d\u1771-\u177f\u17a3-\u1900\u191f-\u194f\u1963-\u197f\u19ac-\u19ff\u1a17-\u1a1f\u1a4d-\u1a52\u1a55-\u1b12\u1b34-\u1b44\u1b4c-\u1b89\u1ba1-\u1bad\u1bb0-\u1bba\u1bbe-\u1bbf\u1be4-\u1bff\u1c24-\u1c4c\u1c50-\ua806\ua80b\ua823-\ua83f\ua85e-\ua861\ua866-\ua868\ua871\ua873-\ua891\ua8b4-\ua909\ua922-\ua92f\ua947-\ua988\ua98c-\ua98e\ua9b3-\ua9df\ua9e5-\ua9e6\ua9f0-\ua9f9\ua9ff-\uaa05\uaa29-\uaa5f\uaa70\uaa74-\uaa79\uaa7b-\uaa7d\uaab0-\uaae1\uaaeb-\uabbf\uabce-\uabcf\uabd1\uabdb-\U000109ff\U00010a01-\U00010a0f\U00010a14\U00010a18\U00010a36-\U00011012\U00011038-\U0001108c\U000110b0-\U00011106\U00011127-\U00011143\U00011145-\U00011154\U00011173-\U00011190\U000111b3-\U00011207\U00011212\U0001122c-\U00011283\U00011287\U00011289\U0001128e\U0001129e\U000112a9-\U000112b9\U000112df-\U00011314\U00011329\U00011331\U00011334\U0001133a-\U0001140d\U00011435-\U0001148e\U000114b0-\U0001158d\U000115af-\U0001160d\U00011630-\U00011689\U000116ab-\U000116b7\U000116b9-\U000116ff\U0001171b-\U00011809\U0001182c-\U000119ad\U000119d1-\U00011a0a\U00011a33-\U00011a5b\U00011a84-\U00011c0d\U00011c2f-\U00011c71\U00011c90-\U00011d0b\U00011d31-\U00011d6b\U00011d8a-\U00011edf\U00011ef2-\U0010ffff",
    "^consonantdead": "\x00-\u09cd\u09cf-\u0d53\u0d57-\u0d79\u0d80-\u1cf1\u1cf4-\U0010ffff",
    "^consonantfinal": "\x00-\u192f\u1932\u193a-\u19c0\u19c8-\u1a57\u1a5a-\u1bbd\u1bc0-\u1bef\u1bf2-\u1c2c\u1c34-\ua94e\ua953-\uaa3f\uaa4e-\uabda\uabe3-\U00011a89\U00011a96-\U0010ffff",
    "^consonantheadletter": "\x00-\u0f87\u0f8d-\U0010ffff",
    "^consonantinitialpostfixed": "\x00-\u1a59\u1a5b-\U0010ffff",
    "^consonantkiller": "\x00-\u0e4b\u0e4d-\u17cc\u17ce-\U0010ffff",
    "^consonantmedial": "\x00-\u0a74\u0a76-\u0ebb\u0ebe-\u103a\u103f-\u105d\u1061-\u1081\u1083-\u1a54\u1a57-\ua8b3\ua8b5-\ua9bc\ua9c0-\uaa32\uaa37-\U0001171c\U00011720-\U00011a3a\U00011a3f-\U00011d46\U00011d48-\U0010ffff",
    "^consonantplaceholder": "\x00-\x2c\x2e-\x9f\xa1-\xd6\xd8-\u097f\u0981-\u0a71\u0a74-\u104a\u104c-\u104d\u104f-\u18ff\u1901-\u1cf9\u1cfb-\u200f\u2015-\u25cb\u25cd-\uaa73\uaa77-\U00011a3e\U00011a40-\U00011a44\U00011a46-\U00011ef1\U00011ef3-\U0010ffff",
    "^consonantprecedingrepha": "\x00-\u0d4d\u0d4f-\U00011d45\U00011d47-\U0010ffff",
    "^consonantprefixed": "\x00-\U000111c1\U000111c4-\U00011a39\U00011a3b-\U00011a83\U00011a8a-\U0010ffff",
    "^consonantsubjoined": "\x00-\u0f8c\u0f98\u0fbd-\u1928\u192c-\u1a56\u1a58-\u1a5a\u1a5f-\u1ba0\u1ba4-\u1bab\u1bae-\u1c23\u1c26-\ua866\ua869-\ua870\ua872-\U00011c91\U00011ca8\U00011cb0-\U0010ffff",
    "^consonantsucceedingrepha": "\x00-\u17cb\u17cd-\u1b02\u1b04-\u1b80\u1b82-\ua981\ua983-\U0010ffff",
    "^consonantwithstacker": "\x00-\u0cf0\u0cf3-\u1cf4\u1cf7-\U00011002\U00011005-\U0010ffff",
    "^geminationmark": "\x00-\u0a70\u0a72-\U00011236\U00011238-\U00011a97\U00011a99-\U0010ffff",
    "^invisiblestacker": "\x00-\u1038\u103a-\u17d1\u17d3-\u1a5f\u1a61-\u1baa\u1bac-\uaaf5\uaaf7-\U00010a3e\U00010a40-\U00011132\U00011134-\U00011a46\U00011a48-\U00011a98\U00011a9a-\U00011d44\U00011d46-\U00011d96\U00011d98-\U0010ffff",
    "^joiner": "\x00-\u200c\u200e-\U0010ffff",
    "^modifyingletter": "\x00-\u0b82\u0b84-\U0010ffff",
    "^nonjoiner": "\x00-\u200b\u200d-\U0010ffff",
    "^nukta": "\x00-\u093b\u093d-\u09bb\u09bd-\u0a3b\u0a3d-\u0abb\u0abd-\u0afc\u0b00-\u0b3b\u0b3d-\u0cbb\u0cbd-\u0f38\u0f3a-\u1b33\u1b35-\u1be5\u1be7-\u1c36\u1c38-\ua9b2\ua9b4-\U00010a37\U00010a3b-\U000110b9\U000110bb-\U00011172\U00011174-\U000111c9\U000111cb-\U00011235\U00011237-\U000112e8\U000112ea-\U0001133a\U0001133d-\U00011445\U00011447-\U000114c2\U000114c4-\U000115bf\U000115c1-\U000116b6\U000116b8-\U00011839\U0001183b-\U00011d41\U00011d43-\U0010ffff",
    "^number": "\x00-\x2f\x3a-\u0965\u0970-\u09e5\u09f0-\u0a65\u0a70-\u0ae5\u0af0-\u0b65\u0b70-\u0be5\u0bf0-\u0c65\u0c70-\u0ce5\u0cf0-\u0d65\u0d70-\u0de5\u0df0-\u0e4f\u0e5a-\u0ecf\u0eda-\u0f1f\u0f34-\u103f\u104a-\u108f\u109a-\u17df\u17ea-\u1945\u1950-\u19cf\u19db-\u1a7f\u1a8a-\u1a8f\u1a9a-\u1b4f\u1b5a-\u1baf\u1bba-\u1c3f\u1c4a-\ua8cf\ua8da-\ua8ff\ua90a-\ua9cf\ua9da-\ua9ef\ua9fa-\uaa4f\uaa5a-\uabef\uabfa-\U00010a3f\U00010a49-\U00011065\U00011070-\U00011135\U00011140-\U000111cf\U000111da-\U000111e0\U000111f5-\U000112ef\U000112fa-\U0001144f\U0001145a-\U000114cf\U000114da-\U0001164f\U0001165a-\U000116bf\U000116ca-\U0001172f\U0001173c-\U00011c4f\U00011c6d-\U00011d4f\U00011d5a-\U00011d9f\U00011daa-\U0010ffff",
    "^numberjoiner": "\x00-\U0001107e\U00011080-\U0010ffff",
    "^other": "\x5c\x2d\x30-\x39\xa0\xb2-\xb3\xd7\u0900-\u094f\u0951-\u0952\u0955-\u0963\u0966-\u096f\u0972-\u0983\u0985-\u098c\u098f-\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bc-\u09c4\u09c7-\u09c8\u09cb-\u09ce\u09d7\u09dc-\u09dd\u09df-\u09e3\u09e6-\u09f1\u09fc\u09fe\u0a01-\u0a03\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a3c\u0a3e-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a51\u0a59-\u0a5c\u0a5e\u0a66-\u0a73\u0a75\u0a81-\u0a83\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0abc-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae0-\u0ae3\u0ae6-\u0aef\u0af9-\u0aff\u0b01-\u0b03\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b35-\u0b39\u0b3c-\u0b44\u0b47-\u0b48\u0b4b-\u0b4d\u0b56-\u0b57\u0b5c-\u0b5d\u0b5f-\u0b63\u0b66-\u0b6f\u0b71\u0b82-\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99-\u0b9a\u0b9c\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c58-\u0c5a\u0c60-\u0c63\u0c66-\u0c6f\u0c80-\u0c83\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbc-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5-\u0cd6\u0cde\u0ce0-\u0ce3\u0ce6-\u0cef\u0cf1-\u0cf2\u0d00-\u0d03\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d44\u0d46-\u0d48\u0d4a-\u0d4e\u0d54-\u0d57\u0d5f-\u0d63\u0d66-\u0d6f\u0d7a-\u0d7f\u0d82-\u0d83\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2-\u0df3\u0e01-\u0e2e\u0e30-\u0e3a\u0e40-\u0e45\u0e47-\u0e4e\u0e50-\u0e59\u0e81-\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eae\u0eb0-\u0ebd\u0ec0-\u0ec4\u0ec8-\u0ecb\u0ecd\u0ed0-\u0ed9\u0edc-\u0edf\u0f20-\u0f33\u0f35\u0f37\u0f39\u0f40-\u0f47\u0f49-\u0f6c\u0f71-\u0f85\u0f88-\u0f97\u0f99-\u0fbc\u0fc6\u1000-\u1049\u104b\u104e\u1050-\u109d\u1700-\u170c\u170e-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176c\u176e-\u1770\u1772-\u1773\u1780-\u17b3\u17b6-\u17d3\u17dc-\u17dd\u17e0-\u17e9\u1900-\u191e\u1920-\u192b\u1930-\u193b\u1946-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u19d0-\u19da\u1a00-\u1a1b\u1a20-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1b00-\u1b4b\u1b50-\u1b59\u1b80-\u1bf3\u1c00-\u1c37\u1c40-\u1c49\u1c4d-\u1c4f\u1cd0-\u1cd2\u1cd4-\u1ce1\u1cf2-\u1cfa\u1dfb\u200c-\u200d\u2010-\u2014\u2074\u2082-\u2084\u20f0\u25cc\ua800-\ua827\ua840-\ua873\ua880-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f3\ua8fe-\ua92d\ua930-\ua953\ua980-\ua9c0\ua9d0-\ua9d9\ua9e0-\ua9e5\ua9e7-\ua9fe\uaa00-\uaa36\uaa40-\uaa4d\uaa50-\uaa59\uaa60-\uaa6f\uaa71-\uaa76\uaa7a-\uaac2\uaae0-\uaaef\uaaf5-\uaaf6\uabc0-\uabea\uabec-\uabed\uabf0-\uabf9\U00010a00-\U00010a03\U00010a05-\U00010a06\U00010a0c-\U00010a13\U00010a15-\U00010a17\U00010a19-\U00010a35\U00010a38-\U00010a3a\U00010a3f-\U00010a48\U00011000-\U00011046\U00011052-\U0001106f\U0001107f-\U000110ba\U00011100-\U00011134\U00011136-\U0001113f\U00011144-\U00011146\U00011150-\U00011173\U00011180-\U000111c3\U000111c9-\U000111cc\U000111d0-\U000111d9\U000111e1-\U000111f4\U00011200-\U00011211\U00011213-\U00011237\U0001123e\U00011280-\U00011286\U00011288\U0001128a-\U0001128d\U0001128f-\U0001129d\U0001129f-\U000112a8\U000112b0-\U000112ea\U000112f0-\U000112f9\U00011300-\U00011303\U00011305-\U0001130c\U0001130f-\U00011310\U00011313-\U00011328\U0001132a-\U00011330\U00011332-\U00011333\U00011335-\U00011339\U0001133b-\U00011344\U00011347-\U00011348\U0001134b-\U0001134d\U00011357\U0001135e-\U00011363\U00011366-\U0001136c\U00011370-\U00011374\U00011400-\U00011447\U00011450-\U00011459\U0001145e-\U0001145f\U00011481-\U000114c4\U000114d0-\U000114d9\U00011580-\U000115b5\U000115b8-\U000115c0\U000115d8-\U000115dd\U00011600-\U00011640\U00011650-\U00011659\U00011680-\U000116b8\U000116c0-\U000116c9\U00011700-\U0001171a\U0001171d-\U0001172b\U00011730-\U0001173b\U00011800-\U0001183a\U000119a0-\U000119a7\U000119aa-\U000119d7\U000119da-\U000119e1\U000119e4\U00011a00-\U00011a3f\U00011a45\U00011a47\U00011a50-\U00011a99\U00011a9d\U00011c00-\U00011c08\U00011c0a-\U00011c36\U00011c38-\U00011c40\U00011c50-\U00011c6c\U00011c72-\U00011c8f\U00011c92-\U00011ca7\U00011ca9-\U00011cb6\U00011d00-\U00011d06\U00011d08-\U00011d09\U00011d0b-\U00011d36\U00011d3a\U00011d3c-\U00011d3d\U00011d3f-\U00011d47\U00011d50-\U00011d59\U00011d60-\U00011d65\U00011d67-\U00011d68\U00011d6a-\U00011d8e\U00011d90-\U00011d91\U00011d93-\U00011d97\U00011da0-\U00011da9\U00011ee0-\U00011ef6",
    "^purekiller": "\x00-\u0d3a\u0d3d-\u0e39\u0e3b-\u0e4d\u0e4f-\u0eb9\u0ebb-\u0f83\u0f85-\u1039\u103b-\u1713\u1715-\u1733\u1735-\u17d0\u17d2-\u1a79\u1a7b-\u1ba9\u1bab-\u1bf1\u1bf4-\ua952\ua954-\uabec\uabee-\U00011133\U00011135-\U000112e9\U000112eb-\U0001172a\U0001172c-\U00011a33\U00011a35-\U00011d43\U00011d45-\U0010ffff",
    "^registershifter": "\x00-\u17c8\u17cb-\U0010ffff",
    "^syllablemodifier": "\x00-\xb1\xb4-\u09fd\u09ff-\u0f34\u0f36\u0f38-\u0fc5\u0fc7-\u17ca\u17cc-\u17cd\u17d1-\u17d2\u17d4-\u17dc\u17de-\u193a\u193c-\u1a7a\u1a7d-\u1a7e\u1a80-\u1c35\u1c37-\u1dfa\u1dfc-\u2073\u2075-\u2081\u2085-\U000111c8\U000111ca-\U0001145d\U0001145f-\U00011a32\U00011a34-\U0010ffff",
    "^toneletter": "\x00-\u196f\u1975-\uaabf\uaac1\uaac3-\U0010ffff",
    "^tonemark": "\x00-\u0e47\u0e4c-\u0ec7\u0ecc-\u1036\u1038-\u1062\u1065-\u1068\u106e-\u1086\u108e\u1090-\u1099\u109c-\u19c7\u19ca-\u1a74\u1a7a-\ua92a\ua92e-\uaa7a\uaa7e-\uaabe\uaac0\uaac2-\uabeb\uabed-\U0010ffff",
    "^virama": "\x00-\u094c\u094e-\u09cc\u09ce-\u0a4c\u0a4e-\u0acc\u0ace-\u0b4c\u0b4e-\u0bcc\u0bce-\u0c4c\u0c4e-\u0ccc\u0cce-\u0d4c\u0d4e-\u0dc9\u0dcb-\u1b43\u1b45-\ua805\ua807-\ua8c3\ua8c5-\ua9bf\ua9c1-\U00011045\U00011047-\U000110b8\U000110ba-\U000111bf\U000111c1-\U00011234\U00011236-\U0001134c\U0001134e-\U00011441\U00011443-\U000114c1\U000114c3-\U000115be\U000115c0-\U0001163e\U00011640-\U000116b5\U000116b7-\U00011838\U0001183a-\U000119df\U000119e1-\U00011c3e\U00011c40-\U0010ffff",
    "^visarga": "\x00-\u0902\u0904-\u0982\u0984-\u0a02\u0a04-\u0a82\u0a84-\u0b02\u0b04-\u0c02\u0c04-\u0c82\u0c84-\u0d02\u0d04-\u0d82\u0d84-\u0f7e\u0f80-\u1037\u1039-\u17c6\u17c8-\u1b03\u1b05-\u1b81\u1b83-\ua880\ua882-\ua982\ua984-\uaaf4\uaaf6-\U00010a0e\U00010a10-\U00011001\U00011003-\U00011081\U00011083-\U00011101\U00011103-\U00011181\U00011183-\U00011302\U00011304-\U00011444\U00011446-\U000114c0\U000114c2-\U000115bd\U000115bf-\U0001163d\U0001163f-\U000116ab\U000116ad-\U00011837\U00011839-\U000119de\U000119e0-\U00011a38\U00011a3a-\U00011a96\U00011a98-\U00011c3d\U00011c3f-\U00011d40\U00011d42-\U00011d95\U00011d97-\U0010ffff",
    "^vowel": "\x00-\u1962\u196e-\ua85d\ua862-\ua865\ua867-\ua921\ua92b-\U0001114f\U00011155-\U0010ffff",
    "^voweldependent": "\x00-\u0939\u093c-\u093d\u094d\u0950-\u0954\u0958-\u0961\u0964-\u09bd\u09c5-\u09c6\u09c9-\u09ca\u09cd-\u09d6\u09d8-\u09e1\u09e4-\u0a3d\u0a43-\u0a46\u0a49-\u0a4a\u0a4d-\u0abd\u0ac6\u0aca\u0acd-\u0ae1\u0ae4-\u0b3d\u0b45-\u0b46\u0b49-\u0b4a\u0b4d-\u0b55\u0b58-\u0b61\u0b64-\u0bbd\u0bc3-\u0bc5\u0bc9\u0bcd-\u0bd6\u0bd8-\u0c3d\u0c45\u0c49\u0c4d-\u0c54\u0c57-\u0c61\u0c64-\u0cbd\u0cc5\u0cc9\u0ccd-\u0cd4\u0cd7-\u0ce1\u0ce4-\u0d3d\u0d45\u0d49\u0d4d-\u0d56\u0d58-\u0d61\u0d64-\u0dce\u0dd5\u0dd7\u0de0-\u0df1\u0df4-\u0e2f\u0e3a-\u0e3f\u0e46\u0e48-\u0eaf\u0eba\u0ebc-\u0ebf\u0ec5-\u0f70\u0f7e-\u0f7f\u0f82-\u102a\u1036-\u1055\u105a-\u1061\u1063-\u1066\u1069-\u1070\u1075-\u1082\u1087-\u109b\u109e-\u1711\u1714-\u1731\u1734-\u1751\u1754-\u1771\u1774-\u17b5\u17c6-\u17c7\u17c9-\u191f\u1929-\u1939\u193b-\u19af\u19c1-\u1a16\u1a1c-\u1a60\u1a74-\u1b34\u1b44-\u1ba3\u1baa-\u1be6\u1bf0-\u1c25\u1c2d-\ua801\ua803-\ua822\ua828-\ua8b4\ua8c4-\ua8fe\ua900-\ua946\ua94f-\ua9b3\ua9bd-\ua9e4\ua9e6-\uaa28\uaa33-\uaaaf\uaabf-\uaaea\uaaf0-\uabe2\uabeb-\U00010a00\U00010a04\U00010a07-\U00010a0b\U00010a0e-\U00011037\U00011046-\U000110af\U000110b9-\U00011126\U00011133-\U00011144\U00011147-\U000111b2\U000111c0-\U000111ca\U000111cd-\U0001122b\U00011234-\U000112df\U000112e9-\U0001133d\U00011345-\U00011346\U00011349-\U0001134a\U0001134d-\U00011356\U00011358-\U00011361\U00011364-\U00011434\U00011442-\U000114af\U000114bf-\U000115ae\U000115b6-\U000115b7\U000115bc-\U000115db\U000115de-\U0001162f\U0001163d-\U0001163f\U00011641-\U000116ac\U000116b6-\U0001171f\U0001172b-\U0001182b\U00011837-\U000119d0\U000119d8-\U000119d9\U000119de-\U000119e3\U000119e5-\U00011a00\U00011a0b-\U00011a50\U00011a5c-\U00011c2e\U00011c37\U00011c3c-\U00011caf\U00011cb5-\U00011d30\U00011d37-\U00011d39\U00011d3b\U00011d3e\U00011d40-\U00011d42\U00011d44-\U00011d89\U00011d8f\U00011d92\U00011d95-\U00011ef2\U00011ef7-\U0010ffff",
    "^vowelindependent": "\x00-\u0903\u0915-\u095f\u0962-\u0971\u0978-\u0984\u098d-\u098e\u0991-\u0992\u0995-\u09df\u09e2-\u0a04\u0a0b-\u0a0e\u0a11-\u0a12\u0a15-\u0a84\u0a8e\u0a92\u0a95-\u0adf\u0ae2-\u0b04\u0b0d-\u0b0e\u0b11-\u0b12\u0b15-\u0b5f\u0b62-\u0b84\u0b8b-\u0b8d\u0b91\u0b95-\u0c04\u0c0d\u0c11\u0c15-\u0c5f\u0c62-\u0c84\u0c8d\u0c91\u0c95-\u0cdf\u0ce2-\u0d04\u0d0d\u0d11\u0d15-\u0d5e\u0d62-\u0d84\u0d97-\u1020\u102b-\u1051\u1056-\u16ff\u1703-\u171f\u1723-\u173f\u1743-\u175f\u1763-\u17a2\u17b4-\u1a4c\u1a53-\u1b04\u1b13-\u1b82\u1b8a-\u1be3\u1be6-\ua7ff\ua802\ua806-\ua881\ua892-\ua8fd\ua8ff-\ua983\ua989-\ua98b\ua98f-\ua9ff\uaa06-\uaadf\uaae2-\uabcd\uabd0\uabd2-\U00011004\U00011013-\U00011082\U0001108d-\U00011102\U00011107-\U00011182\U00011191-\U000111ff\U00011208-\U0001127f\U00011284-\U000112af\U000112ba-\U00011304\U0001130d-\U0001130e\U00011311-\U00011312\U00011315-\U0001135f\U00011362-\U000113ff\U0001140e-\U00011480\U0001148f-\U0001157f\U0001158e-\U000115d7\U000115dc-\U000115ff\U0001160e-\U0001167f\U0001168a-\U000117ff\U0001180a-\U0001199f\U000119a8-\U000119a9\U000119ae-\U000119ff\U00011a01-\U00011a4f\U00011a51-\U00011bff\U00011c09\U00011c0e-\U00011cff\U00011d07\U00011d0a\U00011d0c-\U00011d5f\U00011d66\U00011d69\U00011d6c-\U0010ffff",
    "avagraha": "\u093d\u09bd\u0abd\u0b3d\u0c3d\u0cbd\u0d3d\u0f85\u17dc\u1bba\U000111c1\U0001133d\U00011447\U000114c4\U000119e1\U00011a9d\U00011c40",
    "bindu": "\u0900-\u0902\u0981-\u0982\u09fc\u0a01-\u0a02\u0a70\u0a81-\u0a82\u0b01-\u0b02\u0b82\u0c00-\u0c02\u0c04\u0c80-\u0c82\u0d00-\u0d02\u0d82\u0e4d\u0ecd\u0f7e\u0f82-\u0f83\u1036\u17c6\u1932\u1a74\u1b00-\u1b02\u1b80\u1c34-\u1c35\ua80b\ua873\ua880\ua8c5\ua8f2-\ua8f3\ua980-\ua981\U00010a0e\U00011000-\U00011001\U00011080-\U00011081\U00011100-\U00011101\U00011180-\U00011181\U00011234\U000112df\U00011300-\U00011302\U0001135e-\U0001135f\U00011443-\U00011444\U0001145f\U000114bf-\U000114c0\U000115bc-\U000115bd\U0001163d\U000116ab\U00011837\U000119de\U00011a35-\U00011a38\U00011a96\U00011c3c-\U00011c3d\U00011cb5-\U00011cb6\U00011d40\U00011d95",
    "brahmijoiningnumber": "\U00011052-\U00011065",
    "cantillationmark": "\u0951-\u0952\u0a51\u0afa-\u0afc\u1cd0-\u1cd2\u1cd4-\u1ce1\u1cf4\u1cf7-\u1cf9\u20f0\ua8e0-\ua8f1\U0001123e\U00011366-\U0001136c\U00011370-\U00011374",
    "consonant": "\u0915-\u0939\u0958-\u095f\u0978-\u097f\u0995-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09dc-\u09dd\u09df\u09f0-\u09f1\u0a15-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a59-\u0a5c\u0a5e\u0a95-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0af9\u0b15-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b35-\u0b39\u0b5c-\u0b5d\u0b5f\u0b71\u0b95\u0b99-\u0b9a\u0b9c\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0c15-\u0c28\u0c2a-\u0c39\u0c58-\u0c5a\u0c95-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cde\u0d15-\u0d3a\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e2e\u0e81-\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eae\u0edc-\u0edf\u0f40-\u0f47\u0f49-\u0f6c\u1000-\u1020\u103f\u1050-\u1051\u105a-\u105d\u1061\u1065-\u1066\u106e-\u1070\u1075-\u1081\u108e\u1703-\u170c\u170e-\u1711\u1723-\u1731\u1743-\u1751\u1763-\u176c\u176e-\u1770\u1780-\u17a2\u1901-\u191e\u1950-\u1962\u1980-\u19ab\u1a00-\u1a16\u1a20-\u1a4c\u1a53-\u1a54\u1b13-\u1b33\u1b45-\u1b4b\u1b8a-\u1ba0\u1bae-\u1baf\u1bbb-\u1bbd\u1bc0-\u1be3\u1c00-\u1c23\u1c4d-\u1c4f\ua807-\ua80a\ua80c-\ua822\ua840-\ua85d\ua862-\ua865\ua869-\ua870\ua872\ua892-\ua8b3\ua90a-\ua921\ua930-\ua946\ua989-\ua98b\ua98f-\ua9b2\ua9e0-\ua9e4\ua9e7-\ua9ef\ua9fa-\ua9fe\uaa06-\uaa28\uaa60-\uaa6f\uaa71-\uaa73\uaa7a\uaa7e-\uaaaf\uaae2-\uaaea\uabc0-\uabcd\uabd0\uabd2-\uabda\U00010a00\U00010a10-\U00010a13\U00010a15-\U00010a17\U00010a19-\U00010a35\U00011013-\U00011037\U0001108d-\U000110af\U00011107-\U00011126\U00011144\U00011155-\U00011172\U00011191-\U000111b2\U00011208-\U00011211\U00011213-\U0001122b\U00011284-\U00011286\U00011288\U0001128a-\U0001128d\U0001128f-\U0001129d\U0001129f-\U000112a8\U000112ba-\U000112de\U00011315-\U00011328\U0001132a-\U00011330\U00011332-\U00011333\U00011335-\U00011339\U0001140e-\U00011434\U0001148f-\U000114af\U0001158e-\U000115ae\U0001160e-\U0001162f\U0001168a-\U000116aa\U000116b8\U00011700-\U0001171a\U0001180a-\U0001182b\U000119ae-\U000119d0\U00011a0b-\U00011a32\U00011a5c-\U00011a83\U00011c0e-\U00011c2e\U00011c72-\U00011c8f\U00011d0c-\U00011d30\U00011d6c-\U00011d89\U00011ee0-\U00011ef1",
    "consonantdead": "\u09ce\u0d54-\u0d56\u0d7a-\u0d7f\u1cf2-\u1cf3",
    "consonantfinal": "\u1930-\u1931\u1933-\u1939\u19c1-\u19c7\u1a58-\u1a59\u1bbe-\u1bbf\u1bf0-\u1bf1\u1c2d-\u1c33\ua94f-\ua952\uaa40-\uaa4d\uabdb-\uabe2\U00011a8a-\U00011a95",
    "consonantheadletter": "\u0f88-\u0f8c",
    "consonantinitialpostfixed": "\u1a5a",
    "consonantkiller": "\u0e4c\u17cd",
    "consonantmedial": "\u0a75\u0ebc-\u0ebd\u103b-\u103e\u105e-\u1060\u1082\u1a55-\u1a56\ua8b4\ua9bd-\ua9bf\uaa33-\uaa36\U0001171d-\U0001171f\U00011a3b-\U00011a3e\U00011d47",
    "consonantplaceholder": "\x5c\x2d\xa0\xd7\u0980\u0a72-\u0a73\u104b\u104e\u1900\u1cfa\u2010-\u2014\u25cc\uaa74-\uaa76\U00011a3f\U00011a45\U00011ef2",
    "consonantprecedingrepha": "\u0d4e\U00011d46",
    "consonantprefixed": "\U000111c2-\U000111c3\U00011a3a\U00011a84-\U00011a89",
    "consonantsubjoined": "\u0f8d-\u0f97\u0f99-\u0fbc\u1929-\u192b\u1a57\u1a5b-\u1a5e\u1ba1-\u1ba3\u1bac-\u1bad\u1c24-\u1c25\ua867-\ua868\ua871\U00011c92-\U00011ca7\U00011ca9-\U00011caf",
    "consonantsucceedingrepha": "\u17cc\u1b03\u1b81\ua982",
    "consonantwithstacker": "\u0cf1-\u0cf2\u1cf5-\u1cf6\U00011003-\U00011004",
    "geminationmark": "\u0a71\U00011237\U00011a98",
    "invisiblestacker": "\u1039\u17d2\u1a60\u1bab\uaaf6\U00010a3f\U00011133\U00011a47\U00011a99\U00011d45\U00011d97",
    "joiner": "\u200d",
    "modifyingletter": "\u0b83",
    "nonjoiner": "\u200c",
    "nukta": "\u093c\u09bc\u0a3c\u0abc\u0afd-\u0aff\u0b3c\u0cbc\u0f39\u1b34\u1be6\u1c37\ua9b3\U00010a38-\U00010a3a\U000110ba\U00011173\U000111ca\U00011236\U000112e9\U0001133b-\U0001133c\U00011446\U000114c3\U000115c0\U000116b7\U0001183a\U00011d42",
    "number": "\x30-\x39\u0966-\u096f\u09e6-\u09ef\u0a66-\u0a6f\u0ae6-\u0aef\u0b66-\u0b6f\u0be6-\u0bef\u0c66-\u0c6f\u0ce6-\u0cef\u0d66-\u0d6f\u0de6-\u0def\u0e50-\u0e59\u0ed0-\u0ed9\u0f20-\u0f33\u1040-\u1049\u1090-\u1099\u17e0-\u17e9\u1946-\u194f\u19d0-\u19da\u1a80-\u1a89\u1a90-\u1a99\u1b50-\u1b59\u1bb0-\u1bb9\u1c40-\u1c49\ua8d0-\ua8d9\ua900-\ua909\ua9d0-\ua9d9\ua9f0-\ua9f9\uaa50-\uaa59\uabf0-\uabf9\U00010a40-\U00010a48\U00011066-\U0001106f\U00011136-\U0001113f\U000111d0-\U000111d9\U000111e1-\U000111f4\U000112f0-\U000112f9\U00011450-\U00011459\U000114d0-\U000114d9\U00011650-\U00011659\U000116c0-\U000116c9\U00011730-\U0001173b\U00011c50-\U00011c6c\U00011d50-\U00011d59\U00011da0-\U00011da9",
    "numberjoiner": "\U0001107f",
    "other": "\x00-\x2c\x2e-\x2f\x3a-\x9f\xa1-\xb1\xb4-\xd6\xd8-\u08ff\u0950\u0953-\u0954\u0964-\u0965\u0970-\u0971\u0984\u098d-\u098e\u0991-\u0992\u09a9\u09b1\u09b3-\u09b5\u09ba-\u09bb\u09c5-\u09c6\u09c9-\u09ca\u09cf-\u09d6\u09d8-\u09db\u09de\u09e4-\u09e5\u09f2-\u09fb\u09fd\u09ff-\u0a00\u0a04\u0a0b-\u0a0e\u0a11-\u0a12\u0a29\u0a31\u0a34\u0a37\u0a3a-\u0a3b\u0a3d\u0a43-\u0a46\u0a49-\u0a4a\u0a4e-\u0a50\u0a52-\u0a58\u0a5d\u0a5f-\u0a65\u0a74\u0a76-\u0a80\u0a84\u0a8e\u0a92\u0aa9\u0ab1\u0ab4\u0aba-\u0abb\u0ac6\u0aca\u0ace-\u0adf\u0ae4-\u0ae5\u0af0-\u0af8\u0b00\u0b04\u0b0d-\u0b0e\u0b11-\u0b12\u0b29\u0b31\u0b34\u0b3a-\u0b3b\u0b45-\u0b46\u0b49-\u0b4a\u0b4e-\u0b55\u0b58-\u0b5b\u0b5e\u0b64-\u0b65\u0b70\u0b72-\u0b81\u0b84\u0b8b-\u0b8d\u0b91\u0b96-\u0b98\u0b9b\u0b9d\u0ba0-\u0ba2\u0ba5-\u0ba7\u0bab-\u0bad\u0bba-\u0bbd\u0bc3-\u0bc5\u0bc9\u0bce-\u0bd6\u0bd8-\u0be5\u0bf0-\u0bff\u0c0d\u0c11\u0c29\u0c3a-\u0c3c\u0c45\u0c49\u0c4e-\u0c54\u0c57\u0c5b-\u0c5f\u0c64-\u0c65\u0c70-\u0c7f\u0c84\u0c8d\u0c91\u0ca9\u0cb4\u0cba-\u0cbb\u0cc5\u0cc9\u0cce-\u0cd4\u0cd7-\u0cdd\u0cdf\u0ce4-\u0ce5\u0cf0\u0cf3-\u0cff\u0d04\u0d0d\u0d11\u0d45\u0d49\u0d4f-\u0d53\u0d58-\u0d5e\u0d64-\u0d65\u0d70-\u0d79\u0d80-\u0d81\u0d84\u0d97-\u0d99\u0db2\u0dbc\u0dbe-\u0dbf\u0dc7-\u0dc9\u0dcb-\u0dce\u0dd5\u0dd7\u0de0-\u0de5\u0df0-\u0df1\u0df4-\u0e00\u0e2f\u0e3b-\u0e3f\u0e46\u0e4f\u0e5a-\u0e80\u0e83\u0e85\u0e8b\u0ea4\u0ea6\u0eaf\u0ebe-\u0ebf\u0ec5-\u0ec7\u0ecc\u0ece-\u0ecf\u0eda-\u0edb\u0ee0-\u0f1f\u0f34\u0f36\u0f38\u0f3a-\u0f3f\u0f48\u0f6d-\u0f70\u0f86-\u0f87\u0f98\u0fbd-\u0fc5\u0fc7-\u0fff\u104a\u104c-\u104d\u104f\u109e-\u16ff\u170d\u1715-\u171f\u1735-\u173f\u1754-\u175f\u176d\u1771\u1774-\u177f\u17b4-\u17b5\u17d4-\u17db\u17de-\u17df\u17ea-\u18ff\u191f\u192c-\u192f\u193c-\u1945\u196e-\u196f\u1975-\u197f\u19ac-\u19af\u19ca-\u19cf\u19db-\u19ff\u1a1c-\u1a1f\u1a5f\u1a7d-\u1a7e\u1a8a-\u1a8f\u1a9a-\u1aff\u1b4c-\u1b4f\u1b5a-\u1b7f\u1bf4-\u1bff\u1c38-\u1c3f\u1c4a-\u1c4c\u1c50-\u1ccf\u1cd3\u1ce2-\u1cf1\u1cfb-\u1dfa\u1dfc-\u200b\u200e-\u200f\u2015-\u2073\u2075-\u2081\u2085-\u20ef\u20f1-\u25cb\u25cd-\ua7ff\ua828-\ua83f\ua874-\ua87f\ua8c6-\ua8cf\ua8da-\ua8df\ua8f4-\ua8fd\ua92e-\ua92f\ua954-\ua97f\ua9c1-\ua9cf\ua9da-\ua9df\ua9e6\ua9ff\uaa37-\uaa3f\uaa4e-\uaa4f\uaa5a-\uaa5f\uaa70\uaa77-\uaa79\uaac3-\uaadf\uaaf0-\uaaf4\uaaf7-\uabbf\uabeb\uabee-\uabef\uabfa-\U000109ff\U00010a04\U00010a07-\U00010a0b\U00010a14\U00010a18\U00010a36-\U00010a37\U00010a3b-\U00010a3e\U00010a49-\U00010fff\U00011047-\U00011051\U00011070-\U0001107e\U000110bb-\U000110ff\U00011135\U00011140-\U00011143\U00011147-\U0001114f\U00011174-\U0001117f\U000111c4-\U000111c8\U000111cd-\U000111cf\U000111da-\U000111e0\U000111f5-\U000111ff\U00011212\U00011238-\U0001123d\U0001123f-\U0001127f\U00011287\U00011289\U0001128e\U0001129e\U000112a9-\U000112af\U000112eb-\U000112ef\U000112fa-\U000112ff\U00011304\U0001130d-\U0001130e\U00011311-\U00011312\U00011329\U00011331\U00011334\U0001133a\U00011345-\U00011346\U00011349-\U0001134a\U0001134e-\U00011356\U00011358-\U0001135d\U00011364-\U00011365\U0001136d-\U0001136f\U00011375-\U000113ff\U00011448-\U0001144f\U0001145a-\U0001145d\U00011460-\U00011480\U000114c5-\U000114cf\U000114da-\U0001157f\U000115b6-\U000115b7\U000115c1-\U000115d7\U000115de-\U000115ff\U00011641-\U0001164f\U0001165a-\U0001167f\U000116b9-\U000116bf\U000116ca-\U000116ff\U0001171b-\U0001171c\U0001172c-\U0001172f\U0001173c-\U000117ff\U0001183b-\U0001199f\U000119a8-\U000119a9\U000119d8-\U000119d9\U000119e2-\U000119e3\U000119e5-\U000119ff\U00011a40-\U00011a44\U00011a46\U00011a48-\U00011a4f\U00011a9a-\U00011a9c\U00011a9e-\U00011bff\U00011c09\U00011c37\U00011c41-\U00011c4f\U00011c6d-\U00011c71\U00011c90-\U00011c91\U00011ca8\U00011cb7-\U00011cff\U00011d07\U00011d0a\U00011d37-\U00011d39\U00011d3b\U00011d3e\U00011d48-\U00011d4f\U00011d5a-\U00011d5f\U00011d66\U00011d69\U00011d8f\U00011d92\U00011d98-\U00011d9f\U00011daa-\U00011edf\U00011ef7-\U0010ffff",
    "purekiller": "\u0d3b-\u0d3c\u0e3a\u0e4e\u0eba\u0f84\u103a\u1714\u1734\u17d1\u1a7a\u1baa\u1bf2-\u1bf3\ua953\uabed\U00011134\U000112ea\U0001172b\U00011a34\U00011d44",
    "registershifter": "\u17c9-\u17ca",
    "syllablemodifier": "\xb2-\xb3\u09fe\u0f35\u0f37\u0fc6\u17cb\u17ce-\u17d0\u17d3\u17dd\u193b\u1a7b-\u1a7c\u1a7f\u1c36\u1dfb\u2074\u2082-\u2084\U000111c9\U0001145e\U00011a33",
    "toneletter": "\u1970-\u1974\uaac0\uaac2",
    "tonemark": "\u0e48-\u0e4b\u0ec8-\u0ecb\u1037\u1063-\u1064\u1069-\u106d\u1087-\u108d\u108f\u109a-\u109b\u19c8-\u19c9\u1a75-\u1a79\ua92b-\ua92d\uaa7b-\uaa7d\uaabf\uaac1\uabec",
    "virama": "\u094d\u09cd\u0a4d\u0acd\u0b4d\u0bcd\u0c4d\u0ccd\u0d4d\u0dca\u1b44\ua806\ua8c4\ua9c0\U00011046\U000110b9\U000111c0\U00011235\U0001134d\U00011442\U000114c2\U000115bf\U0001163f\U000116b6\U00011839\U000119e0\U00011c3f",
    "visarga": "\u0903\u0983\u0a03\u0a83\u0b03\u0c03\u0c83\u0d03\u0d83\u0f7f\u1038\u17c7\u1b04\u1b82\ua881\ua983\uaaf5\U00010a0f\U00011002\U00011082\U00011102\U00011182\U00011303\U00011445\U000114c1\U000115be\U0001163e\U000116ac\U00011838\U000119df\U00011a39\U00011a97\U00011c3e\U00011d41\U00011d96",
    "vowel": "\u1963-\u196d\ua85e-\ua861\ua866\ua922-\ua92a\U00011150-\U00011154",
    "voweldependent": "\u093a-\u093b\u093e-\u094c\u094e-\u094f\u0955-\u0957\u0962-\u0963\u09be-\u09c4\u09c7-\u09c8\u09cb-\u09cc\u09d7\u09e2-\u09e3\u0a3e-\u0a42\u0a47-\u0a48\u0a4b-\u0a4c\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acc\u0ae2-\u0ae3\u0b3e-\u0b44\u0b47-\u0b48\u0b4b-\u0b4c\u0b56-\u0b57\u0b62-\u0b63\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcc\u0bd7\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4c\u0c55-\u0c56\u0c62-\u0c63\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccc\u0cd5-\u0cd6\u0ce2-\u0ce3\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4c\u0d57\u0d62-\u0d63\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0df2-\u0df3\u0e30-\u0e39\u0e40-\u0e45\u0e47\u0eb0-\u0eb9\u0ebb\u0ec0-\u0ec4\u0f71-\u0f7d\u0f80-\u0f81\u102b-\u1035\u1056-\u1059\u1062\u1067-\u1068\u1071-\u1074\u1083-\u1086\u109c-\u109d\u1712-\u1713\u1732-\u1733\u1752-\u1753\u1772-\u1773\u17b6-\u17c5\u17c8\u1920-\u1928\u193a\u19b0-\u19c0\u1a17-\u1a1b\u1a61-\u1a73\u1b35-\u1b43\u1ba4-\u1ba9\u1be7-\u1bef\u1c26-\u1c2c\ua802\ua823-\ua827\ua8b5-\ua8c3\ua8ff\ua947-\ua94e\ua9b4-\ua9bc\ua9e5\uaa29-\uaa32\uaab0-\uaabe\uaaeb-\uaaef\uabe3-\uabea\U00010a01-\U00010a03\U00010a05-\U00010a06\U00010a0c-\U00010a0d\U00011038-\U00011045\U000110b0-\U000110b8\U00011127-\U00011132\U00011145-\U00011146\U000111b3-\U000111bf\U000111cb-\U000111cc\U0001122c-\U00011233\U000112e0-\U000112e8\U0001133e-\U00011344\U00011347-\U00011348\U0001134b-\U0001134c\U00011357\U00011362-\U00011363\U00011435-\U00011441\U000114b0-\U000114be\U000115af-\U000115b5\U000115b8-\U000115bb\U000115dc-\U000115dd\U00011630-\U0001163c\U00011640\U000116ad-\U000116b5\U00011720-\U0001172a\U0001182c-\U00011836\U000119d1-\U000119d7\U000119da-\U000119dd\U000119e4\U00011a01-\U00011a0a\U00011a51-\U00011a5b\U00011c2f-\U00011c36\U00011c38-\U00011c3b\U00011cb0-\U00011cb4\U00011d31-\U00011d36\U00011d3a\U00011d3c-\U00011d3d\U00011d3f\U00011d43\U00011d8a-\U00011d8e\U00011d90-\U00011d91\U00011d93-\U00011d94\U00011ef3-\U00011ef6",
    "vowelindependent": "\u0904-\u0914\u0960-\u0961\u0972-\u0977\u0985-\u098c\u098f-\u0990\u0993-\u0994\u09e0-\u09e1\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a14\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0a94\u0ae0-\u0ae1\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b14\u0b60-\u0b61\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b94\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c14\u0c60-\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0c94\u0ce0-\u0ce1\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d14\u0d5f-\u0d61\u0d85-\u0d96\u1021-\u102a\u1052-\u1055\u1700-\u1702\u1720-\u1722\u1740-\u1742\u1760-\u1762\u17a3-\u17b3\u1a4d-\u1a52\u1b05-\u1b12\u1b83-\u1b89\u1be4-\u1be5\ua800-\ua801\ua803-\ua805\ua882-\ua891\ua8fe\ua984-\ua988\ua98c-\ua98e\uaa00-\uaa05\uaae0-\uaae1\uabce-\uabcf\uabd1\U00011005-\U00011012\U00011083-\U0001108c\U00011103-\U00011106\U00011183-\U00011190\U00011200-\U00011207\U00011280-\U00011283\U000112b0-\U000112b9\U00011305-\U0001130c\U0001130f-\U00011310\U00011313-\U00011314\U00011360-\U00011361\U00011400-\U0001140d\U00011481-\U0001148e\U00011580-\U0001158d\U000115d8-\U000115db\U00011600-\U0001160d\U00011680-\U00011689\U00011800-\U00011809\U000119a0-\U000119a7\U000119aa-\U000119ad\U00011a00\U00011a50\U00011c00-\U00011c08\U00011c0a-\U00011c0d\U00011d00-\U00011d06\U00011d08-\U00011d09\U00011d0b\U00011d60-\U00011d65\U00011d67-\U00011d68\U00011d6a-\U00011d6b"
}
ascii_indic_syllabic_category: Dict[str, str] = {
    "^avagraha": "\x00-\U0010ffff",
    "^bindu": "\x00-\U0010ffff",
    "^brahmijoiningnumber": "\x00-\U0010ffff",
    "^cantillationmark": "\x00-\U0010ffff",
    "^consonant": "\x00-\U0010ffff",
    "^consonantdead": "\x00-\U0010ffff",
    "^consonantfinal": "\x00-\U0010ffff",
    "^consonantheadletter": "\x00-\U0010ffff",
    "^consonantinitialpostfixed": "\x00-\U0010ffff",
    "^consonantkiller": "\x00-\U0010ffff",
    "^consonantmedial": "\x00-\U0010ffff",
    "^consonantplaceholder": "\x00-\x2c\x2e-\U0010ffff",
    "^consonantprecedingrepha": "\x00-\U0010ffff",
    "^consonantprefixed": "\x00-\U0010ffff",
    "^consonantsubjoined": "\x00-\U0010ffff",
    "^consonantsucceedingrepha": "\x00-\U0010ffff",
    "^consonantwithstacker": "\x00-\U0010ffff",
    "^geminationmark": "\x00-\U0010ffff",
    "^invisiblestacker": "\x00-\U0010ffff",
    "^joiner": "\x00-\U0010ffff",
    "^modifyingletter": "\x00-\U0010ffff",
    "^nonjoiner": "\x00-\U0010ffff",
    "^nukta": "\x00-\U0010ffff",
    "^number": "\x00-\x2f\x3a-\U0010ffff",
    "^numberjoiner": "\x00-\U0010ffff",
    "^other": "\x5c\x2d\x30-\x39",
    "^purekiller": "\x00-\U0010ffff",
    "^registershifter": "\x00-\U0010ffff",
    "^syllablemodifier": "\x00-\U0010ffff",
    "^toneletter": "\x00-\U0010ffff",
    "^tonemark": "\x00-\U0010ffff",
    "^virama": "\x00-\U0010ffff",
    "^visarga": "\x00-\U0010ffff",
    "^vowel": "\x00-\U0010ffff",
    "^voweldependent": "\x00-\U0010ffff",
    "^vowelindependent": "\x00-\U0010ffff",
    "avagraha": "",
    "bindu": "",
    "brahmijoiningnumber": "",
    "cantillationmark": "",
    "consonant": "",
    "consonantdead": "",
    "consonantfinal": "",
    "consonantheadletter": "",
    "consonantinitialpostfixed": "",
    "consonantkiller": "",
    "consonantmedial": "",
    "consonantplaceholder": "\x5c\x2d",
    "consonantprecedingrepha": "",
    "consonantprefixed": "",
    "consonantsubjoined": "",
    "consonantsucceedingrepha": "",
    "consonantwithstacker": "",
    "geminationmark": "",
    "invisiblestacker": "",
    "joiner": "",
    "modifyingletter": "",
    "nonjoiner": "",
    "nukta": "",
    "number": "\x30-\x39",
    "numberjoiner": "",
    "other": "\x00-\x2c\x2e-\x2f\x3a-\U0010ffff",
    "purekiller": "",
    "registershifter": "",
    "syllablemodifier": "",
    "toneletter": "",
    "tonemark": "",
    "virama": "",
    "visarga": "",
    "vowel": "",
    "voweldependent": "",
    "vowelindependent": ""
}
