"""Unicode Properties from Unicode version 12.1.0 (autogen)."""
from typing import Dict

unicode_age: Dict[str, str] = {
    "1.1": "\x00-\u01f5\u01fa-\u0217\u0250-\u02a8\u02b0-\u02de\u02e0-\u02e9\u0300-\u0345\u0360-\u0361\u0374-\u0375\u037a\u037e\u0384-\u038a\u038c\u038e-\u03a1\u03a3-\u03ce\u03d0-\u03d6\u03da\u03dc\u03de\u03e0\u03e2-\u03f3\u0401-\u040c\u040e-\u044f\u0451-\u045c\u045e-\u0486\u0490-\u04c4\u04c7-\u04c8\u04cb-\u04cc\u04d0-\u04eb\u04ee-\u04f5\u04f8-\u04f9\u0531-\u0556\u0559-\u055f\u0561-\u0587\u0589\u05b0-\u05b9\u05bb-\u05c3\u05d0-\u05ea\u05f0-\u05f4\u060c\u061b\u061f\u0621-\u063a\u0640-\u0652\u0660-\u066d\u0670-\u06b7\u06ba-\u06be\u06c0-\u06ce\u06d0-\u06ed\u06f0-\u06f9\u0901-\u0903\u0905-\u0939\u093c-\u094d\u0950-\u0954\u0958-\u0970\u0981-\u0983\u0985-\u098c\u098f-\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bc\u09be-\u09c4\u09c7-\u09c8\u09cb-\u09cd\u09d7\u09dc-\u09dd\u09df-\u09e3\u09e6-\u09fa\u0a02\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a3c\u0a3e-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a59-\u0a5c\u0a5e\u0a66-\u0a74\u0a81-\u0a83\u0a85-\u0a8b\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0abc-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ad0\u0ae0\u0ae6-\u0aef\u0b01-\u0b03\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b36-\u0b39\u0b3c-\u0b43\u0b47-\u0b48\u0b4b-\u0b4d\u0b56-\u0b57\u0b5c-\u0b5d\u0b5f-\u0b61\u0b66-\u0b70\u0b82-\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99-\u0b9a\u0b9c\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb5\u0bb7-\u0bb9\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be7-\u0bf2\u0c01-\u0c03\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c60-\u0c61\u0c66-\u0c6f\u0c82-\u0c83\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5-\u0cd6\u0cde\u0ce0-\u0ce1\u0ce6-\u0cef\u0d02-\u0d03\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d28\u0d2a-\u0d39\u0d3e-\u0d43\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d60-\u0d61\u0d66-\u0d6f\u0e01-\u0e3a\u0e3f-\u0e5b\u0e81-\u0e82\u0e84\u0e87-\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa-\u0eab\u0ead-\u0eb9\u0ebb-\u0ebd\u0ec0-\u0ec4\u0ec6\u0ec8-\u0ecd\u0ed0-\u0ed9\u0edc-\u0edd\u10a0-\u10c5\u10d0-\u10f6\u10fb\u1100-\u1159\u115f-\u11a2\u11a8-\u11f9\u1e00-\u1e9a\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fc4\u1fc6-\u1fd3\u1fd6-\u1fdb\u1fdd-\u1fef\u1ff2-\u1ff4\u1ff6-\u1ffe\u2000-\u202e\u2030-\u2046\u206a-\u2070\u2074-\u208e\u20a0-\u20aa\u20d0-\u20e1\u2100-\u2138\u2153-\u2182\u2190-\u21ea\u2200-\u22f1\u2300\u2302-\u237a\u2400-\u2424\u2440-\u244a\u2460-\u24ea\u2500-\u2595\u25a0-\u25ef\u2600-\u2613\u261a-\u266f\u2701-\u2704\u2706-\u2709\u270c-\u2727\u2729-\u274b\u274d\u274f-\u2752\u2756\u2758-\u275e\u2761-\u2767\u2776-\u2794\u2798-\u27af\u27b1-\u27be\u3000-\u3037\u303f\u3041-\u3094\u3099-\u309e\u30a1-\u30fe\u3105-\u312c\u3131-\u318e\u3190-\u319f\u3200-\u321c\u3220-\u3243\u3260-\u327b\u327f-\u32b0\u32c0-\u32cb\u32d0-\u32fe\u3300-\u3376\u337b-\u33dd\u33e0-\u33fe\u4e00-\u9fa5\ue000-\ufa2d\ufb00-\ufb06\ufb13-\ufb17\ufb1e-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbb1\ufbd3-\ufd3f\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe20-\ufe23\ufe30-\ufe44\ufe49-\ufe52\ufe54-\ufe66\ufe68-\ufe6b\ufe70-\ufe72\ufe74\ufe76-\ufefc\ufeff\uff01-\uff5e\uff61-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\uffe0-\uffe6\uffe8-\uffee\ufffd-\uffff",
    "10.0": "\u0860-\u086a\u09fc-\u09fd\u0afa-\u0aff\u0d00\u0d3b-\u0d3c\u1cf7\u1df6-\u1df9\u20bf\u23ff\u2bd2\u2e45-\u2e49\u312e\u9fd6-\u9fea\U0001032d-\U0001032f\U00011a00-\U00011a47\U00011a50-\U00011a83\U00011a86-\U00011a9c\U00011a9e-\U00011aa2\U00011d00-\U00011d06\U00011d08-\U00011d09\U00011d0b-\U00011d36\U00011d3a\U00011d3c-\U00011d3d\U00011d3f-\U00011d47\U00011d50-\U00011d59\U00016fe1\U0001b002-\U0001b11e\U0001b170-\U0001b2fb\U0001f260-\U0001f265\U0001f6d3-\U0001f6d4\U0001f6f7-\U0001f6f8\U0001f900-\U0001f90b\U0001f91f\U0001f928-\U0001f92f\U0001f931-\U0001f932\U0001f94c\U0001f95f-\U0001f96b\U0001f992-\U0001f997\U0001f9d0-\U0001f9e6\U0002ceb0-\U0002ebe0",
    "11.0": "\u0560\u0588\u05ef\u07fd-\u07ff\u08d3\u09fe\u0a76\u0c04\u0c84\u1878\u1c90-\u1cba\u1cbd-\u1cbf\u2bba-\u2bbc\u2bd3-\u2beb\u2bf0-\u2bfe\u2e4a-\u2e4e\u312f\u9feb-\u9fef\ua7af\ua7b8-\ua7b9\ua8fe-\ua8ff\U00010a34-\U00010a35\U00010a48\U00010d00-\U00010d27\U00010d30-\U00010d39\U00010f00-\U00010f27\U00010f30-\U00010f59\U000110cd\U00011144-\U00011146\U0001133b\U0001145e\U0001171a\U00011800-\U0001183b\U00011a9d\U00011d60-\U00011d65\U00011d67-\U00011d68\U00011d6a-\U00011d8e\U00011d90-\U00011d91\U00011d93-\U00011d98\U00011da0-\U00011da9\U00011ee0-\U00011ef8\U00016e40-\U00016e9a\U000187ed-\U000187f1\U0001d2e0-\U0001d2f3\U0001d372-\U0001d378\U0001ec71-\U0001ecb4\U0001f12f\U0001f6f9\U0001f7d5-\U0001f7d8\U0001f94d-\U0001f94f\U0001f96c-\U0001f970\U0001f973-\U0001f976\U0001f97a\U0001f97c-\U0001f97f\U0001f998-\U0001f9a2\U0001f9b0-\U0001f9b9\U0001f9c1-\U0001f9c2\U0001f9e7-\U0001f9ff\U0001fa60-\U0001fa6d",
    "12.0": "\u0c77\u0e86\u0e89\u0e8c\u0e8e-\u0e93\u0e98\u0ea0\u0ea8-\u0ea9\u0eac\u0eba\u1cfa\u2bc9\u2bff\u2e4f\ua7ba-\ua7bf\ua7c2-\ua7c6\uab66-\uab67\U00010fe0-\U00010ff6\U0001145f\U000116b8\U000119a0-\U000119a7\U000119aa-\U000119d7\U000119da-\U000119e4\U00011a84-\U00011a85\U00011fc0-\U00011ff1\U00011fff\U00013430-\U00013438\U00016f45-\U00016f4a\U00016f4f\U00016f7f-\U00016f87\U00016fe2-\U00016fe3\U000187f2-\U000187f7\U0001b150-\U0001b152\U0001b164-\U0001b167\U0001e100-\U0001e12c\U0001e130-\U0001e13d\U0001e140-\U0001e149\U0001e14e-\U0001e14f\U0001e2c0-\U0001e2f9\U0001e2ff\U0001e94b\U0001ed01-\U0001ed3d\U0001f16c\U0001f6d5\U0001f6fa\U0001f7e0-\U0001f7eb\U0001f90d-\U0001f90f\U0001f93f\U0001f971\U0001f97b\U0001f9a5-\U0001f9aa\U0001f9ae-\U0001f9af\U0001f9ba-\U0001f9bf\U0001f9c3-\U0001f9ca\U0001f9cd-\U0001f9cf\U0001fa00-\U0001fa53\U0001fa70-\U0001fa73\U0001fa78-\U0001fa7a\U0001fa80-\U0001fa82\U0001fa90-\U0001fa95",
    "12.1": "\u32ff",
    "2.0": "\u0591-\u05a1\u05a3-\u05af\u05c4\u0f00-\u0f47\u0f49-\u0f69\u0f71-\u0f8b\u0f90-\u0f95\u0f97\u0f99-\u0fad\u0fb1-\u0fb7\u0fb9\u1e9b\u20ab\uac00-\ud7a3\ud800-\udfff\U0001fffe-\U0001ffff\U0002fffe-\U0002ffff\U0003fffe-\U0003ffff\U0004fffe-\U0004ffff\U0005fffe-\U0005ffff\U0006fffe-\U0006ffff\U0007fffe-\U0007ffff\U0008fffe-\U0008ffff\U0009fffe-\U0009ffff\U000afffe-\U000affff\U000bfffe-\U000bffff\U000cfffe-\U000cffff\U000dfffe-\U000dffff\U000efffe-\U0010ffff",
    "2.1": "\u20ac\ufffc",
    "3.0": "\u01f6-\u01f9\u0218-\u021f\u0222-\u0233\u02a9-\u02ad\u02df\u02ea-\u02ee\u0346-\u034e\u0362\u03d7\u03db\u03dd\u03df\u03e1\u0400\u040d\u0450\u045d\u0488-\u0489\u048c-\u048f\u04ec-\u04ed\u058a\u0653-\u0655\u06b8-\u06b9\u06bf\u06cf\u06fa-\u06fe\u0700-\u070d\u070f-\u072c\u0730-\u074a\u0780-\u07b0\u0d82-\u0d83\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0df2-\u0df4\u0f6a\u0f96\u0fae-\u0fb0\u0fb8\u0fba-\u0fbc\u0fbe-\u0fcc\u0fcf\u1000-\u1021\u1023-\u1027\u1029-\u102a\u102c-\u1032\u1036-\u1039\u1040-\u1059\u1200-\u1206\u1208-\u1246\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1286\u1288\u128a-\u128d\u1290-\u12ae\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12ce\u12d0-\u12d6\u12d8-\u12ee\u12f0-\u130e\u1310\u1312-\u1315\u1318-\u131e\u1320-\u1346\u1348-\u135a\u1361-\u137c\u13a0-\u13f4\u1401-\u1676\u1680-\u169c\u16a0-\u16f0\u1780-\u17dc\u17e0-\u17e9\u1800-\u180e\u1810-\u1819\u1820-\u1877\u1880-\u18a9\u202f\u2048-\u204d\u20ad-\u20af\u20e2-\u20e3\u2139-\u213a\u2183\u21eb-\u21f3\u2301\u237b\u237d-\u239a\u2425-\u2426\u25f0-\u25f7\u2619\u2670-\u2671\u2800-\u28ff\u2e80-\u2e99\u2e9b-\u2ef3\u2f00-\u2fd5\u2ff0-\u2ffb\u3038-\u303a\u303e\u31a0-\u31b7\u3400-\u4db5\ua000-\ua48c\ua490-\ua4a1\ua4a4-\ua4b3\ua4b5-\ua4c0\ua4c2-\ua4c4\ua4c6\ufb1d\ufff9-\ufffb",
    "3.1": "\u03f4-\u03f5\ufdd0-\ufdef\U00010300-\U0001031e\U00010320-\U00010323\U00010330-\U0001034a\U00010400-\U00010425\U00010428-\U0001044d\U0001d000-\U0001d0f5\U0001d100-\U0001d126\U0001d12a-\U0001d1dd\U0001d400-\U0001d454\U0001d456-\U0001d49c\U0001d49e-\U0001d49f\U0001d4a2\U0001d4a5-\U0001d4a6\U0001d4a9-\U0001d4ac\U0001d4ae-\U0001d4b9\U0001d4bb\U0001d4bd-\U0001d4c0\U0001d4c2-\U0001d4c3\U0001d4c5-\U0001d505\U0001d507-\U0001d50a\U0001d50d-\U0001d514\U0001d516-\U0001d51c\U0001d51e-\U0001d539\U0001d53b-\U0001d53e\U0001d540-\U0001d544\U0001d546\U0001d54a-\U0001d550\U0001d552-\U0001d6a3\U0001d6a8-\U0001d7c9\U0001d7ce-\U0001d7ff\U00020000-\U0002a6d6\U0002f800-\U0002fa1d\U000e0001\U000e0020-\U000e007f",
    "3.2": "\u0220\u034f\u0363-\u036f\u03d8-\u03d9\u03f6\u048a-\u048b\u04c5-\u04c6\u04c9-\u04ca\u04cd-\u04ce\u0500-\u050f\u066e-\u066f\u07b1\u10f7-\u10f8\u1700-\u170c\u170e-\u1714\u1720-\u1736\u1740-\u1753\u1760-\u176c\u176e-\u1770\u1772-\u1773\u2047\u204e-\u2052\u2057\u205f-\u2063\u2071\u20b0-\u20b1\u20e4-\u20ea\u213d-\u214b\u21f4-\u21ff\u22f2-\u22ff\u237c\u239b-\u23ce\u24eb-\u24fe\u2596-\u259f\u25f8-\u25ff\u2616-\u2617\u2672-\u267d\u2680-\u2689\u2768-\u2775\u27d0-\u27eb\u27f0-\u27ff\u2900-\u2aff\u303b-\u303d\u3095-\u3096\u309f-\u30a0\u30ff\u31f0-\u31ff\u3251-\u325f\u32b1-\u32bf\ua4a2-\ua4a3\ua4b4\ua4c1\ua4c5\ufa30-\ufa6a\ufdfc\ufe00-\ufe0f\ufe45-\ufe46\ufe73\uff5f-\uff60",
    "4.0": "\u0221\u0234-\u0236\u02ae-\u02af\u02ef-\u02ff\u0350-\u0357\u035d-\u035f\u03f7-\u03fb\u0600-\u0603\u060d-\u0615\u0656-\u0658\u06ee-\u06ef\u06ff\u072d-\u072f\u074d-\u074f\u0904\u09bd\u0a01\u0a03\u0a8c\u0ae1-\u0ae3\u0af1\u0b35\u0b71\u0bf3-\u0bfa\u0cbc-\u0cbd\u17dd\u17f0-\u17f9\u1900-\u191c\u1920-\u192b\u1930-\u193b\u1940\u1944-\u196d\u1970-\u1974\u19e0-\u19ff\u1d00-\u1d6b\u2053-\u2054\u213b\u23cf-\u23d0\u24ff\u2614-\u2615\u268a-\u2691\u26a0-\u26a1\u2b00-\u2b0d\u321d-\u321e\u3250\u327c-\u327d\u32cc-\u32cf\u3377-\u337a\u33de-\u33df\u33ff\u4dc0-\u4dff\ufdfd\ufe47-\ufe48\U00010000-\U0001000b\U0001000d-\U00010026\U00010028-\U0001003a\U0001003c-\U0001003d\U0001003f-\U0001004d\U00010050-\U0001005d\U00010080-\U000100fa\U00010100-\U00010102\U00010107-\U00010133\U00010137-\U0001013f\U00010380-\U0001039d\U0001039f\U00010426-\U00010427\U0001044e-\U0001049d\U000104a0-\U000104a9\U00010800-\U00010805\U00010808\U0001080a-\U00010835\U00010837-\U00010838\U0001083c\U0001083f\U0001d300-\U0001d356\U0001d4c1\U000e0100-\U000e01ef",
    "4.1": "\u0237-\u0241\u0358-\u035c\u03fc-\u03ff\u04f6-\u04f7\u05a2\u05c5-\u05c7\u060b\u061e\u0659-\u065e\u0750-\u076d\u097d\u09ce\u0bb6\u0be6\u0fd0-\u0fd1\u10f9-\u10fa\u10fc\u1207\u1247\u1287\u12af\u12cf\u12ef\u130f\u131f\u1347\u135f-\u1360\u1380-\u1399\u1980-\u19a9\u19b0-\u19c9\u19d0-\u19d9\u19de-\u19df\u1a00-\u1a1b\u1a1e-\u1a1f\u1d6c-\u1dc3\u2055-\u2056\u2058-\u205e\u2090-\u2094\u20b2-\u20b5\u20eb\u213c\u214c\u23d1-\u23db\u2618\u267e-\u267f\u2692-\u269c\u26a2-\u26b1\u27c0-\u27c6\u2b0e-\u2b13\u2c00-\u2c2e\u2c30-\u2c5e\u2c80-\u2cea\u2cf9-\u2d25\u2d30-\u2d65\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2e00-\u2e17\u2e1c-\u2e1d\u31c0-\u31cf\u327e\u9fa6-\u9fbb\ua700-\ua716\ua800-\ua82b\ufa70-\ufad9\ufe10-\ufe19\U00010140-\U0001018a\U000103a0-\U000103c3\U000103c8-\U000103d5\U00010a00-\U00010a03\U00010a05-\U00010a06\U00010a0c-\U00010a13\U00010a15-\U00010a17\U00010a19-\U00010a33\U00010a38-\U00010a3a\U00010a3f-\U00010a47\U00010a50-\U00010a58\U0001d200-\U0001d245\U0001d6a4-\U0001d6a5",
    "5.0": "\u0242-\u024f\u037b-\u037d\u04cf\u04fa-\u04ff\u0510-\u0513\u05ba\u07c0-\u07fa\u097b-\u097c\u097e-\u097f\u0ce2-\u0ce3\u0cf1-\u0cf2\u1b00-\u1b4b\u1b50-\u1b7c\u1dc4-\u1dca\u1dfe-\u1dff\u20ec-\u20ef\u214d-\u214e\u2184\u23dc-\u23e7\u26b2\u27c7-\u27ca\u2b14-\u2b1a\u2b20-\u2b23\u2c60-\u2c6c\u2c74-\u2c77\ua717-\ua71a\ua720-\ua721\ua840-\ua877\U00010900-\U00010919\U0001091f\U00012000-\U0001236e\U00012400-\U00012462\U00012470-\U00012473\U0001d360-\U0001d371\U0001d7ca-\U0001d7cb",
    "5.1": "\u0370-\u0373\u0376-\u0377\u03cf\u0487\u0514-\u0523\u0606-\u060a\u0616-\u061a\u063b-\u063f\u076e-\u077f\u0971-\u0972\u0a51\u0a75\u0b44\u0b62-\u0b63\u0bd0\u0c3d\u0c58-\u0c59\u0c62-\u0c63\u0c78-\u0c7f\u0d3d\u0d44\u0d62-\u0d63\u0d70-\u0d75\u0d79-\u0d7f\u0f6b-\u0f6c\u0fce\u0fd2-\u0fd4\u1022\u1028\u102b\u1033-\u1035\u103a-\u103f\u105a-\u1099\u109e-\u109f\u18aa\u1b80-\u1baa\u1bae-\u1bb9\u1c00-\u1c37\u1c3b-\u1c49\u1c4d-\u1c7f\u1dcb-\u1de6\u1e9c-\u1e9f\u1efa-\u1eff\u2064\u20f0\u214f\u2185-\u2188\u269d\u26b3-\u26bc\u26c0-\u26c3\u27cc\u27ec-\u27ef\u2b1b-\u2b1f\u2b24-\u2b4c\u2b50-\u2b54\u2c6d-\u2c6f\u2c71-\u2c73\u2c78-\u2c7d\u2de0-\u2dff\u2e18-\u2e1b\u2e1e-\u2e30\u312d\u31d0-\u31e3\u9fbc-\u9fc3\ua500-\ua62b\ua640-\ua65f\ua662-\ua673\ua67c-\ua697\ua71b-\ua71f\ua722-\ua78c\ua7fb-\ua7ff\ua880-\ua8c4\ua8ce-\ua8d9\ua900-\ua953\ua95f\uaa00-\uaa36\uaa40-\uaa4d\uaa50-\uaa59\uaa5c-\uaa5f\ufe24-\ufe26\U00010190-\U0001019b\U000101d0-\U000101fd\U00010280-\U0001029c\U000102a0-\U000102d0\U00010920-\U00010939\U0001093f\U0001d129\U0001f000-\U0001f02b\U0001f030-\U0001f093",
    "5.2": "\u0524-\u0525\u0800-\u082d\u0830-\u083e\u0900\u094e\u0955\u0979-\u097a\u09fb\u0fd5-\u0fd8\u109a-\u109d\u115a-\u115e\u11a3-\u11a7\u11fa-\u11ff\u1400\u1677-\u167f\u18b0-\u18f5\u19aa-\u19ab\u19da\u1a20-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1aa0-\u1aad\u1cd0-\u1cf2\u1dfd\u20b6-\u20b8\u2150-\u2152\u2189\u23e8\u269e-\u269f\u26bd-\u26bf\u26c4-\u26cd\u26cf-\u26e1\u26e3\u26e8-\u26ff\u2757\u2b55-\u2b59\u2c70\u2c7e-\u2c7f\u2ceb-\u2cf1\u2e31\u3244-\u324f\u9fc4-\u9fcb\ua4d0-\ua4ff\ua6a0-\ua6f7\ua830-\ua839\ua8e0-\ua8fb\ua960-\ua97c\ua980-\ua9cd\ua9cf-\ua9d9\ua9de-\ua9df\uaa60-\uaa7b\uaa80-\uaac2\uaadb-\uaadf\uabc0-\uabed\uabf0-\uabf9\ud7b0-\ud7c6\ud7cb-\ud7fb\ufa6b-\ufa6d\U00010840-\U00010855\U00010857-\U0001085f\U0001091a-\U0001091b\U00010a60-\U00010a7f\U00010b00-\U00010b35\U00010b39-\U00010b55\U00010b58-\U00010b72\U00010b78-\U00010b7f\U00010c00-\U00010c48\U00010e60-\U00010e7e\U00011080-\U000110c1\U00013000-\U0001342e\U0001f100-\U0001f10a\U0001f110-\U0001f12e\U0001f131\U0001f13d\U0001f13f\U0001f142\U0001f146\U0001f14a-\U0001f14e\U0001f157\U0001f15f\U0001f179\U0001f17b-\U0001f17c\U0001f17f\U0001f18a-\U0001f18d\U0001f190\U0001f200\U0001f210-\U0001f231\U0001f240-\U0001f248\U0002a700-\U0002b734",
    "6.0": "\u0526-\u0527\u0620\u065f\u0840-\u085b\u085e\u093a-\u093b\u094f\u0956-\u0957\u0973-\u0977\u0b72-\u0b77\u0d29\u0d3a\u0d4e\u0f8c-\u0f8f\u0fd9-\u0fda\u135d-\u135e\u1bc0-\u1bf3\u1bfc-\u1bff\u1dfc\u2095-\u209c\u20b9\u23e9-\u23f3\u26ce\u26e2\u26e4-\u26e7\u2705\u270a-\u270b\u2728\u274c\u274e\u2753-\u2755\u275f-\u2760\u2795-\u2797\u27b0\u27bf\u27ce-\u27cf\u2d70\u2d7f\u31b8-\u31ba\ua660-\ua661\ua78d-\ua78e\ua790-\ua791\ua7a0-\ua7a9\ua7fa\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\ufbb2-\ufbc1\U00011000-\U0001104d\U00011052-\U0001106f\U00016800-\U00016a38\U0001b000-\U0001b001\U0001f0a0-\U0001f0ae\U0001f0b1-\U0001f0be\U0001f0c1-\U0001f0cf\U0001f0d1-\U0001f0df\U0001f130\U0001f132-\U0001f13c\U0001f13e\U0001f140-\U0001f141\U0001f143-\U0001f145\U0001f147-\U0001f149\U0001f14f-\U0001f156\U0001f158-\U0001f15e\U0001f160-\U0001f169\U0001f170-\U0001f178\U0001f17a\U0001f17d-\U0001f17e\U0001f180-\U0001f189\U0001f18e-\U0001f18f\U0001f191-\U0001f19a\U0001f1e6-\U0001f1ff\U0001f201-\U0001f202\U0001f232-\U0001f23a\U0001f250-\U0001f251\U0001f300-\U0001f320\U0001f330-\U0001f335\U0001f337-\U0001f37c\U0001f380-\U0001f393\U0001f3a0-\U0001f3c4\U0001f3c6-\U0001f3ca\U0001f3e0-\U0001f3f0\U0001f400-\U0001f43e\U0001f440\U0001f442-\U0001f4f7\U0001f4f9-\U0001f4fc\U0001f500-\U0001f53d\U0001f550-\U0001f567\U0001f5fb-\U0001f5ff\U0001f601-\U0001f610\U0001f612-\U0001f614\U0001f616\U0001f618\U0001f61a\U0001f61c-\U0001f61e\U0001f620-\U0001f625\U0001f628-\U0001f62b\U0001f62d\U0001f630-\U0001f633\U0001f635-\U0001f640\U0001f645-\U0001f64f\U0001f680-\U0001f6c5\U0001f700-\U0001f773\U0002b740-\U0002b81d",
    "6.1": "\u058f\u0604\u08a0\u08a2-\u08ac\u08e4-\u08fe\u0af0\u0ede-\u0edf\u10c7\u10cd\u10fd-\u10ff\u1bab-\u1bad\u1bba-\u1bbf\u1cc0-\u1cc7\u1cf3-\u1cf6\u27cb\u27cd\u2cf2-\u2cf3\u2d27\u2d2d\u2d66-\u2d67\u2e32-\u2e3b\u9fcc\ua674-\ua67b\ua69f\ua792-\ua793\ua7aa\ua7f8-\ua7f9\uaae0-\uaaf6\ufa2e-\ufa2f\U00010980-\U000109b7\U000109be-\U000109bf\U000110d0-\U000110e8\U000110f0-\U000110f9\U00011100-\U00011134\U00011136-\U00011143\U00011180-\U000111c8\U000111d0-\U000111d9\U00011680-\U000116b7\U000116c0-\U000116c9\U00016f00-\U00016f44\U00016f50-\U00016f7e\U00016f8f-\U00016f9f\U0001ee00-\U0001ee03\U0001ee05-\U0001ee1f\U0001ee21-\U0001ee22\U0001ee24\U0001ee27\U0001ee29-\U0001ee32\U0001ee34-\U0001ee37\U0001ee39\U0001ee3b\U0001ee42\U0001ee47\U0001ee49\U0001ee4b\U0001ee4d-\U0001ee4f\U0001ee51-\U0001ee52\U0001ee54\U0001ee57\U0001ee59\U0001ee5b\U0001ee5d\U0001ee5f\U0001ee61-\U0001ee62\U0001ee64\U0001ee67-\U0001ee6a\U0001ee6c-\U0001ee72\U0001ee74-\U0001ee77\U0001ee79-\U0001ee7c\U0001ee7e\U0001ee80-\U0001ee89\U0001ee8b-\U0001ee9b\U0001eea1-\U0001eea3\U0001eea5-\U0001eea9\U0001eeab-\U0001eebb\U0001eef0-\U0001eef1\U0001f16a-\U0001f16b\U0001f540-\U0001f543\U0001f600\U0001f611\U0001f615\U0001f617\U0001f619\U0001f61b\U0001f61f\U0001f626-\U0001f627\U0001f62c\U0001f62e-\U0001f62f\U0001f634",
    "6.2": "\u20ba",
    "6.3": "\u061c\u2066-\u2069",
    "7.0": "\u037f\u0528-\u052f\u058d-\u058e\u0605\u08a1\u08ad-\u08b2\u08ff\u0978\u0980\u0c00\u0c34\u0c81\u0d01\u0de6-\u0def\u16f1-\u16f8\u191d-\u191e\u1ab0-\u1abe\u1cf8-\u1cf9\u1de7-\u1df5\u20bb-\u20bd\u23f4-\u23fa\u2700\u2b4d-\u2b4f\u2b5a-\u2b73\u2b76-\u2b95\u2b98-\u2bb9\u2bbd-\u2bc8\u2bca-\u2bd1\u2e3c-\u2e42\ua698-\ua69d\ua794-\ua79f\ua7ab-\ua7ad\ua7b0-\ua7b1\ua7f7\ua9e0-\ua9fe\uaa7c-\uaa7f\uab30-\uab5f\uab64-\uab65\ufe27-\ufe2d\U0001018b-\U0001018c\U000101a0\U000102e0-\U000102fb\U0001031f\U00010350-\U0001037a\U00010500-\U00010527\U00010530-\U00010563\U0001056f\U00010600-\U00010736\U00010740-\U00010755\U00010760-\U00010767\U00010860-\U0001089e\U000108a7-\U000108af\U00010a80-\U00010a9f\U00010ac0-\U00010ae6\U00010aeb-\U00010af6\U00010b80-\U00010b91\U00010b99-\U00010b9c\U00010ba9-\U00010baf\U0001107f\U00011150-\U00011176\U000111cd\U000111da\U000111e1-\U000111f4\U00011200-\U00011211\U00011213-\U0001123d\U000112b0-\U000112ea\U000112f0-\U000112f9\U00011301-\U00011303\U00011305-\U0001130c\U0001130f-\U00011310\U00011313-\U00011328\U0001132a-\U00011330\U00011332-\U00011333\U00011335-\U00011339\U0001133c-\U00011344\U00011347-\U00011348\U0001134b-\U0001134d\U00011357\U0001135d-\U00011363\U00011366-\U0001136c\U00011370-\U00011374\U00011480-\U000114c7\U000114d0-\U000114d9\U00011580-\U000115b5\U000115b8-\U000115c9\U00011600-\U00011644\U00011650-\U00011659\U000118a0-\U000118f2\U000118ff\U00011ac0-\U00011af8\U0001236f-\U00012398\U00012463-\U0001246e\U00012474\U00016a40-\U00016a5e\U00016a60-\U00016a69\U00016a6e-\U00016a6f\U00016ad0-\U00016aed\U00016af0-\U00016af5\U00016b00-\U00016b45\U00016b50-\U00016b59\U00016b5b-\U00016b61\U00016b63-\U00016b77\U00016b7d-\U00016b8f\U0001bc00-\U0001bc6a\U0001bc70-\U0001bc7c\U0001bc80-\U0001bc88\U0001bc90-\U0001bc99\U0001bc9c-\U0001bca3\U0001e800-\U0001e8c4\U0001e8c7-\U0001e8d6\U0001f0bf\U0001f0e0-\U0001f0f5\U0001f10b-\U0001f10c\U0001f321-\U0001f32c\U0001f336\U0001f37d\U0001f394-\U0001f39f\U0001f3c5\U0001f3cb-\U0001f3ce\U0001f3d4-\U0001f3df\U0001f3f1-\U0001f3f7\U0001f43f\U0001f441\U0001f4f8\U0001f4fd-\U0001f4fe\U0001f53e-\U0001f53f\U0001f544-\U0001f54a\U0001f568-\U0001f579\U0001f57b-\U0001f5a3\U0001f5a5-\U0001f5fa\U0001f641-\U0001f642\U0001f650-\U0001f67f\U0001f6c6-\U0001f6cf\U0001f6e0-\U0001f6ec\U0001f6f0-\U0001f6f3\U0001f780-\U0001f7d4\U0001f800-\U0001f80b\U0001f810-\U0001f847\U0001f850-\U0001f859\U0001f860-\U0001f887\U0001f890-\U0001f8ad",
    "8.0": "\u08b3-\u08b4\u08e3\u0af9\u0c5a\u0d5f\u13f5\u13f8-\u13fd\u20be\u218a-\u218b\u2bec-\u2bef\u9fcd-\u9fd5\ua69e\ua78f\ua7b2-\ua7b7\ua8fc-\ua8fd\uab60-\uab63\uab70-\uabbf\ufe2e-\ufe2f\U000108e0-\U000108f2\U000108f4-\U000108f5\U000108fb-\U000108ff\U000109bc-\U000109bd\U000109c0-\U000109cf\U000109d2-\U000109ff\U00010c80-\U00010cb2\U00010cc0-\U00010cf2\U00010cfa-\U00010cff\U000111c9-\U000111cc\U000111db-\U000111df\U00011280-\U00011286\U00011288\U0001128a-\U0001128d\U0001128f-\U0001129d\U0001129f-\U000112a9\U00011300\U00011350\U000115ca-\U000115dd\U00011700-\U00011719\U0001171d-\U0001172b\U00011730-\U0001173f\U00012399\U00012480-\U00012543\U00014400-\U00014646\U0001d1de-\U0001d1e8\U0001d800-\U0001da8b\U0001da9b-\U0001da9f\U0001daa1-\U0001daaf\U0001f32d-\U0001f32f\U0001f37e-\U0001f37f\U0001f3cf-\U0001f3d3\U0001f3f8-\U0001f3ff\U0001f4ff\U0001f54b-\U0001f54f\U0001f643-\U0001f644\U0001f6d0\U0001f910-\U0001f918\U0001f980-\U0001f984\U0001f9c0\U0002b820-\U0002cea1",
    "9.0": "\u08b6-\u08bd\u08d4-\u08e2\u0c80\u0d4f\u0d54-\u0d56\u0d58-\u0d5e\u0d76-\u0d78\u1c80-\u1c88\u1dfb\u23fb-\u23fe\u2e43-\u2e44\ua7ae\ua8c5\U0001018d-\U0001018e\U000104b0-\U000104d3\U000104d8-\U000104fb\U0001123e\U00011400-\U00011459\U0001145b\U0001145d\U00011660-\U0001166c\U00011c00-\U00011c08\U00011c0a-\U00011c36\U00011c38-\U00011c45\U00011c50-\U00011c6c\U00011c70-\U00011c8f\U00011c92-\U00011ca7\U00011ca9-\U00011cb6\U00016fe0\U00017000-\U000187ec\U00018800-\U00018af2\U0001e000-\U0001e006\U0001e008-\U0001e018\U0001e01b-\U0001e021\U0001e023-\U0001e024\U0001e026-\U0001e02a\U0001e900-\U0001e94a\U0001e950-\U0001e959\U0001e95e-\U0001e95f\U0001f19b-\U0001f1ac\U0001f23b\U0001f57a\U0001f5a4\U0001f6d1-\U0001f6d2\U0001f6f4-\U0001f6f6\U0001f919-\U0001f91e\U0001f920-\U0001f927\U0001f930\U0001f933-\U0001f93e\U0001f940-\U0001f94b\U0001f950-\U0001f95e\U0001f985-\U0001f991",
    "^1.1": "\u01f6-\u01f9\u0218-\u024f\u02a9-\u02af\u02df\u02ea-\u02ff\u0346-\u035f\u0362-\u0373\u0376-\u0379\u037b-\u037d\u037f-\u0383\u038b\u038d\u03a2\u03cf\u03d7-\u03d9\u03db\u03dd\u03df\u03e1\u03f4-\u0400\u040d\u0450\u045d\u0487-\u048f\u04c5-\u04c6\u04c9-\u04ca\u04cd-\u04cf\u04ec-\u04ed\u04f6-\u04f7\u04fa-\u0530\u0557-\u0558\u0560\u0588\u058a-\u05af\u05ba\u05c4-\u05cf\u05eb-\u05ef\u05f5-\u060b\u060d-\u061a\u061c-\u061e\u0620\u063b-\u063f\u0653-\u065f\u066e-\u066f\u06b8-\u06b9\u06bf\u06cf\u06ee-\u06ef\u06fa-\u0900\u0904\u093a-\u093b\u094e-\u094f\u0955-\u0957\u0971-\u0980\u0984\u098d-\u098e\u0991-\u0992\u09a9\u09b1\u09b3-\u09b5\u09ba-\u09bb\u09bd\u09c5-\u09c6\u09c9-\u09ca\u09ce-\u09d6\u09d8-\u09db\u09de\u09e4-\u09e5\u09fb-\u0a01\u0a03-\u0a04\u0a0b-\u0a0e\u0a11-\u0a12\u0a29\u0a31\u0a34\u0a37\u0a3a-\u0a3b\u0a3d\u0a43-\u0a46\u0a49-\u0a4a\u0a4e-\u0a58\u0a5d\u0a5f-\u0a65\u0a75-\u0a80\u0a84\u0a8c\u0a8e\u0a92\u0aa9\u0ab1\u0ab4\u0aba-\u0abb\u0ac6\u0aca\u0ace-\u0acf\u0ad1-\u0adf\u0ae1-\u0ae5\u0af0-\u0b00\u0b04\u0b0d-\u0b0e\u0b11-\u0b12\u0b29\u0b31\u0b34-\u0b35\u0b3a-\u0b3b\u0b44-\u0b46\u0b49-\u0b4a\u0b4e-\u0b55\u0b58-\u0b5b\u0b5e\u0b62-\u0b65\u0b71-\u0b81\u0b84\u0b8b-\u0b8d\u0b91\u0b96-\u0b98\u0b9b\u0b9d\u0ba0-\u0ba2\u0ba5-\u0ba7\u0bab-\u0bad\u0bb6\u0bba-\u0bbd\u0bc3-\u0bc5\u0bc9\u0bce-\u0bd6\u0bd8-\u0be6\u0bf3-\u0c00\u0c04\u0c0d\u0c11\u0c29\u0c34\u0c3a-\u0c3d\u0c45\u0c49\u0c4e-\u0c54\u0c57-\u0c5f\u0c62-\u0c65\u0c70-\u0c81\u0c84\u0c8d\u0c91\u0ca9\u0cb4\u0cba-\u0cbd\u0cc5\u0cc9\u0cce-\u0cd4\u0cd7-\u0cdd\u0cdf\u0ce2-\u0ce5\u0cf0-\u0d01\u0d04\u0d0d\u0d11\u0d29\u0d3a-\u0d3d\u0d44-\u0d45\u0d49\u0d4e-\u0d56\u0d58-\u0d5f\u0d62-\u0d65\u0d70-\u0e00\u0e3b-\u0e3e\u0e5c-\u0e80\u0e83\u0e85-\u0e86\u0e89\u0e8b-\u0e8c\u0e8e-\u0e93\u0e98\u0ea0\u0ea4\u0ea6\u0ea8-\u0ea9\u0eac\u0eba\u0ebe-\u0ebf\u0ec5\u0ec7\u0ece-\u0ecf\u0eda-\u0edb\u0ede-\u109f\u10c6-\u10cf\u10f7-\u10fa\u10fc-\u10ff\u115a-\u115e\u11a3-\u11a7\u11fa-\u1dff\u1e9b-\u1e9f\u1efa-\u1eff\u1f16-\u1f17\u1f1e-\u1f1f\u1f46-\u1f47\u1f4e-\u1f4f\u1f58\u1f5a\u1f5c\u1f5e\u1f7e-\u1f7f\u1fb5\u1fc5\u1fd4-\u1fd5\u1fdc\u1ff0-\u1ff1\u1ff5\u1fff\u202f\u2047-\u2069\u2071-\u2073\u208f-\u209f\u20ab-\u20cf\u20e2-\u20ff\u2139-\u2152\u2183-\u218f\u21eb-\u21ff\u22f2-\u22ff\u2301\u237b-\u23ff\u2425-\u243f\u244b-\u245f\u24eb-\u24ff\u2596-\u259f\u25f0-\u25ff\u2614-\u2619\u2670-\u2700\u2705\u270a-\u270b\u2728\u274c\u274e\u2753-\u2755\u2757\u275f-\u2760\u2768-\u2775\u2795-\u2797\u27b0\u27bf-\u2fff\u3038-\u303e\u3040\u3095-\u3098\u309f-\u30a0\u30ff-\u3104\u312d-\u3130\u318f\u31a0-\u31ff\u321d-\u321f\u3244-\u325f\u327c-\u327e\u32b1-\u32bf\u32cc-\u32cf\u32ff\u3377-\u337a\u33de-\u33df\u33ff-\u4dff\u9fa6-\udfff\ufa2e-\ufaff\ufb07-\ufb12\ufb18-\ufb1d\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufbb2-\ufbd2\ufd40-\ufd4f\ufd90-\ufd91\ufdc8-\ufdef\ufdfc-\ufe1f\ufe24-\ufe2f\ufe45-\ufe48\ufe53\ufe67\ufe6c-\ufe6f\ufe73\ufe75\ufefd-\ufefe\uff00\uff5f-\uff60\uffbf-\uffc1\uffc8-\uffc9\uffd0-\uffd1\uffd8-\uffd9\uffdd-\uffdf\uffe7\uffef-\ufffc\U00010000-\U0010ffff",
    "^10.0": "\x00-\u085f\u086b-\u09fb\u09fe-\u0af9\u0b00-\u0cff\u0d01-\u0d3a\u0d3d-\u1cf6\u1cf8-\u1df5\u1dfa-\u20be\u20c0-\u23fe\u2400-\u2bd1\u2bd3-\u2e44\u2e4a-\u312d\u312f-\u9fd5\u9feb-\U0001032c\U00010330-\U000119ff\U00011a48-\U00011a4f\U00011a84-\U00011a85\U00011a9d\U00011aa3-\U00011cff\U00011d07\U00011d0a\U00011d37-\U00011d39\U00011d3b\U00011d3e\U00011d48-\U00011d4f\U00011d5a-\U00016fe0\U00016fe2-\U0001b001\U0001b11f-\U0001b16f\U0001b2fc-\U0001f25f\U0001f266-\U0001f6d2\U0001f6d5-\U0001f6f6\U0001f6f9-\U0001f8ff\U0001f90c-\U0001f91e\U0001f920-\U0001f927\U0001f930\U0001f933-\U0001f94b\U0001f94d-\U0001f95e\U0001f96c-\U0001f991\U0001f998-\U0001f9cf\U0001f9e7-\U0002ceaf\U0002ebe1-\U0010ffff",
    "^11.0": "\x00-\u055f\u0561-\u0587\u0589-\u05ee\u05f0-\u07fc\u0800-\u08d2\u08d4-\u09fd\u09ff-\u0a75\u0a77-\u0c03\u0c05-\u0c83\u0c85-\u1877\u1879-\u1c8f\u1cbb-\u1cbc\u1cc0-\u2bb9\u2bbd-\u2bd2\u2bec-\u2bef\u2bff-\u2e49\u2e4f-\u312e\u3130-\u9fea\u9ff0-\ua7ae\ua7b0-\ua7b7\ua7ba-\ua8fd\ua900-\U00010a33\U00010a36-\U00010a47\U00010a49-\U00010cff\U00010d28-\U00010d2f\U00010d3a-\U00010eff\U00010f28-\U00010f2f\U00010f5a-\U000110cc\U000110ce-\U00011143\U00011147-\U0001133a\U0001133c-\U0001145d\U0001145f-\U00011719\U0001171b-\U000117ff\U0001183c-\U00011a9c\U00011a9e-\U00011d5f\U00011d66\U00011d69\U00011d8f\U00011d92\U00011d99-\U00011d9f\U00011daa-\U00011edf\U00011ef9-\U00016e3f\U00016e9b-\U000187ec\U000187f2-\U0001d2df\U0001d2f4-\U0001d371\U0001d379-\U0001ec70\U0001ecb5-\U0001f12e\U0001f130-\U0001f6f8\U0001f6fa-\U0001f7d4\U0001f7d9-\U0001f94c\U0001f950-\U0001f96b\U0001f971-\U0001f972\U0001f977-\U0001f979\U0001f97b\U0001f980-\U0001f997\U0001f9a3-\U0001f9af\U0001f9ba-\U0001f9c0\U0001f9c3-\U0001f9e6\U0001fa00-\U0001fa5f\U0001fa6e-\U0010ffff",
    "^12.0": "\x00-\u0c76\u0c78-\u0e85\u0e87-\u0e88\u0e8a-\u0e8b\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea7\u0eaa-\u0eab\u0ead-\u0eb9\u0ebb-\u1cf9\u1cfb-\u2bc8\u2bca-\u2bfe\u2c00-\u2e4e\u2e50-\ua7b9\ua7c0-\ua7c1\ua7c7-\uab65\uab68-\U00010fdf\U00010ff7-\U0001145e\U00011460-\U000116b7\U000116b9-\U0001199f\U000119a8-\U000119a9\U000119d8-\U000119d9\U000119e5-\U00011a83\U00011a86-\U00011fbf\U00011ff2-\U00011ffe\U00012000-\U0001342f\U00013439-\U00016f44\U00016f4b-\U00016f4e\U00016f50-\U00016f7e\U00016f88-\U00016fe1\U00016fe4-\U000187f1\U000187f8-\U0001b14f\U0001b153-\U0001b163\U0001b168-\U0001e0ff\U0001e12d-\U0001e12f\U0001e13e-\U0001e13f\U0001e14a-\U0001e14d\U0001e150-\U0001e2bf\U0001e2fa-\U0001e2fe\U0001e300-\U0001e94a\U0001e94c-\U0001ed00\U0001ed3e-\U0001f16b\U0001f16d-\U0001f6d4\U0001f6d6-\U0001f6f9\U0001f6fb-\U0001f7df\U0001f7ec-\U0001f90c\U0001f910-\U0001f93e\U0001f940-\U0001f970\U0001f972-\U0001f97a\U0001f97c-\U0001f9a4\U0001f9ab-\U0001f9ad\U0001f9b0-\U0001f9b9\U0001f9c0-\U0001f9c2\U0001f9cb-\U0001f9cc\U0001f9d0-\U0001f9ff\U0001fa54-\U0001fa6f\U0001fa74-\U0001fa77\U0001fa7b-\U0001fa7f\U0001fa83-\U0001fa8f\U0001fa96-\U0010ffff",
    "^12.1": "\x00-\u32fe\u3300-\U0010ffff",
    "^2.0": "\x00-\u0590\u05a2\u05b0-\u05c3\u05c5-\u0eff\u0f48\u0f6a-\u0f70\u0f8c-\u0f8f\u0f96\u0f98\u0fae-\u0fb0\u0fb8\u0fba-\u1e9a\u1e9c-\u20aa\u20ac-\uabff\ud7a4-\ud7ff\ue000-\U0001fffd\U00020000-\U0002fffd\U00030000-\U0003fffd\U00040000-\U0004fffd\U00050000-\U0005fffd\U00060000-\U0006fffd\U00070000-\U0007fffd\U00080000-\U0008fffd\U00090000-\U0009fffd\U000a0000-\U000afffd\U000b0000-\U000bfffd\U000c0000-\U000cfffd\U000d0000-\U000dfffd\U000e0000-\U000efffd",
    "^2.1": "\x00-\u20ab\u20ad-\ufffb\ufffd-\U0010ffff",
    "^3.0": "\x00-\u01f5\u01fa-\u0217\u0220-\u0221\u0234-\u02a8\u02ae-\u02de\u02e0-\u02e9\u02ef-\u0345\u034f-\u0361\u0363-\u03d6\u03d8-\u03da\u03dc\u03de\u03e0\u03e2-\u03ff\u0401-\u040c\u040e-\u044f\u0451-\u045c\u045e-\u0487\u048a-\u048b\u0490-\u04eb\u04ee-\u0589\u058b-\u0652\u0656-\u06b7\u06ba-\u06be\u06c0-\u06ce\u06d0-\u06f9\u06ff\u070e\u072d-\u072f\u074b-\u077f\u07b1-\u0d81\u0d84\u0d97-\u0d99\u0db2\u0dbc\u0dbe-\u0dbf\u0dc7-\u0dc9\u0dcb-\u0dce\u0dd5\u0dd7\u0de0-\u0df1\u0df5-\u0f69\u0f6b-\u0f95\u0f97-\u0fad\u0fb1-\u0fb7\u0fb9\u0fbd\u0fcd-\u0fce\u0fd0-\u0fff\u1022\u1028\u102b\u1033-\u1035\u103a-\u103f\u105a-\u11ff\u1207\u1247\u1249\u124e-\u124f\u1257\u1259\u125e-\u125f\u1287\u1289\u128e-\u128f\u12af\u12b1\u12b6-\u12b7\u12bf\u12c1\u12c6-\u12c7\u12cf\u12d7\u12ef\u130f\u1311\u1316-\u1317\u131f\u1347\u135b-\u1360\u137d-\u139f\u13f5-\u1400\u1677-\u167f\u169d-\u169f\u16f1-\u177f\u17dd-\u17df\u17ea-\u17ff\u180f\u181a-\u181f\u1878-\u187f\u18aa-\u202e\u2030-\u2047\u204e-\u20ac\u20b0-\u20e1\u20e4-\u2138\u213b-\u2182\u2184-\u21ea\u21f4-\u2300\u2302-\u237a\u237c\u239b-\u2424\u2427-\u25ef\u25f8-\u2618\u261a-\u266f\u2672-\u27ff\u2900-\u2e7f\u2e9a\u2ef4-\u2eff\u2fd6-\u2fef\u2ffc-\u3037\u303b-\u303d\u303f-\u319f\u31b8-\u33ff\u4db6-\u9fff\ua48d-\ua48f\ua4a2-\ua4a3\ua4b4\ua4c1\ua4c5\ua4c7-\ufb1c\ufb1e-\ufff8\ufffc-\U0010ffff",
    "^3.1": "\x00-\u03f3\u03f6-\ufdcf\ufdf0-\U000102ff\U0001031f\U00010324-\U0001032f\U0001034b-\U000103ff\U00010426-\U00010427\U0001044e-\U0001cfff\U0001d0f6-\U0001d0ff\U0001d127-\U0001d129\U0001d1de-\U0001d3ff\U0001d455\U0001d49d\U0001d4a0-\U0001d4a1\U0001d4a3-\U0001d4a4\U0001d4a7-\U0001d4a8\U0001d4ad\U0001d4ba\U0001d4bc\U0001d4c1\U0001d4c4\U0001d506\U0001d50b-\U0001d50c\U0001d515\U0001d51d\U0001d53a\U0001d53f\U0001d545\U0001d547-\U0001d549\U0001d551\U0001d6a4-\U0001d6a7\U0001d7ca-\U0001d7cd\U0001d800-\U0001ffff\U0002a6d7-\U0002f7ff\U0002fa1e-\U000e0000\U000e0002-\U000e001f\U000e0080-\U0010ffff",
    "^3.2": "\x00-\u021f\u0221-\u034e\u0350-\u0362\u0370-\u03d7\u03da-\u03f5\u03f7-\u0489\u048c-\u04c4\u04c7-\u04c8\u04cb-\u04cc\u04cf-\u04ff\u0510-\u066d\u0670-\u07b0\u07b2-\u10f6\u10f9-\u16ff\u170d\u1715-\u171f\u1737-\u173f\u1754-\u175f\u176d\u1771\u1774-\u2046\u2048-\u204d\u2053-\u2056\u2058-\u205e\u2064-\u2070\u2072-\u20af\u20b2-\u20e3\u20eb-\u213c\u214c-\u21f3\u2200-\u22f1\u2300-\u237b\u237d-\u239a\u23cf-\u24ea\u24ff-\u2595\u25a0-\u25f7\u2600-\u2615\u2618-\u2671\u267e-\u267f\u268a-\u2767\u2776-\u27cf\u27ec-\u27ef\u2800-\u28ff\u2b00-\u303a\u303e-\u3094\u3097-\u309e\u30a1-\u30fe\u3100-\u31ef\u3200-\u3250\u3260-\u32b0\u32c0-\ua4a1\ua4a4-\ua4b3\ua4b5-\ua4c0\ua4c2-\ua4c4\ua4c6-\ufa2f\ufa6b-\ufdfb\ufdfd-\ufdff\ufe10-\ufe44\ufe47-\ufe72\ufe74-\uff5e\uff61-\U0010ffff",
    "^4.0": "\x00-\u0220\u0222-\u0233\u0237-\u02ad\u02b0-\u02ee\u0300-\u034f\u0358-\u035c\u0360-\u03f6\u03fc-\u05ff\u0604-\u060c\u0616-\u0655\u0659-\u06ed\u06f0-\u06fe\u0700-\u072c\u0730-\u074c\u0750-\u0903\u0905-\u09bc\u09be-\u0a00\u0a02\u0a04-\u0a8b\u0a8d-\u0ae0\u0ae4-\u0af0\u0af2-\u0b34\u0b36-\u0b70\u0b72-\u0bf2\u0bfb-\u0cbb\u0cbe-\u17dc\u17de-\u17ef\u17fa-\u18ff\u191d-\u191f\u192c-\u192f\u193c-\u193f\u1941-\u1943\u196e-\u196f\u1975-\u19df\u1a00-\u1cff\u1d6c-\u2052\u2055-\u213a\u213c-\u23ce\u23d1-\u24fe\u2500-\u2613\u2616-\u2689\u2692-\u269f\u26a2-\u2aff\u2b0e-\u321c\u321f-\u324f\u3251-\u327b\u327e-\u32cb\u32d0-\u3376\u337b-\u33dd\u33e0-\u33fe\u3400-\u4dbf\u4e00-\ufdfc\ufdfe-\ufe46\ufe49-\uffff\U0001000c\U00010027\U0001003b\U0001003e\U0001004e-\U0001004f\U0001005e-\U0001007f\U000100fb-\U000100ff\U00010103-\U00010106\U00010134-\U00010136\U00010140-\U0001037f\U0001039e\U000103a0-\U00010425\U00010428-\U0001044d\U0001049e-\U0001049f\U000104aa-\U000107ff\U00010806-\U00010807\U00010809\U00010836\U00010839-\U0001083b\U0001083d-\U0001083e\U00010840-\U0001d2ff\U0001d357-\U0001d4c0\U0001d4c2-\U000e00ff\U000e01f0-\U0010ffff",
    "^4.1": "\x00-\u0236\u0242-\u0357\u035d-\u03fb\u0400-\u04f5\u04f8-\u05a1\u05a3-\u05c4\u05c8-\u060a\u060c-\u061d\u061f-\u0658\u065f-\u074f\u076e-\u097c\u097e-\u09cd\u09cf-\u0bb5\u0bb7-\u0be5\u0be7-\u0fcf\u0fd2-\u10f8\u10fb\u10fd-\u1206\u1208-\u1246\u1248-\u1286\u1288-\u12ae\u12b0-\u12ce\u12d0-\u12ee\u12f0-\u130e\u1310-\u131e\u1320-\u1346\u1348-\u135e\u1361-\u137f\u139a-\u197f\u19aa-\u19af\u19ca-\u19cf\u19da-\u19dd\u19e0-\u19ff\u1a1c-\u1a1d\u1a20-\u1d6b\u1dc4-\u2054\u2057\u205f-\u208f\u2095-\u20b1\u20b6-\u20ea\u20ec-\u213b\u213d-\u214b\u214d-\u23d0\u23dc-\u2617\u2619-\u267d\u2680-\u2691\u269d-\u26a1\u26b2-\u27bf\u27c7-\u2b0d\u2b14-\u2bff\u2c2f\u2c5f-\u2c7f\u2ceb-\u2cf8\u2d26-\u2d2f\u2d66-\u2d6e\u2d70-\u2d7f\u2d97-\u2d9f\u2da7\u2daf\u2db7\u2dbf\u2dc7\u2dcf\u2dd7\u2ddf-\u2dff\u2e18-\u2e1b\u2e1e-\u31bf\u31d0-\u327d\u327f-\u9fa5\u9fbc-\ua6ff\ua717-\ua7ff\ua82c-\ufa6f\ufada-\ufe0f\ufe1a-\U0001013f\U0001018b-\U0001039f\U000103c4-\U000103c7\U000103d6-\U000109ff\U00010a04\U00010a07-\U00010a0b\U00010a14\U00010a18\U00010a34-\U00010a37\U00010a3b-\U00010a3e\U00010a48-\U00010a4f\U00010a59-\U0001d1ff\U0001d246-\U0001d6a3\U0001d6a6-\U0010ffff",
    "^5.0": "\x00-\u0241\u0250-\u037a\u037e-\u04ce\u04d0-\u04f9\u0500-\u050f\u0514-\u05b9\u05bb-\u07bf\u07fb-\u097a\u097d\u0980-\u0ce1\u0ce4-\u0cf0\u0cf3-\u1aff\u1b4c-\u1b4f\u1b7d-\u1dc3\u1dcb-\u1dfd\u1e00-\u20eb\u20f0-\u214c\u214f-\u2183\u2185-\u23db\u23e8-\u26b1\u26b3-\u27c6\u27cb-\u2b13\u2b1b-\u2b1f\u2b24-\u2c5f\u2c6d-\u2c73\u2c78-\ua716\ua71b-\ua71f\ua722-\ua83f\ua878-\U000108ff\U0001091a-\U0001091e\U00010920-\U00011fff\U0001236f-\U000123ff\U00012463-\U0001246f\U00012474-\U0001d35f\U0001d372-\U0001d7c9\U0001d7cc-\U0010ffff",
    "^5.1": "\x00-\u036f\u0374-\u0375\u0378-\u03ce\u03d0-\u0486\u0488-\u0513\u0524-\u0605\u060b-\u0615\u061b-\u063a\u0640-\u076d\u0780-\u0970\u0973-\u0a50\u0a52-\u0a74\u0a76-\u0b43\u0b45-\u0b61\u0b64-\u0bcf\u0bd1-\u0c3c\u0c3e-\u0c57\u0c5a-\u0c61\u0c64-\u0c77\u0c80-\u0d3c\u0d3e-\u0d43\u0d45-\u0d61\u0d64-\u0d6f\u0d76-\u0d78\u0d80-\u0f6a\u0f6d-\u0fcd\u0fcf-\u0fd1\u0fd5-\u1021\u1023-\u1027\u1029-\u102a\u102c-\u1032\u1036-\u1039\u1040-\u1059\u109a-\u109d\u10a0-\u18a9\u18ab-\u1b7f\u1bab-\u1bad\u1bba-\u1bff\u1c38-\u1c3a\u1c4a-\u1c4c\u1c80-\u1dca\u1de7-\u1e9b\u1ea0-\u1ef9\u1f00-\u2063\u2065-\u20ef\u20f1-\u214e\u2150-\u2184\u2189-\u269c\u269e-\u26b2\u26bd-\u26bf\u26c4-\u27cb\u27cd-\u27eb\u27f0-\u2b1a\u2b20-\u2b23\u2b4d-\u2b4f\u2b55-\u2c6c\u2c70\u2c74-\u2c77\u2c7e-\u2ddf\u2e00-\u2e17\u2e1c-\u2e1d\u2e31-\u312c\u312e-\u31cf\u31e4-\u9fbb\u9fc4-\ua4ff\ua62c-\ua63f\ua660-\ua661\ua674-\ua67b\ua698-\ua71a\ua720-\ua721\ua78d-\ua7fa\ua800-\ua87f\ua8c5-\ua8cd\ua8da-\ua8ff\ua954-\ua95e\ua960-\ua9ff\uaa37-\uaa3f\uaa4e-\uaa4f\uaa5a-\uaa5b\uaa60-\ufe23\ufe27-\U0001018f\U0001019c-\U000101cf\U000101fe-\U0001027f\U0001029d-\U0001029f\U000102d1-\U0001091f\U0001093a-\U0001093e\U00010940-\U0001d128\U0001d12a-\U0001efff\U0001f02c-\U0001f02f\U0001f094-\U0010ffff",
    "^5.2": "\x00-\u0523\u0526-\u07ff\u082e-\u082f\u083f-\u08ff\u0901-\u094d\u094f-\u0954\u0956-\u0978\u097b-\u09fa\u09fc-\u0fd4\u0fd9-\u1099\u109e-\u1159\u115f-\u11a2\u11a8-\u11f9\u1200-\u13ff\u1401-\u1676\u1680-\u18af\u18f6-\u19a9\u19ac-\u19d9\u19db-\u1a1f\u1a5f\u1a7d-\u1a7e\u1a8a-\u1a8f\u1a9a-\u1a9f\u1aae-\u1ccf\u1cf3-\u1dfc\u1dfe-\u20b5\u20b9-\u214f\u2153-\u2188\u218a-\u23e7\u23e9-\u269d\u26a0-\u26bc\u26c0-\u26c3\u26ce\u26e2\u26e4-\u26e7\u2700-\u2756\u2758-\u2b54\u2b5a-\u2c6f\u2c71-\u2c7d\u2c80-\u2cea\u2cf2-\u2e30\u2e32-\u3243\u3250-\u9fc3\u9fcc-\ua4cf\ua500-\ua69f\ua6f8-\ua82f\ua83a-\ua8df\ua8fc-\ua95f\ua97d-\ua97f\ua9ce\ua9da-\ua9dd\ua9e0-\uaa5f\uaa7c-\uaa7f\uaac3-\uaada\uaae0-\uabbf\uabee-\uabef\uabfa-\ud7af\ud7c7-\ud7ca\ud7fc-\ufa6a\ufa6e-\U0001083f\U00010856\U00010860-\U00010919\U0001091c-\U00010a5f\U00010a80-\U00010aff\U00010b36-\U00010b38\U00010b56-\U00010b57\U00010b73-\U00010b77\U00010b80-\U00010bff\U00010c49-\U00010e5f\U00010e7f-\U0001107f\U000110c2-\U00012fff\U0001342f-\U0001f0ff\U0001f10b-\U0001f10f\U0001f12f-\U0001f130\U0001f132-\U0001f13c\U0001f13e\U0001f140-\U0001f141\U0001f143-\U0001f145\U0001f147-\U0001f149\U0001f14f-\U0001f156\U0001f158-\U0001f15e\U0001f160-\U0001f178\U0001f17a\U0001f17d-\U0001f17e\U0001f180-\U0001f189\U0001f18e-\U0001f18f\U0001f191-\U0001f1ff\U0001f201-\U0001f20f\U0001f232-\U0001f23f\U0001f249-\U0002a6ff\U0002b735-\U0010ffff",
    "^6.0": "\x00-\u0525\u0528-\u061f\u0621-\u065e\u0660-\u083f\u085c-\u085d\u085f-\u0939\u093c-\u094e\u0950-\u0955\u0958-\u0972\u0978-\u0b71\u0b78-\u0d28\u0d2a-\u0d39\u0d3b-\u0d4d\u0d4f-\u0f8b\u0f90-\u0fd8\u0fdb-\u135c\u135f-\u1bbf\u1bf4-\u1bfb\u1c00-\u1dfb\u1dfd-\u2094\u209d-\u20b8\u20ba-\u23e8\u23f4-\u26cd\u26cf-\u26e1\u26e3\u26e8-\u2704\u2706-\u2709\u270c-\u2727\u2729-\u274b\u274d\u274f-\u2752\u2756-\u275e\u2761-\u2794\u2798-\u27af\u27b1-\u27be\u27c0-\u27cd\u27d0-\u2d6f\u2d71-\u2d7e\u2d80-\u31b7\u31bb-\ua65f\ua662-\ua78c\ua78f\ua792-\ua79f\ua7aa-\ua7f9\ua7fb-\uab00\uab07-\uab08\uab0f-\uab10\uab17-\uab1f\uab27\uab2f-\ufbb1\ufbc2-\U00010fff\U0001104e-\U00011051\U00011070-\U000167ff\U00016a39-\U0001afff\U0001b002-\U0001f09f\U0001f0af-\U0001f0b0\U0001f0bf-\U0001f0c0\U0001f0d0\U0001f0e0-\U0001f12f\U0001f131\U0001f13d\U0001f13f\U0001f142\U0001f146\U0001f14a-\U0001f14e\U0001f157\U0001f15f\U0001f16a-\U0001f16f\U0001f179\U0001f17b-\U0001f17c\U0001f17f\U0001f18a-\U0001f18d\U0001f190\U0001f19b-\U0001f1e5\U0001f200\U0001f203-\U0001f231\U0001f23b-\U0001f24f\U0001f252-\U0001f2ff\U0001f321-\U0001f32f\U0001f336\U0001f37d-\U0001f37f\U0001f394-\U0001f39f\U0001f3c5\U0001f3cb-\U0001f3df\U0001f3f1-\U0001f3ff\U0001f43f\U0001f441\U0001f4f8\U0001f4fd-\U0001f4ff\U0001f53e-\U0001f54f\U0001f568-\U0001f5fa\U0001f600\U0001f611\U0001f615\U0001f617\U0001f619\U0001f61b\U0001f61f\U0001f626-\U0001f627\U0001f62c\U0001f62e-\U0001f62f\U0001f634\U0001f641-\U0001f644\U0001f650-\U0001f67f\U0001f6c6-\U0001f6ff\U0001f774-\U0002b73f\U0002b81e-\U0010ffff",
    "^6.1": "\x00-\u058e\u0590-\u0603\u0605-\u089f\u08a1\u08ad-\u08e3\u08ff-\u0aef\u0af1-\u0edd\u0ee0-\u10c6\u10c8-\u10cc\u10ce-\u10fc\u1100-\u1baa\u1bae-\u1bb9\u1bc0-\u1cbf\u1cc8-\u1cf2\u1cf7-\u27ca\u27cc\u27ce-\u2cf1\u2cf4-\u2d26\u2d28-\u2d2c\u2d2e-\u2d65\u2d68-\u2e31\u2e3c-\u9fcb\u9fcd-\ua673\ua67c-\ua69e\ua6a0-\ua791\ua794-\ua7a9\ua7ab-\ua7f7\ua7fa-\uaadf\uaaf7-\ufa2d\ufa30-\U0001097f\U000109b8-\U000109bd\U000109c0-\U000110cf\U000110e9-\U000110ef\U000110fa-\U000110ff\U00011135\U00011144-\U0001117f\U000111c9-\U000111cf\U000111da-\U0001167f\U000116b8-\U000116bf\U000116ca-\U00016eff\U00016f45-\U00016f4f\U00016f7f-\U00016f8e\U00016fa0-\U0001edff\U0001ee04\U0001ee20\U0001ee23\U0001ee25-\U0001ee26\U0001ee28\U0001ee33\U0001ee38\U0001ee3a\U0001ee3c-\U0001ee41\U0001ee43-\U0001ee46\U0001ee48\U0001ee4a\U0001ee4c\U0001ee50\U0001ee53\U0001ee55-\U0001ee56\U0001ee58\U0001ee5a\U0001ee5c\U0001ee5e\U0001ee60\U0001ee63\U0001ee65-\U0001ee66\U0001ee6b\U0001ee73\U0001ee78\U0001ee7d\U0001ee7f\U0001ee8a\U0001ee9c-\U0001eea0\U0001eea4\U0001eeaa\U0001eebc-\U0001eeef\U0001eef2-\U0001f169\U0001f16c-\U0001f53f\U0001f544-\U0001f5ff\U0001f601-\U0001f610\U0001f612-\U0001f614\U0001f616\U0001f618\U0001f61a\U0001f61c-\U0001f61e\U0001f620-\U0001f625\U0001f628-\U0001f62b\U0001f62d\U0001f630-\U0001f633\U0001f635-\U0010ffff",
    "^6.2": "\x00-\u20b9\u20bb-\U0010ffff",
    "^6.3": "\x00-\u061b\u061d-\u2065\u206a-\U0010ffff",
    "^7.0": "\x00-\u037e\u0380-\u0527\u0530-\u058c\u058f-\u0604\u0606-\u08a0\u08a2-\u08ac\u08b3-\u08fe\u0900-\u0977\u0979-\u097f\u0981-\u0bff\u0c01-\u0c33\u0c35-\u0c80\u0c82-\u0d00\u0d02-\u0de5\u0df0-\u16f0\u16f9-\u191c\u191f-\u1aaf\u1abf-\u1cf7\u1cfa-\u1de6\u1df6-\u20ba\u20be-\u23f3\u23fb-\u26ff\u2701-\u2b4c\u2b50-\u2b59\u2b74-\u2b75\u2b96-\u2b97\u2bba-\u2bbc\u2bc9\u2bd2-\u2e3b\u2e43-\ua697\ua69e-\ua793\ua7a0-\ua7aa\ua7ae-\ua7af\ua7b2-\ua7f6\ua7f8-\ua9df\ua9ff-\uaa7b\uaa80-\uab2f\uab60-\uab63\uab66-\ufe26\ufe2e-\U0001018a\U0001018d-\U0001019f\U000101a1-\U000102df\U000102fc-\U0001031e\U00010320-\U0001034f\U0001037b-\U000104ff\U00010528-\U0001052f\U00010564-\U0001056e\U00010570-\U000105ff\U00010737-\U0001073f\U00010756-\U0001075f\U00010768-\U0001085f\U0001089f-\U000108a6\U000108b0-\U00010a7f\U00010aa0-\U00010abf\U00010ae7-\U00010aea\U00010af7-\U00010b7f\U00010b92-\U00010b98\U00010b9d-\U00010ba8\U00010bb0-\U0001107e\U00011080-\U0001114f\U00011177-\U000111cc\U000111ce-\U000111d9\U000111db-\U000111e0\U000111f5-\U000111ff\U00011212\U0001123e-\U000112af\U000112eb-\U000112ef\U000112fa-\U00011300\U00011304\U0001130d-\U0001130e\U00011311-\U00011312\U00011329\U00011331\U00011334\U0001133a-\U0001133b\U00011345-\U00011346\U00011349-\U0001134a\U0001134e-\U00011356\U00011358-\U0001135c\U00011364-\U00011365\U0001136d-\U0001136f\U00011375-\U0001147f\U000114c8-\U000114cf\U000114da-\U0001157f\U000115b6-\U000115b7\U000115ca-\U000115ff\U00011645-\U0001164f\U0001165a-\U0001189f\U000118f3-\U000118fe\U00011900-\U00011abf\U00011af9-\U0001236e\U00012399-\U00012462\U0001246f-\U00012473\U00012475-\U00016a3f\U00016a5f\U00016a6a-\U00016a6d\U00016a70-\U00016acf\U00016aee-\U00016aef\U00016af6-\U00016aff\U00016b46-\U00016b4f\U00016b5a\U00016b62\U00016b78-\U00016b7c\U00016b90-\U0001bbff\U0001bc6b-\U0001bc6f\U0001bc7d-\U0001bc7f\U0001bc89-\U0001bc8f\U0001bc9a-\U0001bc9b\U0001bca4-\U0001e7ff\U0001e8c5-\U0001e8c6\U0001e8d7-\U0001f0be\U0001f0c0-\U0001f0df\U0001f0f6-\U0001f10a\U0001f10d-\U0001f320\U0001f32d-\U0001f335\U0001f337-\U0001f37c\U0001f37e-\U0001f393\U0001f3a0-\U0001f3c4\U0001f3c6-\U0001f3ca\U0001f3cf-\U0001f3d3\U0001f3e0-\U0001f3f0\U0001f3f8-\U0001f43e\U0001f440\U0001f442-\U0001f4f7\U0001f4f9-\U0001f4fc\U0001f4ff-\U0001f53d\U0001f540-\U0001f543\U0001f54b-\U0001f567\U0001f57a\U0001f5a4\U0001f5fb-\U0001f640\U0001f643-\U0001f64f\U0001f680-\U0001f6c5\U0001f6d0-\U0001f6df\U0001f6ed-\U0001f6ef\U0001f6f4-\U0001f77f\U0001f7d5-\U0001f7ff\U0001f80c-\U0001f80f\U0001f848-\U0001f84f\U0001f85a-\U0001f85f\U0001f888-\U0001f88f\U0001f8ae-\U0010ffff",
    "^8.0": "\x00-\u08b2\u08b5-\u08e2\u08e4-\u0af8\u0afa-\u0c59\u0c5b-\u0d5e\u0d60-\u13f4\u13f6-\u13f7\u13fe-\u20bd\u20bf-\u2189\u218c-\u2beb\u2bf0-\u9fcc\u9fd6-\ua69d\ua69f-\ua78e\ua790-\ua7b1\ua7b8-\ua8fb\ua8fe-\uab5f\uab64-\uab6f\uabc0-\ufe2d\ufe30-\U000108df\U000108f3\U000108f6-\U000108fa\U00010900-\U000109bb\U000109be-\U000109bf\U000109d0-\U000109d1\U00010a00-\U00010c7f\U00010cb3-\U00010cbf\U00010cf3-\U00010cf9\U00010d00-\U000111c8\U000111cd-\U000111da\U000111e0-\U0001127f\U00011287\U00011289\U0001128e\U0001129e\U000112aa-\U000112ff\U00011301-\U0001134f\U00011351-\U000115c9\U000115de-\U000116ff\U0001171a-\U0001171c\U0001172c-\U0001172f\U00011740-\U00012398\U0001239a-\U0001247f\U00012544-\U000143ff\U00014647-\U0001d1dd\U0001d1e9-\U0001d7ff\U0001da8c-\U0001da9a\U0001daa0\U0001dab0-\U0001f32c\U0001f330-\U0001f37d\U0001f380-\U0001f3ce\U0001f3d4-\U0001f3f7\U0001f400-\U0001f4fe\U0001f500-\U0001f54a\U0001f550-\U0001f642\U0001f645-\U0001f6cf\U0001f6d1-\U0001f90f\U0001f919-\U0001f97f\U0001f985-\U0001f9bf\U0001f9c1-\U0002b81f\U0002cea2-\U0010ffff",
    "^9.0": "\x00-\u08b5\u08be-\u08d3\u08e3-\u0c7f\u0c81-\u0d4e\u0d50-\u0d53\u0d57\u0d5f-\u0d75\u0d79-\u1c7f\u1c89-\u1dfa\u1dfc-\u23fa\u23ff-\u2e42\u2e45-\ua7ad\ua7af-\ua8c4\ua8c6-\U0001018c\U0001018f-\U000104af\U000104d4-\U000104d7\U000104fc-\U0001123d\U0001123f-\U000113ff\U0001145a\U0001145c\U0001145e-\U0001165f\U0001166d-\U00011bff\U00011c09\U00011c37\U00011c46-\U00011c4f\U00011c6d-\U00011c6f\U00011c90-\U00011c91\U00011ca8\U00011cb7-\U00016fdf\U00016fe1-\U00016fff\U000187ed-\U000187ff\U00018af3-\U0001dfff\U0001e007\U0001e019-\U0001e01a\U0001e022\U0001e025\U0001e02b-\U0001e8ff\U0001e94b-\U0001e94f\U0001e95a-\U0001e95d\U0001e960-\U0001f19a\U0001f1ad-\U0001f23a\U0001f23c-\U0001f579\U0001f57b-\U0001f5a3\U0001f5a5-\U0001f6d0\U0001f6d3-\U0001f6f3\U0001f6f7-\U0001f918\U0001f91f\U0001f928-\U0001f92f\U0001f931-\U0001f932\U0001f93f\U0001f94c-\U0001f94f\U0001f95f-\U0001f984\U0001f992-\U0010ffff",
    "^na": "\x00-\u0377\u037a-\u037f\u0384-\u038a\u038c\u038e-\u03a1\u03a3-\u052f\u0531-\u0556\u0559-\u058a\u058d-\u058f\u0591-\u05c7\u05d0-\u05ea\u05ef-\u05f4\u0600-\u061c\u061e-\u070d\u070f-\u074a\u074d-\u07b1\u07c0-\u07fa\u07fd-\u082d\u0830-\u083e\u0840-\u085b\u085e\u0860-\u086a\u08a0-\u08b4\u08b6-\u08bd\u08d3-\u0983\u0985-\u098c\u098f-\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bc-\u09c4\u09c7-\u09c8\u09cb-\u09ce\u09d7\u09dc-\u09dd\u09df-\u09e3\u09e6-\u09fe\u0a01-\u0a03\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a3c\u0a3e-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a51\u0a59-\u0a5c\u0a5e\u0a66-\u0a76\u0a81-\u0a83\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0abc-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ad0\u0ae0-\u0ae3\u0ae6-\u0af1\u0af9-\u0aff\u0b01-\u0b03\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b35-\u0b39\u0b3c-\u0b44\u0b47-\u0b48\u0b4b-\u0b4d\u0b56-\u0b57\u0b5c-\u0b5d\u0b5f-\u0b63\u0b66-\u0b77\u0b82-\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99-\u0b9a\u0b9c\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd0\u0bd7\u0be6-\u0bfa\u0c00-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c58-\u0c5a\u0c60-\u0c63\u0c66-\u0c6f\u0c77-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbc-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5-\u0cd6\u0cde\u0ce0-\u0ce3\u0ce6-\u0cef\u0cf1-\u0cf2\u0d00-\u0d03\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d44\u0d46-\u0d48\u0d4a-\u0d4f\u0d54-\u0d63\u0d66-\u0d7f\u0d82-\u0d83\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2-\u0df4\u0e01-\u0e3a\u0e3f-\u0e5b\u0e81-\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0ebd\u0ec0-\u0ec4\u0ec6\u0ec8-\u0ecd\u0ed0-\u0ed9\u0edc-\u0edf\u0f00-\u0f47\u0f49-\u0f6c\u0f71-\u0f97\u0f99-\u0fbc\u0fbe-\u0fcc\u0fce-\u0fda\u1000-\u10c5\u10c7\u10cd\u10d0-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u135d-\u137c\u1380-\u1399\u13a0-\u13f5\u13f8-\u13fd\u1400-\u169c\u16a0-\u16f8\u1700-\u170c\u170e-\u1714\u1720-\u1736\u1740-\u1753\u1760-\u176c\u176e-\u1770\u1772-\u1773\u1780-\u17dd\u17e0-\u17e9\u17f0-\u17f9\u1800-\u180e\u1810-\u1819\u1820-\u1878\u1880-\u18aa\u18b0-\u18f5\u1900-\u191e\u1920-\u192b\u1930-\u193b\u1940\u1944-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u19d0-\u19da\u19de-\u1a1b\u1a1e-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1aa0-\u1aad\u1ab0-\u1abe\u1b00-\u1b4b\u1b50-\u1b7c\u1b80-\u1bf3\u1bfc-\u1c37\u1c3b-\u1c49\u1c4d-\u1c88\u1c90-\u1cba\u1cbd-\u1cc7\u1cd0-\u1cfa\u1d00-\u1df9\u1dfb-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fc4\u1fc6-\u1fd3\u1fd6-\u1fdb\u1fdd-\u1fef\u1ff2-\u1ff4\u1ff6-\u1ffe\u2000-\u2064\u2066-\u2071\u2074-\u208e\u2090-\u209c\u20a0-\u20bf\u20d0-\u20f0\u2100-\u218b\u2190-\u2426\u2440-\u244a\u2460-\u2b73\u2b76-\u2b95\u2b98-\u2c2e\u2c30-\u2c5e\u2c60-\u2cf3\u2cf9-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f-\u2d70\u2d7f-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2de0-\u2e4f\u2e80-\u2e99\u2e9b-\u2ef3\u2f00-\u2fd5\u2ff0-\u2ffb\u3000-\u303f\u3041-\u3096\u3099-\u30ff\u3105-\u312f\u3131-\u318e\u3190-\u31ba\u31c0-\u31e3\u31f0-\u321e\u3220-\u4db5\u4dc0-\u9fef\ua000-\ua48c\ua490-\ua4c6\ua4d0-\ua62b\ua640-\ua6f7\ua700-\ua7bf\ua7c2-\ua7c6\ua7f7-\ua82b\ua830-\ua839\ua840-\ua877\ua880-\ua8c5\ua8ce-\ua8d9\ua8e0-\ua953\ua95f-\ua97c\ua980-\ua9cd\ua9cf-\ua9d9\ua9de-\ua9fe\uaa00-\uaa36\uaa40-\uaa4d\uaa50-\uaa59\uaa5c-\uaac2\uaadb-\uaaf6\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab67\uab70-\uabed\uabf0-\uabf9\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\ud800-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbc1\ufbd3-\ufd3f\ufd50-\ufd8f\ufd92-\ufdc7\ufdd0-\ufdfd\ufe00-\ufe19\ufe20-\ufe52\ufe54-\ufe66\ufe68-\ufe6b\ufe70-\ufe74\ufe76-\ufefc\ufeff\uff01-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\uffe0-\uffe6\uffe8-\uffee\ufff9-\U0001000b\U0001000d-\U00010026\U00010028-\U0001003a\U0001003c-\U0001003d\U0001003f-\U0001004d\U00010050-\U0001005d\U00010080-\U000100fa\U00010100-\U00010102\U00010107-\U00010133\U00010137-\U0001018e\U00010190-\U0001019b\U000101a0\U000101d0-\U000101fd\U00010280-\U0001029c\U000102a0-\U000102d0\U000102e0-\U000102fb\U00010300-\U00010323\U0001032d-\U0001034a\U00010350-\U0001037a\U00010380-\U0001039d\U0001039f-\U000103c3\U000103c8-\U000103d5\U00010400-\U0001049d\U000104a0-\U000104a9\U000104b0-\U000104d3\U000104d8-\U000104fb\U00010500-\U00010527\U00010530-\U00010563\U0001056f\U00010600-\U00010736\U00010740-\U00010755\U00010760-\U00010767\U00010800-\U00010805\U00010808\U0001080a-\U00010835\U00010837-\U00010838\U0001083c\U0001083f-\U00010855\U00010857-\U0001089e\U000108a7-\U000108af\U000108e0-\U000108f2\U000108f4-\U000108f5\U000108fb-\U0001091b\U0001091f-\U00010939\U0001093f\U00010980-\U000109b7\U000109bc-\U000109cf\U000109d2-\U00010a03\U00010a05-\U00010a06\U00010a0c-\U00010a13\U00010a15-\U00010a17\U00010a19-\U00010a35\U00010a38-\U00010a3a\U00010a3f-\U00010a48\U00010a50-\U00010a58\U00010a60-\U00010a9f\U00010ac0-\U00010ae6\U00010aeb-\U00010af6\U00010b00-\U00010b35\U00010b39-\U00010b55\U00010b58-\U00010b72\U00010b78-\U00010b91\U00010b99-\U00010b9c\U00010ba9-\U00010baf\U00010c00-\U00010c48\U00010c80-\U00010cb2\U00010cc0-\U00010cf2\U00010cfa-\U00010d27\U00010d30-\U00010d39\U00010e60-\U00010e7e\U00010f00-\U00010f27\U00010f30-\U00010f59\U00010fe0-\U00010ff6\U00011000-\U0001104d\U00011052-\U0001106f\U0001107f-\U000110c1\U000110cd\U000110d0-\U000110e8\U000110f0-\U000110f9\U00011100-\U00011134\U00011136-\U00011146\U00011150-\U00011176\U00011180-\U000111cd\U000111d0-\U000111df\U000111e1-\U000111f4\U00011200-\U00011211\U00011213-\U0001123e\U00011280-\U00011286\U00011288\U0001128a-\U0001128d\U0001128f-\U0001129d\U0001129f-\U000112a9\U000112b0-\U000112ea\U000112f0-\U000112f9\U00011300-\U00011303\U00011305-\U0001130c\U0001130f-\U00011310\U00011313-\U00011328\U0001132a-\U00011330\U00011332-\U00011333\U00011335-\U00011339\U0001133b-\U00011344\U00011347-\U00011348\U0001134b-\U0001134d\U00011350\U00011357\U0001135d-\U00011363\U00011366-\U0001136c\U00011370-\U00011374\U00011400-\U00011459\U0001145b\U0001145d-\U0001145f\U00011480-\U000114c7\U000114d0-\U000114d9\U00011580-\U000115b5\U000115b8-\U000115dd\U00011600-\U00011644\U00011650-\U00011659\U00011660-\U0001166c\U00011680-\U000116b8\U000116c0-\U000116c9\U00011700-\U0001171a\U0001171d-\U0001172b\U00011730-\U0001173f\U00011800-\U0001183b\U000118a0-\U000118f2\U000118ff\U000119a0-\U000119a7\U000119aa-\U000119d7\U000119da-\U000119e4\U00011a00-\U00011a47\U00011a50-\U00011aa2\U00011ac0-\U00011af8\U00011c00-\U00011c08\U00011c0a-\U00011c36\U00011c38-\U00011c45\U00011c50-\U00011c6c\U00011c70-\U00011c8f\U00011c92-\U00011ca7\U00011ca9-\U00011cb6\U00011d00-\U00011d06\U00011d08-\U00011d09\U00011d0b-\U00011d36\U00011d3a\U00011d3c-\U00011d3d\U00011d3f-\U00011d47\U00011d50-\U00011d59\U00011d60-\U00011d65\U00011d67-\U00011d68\U00011d6a-\U00011d8e\U00011d90-\U00011d91\U00011d93-\U00011d98\U00011da0-\U00011da9\U00011ee0-\U00011ef8\U00011fc0-\U00011ff1\U00011fff-\U00012399\U00012400-\U0001246e\U00012470-\U00012474\U00012480-\U00012543\U00013000-\U0001342e\U00013430-\U00013438\U00014400-\U00014646\U00016800-\U00016a38\U00016a40-\U00016a5e\U00016a60-\U00016a69\U00016a6e-\U00016a6f\U00016ad0-\U00016aed\U00016af0-\U00016af5\U00016b00-\U00016b45\U00016b50-\U00016b59\U00016b5b-\U00016b61\U00016b63-\U00016b77\U00016b7d-\U00016b8f\U00016e40-\U00016e9a\U00016f00-\U00016f4a\U00016f4f-\U00016f87\U00016f8f-\U00016f9f\U00016fe0-\U00016fe3\U00017000-\U000187f7\U00018800-\U00018af2\U0001b000-\U0001b11e\U0001b150-\U0001b152\U0001b164-\U0001b167\U0001b170-\U0001b2fb\U0001bc00-\U0001bc6a\U0001bc70-\U0001bc7c\U0001bc80-\U0001bc88\U0001bc90-\U0001bc99\U0001bc9c-\U0001bca3\U0001d000-\U0001d0f5\U0001d100-\U0001d126\U0001d129-\U0001d1e8\U0001d200-\U0001d245\U0001d2e0-\U0001d2f3\U0001d300-\U0001d356\U0001d360-\U0001d378\U0001d400-\U0001d454\U0001d456-\U0001d49c\U0001d49e-\U0001d49f\U0001d4a2\U0001d4a5-\U0001d4a6\U0001d4a9-\U0001d4ac\U0001d4ae-\U0001d4b9\U0001d4bb\U0001d4bd-\U0001d4c3\U0001d4c5-\U0001d505\U0001d507-\U0001d50a\U0001d50d-\U0001d514\U0001d516-\U0001d51c\U0001d51e-\U0001d539\U0001d53b-\U0001d53e\U0001d540-\U0001d544\U0001d546\U0001d54a-\U0001d550\U0001d552-\U0001d6a5\U0001d6a8-\U0001d7cb\U0001d7ce-\U0001da8b\U0001da9b-\U0001da9f\U0001daa1-\U0001daaf\U0001e000-\U0001e006\U0001e008-\U0001e018\U0001e01b-\U0001e021\U0001e023-\U0001e024\U0001e026-\U0001e02a\U0001e100-\U0001e12c\U0001e130-\U0001e13d\U0001e140-\U0001e149\U0001e14e-\U0001e14f\U0001e2c0-\U0001e2f9\U0001e2ff\U0001e800-\U0001e8c4\U0001e8c7-\U0001e8d6\U0001e900-\U0001e94b\U0001e950-\U0001e959\U0001e95e-\U0001e95f\U0001ec71-\U0001ecb4\U0001ed01-\U0001ed3d\U0001ee00-\U0001ee03\U0001ee05-\U0001ee1f\U0001ee21-\U0001ee22\U0001ee24\U0001ee27\U0001ee29-\U0001ee32\U0001ee34-\U0001ee37\U0001ee39\U0001ee3b\U0001ee42\U0001ee47\U0001ee49\U0001ee4b\U0001ee4d-\U0001ee4f\U0001ee51-\U0001ee52\U0001ee54\U0001ee57\U0001ee59\U0001ee5b\U0001ee5d\U0001ee5f\U0001ee61-\U0001ee62\U0001ee64\U0001ee67-\U0001ee6a\U0001ee6c-\U0001ee72\U0001ee74-\U0001ee77\U0001ee79-\U0001ee7c\U0001ee7e\U0001ee80-\U0001ee89\U0001ee8b-\U0001ee9b\U0001eea1-\U0001eea3\U0001eea5-\U0001eea9\U0001eeab-\U0001eebb\U0001eef0-\U0001eef1\U0001f000-\U0001f02b\U0001f030-\U0001f093\U0001f0a0-\U0001f0ae\U0001f0b1-\U0001f0bf\U0001f0c1-\U0001f0cf\U0001f0d1-\U0001f0f5\U0001f100-\U0001f10c\U0001f110-\U0001f16c\U0001f170-\U0001f1ac\U0001f1e6-\U0001f202\U0001f210-\U0001f23b\U0001f240-\U0001f248\U0001f250-\U0001f251\U0001f260-\U0001f265\U0001f300-\U0001f6d5\U0001f6e0-\U0001f6ec\U0001f6f0-\U0001f6fa\U0001f700-\U0001f773\U0001f780-\U0001f7d8\U0001f7e0-\U0001f7eb\U0001f800-\U0001f80b\U0001f810-\U0001f847\U0001f850-\U0001f859\U0001f860-\U0001f887\U0001f890-\U0001f8ad\U0001f900-\U0001f90b\U0001f90d-\U0001f971\U0001f973-\U0001f976\U0001f97a-\U0001f9a2\U0001f9a5-\U0001f9aa\U0001f9ae-\U0001f9ca\U0001f9cd-\U0001fa53\U0001fa60-\U0001fa6d\U0001fa70-\U0001fa73\U0001fa78-\U0001fa7a\U0001fa80-\U0001fa82\U0001fa90-\U0001fa95\U0001fffe-\U0002a6d6\U0002a700-\U0002b734\U0002b740-\U0002b81d\U0002b820-\U0002cea1\U0002ceb0-\U0002ebe0\U0002f800-\U0002fa1d\U0002fffe-\U0002ffff\U0003fffe-\U0003ffff\U0004fffe-\U0004ffff\U0005fffe-\U0005ffff\U0006fffe-\U0006ffff\U0007fffe-\U0007ffff\U0008fffe-\U0008ffff\U0009fffe-\U0009ffff\U000afffe-\U000affff\U000bfffe-\U000bffff\U000cfffe-\U000cffff\U000dfffe-\U000dffff\U000e0001\U000e0020-\U000e007f\U000e0100-\U000e01ef\U000efffe-\U0010ffff",
    "na": "\u0378-\u0379\u0380-\u0383\u038b\u038d\u03a2\u0530\u0557-\u0558\u058b-\u058c\u0590\u05c8-\u05cf\u05eb-\u05ee\u05f5-\u05ff\u061d\u070e\u074b-\u074c\u07b2-\u07bf\u07fb-\u07fc\u082e-\u082f\u083f\u085c-\u085d\u085f\u086b-\u089f\u08b5\u08be-\u08d2\u0984\u098d-\u098e\u0991-\u0992\u09a9\u09b1\u09b3-\u09b5\u09ba-\u09bb\u09c5-\u09c6\u09c9-\u09ca\u09cf-\u09d6\u09d8-\u09db\u09de\u09e4-\u09e5\u09ff-\u0a00\u0a04\u0a0b-\u0a0e\u0a11-\u0a12\u0a29\u0a31\u0a34\u0a37\u0a3a-\u0a3b\u0a3d\u0a43-\u0a46\u0a49-\u0a4a\u0a4e-\u0a50\u0a52-\u0a58\u0a5d\u0a5f-\u0a65\u0a77-\u0a80\u0a84\u0a8e\u0a92\u0aa9\u0ab1\u0ab4\u0aba-\u0abb\u0ac6\u0aca\u0ace-\u0acf\u0ad1-\u0adf\u0ae4-\u0ae5\u0af2-\u0af8\u0b00\u0b04\u0b0d-\u0b0e\u0b11-\u0b12\u0b29\u0b31\u0b34\u0b3a-\u0b3b\u0b45-\u0b46\u0b49-\u0b4a\u0b4e-\u0b55\u0b58-\u0b5b\u0b5e\u0b64-\u0b65\u0b78-\u0b81\u0b84\u0b8b-\u0b8d\u0b91\u0b96-\u0b98\u0b9b\u0b9d\u0ba0-\u0ba2\u0ba5-\u0ba7\u0bab-\u0bad\u0bba-\u0bbd\u0bc3-\u0bc5\u0bc9\u0bce-\u0bcf\u0bd1-\u0bd6\u0bd8-\u0be5\u0bfb-\u0bff\u0c0d\u0c11\u0c29\u0c3a-\u0c3c\u0c45\u0c49\u0c4e-\u0c54\u0c57\u0c5b-\u0c5f\u0c64-\u0c65\u0c70-\u0c76\u0c8d\u0c91\u0ca9\u0cb4\u0cba-\u0cbb\u0cc5\u0cc9\u0cce-\u0cd4\u0cd7-\u0cdd\u0cdf\u0ce4-\u0ce5\u0cf0\u0cf3-\u0cff\u0d04\u0d0d\u0d11\u0d45\u0d49\u0d50-\u0d53\u0d64-\u0d65\u0d80-\u0d81\u0d84\u0d97-\u0d99\u0db2\u0dbc\u0dbe-\u0dbf\u0dc7-\u0dc9\u0dcb-\u0dce\u0dd5\u0dd7\u0de0-\u0de5\u0df0-\u0df1\u0df5-\u0e00\u0e3b-\u0e3e\u0e5c-\u0e80\u0e83\u0e85\u0e8b\u0ea4\u0ea6\u0ebe-\u0ebf\u0ec5\u0ec7\u0ece-\u0ecf\u0eda-\u0edb\u0ee0-\u0eff\u0f48\u0f6d-\u0f70\u0f98\u0fbd\u0fcd\u0fdb-\u0fff\u10c6\u10c8-\u10cc\u10ce-\u10cf\u1249\u124e-\u124f\u1257\u1259\u125e-\u125f\u1289\u128e-\u128f\u12b1\u12b6-\u12b7\u12bf\u12c1\u12c6-\u12c7\u12d7\u1311\u1316-\u1317\u135b-\u135c\u137d-\u137f\u139a-\u139f\u13f6-\u13f7\u13fe-\u13ff\u169d-\u169f\u16f9-\u16ff\u170d\u1715-\u171f\u1737-\u173f\u1754-\u175f\u176d\u1771\u1774-\u177f\u17de-\u17df\u17ea-\u17ef\u17fa-\u17ff\u180f\u181a-\u181f\u1879-\u187f\u18ab-\u18af\u18f6-\u18ff\u191f\u192c-\u192f\u193c-\u193f\u1941-\u1943\u196e-\u196f\u1975-\u197f\u19ac-\u19af\u19ca-\u19cf\u19db-\u19dd\u1a1c-\u1a1d\u1a5f\u1a7d-\u1a7e\u1a8a-\u1a8f\u1a9a-\u1a9f\u1aae-\u1aaf\u1abf-\u1aff\u1b4c-\u1b4f\u1b7d-\u1b7f\u1bf4-\u1bfb\u1c38-\u1c3a\u1c4a-\u1c4c\u1c89-\u1c8f\u1cbb-\u1cbc\u1cc8-\u1ccf\u1cfb-\u1cff\u1dfa\u1f16-\u1f17\u1f1e-\u1f1f\u1f46-\u1f47\u1f4e-\u1f4f\u1f58\u1f5a\u1f5c\u1f5e\u1f7e-\u1f7f\u1fb5\u1fc5\u1fd4-\u1fd5\u1fdc\u1ff0-\u1ff1\u1ff5\u1fff\u2065\u2072-\u2073\u208f\u209d-\u209f\u20c0-\u20cf\u20f1-\u20ff\u218c-\u218f\u2427-\u243f\u244b-\u245f\u2b74-\u2b75\u2b96-\u2b97\u2c2f\u2c5f\u2cf4-\u2cf8\u2d26\u2d28-\u2d2c\u2d2e-\u2d2f\u2d68-\u2d6e\u2d71-\u2d7e\u2d97-\u2d9f\u2da7\u2daf\u2db7\u2dbf\u2dc7\u2dcf\u2dd7\u2ddf\u2e50-\u2e7f\u2e9a\u2ef4-\u2eff\u2fd6-\u2fef\u2ffc-\u2fff\u3040\u3097-\u3098\u3100-\u3104\u3130\u318f\u31bb-\u31bf\u31e4-\u31ef\u321f\u4db6-\u4dbf\u9ff0-\u9fff\ua48d-\ua48f\ua4c7-\ua4cf\ua62c-\ua63f\ua6f8-\ua6ff\ua7c0-\ua7c1\ua7c7-\ua7f6\ua82c-\ua82f\ua83a-\ua83f\ua878-\ua87f\ua8c6-\ua8cd\ua8da-\ua8df\ua954-\ua95e\ua97d-\ua97f\ua9ce\ua9da-\ua9dd\ua9ff\uaa37-\uaa3f\uaa4e-\uaa4f\uaa5a-\uaa5b\uaac3-\uaada\uaaf7-\uab00\uab07-\uab08\uab0f-\uab10\uab17-\uab1f\uab27\uab2f\uab68-\uab6f\uabee-\uabef\uabfa-\uabff\ud7a4-\ud7af\ud7c7-\ud7ca\ud7fc-\ud7ff\ufa6e-\ufa6f\ufada-\ufaff\ufb07-\ufb12\ufb18-\ufb1c\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufbc2-\ufbd2\ufd40-\ufd4f\ufd90-\ufd91\ufdc8-\ufdcf\ufdfe-\ufdff\ufe1a-\ufe1f\ufe53\ufe67\ufe6c-\ufe6f\ufe75\ufefd-\ufefe\uff00\uffbf-\uffc1\uffc8-\uffc9\uffd0-\uffd1\uffd8-\uffd9\uffdd-\uffdf\uffe7\uffef-\ufff8\U0001000c\U00010027\U0001003b\U0001003e\U0001004e-\U0001004f\U0001005e-\U0001007f\U000100fb-\U000100ff\U00010103-\U00010106\U00010134-\U00010136\U0001018f\U0001019c-\U0001019f\U000101a1-\U000101cf\U000101fe-\U0001027f\U0001029d-\U0001029f\U000102d1-\U000102df\U000102fc-\U000102ff\U00010324-\U0001032c\U0001034b-\U0001034f\U0001037b-\U0001037f\U0001039e\U000103c4-\U000103c7\U000103d6-\U000103ff\U0001049e-\U0001049f\U000104aa-\U000104af\U000104d4-\U000104d7\U000104fc-\U000104ff\U00010528-\U0001052f\U00010564-\U0001056e\U00010570-\U000105ff\U00010737-\U0001073f\U00010756-\U0001075f\U00010768-\U000107ff\U00010806-\U00010807\U00010809\U00010836\U00010839-\U0001083b\U0001083d-\U0001083e\U00010856\U0001089f-\U000108a6\U000108b0-\U000108df\U000108f3\U000108f6-\U000108fa\U0001091c-\U0001091e\U0001093a-\U0001093e\U00010940-\U0001097f\U000109b8-\U000109bb\U000109d0-\U000109d1\U00010a04\U00010a07-\U00010a0b\U00010a14\U00010a18\U00010a36-\U00010a37\U00010a3b-\U00010a3e\U00010a49-\U00010a4f\U00010a59-\U00010a5f\U00010aa0-\U00010abf\U00010ae7-\U00010aea\U00010af7-\U00010aff\U00010b36-\U00010b38\U00010b56-\U00010b57\U00010b73-\U00010b77\U00010b92-\U00010b98\U00010b9d-\U00010ba8\U00010bb0-\U00010bff\U00010c49-\U00010c7f\U00010cb3-\U00010cbf\U00010cf3-\U00010cf9\U00010d28-\U00010d2f\U00010d3a-\U00010e5f\U00010e7f-\U00010eff\U00010f28-\U00010f2f\U00010f5a-\U00010fdf\U00010ff7-\U00010fff\U0001104e-\U00011051\U00011070-\U0001107e\U000110c2-\U000110cc\U000110ce-\U000110cf\U000110e9-\U000110ef\U000110fa-\U000110ff\U00011135\U00011147-\U0001114f\U00011177-\U0001117f\U000111ce-\U000111cf\U000111e0\U000111f5-\U000111ff\U00011212\U0001123f-\U0001127f\U00011287\U00011289\U0001128e\U0001129e\U000112aa-\U000112af\U000112eb-\U000112ef\U000112fa-\U000112ff\U00011304\U0001130d-\U0001130e\U00011311-\U00011312\U00011329\U00011331\U00011334\U0001133a\U00011345-\U00011346\U00011349-\U0001134a\U0001134e-\U0001134f\U00011351-\U00011356\U00011358-\U0001135c\U00011364-\U00011365\U0001136d-\U0001136f\U00011375-\U000113ff\U0001145a\U0001145c\U00011460-\U0001147f\U000114c8-\U000114cf\U000114da-\U0001157f\U000115b6-\U000115b7\U000115de-\U000115ff\U00011645-\U0001164f\U0001165a-\U0001165f\U0001166d-\U0001167f\U000116b9-\U000116bf\U000116ca-\U000116ff\U0001171b-\U0001171c\U0001172c-\U0001172f\U00011740-\U000117ff\U0001183c-\U0001189f\U000118f3-\U000118fe\U00011900-\U0001199f\U000119a8-\U000119a9\U000119d8-\U000119d9\U000119e5-\U000119ff\U00011a48-\U00011a4f\U00011aa3-\U00011abf\U00011af9-\U00011bff\U00011c09\U00011c37\U00011c46-\U00011c4f\U00011c6d-\U00011c6f\U00011c90-\U00011c91\U00011ca8\U00011cb7-\U00011cff\U00011d07\U00011d0a\U00011d37-\U00011d39\U00011d3b\U00011d3e\U00011d48-\U00011d4f\U00011d5a-\U00011d5f\U00011d66\U00011d69\U00011d8f\U00011d92\U00011d99-\U00011d9f\U00011daa-\U00011edf\U00011ef9-\U00011fbf\U00011ff2-\U00011ffe\U0001239a-\U000123ff\U0001246f\U00012475-\U0001247f\U00012544-\U00012fff\U0001342f\U00013439-\U000143ff\U00014647-\U000167ff\U00016a39-\U00016a3f\U00016a5f\U00016a6a-\U00016a6d\U00016a70-\U00016acf\U00016aee-\U00016aef\U00016af6-\U00016aff\U00016b46-\U00016b4f\U00016b5a\U00016b62\U00016b78-\U00016b7c\U00016b90-\U00016e3f\U00016e9b-\U00016eff\U00016f4b-\U00016f4e\U00016f88-\U00016f8e\U00016fa0-\U00016fdf\U00016fe4-\U00016fff\U000187f8-\U000187ff\U00018af3-\U0001afff\U0001b11f-\U0001b14f\U0001b153-\U0001b163\U0001b168-\U0001b16f\U0001b2fc-\U0001bbff\U0001bc6b-\U0001bc6f\U0001bc7d-\U0001bc7f\U0001bc89-\U0001bc8f\U0001bc9a-\U0001bc9b\U0001bca4-\U0001cfff\U0001d0f6-\U0001d0ff\U0001d127-\U0001d128\U0001d1e9-\U0001d1ff\U0001d246-\U0001d2df\U0001d2f4-\U0001d2ff\U0001d357-\U0001d35f\U0001d379-\U0001d3ff\U0001d455\U0001d49d\U0001d4a0-\U0001d4a1\U0001d4a3-\U0001d4a4\U0001d4a7-\U0001d4a8\U0001d4ad\U0001d4ba\U0001d4bc\U0001d4c4\U0001d506\U0001d50b-\U0001d50c\U0001d515\U0001d51d\U0001d53a\U0001d53f\U0001d545\U0001d547-\U0001d549\U0001d551\U0001d6a6-\U0001d6a7\U0001d7cc-\U0001d7cd\U0001da8c-\U0001da9a\U0001daa0\U0001dab0-\U0001dfff\U0001e007\U0001e019-\U0001e01a\U0001e022\U0001e025\U0001e02b-\U0001e0ff\U0001e12d-\U0001e12f\U0001e13e-\U0001e13f\U0001e14a-\U0001e14d\U0001e150-\U0001e2bf\U0001e2fa-\U0001e2fe\U0001e300-\U0001e7ff\U0001e8c5-\U0001e8c6\U0001e8d7-\U0001e8ff\U0001e94c-\U0001e94f\U0001e95a-\U0001e95d\U0001e960-\U0001ec70\U0001ecb5-\U0001ed00\U0001ed3e-\U0001edff\U0001ee04\U0001ee20\U0001ee23\U0001ee25-\U0001ee26\U0001ee28\U0001ee33\U0001ee38\U0001ee3a\U0001ee3c-\U0001ee41\U0001ee43-\U0001ee46\U0001ee48\U0001ee4a\U0001ee4c\U0001ee50\U0001ee53\U0001ee55-\U0001ee56\U0001ee58\U0001ee5a\U0001ee5c\U0001ee5e\U0001ee60\U0001ee63\U0001ee65-\U0001ee66\U0001ee6b\U0001ee73\U0001ee78\U0001ee7d\U0001ee7f\U0001ee8a\U0001ee9c-\U0001eea0\U0001eea4\U0001eeaa\U0001eebc-\U0001eeef\U0001eef2-\U0001efff\U0001f02c-\U0001f02f\U0001f094-\U0001f09f\U0001f0af-\U0001f0b0\U0001f0c0\U0001f0d0\U0001f0f6-\U0001f0ff\U0001f10d-\U0001f10f\U0001f16d-\U0001f16f\U0001f1ad-\U0001f1e5\U0001f203-\U0001f20f\U0001f23c-\U0001f23f\U0001f249-\U0001f24f\U0001f252-\U0001f25f\U0001f266-\U0001f2ff\U0001f6d6-\U0001f6df\U0001f6ed-\U0001f6ef\U0001f6fb-\U0001f6ff\U0001f774-\U0001f77f\U0001f7d9-\U0001f7df\U0001f7ec-\U0001f7ff\U0001f80c-\U0001f80f\U0001f848-\U0001f84f\U0001f85a-\U0001f85f\U0001f888-\U0001f88f\U0001f8ae-\U0001f8ff\U0001f90c\U0001f972\U0001f977-\U0001f979\U0001f9a3-\U0001f9a4\U0001f9ab-\U0001f9ad\U0001f9cb-\U0001f9cc\U0001fa54-\U0001fa5f\U0001fa6e-\U0001fa6f\U0001fa74-\U0001fa77\U0001fa7b-\U0001fa7f\U0001fa83-\U0001fa8f\U0001fa96-\U0001fffd\U0002a6d7-\U0002a6ff\U0002b735-\U0002b73f\U0002b81e-\U0002b81f\U0002cea2-\U0002ceaf\U0002ebe1-\U0002f7ff\U0002fa1e-\U0002fffd\U00030000-\U0003fffd\U00040000-\U0004fffd\U00050000-\U0005fffd\U00060000-\U0006fffd\U00070000-\U0007fffd\U00080000-\U0008fffd\U00090000-\U0009fffd\U000a0000-\U000afffd\U000b0000-\U000bfffd\U000c0000-\U000cfffd\U000d0000-\U000dfffd\U000e0000\U000e0002-\U000e001f\U000e0080-\U000e00ff\U000e01f0-\U000efffd"
}
ascii_age: Dict[str, str] = {
    "1.1": "\x00-\x7f",
    "10.0": "",
    "11.0": "",
    "12.0": "",
    "12.1": "",
    "2.0": "",
    "2.1": "",
    "3.0": "",
    "3.1": "",
    "3.2": "",
    "4.0": "",
    "4.1": "",
    "5.0": "",
    "5.1": "",
    "5.2": "",
    "6.0": "",
    "6.1": "",
    "6.2": "",
    "6.3": "",
    "7.0": "",
    "8.0": "",
    "9.0": "",
    "^1.1": "\x80-\U0010ffff",
    "^10.0": "\x00-\U0010ffff",
    "^11.0": "\x00-\U0010ffff",
    "^12.0": "\x00-\U0010ffff",
    "^12.1": "\x00-\U0010ffff",
    "^2.0": "\x00-\U0010ffff",
    "^2.1": "\x00-\U0010ffff",
    "^3.0": "\x00-\U0010ffff",
    "^3.1": "\x00-\U0010ffff",
    "^3.2": "\x00-\U0010ffff",
    "^4.0": "\x00-\U0010ffff",
    "^4.1": "\x00-\U0010ffff",
    "^5.0": "\x00-\U0010ffff",
    "^5.1": "\x00-\U0010ffff",
    "^5.2": "\x00-\U0010ffff",
    "^6.0": "\x00-\U0010ffff",
    "^6.1": "\x00-\U0010ffff",
    "^6.2": "\x00-\U0010ffff",
    "^6.3": "\x00-\U0010ffff",
    "^7.0": "\x00-\U0010ffff",
    "^8.0": "\x00-\U0010ffff",
    "^9.0": "\x00-\U0010ffff",
    "^na": "\x00-\U0010ffff",
    "na": ""
}
