"""Unicode Properties from Unicode version 12.1.0 (autogen)."""
from __future__ import unicode_literals

unicode_nfc_quick_check = {
    "^m": "\x00-\u02ff\u0305\u030d-\u030e\u0310\u0312\u0315-\u031a\u031c-\u0322\u0329-\u032c\u032f\u0332-\u0337\u0339-\u0341\u0343-\u0344\u0346-\u0652\u0656-\u093b\u093d-\u09bd\u09bf-\u09d6\u09d8-\u0b3d\u0b3f-\u0b55\u0b58-\u0bbd\u0bbf-\u0bd6\u0bd8-\u0c55\u0c57-\u0cc1\u0cc3-\u0cd4\u0cd7-\u0d3d\u0d3f-\u0d56\u0d58-\u0dc9\u0dcb-\u0dce\u0dd0-\u0dde\u0de0-\u102d\u102f-\u1160\u1176-\u11a7\u11c3-\u1b34\u1b36-\u3098\u309b-\U000110b9\U000110bb-\U00011126\U00011128-\U0001133d\U0001133f-\U00011356\U00011358-\U000114af\U000114b1-\U000114b9\U000114bb-\U000114bc\U000114be-\U000115ae\U000115b0-\U0010ffff",
    "^n": "\x00-\u033f\u0342\u0345-\u0373\u0375-\u037d\u037f-\u0386\u0388-\u0957\u0960-\u09db\u09de\u09e0-\u0a32\u0a34-\u0a35\u0a37-\u0a58\u0a5c-\u0a5d\u0a5f-\u0b5b\u0b5e-\u0f42\u0f44-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f72\u0f74\u0f77\u0f79-\u0f80\u0f82-\u0f92\u0f94-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u1f70\u1f72\u1f74\u1f76\u1f78\u1f7a\u1f7c\u1f7e-\u1fba\u1fbc-\u1fbd\u1fbf-\u1fc8\u1fca\u1fcc-\u1fd2\u1fd4-\u1fda\u1fdc-\u1fe2\u1fe4-\u1fea\u1fec-\u1fed\u1ff0-\u1ff8\u1ffa\u1ffc\u1ffe-\u1fff\u2002-\u2125\u2127-\u2129\u212c-\u2328\u232b-\u2adb\u2add-\uf8ff\ufa0e-\ufa0f\ufa11\ufa13-\ufa14\ufa1f\ufa21\ufa23-\ufa24\ufa27-\ufa29\ufa6e-\ufa6f\ufada-\ufb1c\ufb1e\ufb20-\ufb29\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufb4f-\U0001d15d\U0001d165-\U0001d1ba\U0001d1c1-\U0002f7ff\U0002fa1e-\U0010ffff",
    "^y": "\u0300-\u0304\u0306-\u030c\u030f\u0311\u0313-\u0314\u031b\u0323-\u0328\u032d-\u032e\u0330-\u0331\u0338\u0340-\u0345\u0374\u037e\u0387\u0653-\u0655\u093c\u0958-\u095f\u09be\u09d7\u09dc-\u09dd\u09df\u0a33\u0a36\u0a59-\u0a5b\u0a5e\u0b3e\u0b56-\u0b57\u0b5c-\u0b5d\u0bbe\u0bd7\u0c56\u0cc2\u0cd5-\u0cd6\u0d3e\u0d57\u0dca\u0dcf\u0ddf\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f73\u0f75-\u0f76\u0f78\u0f81\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u102e\u1161-\u1175\u11a8-\u11c2\u1b35\u1f71\u1f73\u1f75\u1f77\u1f79\u1f7b\u1f7d\u1fbb\u1fbe\u1fc9\u1fcb\u1fd3\u1fdb\u1fe3\u1feb\u1fee-\u1fef\u1ff9\u1ffb\u1ffd\u2000-\u2001\u2126\u212a-\u212b\u2329-\u232a\u2adc\u3099-\u309a\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa6d\ufa70-\ufad9\ufb1d\ufb1f\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufb4e\U000110ba\U00011127\U0001133e\U00011357\U000114b0\U000114ba\U000114bd\U000115af\U0001d15e-\U0001d164\U0001d1bb-\U0001d1c0\U0002f800-\U0002fa1d",
    "m": "\u0300-\u0304\u0306-\u030c\u030f\u0311\u0313-\u0314\u031b\u0323-\u0328\u032d-\u032e\u0330-\u0331\u0338\u0342\u0345\u0653-\u0655\u093c\u09be\u09d7\u0b3e\u0b56-\u0b57\u0bbe\u0bd7\u0c56\u0cc2\u0cd5-\u0cd6\u0d3e\u0d57\u0dca\u0dcf\u0ddf\u102e\u1161-\u1175\u11a8-\u11c2\u1b35\u3099-\u309a\U000110ba\U00011127\U0001133e\U00011357\U000114b0\U000114ba\U000114bd\U000115af",
    "n": "\u0340-\u0341\u0343-\u0344\u0374\u037e\u0387\u0958-\u095f\u09dc-\u09dd\u09df\u0a33\u0a36\u0a59-\u0a5b\u0a5e\u0b5c-\u0b5d\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f73\u0f75-\u0f76\u0f78\u0f81\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u1f71\u1f73\u1f75\u1f77\u1f79\u1f7b\u1f7d\u1fbb\u1fbe\u1fc9\u1fcb\u1fd3\u1fdb\u1fe3\u1feb\u1fee-\u1fef\u1ff9\u1ffb\u1ffd\u2000-\u2001\u2126\u212a-\u212b\u2329-\u232a\u2adc\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa6d\ufa70-\ufad9\ufb1d\ufb1f\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufb4e\U0001d15e-\U0001d164\U0001d1bb-\U0001d1c0\U0002f800-\U0002fa1d",
    "y": "\x00-\u02ff\u0305\u030d-\u030e\u0310\u0312\u0315-\u031a\u031c-\u0322\u0329-\u032c\u032f\u0332-\u0337\u0339-\u033f\u0346-\u0373\u0375-\u037d\u037f-\u0386\u0388-\u0652\u0656-\u093b\u093d-\u0957\u0960-\u09bd\u09bf-\u09d6\u09d8-\u09db\u09de\u09e0-\u0a32\u0a34-\u0a35\u0a37-\u0a58\u0a5c-\u0a5d\u0a5f-\u0b3d\u0b3f-\u0b55\u0b58-\u0b5b\u0b5e-\u0bbd\u0bbf-\u0bd6\u0bd8-\u0c55\u0c57-\u0cc1\u0cc3-\u0cd4\u0cd7-\u0d3d\u0d3f-\u0d56\u0d58-\u0dc9\u0dcb-\u0dce\u0dd0-\u0dde\u0de0-\u0f42\u0f44-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f72\u0f74\u0f77\u0f79-\u0f80\u0f82-\u0f92\u0f94-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u102d\u102f-\u1160\u1176-\u11a7\u11c3-\u1b34\u1b36-\u1f70\u1f72\u1f74\u1f76\u1f78\u1f7a\u1f7c\u1f7e-\u1fba\u1fbc-\u1fbd\u1fbf-\u1fc8\u1fca\u1fcc-\u1fd2\u1fd4-\u1fda\u1fdc-\u1fe2\u1fe4-\u1fea\u1fec-\u1fed\u1ff0-\u1ff8\u1ffa\u1ffc\u1ffe-\u1fff\u2002-\u2125\u2127-\u2129\u212c-\u2328\u232b-\u2adb\u2add-\u3098\u309b-\uf8ff\ufa0e-\ufa0f\ufa11\ufa13-\ufa14\ufa1f\ufa21\ufa23-\ufa24\ufa27-\ufa29\ufa6e-\ufa6f\ufada-\ufb1c\ufb1e\ufb20-\ufb29\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufb4f-\U000110b9\U000110bb-\U00011126\U00011128-\U0001133d\U0001133f-\U00011356\U00011358-\U000114af\U000114b1-\U000114b9\U000114bb-\U000114bc\U000114be-\U000115ae\U000115b0-\U0001d15d\U0001d165-\U0001d1ba\U0001d1c1-\U0002f7ff\U0002fa1e-\U0010ffff"
}
unicode_nfd_quick_check = {
    "^n": "\x00-\xbf\xc6\xd0\xd7-\xd8\xde-\xdf\xe6\xf0\xf7-\xf8\xfe\u0110-\u0111\u0126-\u0127\u0131-\u0133\u0138\u013f-\u0142\u0149-\u014b\u0152-\u0153\u0166-\u0167\u017f-\u019f\u01a2-\u01ae\u01b1-\u01cc\u01dd\u01e4-\u01e5\u01f1-\u01f3\u01f6-\u01f7\u021c-\u021d\u0220-\u0225\u0234-\u033f\u0342\u0345-\u0373\u0375-\u037d\u037f-\u0384\u038b\u038d\u0391-\u03a9\u03b1-\u03c9\u03cf-\u03d2\u03d5-\u03ff\u0402\u0404-\u0406\u0408-\u040b\u040f-\u0418\u041a-\u0438\u043a-\u044f\u0452\u0454-\u0456\u0458-\u045b\u045f-\u0475\u0478-\u04c0\u04c3-\u04cf\u04d4-\u04d5\u04d8-\u04d9\u04e0-\u04e1\u04e8-\u04e9\u04f6-\u04f7\u04fa-\u0621\u0627-\u06bf\u06c1\u06c3-\u06d2\u06d4-\u0928\u092a-\u0930\u0932-\u0933\u0935-\u0957\u0960-\u09ca\u09cd-\u09db\u09de\u09e0-\u0a32\u0a34-\u0a35\u0a37-\u0a58\u0a5c-\u0a5d\u0a5f-\u0b47\u0b49-\u0b4a\u0b4d-\u0b5b\u0b5e-\u0b93\u0b95-\u0bc9\u0bcd-\u0c47\u0c49-\u0cbf\u0cc1-\u0cc6\u0cc9\u0ccc-\u0d49\u0d4d-\u0dd9\u0ddb\u0ddf-\u0f42\u0f44-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f72\u0f74\u0f77\u0f79-\u0f80\u0f82-\u0f92\u0f94-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u1025\u1027-\u1b05\u1b07\u1b09\u1b0b\u1b0d\u1b0f-\u1b11\u1b13-\u1b3a\u1b3c\u1b3e-\u1b3f\u1b42\u1b44-\u1dff\u1e9a\u1e9c-\u1e9f\u1efa-\u1eff\u1f16-\u1f17\u1f1e-\u1f1f\u1f46-\u1f47\u1f4e-\u1f4f\u1f58\u1f5a\u1f5c\u1f5e\u1f7e-\u1f7f\u1fb5\u1fbd\u1fbf-\u1fc0\u1fc5\u1fd4-\u1fd5\u1fdc\u1ff0-\u1ff1\u1ff5\u1ffe-\u1fff\u2002-\u2125\u2127-\u2129\u212c-\u2199\u219c-\u21ad\u21af-\u21cc\u21d0-\u2203\u2205-\u2208\u220a-\u220b\u220d-\u2223\u2225\u2227-\u2240\u2242-\u2243\u2245-\u2246\u2248\u224a-\u225f\u2261\u2263-\u226c\u2272-\u2273\u2276-\u2277\u227a-\u227f\u2282-\u2283\u2286-\u2287\u228a-\u22ab\u22b0-\u22df\u22e4-\u22e9\u22ee-\u2328\u232b-\u2adb\u2add-\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3063-\u3064\u3066\u3068\u306a-\u306f\u3072\u3075\u3078\u307b\u307e-\u3093\u3095-\u309d\u309f-\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c3-\u30c4\u30c6\u30c8\u30ca-\u30cf\u30d2\u30d5\u30d8\u30db\u30de-\u30f3\u30f5-\u30f6\u30fb-\u30fd\u30ff-\uabff\ud7a4-\uf8ff\ufa0e-\ufa0f\ufa11\ufa13-\ufa14\ufa1f\ufa21\ufa23-\ufa24\ufa27-\ufa29\ufa6e-\ufa6f\ufada-\ufb1c\ufb1e\ufb20-\ufb29\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufb4f-\U00011099\U0001109b\U0001109d-\U000110aa\U000110ac-\U0001112d\U00011130-\U0001134a\U0001134d-\U000114ba\U000114bd\U000114bf-\U000115b9\U000115bc-\U0001d15d\U0001d165-\U0001d1ba\U0001d1c1-\U0002f7ff\U0002fa1e-\U0010ffff",
    "^y": "\xc0-\xc5\xc7-\xcf\xd1-\xd6\xd9-\xdd\xe0-\xe5\xe7-\xef\xf1-\xf6\xf9-\xfd\xff-\u010f\u0112-\u0125\u0128-\u0130\u0134-\u0137\u0139-\u013e\u0143-\u0148\u014c-\u0151\u0154-\u0165\u0168-\u017e\u01a0-\u01a1\u01af-\u01b0\u01cd-\u01dc\u01de-\u01e3\u01e6-\u01f0\u01f4-\u01f5\u01f8-\u021b\u021e-\u021f\u0226-\u0233\u0340-\u0341\u0343-\u0344\u0374\u037e\u0385-\u038a\u038c\u038e-\u0390\u03aa-\u03b0\u03ca-\u03ce\u03d3-\u03d4\u0400-\u0401\u0403\u0407\u040c-\u040e\u0419\u0439\u0450-\u0451\u0453\u0457\u045c-\u045e\u0476-\u0477\u04c1-\u04c2\u04d0-\u04d3\u04d6-\u04d7\u04da-\u04df\u04e2-\u04e7\u04ea-\u04f5\u04f8-\u04f9\u0622-\u0626\u06c0\u06c2\u06d3\u0929\u0931\u0934\u0958-\u095f\u09cb-\u09cc\u09dc-\u09dd\u09df\u0a33\u0a36\u0a59-\u0a5b\u0a5e\u0b48\u0b4b-\u0b4c\u0b5c-\u0b5d\u0b94\u0bca-\u0bcc\u0c48\u0cc0\u0cc7-\u0cc8\u0cca-\u0ccb\u0d4a-\u0d4c\u0dda\u0ddc-\u0dde\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f73\u0f75-\u0f76\u0f78\u0f81\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u1026\u1b06\u1b08\u1b0a\u1b0c\u1b0e\u1b12\u1b3b\u1b3d\u1b40-\u1b41\u1b43\u1e00-\u1e99\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc1-\u1fc4\u1fc6-\u1fd3\u1fd6-\u1fdb\u1fdd-\u1fef\u1ff2-\u1ff4\u1ff6-\u1ffd\u2000-\u2001\u2126\u212a-\u212b\u219a-\u219b\u21ae\u21cd-\u21cf\u2204\u2209\u220c\u2224\u2226\u2241\u2244\u2247\u2249\u2260\u2262\u226d-\u2271\u2274-\u2275\u2278-\u2279\u2280-\u2281\u2284-\u2285\u2288-\u2289\u22ac-\u22af\u22e0-\u22e3\u22ea-\u22ed\u2329-\u232a\u2adc\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070-\u3071\u3073-\u3074\u3076-\u3077\u3079-\u307a\u307c-\u307d\u3094\u309e\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0-\u30d1\u30d3-\u30d4\u30d6-\u30d7\u30d9-\u30da\u30dc-\u30dd\u30f4\u30f7-\u30fa\u30fe\uac00-\ud7a3\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa6d\ufa70-\ufad9\ufb1d\ufb1f\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufb4e\U0001109a\U0001109c\U000110ab\U0001112e-\U0001112f\U0001134b-\U0001134c\U000114bb-\U000114bc\U000114be\U000115ba-\U000115bb\U0001d15e-\U0001d164\U0001d1bb-\U0001d1c0\U0002f800-\U0002fa1d",
    "n": "\xc0-\xc5\xc7-\xcf\xd1-\xd6\xd9-\xdd\xe0-\xe5\xe7-\xef\xf1-\xf6\xf9-\xfd\xff-\u010f\u0112-\u0125\u0128-\u0130\u0134-\u0137\u0139-\u013e\u0143-\u0148\u014c-\u0151\u0154-\u0165\u0168-\u017e\u01a0-\u01a1\u01af-\u01b0\u01cd-\u01dc\u01de-\u01e3\u01e6-\u01f0\u01f4-\u01f5\u01f8-\u021b\u021e-\u021f\u0226-\u0233\u0340-\u0341\u0343-\u0344\u0374\u037e\u0385-\u038a\u038c\u038e-\u0390\u03aa-\u03b0\u03ca-\u03ce\u03d3-\u03d4\u0400-\u0401\u0403\u0407\u040c-\u040e\u0419\u0439\u0450-\u0451\u0453\u0457\u045c-\u045e\u0476-\u0477\u04c1-\u04c2\u04d0-\u04d3\u04d6-\u04d7\u04da-\u04df\u04e2-\u04e7\u04ea-\u04f5\u04f8-\u04f9\u0622-\u0626\u06c0\u06c2\u06d3\u0929\u0931\u0934\u0958-\u095f\u09cb-\u09cc\u09dc-\u09dd\u09df\u0a33\u0a36\u0a59-\u0a5b\u0a5e\u0b48\u0b4b-\u0b4c\u0b5c-\u0b5d\u0b94\u0bca-\u0bcc\u0c48\u0cc0\u0cc7-\u0cc8\u0cca-\u0ccb\u0d4a-\u0d4c\u0dda\u0ddc-\u0dde\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f73\u0f75-\u0f76\u0f78\u0f81\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u1026\u1b06\u1b08\u1b0a\u1b0c\u1b0e\u1b12\u1b3b\u1b3d\u1b40-\u1b41\u1b43\u1e00-\u1e99\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc1-\u1fc4\u1fc6-\u1fd3\u1fd6-\u1fdb\u1fdd-\u1fef\u1ff2-\u1ff4\u1ff6-\u1ffd\u2000-\u2001\u2126\u212a-\u212b\u219a-\u219b\u21ae\u21cd-\u21cf\u2204\u2209\u220c\u2224\u2226\u2241\u2244\u2247\u2249\u2260\u2262\u226d-\u2271\u2274-\u2275\u2278-\u2279\u2280-\u2281\u2284-\u2285\u2288-\u2289\u22ac-\u22af\u22e0-\u22e3\u22ea-\u22ed\u2329-\u232a\u2adc\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070-\u3071\u3073-\u3074\u3076-\u3077\u3079-\u307a\u307c-\u307d\u3094\u309e\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0-\u30d1\u30d3-\u30d4\u30d6-\u30d7\u30d9-\u30da\u30dc-\u30dd\u30f4\u30f7-\u30fa\u30fe\uac00-\ud7a3\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa6d\ufa70-\ufad9\ufb1d\ufb1f\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufb4e\U0001109a\U0001109c\U000110ab\U0001112e-\U0001112f\U0001134b-\U0001134c\U000114bb-\U000114bc\U000114be\U000115ba-\U000115bb\U0001d15e-\U0001d164\U0001d1bb-\U0001d1c0\U0002f800-\U0002fa1d",
    "y": "\x00-\xbf\xc6\xd0\xd7-\xd8\xde-\xdf\xe6\xf0\xf7-\xf8\xfe\u0110-\u0111\u0126-\u0127\u0131-\u0133\u0138\u013f-\u0142\u0149-\u014b\u0152-\u0153\u0166-\u0167\u017f-\u019f\u01a2-\u01ae\u01b1-\u01cc\u01dd\u01e4-\u01e5\u01f1-\u01f3\u01f6-\u01f7\u021c-\u021d\u0220-\u0225\u0234-\u033f\u0342\u0345-\u0373\u0375-\u037d\u037f-\u0384\u038b\u038d\u0391-\u03a9\u03b1-\u03c9\u03cf-\u03d2\u03d5-\u03ff\u0402\u0404-\u0406\u0408-\u040b\u040f-\u0418\u041a-\u0438\u043a-\u044f\u0452\u0454-\u0456\u0458-\u045b\u045f-\u0475\u0478-\u04c0\u04c3-\u04cf\u04d4-\u04d5\u04d8-\u04d9\u04e0-\u04e1\u04e8-\u04e9\u04f6-\u04f7\u04fa-\u0621\u0627-\u06bf\u06c1\u06c3-\u06d2\u06d4-\u0928\u092a-\u0930\u0932-\u0933\u0935-\u0957\u0960-\u09ca\u09cd-\u09db\u09de\u09e0-\u0a32\u0a34-\u0a35\u0a37-\u0a58\u0a5c-\u0a5d\u0a5f-\u0b47\u0b49-\u0b4a\u0b4d-\u0b5b\u0b5e-\u0b93\u0b95-\u0bc9\u0bcd-\u0c47\u0c49-\u0cbf\u0cc1-\u0cc6\u0cc9\u0ccc-\u0d49\u0d4d-\u0dd9\u0ddb\u0ddf-\u0f42\u0f44-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f72\u0f74\u0f77\u0f79-\u0f80\u0f82-\u0f92\u0f94-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u1025\u1027-\u1b05\u1b07\u1b09\u1b0b\u1b0d\u1b0f-\u1b11\u1b13-\u1b3a\u1b3c\u1b3e-\u1b3f\u1b42\u1b44-\u1dff\u1e9a\u1e9c-\u1e9f\u1efa-\u1eff\u1f16-\u1f17\u1f1e-\u1f1f\u1f46-\u1f47\u1f4e-\u1f4f\u1f58\u1f5a\u1f5c\u1f5e\u1f7e-\u1f7f\u1fb5\u1fbd\u1fbf-\u1fc0\u1fc5\u1fd4-\u1fd5\u1fdc\u1ff0-\u1ff1\u1ff5\u1ffe-\u1fff\u2002-\u2125\u2127-\u2129\u212c-\u2199\u219c-\u21ad\u21af-\u21cc\u21d0-\u2203\u2205-\u2208\u220a-\u220b\u220d-\u2223\u2225\u2227-\u2240\u2242-\u2243\u2245-\u2246\u2248\u224a-\u225f\u2261\u2263-\u226c\u2272-\u2273\u2276-\u2277\u227a-\u227f\u2282-\u2283\u2286-\u2287\u228a-\u22ab\u22b0-\u22df\u22e4-\u22e9\u22ee-\u2328\u232b-\u2adb\u2add-\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3063-\u3064\u3066\u3068\u306a-\u306f\u3072\u3075\u3078\u307b\u307e-\u3093\u3095-\u309d\u309f-\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c3-\u30c4\u30c6\u30c8\u30ca-\u30cf\u30d2\u30d5\u30d8\u30db\u30de-\u30f3\u30f5-\u30f6\u30fb-\u30fd\u30ff-\uabff\ud7a4-\uf8ff\ufa0e-\ufa0f\ufa11\ufa13-\ufa14\ufa1f\ufa21\ufa23-\ufa24\ufa27-\ufa29\ufa6e-\ufa6f\ufada-\ufb1c\ufb1e\ufb20-\ufb29\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufb4f-\U00011099\U0001109b\U0001109d-\U000110aa\U000110ac-\U0001112d\U00011130-\U0001134a\U0001134d-\U000114ba\U000114bd\U000114bf-\U000115b9\U000115bc-\U0001d15d\U0001d165-\U0001d1ba\U0001d1c1-\U0002f7ff\U0002fa1e-\U0010ffff"
}
unicode_nfkc_quick_check = {
    "^m": "\x00-\u02ff\u0305\u030d-\u030e\u0310\u0312\u0315-\u031a\u031c-\u0322\u0329-\u032c\u032f\u0332-\u0337\u0339-\u0341\u0343-\u0344\u0346-\u0652\u0656-\u093b\u093d-\u09bd\u09bf-\u09d6\u09d8-\u0b3d\u0b3f-\u0b55\u0b58-\u0bbd\u0bbf-\u0bd6\u0bd8-\u0c55\u0c57-\u0cc1\u0cc3-\u0cd4\u0cd7-\u0d3d\u0d3f-\u0d56\u0d58-\u0dc9\u0dcb-\u0dce\u0dd0-\u0dde\u0de0-\u102d\u102f-\u1160\u1176-\u11a7\u11c3-\u1b34\u1b36-\u3098\u309b-\U000110b9\U000110bb-\U00011126\U00011128-\U0001133d\U0001133f-\U00011356\U00011358-\U000114af\U000114b1-\U000114b9\U000114bb-\U000114bc\U000114be-\U000115ae\U000115b0-\U0010ffff",
    "^n": "\x00-\x9f\xa1-\xa7\xa9\xab-\xae\xb0-\xb1\xb6-\xb7\xbb\xbf-\u0131\u0134-\u013e\u0141-\u0148\u014a-\u017e\u0180-\u01c3\u01cd-\u01f0\u01f4-\u02af\u02b9-\u02d7\u02de-\u02df\u02e5-\u033f\u0342\u0345-\u0373\u0375-\u0379\u037b-\u037d\u037f-\u0383\u0386\u0388-\u03cf\u03d7-\u03ef\u03f3\u03f6-\u03f8\u03fa-\u0586\u0588-\u0674\u0679-\u0957\u0960-\u09db\u09de\u09e0-\u0a32\u0a34-\u0a35\u0a37-\u0a58\u0a5c-\u0a5d\u0a5f-\u0b5b\u0b5e-\u0e32\u0e34-\u0eb2\u0eb4-\u0edb\u0ede-\u0f0b\u0f0d-\u0f42\u0f44-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f72\u0f74\u0f7a-\u0f80\u0f82-\u0f92\u0f94-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u10fb\u10fd-\u1d2b\u1d2f\u1d3b\u1d4e\u1d6b-\u1d77\u1d79-\u1d9a\u1dc0-\u1e99\u1e9c-\u1f70\u1f72\u1f74\u1f76\u1f78\u1f7a\u1f7c\u1f7e-\u1fba\u1fbc\u1fc2-\u1fc8\u1fca\u1fcc\u1fd0-\u1fd2\u1fd4-\u1fda\u1fdc\u1fe0-\u1fe2\u1fe4-\u1fea\u1fec\u1ff0-\u1ff8\u1ffa\u1ffc\u1fff\u200b-\u2010\u2012-\u2016\u2018-\u2023\u2027-\u202e\u2030-\u2032\u2035\u2038-\u203b\u203d\u203f-\u2046\u204a-\u2056\u2058-\u205e\u2060-\u206f\u2072-\u2073\u208f\u209d-\u20a7\u20a9-\u20ff\u2104\u2108\u2114\u2117-\u2118\u211e-\u211f\u2123\u2125\u2127\u2129\u212e\u2132\u213a\u2141-\u2144\u214a-\u214f\u2180-\u2188\u218a-\u222b\u222e\u2231-\u2328\u232b-\u245f\u24eb-\u2a0b\u2a0d-\u2a73\u2a77-\u2adb\u2add-\u2c7b\u2c7e-\u2d6e\u2d70-\u2e9e\u2ea0-\u2ef2\u2ef4-\u2eff\u2fd6-\u2fff\u3001-\u3035\u3037\u303b-\u309a\u309d-\u309e\u30a0-\u30fe\u3100-\u3130\u318f-\u3191\u31a0-\u31ff\u321f\u3248-\u324f\u327f\u3400-\ua69b\ua69e-\ua76f\ua771-\ua7f7\ua7fa-\uab5b\uab60-\uf8ff\ufa0e-\ufa0f\ufa11\ufa13-\ufa14\ufa1f\ufa21\ufa23-\ufa24\ufa27-\ufa29\ufa6e-\ufa6f\ufada-\ufaff\ufb07-\ufb12\ufb18-\ufb1c\ufb1e\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufbb2-\ufbd2\ufd3e-\ufd4f\ufd90-\ufd91\ufdc8-\ufdef\ufdfd-\ufe0f\ufe1a-\ufe2f\ufe45-\ufe46\ufe53\ufe67\ufe6c-\ufe6f\ufe73\ufe75\ufefd-\uff00\uffbf-\uffc1\uffc8-\uffc9\uffd0-\uffd1\uffd8-\uffd9\uffdd-\uffdf\uffe7\uffef-\U0001d15d\U0001d165-\U0001d1ba\U0001d1c1-\U0001d3ff\U0001d455\U0001d49d\U0001d4a0-\U0001d4a1\U0001d4a3-\U0001d4a4\U0001d4a7-\U0001d4a8\U0001d4ad\U0001d4ba\U0001d4bc\U0001d4c4\U0001d506\U0001d50b-\U0001d50c\U0001d515\U0001d51d\U0001d53a\U0001d53f\U0001d545\U0001d547-\U0001d549\U0001d551\U0001d6a6-\U0001d6a7\U0001d7cc-\U0001d7cd\U0001d800-\U0001edff\U0001ee04\U0001ee20\U0001ee23\U0001ee25-\U0001ee26\U0001ee28\U0001ee33\U0001ee38\U0001ee3a\U0001ee3c-\U0001ee41\U0001ee43-\U0001ee46\U0001ee48\U0001ee4a\U0001ee4c\U0001ee50\U0001ee53\U0001ee55-\U0001ee56\U0001ee58\U0001ee5a\U0001ee5c\U0001ee5e\U0001ee60\U0001ee63\U0001ee65-\U0001ee66\U0001ee6b\U0001ee73\U0001ee78\U0001ee7d\U0001ee7f\U0001ee8a\U0001ee9c-\U0001eea0\U0001eea4\U0001eeaa\U0001eebc-\U0001f0ff\U0001f10b-\U0001f10f\U0001f12f\U0001f150-\U0001f169\U0001f16d-\U0001f18f\U0001f191-\U0001f1ff\U0001f203-\U0001f20f\U0001f23c-\U0001f23f\U0001f249-\U0001f24f\U0001f252-\U0002f7ff\U0002fa1e-\U0010ffff",
    "^y": "\xa0\xa8\xaa\xaf\xb2-\xb5\xb8-\xba\xbc-\xbe\u0132-\u0133\u013f-\u0140\u0149\u017f\u01c4-\u01cc\u01f1-\u01f3\u02b0-\u02b8\u02d8-\u02dd\u02e0-\u02e4\u0300-\u0304\u0306-\u030c\u030f\u0311\u0313-\u0314\u031b\u0323-\u0328\u032d-\u032e\u0330-\u0331\u0338\u0340-\u0345\u0374\u037a\u037e\u0384-\u0385\u0387\u03d0-\u03d6\u03f0-\u03f2\u03f4-\u03f5\u03f9\u0587\u0653-\u0655\u0675-\u0678\u093c\u0958-\u095f\u09be\u09d7\u09dc-\u09dd\u09df\u0a33\u0a36\u0a59-\u0a5b\u0a5e\u0b3e\u0b56-\u0b57\u0b5c-\u0b5d\u0bbe\u0bd7\u0c56\u0cc2\u0cd5-\u0cd6\u0d3e\u0d57\u0dca\u0dcf\u0ddf\u0e33\u0eb3\u0edc-\u0edd\u0f0c\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f73\u0f75-\u0f79\u0f81\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u102e\u10fc\u1161-\u1175\u11a8-\u11c2\u1b35\u1d2c-\u1d2e\u1d30-\u1d3a\u1d3c-\u1d4d\u1d4f-\u1d6a\u1d78\u1d9b-\u1dbf\u1e9a-\u1e9b\u1f71\u1f73\u1f75\u1f77\u1f79\u1f7b\u1f7d\u1fbb\u1fbd-\u1fc1\u1fc9\u1fcb\u1fcd-\u1fcf\u1fd3\u1fdb\u1fdd-\u1fdf\u1fe3\u1feb\u1fed-\u1fef\u1ff9\u1ffb\u1ffd-\u1ffe\u2000-\u200a\u2011\u2017\u2024-\u2026\u202f\u2033-\u2034\u2036-\u2037\u203c\u203e\u2047-\u2049\u2057\u205f\u2070-\u2071\u2074-\u208e\u2090-\u209c\u20a8\u2100-\u2103\u2105-\u2107\u2109-\u2113\u2115-\u2116\u2119-\u211d\u2120-\u2122\u2124\u2126\u2128\u212a-\u212d\u212f-\u2131\u2133-\u2139\u213b-\u2140\u2145-\u2149\u2150-\u217f\u2189\u222c-\u222d\u222f-\u2230\u2329-\u232a\u2460-\u24ea\u2a0c\u2a74-\u2a76\u2adc\u2c7c-\u2c7d\u2d6f\u2e9f\u2ef3\u2f00-\u2fd5\u3000\u3036\u3038-\u303a\u3099-\u309c\u309f\u30ff\u3131-\u318e\u3192-\u319f\u3200-\u321e\u3220-\u3247\u3250-\u327e\u3280-\u33ff\ua69c-\ua69d\ua770\ua7f8-\ua7f9\uab5c-\uab5f\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfc\ufe10-\ufe19\ufe30-\ufe44\ufe47-\ufe52\ufe54-\ufe66\ufe68-\ufe6b\ufe70-\ufe72\ufe74\ufe76-\ufefc\uff01-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\uffe0-\uffe6\uffe8-\uffee\U000110ba\U00011127\U0001133e\U00011357\U000114b0\U000114ba\U000114bd\U000115af\U0001d15e-\U0001d164\U0001d1bb-\U0001d1c0\U0001d400-\U0001d454\U0001d456-\U0001d49c\U0001d49e-\U0001d49f\U0001d4a2\U0001d4a5-\U0001d4a6\U0001d4a9-\U0001d4ac\U0001d4ae-\U0001d4b9\U0001d4bb\U0001d4bd-\U0001d4c3\U0001d4c5-\U0001d505\U0001d507-\U0001d50a\U0001d50d-\U0001d514\U0001d516-\U0001d51c\U0001d51e-\U0001d539\U0001d53b-\U0001d53e\U0001d540-\U0001d544\U0001d546\U0001d54a-\U0001d550\U0001d552-\U0001d6a5\U0001d6a8-\U0001d7cb\U0001d7ce-\U0001d7ff\U0001ee00-\U0001ee03\U0001ee05-\U0001ee1f\U0001ee21-\U0001ee22\U0001ee24\U0001ee27\U0001ee29-\U0001ee32\U0001ee34-\U0001ee37\U0001ee39\U0001ee3b\U0001ee42\U0001ee47\U0001ee49\U0001ee4b\U0001ee4d-\U0001ee4f\U0001ee51-\U0001ee52\U0001ee54\U0001ee57\U0001ee59\U0001ee5b\U0001ee5d\U0001ee5f\U0001ee61-\U0001ee62\U0001ee64\U0001ee67-\U0001ee6a\U0001ee6c-\U0001ee72\U0001ee74-\U0001ee77\U0001ee79-\U0001ee7c\U0001ee7e\U0001ee80-\U0001ee89\U0001ee8b-\U0001ee9b\U0001eea1-\U0001eea3\U0001eea5-\U0001eea9\U0001eeab-\U0001eebb\U0001f100-\U0001f10a\U0001f110-\U0001f12e\U0001f130-\U0001f14f\U0001f16a-\U0001f16c\U0001f190\U0001f200-\U0001f202\U0001f210-\U0001f23b\U0001f240-\U0001f248\U0001f250-\U0001f251\U0002f800-\U0002fa1d",
    "m": "\u0300-\u0304\u0306-\u030c\u030f\u0311\u0313-\u0314\u031b\u0323-\u0328\u032d-\u032e\u0330-\u0331\u0338\u0342\u0345\u0653-\u0655\u093c\u09be\u09d7\u0b3e\u0b56-\u0b57\u0bbe\u0bd7\u0c56\u0cc2\u0cd5-\u0cd6\u0d3e\u0d57\u0dca\u0dcf\u0ddf\u102e\u1161-\u1175\u11a8-\u11c2\u1b35\u3099-\u309a\U000110ba\U00011127\U0001133e\U00011357\U000114b0\U000114ba\U000114bd\U000115af",
    "n": "\xa0\xa8\xaa\xaf\xb2-\xb5\xb8-\xba\xbc-\xbe\u0132-\u0133\u013f-\u0140\u0149\u017f\u01c4-\u01cc\u01f1-\u01f3\u02b0-\u02b8\u02d8-\u02dd\u02e0-\u02e4\u0340-\u0341\u0343-\u0344\u0374\u037a\u037e\u0384-\u0385\u0387\u03d0-\u03d6\u03f0-\u03f2\u03f4-\u03f5\u03f9\u0587\u0675-\u0678\u0958-\u095f\u09dc-\u09dd\u09df\u0a33\u0a36\u0a59-\u0a5b\u0a5e\u0b5c-\u0b5d\u0e33\u0eb3\u0edc-\u0edd\u0f0c\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f73\u0f75-\u0f79\u0f81\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u10fc\u1d2c-\u1d2e\u1d30-\u1d3a\u1d3c-\u1d4d\u1d4f-\u1d6a\u1d78\u1d9b-\u1dbf\u1e9a-\u1e9b\u1f71\u1f73\u1f75\u1f77\u1f79\u1f7b\u1f7d\u1fbb\u1fbd-\u1fc1\u1fc9\u1fcb\u1fcd-\u1fcf\u1fd3\u1fdb\u1fdd-\u1fdf\u1fe3\u1feb\u1fed-\u1fef\u1ff9\u1ffb\u1ffd-\u1ffe\u2000-\u200a\u2011\u2017\u2024-\u2026\u202f\u2033-\u2034\u2036-\u2037\u203c\u203e\u2047-\u2049\u2057\u205f\u2070-\u2071\u2074-\u208e\u2090-\u209c\u20a8\u2100-\u2103\u2105-\u2107\u2109-\u2113\u2115-\u2116\u2119-\u211d\u2120-\u2122\u2124\u2126\u2128\u212a-\u212d\u212f-\u2131\u2133-\u2139\u213b-\u2140\u2145-\u2149\u2150-\u217f\u2189\u222c-\u222d\u222f-\u2230\u2329-\u232a\u2460-\u24ea\u2a0c\u2a74-\u2a76\u2adc\u2c7c-\u2c7d\u2d6f\u2e9f\u2ef3\u2f00-\u2fd5\u3000\u3036\u3038-\u303a\u309b-\u309c\u309f\u30ff\u3131-\u318e\u3192-\u319f\u3200-\u321e\u3220-\u3247\u3250-\u327e\u3280-\u33ff\ua69c-\ua69d\ua770\ua7f8-\ua7f9\uab5c-\uab5f\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfc\ufe10-\ufe19\ufe30-\ufe44\ufe47-\ufe52\ufe54-\ufe66\ufe68-\ufe6b\ufe70-\ufe72\ufe74\ufe76-\ufefc\uff01-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\uffe0-\uffe6\uffe8-\uffee\U0001d15e-\U0001d164\U0001d1bb-\U0001d1c0\U0001d400-\U0001d454\U0001d456-\U0001d49c\U0001d49e-\U0001d49f\U0001d4a2\U0001d4a5-\U0001d4a6\U0001d4a9-\U0001d4ac\U0001d4ae-\U0001d4b9\U0001d4bb\U0001d4bd-\U0001d4c3\U0001d4c5-\U0001d505\U0001d507-\U0001d50a\U0001d50d-\U0001d514\U0001d516-\U0001d51c\U0001d51e-\U0001d539\U0001d53b-\U0001d53e\U0001d540-\U0001d544\U0001d546\U0001d54a-\U0001d550\U0001d552-\U0001d6a5\U0001d6a8-\U0001d7cb\U0001d7ce-\U0001d7ff\U0001ee00-\U0001ee03\U0001ee05-\U0001ee1f\U0001ee21-\U0001ee22\U0001ee24\U0001ee27\U0001ee29-\U0001ee32\U0001ee34-\U0001ee37\U0001ee39\U0001ee3b\U0001ee42\U0001ee47\U0001ee49\U0001ee4b\U0001ee4d-\U0001ee4f\U0001ee51-\U0001ee52\U0001ee54\U0001ee57\U0001ee59\U0001ee5b\U0001ee5d\U0001ee5f\U0001ee61-\U0001ee62\U0001ee64\U0001ee67-\U0001ee6a\U0001ee6c-\U0001ee72\U0001ee74-\U0001ee77\U0001ee79-\U0001ee7c\U0001ee7e\U0001ee80-\U0001ee89\U0001ee8b-\U0001ee9b\U0001eea1-\U0001eea3\U0001eea5-\U0001eea9\U0001eeab-\U0001eebb\U0001f100-\U0001f10a\U0001f110-\U0001f12e\U0001f130-\U0001f14f\U0001f16a-\U0001f16c\U0001f190\U0001f200-\U0001f202\U0001f210-\U0001f23b\U0001f240-\U0001f248\U0001f250-\U0001f251\U0002f800-\U0002fa1d",
    "y": "\x00-\x9f\xa1-\xa7\xa9\xab-\xae\xb0-\xb1\xb6-\xb7\xbb\xbf-\u0131\u0134-\u013e\u0141-\u0148\u014a-\u017e\u0180-\u01c3\u01cd-\u01f0\u01f4-\u02af\u02b9-\u02d7\u02de-\u02df\u02e5-\u02ff\u0305\u030d-\u030e\u0310\u0312\u0315-\u031a\u031c-\u0322\u0329-\u032c\u032f\u0332-\u0337\u0339-\u033f\u0346-\u0373\u0375-\u0379\u037b-\u037d\u037f-\u0383\u0386\u0388-\u03cf\u03d7-\u03ef\u03f3\u03f6-\u03f8\u03fa-\u0586\u0588-\u0652\u0656-\u0674\u0679-\u093b\u093d-\u0957\u0960-\u09bd\u09bf-\u09d6\u09d8-\u09db\u09de\u09e0-\u0a32\u0a34-\u0a35\u0a37-\u0a58\u0a5c-\u0a5d\u0a5f-\u0b3d\u0b3f-\u0b55\u0b58-\u0b5b\u0b5e-\u0bbd\u0bbf-\u0bd6\u0bd8-\u0c55\u0c57-\u0cc1\u0cc3-\u0cd4\u0cd7-\u0d3d\u0d3f-\u0d56\u0d58-\u0dc9\u0dcb-\u0dce\u0dd0-\u0dde\u0de0-\u0e32\u0e34-\u0eb2\u0eb4-\u0edb\u0ede-\u0f0b\u0f0d-\u0f42\u0f44-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f72\u0f74\u0f7a-\u0f80\u0f82-\u0f92\u0f94-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u102d\u102f-\u10fb\u10fd-\u1160\u1176-\u11a7\u11c3-\u1b34\u1b36-\u1d2b\u1d2f\u1d3b\u1d4e\u1d6b-\u1d77\u1d79-\u1d9a\u1dc0-\u1e99\u1e9c-\u1f70\u1f72\u1f74\u1f76\u1f78\u1f7a\u1f7c\u1f7e-\u1fba\u1fbc\u1fc2-\u1fc8\u1fca\u1fcc\u1fd0-\u1fd2\u1fd4-\u1fda\u1fdc\u1fe0-\u1fe2\u1fe4-\u1fea\u1fec\u1ff0-\u1ff8\u1ffa\u1ffc\u1fff\u200b-\u2010\u2012-\u2016\u2018-\u2023\u2027-\u202e\u2030-\u2032\u2035\u2038-\u203b\u203d\u203f-\u2046\u204a-\u2056\u2058-\u205e\u2060-\u206f\u2072-\u2073\u208f\u209d-\u20a7\u20a9-\u20ff\u2104\u2108\u2114\u2117-\u2118\u211e-\u211f\u2123\u2125\u2127\u2129\u212e\u2132\u213a\u2141-\u2144\u214a-\u214f\u2180-\u2188\u218a-\u222b\u222e\u2231-\u2328\u232b-\u245f\u24eb-\u2a0b\u2a0d-\u2a73\u2a77-\u2adb\u2add-\u2c7b\u2c7e-\u2d6e\u2d70-\u2e9e\u2ea0-\u2ef2\u2ef4-\u2eff\u2fd6-\u2fff\u3001-\u3035\u3037\u303b-\u3098\u309d-\u309e\u30a0-\u30fe\u3100-\u3130\u318f-\u3191\u31a0-\u31ff\u321f\u3248-\u324f\u327f\u3400-\ua69b\ua69e-\ua76f\ua771-\ua7f7\ua7fa-\uab5b\uab60-\uf8ff\ufa0e-\ufa0f\ufa11\ufa13-\ufa14\ufa1f\ufa21\ufa23-\ufa24\ufa27-\ufa29\ufa6e-\ufa6f\ufada-\ufaff\ufb07-\ufb12\ufb18-\ufb1c\ufb1e\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufbb2-\ufbd2\ufd3e-\ufd4f\ufd90-\ufd91\ufdc8-\ufdef\ufdfd-\ufe0f\ufe1a-\ufe2f\ufe45-\ufe46\ufe53\ufe67\ufe6c-\ufe6f\ufe73\ufe75\ufefd-\uff00\uffbf-\uffc1\uffc8-\uffc9\uffd0-\uffd1\uffd8-\uffd9\uffdd-\uffdf\uffe7\uffef-\U000110b9\U000110bb-\U00011126\U00011128-\U0001133d\U0001133f-\U00011356\U00011358-\U000114af\U000114b1-\U000114b9\U000114bb-\U000114bc\U000114be-\U000115ae\U000115b0-\U0001d15d\U0001d165-\U0001d1ba\U0001d1c1-\U0001d3ff\U0001d455\U0001d49d\U0001d4a0-\U0001d4a1\U0001d4a3-\U0001d4a4\U0001d4a7-\U0001d4a8\U0001d4ad\U0001d4ba\U0001d4bc\U0001d4c4\U0001d506\U0001d50b-\U0001d50c\U0001d515\U0001d51d\U0001d53a\U0001d53f\U0001d545\U0001d547-\U0001d549\U0001d551\U0001d6a6-\U0001d6a7\U0001d7cc-\U0001d7cd\U0001d800-\U0001edff\U0001ee04\U0001ee20\U0001ee23\U0001ee25-\U0001ee26\U0001ee28\U0001ee33\U0001ee38\U0001ee3a\U0001ee3c-\U0001ee41\U0001ee43-\U0001ee46\U0001ee48\U0001ee4a\U0001ee4c\U0001ee50\U0001ee53\U0001ee55-\U0001ee56\U0001ee58\U0001ee5a\U0001ee5c\U0001ee5e\U0001ee60\U0001ee63\U0001ee65-\U0001ee66\U0001ee6b\U0001ee73\U0001ee78\U0001ee7d\U0001ee7f\U0001ee8a\U0001ee9c-\U0001eea0\U0001eea4\U0001eeaa\U0001eebc-\U0001f0ff\U0001f10b-\U0001f10f\U0001f12f\U0001f150-\U0001f169\U0001f16d-\U0001f18f\U0001f191-\U0001f1ff\U0001f203-\U0001f20f\U0001f23c-\U0001f23f\U0001f249-\U0001f24f\U0001f252-\U0002f7ff\U0002fa1e-\U0010ffff"
}
unicode_nfkd_quick_check = {
    "^n": "\x00-\x9f\xa1-\xa7\xa9\xab-\xae\xb0-\xb1\xb6-\xb7\xbb\xbf\xc6\xd0\xd7-\xd8\xde-\xdf\xe6\xf0\xf7-\xf8\xfe\u0110-\u0111\u0126-\u0127\u0131\u0138\u0141-\u0142\u014a-\u014b\u0152-\u0153\u0166-\u0167\u0180-\u019f\u01a2-\u01ae\u01b1-\u01c3\u01dd\u01e4-\u01e5\u01f6-\u01f7\u021c-\u021d\u0220-\u0225\u0234-\u02af\u02b9-\u02d7\u02de-\u02df\u02e5-\u033f\u0342\u0345-\u0373\u0375-\u0379\u037b-\u037d\u037f-\u0383\u038b\u038d\u0391-\u03a9\u03b1-\u03c9\u03cf\u03d7-\u03ef\u03f3\u03f6-\u03f8\u03fa-\u03ff\u0402\u0404-\u0406\u0408-\u040b\u040f-\u0418\u041a-\u0438\u043a-\u044f\u0452\u0454-\u0456\u0458-\u045b\u045f-\u0475\u0478-\u04c0\u04c3-\u04cf\u04d4-\u04d5\u04d8-\u04d9\u04e0-\u04e1\u04e8-\u04e9\u04f6-\u04f7\u04fa-\u0586\u0588-\u0621\u0627-\u0674\u0679-\u06bf\u06c1\u06c3-\u06d2\u06d4-\u0928\u092a-\u0930\u0932-\u0933\u0935-\u0957\u0960-\u09ca\u09cd-\u09db\u09de\u09e0-\u0a32\u0a34-\u0a35\u0a37-\u0a58\u0a5c-\u0a5d\u0a5f-\u0b47\u0b49-\u0b4a\u0b4d-\u0b5b\u0b5e-\u0b93\u0b95-\u0bc9\u0bcd-\u0c47\u0c49-\u0cbf\u0cc1-\u0cc6\u0cc9\u0ccc-\u0d49\u0d4d-\u0dd9\u0ddb\u0ddf-\u0e32\u0e34-\u0eb2\u0eb4-\u0edb\u0ede-\u0f0b\u0f0d-\u0f42\u0f44-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f72\u0f74\u0f7a-\u0f80\u0f82-\u0f92\u0f94-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u1025\u1027-\u10fb\u10fd-\u1b05\u1b07\u1b09\u1b0b\u1b0d\u1b0f-\u1b11\u1b13-\u1b3a\u1b3c\u1b3e-\u1b3f\u1b42\u1b44-\u1d2b\u1d2f\u1d3b\u1d4e\u1d6b-\u1d77\u1d79-\u1d9a\u1dc0-\u1dff\u1e9c-\u1e9f\u1efa-\u1eff\u1f16-\u1f17\u1f1e-\u1f1f\u1f46-\u1f47\u1f4e-\u1f4f\u1f58\u1f5a\u1f5c\u1f5e\u1f7e-\u1f7f\u1fb5\u1fc5\u1fd4-\u1fd5\u1fdc\u1ff0-\u1ff1\u1ff5\u1fff\u200b-\u2010\u2012-\u2016\u2018-\u2023\u2027-\u202e\u2030-\u2032\u2035\u2038-\u203b\u203d\u203f-\u2046\u204a-\u2056\u2058-\u205e\u2060-\u206f\u2072-\u2073\u208f\u209d-\u20a7\u20a9-\u20ff\u2104\u2108\u2114\u2117-\u2118\u211e-\u211f\u2123\u2125\u2127\u2129\u212e\u2132\u213a\u2141-\u2144\u214a-\u214f\u2180-\u2188\u218a-\u2199\u219c-\u21ad\u21af-\u21cc\u21d0-\u2203\u2205-\u2208\u220a-\u220b\u220d-\u2223\u2225\u2227-\u222b\u222e\u2231-\u2240\u2242-\u2243\u2245-\u2246\u2248\u224a-\u225f\u2261\u2263-\u226c\u2272-\u2273\u2276-\u2277\u227a-\u227f\u2282-\u2283\u2286-\u2287\u228a-\u22ab\u22b0-\u22df\u22e4-\u22e9\u22ee-\u2328\u232b-\u245f\u24eb-\u2a0b\u2a0d-\u2a73\u2a77-\u2adb\u2add-\u2c7b\u2c7e-\u2d6e\u2d70-\u2e9e\u2ea0-\u2ef2\u2ef4-\u2eff\u2fd6-\u2fff\u3001-\u3035\u3037\u303b-\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3063-\u3064\u3066\u3068\u306a-\u306f\u3072\u3075\u3078\u307b\u307e-\u3093\u3095-\u309a\u309d\u30a0-\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c3-\u30c4\u30c6\u30c8\u30ca-\u30cf\u30d2\u30d5\u30d8\u30db\u30de-\u30f3\u30f5-\u30f6\u30fb-\u30fd\u3100-\u3130\u318f-\u3191\u31a0-\u31ff\u321f\u3248-\u324f\u327f\u3400-\ua69b\ua69e-\ua76f\ua771-\ua7f7\ua7fa-\uab5b\uab60-\uabff\ud7a4-\uf8ff\ufa0e-\ufa0f\ufa11\ufa13-\ufa14\ufa1f\ufa21\ufa23-\ufa24\ufa27-\ufa29\ufa6e-\ufa6f\ufada-\ufaff\ufb07-\ufb12\ufb18-\ufb1c\ufb1e\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufbb2-\ufbd2\ufd3e-\ufd4f\ufd90-\ufd91\ufdc8-\ufdef\ufdfd-\ufe0f\ufe1a-\ufe2f\ufe45-\ufe46\ufe53\ufe67\ufe6c-\ufe6f\ufe73\ufe75\ufefd-\uff00\uffbf-\uffc1\uffc8-\uffc9\uffd0-\uffd1\uffd8-\uffd9\uffdd-\uffdf\uffe7\uffef-\U00011099\U0001109b\U0001109d-\U000110aa\U000110ac-\U0001112d\U00011130-\U0001134a\U0001134d-\U000114ba\U000114bd\U000114bf-\U000115b9\U000115bc-\U0001d15d\U0001d165-\U0001d1ba\U0001d1c1-\U0001d3ff\U0001d455\U0001d49d\U0001d4a0-\U0001d4a1\U0001d4a3-\U0001d4a4\U0001d4a7-\U0001d4a8\U0001d4ad\U0001d4ba\U0001d4bc\U0001d4c4\U0001d506\U0001d50b-\U0001d50c\U0001d515\U0001d51d\U0001d53a\U0001d53f\U0001d545\U0001d547-\U0001d549\U0001d551\U0001d6a6-\U0001d6a7\U0001d7cc-\U0001d7cd\U0001d800-\U0001edff\U0001ee04\U0001ee20\U0001ee23\U0001ee25-\U0001ee26\U0001ee28\U0001ee33\U0001ee38\U0001ee3a\U0001ee3c-\U0001ee41\U0001ee43-\U0001ee46\U0001ee48\U0001ee4a\U0001ee4c\U0001ee50\U0001ee53\U0001ee55-\U0001ee56\U0001ee58\U0001ee5a\U0001ee5c\U0001ee5e\U0001ee60\U0001ee63\U0001ee65-\U0001ee66\U0001ee6b\U0001ee73\U0001ee78\U0001ee7d\U0001ee7f\U0001ee8a\U0001ee9c-\U0001eea0\U0001eea4\U0001eeaa\U0001eebc-\U0001f0ff\U0001f10b-\U0001f10f\U0001f12f\U0001f150-\U0001f169\U0001f16d-\U0001f18f\U0001f191-\U0001f1ff\U0001f203-\U0001f20f\U0001f23c-\U0001f23f\U0001f249-\U0001f24f\U0001f252-\U0002f7ff\U0002fa1e-\U0010ffff",
    "^y": "\xa0\xa8\xaa\xaf\xb2-\xb5\xb8-\xba\xbc-\xbe\xc0-\xc5\xc7-\xcf\xd1-\xd6\xd9-\xdd\xe0-\xe5\xe7-\xef\xf1-\xf6\xf9-\xfd\xff-\u010f\u0112-\u0125\u0128-\u0130\u0132-\u0137\u0139-\u0140\u0143-\u0149\u014c-\u0151\u0154-\u0165\u0168-\u017f\u01a0-\u01a1\u01af-\u01b0\u01c4-\u01dc\u01de-\u01e3\u01e6-\u01f5\u01f8-\u021b\u021e-\u021f\u0226-\u0233\u02b0-\u02b8\u02d8-\u02dd\u02e0-\u02e4\u0340-\u0341\u0343-\u0344\u0374\u037a\u037e\u0384-\u038a\u038c\u038e-\u0390\u03aa-\u03b0\u03ca-\u03ce\u03d0-\u03d6\u03f0-\u03f2\u03f4-\u03f5\u03f9\u0400-\u0401\u0403\u0407\u040c-\u040e\u0419\u0439\u0450-\u0451\u0453\u0457\u045c-\u045e\u0476-\u0477\u04c1-\u04c2\u04d0-\u04d3\u04d6-\u04d7\u04da-\u04df\u04e2-\u04e7\u04ea-\u04f5\u04f8-\u04f9\u0587\u0622-\u0626\u0675-\u0678\u06c0\u06c2\u06d3\u0929\u0931\u0934\u0958-\u095f\u09cb-\u09cc\u09dc-\u09dd\u09df\u0a33\u0a36\u0a59-\u0a5b\u0a5e\u0b48\u0b4b-\u0b4c\u0b5c-\u0b5d\u0b94\u0bca-\u0bcc\u0c48\u0cc0\u0cc7-\u0cc8\u0cca-\u0ccb\u0d4a-\u0d4c\u0dda\u0ddc-\u0dde\u0e33\u0eb3\u0edc-\u0edd\u0f0c\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f73\u0f75-\u0f79\u0f81\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u1026\u10fc\u1b06\u1b08\u1b0a\u1b0c\u1b0e\u1b12\u1b3b\u1b3d\u1b40-\u1b41\u1b43\u1d2c-\u1d2e\u1d30-\u1d3a\u1d3c-\u1d4d\u1d4f-\u1d6a\u1d78\u1d9b-\u1dbf\u1e00-\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fc4\u1fc6-\u1fd3\u1fd6-\u1fdb\u1fdd-\u1fef\u1ff2-\u1ff4\u1ff6-\u1ffe\u2000-\u200a\u2011\u2017\u2024-\u2026\u202f\u2033-\u2034\u2036-\u2037\u203c\u203e\u2047-\u2049\u2057\u205f\u2070-\u2071\u2074-\u208e\u2090-\u209c\u20a8\u2100-\u2103\u2105-\u2107\u2109-\u2113\u2115-\u2116\u2119-\u211d\u2120-\u2122\u2124\u2126\u2128\u212a-\u212d\u212f-\u2131\u2133-\u2139\u213b-\u2140\u2145-\u2149\u2150-\u217f\u2189\u219a-\u219b\u21ae\u21cd-\u21cf\u2204\u2209\u220c\u2224\u2226\u222c-\u222d\u222f-\u2230\u2241\u2244\u2247\u2249\u2260\u2262\u226d-\u2271\u2274-\u2275\u2278-\u2279\u2280-\u2281\u2284-\u2285\u2288-\u2289\u22ac-\u22af\u22e0-\u22e3\u22ea-\u22ed\u2329-\u232a\u2460-\u24ea\u2a0c\u2a74-\u2a76\u2adc\u2c7c-\u2c7d\u2d6f\u2e9f\u2ef3\u2f00-\u2fd5\u3000\u3036\u3038-\u303a\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070-\u3071\u3073-\u3074\u3076-\u3077\u3079-\u307a\u307c-\u307d\u3094\u309b-\u309c\u309e-\u309f\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0-\u30d1\u30d3-\u30d4\u30d6-\u30d7\u30d9-\u30da\u30dc-\u30dd\u30f4\u30f7-\u30fa\u30fe-\u30ff\u3131-\u318e\u3192-\u319f\u3200-\u321e\u3220-\u3247\u3250-\u327e\u3280-\u33ff\ua69c-\ua69d\ua770\ua7f8-\ua7f9\uab5c-\uab5f\uac00-\ud7a3\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfc\ufe10-\ufe19\ufe30-\ufe44\ufe47-\ufe52\ufe54-\ufe66\ufe68-\ufe6b\ufe70-\ufe72\ufe74\ufe76-\ufefc\uff01-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\uffe0-\uffe6\uffe8-\uffee\U0001109a\U0001109c\U000110ab\U0001112e-\U0001112f\U0001134b-\U0001134c\U000114bb-\U000114bc\U000114be\U000115ba-\U000115bb\U0001d15e-\U0001d164\U0001d1bb-\U0001d1c0\U0001d400-\U0001d454\U0001d456-\U0001d49c\U0001d49e-\U0001d49f\U0001d4a2\U0001d4a5-\U0001d4a6\U0001d4a9-\U0001d4ac\U0001d4ae-\U0001d4b9\U0001d4bb\U0001d4bd-\U0001d4c3\U0001d4c5-\U0001d505\U0001d507-\U0001d50a\U0001d50d-\U0001d514\U0001d516-\U0001d51c\U0001d51e-\U0001d539\U0001d53b-\U0001d53e\U0001d540-\U0001d544\U0001d546\U0001d54a-\U0001d550\U0001d552-\U0001d6a5\U0001d6a8-\U0001d7cb\U0001d7ce-\U0001d7ff\U0001ee00-\U0001ee03\U0001ee05-\U0001ee1f\U0001ee21-\U0001ee22\U0001ee24\U0001ee27\U0001ee29-\U0001ee32\U0001ee34-\U0001ee37\U0001ee39\U0001ee3b\U0001ee42\U0001ee47\U0001ee49\U0001ee4b\U0001ee4d-\U0001ee4f\U0001ee51-\U0001ee52\U0001ee54\U0001ee57\U0001ee59\U0001ee5b\U0001ee5d\U0001ee5f\U0001ee61-\U0001ee62\U0001ee64\U0001ee67-\U0001ee6a\U0001ee6c-\U0001ee72\U0001ee74-\U0001ee77\U0001ee79-\U0001ee7c\U0001ee7e\U0001ee80-\U0001ee89\U0001ee8b-\U0001ee9b\U0001eea1-\U0001eea3\U0001eea5-\U0001eea9\U0001eeab-\U0001eebb\U0001f100-\U0001f10a\U0001f110-\U0001f12e\U0001f130-\U0001f14f\U0001f16a-\U0001f16c\U0001f190\U0001f200-\U0001f202\U0001f210-\U0001f23b\U0001f240-\U0001f248\U0001f250-\U0001f251\U0002f800-\U0002fa1d",
    "n": "\xa0\xa8\xaa\xaf\xb2-\xb5\xb8-\xba\xbc-\xbe\xc0-\xc5\xc7-\xcf\xd1-\xd6\xd9-\xdd\xe0-\xe5\xe7-\xef\xf1-\xf6\xf9-\xfd\xff-\u010f\u0112-\u0125\u0128-\u0130\u0132-\u0137\u0139-\u0140\u0143-\u0149\u014c-\u0151\u0154-\u0165\u0168-\u017f\u01a0-\u01a1\u01af-\u01b0\u01c4-\u01dc\u01de-\u01e3\u01e6-\u01f5\u01f8-\u021b\u021e-\u021f\u0226-\u0233\u02b0-\u02b8\u02d8-\u02dd\u02e0-\u02e4\u0340-\u0341\u0343-\u0344\u0374\u037a\u037e\u0384-\u038a\u038c\u038e-\u0390\u03aa-\u03b0\u03ca-\u03ce\u03d0-\u03d6\u03f0-\u03f2\u03f4-\u03f5\u03f9\u0400-\u0401\u0403\u0407\u040c-\u040e\u0419\u0439\u0450-\u0451\u0453\u0457\u045c-\u045e\u0476-\u0477\u04c1-\u04c2\u04d0-\u04d3\u04d6-\u04d7\u04da-\u04df\u04e2-\u04e7\u04ea-\u04f5\u04f8-\u04f9\u0587\u0622-\u0626\u0675-\u0678\u06c0\u06c2\u06d3\u0929\u0931\u0934\u0958-\u095f\u09cb-\u09cc\u09dc-\u09dd\u09df\u0a33\u0a36\u0a59-\u0a5b\u0a5e\u0b48\u0b4b-\u0b4c\u0b5c-\u0b5d\u0b94\u0bca-\u0bcc\u0c48\u0cc0\u0cc7-\u0cc8\u0cca-\u0ccb\u0d4a-\u0d4c\u0dda\u0ddc-\u0dde\u0e33\u0eb3\u0edc-\u0edd\u0f0c\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f73\u0f75-\u0f79\u0f81\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u1026\u10fc\u1b06\u1b08\u1b0a\u1b0c\u1b0e\u1b12\u1b3b\u1b3d\u1b40-\u1b41\u1b43\u1d2c-\u1d2e\u1d30-\u1d3a\u1d3c-\u1d4d\u1d4f-\u1d6a\u1d78\u1d9b-\u1dbf\u1e00-\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fc4\u1fc6-\u1fd3\u1fd6-\u1fdb\u1fdd-\u1fef\u1ff2-\u1ff4\u1ff6-\u1ffe\u2000-\u200a\u2011\u2017\u2024-\u2026\u202f\u2033-\u2034\u2036-\u2037\u203c\u203e\u2047-\u2049\u2057\u205f\u2070-\u2071\u2074-\u208e\u2090-\u209c\u20a8\u2100-\u2103\u2105-\u2107\u2109-\u2113\u2115-\u2116\u2119-\u211d\u2120-\u2122\u2124\u2126\u2128\u212a-\u212d\u212f-\u2131\u2133-\u2139\u213b-\u2140\u2145-\u2149\u2150-\u217f\u2189\u219a-\u219b\u21ae\u21cd-\u21cf\u2204\u2209\u220c\u2224\u2226\u222c-\u222d\u222f-\u2230\u2241\u2244\u2247\u2249\u2260\u2262\u226d-\u2271\u2274-\u2275\u2278-\u2279\u2280-\u2281\u2284-\u2285\u2288-\u2289\u22ac-\u22af\u22e0-\u22e3\u22ea-\u22ed\u2329-\u232a\u2460-\u24ea\u2a0c\u2a74-\u2a76\u2adc\u2c7c-\u2c7d\u2d6f\u2e9f\u2ef3\u2f00-\u2fd5\u3000\u3036\u3038-\u303a\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070-\u3071\u3073-\u3074\u3076-\u3077\u3079-\u307a\u307c-\u307d\u3094\u309b-\u309c\u309e-\u309f\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0-\u30d1\u30d3-\u30d4\u30d6-\u30d7\u30d9-\u30da\u30dc-\u30dd\u30f4\u30f7-\u30fa\u30fe-\u30ff\u3131-\u318e\u3192-\u319f\u3200-\u321e\u3220-\u3247\u3250-\u327e\u3280-\u33ff\ua69c-\ua69d\ua770\ua7f8-\ua7f9\uab5c-\uab5f\uac00-\ud7a3\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfc\ufe10-\ufe19\ufe30-\ufe44\ufe47-\ufe52\ufe54-\ufe66\ufe68-\ufe6b\ufe70-\ufe72\ufe74\ufe76-\ufefc\uff01-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\uffe0-\uffe6\uffe8-\uffee\U0001109a\U0001109c\U000110ab\U0001112e-\U0001112f\U0001134b-\U0001134c\U000114bb-\U000114bc\U000114be\U000115ba-\U000115bb\U0001d15e-\U0001d164\U0001d1bb-\U0001d1c0\U0001d400-\U0001d454\U0001d456-\U0001d49c\U0001d49e-\U0001d49f\U0001d4a2\U0001d4a5-\U0001d4a6\U0001d4a9-\U0001d4ac\U0001d4ae-\U0001d4b9\U0001d4bb\U0001d4bd-\U0001d4c3\U0001d4c5-\U0001d505\U0001d507-\U0001d50a\U0001d50d-\U0001d514\U0001d516-\U0001d51c\U0001d51e-\U0001d539\U0001d53b-\U0001d53e\U0001d540-\U0001d544\U0001d546\U0001d54a-\U0001d550\U0001d552-\U0001d6a5\U0001d6a8-\U0001d7cb\U0001d7ce-\U0001d7ff\U0001ee00-\U0001ee03\U0001ee05-\U0001ee1f\U0001ee21-\U0001ee22\U0001ee24\U0001ee27\U0001ee29-\U0001ee32\U0001ee34-\U0001ee37\U0001ee39\U0001ee3b\U0001ee42\U0001ee47\U0001ee49\U0001ee4b\U0001ee4d-\U0001ee4f\U0001ee51-\U0001ee52\U0001ee54\U0001ee57\U0001ee59\U0001ee5b\U0001ee5d\U0001ee5f\U0001ee61-\U0001ee62\U0001ee64\U0001ee67-\U0001ee6a\U0001ee6c-\U0001ee72\U0001ee74-\U0001ee77\U0001ee79-\U0001ee7c\U0001ee7e\U0001ee80-\U0001ee89\U0001ee8b-\U0001ee9b\U0001eea1-\U0001eea3\U0001eea5-\U0001eea9\U0001eeab-\U0001eebb\U0001f100-\U0001f10a\U0001f110-\U0001f12e\U0001f130-\U0001f14f\U0001f16a-\U0001f16c\U0001f190\U0001f200-\U0001f202\U0001f210-\U0001f23b\U0001f240-\U0001f248\U0001f250-\U0001f251\U0002f800-\U0002fa1d",
    "y": "\x00-\x9f\xa1-\xa7\xa9\xab-\xae\xb0-\xb1\xb6-\xb7\xbb\xbf\xc6\xd0\xd7-\xd8\xde-\xdf\xe6\xf0\xf7-\xf8\xfe\u0110-\u0111\u0126-\u0127\u0131\u0138\u0141-\u0142\u014a-\u014b\u0152-\u0153\u0166-\u0167\u0180-\u019f\u01a2-\u01ae\u01b1-\u01c3\u01dd\u01e4-\u01e5\u01f6-\u01f7\u021c-\u021d\u0220-\u0225\u0234-\u02af\u02b9-\u02d7\u02de-\u02df\u02e5-\u033f\u0342\u0345-\u0373\u0375-\u0379\u037b-\u037d\u037f-\u0383\u038b\u038d\u0391-\u03a9\u03b1-\u03c9\u03cf\u03d7-\u03ef\u03f3\u03f6-\u03f8\u03fa-\u03ff\u0402\u0404-\u0406\u0408-\u040b\u040f-\u0418\u041a-\u0438\u043a-\u044f\u0452\u0454-\u0456\u0458-\u045b\u045f-\u0475\u0478-\u04c0\u04c3-\u04cf\u04d4-\u04d5\u04d8-\u04d9\u04e0-\u04e1\u04e8-\u04e9\u04f6-\u04f7\u04fa-\u0586\u0588-\u0621\u0627-\u0674\u0679-\u06bf\u06c1\u06c3-\u06d2\u06d4-\u0928\u092a-\u0930\u0932-\u0933\u0935-\u0957\u0960-\u09ca\u09cd-\u09db\u09de\u09e0-\u0a32\u0a34-\u0a35\u0a37-\u0a58\u0a5c-\u0a5d\u0a5f-\u0b47\u0b49-\u0b4a\u0b4d-\u0b5b\u0b5e-\u0b93\u0b95-\u0bc9\u0bcd-\u0c47\u0c49-\u0cbf\u0cc1-\u0cc6\u0cc9\u0ccc-\u0d49\u0d4d-\u0dd9\u0ddb\u0ddf-\u0e32\u0e34-\u0eb2\u0eb4-\u0edb\u0ede-\u0f0b\u0f0d-\u0f42\u0f44-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f72\u0f74\u0f7a-\u0f80\u0f82-\u0f92\u0f94-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u1025\u1027-\u10fb\u10fd-\u1b05\u1b07\u1b09\u1b0b\u1b0d\u1b0f-\u1b11\u1b13-\u1b3a\u1b3c\u1b3e-\u1b3f\u1b42\u1b44-\u1d2b\u1d2f\u1d3b\u1d4e\u1d6b-\u1d77\u1d79-\u1d9a\u1dc0-\u1dff\u1e9c-\u1e9f\u1efa-\u1eff\u1f16-\u1f17\u1f1e-\u1f1f\u1f46-\u1f47\u1f4e-\u1f4f\u1f58\u1f5a\u1f5c\u1f5e\u1f7e-\u1f7f\u1fb5\u1fc5\u1fd4-\u1fd5\u1fdc\u1ff0-\u1ff1\u1ff5\u1fff\u200b-\u2010\u2012-\u2016\u2018-\u2023\u2027-\u202e\u2030-\u2032\u2035\u2038-\u203b\u203d\u203f-\u2046\u204a-\u2056\u2058-\u205e\u2060-\u206f\u2072-\u2073\u208f\u209d-\u20a7\u20a9-\u20ff\u2104\u2108\u2114\u2117-\u2118\u211e-\u211f\u2123\u2125\u2127\u2129\u212e\u2132\u213a\u2141-\u2144\u214a-\u214f\u2180-\u2188\u218a-\u2199\u219c-\u21ad\u21af-\u21cc\u21d0-\u2203\u2205-\u2208\u220a-\u220b\u220d-\u2223\u2225\u2227-\u222b\u222e\u2231-\u2240\u2242-\u2243\u2245-\u2246\u2248\u224a-\u225f\u2261\u2263-\u226c\u2272-\u2273\u2276-\u2277\u227a-\u227f\u2282-\u2283\u2286-\u2287\u228a-\u22ab\u22b0-\u22df\u22e4-\u22e9\u22ee-\u2328\u232b-\u245f\u24eb-\u2a0b\u2a0d-\u2a73\u2a77-\u2adb\u2add-\u2c7b\u2c7e-\u2d6e\u2d70-\u2e9e\u2ea0-\u2ef2\u2ef4-\u2eff\u2fd6-\u2fff\u3001-\u3035\u3037\u303b-\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3063-\u3064\u3066\u3068\u306a-\u306f\u3072\u3075\u3078\u307b\u307e-\u3093\u3095-\u309a\u309d\u30a0-\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c3-\u30c4\u30c6\u30c8\u30ca-\u30cf\u30d2\u30d5\u30d8\u30db\u30de-\u30f3\u30f5-\u30f6\u30fb-\u30fd\u3100-\u3130\u318f-\u3191\u31a0-\u31ff\u321f\u3248-\u324f\u327f\u3400-\ua69b\ua69e-\ua76f\ua771-\ua7f7\ua7fa-\uab5b\uab60-\uabff\ud7a4-\uf8ff\ufa0e-\ufa0f\ufa11\ufa13-\ufa14\ufa1f\ufa21\ufa23-\ufa24\ufa27-\ufa29\ufa6e-\ufa6f\ufada-\ufaff\ufb07-\ufb12\ufb18-\ufb1c\ufb1e\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufbb2-\ufbd2\ufd3e-\ufd4f\ufd90-\ufd91\ufdc8-\ufdef\ufdfd-\ufe0f\ufe1a-\ufe2f\ufe45-\ufe46\ufe53\ufe67\ufe6c-\ufe6f\ufe73\ufe75\ufefd-\uff00\uffbf-\uffc1\uffc8-\uffc9\uffd0-\uffd1\uffd8-\uffd9\uffdd-\uffdf\uffe7\uffef-\U00011099\U0001109b\U0001109d-\U000110aa\U000110ac-\U0001112d\U00011130-\U0001134a\U0001134d-\U000114ba\U000114bd\U000114bf-\U000115b9\U000115bc-\U0001d15d\U0001d165-\U0001d1ba\U0001d1c1-\U0001d3ff\U0001d455\U0001d49d\U0001d4a0-\U0001d4a1\U0001d4a3-\U0001d4a4\U0001d4a7-\U0001d4a8\U0001d4ad\U0001d4ba\U0001d4bc\U0001d4c4\U0001d506\U0001d50b-\U0001d50c\U0001d515\U0001d51d\U0001d53a\U0001d53f\U0001d545\U0001d547-\U0001d549\U0001d551\U0001d6a6-\U0001d6a7\U0001d7cc-\U0001d7cd\U0001d800-\U0001edff\U0001ee04\U0001ee20\U0001ee23\U0001ee25-\U0001ee26\U0001ee28\U0001ee33\U0001ee38\U0001ee3a\U0001ee3c-\U0001ee41\U0001ee43-\U0001ee46\U0001ee48\U0001ee4a\U0001ee4c\U0001ee50\U0001ee53\U0001ee55-\U0001ee56\U0001ee58\U0001ee5a\U0001ee5c\U0001ee5e\U0001ee60\U0001ee63\U0001ee65-\U0001ee66\U0001ee6b\U0001ee73\U0001ee78\U0001ee7d\U0001ee7f\U0001ee8a\U0001ee9c-\U0001eea0\U0001eea4\U0001eeaa\U0001eebc-\U0001f0ff\U0001f10b-\U0001f10f\U0001f12f\U0001f150-\U0001f169\U0001f16d-\U0001f18f\U0001f191-\U0001f1ff\U0001f203-\U0001f20f\U0001f23c-\U0001f23f\U0001f249-\U0001f24f\U0001f252-\U0002f7ff\U0002fa1e-\U0010ffff"
}
ascii_nfd_quick_check = {
    "^n": "\x00-\xbf\xc6\xd0\xd7-\xd8\xde-\xdf\xe6\xf0\xf7-\xf8\xfe",
    "^y": "\xc0-\xc5\xc7-\xcf\xd1-\xd6\xd9-\xdd\xe0-\xe5\xe7-\xef\xf1-\xf6\xf9-\xfd\xff",
    "n": "\xc0-\xc5\xc7-\xcf\xd1-\xd6\xd9-\xdd\xe0-\xe5\xe7-\xef\xf1-\xf6\xf9-\xfd\xff",
    "y": "\x00-\xbf\xc6\xd0\xd7-\xd8\xde-\xdf\xe6\xf0\xf7-\xf8\xfe"
}
ascii_nfkc_quick_check = {
    "^n": "\x00-\x9f\xa1-\xa7\xa9\xab-\xae\xb0-\xb1\xb6-\xb7\xbb\xbf-\xff",
    "^y": "\xa0\xa8\xaa\xaf\xb2-\xb5\xb8-\xba\xbc-\xbe",
    "n": "\xa0\xa8\xaa\xaf\xb2-\xb5\xb8-\xba\xbc-\xbe",
    "y": "\x00-\x9f\xa1-\xa7\xa9\xab-\xae\xb0-\xb1\xb6-\xb7\xbb\xbf-\xff"
}
ascii_nfkd_quick_check = {
    "^n": "\x00-\x9f\xa1-\xa7\xa9\xab-\xae\xb0-\xb1\xb6-\xb7\xbb\xbf\xc6\xd0\xd7-\xd8\xde-\xdf\xe6\xf0\xf7-\xf8\xfe",
    "^y": "\xa0\xa8\xaa\xaf\xb2-\xb5\xb8-\xba\xbc-\xbe\xc0-\xc5\xc7-\xcf\xd1-\xd6\xd9-\xdd\xe0-\xe5\xe7-\xef\xf1-\xf6\xf9-\xfd\xff",
    "n": "\xa0\xa8\xaa\xaf\xb2-\xb5\xb8-\xba\xbc-\xbe\xc0-\xc5\xc7-\xcf\xd1-\xd6\xd9-\xdd\xe0-\xe5\xe7-\xef\xf1-\xf6\xf9-\xfd\xff",
    "y": "\x00-\x9f\xa1-\xa7\xa9\xab-\xae\xb0-\xb1\xb6-\xb7\xbb\xbf\xc6\xd0\xd7-\xd8\xde-\xdf\xe6\xf0\xf7-\xf8\xfe"
}
