﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iam/IAM_EXPORTS.h>
#include <aws/iam/model/LoginProfile.h>
#include <aws/iam/model/ResponseMetadata.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Xml
{
  class XmlDocument;
} // namespace Xml
} // namespace Utils
namespace IAM
{
namespace Model
{
  /**
   * <p>Contains the response to a successful <a>GetLoginProfile</a> request.
   * </p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfileResponse">AWS
   * API Reference</a></p>
   */
  class AWS_IAM_API GetLoginProfileResult
  {
  public:
    GetLoginProfileResult();
    GetLoginProfileResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
    GetLoginProfileResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);


    /**
     * <p>A structure containing the user name and the profile creation date for the
     * user.</p>
     */
    inline const LoginProfile& GetLoginProfile() const{ return m_loginProfile; }

    /**
     * <p>A structure containing the user name and the profile creation date for the
     * user.</p>
     */
    inline void SetLoginProfile(const LoginProfile& value) { m_loginProfile = value; }

    /**
     * <p>A structure containing the user name and the profile creation date for the
     * user.</p>
     */
    inline void SetLoginProfile(LoginProfile&& value) { m_loginProfile = std::move(value); }

    /**
     * <p>A structure containing the user name and the profile creation date for the
     * user.</p>
     */
    inline GetLoginProfileResult& WithLoginProfile(const LoginProfile& value) { SetLoginProfile(value); return *this;}

    /**
     * <p>A structure containing the user name and the profile creation date for the
     * user.</p>
     */
    inline GetLoginProfileResult& WithLoginProfile(LoginProfile&& value) { SetLoginProfile(std::move(value)); return *this;}


    
    inline const ResponseMetadata& GetResponseMetadata() const{ return m_responseMetadata; }

    
    inline void SetResponseMetadata(const ResponseMetadata& value) { m_responseMetadata = value; }

    
    inline void SetResponseMetadata(ResponseMetadata&& value) { m_responseMetadata = std::move(value); }

    
    inline GetLoginProfileResult& WithResponseMetadata(const ResponseMetadata& value) { SetResponseMetadata(value); return *this;}

    
    inline GetLoginProfileResult& WithResponseMetadata(ResponseMetadata&& value) { SetResponseMetadata(std::move(value)); return *this;}

  private:

    LoginProfile m_loginProfile;

    ResponseMetadata m_responseMetadata;
  };

} // namespace Model
} // namespace IAM
} // namespace Aws
