// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#ifndef ARROW_CSV_READER_H
#define ARROW_CSV_READER_H

#include <memory>

#include "arrow/csv/options.h"  // IWYU pragma: keep
#include "arrow/status.h"
#include "arrow/util/visibility.h"

namespace arrow {

class MemoryPool;
class Table;

namespace io {
class InputStream;
}  // namespace io

namespace csv {

/// A class that reads an entire CSV file into a Arrow Table
class ARROW_EXPORT TableReader {
 public:
  virtual ~TableReader() = default;

  /// Read the entire CSV file and convert it to a Arrow Table
  virtual Status Read(std::shared_ptr<Table>* out) = 0;

  /// Create a TableReader instance
  static Status Make(MemoryPool* pool, std::shared_ptr<io::InputStream> input,
                     const ReadOptions&, const ParseOptions&, const ConvertOptions&,
                     std::shared_ptr<TableReader>* out);
};

}  // namespace csv
}  // namespace arrow

#endif  // ARROW_CSV_READER_H
