# Volumetric Examples directory
In this directory you will find examples dealing with voxel data.
```bash
git clone https://github.com/marcomusy/vtkplotter.git
cd vtkplotter/vtkplotter/examples/volumetric
python example.py
```
(_click thumbnail image to get to the python script_)

|                                                                                                                                                                                                                                                                       |      |
|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-----|
| [![volumeOperations](https://user-images.githubusercontent.com/32848391/50739032-6b2a7c80-11da-11e9-82fb-495c803ea9bf.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/volumeOperations.py)<br/> `volumeOperations.py`                   |  Perform simple mathematical operations between 3d images.<br>Possible operations are: +, -, /, 1/x, sin, cos, exp, log, abs,  sqrt, min, max, atan, atan2, median, mag, dot, gradient, divergence, laplacian.|
|                                                                                                                                                                                                                                                                       |      |
| [![interpolateVolume](https://user-images.githubusercontent.com/32848391/50739033-6b2a7c80-11da-11e9-86fd-6026b22737df.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/interpolateVolume.py)<br/> `interpolateVolume.py`                | Generate a voxel dataset by interpolating a scalar which is only known on a small set of points. Interpolation is based on RBF (Radial Basis Function).|
|                                                                                                                                                                                                                                                                       |      |
| [![isosurfaces1](https://user-images.githubusercontent.com/32848391/52141625-975ce000-2656-11e9-91fc-291e072fc4c1.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/isosurfaces1.py)<br/> `isosurfaces1.py`                               | Generate the isosurfaces corresponding to an input set of thresholds on volumetric data.|
|                                                                                                                                                                                                                                                                       |      |
| [![isosurfaces2](https://user-images.githubusercontent.com/32848391/51558920-ec436e00-1e80-11e9-9d96-aa9b7c72d58b.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/isosurfaces2.py)<br/> `isosurfaces2.py`                               | Generate the isosurfaces corresponding to an input set of thresholds on volumetric data.|
|                                                                                                                                                                                                                                                                       |      |
| [![lego](https://user-images.githubusercontent.com/32848391/56820682-da40e500-684c-11e9-8ea3-91cbcba24b3a.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/legosurface.py)<br/> `legosurface.py`                                         | Represent a volume as lego blocks (voxels). Colors correspond to the volume's scalar. |
|                                                                                                                                                                                                                                                                       |      |
| [![probeLine1](https://user-images.githubusercontent.com/32848391/48198460-3aa0a080-e359-11e8-982d-23fadf4de66f.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/probeLine1.py)<br/> `probeLine1.py`                                     | Find and visualize the scalar value along a line intersecting a volume. |
|                                                                                                                                                                                                                                                                       |      |
| [![sliceplane](https://user-images.githubusercontent.com/32848391/48198461-3aa0a080-e359-11e8-8c29-18f287f105e6.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/slicePlane.py)<br/> `slicePlane.py`                                     | Slice a `Volume` (voxel dataset) with a plane and visualize the scalar value on it.|
|                                                                                                                                                                                                                                                                       |      |
| [![readVolumeAsIsoSurface](https://user-images.githubusercontent.com/32848391/50739035-6b2a7c80-11da-11e9-8687-4e4d46ff6df0.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/readVolumeAsIsoSurface.py)<br/> `readVolumeAsIsoSurface.py` | Generate an isosurface from voxel data.<br>A tiff stack is a set of image slices in z. The scalar value (intensity of white) is used to create an isosurface by fixing a threshold. |
|                                                                                                                                                                                                                                                                       |      |
| [![readVolume](https://user-images.githubusercontent.com/32848391/50739034-6b2a7c80-11da-11e9-9c86-1b25b1b77f42.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/readVolume.py)<br/> `readVolume.py`                                     | Load a `Volume` and show it along with a mesh surface (the red sphere). |
|                                                                                                                                                                                                                                                                       |      |
| [![read_vti](https://user-images.githubusercontent.com/32848391/50739036-6bc31300-11da-11e9-89b3-04a75187f812.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/read_vti.py)<br/> `read_vti.py`                                           | Using typical vtk commands to load a xml `.vti` file, then use vtkplotter to show the resulting 3D image.|
|                                                                                                                                                                                                                                                                       |      |
| [![signedDistance](https://user-images.githubusercontent.com/32848391/50739037-6bc31300-11da-11e9-82b7-dd4ae11076ae.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/volumeFromMesh.py)<br/> `volumeFromMesh.py`                         | Generate a scalar field by the signed distance from a polydata, then extract an isosurface from the 3D image. |
|                                                                                                                                                                                                                                                                       |      |
| [![streamlines1](https://user-images.githubusercontent.com/32848391/56964002-9145a500-6b5a-11e9-9e3f-da712609d896.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/streamlines1.py)<br/> `streamlines1.py`                               | Streamlines originating from a probing sphere in a volume domain defined by the pink hyperboloid. The vector field is given by the coords of the hyperboloid, this field is interpolated to the whole bounding box. |
|                                                                                                                                                                                                                                                                       |      |
| [![streamlines2](https://user-images.githubusercontent.com/32848391/56964001-9145a500-6b5a-11e9-935b-1b2425bd7dd2.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/streamlines2.py)<br/> `streamlines2.py`                               | Load an existing vtkStructuredGrid and draw the streamlines of the velocity field. |
|                                                                                                                                                                                                                                                                       |      |
| [![streamribbons](https://user-images.githubusercontent.com/32848391/56963999-9145a500-6b5a-11e9-9461-0037c471faab.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/streamribbons.py)<br/> `streamribbons.py`                            | Load an existing vtkStructuredGrid and draw the lines of the velocity field joining them in ribbons. |
|                                                                                                                                                                                                                                                                       |      |
| [![office](https://user-images.githubusercontent.com/32848391/56964003-9145a500-6b5a-11e9-9d9e-9736d90e1900.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/office.py)<br/> `office.py`                                                 | Stream tubes originating from a probing grid of points from CFD analysis of airflow in an office with ventilation and a burning cigarette. |
|                                                                                                                                                                                                                                                                       |      |
| [![tensors](https://user-images.githubusercontent.com/32848391/59944747-e2d92480-9465-11e9-8012-1fc34a2e30c6.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/volumetric/tensors.py)<br/> `tensors.py`                                              | Geometric representation of tensors defined on a domain or set of points. |

