# Histogramming and plotting examples

In this directory you will find a set of examples to perform basic 2D/3D plotting and histogramming.
```bash
git clone https://github.com/marcomusy/vtkplotter.git
cd vtkplotter/vtkplotter/examples/pyplot
python example.py
```
(_click thumbnail image to get to the python script_)

|    |    |
|:--------:|:-----|
| [![customaxes](https://user-images.githubusercontent.com/32848391/58181826-c605d180-7cac-11e9-9786-11b5eb278f20.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/customAxes.py)<br/> `customAxes.py`  | Customize axes style and appearance. |
|    |    |
| [![latex](https://user-images.githubusercontent.com/32848391/55568648-6190b200-5700-11e9-9547-0798c588a7a5.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/latex.py)<br/> `latex.py`                 | Draw latex formatted text on the rendering window. |
|    |    |
| [![markpoint](https://user-images.githubusercontent.com/32848391/52169969-1fb7af80-2741-11e9-937f-5c331d9a1d11.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/markpoint.py)<br/> `markpoint.py`     | Flag a point with a text that always faces camera. |
|    |    |
| [![plotxy](https://user-images.githubusercontent.com/32848391/69158509-d6c1c380-0ae6-11ea-9dbf-ff5cd396a9a6.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/plot1_errbars.py)<br/> `plot1_errbars.py`              | Draw a _x_ vs _y_ plot with optional error bars. |
|    |    |
| [![plotxy_errband](https://user-images.githubusercontent.com/32848391/72461569-970a1600-37cf-11ea-8060-a8a6cf657b95.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/plot2_errband.py)<br/> `plot2_errband.py`              | Draw errors in *y* as a solid color band. |
|    |    |
| [![fxy](https://user-images.githubusercontent.com/32848391/50738863-bfccf800-11d8-11e9-882d-7b217aceb55a.jpg)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/plot4_fxy.py)<br/> `plot4_fxy.py`                       | Draw a surface representing a function _f(x, y)_ defined as a string/formula or as a reference to an external already existing function. <br/>Red points indicate where the function does not exist. |
|    |    |
| [![scatter2](https://user-images.githubusercontent.com/32848391/72615028-013bcb80-3934-11ea-8ab8-823f1916bc6c.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/scatter2.py)<br/> `scatter2.py`              | Scatter points with varying marker size and color. |
|    |    |
| [![scatter3](https://user-images.githubusercontent.com/32848391/72446102-2d7c0e80-37b3-11ea-8fe4-b27526af574f.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/scatter3.py)<br/> `scatter3.py`              | Superpose scatter plots of different distributions. |
|    |    |
| [![histo](https://user-images.githubusercontent.com/32848391/68141260-77cc4e00-ff2d-11e9-9280-0efc5b87314d.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/histo_1D.py)<br/> `histo_1D.py`         | Draw a 1D histogram with optional error bars. |
|    |    |
| [![histog2d](https://user-images.githubusercontent.com/32848391/72452359-b5671600-37bd-11ea-8b1d-c44d884496ed.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/histo_2D.py)<br/> `histo_2D.py`         | Draw a 2D histogram. |
|    |    |
| [![histo2d](https://user-images.githubusercontent.com/32848391/72434748-b471bc80-379c-11ea-95d7-d70333770582.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/histo_hexagonal.py)<br/> `histo_hexagonal.py`    | Make a histogram of two variables with hexagonal binning. |
|    |    |
| [![polarHisto](https://user-images.githubusercontent.com/32848391/64912717-5754f400-d733-11e9-8a1f-612165955f23.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/histo_polar.py)<br/> `histo_polar.py`  | Draw a polar histogram with error bars. |
|    |    |
| [![sphericPlot](https://user-images.githubusercontent.com/32848391/72433091-f0a31e00-3798-11ea-86bd-6c522e23ec61.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/sphericPlot.py)<br/> `sphericPlot.py`     | Plot a surface in spherical coordinates. |
|    |    |
| [![quiverPlot](https://user-images.githubusercontent.com/32848391/72261438-199aa600-3615-11ea-870e-e44ca4c4b8d3.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/quiverPlot.py)<br/> `quiverPlot.py`     | Quiver plot to represent a 2D field. |
|    |    |
| [![streamplot](https://user-images.githubusercontent.com/32848391/73615998-61a65a80-460e-11ea-83a6-5592ac045d17.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/donutPlot.py)<br/> `plot7_stream.py.py`     | Stream line plot with seeding. |
|    |    |
| [![donutplot](https://user-images.githubusercontent.com/32848391/64998178-6f6b7580-d8e3-11e9-9bd8-8dfb9ccd90e4.png)](https://github.com/marcomusy/vtkplotter/blob/master/vtkplotter/examples/pyplot/donutPlot.py)<br/> `donut.py`     | A donut style plot or pie chart. |
