# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class UsAppToPersonList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, messaging_service_sid):
        """
        Initialize the UsAppToPersonList

        :param Version version: Version that contains the resource
        :param messaging_service_sid: The SID of the Messaging Service the resource is associated with

        :returns: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonList
        :rtype: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonList
        """
        super(UsAppToPersonList, self).__init__(version)

        # Path Solution
        self._solution = {'messaging_service_sid': messaging_service_sid, }
        self._uri = '/Services/{messaging_service_sid}/Compliance/Usa2p'.format(**self._solution)

    def create(self, brand_registration_sid, description, message_samples,
               us_app_to_person_usecase, has_embedded_links, has_embedded_phone):
        """
        Create the UsAppToPersonInstance

        :param unicode brand_registration_sid: A2P Brand Registration SID
        :param unicode description: A short description of what this SMS campaign does
        :param list[unicode] message_samples: Message samples
        :param unicode us_app_to_person_usecase: A2P Campaign Use Case.
        :param bool has_embedded_links: Indicates that this SMS campaign will send messages that contain links
        :param bool has_embedded_phone: Indicates that this SMS campaign will send messages that contain phone numbers

        :returns: The created UsAppToPersonInstance
        :rtype: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonInstance
        """
        data = values.of({
            'BrandRegistrationSid': brand_registration_sid,
            'Description': description,
            'MessageSamples': serialize.map(message_samples, lambda e: e),
            'UsAppToPersonUsecase': us_app_to_person_usecase,
            'HasEmbeddedLinks': has_embedded_links,
            'HasEmbeddedPhone': has_embedded_phone,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return UsAppToPersonInstance(
            self._version,
            payload,
            messaging_service_sid=self._solution['messaging_service_sid'],
        )

    def delete(self):
        """
        Deletes the UsAppToPersonInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def fetch(self):
        """
        Fetch the UsAppToPersonInstance

        :returns: The fetched UsAppToPersonInstance
        :rtype: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return UsAppToPersonInstance(
            self._version,
            payload,
            messaging_service_sid=self._solution['messaging_service_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.UsAppToPersonList>'


class UsAppToPersonPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the UsAppToPersonPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param messaging_service_sid: The SID of the Messaging Service the resource is associated with

        :returns: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonPage
        :rtype: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonPage
        """
        super(UsAppToPersonPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of UsAppToPersonInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonInstance
        :rtype: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonInstance
        """
        return UsAppToPersonInstance(
            self._version,
            payload,
            messaging_service_sid=self._solution['messaging_service_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.UsAppToPersonPage>'


class UsAppToPersonInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, messaging_service_sid):
        """
        Initialize the UsAppToPersonInstance

        :returns: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonInstance
        :rtype: twilio.rest.messaging.v1.service.us_app_to_person.UsAppToPersonInstance
        """
        super(UsAppToPersonInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'brand_registration_sid': payload.get('brand_registration_sid'),
            'messaging_service_sid': payload.get('messaging_service_sid'),
            'description': payload.get('description'),
            'message_samples': payload.get('message_samples'),
            'us_app_to_person_usecase': payload.get('us_app_to_person_usecase'),
            'has_embedded_links': payload.get('has_embedded_links'),
            'has_embedded_phone': payload.get('has_embedded_phone'),
            'status': payload.get('status'),
            'campaign_id': payload.get('campaign_id'),
            'is_externally_registered': payload.get('is_externally_registered'),
            'rate_limits': payload.get('rate_limits'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'messaging_service_sid': messaging_service_sid, }

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def brand_registration_sid(self):
        """
        :returns: A2P Brand Registration SID
        :rtype: unicode
        """
        return self._properties['brand_registration_sid']

    @property
    def messaging_service_sid(self):
        """
        :returns: The SID of the Messaging Service the resource is associated with
        :rtype: unicode
        """
        return self._properties['messaging_service_sid']

    @property
    def description(self):
        """
        :returns: A short description of what this SMS campaign does
        :rtype: unicode
        """
        return self._properties['description']

    @property
    def message_samples(self):
        """
        :returns: Message samples
        :rtype: list[unicode]
        """
        return self._properties['message_samples']

    @property
    def us_app_to_person_usecase(self):
        """
        :returns: A2P Campaign Use Case.
        :rtype: unicode
        """
        return self._properties['us_app_to_person_usecase']

    @property
    def has_embedded_links(self):
        """
        :returns: Indicate that this SMS campaign will send messages that contain links
        :rtype: bool
        """
        return self._properties['has_embedded_links']

    @property
    def has_embedded_phone(self):
        """
        :returns: Indicates that this SMS campaign will send messages that contain phone numbers
        :rtype: bool
        """
        return self._properties['has_embedded_phone']

    @property
    def status(self):
        """
        :returns: Campaign status
        :rtype: unicode
        """
        return self._properties['status']

    @property
    def campaign_id(self):
        """
        :returns: The Campaign Registry (TCR) Campaign ID.
        :rtype: unicode
        """
        return self._properties['campaign_id']

    @property
    def is_externally_registered(self):
        """
        :returns: Indicates whether the campaign was registered externally or not
        :rtype: bool
        """
        return self._properties['is_externally_registered']

    @property
    def rate_limits(self):
        """
        :returns: Rate limit and/or classification set by each carrier
        :rtype: dict
        """
        return self._properties['rate_limits']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the US App to Person resource
        :rtype: unicode
        """
        return self._properties['url']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.UsAppToPersonInstance>'
