/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ParsingContext;

public class TextParsingException
extends RuntimeException {
    private static final long serialVersionUID = 1410975527141918214L;
    private final long lineIndex;
    private final long charIndex;
    private final String content;

    public TextParsingException(ParsingContext context, String message, Throwable cause) {
        super(message, cause);
        this.lineIndex = context.currentLine();
        this.charIndex = context.currentChar();
        this.content = context.currentParsedContent();
    }

    public TextParsingException(ParsingContext context, String message) {
        this(context, message, null);
    }

    public TextParsingException(ParsingContext context, Throwable cause) {
        this(context, cause != null ? cause.getMessage() : null, cause);
    }

    public TextParsingException(ParsingContext context) {
        this(context, null, null);
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        msg = msg == null ? "" : msg;
        return "Error processing input: " + msg + ", line=" + this.lineIndex + ", char=" + this.charIndex + ". Content parsed: [" + this.content + "]";
    }

    public long getLineIndex() {
        return this.lineIndex;
    }

    public long getCharIndex() {
        return this.charIndex;
    }
}

