/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.loader.fileLoader;

import dmLab.array.Array;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.fileLoader.FileLoader;
import dmLab.array.meta.AttributeRole;
import java.io.BufferedReader;
import java.io.File;

public class FileLoaderCSV
extends FileLoader {
    public boolean firstLineContainsAttributes;
    public boolean consequentSeparatorsTreatAsOne;
    public String defaultAttributeName;
    protected AttributeRole[] attrDefArray;
    private boolean allDecision = false;

    @Override
    protected boolean myInit() {
        this.separator = (char)44;
        this.nullLabels.clear();
        this.nullLabels.add("");
        this.nullLabels.add("?");
        this.nullLabels.add("NaN");
        this.nullLabels.add("NA");
        this.nullLabels.add("Null");
        this.firstLineContainsAttributes = true;
        this.defaultAttributeName = "attr";
        this.trimComments = false;
        this.consequentSeparatorsTreatAsOne = false;
        this.fileType = 3;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean parseInputFile(File inputFile) {
        void var1_1;
        int lineCount = 0;
        char[] separators = new char[]{this.separator};
        boolean firstLine = true;
        BufferedReader fileReader = DiscFunctions.openFile(inputFile);
        if (fileReader == null) {
            DiscFunctions.closeFile(fileReader);
            return false;
        }
        do {
            String line;
            try {
                line = fileReader.readLine();
                ++lineCount;
            }
            catch (Exception exception) {
                System.err.println("Error reading input file. Line: ".concat(String.valueOf(lineCount)));
                return false;
            }
            if (line == null || (line = this.trimComments(line)).length() == 0) continue;
            if (firstLine) {
                String[] tokens = DiscFunctions.tokenizeString(line, separators, this.consequentSeparatorsTreatAsOne);
                this.attributesNumber = tokens.length;
                if (this.firstLineContainsAttributes) {
                    if (!this.readHeaderLine(tokens)) {
                        return false;
                    }
                } else {
                    if (!this.readHeaderLine(null)) {
                        return false;
                    }
                    ++this.eventsNumber;
                }
                boolean bl = false;
                continue;
            }
            ++this.eventsNumber;
        } while (var1_1 != null);
        if (this.attrDefArray != null && this.attrDefArray.length != this.attributesNumber) {
            System.err.println("Number of attributes in data (" + this.attributesNumber + ") does not equal to header(" + this.attrDefArray.length + ").");
            return false;
        }
        this.attributesNumber -= this.ignoredAttributesNumber;
        return DiscFunctions.closeFile(fileReader);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean readInputFile(File inputFile) {
        void var1_1;
        int lineCount = 0;
        boolean firstLine = true;
        int eventIndex = 0;
        BufferedReader fileReader = DiscFunctions.openFile(inputFile);
        if (fileReader == null) {
            return false;
        }
        if (this.attrDefArray != null) {
            int attrIndex = 0;
            int i = 0;
            while (i < this.attrDefArray.length) {
                AttributeRole attr = this.attrDefArray[i];
                if (attr.role == AttributeRole.ROLE_IGNORE) {
                    this.ignoredAttributeMask[i] = true;
                } else {
                    this.ignoredAttributeMask[i] = false;
                    this.myArray.attributes[attrIndex].name = attr.name;
                    this.myArray.attributes[attrIndex].type = attr.type;
                    this.myArray.attributes[attrIndex].weight = attr.weight;
                    if (attr.role == AttributeRole.ROLE_DECISION) {
                        this.myArray.setDecAttrIdx(attrIndex);
                        if (attr.decValues.length > 0) {
                            this.myArray.setDecValues(attr.decValues);
                        } else {
                            this.allDecision = true;
                        }
                    }
                    ++attrIndex;
                }
                ++i;
            }
        }
        do {
            String line;
            try {
                line = fileReader.readLine();
                ++lineCount;
            }
            catch (Exception exception) {
                System.err.println("Error reading input file. Line: ".concat(String.valueOf(lineCount)));
                return false;
            }
            if (line == null || (line = this.trimComments(line)).length() == 0) continue;
            if (firstLine && this.firstLineContainsAttributes) {
                firstLine = false;
                continue;
            }
            if (!this.loadEvent(line, eventIndex)) {
                System.err.println("Error reading event. Line: ".concat(String.valueOf(lineCount)));
                return false;
            }
            ++eventIndex;
        } while (var1_1 != null);
        if (this.allDecision) {
            this.myArray.setAllDecValues();
        }
        return DiscFunctions.closeFile(fileReader);
    }

    /*
     * WARNING - void declaration
     */
    private boolean readHeaderLine(String[] tokens) {
        if (this.attrDefArray == null) {
            this.attrDefArray = new AttributeRole[this.attributesNumber];
        }
        if (tokens == null) {
            int i = 0;
            while (i < this.attributesNumber) {
                if (this.attrDefArray[i] == null) {
                    this.attrDefArray[i] = new AttributeRole();
                    this.attrDefArray[i].name = String.valueOf(this.defaultAttributeName) + i;
                    this.attrDefArray[i].type = 1;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < tokens.length) {
                String name = tokens[i];
                if (name.equalsIgnoreCase("")) {
                    name = String.valueOf(this.defaultAttributeName) + i;
                }
                if (name.startsWith("\"") || name.startsWith("'")) {
                    name = DiscFunctions.trimQuotation(name);
                }
                if (this.attrDefArray[i] == null) {
                    this.attrDefArray[i] = new AttributeRole();
                    this.attrDefArray[i].name = name.trim().replaceAll(" ", Array.SPACE_CHAR);
                    this.attrDefArray[i].type = 1;
                } else if (!this.attrDefArray[i].name.equalsIgnoreCase(name)) {
                    void var3_4;
                    System.out.println(name);
                    System.out.println(this.attrDefArray[i].name);
                    System.err.println("Name of attribute in data (" + (String)var3_4 + ") does not correspond to header attribute name (" + this.attrDefArray[i].name + ").");
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected boolean readHeaderFile(File inputFile) {
        return true;
    }

    @Override
    protected File getDataFile(File inputFile) {
        return inputFile;
    }
}

