import argparse

from pls.enums.icon_type import IconType
from pls.parser.actions import BooleanOptionalAction, StoreOrCountAction


def add_args(parser: argparse.ArgumentParser):
    """
    Add arguments for presentation to the given parser.

    :param parser: the parser to which to add the arguments
    """

    presentation = parser.add_argument_group(
        title="presentation",
        description="arguments for controlling the presentation of nodes",
    )
    presentation.add_argument(
        *["-i", "--icon"],
        metavar="TYPE",
        type=IconType,
        choices=list(IconType),
        help="the type of icons to show with the files",
    )
    presentation.add_argument(
        "--align",
        action=BooleanOptionalAction,
        help="[underline]do[/]/[magenta]don't[/] align names based on leading dots",
    )
    presentation.add_argument(
        "--multi-cols",
        action=BooleanOptionalAction,
        help="render output in multiple/[magenta][underline]single[/][/] columns",
    )
    presentation.add_argument(
        *["-c", "--collapse"],
        action=StoreOrCountAction,
        help="collapse autogenerated files behind their sources",
    )
