#!/usr/bin/env python3
# Copyright 2004-present Facebook. All Rights Reserved.
#
# This file contains dummy data for the Backtester unit tests

import pandas as pd


PROPHET_EMPTY_DUMMY_DATA = pd.DataFrame(
    {
        "time": {},
        "fcst": {},
        "fcst_lower": {},
        "fcst_upper": {},
    }
)
PROPHET_0_108_FCST_DUMMY_DATA = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1958-01-01 00:00:00"),
            1: pd.Timestamp("1958-02-01 00:00:00"),
            2: pd.Timestamp("1958-03-01 00:00:00"),
            3: pd.Timestamp("1958-04-01 00:00:00"),
            4: pd.Timestamp("1958-05-01 00:00:00"),
            5: pd.Timestamp("1958-06-01 00:00:00"),
            6: pd.Timestamp("1958-07-01 00:00:00"),
            7: pd.Timestamp("1958-08-01 00:00:00"),
            8: pd.Timestamp("1958-09-01 00:00:00"),
            9: pd.Timestamp("1958-10-01 00:00:00"),
            10: pd.Timestamp("1958-11-01 00:00:00"),
            11: pd.Timestamp("1958-12-01 00:00:00"),
            12: pd.Timestamp("1959-01-01 00:00:00"),
            13: pd.Timestamp("1959-02-01 00:00:00"),
            14: pd.Timestamp("1959-03-01 00:00:00"),
            15: pd.Timestamp("1959-04-01 00:00:00"),
            16: pd.Timestamp("1959-05-01 00:00:00"),
            17: pd.Timestamp("1959-06-01 00:00:00"),
            18: pd.Timestamp("1959-07-01 00:00:00"),
            19: pd.Timestamp("1959-08-01 00:00:00"),
            20: pd.Timestamp("1959-09-01 00:00:00"),
            21: pd.Timestamp("1959-10-01 00:00:00"),
            22: pd.Timestamp("1959-11-01 00:00:00"),
            23: pd.Timestamp("1959-12-01 00:00:00"),
            24: pd.Timestamp("1960-01-01 00:00:00"),
            25: pd.Timestamp("1960-02-01 00:00:00"),
            26: pd.Timestamp("1960-03-01 00:00:00"),
            27: pd.Timestamp("1960-04-01 00:00:00"),
            28: pd.Timestamp("1960-05-01 00:00:00"),
            29: pd.Timestamp("1960-06-01 00:00:00"),
            30: pd.Timestamp("1960-07-01 00:00:00"),
            31: pd.Timestamp("1960-08-01 00:00:00"),
            32: pd.Timestamp("1960-09-01 00:00:00"),
            33: pd.Timestamp("1960-10-01 00:00:00"),
            34: pd.Timestamp("1960-11-01 00:00:00"),
            35: pd.Timestamp("1960-12-01 00:00:00"),
        },
        "fcst": {
            0: 371.8384916654681,
            1: 370.7166133142578,
            2: 402.75352461849104,
            3: 398.2578723521292,
            4: 400.9644584964947,
            5: 431.95072914187404,
            6: 462.80858755589594,
            7: 460.08754018112535,
            8: 431.00285135509176,
            9: 400.581623467755,
            10: 374.51951005958665,
            11: 401.6009648622867,
            12: 411.37064408482735,
            13: 411.5061823761929,
            14: 443.34595165457495,
            15: 440.1413375405826,
            16: 444.5563375428613,
            17: 471.46666969054485,
            18: 504.98988898163134,
            19: 498.35960628814576,
            20: 473.32413621460125,
            21: 443.0517587567832,
            22: 416.59371914698244,
            23: 443.7037120467515,
            24: 450.8710112643212,
            25: 452.31226743689376,
            26: 486.9095714349833,
            27: 479.8915930503214,
            28: 478.97476806451965,
            29: 518.0709602182424,
            30: 543.608014575239,
            31: 548.8192224374407,
            32: 511.8132380931265,
            33: 480.9592668621728,
            34: 455.64262323696136,
            35: 482.5133810159045,
        },
        "fcst_lower": {
            0: 351.75906765020045,
            1: 349.4631990315883,
            2: 383.49620609153504,
            3: 379.6731481270859,
            4: 381.79376234866737,
            5: 413.69541251334823,
            6: 443.4370537370912,
            7: 441.82638941977075,
            8: 410.7706446258158,
            9: 381.8995972489696,
            10: 355.32821266513804,
            11: 382.10359749033546,
            12: 391.75045781798065,
            13: 391.5607315975187,
            14: 423.03099131926456,
            15: 420.40783486931775,
            16: 424.8719489703955,
            17: 450.969378385955,
            18: 485.77285874675977,
            19: 477.57199397496754,
            20: 453.5375638478092,
            21: 423.97672041671615,
            22: 397.4084778611959,
            23: 424.552699584151,
            24: 430.50468300738254,
            25: 433.04647470591567,
            26: 467.6633090328184,
            27: 460.3975548723683,
            28: 458.0294539236105,
            29: 497.9249876034277,
            30: 523.7156619701472,
            31: 530.4779982775412,
            32: 492.8961259596756,
            33: 460.60357220647313,
            34: 435.328159952051,
            35: 462.4404213259764,
        },
        "fcst_upper": {
            0: 390.4683105158605,
            1: 390.65164256712404,
            2: 421.5403268045992,
            3: 416.1453756395322,
            4: 418.838093703513,
            5: 452.51010537024194,
            6: 482.25832758357,
            7: 479.83300173298034,
            8: 449.23550872613293,
            9: 420.22063355753346,
            10: 393.84614569593,
            11: 418.95227568223663,
            12: 431.04867236420984,
            13: 431.8484596539524,
            14: 463.9610569923289,
            15: 458.17744468003133,
            16: 465.09151665034733,
            17: 491.1368490053545,
            18: 525.486053970781,
            19: 518.5401234123842,
            20: 492.19400745742325,
            21: 462.1348506254867,
            22: 435.50185140808566,
            23: 463.7626738331911,
            24: 469.326487280586,
            25: 472.0940439336841,
            26: 505.57198161764313,
            27: 500.119218786532,
            28: 498.76665081245017,
            29: 537.852410931747,
            30: 563.1728232333625,
            31: 569.0253629866141,
            32: 532.8375606810956,
            33: 500.1945689286676,
            34: 476.7618708375277,
            35: 501.89605068655936,
        },
    }
)

PROPHET_0_72_FCST_DUMMY_DATA = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1955-01-01 00:00:00"),
            1: pd.Timestamp("1955-02-01 00:00:00"),
            2: pd.Timestamp("1955-03-01 00:00:00"),
            3: pd.Timestamp("1955-04-01 00:00:00"),
            4: pd.Timestamp("1955-05-01 00:00:00"),
            5: pd.Timestamp("1955-06-01 00:00:00"),
            6: pd.Timestamp("1955-07-01 00:00:00"),
            7: pd.Timestamp("1955-08-01 00:00:00"),
            8: pd.Timestamp("1955-09-01 00:00:00"),
            9: pd.Timestamp("1955-10-01 00:00:00"),
            10: pd.Timestamp("1955-11-01 00:00:00"),
            11: pd.Timestamp("1955-12-01 00:00:00"),
            12: pd.Timestamp("1956-01-01 00:00:00"),
            13: pd.Timestamp("1956-02-01 00:00:00"),
            14: pd.Timestamp("1956-03-01 00:00:00"),
            15: pd.Timestamp("1956-04-01 00:00:00"),
            16: pd.Timestamp("1956-05-01 00:00:00"),
            17: pd.Timestamp("1956-06-01 00:00:00"),
            18: pd.Timestamp("1956-07-01 00:00:00"),
            19: pd.Timestamp("1956-08-01 00:00:00"),
            20: pd.Timestamp("1956-09-01 00:00:00"),
            21: pd.Timestamp("1956-10-01 00:00:00"),
            22: pd.Timestamp("1956-11-01 00:00:00"),
            23: pd.Timestamp("1956-12-01 00:00:00"),
            24: pd.Timestamp("1957-01-01 00:00:00"),
            25: pd.Timestamp("1957-02-01 00:00:00"),
            26: pd.Timestamp("1957-03-01 00:00:00"),
            27: pd.Timestamp("1957-04-01 00:00:00"),
            28: pd.Timestamp("1957-05-01 00:00:00"),
            29: pd.Timestamp("1957-06-01 00:00:00"),
            30: pd.Timestamp("1957-07-01 00:00:00"),
            31: pd.Timestamp("1957-08-01 00:00:00"),
            32: pd.Timestamp("1957-09-01 00:00:00"),
            33: pd.Timestamp("1957-10-01 00:00:00"),
            34: pd.Timestamp("1957-11-01 00:00:00"),
            35: pd.Timestamp("1957-12-01 00:00:00"),
        },
        "fcst": {
            0: 237.82191741092083,
            1: 241.79202945022217,
            2: 267.1411737358285,
            3: 257.74440815387146,
            4: 261.9618687066704,
            5: 274.90677518199567,
            6: 303.3465713520833,
            7: 297.759518279388,
            8: 281.38523924483326,
            9: 254.19994121360392,
            10: 233.4338265953682,
            11: 255.2797226719209,
            12: 258.485964151307,
            13: 264.35209890708825,
            14: 289.00117441131954,
            15: 283.3826058720747,
            16: 277.05188323042364,
            17: 304.8330125137641,
            18: 318.1301551795879,
            19: 327.10631612791803,
            20: 296.231806714001,
            21: 277.08994387456875,
            22: 255.61166085025698,
            23: 276.46818345277865,
            24: 283.3613215854848,
            25: 283.5609841115963,
            26: 310.6869547306119,
            27: 303.76305466769344,
            28: 300.9769629347439,
            29: 323.80656762803085,
            30: 342.1511443674959,
            31: 346.27027622495586,
            32: 320.2058399812674,
            33: 298.4283096940648,
            34: 277.1569052401928,
            35: 298.36152854116483,
        },
        "fcst_lower": {
            0: 226.8529782949165,
            1: 230.18190668208638,
            2: 255.32761053365388,
            3: 246.5328658330278,
            4: 250.6965428313151,
            5: 263.1336830365089,
            6: 292.0796462112445,
            7: 286.22380149859083,
            8: 269.90570329653,
            9: 243.19463721058693,
            10: 221.22185732186554,
            11: 243.47397278919004,
            12: 246.8851182333225,
            13: 253.01099796435574,
            14: 277.548465681668,
            15: 272.08552432455605,
            16: 265.34969815143677,
            17: 293.1226469657216,
            18: 307.1238964080764,
            19: 316.55471113078045,
            20: 285.0229229290555,
            21: 265.1053129584326,
            22: 244.38060617140027,
            23: 265.20610357244465,
            24: 271.1291914315538,
            25: 271.5265427459028,
            26: 299.12700269019206,
            27: 291.41661390576724,
            28: 289.19023139332603,
            29: 311.61946562705845,
            30: 330.2623004534514,
            31: 334.2643940985813,
            32: 307.75154864699897,
            33: 285.69277730520463,
            34: 265.38806567937957,
            35: 285.88678254316125,
        },
        "fcst_upper": {
            0: 248.89580558783916,
            1: 252.50105973062674,
            2: 278.3005895990244,
            3: 268.49901917514615,
            4: 273.3288366228615,
            5: 286.61682258354296,
            6: 314.72924769390823,
            7: 308.79476140347447,
            8: 293.28098662275494,
            9: 264.6275083559279,
            10: 245.54173164678076,
            11: 266.5312328096252,
            12: 269.94996771663403,
            13: 275.50877204913513,
            14: 301.0183655471023,
            15: 295.7305555338226,
            16: 288.8996959609498,
            17: 316.61594443240114,
            18: 330.062878517589,
            19: 338.3714200949285,
            20: 308.39970470180833,
            21: 288.5066675016717,
            22: 267.5556913372148,
            23: 288.8514079779891,
            24: 295.7016004809358,
            25: 293.7737949171852,
            26: 321.8545742149634,
            27: 315.83752300637445,
            28: 312.4221953590091,
            29: 335.5600563826465,
            30: 354.8451497665086,
            31: 358.5411034033912,
            32: 333.0143785874175,
            33: 311.1092593726273,
            34: 290.18536402157724,
            35: 310.4072489832923,
        },
    }
)

PROPHET_0_90_FCST_DUMMY_DATA = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1956-07-01 00:00:00"),
            1: pd.Timestamp("1956-08-01 00:00:00"),
            2: pd.Timestamp("1956-09-01 00:00:00"),
            3: pd.Timestamp("1956-10-01 00:00:00"),
            4: pd.Timestamp("1956-11-01 00:00:00"),
            5: pd.Timestamp("1956-12-01 00:00:00"),
            6: pd.Timestamp("1957-01-01 00:00:00"),
            7: pd.Timestamp("1957-02-01 00:00:00"),
            8: pd.Timestamp("1957-03-01 00:00:00"),
            9: pd.Timestamp("1957-04-01 00:00:00"),
            10: pd.Timestamp("1957-05-01 00:00:00"),
            11: pd.Timestamp("1957-06-01 00:00:00"),
            12: pd.Timestamp("1957-07-01 00:00:00"),
            13: pd.Timestamp("1957-08-01 00:00:00"),
            14: pd.Timestamp("1957-09-01 00:00:00"),
            15: pd.Timestamp("1957-10-01 00:00:00"),
            16: pd.Timestamp("1957-11-01 00:00:00"),
            17: pd.Timestamp("1957-12-01 00:00:00"),
            18: pd.Timestamp("1958-01-01 00:00:00"),
            19: pd.Timestamp("1958-02-01 00:00:00"),
            20: pd.Timestamp("1958-03-01 00:00:00"),
            21: pd.Timestamp("1958-04-01 00:00:00"),
            22: pd.Timestamp("1958-05-01 00:00:00"),
            23: pd.Timestamp("1958-06-01 00:00:00"),
            24: pd.Timestamp("1958-07-01 00:00:00"),
            25: pd.Timestamp("1958-08-01 00:00:00"),
            26: pd.Timestamp("1958-09-01 00:00:00"),
            27: pd.Timestamp("1958-10-01 00:00:00"),
            28: pd.Timestamp("1958-11-01 00:00:00"),
            29: pd.Timestamp("1958-12-01 00:00:00"),
            30: pd.Timestamp("1959-01-01 00:00:00"),
            31: pd.Timestamp("1959-02-01 00:00:00"),
            32: pd.Timestamp("1959-03-01 00:00:00"),
            33: pd.Timestamp("1959-04-01 00:00:00"),
            34: pd.Timestamp("1959-05-01 00:00:00"),
            35: pd.Timestamp("1959-06-01 00:00:00"),
        },
        "fcst": {
            0: 352.00928714748585,
            1: 364.17554690882633,
            2: 336.70827342265795,
            3: 318.6578986339586,
            4: 298.5756427393812,
            5: 315.5100398350665,
            6: 324.8790020843178,
            7: 326.06151035270346,
            8: 356.07157413457384,
            9: 351.7241739533581,
            10: 352.6207544250263,
            11: 384.1930355546814,
            12: 397.7685564240741,
            13: 403.01936850091147,
            14: 377.48869711627356,
            15: 355.8682364654478,
            16: 334.4235745388875,
            17: 356.2095451630178,
            18: 364.5621530242759,
            19: 365.4854472514923,
            20: 395.7807110180051,
            21: 390.2080684789574,
            22: 391.09108786995824,
            23: 417.2059658077068,
            24: 443.60785881273944,
            25: 441.79585104809223,
            26: 418.2075775027737,
            27: 393.0139726103589,
            28: 370.324964070078,
            29: 396.97458917903805,
            30: 404.25151009291676,
            31: 404.91378518245745,
            32: 435.4500965959009,
            33: 428.6514480648629,
            34: 429.5229552381207,
            35: 450.3249436993674,
        },
        "fcst_lower": {
            0: 337.71239756642393,
            1: 350.42874271432686,
            2: 322.20498723712325,
            3: 305.15692665226516,
            4: 284.6887206187098,
            5: 302.0463689090377,
            6: 311.78102414545486,
            7: 311.7886170118729,
            8: 342.16238135132477,
            9: 337.44637076820686,
            10: 338.6639564389216,
            11: 370.1151639860109,
            12: 383.7962896061119,
            13: 388.20764772624136,
            14: 363.7579647615208,
            15: 342.6274530733399,
            16: 320.4984516812753,
            17: 341.1641155187016,
            18: 350.9312952888534,
            19: 351.8470030108199,
            20: 380.52533826319103,
            21: 376.0811904474257,
            22: 376.6703044854923,
            23: 402.1343082586913,
            24: 428.46701700537153,
            25: 427.9812477650545,
            26: 403.67957703717985,
            27: 378.14922730562483,
            28: 354.7499682196989,
            29: 380.9282740159505,
            30: 388.78177487001966,
            31: 389.7339914563309,
            32: 419.93109627385684,
            33: 413.2731976385359,
            34: 414.0245998919729,
            35: 433.4503191235715,
        },
        "fcst_upper": {
            0: 366.0567430160846,
            1: 378.1968708859368,
            2: 350.27811377726226,
            3: 333.03609510919557,
            4: 312.6498126677246,
            5: 329.4039391164314,
            6: 338.4168037820807,
            7: 340.23393711844494,
            8: 370.60690661308354,
            9: 365.83580653066986,
            10: 366.2380877563112,
            11: 398.0645627098892,
            12: 411.8354105811776,
            13: 416.8105611071338,
            14: 390.99202743900764,
            15: 370.47398238849553,
            16: 349.987520631835,
            17: 369.6258284910425,
            18: 378.6893046758438,
            19: 379.7423801277896,
            20: 409.5622345625169,
            21: 405.0036774917741,
            22: 405.85422169618323,
            23: 432.18826750902826,
            24: 458.3417279089096,
            25: 456.59973182549254,
            26: 431.5238079835914,
            27: 407.75526764218205,
            28: 385.77155579890416,
            29: 412.04938004776284,
            30: 419.35375284573615,
            31: 419.72949551003285,
            32: 450.486786440989,
            33: 444.3825977938274,
            34: 445.44534085513146,
            35: 466.3848432564347,
        },
    }
)

PROPHET_18_90_FCST_DUMMY_DATA = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1956-07-01 00:00:00"),
            1: pd.Timestamp("1956-08-01 00:00:00"),
            2: pd.Timestamp("1956-09-01 00:00:00"),
            3: pd.Timestamp("1956-10-01 00:00:00"),
            4: pd.Timestamp("1956-11-01 00:00:00"),
            5: pd.Timestamp("1956-12-01 00:00:00"),
            6: pd.Timestamp("1957-01-01 00:00:00"),
            7: pd.Timestamp("1957-02-01 00:00:00"),
            8: pd.Timestamp("1957-03-01 00:00:00"),
            9: pd.Timestamp("1957-04-01 00:00:00"),
            10: pd.Timestamp("1957-05-01 00:00:00"),
            11: pd.Timestamp("1957-06-01 00:00:00"),
            12: pd.Timestamp("1957-07-01 00:00:00"),
            13: pd.Timestamp("1957-08-01 00:00:00"),
            14: pd.Timestamp("1957-09-01 00:00:00"),
            15: pd.Timestamp("1957-10-01 00:00:00"),
            16: pd.Timestamp("1957-11-01 00:00:00"),
            17: pd.Timestamp("1957-12-01 00:00:00"),
            18: pd.Timestamp("1958-01-01 00:00:00"),
            19: pd.Timestamp("1958-02-01 00:00:00"),
            20: pd.Timestamp("1958-03-01 00:00:00"),
            21: pd.Timestamp("1958-04-01 00:00:00"),
            22: pd.Timestamp("1958-05-01 00:00:00"),
            23: pd.Timestamp("1958-06-01 00:00:00"),
            24: pd.Timestamp("1958-07-01 00:00:00"),
            25: pd.Timestamp("1958-08-01 00:00:00"),
            26: pd.Timestamp("1958-09-01 00:00:00"),
            27: pd.Timestamp("1958-10-01 00:00:00"),
            28: pd.Timestamp("1958-11-01 00:00:00"),
            29: pd.Timestamp("1958-12-01 00:00:00"),
            30: pd.Timestamp("1959-01-01 00:00:00"),
            31: pd.Timestamp("1959-02-01 00:00:00"),
            32: pd.Timestamp("1959-03-01 00:00:00"),
            33: pd.Timestamp("1959-04-01 00:00:00"),
            34: pd.Timestamp("1959-05-01 00:00:00"),
            35: pd.Timestamp("1959-06-01 00:00:00"),
        },
        "fcst": {
            0: 356.5613317094504,
            1: 370.19535495664036,
            2: 337.8519223238328,
            3: 319.31850332833795,
            4: 298.559293038843,
            5: 320.04307097899687,
            6: 324.52639556893934,
            7: 318.78044906313545,
            8: 359.2562406626054,
            9: 353.68146791382765,
            10: 356.90562818646265,
            11: 391.3572995104848,
            12: 403.58760242115784,
            13: 409.89137566618956,
            14: 380.839425135621,
            15: 358.52969643921784,
            16: 336.1309468202851,
            17: 360.4787588358221,
            18: 366.07275521660677,
            19: 362.32814804104044,
            20: 398.63083972471054,
            21: 393.1182504784722,
            22: 397.5024306061403,
            23: 426.5500705549409,
            24: 450.67865841010706,
            25: 449.53098734011917,
            26: 423.78067523923465,
            27: 397.6643002142486,
            28: 373.7272916741297,
            29: 400.99122522214276,
            30: 407.68009060792417,
            31: 405.8667155882805,
            32: 437.92999113873,
            33: 432.54077398421003,
            34: 438.08046490412573,
            35: 461.8390389136368,
        },
        "fcst_lower": {
            0: 343.20461396462565,
            1: 356.6764597191184,
            2: 325.7566163312783,
            3: 305.5538086231309,
            4: 284.986965572698,
            5: 306.2800855259901,
            6: 312.42518339708806,
            7: 305.38313360399644,
            8: 346.0429313788403,
            9: 339.97197177658296,
            10: 343.4432375149928,
            11: 378.18001545091323,
            12: 389.7015830782581,
            13: 395.4214724822597,
            14: 368.19031998713257,
            15: 344.19252219633876,
            16: 322.8120782134958,
            17: 347.63009038253085,
            18: 351.9644193938126,
            19: 348.24334510098794,
            20: 384.75196474020913,
            21: 379.0833057357406,
            22: 383.264135206549,
            23: 412.55010339293347,
            24: 436.80646530190177,
            25: 434.47892800833637,
            26: 409.9268245174533,
            27: 384.26042864907043,
            28: 359.49218701140677,
            29: 386.43745480688466,
            30: 393.5529602614205,
            31: 390.9199504523373,
            32: 422.60689754136286,
            33: 417.9874213337745,
            34: 422.95833316717346,
            35: 446.41909553476995,
        },
        "fcst_upper": {
            0: 369.1369936734484,
            1: 383.1034603837521,
            2: 351.7330861153634,
            3: 333.12205900486634,
            4: 312.2638235357573,
            5: 334.6427407632721,
            6: 338.13555269909097,
            7: 332.645480160144,
            8: 371.71161482207305,
            9: 367.14903045863076,
            10: 369.8571160762181,
            11: 404.98129371270596,
            12: 417.9406249167847,
            13: 423.3202055030398,
            14: 394.67358892222234,
            15: 371.94329808599826,
            16: 350.20337156349444,
            17: 374.42518010052976,
            18: 379.8141517503943,
            19: 375.68412373895603,
            20: 412.2844298012189,
            21: 407.1200817560411,
            22: 411.54577559071936,
            23: 439.9549775247772,
            24: 464.8770781444939,
            25: 463.783324005212,
            26: 438.10224002291477,
            27: 412.1816769938384,
            28: 389.08413078035676,
            29: 414.8093471469727,
            30: 422.18127929593766,
            31: 420.05394904230957,
            32: 452.28954374900314,
            33: 447.64999973474715,
            34: 453.4283954321018,
            35: 477.4051778794113,
        },
    }
)

PROPHET_36_108_FCST_DUMMY_DATA = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1956-07-01 00:00:00"),
            1: pd.Timestamp("1956-08-01 00:00:00"),
            2: pd.Timestamp("1956-09-01 00:00:00"),
            3: pd.Timestamp("1956-10-01 00:00:00"),
            4: pd.Timestamp("1956-11-01 00:00:00"),
            5: pd.Timestamp("1956-12-01 00:00:00"),
            6: pd.Timestamp("1957-01-01 00:00:00"),
            7: pd.Timestamp("1957-02-01 00:00:00"),
            8: pd.Timestamp("1957-03-01 00:00:00"),
            9: pd.Timestamp("1957-04-01 00:00:00"),
            10: pd.Timestamp("1957-05-01 00:00:00"),
            11: pd.Timestamp("1957-06-01 00:00:00"),
            12: pd.Timestamp("1957-07-01 00:00:00"),
            13: pd.Timestamp("1957-08-01 00:00:00"),
            14: pd.Timestamp("1957-09-01 00:00:00"),
            15: pd.Timestamp("1957-10-01 00:00:00"),
            16: pd.Timestamp("1957-11-01 00:00:00"),
            17: pd.Timestamp("1957-12-01 00:00:00"),
            18: pd.Timestamp("1958-01-01 00:00:00"),
            19: pd.Timestamp("1958-02-01 00:00:00"),
            20: pd.Timestamp("1958-03-01 00:00:00"),
            21: pd.Timestamp("1958-04-01 00:00:00"),
            22: pd.Timestamp("1958-05-01 00:00:00"),
            23: pd.Timestamp("1958-06-01 00:00:00"),
            24: pd.Timestamp("1958-07-01 00:00:00"),
            25: pd.Timestamp("1958-08-01 00:00:00"),
            26: pd.Timestamp("1958-09-01 00:00:00"),
            27: pd.Timestamp("1958-10-01 00:00:00"),
            28: pd.Timestamp("1958-11-01 00:00:00"),
            29: pd.Timestamp("1958-12-01 00:00:00"),
            30: pd.Timestamp("1959-01-01 00:00:00"),
            31: pd.Timestamp("1959-02-01 00:00:00"),
            32: pd.Timestamp("1959-03-01 00:00:00"),
            33: pd.Timestamp("1959-04-01 00:00:00"),
            34: pd.Timestamp("1959-05-01 00:00:00"),
            35: pd.Timestamp("1959-06-01 00:00:00"),
        },
        "fcst": {
            0: 356.5613317094504,
            1: 370.19535495664036,
            2: 337.8519223238328,
            3: 319.31850332833795,
            4: 298.559293038843,
            5: 320.04307097899687,
            6: 324.52639556893934,
            7: 318.78044906313545,
            8: 359.2562406626054,
            9: 353.68146791382765,
            10: 356.90562818646265,
            11: 391.3572995104848,
            12: 403.58760242115784,
            13: 409.89137566618956,
            14: 380.839425135621,
            15: 358.52969643921784,
            16: 336.1309468202851,
            17: 360.4787588358221,
            18: 366.07275521660677,
            19: 362.32814804104044,
            20: 398.63083972471054,
            21: 393.1182504784722,
            22: 397.5024306061403,
            23: 426.5500705549409,
            24: 450.67865841010706,
            25: 449.53098734011917,
            26: 423.78067523923465,
            27: 397.6643002142486,
            28: 373.7272916741297,
            29: 400.99122522214276,
            30: 407.68009060792417,
            31: 405.8667155882805,
            32: 437.92999113873,
            33: 432.54077398421003,
            34: 438.08046490412573,
            35: 461.8390389136368,
        },
        "fcst_lower": {
            0: 342.82266167555446,
            1: 356.18649250624287,
            2: 324.8073267029821,
            3: 306.9141839368012,
            4: 285.9316818305602,
            5: 306.3561622190904,
            6: 310.44474580959275,
            7: 304.5310444393358,
            8: 345.6760596416288,
            9: 341.1275399107599,
            10: 343.6608420288016,
            11: 377.42861593747557,
            12: 389.6601831587672,
            13: 396.16830583297957,
            14: 365.78869641281415,
            15: 344.93001315733557,
            16: 323.074806314127,
            17: 346.93832068224856,
            18: 352.65472877796617,
            19: 348.71380657066396,
            20: 386.20511815917354,
            21: 381.17613344617524,
            22: 384.2225044130897,
            23: 413.27390184560994,
            24: 436.08334093932007,
            25: 435.4825737286817,
            26: 410.07562687553605,
            27: 384.64437419475405,
            28: 359.6145778561357,
            29: 385.5902096284358,
            30: 392.6668250321382,
            31: 390.50632613495316,
            32: 423.0773550641319,
            33: 418.08986954789077,
            34: 423.2018170785157,
            35: 447.53681730467844,
        },
        "fcst_upper": {
            0: 370.38601749853694,
            1: 384.2278219711307,
            2: 352.0636773871627,
            3: 332.7161206072674,
            4: 312.57182804548074,
            5: 333.71095312707007,
            6: 337.5419444675524,
            7: 332.5016564041385,
            8: 373.6787201780433,
            9: 366.9101573806095,
            10: 370.4657744757551,
            11: 405.11350242223926,
            12: 416.261054558394,
            13: 423.4962414057239,
            14: 394.0190917046389,
            15: 371.7394713182696,
            16: 350.3259856077076,
            17: 374.16117942597026,
            18: 380.2186909720062,
            19: 375.18794343103275,
            20: 412.4724850475396,
            21: 407.52599175173106,
            22: 411.1311292074606,
            23: 441.00586774437875,
            24: 463.76062200257036,
            25: 463.31306060579544,
            26: 438.1217078810615,
            27: 412.78098558694603,
            28: 387.06039980281196,
            29: 414.7514514491066,
            30: 422.56902851274947,
            31: 419.3013747496113,
            32: 452.4480085965222,
            33: 445.99086607358555,
            34: 452.35210504766707,
            35: 477.4513874002895,
        },
    }
)

PROPHET_0_72_GAP_36_FCST_DUMMY_DATA = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1955-01-01 00:00:00"),
            1: pd.Timestamp("1955-02-01 00:00:00"),
            2: pd.Timestamp("1955-03-01 00:00:00"),
            3: pd.Timestamp("1955-04-01 00:00:00"),
            4: pd.Timestamp("1955-05-01 00:00:00"),
            5: pd.Timestamp("1955-06-01 00:00:00"),
            6: pd.Timestamp("1955-07-01 00:00:00"),
            7: pd.Timestamp("1955-08-01 00:00:00"),
            8: pd.Timestamp("1955-09-01 00:00:00"),
            9: pd.Timestamp("1955-10-01 00:00:00"),
            10: pd.Timestamp("1955-11-01 00:00:00"),
            11: pd.Timestamp("1955-12-01 00:00:00"),
            12: pd.Timestamp("1956-01-01 00:00:00"),
            13: pd.Timestamp("1956-02-01 00:00:00"),
            14: pd.Timestamp("1956-03-01 00:00:00"),
            15: pd.Timestamp("1956-04-01 00:00:00"),
            16: pd.Timestamp("1956-05-01 00:00:00"),
            17: pd.Timestamp("1956-06-01 00:00:00"),
            18: pd.Timestamp("1956-07-01 00:00:00"),
            19: pd.Timestamp("1956-08-01 00:00:00"),
            20: pd.Timestamp("1956-09-01 00:00:00"),
            21: pd.Timestamp("1956-10-01 00:00:00"),
            22: pd.Timestamp("1956-11-01 00:00:00"),
            23: pd.Timestamp("1956-12-01 00:00:00"),
            24: pd.Timestamp("1957-01-01 00:00:00"),
            25: pd.Timestamp("1957-02-01 00:00:00"),
            26: pd.Timestamp("1957-03-01 00:00:00"),
            27: pd.Timestamp("1957-04-01 00:00:00"),
            28: pd.Timestamp("1957-05-01 00:00:00"),
            29: pd.Timestamp("1957-06-01 00:00:00"),
            30: pd.Timestamp("1957-07-01 00:00:00"),
            31: pd.Timestamp("1957-08-01 00:00:00"),
            32: pd.Timestamp("1957-09-01 00:00:00"),
            33: pd.Timestamp("1957-10-01 00:00:00"),
            34: pd.Timestamp("1957-11-01 00:00:00"),
            35: pd.Timestamp("1957-12-01 00:00:00"),
            36: pd.Timestamp("1958-01-01 00:00:00"),
            37: pd.Timestamp("1958-02-01 00:00:00"),
            38: pd.Timestamp("1958-03-01 00:00:00"),
            39: pd.Timestamp("1958-04-01 00:00:00"),
            40: pd.Timestamp("1958-05-01 00:00:00"),
            41: pd.Timestamp("1958-06-01 00:00:00"),
            42: pd.Timestamp("1958-07-01 00:00:00"),
            43: pd.Timestamp("1958-08-01 00:00:00"),
            44: pd.Timestamp("1958-09-01 00:00:00"),
            45: pd.Timestamp("1958-10-01 00:00:00"),
            46: pd.Timestamp("1958-11-01 00:00:00"),
            47: pd.Timestamp("1958-12-01 00:00:00"),
            48: pd.Timestamp("1959-01-01 00:00:00"),
            49: pd.Timestamp("1959-02-01 00:00:00"),
            50: pd.Timestamp("1959-03-01 00:00:00"),
            51: pd.Timestamp("1959-04-01 00:00:00"),
            52: pd.Timestamp("1959-05-01 00:00:00"),
            53: pd.Timestamp("1959-06-01 00:00:00"),
            54: pd.Timestamp("1959-07-01 00:00:00"),
            55: pd.Timestamp("1959-08-01 00:00:00"),
            56: pd.Timestamp("1959-09-01 00:00:00"),
            57: pd.Timestamp("1959-10-01 00:00:00"),
            58: pd.Timestamp("1959-11-01 00:00:00"),
            59: pd.Timestamp("1959-12-01 00:00:00"),
            60: pd.Timestamp("1960-01-01 00:00:00"),
            61: pd.Timestamp("1960-02-01 00:00:00"),
            62: pd.Timestamp("1960-03-01 00:00:00"),
            63: pd.Timestamp("1960-04-01 00:00:00"),
            64: pd.Timestamp("1960-05-01 00:00:00"),
            65: pd.Timestamp("1960-06-01 00:00:00"),
            66: pd.Timestamp("1960-07-01 00:00:00"),
            67: pd.Timestamp("1960-08-01 00:00:00"),
            68: pd.Timestamp("1960-09-01 00:00:00"),
            69: pd.Timestamp("1960-10-01 00:00:00"),
            70: pd.Timestamp("1960-11-01 00:00:00"),
            71: pd.Timestamp("1960-12-01 00:00:00"),
        },
        "fcst": {
            0: 237.82191741092083,
            1: 241.79202945022217,
            2: 267.1411737358285,
            3: 257.74440815387146,
            4: 261.9618687066704,
            5: 274.90677518199567,
            6: 303.3465713520833,
            7: 297.759518279388,
            8: 281.38523924483326,
            9: 254.19994121360392,
            10: 233.4338265953682,
            11: 255.2797226719209,
            12: 258.485964151307,
            13: 264.35209890708825,
            14: 289.00117441131954,
            15: 283.3826058720747,
            16: 277.05188323042364,
            17: 304.8330125137641,
            18: 318.1301551795879,
            19: 327.10631612791803,
            20: 296.231806714001,
            21: 277.08994387456875,
            22: 255.61166085025698,
            23: 276.46818345277865,
            24: 283.3613215854848,
            25: 283.5609841115963,
            26: 310.6869547306119,
            27: 303.76305466769344,
            28: 300.9769629347439,
            29: 323.80656762803085,
            30: 342.1511443674959,
            31: 346.27027622495586,
            32: 320.2058399812674,
            33: 298.4283096940648,
            34: 277.1569052401928,
            35: 298.36152854116483,
            36: 304.004983550422,
            37: 306.08567954994453,
            38: 332.3457661326,
            39: 324.16214228684674,
            40: 324.89300304090267,
            41: 342.776056946593,
            42: 366.16927444694636,
            43: 365.43288261476465,
            44: 344.2030151563152,
            45: 319.74373103450324,
            46: 298.709714256601,
            47: 320.24421258224845,
            48: 324.65840223528846,
            49: 328.6285142745866,
            50: 353.9776585601958,
            51: 344.5808929782378,
            52: 348.7983535310376,
            53: 361.74326000636586,
            54: 390.18305617645456,
            55: 384.59600310375913,
            56: 368.22172406920004,
            57: 341.0364260379711,
            58: 320.2703114197387,
            59: 342.11620749628815,
            60: 345.3224489756746,
            61: 351.18858373145736,
            62: 375.83765923568814,
            63: 370.21909069644335,
            64: 363.88836805479525,
            65: 391.66949733813266,
            66: 404.96664000395316,
            67: 413.942800952291,
            68: 383.0682915383717,
            69: 363.92642869894047,
            70: 342.44814567462777,
            71: 363.3046682771503,
        },
        "fcst_lower": {
            0: 226.59558070617862,
            1: 230.72418878779976,
            2: 256.8848076730756,
            3: 247.17286006992407,
            4: 250.3022195607792,
            5: 263.27178504231534,
            6: 291.321583987187,
            7: 286.59515474657996,
            8: 270.31392986370844,
            9: 243.47293053759216,
            10: 223.02974667040667,
            11: 243.7299657806913,
            12: 246.8455268067836,
            13: 252.79597532354637,
            14: 278.54413109085493,
            15: 272.21675284881184,
            16: 266.5746157093272,
            17: 293.4518542321931,
            18: 305.768756217527,
            19: 316.6856625727734,
            20: 284.5779256612787,
            21: 265.7708370265654,
            22: 244.33938522844878,
            23: 265.1531168158428,
            24: 270.57098832958286,
            25: 272.15735876230093,
            26: 298.6828282368792,
            27: 292.54705089568773,
            28: 289.05516888878515,
            29: 312.0064741152824,
            30: 329.50956028671726,
            31: 334.591810711901,
            32: 309.04379699214314,
            33: 285.93029594830614,
            34: 264.87826105366855,
            35: 284.7919622927401,
            36: 291.1626933439099,
            37: 293.3176009142277,
            38: 319.88686878460777,
            39: 311.46249044299134,
            40: 311.48507325715445,
            41: 328.9449003626957,
            42: 353.11856977026133,
            43: 352.5865576395984,
            44: 330.1643281974489,
            45: 306.01570192332025,
            46: 285.1667378070007,
            47: 305.99768070862416,
            48: 309.7100324689925,
            49: 314.6755312532607,
            50: 339.5202393784388,
            51: 330.6644734487008,
            52: 334.1008080438972,
            53: 347.0319441543028,
            54: 374.4121134671332,
            55: 369.22703547822994,
            56: 352.86565583417433,
            57: 324.5297093312721,
            58: 305.21407425325805,
            59: 326.4618368725278,
            60: 328.9253562801482,
            61: 335.1361687892991,
            62: 359.7500581640929,
            63: 353.5790391301544,
            64: 347.12244271203366,
            65: 375.52288603944953,
            66: 387.73814772038315,
            67: 395.85836801426603,
            68: 365.4019790343699,
            69: 346.0514002841461,
            70: 324.8604710189462,
            71: 345.045286486881,
        },
        "fcst_upper": {
            0: 248.89435279629862,
            1: 253.35382806071627,
            2: 278.7008763720259,
            3: 269.39573304146575,
            4: 273.7328156821754,
            5: 287.1536656063239,
            6: 315.1720645678249,
            7: 308.64147398893937,
            8: 292.02057969305014,
            9: 265.7823914639229,
            10: 245.3135116668101,
            11: 267.0295270976494,
            12: 269.80484013687953,
            13: 275.43985533829925,
            14: 300.1900652239041,
            15: 294.16413962568424,
            16: 288.78826603721865,
            17: 316.0994519361272,
            18: 329.33369085089737,
            19: 339.11180650460346,
            20: 307.6598446619491,
            21: 288.87671699333606,
            22: 266.40696909906217,
            23: 289.1071568239538,
            24: 294.0934504210469,
            25: 295.3981068431675,
            26: 322.5383778806753,
            27: 314.9415110963134,
            28: 312.8333764125105,
            29: 336.0555903162685,
            30: 355.2883140963089,
            31: 358.2188192123737,
            32: 331.6755504031773,
            33: 310.5784720164606,
            34: 290.2373605646598,
            35: 310.645709955227,
            36: 316.8078078093544,
            37: 318.93916230067634,
            38: 346.08516251384003,
            39: 337.38003788660075,
            40: 337.6075654341096,
            41: 355.99082329608785,
            42: 379.3710998869037,
            43: 378.72552555484464,
            44: 358.2590351617507,
            45: 333.2212108951843,
            46: 312.83968346875633,
            47: 335.09117828376446,
            48: 338.396319864064,
            49: 342.15621675645076,
            50: 368.6743361350908,
            51: 359.23633609883063,
            52: 363.32796925850516,
            53: 377.4443748358508,
            54: 405.72068348351655,
            55: 400.36619260715,
            56: 382.779036095405,
            57: 354.8225715421405,
            58: 335.52961745049765,
            59: 357.31840776864755,
            60: 361.23299512741795,
            61: 367.9560503092987,
            62: 390.81781508008186,
            63: 387.00874642731554,
            64: 380.8532449823027,
            65: 408.63666648518597,
            66: 423.47153034828,
            67: 430.574266488443,
            68: 401.6187591615602,
            69: 381.6797656158867,
            70: 360.64963954887946,
            71: 381.395069069841,
        },
    }
)
