# ASF Tools for Python

[![PyPI license](https://img.shields.io/pypi/l/asf_tools.svg)](https://pypi.python.org/pypi/asf_tools/)
[![PyPI pyversions](https://img.shields.io/pypi/pyversions/asf_tools.svg)](https://pypi.python.org/pypi/asf_tools/)
[![PyPI version](https://img.shields.io/pypi/v/asf_tools.svg)](https://pypi.python.org/pypi/asf_tools/)
[![Conda version](https://img.shields.io/conda/vn/conda-forge/asf_tools)](https://anaconda.org/conda-forge/asf_tools)
[![Conda platforms](https://img.shields.io/conda/pn/conda-forge/asf_tools)](https://anaconda.org/conda-forge/asf_tools)

[![DOI](https://zenodo.org/badge/295506894.svg)](https://zenodo.org/badge/latestdoi/295506894)

`asf_tools` is a Python package for working with Synthetic Aperture Radar (SAR) data.
It was designed for working with datasets generated by
[HyP3](https://hyp3-docs.asf.alaska.edu/), but several of the tools have the
potential to be used with a variety of rasters, including non-SAR datasets.


## Install

In order to easily manage dependencies, we recommend using dedicated project
environments via [Anaconda/Miniconda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/index.html).
It is also possible to use [Python virtual environments](https://docs.python.org/3/tutorial/venv.html),
but installation of non-python dependencies (e.g., `gdal`) can be challenging. 

`asf_tools` can be installed into a conda environment with:

```
conda install -c conda-forge asf_tools
```

or into a virtual environment with:

```
python -m pip install asf_tools
```

### Running as a Docker container

We also publish a [Docker](https://docs.docker.com/get-started/) image for `asf_tools`, with all the dependencies
pre-installed, to the GitHub Container Registry:
<https://github.com/ASFHyP3/asf-tools/pkgs/container/asf-tools>.

You can pull an image with the latest released version of `asf_tools`  with the command:
```
docker pull ghcr.io/asfhyp3/asf-tools:latest
```

Or, the development version with: 
```
docker pull ghcr.io/asfhyp3/asf-tools:test
```

And then run the container with:
```
docker run --rm -it ghcr.io/asfhyp3/asf-tools:latest
```
which will drop you into a `bash` shell inside the container with an active `asf-tools` conda environment. 

To move data between your local (host) machine and the container, you can mount a 
[volume](https://docs.docker.com/storage/volumes/) with:
```
docker run --rm -it -v /path/to/data:/home/conda/data ghcr.io/asfhyp3/asf-tools:latest
```

## Quick Usage

### Local Resolution Weighted Composite

The `make_composite` tool allows you to create a local-resolution-weighted composite
from a set of Sentinel-1 RTC products ([D. Small, 2012](https://doi.org/10.1109/IGARSS.2012.6350465)).
It is intended to be used with RTC products generated by [ASF HyP3](https://hyp3-docs.asf.alaska.edu/using/vertex).

You will need to request RTC products using the `Include Scattering Area` option,
then download and unzip them into an empty directory.

To generate a composite of the co-polarization images, navigate to the directory
containing the unzipped RTC products and run:
```
make_composite VV-composite */*VV.tif
```

To generate a composite of the cross-polarization images, navigate to the directory
containing the unzipped RTC products and run:
```
make_composite VH-composite */*VH.tif
```

#### Usage Tip
Because the imagery has been radiometrically terrain corrected (RTC), geometric and
radiometric distortions have been removed from the files to be composited. One the
strong points of LRW composites is that you combine both ascending and descending
datatakes into a single product. In this manner no layover or shadow masks are
required - what is shadowed on an ascending pass is visible in a descending pass
and vice-versa. Thus, not only is it possible to combine ascending and descending,
but it is highly encouraged. Using many datatakes from both the ascending and
descending satellite passes will make the best composites possible.

#### About Local Resolution Weighting (LRW)
In an LRW composite, each satellite pass contributes to creating the output pixels.
The amount of this contribution is scaled by the inverse of the scattering area used
during terrain correction (thus the need for requesting the area map option of HyP3 RTC).
The inverse of the surface scattering area, also referred to as local resolution,
is multiplied by each pixel's backscatter value. The results of all of the images
covering any single pixel are then summed. This total is then divided by the sum
of the weights used to get the output average backscatter.

### Water extent mapping

The `water_map` tool allows you to create a surface water extent map from a Sentinel-1
dual-pol (VV+VH) RTC product. It is intended to be used with RTC products generated by
[ASF HyP3](https://hyp3-docs.asf.alaska.edu/using/vertex).

Additionally, a HAND (height above nearest drainage) GeoTIFF that is pixel aligned to
the RTC images is required, and preferably derived from the same DEM used to correct
the RTC images -- the quality of the HAND used is directly tied to the quality of the
output water extent map.

To make a water extent map, run:
```
water_map [OUT_RASTER] [VV_RASTER] [VH_RASTER] [HAND_RASTER]
```

For more information and to see the options available, see:
```
water_map --help
```

For details on the algorithm see the `asf_tools.water_map.make_water_map` docstring.
<!-- FIXME: Link to API reference on our docs page! -->
