# coding: utf-8

"""
    Kubernetes

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1.12.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..api_client import ApiClient


class CustomObjectsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_cluster_custom_object(self, group, version, plural, body, **kwargs):
        """
        Creates a cluster scoped Custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cluster_custom_object(group, version, plural, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param object body: The JSON schema of the Resource to create. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cluster_custom_object_with_http_info(group, version, plural, body, **kwargs)
        else:
            (data) = self.create_cluster_custom_object_with_http_info(group, version, plural, body, **kwargs)
            return data

    def create_cluster_custom_object_with_http_info(self, group, version, plural, body, **kwargs):
        """
        Creates a cluster scoped Custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cluster_custom_object_with_http_info(group, version, plural, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param object body: The JSON schema of the Resource to create. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'body', 'pretty']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `create_cluster_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `create_cluster_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `create_cluster_custom_object`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_cluster_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_namespaced_custom_object(self, group, version, namespace, plural, body, **kwargs):
        """
        Creates a namespace scoped Custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_custom_object(group, version, namespace, plural, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param object body: The JSON schema of the Resource to create. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_namespaced_custom_object_with_http_info(group, version, namespace, plural, body, **kwargs)
        else:
            (data) = self.create_namespaced_custom_object_with_http_info(group, version, namespace, plural, body, **kwargs)
            return data

    def create_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, body, **kwargs):
        """
        Creates a namespace scoped Custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_custom_object_with_http_info(group, version, namespace, plural, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param object body: The JSON schema of the Resource to create. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'body', 'pretty']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `create_namespaced_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `create_namespaced_custom_object`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `create_namespaced_custom_object`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_cluster_custom_object(self, group, version, plural, name, body, **kwargs):
        """
        Deletes the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cluster_custom_object(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param V1DeleteOptions body: (required)
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)
        else:
            (data) = self.delete_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)
            return data

    def delete_cluster_custom_object_with_http_info(self, group, version, plural, name, body, **kwargs):
        """
        Deletes the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cluster_custom_object_with_http_info(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param V1DeleteOptions body: (required)
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `delete_cluster_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `delete_cluster_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `delete_cluster_custom_object`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_cluster_custom_object`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_cluster_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'grace_period_seconds' in params:
            query_params.append(('gracePeriodSeconds', params['grace_period_seconds']))
        if 'orphan_dependents' in params:
            query_params.append(('orphanDependents', params['orphan_dependents']))
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_namespaced_custom_object(self, group, version, namespace, plural, name, body, **kwargs):
        """
        Deletes the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_custom_object(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param V1DeleteOptions body: (required)
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)
        else:
            (data) = self.delete_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)
            return data

    def delete_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):
        """
        Deletes the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param V1DeleteOptions body: (required)
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `delete_namespaced_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `delete_namespaced_custom_object`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `delete_namespaced_custom_object`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_custom_object`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'grace_period_seconds' in params:
            query_params.append(('gracePeriodSeconds', params['grace_period_seconds']))
        if 'orphan_dependents' in params:
            query_params.append(('orphanDependents', params['orphan_dependents']))
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_cluster_custom_object(self, group, version, plural, name, **kwargs):
        """
        Returns a cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_custom_object(group, version, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_custom_object_with_http_info(group, version, plural, name, **kwargs)
        else:
            (data) = self.get_cluster_custom_object_with_http_info(group, version, plural, name, **kwargs)
            return data

    def get_cluster_custom_object_with_http_info(self, group, version, plural, name, **kwargs):
        """
        Returns a cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_custom_object_with_http_info(group, version, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_cluster_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_cluster_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `get_cluster_custom_object`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_cluster_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_cluster_custom_object_scale(self, group, version, plural, name, **kwargs):
        """
        read scale of the specified custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_custom_object_scale(group, version, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_custom_object_scale_with_http_info(group, version, plural, name, **kwargs)
        else:
            (data) = self.get_cluster_custom_object_scale_with_http_info(group, version, plural, name, **kwargs)
            return data

    def get_cluster_custom_object_scale_with_http_info(self, group, version, plural, name, **kwargs):
        """
        read scale of the specified custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_custom_object_scale_with_http_info(group, version, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_custom_object_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_cluster_custom_object_scale`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_cluster_custom_object_scale`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `get_cluster_custom_object_scale`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_cluster_custom_object_scale`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}/scale', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_cluster_custom_object_status(self, group, version, plural, name, **kwargs):
        """
        read status of the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_custom_object_status(group, version, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_custom_object_status_with_http_info(group, version, plural, name, **kwargs)
        else:
            (data) = self.get_cluster_custom_object_status_with_http_info(group, version, plural, name, **kwargs)
            return data

    def get_cluster_custom_object_status_with_http_info(self, group, version, plural, name, **kwargs):
        """
        read status of the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_custom_object_status_with_http_info(group, version, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_custom_object_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_cluster_custom_object_status`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_cluster_custom_object_status`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `get_cluster_custom_object_status`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_cluster_custom_object_status`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}/status', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_namespaced_custom_object(self, group, version, namespace, plural, name, **kwargs):
        """
        Returns a namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_custom_object(group, version, namespace, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, **kwargs)
        else:
            (data) = self.get_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, **kwargs)
            return data

    def get_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, name, **kwargs):
        """
        Returns a namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_namespaced_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_namespaced_custom_object`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_namespaced_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `get_namespaced_custom_object`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_namespaced_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_namespaced_custom_object_scale(self, group, version, namespace, plural, name, **kwargs):
        """
        read scale of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_custom_object_scale(group, version, namespace, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, **kwargs)
        else:
            (data) = self.get_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, **kwargs)
            return data

    def get_namespaced_custom_object_scale_with_http_info(self, group, version, namespace, plural, name, **kwargs):
        """
        read scale of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespaced_custom_object_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_namespaced_custom_object_scale`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_namespaced_custom_object_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_namespaced_custom_object_scale`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `get_namespaced_custom_object_scale`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_namespaced_custom_object_scale`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_namespaced_custom_object_status(self, group, version, namespace, plural, name, **kwargs):
        """
        read status of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_custom_object_status(group, version, namespace, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, **kwargs)
        else:
            (data) = self.get_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, **kwargs)
            return data

    def get_namespaced_custom_object_status_with_http_info(self, group, version, namespace, plural, name, **kwargs):
        """
        read status of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespaced_custom_object_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_namespaced_custom_object_status`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_namespaced_custom_object_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_namespaced_custom_object_status`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `get_namespaced_custom_object_status`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_namespaced_custom_object_status`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_cluster_custom_object(self, group, version, plural, **kwargs):
        """
        list or watch cluster scoped custom objects
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cluster_custom_object(group, version, plural, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cluster_custom_object_with_http_info(group, version, plural, **kwargs)
        else:
            (data) = self.list_cluster_custom_object_with_http_info(group, version, plural, **kwargs)
            return data

    def list_cluster_custom_object_with_http_info(self, group, version, plural, **kwargs):
        """
        list or watch cluster scoped custom objects
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cluster_custom_object_with_http_info(group, version, plural, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'pretty', 'label_selector', 'resource_version', 'watch']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `list_cluster_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `list_cluster_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `list_cluster_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'label_selector' in params:
            query_params.append(('labelSelector', params['label_selector']))
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))
        if 'watch' in params:
            query_params.append(('watch', params['watch']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/json;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_namespaced_custom_object(self, group, version, namespace, plural, **kwargs):
        """
        list or watch namespace scoped custom objects
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_custom_object(group, version, namespace, plural, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_namespaced_custom_object_with_http_info(group, version, namespace, plural, **kwargs)
        else:
            (data) = self.list_namespaced_custom_object_with_http_info(group, version, namespace, plural, **kwargs)
            return data

    def list_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, **kwargs):
        """
        list or watch namespace scoped custom objects
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_custom_object_with_http_info(group, version, namespace, plural, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'pretty', 'label_selector', 'resource_version', 'watch']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `list_namespaced_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `list_namespaced_custom_object`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `list_namespaced_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'label_selector' in params:
            query_params.append(('labelSelector', params['label_selector']))
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))
        if 'watch' in params:
            query_params.append(('watch', params['watch']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/json;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_cluster_custom_object(self, group, version, plural, name, body, **kwargs):
        """
        patch the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_cluster_custom_object(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)
        else:
            (data) = self.patch_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)
            return data

    def patch_cluster_custom_object_with_http_info(self, group, version, plural, name, body, **kwargs):
        """
        patch the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_cluster_custom_object_with_http_info(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `patch_cluster_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `patch_cluster_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `patch_cluster_custom_object`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_cluster_custom_object`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_cluster_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_cluster_custom_object_scale(self, group, version, plural, name, body, **kwargs):
        """
        partially update scale of the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_cluster_custom_object_scale(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_cluster_custom_object_scale_with_http_info(group, version, plural, name, body, **kwargs)
        else:
            (data) = self.patch_cluster_custom_object_scale_with_http_info(group, version, plural, name, body, **kwargs)
            return data

    def patch_cluster_custom_object_scale_with_http_info(self, group, version, plural, name, body, **kwargs):
        """
        partially update scale of the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_cluster_custom_object_scale_with_http_info(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_cluster_custom_object_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `patch_cluster_custom_object_scale`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `patch_cluster_custom_object_scale`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `patch_cluster_custom_object_scale`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_cluster_custom_object_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_cluster_custom_object_scale`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}/scale', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_cluster_custom_object_status(self, group, version, plural, name, body, **kwargs):
        """
        partially update status of the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_cluster_custom_object_status(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_cluster_custom_object_status_with_http_info(group, version, plural, name, body, **kwargs)
        else:
            (data) = self.patch_cluster_custom_object_status_with_http_info(group, version, plural, name, body, **kwargs)
            return data

    def patch_cluster_custom_object_status_with_http_info(self, group, version, plural, name, body, **kwargs):
        """
        partially update status of the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_cluster_custom_object_status_with_http_info(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_cluster_custom_object_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `patch_cluster_custom_object_status`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `patch_cluster_custom_object_status`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `patch_cluster_custom_object_status`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_cluster_custom_object_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_cluster_custom_object_status`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}/status', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_custom_object(self, group, version, namespace, plural, name, body, **kwargs):
        """
        patch the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_custom_object(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)
        else:
            (data) = self.patch_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)
            return data

    def patch_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):
        """
        patch the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `patch_namespaced_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `patch_namespaced_custom_object`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `patch_namespaced_custom_object`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_custom_object`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_custom_object_scale(self, group, version, namespace, plural, name, body, **kwargs):
        """
        partially update scale of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_custom_object_scale(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, body, **kwargs)
        else:
            (data) = self.patch_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, body, **kwargs)
            return data

    def patch_namespaced_custom_object_scale_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):
        """
        partially update scale of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_custom_object_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `patch_namespaced_custom_object_scale`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `patch_namespaced_custom_object_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_custom_object_scale`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `patch_namespaced_custom_object_scale`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_custom_object_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_custom_object_scale`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_custom_object_status(self, group, version, namespace, plural, name, body, **kwargs):
        """
        partially update status of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_custom_object_status(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, body, **kwargs)
        else:
            (data) = self.patch_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, body, **kwargs)
            return data

    def patch_namespaced_custom_object_status_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):
        """
        partially update status of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_custom_object_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `patch_namespaced_custom_object_status`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `patch_namespaced_custom_object_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_custom_object_status`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `patch_namespaced_custom_object_status`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_custom_object_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_custom_object_status`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_cluster_custom_object(self, group, version, plural, name, body, **kwargs):
        """
        replace the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_cluster_custom_object(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to replace. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)
        else:
            (data) = self.replace_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)
            return data

    def replace_cluster_custom_object_with_http_info(self, group, version, plural, name, body, **kwargs):
        """
        replace the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_cluster_custom_object_with_http_info(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to replace. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `replace_cluster_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `replace_cluster_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `replace_cluster_custom_object`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_cluster_custom_object`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_cluster_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_cluster_custom_object_scale(self, group, version, plural, name, body, **kwargs):
        """
        replace scale of the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_cluster_custom_object_scale(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_cluster_custom_object_scale_with_http_info(group, version, plural, name, body, **kwargs)
        else:
            (data) = self.replace_cluster_custom_object_scale_with_http_info(group, version, plural, name, body, **kwargs)
            return data

    def replace_cluster_custom_object_scale_with_http_info(self, group, version, plural, name, body, **kwargs):
        """
        replace scale of the specified cluster scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_cluster_custom_object_scale_with_http_info(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_cluster_custom_object_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `replace_cluster_custom_object_scale`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `replace_cluster_custom_object_scale`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `replace_cluster_custom_object_scale`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_cluster_custom_object_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_cluster_custom_object_scale`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}/scale', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_cluster_custom_object_status(self, group, version, plural, name, body, **kwargs):
        """
        replace status of the cluster scoped specified custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_cluster_custom_object_status(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_cluster_custom_object_status_with_http_info(group, version, plural, name, body, **kwargs)
        else:
            (data) = self.replace_cluster_custom_object_status_with_http_info(group, version, plural, name, body, **kwargs)
            return data

    def replace_cluster_custom_object_status_with_http_info(self, group, version, plural, name, body, **kwargs):
        """
        replace status of the cluster scoped specified custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_cluster_custom_object_status_with_http_info(group, version, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_cluster_custom_object_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `replace_cluster_custom_object_status`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `replace_cluster_custom_object_status`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `replace_cluster_custom_object_status`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_cluster_custom_object_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_cluster_custom_object_status`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/{plural}/{name}/status', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_custom_object(self, group, version, namespace, plural, name, body, **kwargs):
        """
        replace the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_custom_object(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to replace. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)
        else:
            (data) = self.replace_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)
            return data

    def replace_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):
        """
        replace the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to replace. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `replace_namespaced_custom_object`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `replace_namespaced_custom_object`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_custom_object`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `replace_namespaced_custom_object`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_custom_object`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_custom_object`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_custom_object_scale(self, group, version, namespace, plural, name, body, **kwargs):
        """
        replace scale of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_custom_object_scale(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, body, **kwargs)
        else:
            (data) = self.replace_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, body, **kwargs)
            return data

    def replace_namespaced_custom_object_scale_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):
        """
        replace scale of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_custom_object_scale_with_http_info(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_custom_object_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `replace_namespaced_custom_object_scale`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `replace_namespaced_custom_object_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_custom_object_scale`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `replace_namespaced_custom_object_scale`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_custom_object_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_custom_object_scale`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_custom_object_status(self, group, version, namespace, plural, name, body, **kwargs):
        """
        replace status of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_custom_object_status(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, body, **kwargs)
        else:
            (data) = self.replace_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, body, **kwargs)
            return data

    def replace_namespaced_custom_object_status_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):
        """
        replace status of the specified namespace scoped custom object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_custom_object_status_with_http_info(group, version, namespace, plural, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body']
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_custom_object_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params) or (params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `replace_namespaced_custom_object_status`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `replace_namespaced_custom_object_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_custom_object_status`")
        # verify the required parameter 'plural' is set
        if ('plural' not in params) or (params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `replace_namespaced_custom_object_status`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_custom_object_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_custom_object_status`")


        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'plural' in params:
            path_params['plural'] = params['plural']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api('/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        async_req=params.get('async_req'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
