# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _sorted_interval_list
else:
    import _sorted_interval_list

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class Domain(object):
    r"""
    We call *domain* any subset of Int64 = [kint64min, kint64max].

    This class can be used to represent such set efficiently as a sorted and
    non-adjacent list of intervals. This is efficient as long as the size of such
    list stays reasonable.

    In the comments below, the domain of *this will always be written 'D'.
    Note that all the functions are safe with respect to integer overflow.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
         By default, Domain will be empty.

        |

        *Overload 2:*
         Constructor for the common case of a singleton domain.

        |

        *Overload 3:*

        Constructor for the common case of a single interval [left, right].
        If left > right, this will result in the empty domain.
        """
        _sorted_interval_list.Domain_swiginit(self, _sorted_interval_list.new_Domain(*args))

    @staticmethod
    def AllValues() -> "operations_research::Domain":
        r"""Returns the full domain Int64."""
        return _sorted_interval_list.Domain_AllValues()

    @staticmethod
    def FromValues(values: "std::vector< int64_t >") -> "operations_research::Domain":
        r"""
        Creates a domain from the union of an unsorted list of integer values.
        Input values may be repeated, with no consequence on the output
        """
        return _sorted_interval_list.Domain_FromValues(values)

    @staticmethod
    def FromIntervals(intervals: "std::vector< std::vector< int64_t > > const &") -> "operations_research::Domain":
        r"""
        This method is available in Python, Java and .NET. It allows
        building a Domain object from a list of intervals (long[][] in Java and
        .NET, [[0, 2], [5, 5], [8, 10]] in python).
        """
        return _sorted_interval_list.Domain_FromIntervals(intervals)

    @staticmethod
    def FromFlatIntervals(flat_intervals: "std::vector< int64_t > const &") -> "operations_research::Domain":
        r"""
        This method is available in Python, Java and .NET. It allows
        building a Domain object from a flattened list of intervals
        (long[] in Java and .NET, [0, 2, 5, 5, 8, 10] in python).
        """
        return _sorted_interval_list.Domain_FromFlatIntervals(flat_intervals)

    def FlattenedIntervals(self) -> "std::vector< int64_t >":
        r"""
        This method returns the flattened list of interval bounds of the domain.

        Thus the domain {0, 1, 2, 5, 8, 9, 10} will return [0, 2, 5, 5,
        8, 10] (as a C++ std::vector<int64_t>, as a java or C# long[], as
        a python list of integers).
        """
        return _sorted_interval_list.Domain_FlattenedIntervals(self)

    def IsEmpty(self) -> "bool":
        r"""Returns true if this is the empty set."""
        return _sorted_interval_list.Domain_IsEmpty(self)

    def Size(self) -> "int64_t":
        r"""Returns the number of elements in the domain. It is capped at kint64max"""
        return _sorted_interval_list.Domain_Size(self)

    def Min(self) -> "int64_t":
        r"""
        Returns the min value of the domain.
        The domain must not be empty.
        """
        return _sorted_interval_list.Domain_Min(self)

    def Max(self) -> "int64_t":
        r"""
        Returns the max value of the domain.
        The domain must not be empty.
        """
        return _sorted_interval_list.Domain_Max(self)

    def Contains(self, value: "int64_t") -> "bool":
        r"""Returns true iff value is in Domain."""
        return _sorted_interval_list.Domain_Contains(self, value)

    def Complement(self) -> "operations_research::Domain":
        r"""Returns the set Int64 ∖ D."""
        return _sorted_interval_list.Domain_Complement(self)

    def Negation(self) -> "operations_research::Domain":
        r"""
        Returns {x ∈ Int64, ∃ e ∈ D, x = -e}.

        Note in particular that if the negation of Int64 is not Int64 but
        Int64 \ {kint64min} !!
        """
        return _sorted_interval_list.Domain_Negation(self)

    def IntersectionWith(self, domain: "Domain") -> "operations_research::Domain":
        r"""Returns the intersection of D and domain."""
        return _sorted_interval_list.Domain_IntersectionWith(self, domain)

    def UnionWith(self, domain: "Domain") -> "operations_research::Domain":
        r"""Returns the union of D and domain."""
        return _sorted_interval_list.Domain_UnionWith(self, domain)

    def AdditionWith(self, domain: "Domain") -> "operations_research::Domain":
        r"""Returns {x ∈ Int64, ∃ a ∈ D, ∃ b ∈ domain, x = a + b}."""
        return _sorted_interval_list.Domain_AdditionWith(self, domain)

    def __str__(self) -> "std::string":
        r"""Returns a compact string of a vector of intervals like "[1,4][6][10,20]"."""
        return _sorted_interval_list.Domain___str__(self)

    def __lt__(self, other: "Domain") -> "bool":
        r"""Lexicographic order on the intervals() representation."""
        return _sorted_interval_list.Domain___lt__(self, other)

    def __eq__(self, other: "Domain") -> "bool":
        return _sorted_interval_list.Domain___eq__(self, other)

    def __ne__(self, other: "Domain") -> "bool":
        return _sorted_interval_list.Domain___ne__(self, other)
    __swig_destroy__ = _sorted_interval_list.delete_Domain

# Register Domain in _sorted_interval_list:
_sorted_interval_list.Domain_swigregister(Domain)

def Domain_AllValues() -> "operations_research::Domain":
    r"""Returns the full domain Int64."""
    return _sorted_interval_list.Domain_AllValues()

def Domain_FromValues(values: "std::vector< int64_t >") -> "operations_research::Domain":
    r"""
    Creates a domain from the union of an unsorted list of integer values.
    Input values may be repeated, with no consequence on the output
    """
    return _sorted_interval_list.Domain_FromValues(values)

def Domain_FromIntervals(intervals: "std::vector< std::vector< int64_t > > const &") -> "operations_research::Domain":
    r"""
    This method is available in Python, Java and .NET. It allows
    building a Domain object from a list of intervals (long[][] in Java and
    .NET, [[0, 2], [5, 5], [8, 10]] in python).
    """
    return _sorted_interval_list.Domain_FromIntervals(intervals)

def Domain_FromFlatIntervals(flat_intervals: "std::vector< int64_t > const &") -> "operations_research::Domain":
    r"""
    This method is available in Python, Java and .NET. It allows
    building a Domain object from a flattened list of intervals
    (long[] in Java and .NET, [0, 2, 5, 5, 8, 10] in python).
    """
    return _sorted_interval_list.Domain_FromFlatIntervals(flat_intervals)


def __lshift__(*args) -> "std::ostream &":
    return _sorted_interval_list.__lshift__(*args)


