"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.wrappers_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Task(google.protobuf.message.Message):
    """This message specifies a task inside a job."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MACHINE_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    COST_FIELD_NUMBER: builtins.int
    @property
    def machine(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The alternative machines that can perform that task. Only one must
        be selected. We store the index of the machine in the main
        JsspInputProblem.
        """
        pass
    @property
    def duration(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The corresponding duration for the alternative ways of performing this
        task. This list must have the same size as the machine_id list.
        """
        pass
    @property
    def cost(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """An optional cost for selecting one alternative way of performing the task
        against another. This list must either be empty, or has the same size as
        the above two lists.
        """
        pass
    def __init__(self,
        *,
        machine: typing.Optional[typing.Iterable[builtins.int]] = ...,
        duration: typing.Optional[typing.Iterable[builtins.int]] = ...,
        cost: typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cost",b"cost","duration",b"duration","machine",b"machine"]) -> None: ...
global___Task = Task

class Job(google.protobuf.message.Message):
    """A job is an ordered sequence of tasks, plus hard constraints on its earliest
    start time, and its latest completion time. As well as optional
    earliness-tardiness penalties on its end date. The job starts with the first
    task in the list, and ends with the last.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TASKS_FIELD_NUMBER: builtins.int
    EARLIEST_START_FIELD_NUMBER: builtins.int
    EARLY_DUE_DATE_FIELD_NUMBER: builtins.int
    LATE_DUE_DATE_FIELD_NUMBER: builtins.int
    EARLINESS_COST_PER_TIME_UNIT_FIELD_NUMBER: builtins.int
    LATENESS_COST_PER_TIME_UNIT_FIELD_NUMBER: builtins.int
    LATEST_END_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def tasks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Task]:
        """The ordered sequence of tasks."""
        pass
    @property
    def earliest_start(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """This date, if set, specifies a hard constraint on when the job can start."""
        pass
    early_due_date: builtins.int
    """This date specifies the earliest time the job should end. If
    this is set, then the earliness_cost_per_time_unit should be set
    too with a positive value.
    """

    late_due_date: builtins.int
    """This date specifies the latest time the job should end. If this
    is set, then the lateness_cost_per_time_unit should be set too
    with a positive value.  If both early_due_date and late_due_date
    are set, then early_due_date <= late_due_date must hold.
    """

    earliness_cost_per_time_unit: builtins.int
    """The cost model is a convex function
       \\            /
        \\          /
         \\________/
    The slopes of this shape are specified on the left by the earliness cost,
    and on the right by the lateness cost. These penalty parts start at the
    early and late due dates. For one penalty part to be active, both
    the date and a positive cost must be defined. All costs must be positive.
    """

    lateness_cost_per_time_unit: builtins.int
    @property
    def latest_end(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """This date, if set, specifies a hard constraint on when the job
        can end.  If both earliest_start and latest_end are specified,
        then earliest_start <= latest_end must hold.
        """
        pass
    name: typing.Text
    """Optional. A name for the job. This will only be used for logging purposes."""

    def __init__(self,
        *,
        tasks: typing.Optional[typing.Iterable[global___Task]] = ...,
        earliest_start: typing.Optional[google.protobuf.wrappers_pb2.Int64Value] = ...,
        early_due_date: builtins.int = ...,
        late_due_date: builtins.int = ...,
        earliness_cost_per_time_unit: builtins.int = ...,
        lateness_cost_per_time_unit: builtins.int = ...,
        latest_end: typing.Optional[google.protobuf.wrappers_pb2.Int64Value] = ...,
        name: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["earliest_start",b"earliest_start","latest_end",b"latest_end"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["earliest_start",b"earliest_start","earliness_cost_per_time_unit",b"earliness_cost_per_time_unit","early_due_date",b"early_due_date","late_due_date",b"late_due_date","lateness_cost_per_time_unit",b"lateness_cost_per_time_unit","latest_end",b"latest_end","name",b"name","tasks",b"tasks"]) -> None: ...
global___Job = Job

class TransitionTimeMatrix(google.protobuf.message.Message):
    """Stores the transition time matrix between jobs on a given machine.
    If the initial job has n jobs, then time[i * n + j] will indicate the
    minimum delay between the end of a task of a job i performed on this machine
    and the start of a task of job j performed on the same machine.
    Nothing can be executed on that machine during this delay.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TRANSITION_TIME_FIELD_NUMBER: builtins.int
    @property
    def transition_time(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        transition_time: typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["transition_time",b"transition_time"]) -> None: ...
global___TransitionTimeMatrix = TransitionTimeMatrix

class Machine(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TRANSITION_TIME_MATRIX_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def transition_time_matrix(self) -> global___TransitionTimeMatrix:
        """Optional transition time matrix for this machine."""
        pass
    name: typing.Text
    """Optional. A name for a machine. This will only be used for logging
    purposes.
    """

    def __init__(self,
        *,
        transition_time_matrix: typing.Optional[global___TransitionTimeMatrix] = ...,
        name: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["transition_time_matrix",b"transition_time_matrix"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name","transition_time_matrix",b"transition_time_matrix"]) -> None: ...
global___Machine = Machine

class JobPrecedence(google.protobuf.message.Message):
    """Specifies a precedence relation between jobs.
    It states: start(second_job) >= end(first_job) + min_delay.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FIRST_JOB_INDEX_FIELD_NUMBER: builtins.int
    SECOND_JOB_INDEX_FIELD_NUMBER: builtins.int
    MIN_DELAY_FIELD_NUMBER: builtins.int
    first_job_index: builtins.int
    second_job_index: builtins.int
    min_delay: builtins.int
    def __init__(self,
        *,
        first_job_index: builtins.int = ...,
        second_job_index: builtins.int = ...,
        min_delay: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["first_job_index",b"first_job_index","min_delay",b"min_delay","second_job_index",b"second_job_index"]) -> None: ...
global___JobPrecedence = JobPrecedence

class JsspInputProblem(google.protobuf.message.Message):
    """The input of a problem."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    JOBS_FIELD_NUMBER: builtins.int
    MACHINES_FIELD_NUMBER: builtins.int
    PRECEDENCES_FIELD_NUMBER: builtins.int
    MAKESPAN_COST_PER_TIME_UNIT_FIELD_NUMBER: builtins.int
    SCALING_FACTOR_FIELD_NUMBER: builtins.int
    SEED_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def jobs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Job]: ...
    @property
    def machines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Machine]: ...
    @property
    def precedences(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___JobPrecedence]: ...
    makespan_cost_per_time_unit: builtins.int
    @property
    def scaling_factor(self) -> google.protobuf.wrappers_pb2.DoubleValue:
        """If set, the cost coefficients are multiplied by this factor.
        It is set to 1000 by the parser when reading early tardy taillard problems
        where the weight of a job is a floating point value.
        """
        pass
    seed: builtins.int
    """Sometimes, the academic data files contain extra information. We store it
    in the input problem message.
    """

    name: typing.Text
    """Optional: Name of the problem."""

    def __init__(self,
        *,
        jobs: typing.Optional[typing.Iterable[global___Job]] = ...,
        machines: typing.Optional[typing.Iterable[global___Machine]] = ...,
        precedences: typing.Optional[typing.Iterable[global___JobPrecedence]] = ...,
        makespan_cost_per_time_unit: builtins.int = ...,
        scaling_factor: typing.Optional[google.protobuf.wrappers_pb2.DoubleValue] = ...,
        seed: builtins.int = ...,
        name: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["scaling_factor",b"scaling_factor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["jobs",b"jobs","machines",b"machines","makespan_cost_per_time_unit",b"makespan_cost_per_time_unit","name",b"name","precedences",b"precedences","scaling_factor",b"scaling_factor","seed",b"seed"]) -> None: ...
global___JsspInputProblem = JsspInputProblem

class AssignedTask(google.protobuf.message.Message):
    """Stores how a task is executed."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ALTERNATIVE_INDEX_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    alternative_index: builtins.int
    """Indicates which alternative was selected. It corresponds to the
    alternative_index-th machine in the 'machine' field in Tasks
    """

    start_time: builtins.int
    """The start time of that task."""

    def __init__(self,
        *,
        alternative_index: builtins.int = ...,
        start_time: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["alternative_index",b"alternative_index","start_time",b"start_time"]) -> None: ...
global___AssignedTask = AssignedTask

class AssignedJob(google.protobuf.message.Message):
    """Stores how a job is executed."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TASKS_FIELD_NUMBER: builtins.int
    DUE_DATE_COST_FIELD_NUMBER: builtins.int
    SUM_OF_TASK_COSTS_FIELD_NUMBER: builtins.int
    @property
    def tasks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssignedTask]:
        """How each task is executed."""
        pass
    due_date_cost: builtins.int
    """Earliness-Tardiness cost of that job."""

    sum_of_task_costs: builtins.int
    """Sum of all tasks costs for that job."""

    def __init__(self,
        *,
        tasks: typing.Optional[typing.Iterable[global___AssignedTask]] = ...,
        due_date_cost: builtins.int = ...,
        sum_of_task_costs: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["due_date_cost",b"due_date_cost","sum_of_task_costs",b"sum_of_task_costs","tasks",b"tasks"]) -> None: ...
global___AssignedJob = AssignedJob

class JsspOutputSolution(google.protobuf.message.Message):
    """The output of solving a jobshop problem."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    JOBS_FIELD_NUMBER: builtins.int
    MAKESPAN_COST_FIELD_NUMBER: builtins.int
    TOTAL_COST_FIELD_NUMBER: builtins.int
    @property
    def jobs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssignedJob]:
        """The solution for all jobs."""
        pass
    makespan_cost: builtins.int
    """The makespan cost of that solution."""

    total_cost: builtins.int
    """The total cost of that solution."""

    def __init__(self,
        *,
        jobs: typing.Optional[typing.Iterable[global___AssignedJob]] = ...,
        makespan_cost: builtins.int = ...,
        total_cost: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["jobs",b"jobs","makespan_cost",b"makespan_cost","total_cost",b"total_cost"]) -> None: ...
global___JsspOutputSolution = JsspOutputSolution
