"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class Resource(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MAX_CAPACITY_FIELD_NUMBER: builtins.int
    MIN_CAPACITY_FIELD_NUMBER: builtins.int
    RENEWABLE_FIELD_NUMBER: builtins.int
    UNIT_COST_FIELD_NUMBER: builtins.int
    max_capacity: builtins.int = ...
    """The max capacity of the cumulative."""

    min_capacity: builtins.int = ...
    """This field is used only in the consumer/producer case. It states the
    minimum capacity that must be valid at each time point.
    """

    renewable: builtins.bool = ...
    """Indicates if the resource is renewable, that is if a task demands
    d from this resource, then the available capacity decreases by d at the
    start of the task and increases by d at the end of the task.
    """

    unit_cost: builtins.int = ...
    """If non zero, then each unit of capacity will incur a cost of unit_cost."""

    def __init__(self,
        *,
        max_capacity : builtins.int = ...,
        min_capacity : builtins.int = ...,
        renewable : builtins.bool = ...,
        unit_cost : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_capacity",b"max_capacity","min_capacity",b"min_capacity","renewable",b"renewable","unit_cost",b"unit_cost"]) -> None: ...
global___Resource = Resource

class Recipe(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DURATION_FIELD_NUMBER: builtins.int
    DEMANDS_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    duration: builtins.int = ...
    """The duration of the task when this recipe is selected."""

    @property
    def demands(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """In the general case, demand must be >= 0. In the consumer/producer case,
        it can be < 0. Note that in this case, the tasks always have a duration
        of zero. Thus the effect of the demand (increase or decrease of the
        current usage) happens at the start of the task.
        """
        pass
    @property
    def resources(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """This parallel list indicates which resource index (in the main problem)
        the above demand corresponds to.
        """
        pass
    def __init__(self,
        *,
        duration : builtins.int = ...,
        demands : typing.Optional[typing.Iterable[builtins.int]] = ...,
        resources : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["demands",b"demands","duration",b"duration","resources",b"resources"]) -> None: ...
global___Recipe = Recipe

class PerRecipeDelays(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MIN_DELAYS_FIELD_NUMBER: builtins.int
    @property
    def min_delays(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        min_delays : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["min_delays",b"min_delays"]) -> None: ...
global___PerRecipeDelays = PerRecipeDelays

class PerSuccessorDelays(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    RECIPE_DELAYS_FIELD_NUMBER: builtins.int
    @property
    def recipe_delays(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PerRecipeDelays]: ...
    def __init__(self,
        *,
        recipe_delays : typing.Optional[typing.Iterable[global___PerRecipeDelays]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["recipe_delays",b"recipe_delays"]) -> None: ...
global___PerSuccessorDelays = PerSuccessorDelays

class Task(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    SUCCESSORS_FIELD_NUMBER: builtins.int
    RECIPES_FIELD_NUMBER: builtins.int
    SUCCESSOR_DELAYS_FIELD_NUMBER: builtins.int
    @property
    def successors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The indices of the successors tasks in the main problem."""
        pass
    @property
    def recipes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Recipe]:
        """The list of possible ways to execute the task."""
        pass
    @property
    def successor_delays(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PerSuccessorDelays]:
        """If the current task has n successors and m recipes then this is
        an n x m matrix where each entry at line i is a vector with the
        same length as the number of recipes for the task successor[i]. If
        recipe m1 is chosen for the current task, and recipe m2 is chosen
        for its successor i, we have:
           start(current_task) + delay[i][m1][m2] <= start(successor_task).
        """
        pass
    def __init__(self,
        *,
        successors : typing.Optional[typing.Iterable[builtins.int]] = ...,
        recipes : typing.Optional[typing.Iterable[global___Recipe]] = ...,
        successor_delays : typing.Optional[typing.Iterable[global___PerSuccessorDelays]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["recipes",b"recipes","successor_delays",b"successor_delays","successors",b"successors"]) -> None: ...
global___Task = Task

class RcpspProblem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    RESOURCES_FIELD_NUMBER: builtins.int
    TASKS_FIELD_NUMBER: builtins.int
    IS_CONSUMER_PRODUCER_FIELD_NUMBER: builtins.int
    IS_RESOURCE_INVESTMENT_FIELD_NUMBER: builtins.int
    IS_RCPSP_MAX_FIELD_NUMBER: builtins.int
    DEADLINE_FIELD_NUMBER: builtins.int
    HORIZON_FIELD_NUMBER: builtins.int
    RELEASE_DATE_FIELD_NUMBER: builtins.int
    TARDINESS_COST_FIELD_NUMBER: builtins.int
    MPM_TIME_FIELD_NUMBER: builtins.int
    SEED_FIELD_NUMBER: builtins.int
    BASEDATA_FIELD_NUMBER: builtins.int
    DUE_DATE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Resource]:
        """Problem data."""
        pass
    @property
    def tasks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Task]: ...
    is_consumer_producer: builtins.bool = ...
    """Problem type."""

    is_resource_investment: builtins.bool = ...
    is_rcpsp_max: builtins.bool = ...
    deadline: builtins.int = ...
    """If set, it defines a strict date, and each task must finish before this."""

    horizon: builtins.int = ...
    """Additional info stored in the source file.
    The horizon is a date where we are sure that all tasks can fit before it.
    """

    release_date: builtins.int = ...
    """The release date is defined in the rcpsp base format, but is not used."""

    tardiness_cost: builtins.int = ...
    """The tardiness cost is defined in the rcpsp base format, but is not used."""

    mpm_time: builtins.int = ...
    """The mpm_time is defined in the rcpsp base format, but is not used.
    It is defined as the minimum makespan in case of interruptible tasks.
    """

    seed: builtins.int = ...
    """Data used by the problem generator."""

    basedata: typing.Text = ...
    due_date: builtins.int = ...
    """The due date is defined in the rcpsp base format, but is not used."""

    name: typing.Text = ...
    def __init__(self,
        *,
        resources : typing.Optional[typing.Iterable[global___Resource]] = ...,
        tasks : typing.Optional[typing.Iterable[global___Task]] = ...,
        is_consumer_producer : builtins.bool = ...,
        is_resource_investment : builtins.bool = ...,
        is_rcpsp_max : builtins.bool = ...,
        deadline : builtins.int = ...,
        horizon : builtins.int = ...,
        release_date : builtins.int = ...,
        tardiness_cost : builtins.int = ...,
        mpm_time : builtins.int = ...,
        seed : builtins.int = ...,
        basedata : typing.Text = ...,
        due_date : builtins.int = ...,
        name : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["basedata",b"basedata","deadline",b"deadline","due_date",b"due_date","horizon",b"horizon","is_consumer_producer",b"is_consumer_producer","is_rcpsp_max",b"is_rcpsp_max","is_resource_investment",b"is_resource_investment","mpm_time",b"mpm_time","name",b"name","release_date",b"release_date","resources",b"resources","seed",b"seed","tardiness_cost",b"tardiness_cost","tasks",b"tasks"]) -> None: ...
global___RcpspProblem = RcpspProblem
