"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class SatParameters(google.protobuf.message.Message):
    """Contains the definitions for all the sat algorithm parameters and their
    default values.

    NEXT TAG: 194
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class VariableOrder(_VariableOrder, metaclass=_VariableOrderEnumTypeWrapper):
        """==========================================================================
        Branching and polarity
        ==========================================================================

        Variables without activity (i.e. at the beginning of the search) will be
        tried in this preferred order.
        """
        pass
    class _VariableOrder:
        V = typing.NewType('V', builtins.int)
    class _VariableOrderEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_VariableOrder.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        IN_ORDER = SatParameters.VariableOrder.V(0)
        """As specified by the problem."""

        IN_REVERSE_ORDER = SatParameters.VariableOrder.V(1)
        IN_RANDOM_ORDER = SatParameters.VariableOrder.V(2)

    IN_ORDER = SatParameters.VariableOrder.V(0)
    """As specified by the problem."""

    IN_REVERSE_ORDER = SatParameters.VariableOrder.V(1)
    IN_RANDOM_ORDER = SatParameters.VariableOrder.V(2)

    class Polarity(_Polarity, metaclass=_PolarityEnumTypeWrapper):
        """Specifies the initial polarity (true/false) when the solver branches on a
        variable. This can be modified later by the user, or the phase saving
        heuristic.

        Note(user): POLARITY_FALSE is usually a good choice because of the
        "natural" way to express a linear boolean problem.
        """
        pass
    class _Polarity:
        V = typing.NewType('V', builtins.int)
    class _PolarityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Polarity.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        POLARITY_TRUE = SatParameters.Polarity.V(0)
        POLARITY_FALSE = SatParameters.Polarity.V(1)
        POLARITY_RANDOM = SatParameters.Polarity.V(2)
        POLARITY_WEIGHTED_SIGN = SatParameters.Polarity.V(3)
        """Choose the sign that tends to satisfy the most constraints. This is
        computed using a weighted sum: if a literal l appears in a constraint of
        the form: ... + coeff * l +... <= rhs with positive coefficients and
        rhs, then -sign(l) * coeff / rhs is added to the weight of l.variable().
        """

        POLARITY_REVERSE_WEIGHTED_SIGN = SatParameters.Polarity.V(4)
        """The opposite choice of POLARITY_WEIGHTED_SIGN."""


    POLARITY_TRUE = SatParameters.Polarity.V(0)
    POLARITY_FALSE = SatParameters.Polarity.V(1)
    POLARITY_RANDOM = SatParameters.Polarity.V(2)
    POLARITY_WEIGHTED_SIGN = SatParameters.Polarity.V(3)
    """Choose the sign that tends to satisfy the most constraints. This is
    computed using a weighted sum: if a literal l appears in a constraint of
    the form: ... + coeff * l +... <= rhs with positive coefficients and
    rhs, then -sign(l) * coeff / rhs is added to the weight of l.variable().
    """

    POLARITY_REVERSE_WEIGHTED_SIGN = SatParameters.Polarity.V(4)
    """The opposite choice of POLARITY_WEIGHTED_SIGN."""


    class ConflictMinimizationAlgorithm(_ConflictMinimizationAlgorithm, metaclass=_ConflictMinimizationAlgorithmEnumTypeWrapper):
        """==========================================================================
        Conflict analysis
        ==========================================================================

        Do we try to minimize conflicts (greedily) when creating them.
        """
        pass
    class _ConflictMinimizationAlgorithm:
        V = typing.NewType('V', builtins.int)
    class _ConflictMinimizationAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ConflictMinimizationAlgorithm.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        NONE = SatParameters.ConflictMinimizationAlgorithm.V(0)
        SIMPLE = SatParameters.ConflictMinimizationAlgorithm.V(1)
        RECURSIVE = SatParameters.ConflictMinimizationAlgorithm.V(2)
        EXPERIMENTAL = SatParameters.ConflictMinimizationAlgorithm.V(3)

    NONE = SatParameters.ConflictMinimizationAlgorithm.V(0)
    SIMPLE = SatParameters.ConflictMinimizationAlgorithm.V(1)
    RECURSIVE = SatParameters.ConflictMinimizationAlgorithm.V(2)
    EXPERIMENTAL = SatParameters.ConflictMinimizationAlgorithm.V(3)

    class BinaryMinizationAlgorithm(_BinaryMinizationAlgorithm, metaclass=_BinaryMinizationAlgorithmEnumTypeWrapper):
        """Whether to expoit the binary clause to minimize learned clauses further.
        This will have an effect only if treat_binary_clauses_separately is true.
        """
        pass
    class _BinaryMinizationAlgorithm:
        V = typing.NewType('V', builtins.int)
    class _BinaryMinizationAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BinaryMinizationAlgorithm.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        NO_BINARY_MINIMIZATION = SatParameters.BinaryMinizationAlgorithm.V(0)
        BINARY_MINIMIZATION_FIRST = SatParameters.BinaryMinizationAlgorithm.V(1)
        BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION = SatParameters.BinaryMinizationAlgorithm.V(4)
        BINARY_MINIMIZATION_WITH_REACHABILITY = SatParameters.BinaryMinizationAlgorithm.V(2)
        EXPERIMENTAL_BINARY_MINIMIZATION = SatParameters.BinaryMinizationAlgorithm.V(3)

    NO_BINARY_MINIMIZATION = SatParameters.BinaryMinizationAlgorithm.V(0)
    BINARY_MINIMIZATION_FIRST = SatParameters.BinaryMinizationAlgorithm.V(1)
    BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION = SatParameters.BinaryMinizationAlgorithm.V(4)
    BINARY_MINIMIZATION_WITH_REACHABILITY = SatParameters.BinaryMinizationAlgorithm.V(2)
    EXPERIMENTAL_BINARY_MINIMIZATION = SatParameters.BinaryMinizationAlgorithm.V(3)

    class ClauseProtection(_ClauseProtection, metaclass=_ClauseProtectionEnumTypeWrapper):
        """Each time a clause activity is bumped, the clause has a chance to be
        protected during the next cleanup phase. Note that clauses used as a reason
        are always protected.
        """
        pass
    class _ClauseProtection:
        V = typing.NewType('V', builtins.int)
    class _ClauseProtectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ClauseProtection.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        PROTECTION_NONE = SatParameters.ClauseProtection.V(0)
        """No protection."""

        PROTECTION_ALWAYS = SatParameters.ClauseProtection.V(1)
        """Protect all clauses whose activity is bumped."""

        PROTECTION_LBD = SatParameters.ClauseProtection.V(2)
        """Only protect clause with a better LBD."""


    PROTECTION_NONE = SatParameters.ClauseProtection.V(0)
    """No protection."""

    PROTECTION_ALWAYS = SatParameters.ClauseProtection.V(1)
    """Protect all clauses whose activity is bumped."""

    PROTECTION_LBD = SatParameters.ClauseProtection.V(2)
    """Only protect clause with a better LBD."""


    class ClauseOrdering(_ClauseOrdering, metaclass=_ClauseOrderingEnumTypeWrapper):
        """The clauses that will be kept during a cleanup are the ones that come
        first under this order. We always keep or exclude ties together.
        """
        pass
    class _ClauseOrdering:
        V = typing.NewType('V', builtins.int)
    class _ClauseOrderingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ClauseOrdering.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        CLAUSE_ACTIVITY = SatParameters.ClauseOrdering.V(0)
        """Order clause by decreasing activity, then by increasing LBD."""

        CLAUSE_LBD = SatParameters.ClauseOrdering.V(1)
        """Order clause by increasing LBD, then by decreasing activity."""


    CLAUSE_ACTIVITY = SatParameters.ClauseOrdering.V(0)
    """Order clause by decreasing activity, then by increasing LBD."""

    CLAUSE_LBD = SatParameters.ClauseOrdering.V(1)
    """Order clause by increasing LBD, then by decreasing activity."""


    class RestartAlgorithm(_RestartAlgorithm, metaclass=_RestartAlgorithmEnumTypeWrapper):
        """==========================================================================
        Restart
        ==========================================================================

        Restart algorithms.

        A reference for the more advanced ones is:
        Gilles Audemard, Laurent Simon, "Refining Restarts Strategies for SAT
        and UNSAT", Principles and Practice of Constraint Programming Lecture
        Notes in Computer Science 2012, pp 118-126
        """
        pass
    class _RestartAlgorithm:
        V = typing.NewType('V', builtins.int)
    class _RestartAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RestartAlgorithm.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        NO_RESTART = SatParameters.RestartAlgorithm.V(0)
        LUBY_RESTART = SatParameters.RestartAlgorithm.V(1)
        """Just follow a Luby sequence times restart_period."""

        DL_MOVING_AVERAGE_RESTART = SatParameters.RestartAlgorithm.V(2)
        """Moving average restart based on the decision level of conflicts."""

        LBD_MOVING_AVERAGE_RESTART = SatParameters.RestartAlgorithm.V(3)
        """Moving average restart based on the LBD of conflicts."""

        FIXED_RESTART = SatParameters.RestartAlgorithm.V(4)
        """Fixed period restart every restart period."""


    NO_RESTART = SatParameters.RestartAlgorithm.V(0)
    LUBY_RESTART = SatParameters.RestartAlgorithm.V(1)
    """Just follow a Luby sequence times restart_period."""

    DL_MOVING_AVERAGE_RESTART = SatParameters.RestartAlgorithm.V(2)
    """Moving average restart based on the decision level of conflicts."""

    LBD_MOVING_AVERAGE_RESTART = SatParameters.RestartAlgorithm.V(3)
    """Moving average restart based on the LBD of conflicts."""

    FIXED_RESTART = SatParameters.RestartAlgorithm.V(4)
    """Fixed period restart every restart period."""


    class MaxSatAssumptionOrder(_MaxSatAssumptionOrder, metaclass=_MaxSatAssumptionOrderEnumTypeWrapper):
        """In what order do we add the assumptions in a core-based max-sat algorithm"""
        pass
    class _MaxSatAssumptionOrder:
        V = typing.NewType('V', builtins.int)
    class _MaxSatAssumptionOrderEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MaxSatAssumptionOrder.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        DEFAULT_ASSUMPTION_ORDER = SatParameters.MaxSatAssumptionOrder.V(0)
        ORDER_ASSUMPTION_BY_DEPTH = SatParameters.MaxSatAssumptionOrder.V(1)
        ORDER_ASSUMPTION_BY_WEIGHT = SatParameters.MaxSatAssumptionOrder.V(2)

    DEFAULT_ASSUMPTION_ORDER = SatParameters.MaxSatAssumptionOrder.V(0)
    ORDER_ASSUMPTION_BY_DEPTH = SatParameters.MaxSatAssumptionOrder.V(1)
    ORDER_ASSUMPTION_BY_WEIGHT = SatParameters.MaxSatAssumptionOrder.V(2)

    class MaxSatStratificationAlgorithm(_MaxSatStratificationAlgorithm, metaclass=_MaxSatStratificationAlgorithmEnumTypeWrapper):
        """What stratification algorithm we use in the presence of weight."""
        pass
    class _MaxSatStratificationAlgorithm:
        V = typing.NewType('V', builtins.int)
    class _MaxSatStratificationAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MaxSatStratificationAlgorithm.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        STRATIFICATION_NONE = SatParameters.MaxSatStratificationAlgorithm.V(0)
        """No stratification of the problem."""

        STRATIFICATION_DESCENT = SatParameters.MaxSatStratificationAlgorithm.V(1)
        """Start with literals with the highest weight, and when SAT, add the
        literals with the next highest weight and so on.
        """

        STRATIFICATION_ASCENT = SatParameters.MaxSatStratificationAlgorithm.V(2)
        """Start with all literals. Each time a core is found with a given minimum
        weight, do not consider literals with a lower weight for the next core
        computation. If the subproblem is SAT, do like in STRATIFICATION_DESCENT
        and just add the literals with the next highest weight.
        """


    STRATIFICATION_NONE = SatParameters.MaxSatStratificationAlgorithm.V(0)
    """No stratification of the problem."""

    STRATIFICATION_DESCENT = SatParameters.MaxSatStratificationAlgorithm.V(1)
    """Start with literals with the highest weight, and when SAT, add the
    literals with the next highest weight and so on.
    """

    STRATIFICATION_ASCENT = SatParameters.MaxSatStratificationAlgorithm.V(2)
    """Start with all literals. Each time a core is found with a given minimum
    weight, do not consider literals with a lower weight for the next core
    computation. If the subproblem is SAT, do like in STRATIFICATION_DESCENT
    and just add the literals with the next highest weight.
    """


    class SearchBranching(_SearchBranching, metaclass=_SearchBranchingEnumTypeWrapper):
        """The search branching will be used to decide how to branch on unfixed nodes."""
        pass
    class _SearchBranching:
        V = typing.NewType('V', builtins.int)
    class _SearchBranchingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SearchBranching.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        AUTOMATIC_SEARCH = SatParameters.SearchBranching.V(0)
        """Try to fix all literals using the underlying SAT solver's heuristics,
        then generate and fix literals until integer variables are fixed.
        """

        FIXED_SEARCH = SatParameters.SearchBranching.V(1)
        """If used then all decisions taken by the solver are made using a fixed
        order as specified in the API or in the CpModelProto search_strategy
        field.
        """

        PORTFOLIO_SEARCH = SatParameters.SearchBranching.V(2)
        """If used, the solver will use various generic heuristics in turn."""

        LP_SEARCH = SatParameters.SearchBranching.V(3)
        """If used, the solver will use heuristics from the LP relaxation. This
        exploit the reduced costs of the variables in the relaxation.

        TODO(user): Maybe rename REDUCED_COST_SEARCH?
        """

        PSEUDO_COST_SEARCH = SatParameters.SearchBranching.V(4)
        """If used, the solver uses the pseudo costs for branching. Pseudo costs
        are computed using the historical change in objective bounds when some
        decision are taken.
        """

        PORTFOLIO_WITH_QUICK_RESTART_SEARCH = SatParameters.SearchBranching.V(5)
        """Mainly exposed here for testing. This quickly tries a lot of randomized
        heuristics with a low conflict limit. It usually provides a good first
        solution.
        """

        HINT_SEARCH = SatParameters.SearchBranching.V(6)
        """Mainly used internally. This is like FIXED_SEARCH, except we follow the
        solution_hint field of the CpModelProto rather than using the information
        provided in the search_strategy.
        """


    AUTOMATIC_SEARCH = SatParameters.SearchBranching.V(0)
    """Try to fix all literals using the underlying SAT solver's heuristics,
    then generate and fix literals until integer variables are fixed.
    """

    FIXED_SEARCH = SatParameters.SearchBranching.V(1)
    """If used then all decisions taken by the solver are made using a fixed
    order as specified in the API or in the CpModelProto search_strategy
    field.
    """

    PORTFOLIO_SEARCH = SatParameters.SearchBranching.V(2)
    """If used, the solver will use various generic heuristics in turn."""

    LP_SEARCH = SatParameters.SearchBranching.V(3)
    """If used, the solver will use heuristics from the LP relaxation. This
    exploit the reduced costs of the variables in the relaxation.

    TODO(user): Maybe rename REDUCED_COST_SEARCH?
    """

    PSEUDO_COST_SEARCH = SatParameters.SearchBranching.V(4)
    """If used, the solver uses the pseudo costs for branching. Pseudo costs
    are computed using the historical change in objective bounds when some
    decision are taken.
    """

    PORTFOLIO_WITH_QUICK_RESTART_SEARCH = SatParameters.SearchBranching.V(5)
    """Mainly exposed here for testing. This quickly tries a lot of randomized
    heuristics with a low conflict limit. It usually provides a good first
    solution.
    """

    HINT_SEARCH = SatParameters.SearchBranching.V(6)
    """Mainly used internally. This is like FIXED_SEARCH, except we follow the
    solution_hint field of the CpModelProto rather than using the information
    provided in the search_strategy.
    """


    class FPRoundingMethod(_FPRoundingMethod, metaclass=_FPRoundingMethodEnumTypeWrapper):
        """Rounding method to use for feasibility pump."""
        pass
    class _FPRoundingMethod:
        V = typing.NewType('V', builtins.int)
    class _FPRoundingMethodEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FPRoundingMethod.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        NEAREST_INTEGER = SatParameters.FPRoundingMethod.V(0)
        """Rounds to the nearest integer value."""

        LOCK_BASED = SatParameters.FPRoundingMethod.V(1)
        """Counts the number of linear constraints restricting the variable in the
        increasing values (up locks) and decreasing values (down locks). Rounds
        the variable in the direction of lesser locks.
        """

        ACTIVE_LOCK_BASED = SatParameters.FPRoundingMethod.V(3)
        """Similar to lock based rounding except this only considers locks of active
        constraints from the last lp solve.
        """

        PROPAGATION_ASSISTED = SatParameters.FPRoundingMethod.V(2)
        """This is expensive rounding algorithm. We round variables one by one and
        propagate the bounds in between. If none of the rounded values fall in
        the continuous domain specified by lower and upper bound, we use the
        current lower/upper bound (whichever one is closest) instead of rounding
        the fractional lp solution value. If both the rounded values are in the
        domain, we round to nearest integer.
        """


    NEAREST_INTEGER = SatParameters.FPRoundingMethod.V(0)
    """Rounds to the nearest integer value."""

    LOCK_BASED = SatParameters.FPRoundingMethod.V(1)
    """Counts the number of linear constraints restricting the variable in the
    increasing values (up locks) and decreasing values (down locks). Rounds
    the variable in the direction of lesser locks.
    """

    ACTIVE_LOCK_BASED = SatParameters.FPRoundingMethod.V(3)
    """Similar to lock based rounding except this only considers locks of active
    constraints from the last lp solve.
    """

    PROPAGATION_ASSISTED = SatParameters.FPRoundingMethod.V(2)
    """This is expensive rounding algorithm. We round variables one by one and
    propagate the bounds in between. If none of the rounded values fall in
    the continuous domain specified by lower and upper bound, we use the
    current lower/upper bound (whichever one is closest) instead of rounding
    the fractional lp solution value. If both the rounded values are in the
    domain, we round to nearest integer.
    """


    NAME_FIELD_NUMBER: builtins.int
    PREFERRED_VARIABLE_ORDER_FIELD_NUMBER: builtins.int
    INITIAL_POLARITY_FIELD_NUMBER: builtins.int
    USE_PHASE_SAVING_FIELD_NUMBER: builtins.int
    POLARITY_REPHASE_INCREMENT_FIELD_NUMBER: builtins.int
    RANDOM_POLARITY_RATIO_FIELD_NUMBER: builtins.int
    RANDOM_BRANCHES_RATIO_FIELD_NUMBER: builtins.int
    USE_ERWA_HEURISTIC_FIELD_NUMBER: builtins.int
    INITIAL_VARIABLES_ACTIVITY_FIELD_NUMBER: builtins.int
    ALSO_BUMP_VARIABLES_IN_CONFLICT_REASONS_FIELD_NUMBER: builtins.int
    MINIMIZATION_ALGORITHM_FIELD_NUMBER: builtins.int
    BINARY_MINIMIZATION_ALGORITHM_FIELD_NUMBER: builtins.int
    SUBSUMPTION_DURING_CONFLICT_ANALYSIS_FIELD_NUMBER: builtins.int
    CLAUSE_CLEANUP_PERIOD_FIELD_NUMBER: builtins.int
    CLAUSE_CLEANUP_TARGET_FIELD_NUMBER: builtins.int
    CLAUSE_CLEANUP_RATIO_FIELD_NUMBER: builtins.int
    CLAUSE_CLEANUP_PROTECTION_FIELD_NUMBER: builtins.int
    CLAUSE_CLEANUP_LBD_BOUND_FIELD_NUMBER: builtins.int
    CLAUSE_CLEANUP_ORDERING_FIELD_NUMBER: builtins.int
    PB_CLEANUP_INCREMENT_FIELD_NUMBER: builtins.int
    PB_CLEANUP_RATIO_FIELD_NUMBER: builtins.int
    MINIMIZE_WITH_PROPAGATION_RESTART_PERIOD_FIELD_NUMBER: builtins.int
    MINIMIZE_WITH_PROPAGATION_NUM_DECISIONS_FIELD_NUMBER: builtins.int
    VARIABLE_ACTIVITY_DECAY_FIELD_NUMBER: builtins.int
    MAX_VARIABLE_ACTIVITY_VALUE_FIELD_NUMBER: builtins.int
    GLUCOSE_MAX_DECAY_FIELD_NUMBER: builtins.int
    GLUCOSE_DECAY_INCREMENT_FIELD_NUMBER: builtins.int
    GLUCOSE_DECAY_INCREMENT_PERIOD_FIELD_NUMBER: builtins.int
    CLAUSE_ACTIVITY_DECAY_FIELD_NUMBER: builtins.int
    MAX_CLAUSE_ACTIVITY_VALUE_FIELD_NUMBER: builtins.int
    RESTART_ALGORITHMS_FIELD_NUMBER: builtins.int
    DEFAULT_RESTART_ALGORITHMS_FIELD_NUMBER: builtins.int
    RESTART_PERIOD_FIELD_NUMBER: builtins.int
    RESTART_RUNNING_WINDOW_SIZE_FIELD_NUMBER: builtins.int
    RESTART_DL_AVERAGE_RATIO_FIELD_NUMBER: builtins.int
    RESTART_LBD_AVERAGE_RATIO_FIELD_NUMBER: builtins.int
    USE_BLOCKING_RESTART_FIELD_NUMBER: builtins.int
    BLOCKING_RESTART_WINDOW_SIZE_FIELD_NUMBER: builtins.int
    BLOCKING_RESTART_MULTIPLIER_FIELD_NUMBER: builtins.int
    NUM_CONFLICTS_BEFORE_STRATEGY_CHANGES_FIELD_NUMBER: builtins.int
    STRATEGY_CHANGE_INCREASE_RATIO_FIELD_NUMBER: builtins.int
    MAX_TIME_IN_SECONDS_FIELD_NUMBER: builtins.int
    MAX_DETERMINISTIC_TIME_FIELD_NUMBER: builtins.int
    MAX_NUMBER_OF_CONFLICTS_FIELD_NUMBER: builtins.int
    MAX_MEMORY_IN_MB_FIELD_NUMBER: builtins.int
    ABSOLUTE_GAP_LIMIT_FIELD_NUMBER: builtins.int
    RELATIVE_GAP_LIMIT_FIELD_NUMBER: builtins.int
    TREAT_BINARY_CLAUSES_SEPARATELY_FIELD_NUMBER: builtins.int
    RANDOM_SEED_FIELD_NUMBER: builtins.int
    PERMUTE_VARIABLE_RANDOMLY_FIELD_NUMBER: builtins.int
    PERMUTE_PRESOLVE_CONSTRAINT_ORDER_FIELD_NUMBER: builtins.int
    USE_ABSL_RANDOM_FIELD_NUMBER: builtins.int
    LOG_SEARCH_PROGRESS_FIELD_NUMBER: builtins.int
    LOG_SUBSOLVER_STATISTICS_FIELD_NUMBER: builtins.int
    LOG_PREFIX_FIELD_NUMBER: builtins.int
    LOG_TO_STDOUT_FIELD_NUMBER: builtins.int
    LOG_TO_RESPONSE_FIELD_NUMBER: builtins.int
    USE_PB_RESOLUTION_FIELD_NUMBER: builtins.int
    MINIMIZE_REDUCTION_DURING_PB_RESOLUTION_FIELD_NUMBER: builtins.int
    COUNT_ASSUMPTION_LEVELS_IN_LBD_FIELD_NUMBER: builtins.int
    PRESOLVE_BVE_THRESHOLD_FIELD_NUMBER: builtins.int
    PRESOLVE_BVE_CLAUSE_WEIGHT_FIELD_NUMBER: builtins.int
    PRESOLVE_PROBING_DETERMINISTIC_TIME_LIMIT_FIELD_NUMBER: builtins.int
    PRESOLVE_BLOCKED_CLAUSE_FIELD_NUMBER: builtins.int
    PRESOLVE_USE_BVA_FIELD_NUMBER: builtins.int
    PRESOLVE_BVA_THRESHOLD_FIELD_NUMBER: builtins.int
    MAX_PRESOLVE_ITERATIONS_FIELD_NUMBER: builtins.int
    CP_MODEL_PRESOLVE_FIELD_NUMBER: builtins.int
    CP_MODEL_POSTSOLVE_WITH_FULL_SOLVER_FIELD_NUMBER: builtins.int
    CP_MODEL_MAX_NUM_PRESOLVE_OPERATIONS_FIELD_NUMBER: builtins.int
    CP_MODEL_PROBING_LEVEL_FIELD_NUMBER: builtins.int
    CP_MODEL_USE_SAT_PRESOLVE_FIELD_NUMBER: builtins.int
    USE_SAT_INPROCESSING_FIELD_NUMBER: builtins.int
    EXPAND_ELEMENT_CONSTRAINTS_FIELD_NUMBER: builtins.int
    EXPAND_AUTOMATON_CONSTRAINTS_FIELD_NUMBER: builtins.int
    EXPAND_TABLE_CONSTRAINTS_FIELD_NUMBER: builtins.int
    EXPAND_ALLDIFF_CONSTRAINTS_FIELD_NUMBER: builtins.int
    EXPAND_RESERVOIR_CONSTRAINTS_FIELD_NUMBER: builtins.int
    DISABLE_CONSTRAINT_EXPANSION_FIELD_NUMBER: builtins.int
    MERGE_NO_OVERLAP_WORK_LIMIT_FIELD_NUMBER: builtins.int
    MERGE_AT_MOST_ONE_WORK_LIMIT_FIELD_NUMBER: builtins.int
    PRESOLVE_SUBSTITUTION_LEVEL_FIELD_NUMBER: builtins.int
    PRESOLVE_EXTRACT_INTEGER_ENFORCEMENT_FIELD_NUMBER: builtins.int
    USE_OPTIMIZATION_HINTS_FIELD_NUMBER: builtins.int
    MINIMIZE_CORE_FIELD_NUMBER: builtins.int
    FIND_MULTIPLE_CORES_FIELD_NUMBER: builtins.int
    COVER_OPTIMIZATION_FIELD_NUMBER: builtins.int
    MAX_SAT_ASSUMPTION_ORDER_FIELD_NUMBER: builtins.int
    MAX_SAT_REVERSE_ASSUMPTION_ORDER_FIELD_NUMBER: builtins.int
    MAX_SAT_STRATIFICATION_FIELD_NUMBER: builtins.int
    USE_PRECEDENCES_IN_DISJUNCTIVE_CONSTRAINT_FIELD_NUMBER: builtins.int
    USE_OVERLOAD_CHECKER_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER: builtins.int
    USE_TIMETABLE_EDGE_FINDING_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER: builtins.int
    USE_DISJUNCTIVE_CONSTRAINT_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER: builtins.int
    LINEARIZATION_LEVEL_FIELD_NUMBER: builtins.int
    BOOLEAN_ENCODING_LEVEL_FIELD_NUMBER: builtins.int
    MAX_DOMAIN_SIZE_WHEN_ENCODING_EQ_NEQ_CONSTRAINTS_FIELD_NUMBER: builtins.int
    MAX_NUM_CUTS_FIELD_NUMBER: builtins.int
    ONLY_ADD_CUTS_AT_LEVEL_ZERO_FIELD_NUMBER: builtins.int
    ADD_KNAPSACK_CUTS_FIELD_NUMBER: builtins.int
    ADD_CG_CUTS_FIELD_NUMBER: builtins.int
    ADD_MIR_CUTS_FIELD_NUMBER: builtins.int
    ADD_ZERO_HALF_CUTS_FIELD_NUMBER: builtins.int
    ADD_CLIQUE_CUTS_FIELD_NUMBER: builtins.int
    MAX_ALL_DIFF_CUT_SIZE_FIELD_NUMBER: builtins.int
    ADD_LIN_MAX_CUTS_FIELD_NUMBER: builtins.int
    MAX_INTEGER_ROUNDING_SCALING_FIELD_NUMBER: builtins.int
    ADD_LP_CONSTRAINTS_LAZILY_FIELD_NUMBER: builtins.int
    MIN_ORTHOGONALITY_FOR_LP_CONSTRAINTS_FIELD_NUMBER: builtins.int
    MAX_CUT_ROUNDS_AT_LEVEL_ZERO_FIELD_NUMBER: builtins.int
    MAX_CONSECUTIVE_INACTIVE_COUNT_FIELD_NUMBER: builtins.int
    CUT_MAX_ACTIVE_COUNT_VALUE_FIELD_NUMBER: builtins.int
    CUT_ACTIVE_COUNT_DECAY_FIELD_NUMBER: builtins.int
    CUT_CLEANUP_TARGET_FIELD_NUMBER: builtins.int
    NEW_CONSTRAINTS_BATCH_SIZE_FIELD_NUMBER: builtins.int
    SEARCH_BRANCHING_FIELD_NUMBER: builtins.int
    HINT_CONFLICT_LIMIT_FIELD_NUMBER: builtins.int
    REPAIR_HINT_FIELD_NUMBER: builtins.int
    FIX_VARIABLES_TO_THEIR_HINTED_VALUE_FIELD_NUMBER: builtins.int
    EXPLOIT_INTEGER_LP_SOLUTION_FIELD_NUMBER: builtins.int
    EXPLOIT_ALL_LP_SOLUTION_FIELD_NUMBER: builtins.int
    EXPLOIT_BEST_SOLUTION_FIELD_NUMBER: builtins.int
    EXPLOIT_RELAXATION_SOLUTION_FIELD_NUMBER: builtins.int
    EXPLOIT_OBJECTIVE_FIELD_NUMBER: builtins.int
    PROBING_PERIOD_AT_ROOT_FIELD_NUMBER: builtins.int
    USE_PROBING_SEARCH_FIELD_NUMBER: builtins.int
    PSEUDO_COST_RELIABILITY_THRESHOLD_FIELD_NUMBER: builtins.int
    OPTIMIZE_WITH_CORE_FIELD_NUMBER: builtins.int
    OPTIMIZE_WITH_LB_TREE_SEARCH_FIELD_NUMBER: builtins.int
    BINARY_SEARCH_NUM_CONFLICTS_FIELD_NUMBER: builtins.int
    OPTIMIZE_WITH_MAX_HS_FIELD_NUMBER: builtins.int
    ENUMERATE_ALL_SOLUTIONS_FIELD_NUMBER: builtins.int
    KEEP_ALL_FEASIBLE_SOLUTIONS_IN_PRESOLVE_FIELD_NUMBER: builtins.int
    FILL_TIGHTENED_DOMAINS_IN_RESPONSE_FIELD_NUMBER: builtins.int
    INSTANTIATE_ALL_VARIABLES_FIELD_NUMBER: builtins.int
    AUTO_DETECT_GREATER_THAN_AT_LEAST_ONE_OF_FIELD_NUMBER: builtins.int
    STOP_AFTER_FIRST_SOLUTION_FIELD_NUMBER: builtins.int
    STOP_AFTER_PRESOLVE_FIELD_NUMBER: builtins.int
    NUM_SEARCH_WORKERS_FIELD_NUMBER: builtins.int
    INTERLEAVE_SEARCH_FIELD_NUMBER: builtins.int
    INTERLEAVE_BATCH_SIZE_FIELD_NUMBER: builtins.int
    REDUCE_MEMORY_USAGE_IN_INTERLEAVE_MODE_FIELD_NUMBER: builtins.int
    SHARE_OBJECTIVE_BOUNDS_FIELD_NUMBER: builtins.int
    SHARE_LEVEL_ZERO_BOUNDS_FIELD_NUMBER: builtins.int
    USE_LNS_ONLY_FIELD_NUMBER: builtins.int
    LNS_FOCUS_ON_DECISION_VARIABLES_FIELD_NUMBER: builtins.int
    LNS_EXPAND_INTERVALS_IN_CONSTRAINT_GRAPH_FIELD_NUMBER: builtins.int
    SOLUTION_POOL_SIZE_FIELD_NUMBER: builtins.int
    USE_RINS_LNS_FIELD_NUMBER: builtins.int
    USE_FEASIBILITY_PUMP_FIELD_NUMBER: builtins.int
    FP_ROUNDING_FIELD_NUMBER: builtins.int
    USE_RELAXATION_LNS_FIELD_NUMBER: builtins.int
    DIVERSIFY_LNS_PARAMS_FIELD_NUMBER: builtins.int
    RANDOMIZE_SEARCH_FIELD_NUMBER: builtins.int
    SEARCH_RANDOMIZATION_TOLERANCE_FIELD_NUMBER: builtins.int
    USE_OPTIONAL_VARIABLES_FIELD_NUMBER: builtins.int
    USE_EXACT_LP_REASON_FIELD_NUMBER: builtins.int
    USE_BRANCHING_IN_LP_FIELD_NUMBER: builtins.int
    USE_COMBINED_NO_OVERLAP_FIELD_NUMBER: builtins.int
    CATCH_SIGINT_SIGNAL_FIELD_NUMBER: builtins.int
    USE_IMPLIED_BOUNDS_FIELD_NUMBER: builtins.int
    POLISH_LP_SOLUTION_FIELD_NUMBER: builtins.int
    CONVERT_INTERVALS_FIELD_NUMBER: builtins.int
    SYMMETRY_LEVEL_FIELD_NUMBER: builtins.int
    MIP_MAX_BOUND_FIELD_NUMBER: builtins.int
    MIP_VAR_SCALING_FIELD_NUMBER: builtins.int
    MIP_AUTOMATICALLY_SCALE_VARIABLES_FIELD_NUMBER: builtins.int
    MIP_WANTED_PRECISION_FIELD_NUMBER: builtins.int
    MIP_MAX_ACTIVITY_EXPONENT_FIELD_NUMBER: builtins.int
    MIP_CHECK_PRECISION_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """In some context, like in a portfolio of search, it makes sense to name a
    given parameters set for logging purpose.
    """

    preferred_variable_order: global___SatParameters.VariableOrder.V = ...
    initial_polarity: global___SatParameters.Polarity.V = ...
    use_phase_saving: builtins.bool = ...
    """If this is true, then the polarity of a variable will be the last value it
    was assigned to, or its default polarity if it was never assigned since the
    call to ResetDecisionHeuristic().

    Actually, we use a newer version where we follow the last value in the
    longest non-conflicting partial assignment in the current phase.

    This is called 'literal phase saving'. For details see 'A Lightweight
    Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
    A.Darwiche, In 10th International Conference on Theory and Applications of
    Satisfiability Testing, 2007.
    """

    polarity_rephase_increment: builtins.int = ...
    """If non-zero, then we change the polarity heuristic after that many number
    of conflicts in an arithmetically increasing fashion. So x the first time,
    2 * x the second time, etc...
    """

    random_polarity_ratio: builtins.float = ...
    """The proportion of polarity chosen at random. Note that this take
    precedence over the phase saving heuristic. This is different from
    initial_polarity:POLARITY_RANDOM because it will select a new random
    polarity each time the variable is branched upon instead of selecting one
    initially and then always taking this choice.
    """

    random_branches_ratio: builtins.float = ...
    """A number between 0 and 1 that indicates the proportion of branching
    variables that are selected randomly instead of choosing the first variable
    from the given variable_ordering strategy.
    """

    use_erwa_heuristic: builtins.bool = ...
    """Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
    described in "Learning Rate Based Branching Heuristic for SAT solvers",
    J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
    """

    initial_variables_activity: builtins.float = ...
    """The initial value of the variables activity. A non-zero value only make
    sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
    together with the ERWA heuristic showed slighthly better result than simply
    using zero. The idea is that when the "learning rate" of a variable becomes
    lower than this value, then we prefer to branch on never explored before
    variables. This is not in the ERWA paper.
    """

    also_bump_variables_in_conflict_reasons: builtins.bool = ...
    """When this is true, then the variables that appear in any of the reason of
    the variables in a conflict have their activity bumped. This is addition to
    the variables in the conflict, and the one that were used during conflict
    resolution.
    """

    minimization_algorithm: global___SatParameters.ConflictMinimizationAlgorithm.V = ...
    binary_minimization_algorithm: global___SatParameters.BinaryMinizationAlgorithm.V = ...
    subsumption_during_conflict_analysis: builtins.bool = ...
    """At a really low cost, during the 1-UIP conflict computation, it is easy to
    detect if some of the involved reasons are subsumed by the current
    conflict. When this is true, such clauses are detached and later removed
    from the problem.
    """

    clause_cleanup_period: builtins.int = ...
    """==========================================================================
    Clause database management
    ==========================================================================

    Trigger a cleanup when this number of "deletable" clauses is learned.
    """

    clause_cleanup_target: builtins.int = ...
    """During a cleanup, we will always keep that number of "deletable" clauses.
    Note that this doesn't include the "protected" clauses.
    """

    clause_cleanup_ratio: builtins.float = ...
    """During a cleanup, if clause_cleanup_target is 0, we will delete the
    clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
    target of clauses to keep.
    """

    clause_cleanup_protection: global___SatParameters.ClauseProtection.V = ...
    clause_cleanup_lbd_bound: builtins.int = ...
    """All the clauses with a LBD (literal blocks distance) lower or equal to this
    parameters will always be kept.
    """

    clause_cleanup_ordering: global___SatParameters.ClauseOrdering.V = ...
    pb_cleanup_increment: builtins.int = ...
    """Same as for the clauses, but for the learned pseudo-Boolean constraints."""

    pb_cleanup_ratio: builtins.float = ...
    minimize_with_propagation_restart_period: builtins.int = ...
    """Parameters for an heuristic similar to the one descibed in "An effective
    learnt clause minimization approach for CDCL Sat Solvers",
    https://www.ijcai.org/proceedings/2017/0098.pdf

    For now, we have a somewhat simpler implementation where every x restart we
    spend y decisions on clause minimization. The minimization technique is the
    same as the one used to minimize core in max-sat. We also minimize problem
    clauses and not just the learned clause that we keep forever like in the
    paper.

    Changing these parameters or the kind of clause we minimize seems to have
    a big impact on the overall perf on our benchmarks. So this technique seems
    definitely useful, but it is hard to tune properly.
    """

    minimize_with_propagation_num_decisions: builtins.int = ...
    variable_activity_decay: builtins.float = ...
    """==========================================================================
    Variable and clause activities
    ==========================================================================

    Each time a conflict is found, the activities of some variables are
    increased by one. Then, the activity of all variables are multiplied by
    variable_activity_decay.

    To implement this efficiently, the activity of all the variables is not
    decayed at each conflict. Instead, the activity increment is multiplied by
    1 / decay. When an activity reach max_variable_activity_value, all the
    activity are multiplied by 1 / max_variable_activity_value.
    """

    max_variable_activity_value: builtins.float = ...
    glucose_max_decay: builtins.float = ...
    """The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
    0.95. This "hack" seems to work well and comes from:

    Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
    http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
    """

    glucose_decay_increment: builtins.float = ...
    glucose_decay_increment_period: builtins.int = ...
    clause_activity_decay: builtins.float = ...
    """Clause activity parameters (same effect as the one on the variables)."""

    max_clause_activity_value: builtins.float = ...
    @property
    def restart_algorithms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___SatParameters.RestartAlgorithm.V]:
        """The restart strategies will change each time the strategy_counter is
        increased. The current strategy will simply be the one at index
        strategy_counter modulo the number of strategy. Note that if this list
        includes a NO_RESTART, nothing will change when it is reached because the
        strategy_counter will only increment after a restart.

        The idea of switching of search strategy tailored for SAT/UNSAT comes from
        Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
        But more generally, it seems REALLY beneficial to try different strategy.
        """
        pass
    default_restart_algorithms: typing.Text = ...
    restart_period: builtins.int = ...
    """Restart period for the FIXED_RESTART strategy. This is also the multiplier
    used by the LUBY_RESTART strategy.
    """

    restart_running_window_size: builtins.int = ...
    """Size of the window for the moving average restarts."""

    restart_dl_average_ratio: builtins.float = ...
    """In the moving average restart algorithms, a restart is triggered if the
    window average times this ratio is greater that the global average.
    """

    restart_lbd_average_ratio: builtins.float = ...
    use_blocking_restart: builtins.bool = ...
    """Block a moving restart algorithm if the trail size of the current conflict
    is greater than the multiplier times the moving average of the trail size
    at the previous conflicts.
    """

    blocking_restart_window_size: builtins.int = ...
    blocking_restart_multiplier: builtins.float = ...
    num_conflicts_before_strategy_changes: builtins.int = ...
    """After each restart, if the number of conflict since the last strategy
    change is greater that this, then we increment a "strategy_counter" that
    can be use to change the search strategy used by the following restarts.
    """

    strategy_change_increase_ratio: builtins.float = ...
    """The parameter num_conflicts_before_strategy_changes is increased by that
    much after each strategy change.
    """

    max_time_in_seconds: builtins.float = ...
    """==========================================================================
    Limits
    ==========================================================================

    Maximum time allowed in seconds to solve a problem.
    The counter will starts at the beginning of the Solve() call.
    """

    max_deterministic_time: builtins.float = ...
    """Maximum time allowed in deterministic time to solve a problem.
    The deterministic time should be correlated with the real time used by the
    solver, the time unit being as close as possible to a second.
    """

    max_number_of_conflicts: builtins.int = ...
    """Maximum number of conflicts allowed to solve a problem.

    TODO(user,user): Maybe change the way the conflict limit is enforced?
    currently it is enforced on each independent internal SAT solve, rather
    than on the overall number of conflicts across all solves. So in the
    context of an optimization problem, this is not really usable directly by a
    client.
    kint64max
    """

    max_memory_in_mb: builtins.int = ...
    """Maximum memory allowed for the whole thread containing the solver. The
    solver will abort as soon as it detects that this limit is crossed. As a
    result, this limit is approximative, but usually the solver will not go too
    much over.
    """

    absolute_gap_limit: builtins.float = ...
    """Stop the search when the gap between the best feasible objective (O) and
    our best objective bound (B) is smaller than a limit.
    The exact definition is:
    - Absolute: abs(O - B)
    - Relative: abs(O - B) / max(1, abs(O)).

    Important: The relative gap depends on the objective offset! If you
    artificially shift the objective, you will get widely different value of
    the relative gap.

    Note that if the gap is reached, the search status will be OPTIMAL. But
    one can check the best objective bound to see the actual gap.
    """

    relative_gap_limit: builtins.float = ...
    treat_binary_clauses_separately: builtins.bool = ...
    """==========================================================================
    Other parameters
    ==========================================================================

    If true, the binary clauses are treated separately from the others. This
    should be faster and uses less memory. However it changes the propagation
    order.
    """

    random_seed: builtins.int = ...
    """At the beginning of each solve, the random number generator used in some
    part of the solver is reinitialized to this seed. If you change the random
    seed, the solver may make different choices during the solving process.

    For some problems, the running time may vary a lot depending on small
    change in the solving algorithm. Running the solver with different seeds
    enables to have more robust benchmarks when evaluating new features.
    """

    permute_variable_randomly: builtins.bool = ...
    """This is mainly here to test the solver variability. Note that in tests, if
    not explicitly set to false, all 3 options will be set to true so that
    clients do not rely on the solver returning a specific solution if they are
    many equivalent optimal solutions.
    """

    permute_presolve_constraint_order: builtins.bool = ...
    use_absl_random: builtins.bool = ...
    log_search_progress: builtins.bool = ...
    """Whether the solver should log the search progress. By default, it logs to
    LOG(INFO). This can be overwritten by the log_destination parameter.
    """

    log_subsolver_statistics: builtins.bool = ...
    """Whether the solver should display per sub-solver search statistics.
    This is only useful is log_search_progress is set to true, and if the
    number of search workers is > 1.
    """

    log_prefix: typing.Text = ...
    """Add a prefix to all logs."""

    log_to_stdout: builtins.bool = ...
    """Log to stdout."""

    log_to_response: builtins.bool = ...
    """Log to response proto."""

    use_pb_resolution: builtins.bool = ...
    """Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
    this option only make sense if your problem is modelized using
    pseudo-Boolean constraints. If you only have clauses, this shouldn't change
    anything (except slow the solver down).
    """

    minimize_reduction_during_pb_resolution: builtins.bool = ...
    """A different algorithm during PB resolution. It minimizes the number of
    calls to ReduceCoefficients() which can be time consuming. However, the
    search space will be different and if the coefficients are large, this may
    lead to integer overflows that could otherwise be prevented.
    """

    count_assumption_levels_in_lbd: builtins.bool = ...
    """Whether or not the assumption levels are taken into account during the LBD
    computation. According to the reference below, not counting them improves
    the solver in some situation. Note that this only impact solves under
    assumptions.

    Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
    Incremental SAT Solving with Assumptions: Application to MUS Extraction"
    Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
    in Computer Science Volume 7962, 2013, pp 309-317.
    """

    presolve_bve_threshold: builtins.int = ...
    """==========================================================================
    Presolve
    ==========================================================================

    During presolve, only try to perform the bounded variable elimination (BVE)
    of a variable x if the number of occurrences of x times the number of
    occurrences of not(x) is not greater than this parameter.
    """

    presolve_bve_clause_weight: builtins.int = ...
    """During presolve, we apply BVE only if this weight times the number of
    clauses plus the number of clause literals is not increased.
    """

    presolve_probing_deterministic_time_limit: builtins.float = ...
    """The maximum "deterministic" time limit to spend in probing. A value of
    zero will disable the probing.
    """

    presolve_blocked_clause: builtins.bool = ...
    """Whether we use an heuristic to detect some basic case of blocked clause
    in the SAT presolve.
    """

    presolve_use_bva: builtins.bool = ...
    """Whether or not we use Bounded Variable Addition (BVA) in the presolve."""

    presolve_bva_threshold: builtins.int = ...
    """Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
    by stricly more than this threshold. The algorithm described in the paper
    uses 0, but quick experiments showed that 1 is a good value. It may not be
    worth it to add a new variable just to remove one clause.
    """

    max_presolve_iterations: builtins.int = ...
    """In case of large reduction in a presolve iteration, we perform multiple
    presolve iterations. This parameter controls the maximum number of such
    presolve iterations.
    """

    cp_model_presolve: builtins.bool = ...
    """Whether we presolve the cp_model before solving it."""

    cp_model_postsolve_with_full_solver: builtins.bool = ...
    """Advanced usage. We have two different postsolve code. The default one
    should be better and it allows for a more powerful presolve, but some
    rarely used features like not fully assigning all variables require the
    other one.
    """

    cp_model_max_num_presolve_operations: builtins.int = ...
    """If positive, try to stop just after that many presolve rules have been
    applied. This is mainly useful for debugging presolve.
    """

    cp_model_probing_level: builtins.int = ...
    """How much effort do we spend on probing. 0 disables it completely."""

    cp_model_use_sat_presolve: builtins.bool = ...
    """Whether we also use the sat presolve when cp_model_presolve is true."""

    use_sat_inprocessing: builtins.bool = ...
    expand_element_constraints: builtins.bool = ...
    """If true, the element constraints are expanded into many
    linear constraints of the form (index == i) => (element[i] == target).
    """

    expand_automaton_constraints: builtins.bool = ...
    """If true, the automaton constraints are expanded."""

    expand_table_constraints: builtins.bool = ...
    """If true, the positive table constraints are expanded.
    Note that currently, negative table constraints are always expanded.
    """

    expand_alldiff_constraints: builtins.bool = ...
    """If true, expand all_different constraints that are not permutations.
    Permutations (#Variables = #Values) are always expanded.
    """

    expand_reservoir_constraints: builtins.bool = ...
    """If true, expand the reservoir constraints by creating booleans for all
    possible precedences between event and encoding the constraint.
    """

    disable_constraint_expansion: builtins.bool = ...
    """If true, it disable all constraint expansion.
    This should only be used to test the presolve of expanded constraints.
    """

    merge_no_overlap_work_limit: builtins.float = ...
    """During presolve, we use a maximum clique heuristic to merge together
    no-overlap constraints or at most one constraints. This code can be slow,
    so we have a limit in place on the number of explored nodes in the
    underlying graph. The internal limit is an int64, but we use double here to
    simplify manual input.
    """

    merge_at_most_one_work_limit: builtins.float = ...
    presolve_substitution_level: builtins.int = ...
    """How much substitution (also called free variable aggregation in MIP
    litterature) should we perform at presolve. This currently only concerns
    variable appearing only in linear constraints. For now the value 0 turns it
    off and any positive value performs substitution.
    """

    presolve_extract_integer_enforcement: builtins.bool = ...
    """If true, we will extract from linear constraints, enforcement literals of
    the form "integer variable at bound => simplified constraint". This should
    always be beneficial except that we don't always handle them as efficiently
    as we could for now. This causes problem on manna81.mps (LP relaxation not
    as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
    created this way).
    """

    use_optimization_hints: builtins.bool = ...
    """==========================================================================
    Max-sat parameters
    ==========================================================================

    For an optimization problem, whether we follow some hints in order to find
    a better first solution. For a variable with hint, the solver will always
    try to follow the hint. It will revert to the variable_branching default
    otherwise.
    """

    minimize_core: builtins.bool = ...
    """Whether we use a simple heuristic to try to minimize an UNSAT core."""

    find_multiple_cores: builtins.bool = ...
    """Whether we try to find more independent cores for a given set of
    assumptions in the core based max-SAT algorithms.
    """

    cover_optimization: builtins.bool = ...
    """If true, when the max-sat algo find a core, we compute the minimal number
    of literals in the core that needs to be true to have a feasible solution.
    """

    max_sat_assumption_order: global___SatParameters.MaxSatAssumptionOrder.V = ...
    max_sat_reverse_assumption_order: builtins.bool = ...
    """If true, adds the assumption in the reverse order of the one defined by
    max_sat_assumption_order.
    """

    max_sat_stratification: global___SatParameters.MaxSatStratificationAlgorithm.V = ...
    use_precedences_in_disjunctive_constraint: builtins.bool = ...
    """==========================================================================
    Constraint programming parameters
    ==========================================================================

    When this is true, then a disjunctive constraint will try to use the
    precedence relations between time intervals to propagate their bounds
    further. For instance if task A and B are both before C and task A and B
    are in disjunction, then we can deduce that task C must start after
    duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
    provided that the start time for all task was currently zero.

    This always result in better propagation, but it is usually slow, so
    depending on the problem, turning this off may lead to a faster solution.
    """

    use_overload_checker_in_cumulative_constraint: builtins.bool = ...
    """When this is true, the cumulative constraint is reinforced with overload
    checking, i.e., an additional level of reasoning based on energy. This
    additional level supplements the default level of reasoning as well as
    timetable edge finding.

    This always result in better propagation, but it is usually slow, so
    depending on the problem, turning this off may lead to a faster solution.
    """

    use_timetable_edge_finding_in_cumulative_constraint: builtins.bool = ...
    """When this is true, the cumulative constraint is reinforced with timetable
    edge finding, i.e., an additional level of reasoning based on the
    conjunction of energy and mandatory parts. This additional level
    supplements the default level of reasoning as well as overload_checker.

    This always result in better propagation, but it is usually slow, so
    depending on the problem, turning this off may lead to a faster solution.
    """

    use_disjunctive_constraint_in_cumulative_constraint: builtins.bool = ...
    """When this is true, the cumulative constraint is reinforced with propagators
    from the disjunctive constraint to improve the inference on a set of tasks
    that are disjunctive at the root of the problem. This additional level
    supplements the default level of reasoning.

    Propagators of the cumulative constraint will not be used at all if all the
    tasks are disjunctive at root node.

    This always result in better propagation, but it is usually slow, so
    depending on the problem, turning this off may lead to a faster solution.
    """

    linearization_level: builtins.int = ...
    """A non-negative level indicating the type of constraints we consider in the
    LP relaxation. At level zero, no LP relaxation is used. At level 1, only
    the linear constraint and full encoding are added. At level 2, we also add
    all the Boolean constraints.
    """

    boolean_encoding_level: builtins.int = ...
    """A non-negative level indicating how much we should try to fully encode
    Integer variables as Boolean.
    """

    max_domain_size_when_encoding_eq_neq_constraints: builtins.int = ...
    """When loading a*x + b*y ==/!= c when x and y are both fully encoded.
    The solver may decide to replace the linear equation by a set of clauses.
    This is triggered if the sizes of the domains of x and y are below the
    threshold.
    """

    max_num_cuts: builtins.int = ...
    """The limit on the number of cuts in our cut pool. When this is reached we do
    not generate cuts anymore.

    TODO(user): We should probably remove this parameters, and just always
    generate cuts but only keep the best n or something.
    """

    only_add_cuts_at_level_zero: builtins.bool = ...
    """For the cut that can be generated at any level, this control if we only
    try to generate them at the root node.
    """

    add_knapsack_cuts: builtins.bool = ...
    """Whether we generate knapsack cuts. Note that in our setting where all
    variables are integer and bounded on both side, such a cut could be applied
    to any constraint.
    """

    add_cg_cuts: builtins.bool = ...
    """Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
    Note that for now, this is not heavily tuned.
    """

    add_mir_cuts: builtins.bool = ...
    """Whether we generate MIR cuts at root node.
    Note that for now, this is not heavily tuned.
    """

    add_zero_half_cuts: builtins.bool = ...
    """Whether we generate Zero-Half cuts at root node.
    Note that for now, this is not heavily tuned.
    """

    add_clique_cuts: builtins.bool = ...
    """Whether we generate clique cuts from the binary implication graph. Note
    that as the search goes on, this graph will contains new binary clauses
    learned by the SAT engine.
    """

    max_all_diff_cut_size: builtins.int = ...
    """Cut generator for all diffs can add too many cuts for large all_diff
    constraints. This parameter restricts the large all_diff constraints to
    have a cut generator.
    """

    add_lin_max_cuts: builtins.bool = ...
    """For the lin max constraints, generates the cuts described in "Strong
    mixed-integer programming formulations for trained neural networks" by Ross
    Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
    """

    max_integer_rounding_scaling: builtins.int = ...
    """In the integer rounding procedure used for MIR and Gomory cut, the maximum
    "scaling" we use (must be positive). The lower this is, the lower the
    integer coefficients of the cut will be. Note that cut generated by lower
    values are not necessarily worse than cut generated by larger value. There
    is no strict dominance relationship.

    Setting this to 2 result in the "strong fractional rouding" of Letchford
    and Lodi.
    """

    add_lp_constraints_lazily: builtins.bool = ...
    """If true, we start by an empty LP, and only add constraints not satisfied
    by the current LP solution batch by batch. A constraint that is only added
    like this is known as a "lazy" constraint in the literature, except that we
    currently consider all constraints as lazy here.
    """

    min_orthogonality_for_lp_constraints: builtins.float = ...
    """While adding constraints, skip the constraints which have orthogonality
    less than 'min_orthogonality_for_lp_constraints' with already added
    constraints during current call. Orthogonality is defined as 1 -
    cosine(vector angle between constraints). A value of zero disable this
    feature.
    """

    max_cut_rounds_at_level_zero: builtins.int = ...
    """Max number of time we perform cut generation and resolve the LP at level 0."""

    max_consecutive_inactive_count: builtins.int = ...
    """If a constraint/cut in LP is not active for that many consecutive OPTIMAL
    solves, remove it from the LP. Note that it might be added again later if
    it become violated by the current LP solution.
    """

    cut_max_active_count_value: builtins.float = ...
    """These parameters are similar to sat clause management activity parameters.
    They are effective only if the number of generated cuts exceed the storage
    limit. Default values are based on a few experiments on miplib instances.
    """

    cut_active_count_decay: builtins.float = ...
    cut_cleanup_target: builtins.int = ...
    """Target number of constraints to remove during cleanup."""

    new_constraints_batch_size: builtins.int = ...
    """Add that many lazy constraints (or cuts) at once in the LP. Note that at
    the beginning of the solve, we do add more than this.
    """

    search_branching: global___SatParameters.SearchBranching.V = ...
    hint_conflict_limit: builtins.int = ...
    """Conflict limit used in the phase that exploit the solution hint."""

    repair_hint: builtins.bool = ...
    """If true, the solver tries to repair the solution given in the hint. This
    search terminates after the 'hint_conflict_limit' is reached and the solver
    switches to regular search. If false, then  we do a FIXED_SEARCH using the
    hint until the hint_conflict_limit is reached.
    """

    fix_variables_to_their_hinted_value: builtins.bool = ...
    """If true, variables appearing in the solution hints will be fixed to their
    hinted value.
    """

    exploit_integer_lp_solution: builtins.bool = ...
    """All the "exploit_*" parameters below work in the same way: when branching
    on an IntegerVariable, these parameters affect the value the variable is
    branched on. Currently the first heuristic that triggers win in the order
    in which they appear below.

    TODO(user): Maybe do like for the restart algorithm, introduce an enum
    and a repeated field that control the order on which these are applied?

    If true and the Lp relaxation of the problem has an integer optimal
    solution, try to exploit it. Note that since the LP relaxation may not
    contain all the constraints, such a solution is not necessarily a solution
    of the full problem.
    """

    exploit_all_lp_solution: builtins.bool = ...
    """If true and the Lp relaxation of the problem has a solution, try to exploit
    it. This is same as above except in this case the lp solution might not be
    an integer solution.
    """

    exploit_best_solution: builtins.bool = ...
    """When branching on a variable, follow the last best solution value."""

    exploit_relaxation_solution: builtins.bool = ...
    """When branching on a variable, follow the last best relaxation solution
    value. We use the relaxation with the tightest bound on the objective as
    the best relaxation solution.
    """

    exploit_objective: builtins.bool = ...
    """When branching an a variable that directly affect the objective,
    branch on the value that lead to the best objective first.
    """

    probing_period_at_root: builtins.int = ...
    """If set at zero (the default), it is disabled. Otherwise the solver attempts
    probing at every 'probing_period' root node. Period of 1 enables probing at
    every root node.
    """

    use_probing_search: builtins.bool = ...
    """If true, search will continuously probe Boolean variables, and integer
    variable bounds.
    """

    pseudo_cost_reliability_threshold: builtins.int = ...
    """The solver ignores the pseudo costs of variables with number of recordings
    less than this threshold.
    """

    optimize_with_core: builtins.bool = ...
    """The default optimization method is a simple "linear scan", each time trying
    to find a better solution than the previous one. If this is true, then we
    use a core-based approach (like in max-SAT) when we try to increase the
    lower bound instead.
    """

    optimize_with_lb_tree_search: builtins.bool = ...
    """Do a more conventional tree search (by opposition to SAT based one) where
    we keep all the explored node in a tree. This is meant to be used in a
    portfolio and focus on improving the objective lower bound. Keeping the
    whole tree allow us to report a better objective lower bound coming from
    the worst open node in the tree.
    """

    binary_search_num_conflicts: builtins.int = ...
    """If non-negative, perform a binary search on the objective variable in order
    to find an [min, max] interval outside of which the solver proved unsat/sat
    under this amount of conflict. This can quickly reduce the objective domain
    on some problems.
    """

    optimize_with_max_hs: builtins.bool = ...
    """This has no effect if optimize_with_core is false. If true, use a different
    core-based algorithm similar to the max-HS algo for max-SAT. This is a
    hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
    one. This is also related to the PhD work of tobyodavies@
    "Automatic Logic-Based Benders Decomposition with MiniZinc"
    http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
    """

    enumerate_all_solutions: builtins.bool = ...
    """Whether we enumerate all solutions of a problem without objective. Note
    that setting this to true automatically disable some presolve reduction
    that can remove feasible solution. That is it has the same effect as
    setting keep_all_feasible_solutions_in_presolve.

    TODO(user): Do not do that and let the user choose what behavior is best by
    setting keep_all_feasible_solutions_in_presolve ?
    """

    keep_all_feasible_solutions_in_presolve: builtins.bool = ...
    """If true, we disable the presolve reductions that remove feasible solutions
    from the search space. Such solution are usually dominated by a "better"
    solution that is kept, but depending on the situation, we might want to
    keep all solutions.

    A trivial example is when a variable is unused. If this is true, then the
    presolve will not fix it to an arbitrary value and it will stay in the
    search space.
    """

    fill_tightened_domains_in_response: builtins.bool = ...
    """If true, add information about the derived variable domains to the
    CpSolverResponse. It is an option because it makes the response slighly
    bigger and there is a bit more work involved during the postsolve to
    construct it, but it should still have a low overhead. See the
    tightened_variables field in CpSolverResponse for more details.
    """

    instantiate_all_variables: builtins.bool = ...
    """If true, the solver will add a default integer branching strategy to the
    already defined search strategy. If not, some variable might still not be
    fixed at the end of the search. For now we assume these variable can just
    be set to their lower bound.
    """

    auto_detect_greater_than_at_least_one_of: builtins.bool = ...
    """If true, then the precedences propagator try to detect for each variable if
    it has a set of "optional incoming arc" for which at least one of them is
    present. This is usually useful to have but can be slow on model with a lot
    of precedence.
    """

    stop_after_first_solution: builtins.bool = ...
    """For an optimization problem, stop the solver as soon as we have a solution."""

    stop_after_presolve: builtins.bool = ...
    """Mainly used when improving the presolver. When true, stops the solver after
    the presolve is complete.
    """

    num_search_workers: builtins.int = ...
    """Specify the number of parallel workers to use during search.
    A value of 0 means the solver will try to use all cores on the machine.
    A number of 1 means no parallelism.
    As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
    programs) this field is overridden with a value of 8, if the field is not
    set *explicitly*. Thus, always set this field explicitly or via
    MPSolver::SetNumThreads().
    """

    interleave_search: builtins.bool = ...
    """Experimental. If this is true, then we interleave all our major search
    strategy and distribute the work amongst num_search_workers.

    The search is deterministic (independently of num_search_workers!), and we
    schedule and wait for interleave_batch_size task to be completed before
    synchronizing and scheduling the next batch of tasks.
    """

    interleave_batch_size: builtins.int = ...
    reduce_memory_usage_in_interleave_mode: builtins.bool = ...
    """Temporary parameter until the memory usage is more optimized."""

    share_objective_bounds: builtins.bool = ...
    """Allows objective sharing between workers."""

    share_level_zero_bounds: builtins.bool = ...
    """Allows sharing of the bounds of modified variables at level 0."""

    use_lns_only: builtins.bool = ...
    """LNS parameters."""

    lns_focus_on_decision_variables: builtins.bool = ...
    lns_expand_intervals_in_constraint_graph: builtins.bool = ...
    solution_pool_size: builtins.int = ...
    """Size of the top-n different solutions kept by the solver.
    Currently this only impact the "base" solution chosen for a LNS fragment.
    """

    use_rins_lns: builtins.bool = ...
    """Turns on relaxation induced neighborhood generator."""

    use_feasibility_pump: builtins.bool = ...
    """Adds a feasibility pump subsolver along with lns subsolvers."""

    fp_rounding: global___SatParameters.FPRoundingMethod.V = ...
    use_relaxation_lns: builtins.bool = ...
    """Turns on a lns worker which solves relaxed version of the original problem
    by removing constraints from the problem in order to get better bounds.
    """

    diversify_lns_params: builtins.bool = ...
    """If true, registers more lns subsolvers with different parameters."""

    randomize_search: builtins.bool = ...
    """Randomize fixed search."""

    search_randomization_tolerance: builtins.int = ...
    """Search randomization will collect equivalent 'max valued' variables, and
    pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
    all unassigned variables are equivalent. If the variable strategy is
    CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
    variables, then the set of max valued variables will be all unassigned
    variables where
       lm <= variable min <= lm + search_randomization_tolerance
    """

    use_optional_variables: builtins.bool = ...
    """If true, we automatically detect variables whose constraint are always
    enforced by the same literal and we mark them as optional. This allows
    to propagate them as if they were present in some situation.
    """

    use_exact_lp_reason: builtins.bool = ...
    """The solver usually exploit the LP relaxation of a model. If this option is
    true, then whatever is infered by the LP will be used like an heuristic to
    compute EXACT propagation on the IP. So with this option, there is no
    numerical imprecision issues.
    """

    use_branching_in_lp: builtins.bool = ...
    """If true, the solver attemts to generate more info inside lp propagator by
    branching on some variables if certain criteria are met during the search
    tree exploration.
    """

    use_combined_no_overlap: builtins.bool = ...
    """This can be beneficial if there is a lot of no-overlap constraints but a
    relatively low number of different intervals in the problem. Like 1000
    intervals, but 1M intervals in the no-overlap constraints covering them.
    """

    catch_sigint_signal: builtins.bool = ...
    """Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
    when calling solve. If set, catching the SIGINT signal will terminate the
    search gracefully, as if a time limit was reached.
    """

    use_implied_bounds: builtins.bool = ...
    """Stores and exploits "implied-bounds" in the solver. That is, relations of
    the form literal => (var >= bound). This is currently used to derive
    stronger cuts.
    """

    polish_lp_solution: builtins.bool = ...
    """Whether we try to do a few degenerate iteration at the end of an LP solve
    to minimize the fractionality of the integer variable in the basis. This
    helps on some problems, but not so much on others. It also cost of bit of
    time to do such polish step.
    """

    convert_intervals: builtins.bool = ...
    """Temporary flag util the feature is more mature. This convert intervals to
    the newer proto format that support affine start/var/end instead of just
    variables.
    """

    symmetry_level: builtins.int = ...
    """Whether we try to automatically detect the symmetries in a model and
    exploit them. Currently, at level 1 we detect them in presolve and try
    to fix Booleans. At level 2, we also do some form of dynamic symmetry
    breaking during search.
    """

    mip_max_bound: builtins.float = ...
    """==========================================================================
    MIP -> CP-SAT (i.e. IP with integer coeff) conversion parameters that are
    used by our automatic "scaling" algorithm.

    Note that it is hard to do a meaningful conversion automatically and if
    you have a model with continuous variables, it is best if you scale the
    domain of the variable yourself so that you have a relevant precision for
    the application at hand. Same for the coefficients and constraint bounds.
    ==========================================================================

    We need to bound the maximum magnitude of the variables for CP-SAT, and
    that is the bound we use. If the MIP model expect larger variable value in
    the solution, then the converted model will likely not be relevant.
    """

    mip_var_scaling: builtins.float = ...
    """All continuous variable of the problem will be multiplied by this factor.
    By default, we don't do any variable scaling and rely on the MIP model to
    specify continuous variable domain with the wanted precision.
    """

    mip_automatically_scale_variables: builtins.bool = ...
    """If true, some continuous variable might be automatically scaled. For now,
    this is only the case where we detect that a variable is actually an
    integer multiple of a constant. For instance, variables of the form k * 0.5
    are quite frequent, and if we detect this, we will scale such variable
    domain by 2 to make it implied integer.
    """

    mip_wanted_precision: builtins.float = ...
    """When scaling constraint with double coefficients to integer coefficients,
    we will multiply by a power of 2 and round the coefficients. We will choose
    the lowest power such that we have no potential overflow and the worst case
    constraint activity error do not exceed this threshold relative to the
    constraint bounds.

    We also use this to decide by how much we relax the constraint bounds so
    that we can have a feasible integer solution of constraints involving
    continuous variable. This is required for instance when you have an == rhs
    constraint as in many situation you cannot have a perfect equality with
    integer variables and coefficients.
    """

    mip_max_activity_exponent: builtins.int = ...
    """To avoid integer overflow, we always force the maximum possible constraint
    activity (and objective value) according to the initial variable domain to
    be smaller than 2 to this given power. Because of this, we cannot always
    reach the "mip_wanted_precision" parameter above.

    This can go as high as 62, but some internal algo currently abort early if
    they might run into integer overflow, so it is better to keep it a bit
    lower than this.
    """

    mip_check_precision: builtins.float = ...
    """As explained in mip_precision and mip_max_activity_exponent, we cannot
    always reach the wanted precision during scaling. We use this threshold to
    enphasize in the logs when the precision seems bad.
    """

    def __init__(self,
        *,
        name : typing.Optional[typing.Text] = ...,
        preferred_variable_order : typing.Optional[global___SatParameters.VariableOrder.V] = ...,
        initial_polarity : typing.Optional[global___SatParameters.Polarity.V] = ...,
        use_phase_saving : typing.Optional[builtins.bool] = ...,
        polarity_rephase_increment : typing.Optional[builtins.int] = ...,
        random_polarity_ratio : typing.Optional[builtins.float] = ...,
        random_branches_ratio : typing.Optional[builtins.float] = ...,
        use_erwa_heuristic : typing.Optional[builtins.bool] = ...,
        initial_variables_activity : typing.Optional[builtins.float] = ...,
        also_bump_variables_in_conflict_reasons : typing.Optional[builtins.bool] = ...,
        minimization_algorithm : typing.Optional[global___SatParameters.ConflictMinimizationAlgorithm.V] = ...,
        binary_minimization_algorithm : typing.Optional[global___SatParameters.BinaryMinizationAlgorithm.V] = ...,
        subsumption_during_conflict_analysis : typing.Optional[builtins.bool] = ...,
        clause_cleanup_period : typing.Optional[builtins.int] = ...,
        clause_cleanup_target : typing.Optional[builtins.int] = ...,
        clause_cleanup_ratio : typing.Optional[builtins.float] = ...,
        clause_cleanup_protection : typing.Optional[global___SatParameters.ClauseProtection.V] = ...,
        clause_cleanup_lbd_bound : typing.Optional[builtins.int] = ...,
        clause_cleanup_ordering : typing.Optional[global___SatParameters.ClauseOrdering.V] = ...,
        pb_cleanup_increment : typing.Optional[builtins.int] = ...,
        pb_cleanup_ratio : typing.Optional[builtins.float] = ...,
        minimize_with_propagation_restart_period : typing.Optional[builtins.int] = ...,
        minimize_with_propagation_num_decisions : typing.Optional[builtins.int] = ...,
        variable_activity_decay : typing.Optional[builtins.float] = ...,
        max_variable_activity_value : typing.Optional[builtins.float] = ...,
        glucose_max_decay : typing.Optional[builtins.float] = ...,
        glucose_decay_increment : typing.Optional[builtins.float] = ...,
        glucose_decay_increment_period : typing.Optional[builtins.int] = ...,
        clause_activity_decay : typing.Optional[builtins.float] = ...,
        max_clause_activity_value : typing.Optional[builtins.float] = ...,
        restart_algorithms : typing.Optional[typing.Iterable[global___SatParameters.RestartAlgorithm.V]] = ...,
        default_restart_algorithms : typing.Optional[typing.Text] = ...,
        restart_period : typing.Optional[builtins.int] = ...,
        restart_running_window_size : typing.Optional[builtins.int] = ...,
        restart_dl_average_ratio : typing.Optional[builtins.float] = ...,
        restart_lbd_average_ratio : typing.Optional[builtins.float] = ...,
        use_blocking_restart : typing.Optional[builtins.bool] = ...,
        blocking_restart_window_size : typing.Optional[builtins.int] = ...,
        blocking_restart_multiplier : typing.Optional[builtins.float] = ...,
        num_conflicts_before_strategy_changes : typing.Optional[builtins.int] = ...,
        strategy_change_increase_ratio : typing.Optional[builtins.float] = ...,
        max_time_in_seconds : typing.Optional[builtins.float] = ...,
        max_deterministic_time : typing.Optional[builtins.float] = ...,
        max_number_of_conflicts : typing.Optional[builtins.int] = ...,
        max_memory_in_mb : typing.Optional[builtins.int] = ...,
        absolute_gap_limit : typing.Optional[builtins.float] = ...,
        relative_gap_limit : typing.Optional[builtins.float] = ...,
        treat_binary_clauses_separately : typing.Optional[builtins.bool] = ...,
        random_seed : typing.Optional[builtins.int] = ...,
        permute_variable_randomly : typing.Optional[builtins.bool] = ...,
        permute_presolve_constraint_order : typing.Optional[builtins.bool] = ...,
        use_absl_random : typing.Optional[builtins.bool] = ...,
        log_search_progress : typing.Optional[builtins.bool] = ...,
        log_subsolver_statistics : typing.Optional[builtins.bool] = ...,
        log_prefix : typing.Optional[typing.Text] = ...,
        log_to_stdout : typing.Optional[builtins.bool] = ...,
        log_to_response : typing.Optional[builtins.bool] = ...,
        use_pb_resolution : typing.Optional[builtins.bool] = ...,
        minimize_reduction_during_pb_resolution : typing.Optional[builtins.bool] = ...,
        count_assumption_levels_in_lbd : typing.Optional[builtins.bool] = ...,
        presolve_bve_threshold : typing.Optional[builtins.int] = ...,
        presolve_bve_clause_weight : typing.Optional[builtins.int] = ...,
        presolve_probing_deterministic_time_limit : typing.Optional[builtins.float] = ...,
        presolve_blocked_clause : typing.Optional[builtins.bool] = ...,
        presolve_use_bva : typing.Optional[builtins.bool] = ...,
        presolve_bva_threshold : typing.Optional[builtins.int] = ...,
        max_presolve_iterations : typing.Optional[builtins.int] = ...,
        cp_model_presolve : typing.Optional[builtins.bool] = ...,
        cp_model_postsolve_with_full_solver : typing.Optional[builtins.bool] = ...,
        cp_model_max_num_presolve_operations : typing.Optional[builtins.int] = ...,
        cp_model_probing_level : typing.Optional[builtins.int] = ...,
        cp_model_use_sat_presolve : typing.Optional[builtins.bool] = ...,
        use_sat_inprocessing : typing.Optional[builtins.bool] = ...,
        expand_element_constraints : typing.Optional[builtins.bool] = ...,
        expand_automaton_constraints : typing.Optional[builtins.bool] = ...,
        expand_table_constraints : typing.Optional[builtins.bool] = ...,
        expand_alldiff_constraints : typing.Optional[builtins.bool] = ...,
        expand_reservoir_constraints : typing.Optional[builtins.bool] = ...,
        disable_constraint_expansion : typing.Optional[builtins.bool] = ...,
        merge_no_overlap_work_limit : typing.Optional[builtins.float] = ...,
        merge_at_most_one_work_limit : typing.Optional[builtins.float] = ...,
        presolve_substitution_level : typing.Optional[builtins.int] = ...,
        presolve_extract_integer_enforcement : typing.Optional[builtins.bool] = ...,
        use_optimization_hints : typing.Optional[builtins.bool] = ...,
        minimize_core : typing.Optional[builtins.bool] = ...,
        find_multiple_cores : typing.Optional[builtins.bool] = ...,
        cover_optimization : typing.Optional[builtins.bool] = ...,
        max_sat_assumption_order : typing.Optional[global___SatParameters.MaxSatAssumptionOrder.V] = ...,
        max_sat_reverse_assumption_order : typing.Optional[builtins.bool] = ...,
        max_sat_stratification : typing.Optional[global___SatParameters.MaxSatStratificationAlgorithm.V] = ...,
        use_precedences_in_disjunctive_constraint : typing.Optional[builtins.bool] = ...,
        use_overload_checker_in_cumulative_constraint : typing.Optional[builtins.bool] = ...,
        use_timetable_edge_finding_in_cumulative_constraint : typing.Optional[builtins.bool] = ...,
        use_disjunctive_constraint_in_cumulative_constraint : typing.Optional[builtins.bool] = ...,
        linearization_level : typing.Optional[builtins.int] = ...,
        boolean_encoding_level : typing.Optional[builtins.int] = ...,
        max_domain_size_when_encoding_eq_neq_constraints : typing.Optional[builtins.int] = ...,
        max_num_cuts : typing.Optional[builtins.int] = ...,
        only_add_cuts_at_level_zero : typing.Optional[builtins.bool] = ...,
        add_knapsack_cuts : typing.Optional[builtins.bool] = ...,
        add_cg_cuts : typing.Optional[builtins.bool] = ...,
        add_mir_cuts : typing.Optional[builtins.bool] = ...,
        add_zero_half_cuts : typing.Optional[builtins.bool] = ...,
        add_clique_cuts : typing.Optional[builtins.bool] = ...,
        max_all_diff_cut_size : typing.Optional[builtins.int] = ...,
        add_lin_max_cuts : typing.Optional[builtins.bool] = ...,
        max_integer_rounding_scaling : typing.Optional[builtins.int] = ...,
        add_lp_constraints_lazily : typing.Optional[builtins.bool] = ...,
        min_orthogonality_for_lp_constraints : typing.Optional[builtins.float] = ...,
        max_cut_rounds_at_level_zero : typing.Optional[builtins.int] = ...,
        max_consecutive_inactive_count : typing.Optional[builtins.int] = ...,
        cut_max_active_count_value : typing.Optional[builtins.float] = ...,
        cut_active_count_decay : typing.Optional[builtins.float] = ...,
        cut_cleanup_target : typing.Optional[builtins.int] = ...,
        new_constraints_batch_size : typing.Optional[builtins.int] = ...,
        search_branching : typing.Optional[global___SatParameters.SearchBranching.V] = ...,
        hint_conflict_limit : typing.Optional[builtins.int] = ...,
        repair_hint : typing.Optional[builtins.bool] = ...,
        fix_variables_to_their_hinted_value : typing.Optional[builtins.bool] = ...,
        exploit_integer_lp_solution : typing.Optional[builtins.bool] = ...,
        exploit_all_lp_solution : typing.Optional[builtins.bool] = ...,
        exploit_best_solution : typing.Optional[builtins.bool] = ...,
        exploit_relaxation_solution : typing.Optional[builtins.bool] = ...,
        exploit_objective : typing.Optional[builtins.bool] = ...,
        probing_period_at_root : typing.Optional[builtins.int] = ...,
        use_probing_search : typing.Optional[builtins.bool] = ...,
        pseudo_cost_reliability_threshold : typing.Optional[builtins.int] = ...,
        optimize_with_core : typing.Optional[builtins.bool] = ...,
        optimize_with_lb_tree_search : typing.Optional[builtins.bool] = ...,
        binary_search_num_conflicts : typing.Optional[builtins.int] = ...,
        optimize_with_max_hs : typing.Optional[builtins.bool] = ...,
        enumerate_all_solutions : typing.Optional[builtins.bool] = ...,
        keep_all_feasible_solutions_in_presolve : typing.Optional[builtins.bool] = ...,
        fill_tightened_domains_in_response : typing.Optional[builtins.bool] = ...,
        instantiate_all_variables : typing.Optional[builtins.bool] = ...,
        auto_detect_greater_than_at_least_one_of : typing.Optional[builtins.bool] = ...,
        stop_after_first_solution : typing.Optional[builtins.bool] = ...,
        stop_after_presolve : typing.Optional[builtins.bool] = ...,
        num_search_workers : typing.Optional[builtins.int] = ...,
        interleave_search : typing.Optional[builtins.bool] = ...,
        interleave_batch_size : typing.Optional[builtins.int] = ...,
        reduce_memory_usage_in_interleave_mode : typing.Optional[builtins.bool] = ...,
        share_objective_bounds : typing.Optional[builtins.bool] = ...,
        share_level_zero_bounds : typing.Optional[builtins.bool] = ...,
        use_lns_only : typing.Optional[builtins.bool] = ...,
        lns_focus_on_decision_variables : typing.Optional[builtins.bool] = ...,
        lns_expand_intervals_in_constraint_graph : typing.Optional[builtins.bool] = ...,
        solution_pool_size : typing.Optional[builtins.int] = ...,
        use_rins_lns : typing.Optional[builtins.bool] = ...,
        use_feasibility_pump : typing.Optional[builtins.bool] = ...,
        fp_rounding : typing.Optional[global___SatParameters.FPRoundingMethod.V] = ...,
        use_relaxation_lns : typing.Optional[builtins.bool] = ...,
        diversify_lns_params : typing.Optional[builtins.bool] = ...,
        randomize_search : typing.Optional[builtins.bool] = ...,
        search_randomization_tolerance : typing.Optional[builtins.int] = ...,
        use_optional_variables : typing.Optional[builtins.bool] = ...,
        use_exact_lp_reason : typing.Optional[builtins.bool] = ...,
        use_branching_in_lp : typing.Optional[builtins.bool] = ...,
        use_combined_no_overlap : typing.Optional[builtins.bool] = ...,
        catch_sigint_signal : typing.Optional[builtins.bool] = ...,
        use_implied_bounds : typing.Optional[builtins.bool] = ...,
        polish_lp_solution : typing.Optional[builtins.bool] = ...,
        convert_intervals : typing.Optional[builtins.bool] = ...,
        symmetry_level : typing.Optional[builtins.int] = ...,
        mip_max_bound : typing.Optional[builtins.float] = ...,
        mip_var_scaling : typing.Optional[builtins.float] = ...,
        mip_automatically_scale_variables : typing.Optional[builtins.bool] = ...,
        mip_wanted_precision : typing.Optional[builtins.float] = ...,
        mip_max_activity_exponent : typing.Optional[builtins.int] = ...,
        mip_check_precision : typing.Optional[builtins.float] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["absolute_gap_limit",b"absolute_gap_limit","add_cg_cuts",b"add_cg_cuts","add_clique_cuts",b"add_clique_cuts","add_knapsack_cuts",b"add_knapsack_cuts","add_lin_max_cuts",b"add_lin_max_cuts","add_lp_constraints_lazily",b"add_lp_constraints_lazily","add_mir_cuts",b"add_mir_cuts","add_zero_half_cuts",b"add_zero_half_cuts","also_bump_variables_in_conflict_reasons",b"also_bump_variables_in_conflict_reasons","auto_detect_greater_than_at_least_one_of",b"auto_detect_greater_than_at_least_one_of","binary_minimization_algorithm",b"binary_minimization_algorithm","binary_search_num_conflicts",b"binary_search_num_conflicts","blocking_restart_multiplier",b"blocking_restart_multiplier","blocking_restart_window_size",b"blocking_restart_window_size","boolean_encoding_level",b"boolean_encoding_level","catch_sigint_signal",b"catch_sigint_signal","clause_activity_decay",b"clause_activity_decay","clause_cleanup_lbd_bound",b"clause_cleanup_lbd_bound","clause_cleanup_ordering",b"clause_cleanup_ordering","clause_cleanup_period",b"clause_cleanup_period","clause_cleanup_protection",b"clause_cleanup_protection","clause_cleanup_ratio",b"clause_cleanup_ratio","clause_cleanup_target",b"clause_cleanup_target","convert_intervals",b"convert_intervals","count_assumption_levels_in_lbd",b"count_assumption_levels_in_lbd","cover_optimization",b"cover_optimization","cp_model_max_num_presolve_operations",b"cp_model_max_num_presolve_operations","cp_model_postsolve_with_full_solver",b"cp_model_postsolve_with_full_solver","cp_model_presolve",b"cp_model_presolve","cp_model_probing_level",b"cp_model_probing_level","cp_model_use_sat_presolve",b"cp_model_use_sat_presolve","cut_active_count_decay",b"cut_active_count_decay","cut_cleanup_target",b"cut_cleanup_target","cut_max_active_count_value",b"cut_max_active_count_value","default_restart_algorithms",b"default_restart_algorithms","disable_constraint_expansion",b"disable_constraint_expansion","diversify_lns_params",b"diversify_lns_params","enumerate_all_solutions",b"enumerate_all_solutions","expand_alldiff_constraints",b"expand_alldiff_constraints","expand_automaton_constraints",b"expand_automaton_constraints","expand_element_constraints",b"expand_element_constraints","expand_reservoir_constraints",b"expand_reservoir_constraints","expand_table_constraints",b"expand_table_constraints","exploit_all_lp_solution",b"exploit_all_lp_solution","exploit_best_solution",b"exploit_best_solution","exploit_integer_lp_solution",b"exploit_integer_lp_solution","exploit_objective",b"exploit_objective","exploit_relaxation_solution",b"exploit_relaxation_solution","fill_tightened_domains_in_response",b"fill_tightened_domains_in_response","find_multiple_cores",b"find_multiple_cores","fix_variables_to_their_hinted_value",b"fix_variables_to_their_hinted_value","fp_rounding",b"fp_rounding","glucose_decay_increment",b"glucose_decay_increment","glucose_decay_increment_period",b"glucose_decay_increment_period","glucose_max_decay",b"glucose_max_decay","hint_conflict_limit",b"hint_conflict_limit","initial_polarity",b"initial_polarity","initial_variables_activity",b"initial_variables_activity","instantiate_all_variables",b"instantiate_all_variables","interleave_batch_size",b"interleave_batch_size","interleave_search",b"interleave_search","keep_all_feasible_solutions_in_presolve",b"keep_all_feasible_solutions_in_presolve","linearization_level",b"linearization_level","lns_expand_intervals_in_constraint_graph",b"lns_expand_intervals_in_constraint_graph","lns_focus_on_decision_variables",b"lns_focus_on_decision_variables","log_prefix",b"log_prefix","log_search_progress",b"log_search_progress","log_subsolver_statistics",b"log_subsolver_statistics","log_to_response",b"log_to_response","log_to_stdout",b"log_to_stdout","max_all_diff_cut_size",b"max_all_diff_cut_size","max_clause_activity_value",b"max_clause_activity_value","max_consecutive_inactive_count",b"max_consecutive_inactive_count","max_cut_rounds_at_level_zero",b"max_cut_rounds_at_level_zero","max_deterministic_time",b"max_deterministic_time","max_domain_size_when_encoding_eq_neq_constraints",b"max_domain_size_when_encoding_eq_neq_constraints","max_integer_rounding_scaling",b"max_integer_rounding_scaling","max_memory_in_mb",b"max_memory_in_mb","max_num_cuts",b"max_num_cuts","max_number_of_conflicts",b"max_number_of_conflicts","max_presolve_iterations",b"max_presolve_iterations","max_sat_assumption_order",b"max_sat_assumption_order","max_sat_reverse_assumption_order",b"max_sat_reverse_assumption_order","max_sat_stratification",b"max_sat_stratification","max_time_in_seconds",b"max_time_in_seconds","max_variable_activity_value",b"max_variable_activity_value","merge_at_most_one_work_limit",b"merge_at_most_one_work_limit","merge_no_overlap_work_limit",b"merge_no_overlap_work_limit","min_orthogonality_for_lp_constraints",b"min_orthogonality_for_lp_constraints","minimization_algorithm",b"minimization_algorithm","minimize_core",b"minimize_core","minimize_reduction_during_pb_resolution",b"minimize_reduction_during_pb_resolution","minimize_with_propagation_num_decisions",b"minimize_with_propagation_num_decisions","minimize_with_propagation_restart_period",b"minimize_with_propagation_restart_period","mip_automatically_scale_variables",b"mip_automatically_scale_variables","mip_check_precision",b"mip_check_precision","mip_max_activity_exponent",b"mip_max_activity_exponent","mip_max_bound",b"mip_max_bound","mip_var_scaling",b"mip_var_scaling","mip_wanted_precision",b"mip_wanted_precision","name",b"name","new_constraints_batch_size",b"new_constraints_batch_size","num_conflicts_before_strategy_changes",b"num_conflicts_before_strategy_changes","num_search_workers",b"num_search_workers","only_add_cuts_at_level_zero",b"only_add_cuts_at_level_zero","optimize_with_core",b"optimize_with_core","optimize_with_lb_tree_search",b"optimize_with_lb_tree_search","optimize_with_max_hs",b"optimize_with_max_hs","pb_cleanup_increment",b"pb_cleanup_increment","pb_cleanup_ratio",b"pb_cleanup_ratio","permute_presolve_constraint_order",b"permute_presolve_constraint_order","permute_variable_randomly",b"permute_variable_randomly","polarity_rephase_increment",b"polarity_rephase_increment","polish_lp_solution",b"polish_lp_solution","preferred_variable_order",b"preferred_variable_order","presolve_blocked_clause",b"presolve_blocked_clause","presolve_bva_threshold",b"presolve_bva_threshold","presolve_bve_clause_weight",b"presolve_bve_clause_weight","presolve_bve_threshold",b"presolve_bve_threshold","presolve_extract_integer_enforcement",b"presolve_extract_integer_enforcement","presolve_probing_deterministic_time_limit",b"presolve_probing_deterministic_time_limit","presolve_substitution_level",b"presolve_substitution_level","presolve_use_bva",b"presolve_use_bva","probing_period_at_root",b"probing_period_at_root","pseudo_cost_reliability_threshold",b"pseudo_cost_reliability_threshold","random_branches_ratio",b"random_branches_ratio","random_polarity_ratio",b"random_polarity_ratio","random_seed",b"random_seed","randomize_search",b"randomize_search","reduce_memory_usage_in_interleave_mode",b"reduce_memory_usage_in_interleave_mode","relative_gap_limit",b"relative_gap_limit","repair_hint",b"repair_hint","restart_dl_average_ratio",b"restart_dl_average_ratio","restart_lbd_average_ratio",b"restart_lbd_average_ratio","restart_period",b"restart_period","restart_running_window_size",b"restart_running_window_size","search_branching",b"search_branching","search_randomization_tolerance",b"search_randomization_tolerance","share_level_zero_bounds",b"share_level_zero_bounds","share_objective_bounds",b"share_objective_bounds","solution_pool_size",b"solution_pool_size","stop_after_first_solution",b"stop_after_first_solution","stop_after_presolve",b"stop_after_presolve","strategy_change_increase_ratio",b"strategy_change_increase_ratio","subsumption_during_conflict_analysis",b"subsumption_during_conflict_analysis","symmetry_level",b"symmetry_level","treat_binary_clauses_separately",b"treat_binary_clauses_separately","use_absl_random",b"use_absl_random","use_blocking_restart",b"use_blocking_restart","use_branching_in_lp",b"use_branching_in_lp","use_combined_no_overlap",b"use_combined_no_overlap","use_disjunctive_constraint_in_cumulative_constraint",b"use_disjunctive_constraint_in_cumulative_constraint","use_erwa_heuristic",b"use_erwa_heuristic","use_exact_lp_reason",b"use_exact_lp_reason","use_feasibility_pump",b"use_feasibility_pump","use_implied_bounds",b"use_implied_bounds","use_lns_only",b"use_lns_only","use_optimization_hints",b"use_optimization_hints","use_optional_variables",b"use_optional_variables","use_overload_checker_in_cumulative_constraint",b"use_overload_checker_in_cumulative_constraint","use_pb_resolution",b"use_pb_resolution","use_phase_saving",b"use_phase_saving","use_precedences_in_disjunctive_constraint",b"use_precedences_in_disjunctive_constraint","use_probing_search",b"use_probing_search","use_relaxation_lns",b"use_relaxation_lns","use_rins_lns",b"use_rins_lns","use_sat_inprocessing",b"use_sat_inprocessing","use_timetable_edge_finding_in_cumulative_constraint",b"use_timetable_edge_finding_in_cumulative_constraint","variable_activity_decay",b"variable_activity_decay"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["absolute_gap_limit",b"absolute_gap_limit","add_cg_cuts",b"add_cg_cuts","add_clique_cuts",b"add_clique_cuts","add_knapsack_cuts",b"add_knapsack_cuts","add_lin_max_cuts",b"add_lin_max_cuts","add_lp_constraints_lazily",b"add_lp_constraints_lazily","add_mir_cuts",b"add_mir_cuts","add_zero_half_cuts",b"add_zero_half_cuts","also_bump_variables_in_conflict_reasons",b"also_bump_variables_in_conflict_reasons","auto_detect_greater_than_at_least_one_of",b"auto_detect_greater_than_at_least_one_of","binary_minimization_algorithm",b"binary_minimization_algorithm","binary_search_num_conflicts",b"binary_search_num_conflicts","blocking_restart_multiplier",b"blocking_restart_multiplier","blocking_restart_window_size",b"blocking_restart_window_size","boolean_encoding_level",b"boolean_encoding_level","catch_sigint_signal",b"catch_sigint_signal","clause_activity_decay",b"clause_activity_decay","clause_cleanup_lbd_bound",b"clause_cleanup_lbd_bound","clause_cleanup_ordering",b"clause_cleanup_ordering","clause_cleanup_period",b"clause_cleanup_period","clause_cleanup_protection",b"clause_cleanup_protection","clause_cleanup_ratio",b"clause_cleanup_ratio","clause_cleanup_target",b"clause_cleanup_target","convert_intervals",b"convert_intervals","count_assumption_levels_in_lbd",b"count_assumption_levels_in_lbd","cover_optimization",b"cover_optimization","cp_model_max_num_presolve_operations",b"cp_model_max_num_presolve_operations","cp_model_postsolve_with_full_solver",b"cp_model_postsolve_with_full_solver","cp_model_presolve",b"cp_model_presolve","cp_model_probing_level",b"cp_model_probing_level","cp_model_use_sat_presolve",b"cp_model_use_sat_presolve","cut_active_count_decay",b"cut_active_count_decay","cut_cleanup_target",b"cut_cleanup_target","cut_max_active_count_value",b"cut_max_active_count_value","default_restart_algorithms",b"default_restart_algorithms","disable_constraint_expansion",b"disable_constraint_expansion","diversify_lns_params",b"diversify_lns_params","enumerate_all_solutions",b"enumerate_all_solutions","expand_alldiff_constraints",b"expand_alldiff_constraints","expand_automaton_constraints",b"expand_automaton_constraints","expand_element_constraints",b"expand_element_constraints","expand_reservoir_constraints",b"expand_reservoir_constraints","expand_table_constraints",b"expand_table_constraints","exploit_all_lp_solution",b"exploit_all_lp_solution","exploit_best_solution",b"exploit_best_solution","exploit_integer_lp_solution",b"exploit_integer_lp_solution","exploit_objective",b"exploit_objective","exploit_relaxation_solution",b"exploit_relaxation_solution","fill_tightened_domains_in_response",b"fill_tightened_domains_in_response","find_multiple_cores",b"find_multiple_cores","fix_variables_to_their_hinted_value",b"fix_variables_to_their_hinted_value","fp_rounding",b"fp_rounding","glucose_decay_increment",b"glucose_decay_increment","glucose_decay_increment_period",b"glucose_decay_increment_period","glucose_max_decay",b"glucose_max_decay","hint_conflict_limit",b"hint_conflict_limit","initial_polarity",b"initial_polarity","initial_variables_activity",b"initial_variables_activity","instantiate_all_variables",b"instantiate_all_variables","interleave_batch_size",b"interleave_batch_size","interleave_search",b"interleave_search","keep_all_feasible_solutions_in_presolve",b"keep_all_feasible_solutions_in_presolve","linearization_level",b"linearization_level","lns_expand_intervals_in_constraint_graph",b"lns_expand_intervals_in_constraint_graph","lns_focus_on_decision_variables",b"lns_focus_on_decision_variables","log_prefix",b"log_prefix","log_search_progress",b"log_search_progress","log_subsolver_statistics",b"log_subsolver_statistics","log_to_response",b"log_to_response","log_to_stdout",b"log_to_stdout","max_all_diff_cut_size",b"max_all_diff_cut_size","max_clause_activity_value",b"max_clause_activity_value","max_consecutive_inactive_count",b"max_consecutive_inactive_count","max_cut_rounds_at_level_zero",b"max_cut_rounds_at_level_zero","max_deterministic_time",b"max_deterministic_time","max_domain_size_when_encoding_eq_neq_constraints",b"max_domain_size_when_encoding_eq_neq_constraints","max_integer_rounding_scaling",b"max_integer_rounding_scaling","max_memory_in_mb",b"max_memory_in_mb","max_num_cuts",b"max_num_cuts","max_number_of_conflicts",b"max_number_of_conflicts","max_presolve_iterations",b"max_presolve_iterations","max_sat_assumption_order",b"max_sat_assumption_order","max_sat_reverse_assumption_order",b"max_sat_reverse_assumption_order","max_sat_stratification",b"max_sat_stratification","max_time_in_seconds",b"max_time_in_seconds","max_variable_activity_value",b"max_variable_activity_value","merge_at_most_one_work_limit",b"merge_at_most_one_work_limit","merge_no_overlap_work_limit",b"merge_no_overlap_work_limit","min_orthogonality_for_lp_constraints",b"min_orthogonality_for_lp_constraints","minimization_algorithm",b"minimization_algorithm","minimize_core",b"minimize_core","minimize_reduction_during_pb_resolution",b"minimize_reduction_during_pb_resolution","minimize_with_propagation_num_decisions",b"minimize_with_propagation_num_decisions","minimize_with_propagation_restart_period",b"minimize_with_propagation_restart_period","mip_automatically_scale_variables",b"mip_automatically_scale_variables","mip_check_precision",b"mip_check_precision","mip_max_activity_exponent",b"mip_max_activity_exponent","mip_max_bound",b"mip_max_bound","mip_var_scaling",b"mip_var_scaling","mip_wanted_precision",b"mip_wanted_precision","name",b"name","new_constraints_batch_size",b"new_constraints_batch_size","num_conflicts_before_strategy_changes",b"num_conflicts_before_strategy_changes","num_search_workers",b"num_search_workers","only_add_cuts_at_level_zero",b"only_add_cuts_at_level_zero","optimize_with_core",b"optimize_with_core","optimize_with_lb_tree_search",b"optimize_with_lb_tree_search","optimize_with_max_hs",b"optimize_with_max_hs","pb_cleanup_increment",b"pb_cleanup_increment","pb_cleanup_ratio",b"pb_cleanup_ratio","permute_presolve_constraint_order",b"permute_presolve_constraint_order","permute_variable_randomly",b"permute_variable_randomly","polarity_rephase_increment",b"polarity_rephase_increment","polish_lp_solution",b"polish_lp_solution","preferred_variable_order",b"preferred_variable_order","presolve_blocked_clause",b"presolve_blocked_clause","presolve_bva_threshold",b"presolve_bva_threshold","presolve_bve_clause_weight",b"presolve_bve_clause_weight","presolve_bve_threshold",b"presolve_bve_threshold","presolve_extract_integer_enforcement",b"presolve_extract_integer_enforcement","presolve_probing_deterministic_time_limit",b"presolve_probing_deterministic_time_limit","presolve_substitution_level",b"presolve_substitution_level","presolve_use_bva",b"presolve_use_bva","probing_period_at_root",b"probing_period_at_root","pseudo_cost_reliability_threshold",b"pseudo_cost_reliability_threshold","random_branches_ratio",b"random_branches_ratio","random_polarity_ratio",b"random_polarity_ratio","random_seed",b"random_seed","randomize_search",b"randomize_search","reduce_memory_usage_in_interleave_mode",b"reduce_memory_usage_in_interleave_mode","relative_gap_limit",b"relative_gap_limit","repair_hint",b"repair_hint","restart_algorithms",b"restart_algorithms","restart_dl_average_ratio",b"restart_dl_average_ratio","restart_lbd_average_ratio",b"restart_lbd_average_ratio","restart_period",b"restart_period","restart_running_window_size",b"restart_running_window_size","search_branching",b"search_branching","search_randomization_tolerance",b"search_randomization_tolerance","share_level_zero_bounds",b"share_level_zero_bounds","share_objective_bounds",b"share_objective_bounds","solution_pool_size",b"solution_pool_size","stop_after_first_solution",b"stop_after_first_solution","stop_after_presolve",b"stop_after_presolve","strategy_change_increase_ratio",b"strategy_change_increase_ratio","subsumption_during_conflict_analysis",b"subsumption_during_conflict_analysis","symmetry_level",b"symmetry_level","treat_binary_clauses_separately",b"treat_binary_clauses_separately","use_absl_random",b"use_absl_random","use_blocking_restart",b"use_blocking_restart","use_branching_in_lp",b"use_branching_in_lp","use_combined_no_overlap",b"use_combined_no_overlap","use_disjunctive_constraint_in_cumulative_constraint",b"use_disjunctive_constraint_in_cumulative_constraint","use_erwa_heuristic",b"use_erwa_heuristic","use_exact_lp_reason",b"use_exact_lp_reason","use_feasibility_pump",b"use_feasibility_pump","use_implied_bounds",b"use_implied_bounds","use_lns_only",b"use_lns_only","use_optimization_hints",b"use_optimization_hints","use_optional_variables",b"use_optional_variables","use_overload_checker_in_cumulative_constraint",b"use_overload_checker_in_cumulative_constraint","use_pb_resolution",b"use_pb_resolution","use_phase_saving",b"use_phase_saving","use_precedences_in_disjunctive_constraint",b"use_precedences_in_disjunctive_constraint","use_probing_search",b"use_probing_search","use_relaxation_lns",b"use_relaxation_lns","use_rins_lns",b"use_rins_lns","use_sat_inprocessing",b"use_sat_inprocessing","use_timetable_edge_finding_in_cumulative_constraint",b"use_timetable_edge_finding_in_cumulative_constraint","variable_activity_decay",b"variable_activity_decay"]) -> None: ...
global___SatParameters = SatParameters
