"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class CpSolverStatus(_CpSolverStatus, metaclass=_CpSolverStatusEnumTypeWrapper):
    """The status returned by a solver trying to solve a CpModelProto."""
    pass
class _CpSolverStatus:
    V = typing.NewType('V', builtins.int)
class _CpSolverStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CpSolverStatus.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    UNKNOWN = CpSolverStatus.V(0)
    """The status of the model is still unknown. A search limit has been reached
    before any of the statuses below could be determined.
    """

    MODEL_INVALID = CpSolverStatus.V(1)
    """The given CpModelProto didn't pass the validation step. You can get a
    detailed error by calling ValidateCpModel(model_proto).
    """

    FEASIBLE = CpSolverStatus.V(2)
    """A feasible solution has been found. But the search was stopped before we
    could prove optimality or before we enumerated all solutions of a
    feasibility problem (if asked).
    """

    INFEASIBLE = CpSolverStatus.V(3)
    """The problem has been proven infeasible."""

    OPTIMAL = CpSolverStatus.V(4)
    """An optimal feasible solution has been found.

    More generally, this status represent a success. So we also return OPTIMAL
    if we find a solution for a pure feasiblity problem or if a gap limit has
    been specified and we return a solution within this limit. In the case
    where we need to return all the feasible solution, this status will only be
    returned if we enumerated all of them; If we stopped before, we will return
    FEASIBLE.
    """


UNKNOWN = CpSolverStatus.V(0)
"""The status of the model is still unknown. A search limit has been reached
before any of the statuses below could be determined.
"""

MODEL_INVALID = CpSolverStatus.V(1)
"""The given CpModelProto didn't pass the validation step. You can get a
detailed error by calling ValidateCpModel(model_proto).
"""

FEASIBLE = CpSolverStatus.V(2)
"""A feasible solution has been found. But the search was stopped before we
could prove optimality or before we enumerated all solutions of a
feasibility problem (if asked).
"""

INFEASIBLE = CpSolverStatus.V(3)
"""The problem has been proven infeasible."""

OPTIMAL = CpSolverStatus.V(4)
"""An optimal feasible solution has been found.

More generally, this status represent a success. So we also return OPTIMAL
if we find a solution for a pure feasiblity problem or if a gap limit has
been specified and we return a solution within this limit. In the case
where we need to return all the feasible solution, this status will only be
returned if we enumerated all of them; If we stopped before, we will return
FEASIBLE.
"""

global___CpSolverStatus = CpSolverStatus


class IntegerVariableProto(google.protobuf.message.Message):
    """An integer variable.

    It will be referred to by an int32 corresponding to its index in a
    CpModelProto variables field.

    Depending on the context, a reference to a variable whose domain is in [0, 1]
    can also be seen as a Boolean that will be true if the variable value is 1
    and false if it is 0. When used in this context, the field name will always
    contain the word "literal".

    Negative reference (advanced usage): to simplify the creation of a model and
    for efficiency reasons, all the "literal" or "variable" fields can also
    contain a negative index. A negative index i will refer to the negation of
    the integer variable at index -i -1 or to NOT the literal at the same index.

    Ex: A variable index 4 will refer to the integer variable model.variables(4)
    and an index of -5 will refer to the negation of the same variable. A literal
    index 4 will refer to the logical fact that model.variable(4) == 1 and a
    literal index of -5 will refer to the logical fact model.variable(4) == 0.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """For debug/logging only. Can be empty."""

    @property
    def domain(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The variable domain given as a sorted list of n disjoint intervals
        [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].

        The most common example being just [min, max].
        If min == max, then this is a constant variable.

        We have:
         - domain_size() is always even.
         - min == domain.front();
         - max == domain.back();
         - for all i < n   :      min_i <= max_i
         - for all i < n-1 :  max_i + 1 < min_{i+1}.

        Note that we check at validation that a variable domain is small enough so
        that we don't run into integer overflow in our algorithms. Because of that,
        you cannot just have "unbounded" variable like [0, kint64max] and should
        try to specify tighter domains.
        """
        pass
    def __init__(self,
        *,
        name : typing.Text = ...,
        domain : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["domain",b"domain","name",b"name"]) -> None: ...
global___IntegerVariableProto = IntegerVariableProto

class BoolArgumentProto(google.protobuf.message.Message):
    """Argument of the constraints of the form OP(literals)."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    LITERALS_FIELD_NUMBER: builtins.int
    @property
    def literals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        literals : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["literals",b"literals"]) -> None: ...
global___BoolArgumentProto = BoolArgumentProto

class IntegerArgumentProto(google.protobuf.message.Message):
    """Argument of the constraints of the form target_var = OP(vars)."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TARGET_FIELD_NUMBER: builtins.int
    VARS_FIELD_NUMBER: builtins.int
    target: builtins.int = ...
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        target : builtins.int = ...,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["target",b"target","vars",b"vars"]) -> None: ...
global___IntegerArgumentProto = IntegerArgumentProto

class LinearExpressionProto(google.protobuf.message.Message):
    """Some constraints supports linear expression instead of just using a reference
    to a variable. This is especially useful during presolve to reduce the model
    size.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VARS_FIELD_NUMBER: builtins.int
    COEFFS_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def coeffs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    offset: builtins.int = ...
    def __init__(self,
        *,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        coeffs : typing.Optional[typing.Iterable[builtins.int]] = ...,
        offset : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["coeffs",b"coeffs","offset",b"offset","vars",b"vars"]) -> None: ...
global___LinearExpressionProto = LinearExpressionProto

class LinearArgumentProto(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TARGET_FIELD_NUMBER: builtins.int
    EXPRS_FIELD_NUMBER: builtins.int
    @property
    def target(self) -> global___LinearExpressionProto: ...
    @property
    def exprs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LinearExpressionProto]: ...
    def __init__(self,
        *,
        target : typing.Optional[global___LinearExpressionProto] = ...,
        exprs : typing.Optional[typing.Iterable[global___LinearExpressionProto]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["target",b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["exprs",b"exprs","target",b"target"]) -> None: ...
global___LinearArgumentProto = LinearArgumentProto

class AllDifferentConstraintProto(google.protobuf.message.Message):
    """All variables must take different values."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VARS_FIELD_NUMBER: builtins.int
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vars",b"vars"]) -> None: ...
global___AllDifferentConstraintProto = AllDifferentConstraintProto

class LinearConstraintProto(google.protobuf.message.Message):
    """The linear sum vars[i] * coeffs[i] must fall in the given domain. The domain
    has the same format as the one in IntegerVariableProto.

    Note that the validation code currently checks using the domain of the
    involved variables that the sum can always be computed without integer
    overflow and throws an error otherwise.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VARS_FIELD_NUMBER: builtins.int
    COEFFS_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def coeffs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Same size as vars."""
        pass
    @property
    def domain(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        coeffs : typing.Optional[typing.Iterable[builtins.int]] = ...,
        domain : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["coeffs",b"coeffs","domain",b"domain","vars",b"vars"]) -> None: ...
global___LinearConstraintProto = LinearConstraintProto

class ElementConstraintProto(google.protobuf.message.Message):
    """The constraint target = vars[index].
    This enforces that index takes one of the value in [0, vars_size()).
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    INDEX_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    VARS_FIELD_NUMBER: builtins.int
    index: builtins.int = ...
    target: builtins.int = ...
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        index : builtins.int = ...,
        target : builtins.int = ...,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["index",b"index","target",b"target","vars",b"vars"]) -> None: ...
global___ElementConstraintProto = ElementConstraintProto

class IntervalConstraintProto(google.protobuf.message.Message):
    """This "special" constraint not only enforces (start + size == end) and (size
    >= 0) but can also be referred by other constraints using this "interval"
    concept.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    START_VIEW_FIELD_NUMBER: builtins.int
    END_VIEW_FIELD_NUMBER: builtins.int
    SIZE_VIEW_FIELD_NUMBER: builtins.int
    start: builtins.int = ...
    end: builtins.int = ...
    size: builtins.int = ...
    @property
    def start_view(self) -> global___LinearExpressionProto:
        """EXPERIMENTAL: This will become the new way to specify an interval.
        Depending on the parameters, the presolve will convert the old way to the
        new way. Do not forget to add an associated linear constraint if you use
        this directly.

        If any of this field is set, then all must be set and the ones above will
        be ignored.

        IMPORTANT: For now, this constraint do not enforce any relations on the
        view, and a linear constraint must be added together with this to enforce
        enforcement => start_view + size_view == end_view. An enforcement =>
        size_view >=0 might also be needed.

        IMPORTANT: For now, we just support affine relation. We could easily
        create an intermediate variable to support full linear expression, but this
        isn't done currently.
        """
        pass
    @property
    def end_view(self) -> global___LinearExpressionProto: ...
    @property
    def size_view(self) -> global___LinearExpressionProto: ...
    def __init__(self,
        *,
        start : builtins.int = ...,
        end : builtins.int = ...,
        size : builtins.int = ...,
        start_view : typing.Optional[global___LinearExpressionProto] = ...,
        end_view : typing.Optional[global___LinearExpressionProto] = ...,
        size_view : typing.Optional[global___LinearExpressionProto] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end_view",b"end_view","size_view",b"size_view","start_view",b"start_view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end",b"end","end_view",b"end_view","size",b"size","size_view",b"size_view","start",b"start","start_view",b"start_view"]) -> None: ...
global___IntervalConstraintProto = IntervalConstraintProto

class NoOverlapConstraintProto(google.protobuf.message.Message):
    """All the intervals (index of IntervalConstraintProto) must be disjoint. More
    formally, there must exist a sequence so that for each consecutive intervals,
    we have end_i <= start_{i+1}. In particular, intervals of size zero do matter
    for this constraint. This is also known as a disjunctive constraint in
    scheduling.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    INTERVALS_FIELD_NUMBER: builtins.int
    @property
    def intervals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        intervals : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["intervals",b"intervals"]) -> None: ...
global___NoOverlapConstraintProto = NoOverlapConstraintProto

class NoOverlap2DConstraintProto(google.protobuf.message.Message):
    """The boxes defined by [start_x, end_x) * [start_y, end_y) cannot overlap.
    Furthermore, one box is optional if at least one of the x or y interval is
    optional.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    X_INTERVALS_FIELD_NUMBER: builtins.int
    Y_INTERVALS_FIELD_NUMBER: builtins.int
    BOXES_WITH_NULL_AREA_CAN_OVERLAP_FIELD_NUMBER: builtins.int
    @property
    def x_intervals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def y_intervals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Same size as x_intervals."""
        pass
    boxes_with_null_area_can_overlap: builtins.bool = ...
    """TODO(user): Add optional areas as repeated LinearExpressionProto."""

    def __init__(self,
        *,
        x_intervals : typing.Optional[typing.Iterable[builtins.int]] = ...,
        y_intervals : typing.Optional[typing.Iterable[builtins.int]] = ...,
        boxes_with_null_area_can_overlap : builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["boxes_with_null_area_can_overlap",b"boxes_with_null_area_can_overlap","x_intervals",b"x_intervals","y_intervals",b"y_intervals"]) -> None: ...
global___NoOverlap2DConstraintProto = NoOverlap2DConstraintProto

class CumulativeConstraintProto(google.protobuf.message.Message):
    """The sum of the demands of the intervals at each interval point cannot exceed
    a capacity. Note that intervals are interpreted as [start, end) and as
    such intervals like [2,3) and [3,4) do not overlap for the point of view of
    this constraint. Moreover, intervals of size zero are ignored.

    TODO(user,user): Switch to linear expression for demands and capacity.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CAPACITY_FIELD_NUMBER: builtins.int
    INTERVALS_FIELD_NUMBER: builtins.int
    DEMANDS_FIELD_NUMBER: builtins.int
    ENERGIES_FIELD_NUMBER: builtins.int
    capacity: builtins.int = ...
    @property
    def intervals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def demands(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Same size as intervals."""
        pass
    @property
    def energies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LinearExpressionProto]:
        """EXPERIMENTAL: This optional field adds a redundant and more precise
        representation of the energy of a task (instead of the traditional demand *
        duration. This is only used by the linear relaxation, and it is only useful
        if both demand and durations are variable, and if the additional linear
        equation if more precise than the linear relaxation (McCormick equation) of
        the product demand * duration.
        """
        pass
    def __init__(self,
        *,
        capacity : builtins.int = ...,
        intervals : typing.Optional[typing.Iterable[builtins.int]] = ...,
        demands : typing.Optional[typing.Iterable[builtins.int]] = ...,
        energies : typing.Optional[typing.Iterable[global___LinearExpressionProto]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["capacity",b"capacity","demands",b"demands","energies",b"energies","intervals",b"intervals"]) -> None: ...
global___CumulativeConstraintProto = CumulativeConstraintProto

class ReservoirConstraintProto(google.protobuf.message.Message):
    """Maintain a reservoir level within bounds. The water level starts at 0, and at
    any time, it must be within [min_level, max_level].

    If the variable actives[i] is true, and if the variable times[i] is assigned
    a value t, then the current level changes by demands[i] (which is constant)
    at the time t. Therefore, at any time t:
         sum(demands[i] * actives[i] if times[i] <= t) in [min_level, max_level]

    Note that min level must be <= 0, and the max level must be >= 0. Please use
    fixed demands to simulate initial state.

    The array of boolean variables 'actives', if defined, indicates which actions
    are actually performed. If this array is not defined, then it is assumed that
    all actions will be performed.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MIN_LEVEL_FIELD_NUMBER: builtins.int
    MAX_LEVEL_FIELD_NUMBER: builtins.int
    TIMES_FIELD_NUMBER: builtins.int
    DEMANDS_FIELD_NUMBER: builtins.int
    ACTIVES_FIELD_NUMBER: builtins.int
    min_level: builtins.int = ...
    max_level: builtins.int = ...
    @property
    def times(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """variables."""
        pass
    @property
    def demands(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """constants, can be negative."""
        pass
    @property
    def actives(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """literals."""
        pass
    def __init__(self,
        *,
        min_level : builtins.int = ...,
        max_level : builtins.int = ...,
        times : typing.Optional[typing.Iterable[builtins.int]] = ...,
        demands : typing.Optional[typing.Iterable[builtins.int]] = ...,
        actives : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["actives",b"actives","demands",b"demands","max_level",b"max_level","min_level",b"min_level","times",b"times"]) -> None: ...
global___ReservoirConstraintProto = ReservoirConstraintProto

class CircuitConstraintProto(google.protobuf.message.Message):
    """The circuit constraint is defined on a graph where the arc presence are
    controlled by literals. Each arc is given by an index in the
    tails/heads/literals lists that must have the same size.

    For now, we ignore node indices with no incident arc. All the other nodes
    must have exactly one incoming and one outgoing selected arc (i.e. literal at
    true). All the selected arcs that are not self-loops must form a single
    circuit. Note that multi-arcs are allowed, but only one of them will be true
    at the same time. Multi-self loop are disallowed though.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TAILS_FIELD_NUMBER: builtins.int
    HEADS_FIELD_NUMBER: builtins.int
    LITERALS_FIELD_NUMBER: builtins.int
    @property
    def tails(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def heads(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def literals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        tails : typing.Optional[typing.Iterable[builtins.int]] = ...,
        heads : typing.Optional[typing.Iterable[builtins.int]] = ...,
        literals : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["heads",b"heads","literals",b"literals","tails",b"tails"]) -> None: ...
global___CircuitConstraintProto = CircuitConstraintProto

class RoutesConstraintProto(google.protobuf.message.Message):
    """The "VRP" (Vehicle Routing Problem) constraint.

    The direct graph where arc #i (from tails[i] to head[i]) is present iff
    literals[i] is true must satisfy this set of properties:
    - #incoming arcs == 1 except for node 0.
    - #outgoing arcs == 1 except for node 0.
    - for node zero, #incoming arcs == #outgoing arcs.
    - There are no duplicate arcs.
    - Self-arcs are allowed except for node 0.
    - There is no cycle in this graph, except through node 0.

    Note: Currently this constraint expect all the nodes in [0, num_nodes) to
    have at least one incident arc. The model will be considered invalid if it
    is not the case. You can add self-arc fixed to one to ignore some nodes if
    needed.

    TODO(user): It is probably possible to generalize this constraint to a
    no-cycle in a general graph, or a no-cycle with sum incoming <= 1 and sum
    outgoing <= 1 (more efficient implementation). On the other hand, having this
    specific constraint allow us to add specific "cuts" to a VRP problem.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TAILS_FIELD_NUMBER: builtins.int
    HEADS_FIELD_NUMBER: builtins.int
    LITERALS_FIELD_NUMBER: builtins.int
    DEMANDS_FIELD_NUMBER: builtins.int
    CAPACITY_FIELD_NUMBER: builtins.int
    @property
    def tails(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def heads(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def literals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def demands(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """EXPERIMENTAL. The demands for each node, and the maximum capacity for each
        route. Note that this is currently only used for the LP relaxation and one
        need to add the corresponding constraint to enforce this outside of the LP.

        TODO(user): Ideally, we should be able to extract any dimension like these
        (i.e. capacity, route_length, etc..) automatically from the encoding. The
        classical way to encode that is to have "current_capacity" variables along
        the route and linear equations of the form:
          arc_literal => (current_capacity_tail + demand <= current_capacity_head)
        """
        pass
    capacity: builtins.int = ...
    def __init__(self,
        *,
        tails : typing.Optional[typing.Iterable[builtins.int]] = ...,
        heads : typing.Optional[typing.Iterable[builtins.int]] = ...,
        literals : typing.Optional[typing.Iterable[builtins.int]] = ...,
        demands : typing.Optional[typing.Iterable[builtins.int]] = ...,
        capacity : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["capacity",b"capacity","demands",b"demands","heads",b"heads","literals",b"literals","tails",b"tails"]) -> None: ...
global___RoutesConstraintProto = RoutesConstraintProto

class TableConstraintProto(google.protobuf.message.Message):
    """The values of the n-tuple formed by the given variables can only be one of
    the listed n-tuples in values. The n-tuples are encoded in a flattened way:
        [tuple0_v0, tuple0_v1, ..., tuple0_v{n-1}, tuple1_v0, ...].
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VARS_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    NEGATED_FIELD_NUMBER: builtins.int
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    negated: builtins.bool = ...
    """If true, the meaning is "negated", that is we forbid any of the given
    tuple from a feasible assignment.
    """

    def __init__(self,
        *,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        values : typing.Optional[typing.Iterable[builtins.int]] = ...,
        negated : builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["negated",b"negated","values",b"values","vars",b"vars"]) -> None: ...
global___TableConstraintProto = TableConstraintProto

class InverseConstraintProto(google.protobuf.message.Message):
    """The two arrays of variable each represent a function, the second is the
    inverse of the first: f_direct[i] == j <=> f_inverse[j] == i.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    F_DIRECT_FIELD_NUMBER: builtins.int
    F_INVERSE_FIELD_NUMBER: builtins.int
    @property
    def f_direct(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def f_inverse(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        f_direct : typing.Optional[typing.Iterable[builtins.int]] = ...,
        f_inverse : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["f_direct",b"f_direct","f_inverse",b"f_inverse"]) -> None: ...
global___InverseConstraintProto = InverseConstraintProto

class AutomatonConstraintProto(google.protobuf.message.Message):
    """This constraint forces a sequence of variables to be accepted by an
    automaton.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    STARTING_STATE_FIELD_NUMBER: builtins.int
    FINAL_STATES_FIELD_NUMBER: builtins.int
    TRANSITION_TAIL_FIELD_NUMBER: builtins.int
    TRANSITION_HEAD_FIELD_NUMBER: builtins.int
    TRANSITION_LABEL_FIELD_NUMBER: builtins.int
    VARS_FIELD_NUMBER: builtins.int
    starting_state: builtins.int = ...
    """A state is identified by a non-negative number. It is preferable to keep
    all the states dense in says [0, num_states). The automaton starts at
    starting_state and must finish in any of the final states.
    """

    @property
    def final_states(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def transition_tail(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """List of transitions (all 3 vectors have the same size). Both tail and head
        are states, label is any variable value. No two outgoing transitions from
        the same state can have the same label.
        """
        pass
    @property
    def transition_head(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def transition_label(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The sequence of variables. The automaton is ran for vars_size() "steps" and
        the value of vars[i] corresponds to the transition label at step i.
        """
        pass
    def __init__(self,
        *,
        starting_state : builtins.int = ...,
        final_states : typing.Optional[typing.Iterable[builtins.int]] = ...,
        transition_tail : typing.Optional[typing.Iterable[builtins.int]] = ...,
        transition_head : typing.Optional[typing.Iterable[builtins.int]] = ...,
        transition_label : typing.Optional[typing.Iterable[builtins.int]] = ...,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["final_states",b"final_states","starting_state",b"starting_state","transition_head",b"transition_head","transition_label",b"transition_label","transition_tail",b"transition_tail","vars",b"vars"]) -> None: ...
global___AutomatonConstraintProto = AutomatonConstraintProto

class ListOfVariablesProto(google.protobuf.message.Message):
    """A list of variables, without any semantics."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VARS_FIELD_NUMBER: builtins.int
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vars",b"vars"]) -> None: ...
global___ListOfVariablesProto = ListOfVariablesProto

class ConstraintProto(google.protobuf.message.Message):
    """Next id: 31"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    ENFORCEMENT_LITERAL_FIELD_NUMBER: builtins.int
    BOOL_OR_FIELD_NUMBER: builtins.int
    BOOL_AND_FIELD_NUMBER: builtins.int
    AT_MOST_ONE_FIELD_NUMBER: builtins.int
    EXACTLY_ONE_FIELD_NUMBER: builtins.int
    BOOL_XOR_FIELD_NUMBER: builtins.int
    INT_DIV_FIELD_NUMBER: builtins.int
    INT_MOD_FIELD_NUMBER: builtins.int
    INT_MAX_FIELD_NUMBER: builtins.int
    LIN_MAX_FIELD_NUMBER: builtins.int
    INT_MIN_FIELD_NUMBER: builtins.int
    LIN_MIN_FIELD_NUMBER: builtins.int
    INT_PROD_FIELD_NUMBER: builtins.int
    LINEAR_FIELD_NUMBER: builtins.int
    ALL_DIFF_FIELD_NUMBER: builtins.int
    ELEMENT_FIELD_NUMBER: builtins.int
    CIRCUIT_FIELD_NUMBER: builtins.int
    ROUTES_FIELD_NUMBER: builtins.int
    TABLE_FIELD_NUMBER: builtins.int
    AUTOMATON_FIELD_NUMBER: builtins.int
    INVERSE_FIELD_NUMBER: builtins.int
    RESERVOIR_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    NO_OVERLAP_FIELD_NUMBER: builtins.int
    NO_OVERLAP_2D_FIELD_NUMBER: builtins.int
    CUMULATIVE_FIELD_NUMBER: builtins.int
    DUMMY_CONSTRAINT_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """For debug/logging only. Can be empty."""

    @property
    def enforcement_literal(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The constraint will be enforced iff all literals listed here are true. If
        this is empty, then the constraint will always be enforced. An enforced
        constraint must be satisfied, and an un-enforced one will simply be
        ignored.

        This is also called half-reification. To have an equivalence between a
        literal and a constraint (full reification), one must add both a constraint
        (controlled by a literal l) and its negation (controlled by the negation of
        l).

        Important: as of September 2018, only a few constraint support enforcement:
        - bool_or, bool_and, linear: fully supported.
        - interval: only support a single enforcement literal.
        - other: no support (but can be added on a per-demand basis).
        """
        pass
    @property
    def bool_or(self) -> global___BoolArgumentProto:
        """The bool_or constraint forces at least one literal to be true."""
        pass
    @property
    def bool_and(self) -> global___BoolArgumentProto:
        """The bool_and constraint forces all of the literals to be true.

        This is a "redundant" constraint in the sense that this can easily be
        encoded with many bool_or or at_most_one. It is just more space efficient
        and handled slightly differently internally.
        """
        pass
    @property
    def at_most_one(self) -> global___BoolArgumentProto:
        """The at_most_one constraint enforces that no more than one literal is
        true at the same time.

        Note that an at most one constraint of length n could be encoded with n
        bool_and constraint with n-1 term on the right hand side. So in a sense,
        this constraint contribute directly to the "implication-graph" or the
        2-SAT part of the model.

        This constraint does not support enforcement_literal. Just use a linear
        constraint if you need to enforce it. You also do not need to use it
        directly, we will extract it from the model in most situations.
        """
        pass
    @property
    def exactly_one(self) -> global___BoolArgumentProto:
        """The exactly_one constraint force exactly one literal to true and no more.

        Anytime a bool_or (it could have been called at_least_one) is included
        into an at_most_one, then the bool_or is actually an exactly one
        constraint, and the extra literal in the at_most_one can be set to false.
        So in this sense, this constraint is not really needed. it is just here
        for a better description of the problem structure and to facilitate some
        algorithm.

        This constraint does not support enforcement_literal. Just use a linear
        constraint if you need to enforce it. You also do not need to use it
        directly, we will extract it from the model in most situations.
        """
        pass
    @property
    def bool_xor(self) -> global___BoolArgumentProto:
        """The bool_xor constraint forces an odd number of the literals to be true."""
        pass
    @property
    def int_div(self) -> global___IntegerArgumentProto:
        """The int_div constraint forces the target to equal vars[0] / vars[1].
        In particular, vars[1] can never take the value 0. Also, as for now, we
        do not support vars[1] spanning across 0.
        """
        pass
    @property
    def int_mod(self) -> global___IntegerArgumentProto:
        """The int_mod constraint forces the target to equal vars[0] % vars[1].
        The domain of vars[1] must be strictly positive. The sign of the target
        is the same as the sign of vars[0].
        """
        pass
    @property
    def int_max(self) -> global___IntegerArgumentProto:
        """The int_max constraint forces the target to equal the maximum of all
        variables.

        The lin_max constraint forces the target to equal the maximum of all
        linear expressions.

        TODO(user): Remove int_max in favor of lin_max.
        """
        pass
    @property
    def lin_max(self) -> global___LinearArgumentProto: ...
    @property
    def int_min(self) -> global___IntegerArgumentProto:
        """The int_min constraint forces the target to equal the minimum of all
        variables.

        The lin_min constraint forces the target to equal the minimum of all
        linear expressions.

        TODO(user): Remove int_min in favor of lin_min.
        """
        pass
    @property
    def lin_min(self) -> global___LinearArgumentProto: ...
    @property
    def int_prod(self) -> global___IntegerArgumentProto:
        """The int_prod constraint forces the target to equal the product of all
        variables. By convention, because we can just remove term equal to one,
        the empty product forces the target to be one.

        Note that the solver checks for potential integer overflow. So it is
        recommended to limit the domain of the variables such that the product
        fits in [INT_MIN + 1..INT_MAX - 1].

        TODO(user): Support more than two terms in the product.
        """
        pass
    @property
    def linear(self) -> global___LinearConstraintProto:
        """The linear constraint enforces a linear inequality among the variables,
        such as 0 <= x + 2y <= 10.
        """
        pass
    @property
    def all_diff(self) -> global___AllDifferentConstraintProto:
        """The all_diff constraint forces all variables to take different values."""
        pass
    @property
    def element(self) -> global___ElementConstraintProto:
        """The element constraint forces the variable with the given index
        to be equal to the target.
        """
        pass
    @property
    def circuit(self) -> global___CircuitConstraintProto:
        """The circuit constraint takes a graph and forces the arcs present
        (with arc presence indicated by a literal) to form a unique cycle.
        """
        pass
    @property
    def routes(self) -> global___RoutesConstraintProto:
        """The routes constraint implements the vehicle routing problem."""
        pass
    @property
    def table(self) -> global___TableConstraintProto:
        """The table constraint enforces what values a tuple of variables may
        take.
        """
        pass
    @property
    def automaton(self) -> global___AutomatonConstraintProto:
        """The automaton constraint forces a sequence of variables to be accepted
        by an automaton.
        """
        pass
    @property
    def inverse(self) -> global___InverseConstraintProto:
        """The inverse constraint forces two arrays to be inverses of each other:
        the values of one are the indices of the other, and vice versa.
        """
        pass
    @property
    def reservoir(self) -> global___ReservoirConstraintProto:
        """The reservoir constraint forces the sum of a set of active demands
        to always be between a specified minimum and maximum value during
        specific times.
        """
        pass
    @property
    def interval(self) -> global___IntervalConstraintProto:
        """Constraints on intervals.

        The first constraint defines what an "interval" is and the other
        constraints use references to it. All the intervals that have an
        enforcement_literal set to false are ignored by these constraints.

        TODO(user): Explain what happen for intervals of size zero. Some
        constraints ignore them; others do take them into account.

        The interval constraint takes a start, end, and size, and forces
        start + size == end.
        """
        pass
    @property
    def no_overlap(self) -> global___NoOverlapConstraintProto:
        """The no_overlap constraint prevents a set of intervals from
        overlapping; in scheduling, this is called a disjunctive
        constraint.
        """
        pass
    @property
    def no_overlap_2d(self) -> global___NoOverlap2DConstraintProto:
        """The no_overlap_2d constraint prevents a set of boxes from overlapping."""
        pass
    @property
    def cumulative(self) -> global___CumulativeConstraintProto:
        """The cumulative constraint ensures that for any integer point, the sum
        of the demands of the intervals containing that point does not exceed
        the capacity.
        """
        pass
    @property
    def dummy_constraint(self) -> global___ListOfVariablesProto:
        """This constraint is not meant to be used and will be rejected by the
        solver. It is meant to mark variable when testing the presolve code.
        """
        pass
    def __init__(self,
        *,
        name : typing.Text = ...,
        enforcement_literal : typing.Optional[typing.Iterable[builtins.int]] = ...,
        bool_or : typing.Optional[global___BoolArgumentProto] = ...,
        bool_and : typing.Optional[global___BoolArgumentProto] = ...,
        at_most_one : typing.Optional[global___BoolArgumentProto] = ...,
        exactly_one : typing.Optional[global___BoolArgumentProto] = ...,
        bool_xor : typing.Optional[global___BoolArgumentProto] = ...,
        int_div : typing.Optional[global___IntegerArgumentProto] = ...,
        int_mod : typing.Optional[global___IntegerArgumentProto] = ...,
        int_max : typing.Optional[global___IntegerArgumentProto] = ...,
        lin_max : typing.Optional[global___LinearArgumentProto] = ...,
        int_min : typing.Optional[global___IntegerArgumentProto] = ...,
        lin_min : typing.Optional[global___LinearArgumentProto] = ...,
        int_prod : typing.Optional[global___IntegerArgumentProto] = ...,
        linear : typing.Optional[global___LinearConstraintProto] = ...,
        all_diff : typing.Optional[global___AllDifferentConstraintProto] = ...,
        element : typing.Optional[global___ElementConstraintProto] = ...,
        circuit : typing.Optional[global___CircuitConstraintProto] = ...,
        routes : typing.Optional[global___RoutesConstraintProto] = ...,
        table : typing.Optional[global___TableConstraintProto] = ...,
        automaton : typing.Optional[global___AutomatonConstraintProto] = ...,
        inverse : typing.Optional[global___InverseConstraintProto] = ...,
        reservoir : typing.Optional[global___ReservoirConstraintProto] = ...,
        interval : typing.Optional[global___IntervalConstraintProto] = ...,
        no_overlap : typing.Optional[global___NoOverlapConstraintProto] = ...,
        no_overlap_2d : typing.Optional[global___NoOverlap2DConstraintProto] = ...,
        cumulative : typing.Optional[global___CumulativeConstraintProto] = ...,
        dummy_constraint : typing.Optional[global___ListOfVariablesProto] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["all_diff",b"all_diff","at_most_one",b"at_most_one","automaton",b"automaton","bool_and",b"bool_and","bool_or",b"bool_or","bool_xor",b"bool_xor","circuit",b"circuit","constraint",b"constraint","cumulative",b"cumulative","dummy_constraint",b"dummy_constraint","element",b"element","exactly_one",b"exactly_one","int_div",b"int_div","int_max",b"int_max","int_min",b"int_min","int_mod",b"int_mod","int_prod",b"int_prod","interval",b"interval","inverse",b"inverse","lin_max",b"lin_max","lin_min",b"lin_min","linear",b"linear","no_overlap",b"no_overlap","no_overlap_2d",b"no_overlap_2d","reservoir",b"reservoir","routes",b"routes","table",b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["all_diff",b"all_diff","at_most_one",b"at_most_one","automaton",b"automaton","bool_and",b"bool_and","bool_or",b"bool_or","bool_xor",b"bool_xor","circuit",b"circuit","constraint",b"constraint","cumulative",b"cumulative","dummy_constraint",b"dummy_constraint","element",b"element","enforcement_literal",b"enforcement_literal","exactly_one",b"exactly_one","int_div",b"int_div","int_max",b"int_max","int_min",b"int_min","int_mod",b"int_mod","int_prod",b"int_prod","interval",b"interval","inverse",b"inverse","lin_max",b"lin_max","lin_min",b"lin_min","linear",b"linear","name",b"name","no_overlap",b"no_overlap","no_overlap_2d",b"no_overlap_2d","reservoir",b"reservoir","routes",b"routes","table",b"table"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["constraint",b"constraint"]) -> typing.Optional[typing_extensions.Literal["bool_or","bool_and","at_most_one","exactly_one","bool_xor","int_div","int_mod","int_max","lin_max","int_min","lin_min","int_prod","linear","all_diff","element","circuit","routes","table","automaton","inverse","reservoir","interval","no_overlap","no_overlap_2d","cumulative","dummy_constraint"]]: ...
global___ConstraintProto = ConstraintProto

class CpObjectiveProto(google.protobuf.message.Message):
    """Optimization objective.

    This is in a message because decision problems don't have any objective.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VARS_FIELD_NUMBER: builtins.int
    COEFFS_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    SCALING_FACTOR_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The linear terms of the objective to minimize.
        For a maximization problem, one can negate all coefficients in the
        objective and set a scaling_factor to -1.
        """
        pass
    @property
    def coeffs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    offset: builtins.float = ...
    """The displayed objective is always:
      scaling_factor * (sum(coefficients[i] * objective_vars[i]) + offset).
    This is needed to have a consistent objective after presolve or when
    scaling a double problem to express it with integers.

    Note that if scaling_factor is zero, then it is assumed to be 1, so that by
    default these fields have no effect.
    """

    scaling_factor: builtins.float = ...
    @property
    def domain(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """If non-empty, only look for an objective value in the given domain.
        Note that this does not depend on the offset or scaling factor, it is a
        domain on the sum of the objective terms only.
        """
        pass
    def __init__(self,
        *,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        coeffs : typing.Optional[typing.Iterable[builtins.int]] = ...,
        offset : builtins.float = ...,
        scaling_factor : builtins.float = ...,
        domain : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["coeffs",b"coeffs","domain",b"domain","offset",b"offset","scaling_factor",b"scaling_factor","vars",b"vars"]) -> None: ...
global___CpObjectiveProto = CpObjectiveProto

class DecisionStrategyProto(google.protobuf.message.Message):
    """Define the strategy to follow when the solver needs to take a new decision.
    Note that this strategy is only defined on a subset of variables.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class VariableSelectionStrategy(_VariableSelectionStrategy, metaclass=_VariableSelectionStrategyEnumTypeWrapper):
        """The order in which the variables above should be considered. Note that only
        variables that are not already fixed are considered.

        TODO(user): extend as needed.
        """
        pass
    class _VariableSelectionStrategy:
        V = typing.NewType('V', builtins.int)
    class _VariableSelectionStrategyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_VariableSelectionStrategy.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        CHOOSE_FIRST = DecisionStrategyProto.VariableSelectionStrategy.V(0)
        CHOOSE_LOWEST_MIN = DecisionStrategyProto.VariableSelectionStrategy.V(1)
        CHOOSE_HIGHEST_MAX = DecisionStrategyProto.VariableSelectionStrategy.V(2)
        CHOOSE_MIN_DOMAIN_SIZE = DecisionStrategyProto.VariableSelectionStrategy.V(3)
        CHOOSE_MAX_DOMAIN_SIZE = DecisionStrategyProto.VariableSelectionStrategy.V(4)

    CHOOSE_FIRST = DecisionStrategyProto.VariableSelectionStrategy.V(0)
    CHOOSE_LOWEST_MIN = DecisionStrategyProto.VariableSelectionStrategy.V(1)
    CHOOSE_HIGHEST_MAX = DecisionStrategyProto.VariableSelectionStrategy.V(2)
    CHOOSE_MIN_DOMAIN_SIZE = DecisionStrategyProto.VariableSelectionStrategy.V(3)
    CHOOSE_MAX_DOMAIN_SIZE = DecisionStrategyProto.VariableSelectionStrategy.V(4)

    class DomainReductionStrategy(_DomainReductionStrategy, metaclass=_DomainReductionStrategyEnumTypeWrapper):
        """Once a variable has been chosen, this enum describe what decision is taken
        on its domain.

        TODO(user): extend as needed.
        """
        pass
    class _DomainReductionStrategy:
        V = typing.NewType('V', builtins.int)
    class _DomainReductionStrategyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DomainReductionStrategy.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        SELECT_MIN_VALUE = DecisionStrategyProto.DomainReductionStrategy.V(0)
        SELECT_MAX_VALUE = DecisionStrategyProto.DomainReductionStrategy.V(1)
        SELECT_LOWER_HALF = DecisionStrategyProto.DomainReductionStrategy.V(2)
        SELECT_UPPER_HALF = DecisionStrategyProto.DomainReductionStrategy.V(3)
        SELECT_MEDIAN_VALUE = DecisionStrategyProto.DomainReductionStrategy.V(4)

    SELECT_MIN_VALUE = DecisionStrategyProto.DomainReductionStrategy.V(0)
    SELECT_MAX_VALUE = DecisionStrategyProto.DomainReductionStrategy.V(1)
    SELECT_LOWER_HALF = DecisionStrategyProto.DomainReductionStrategy.V(2)
    SELECT_UPPER_HALF = DecisionStrategyProto.DomainReductionStrategy.V(3)
    SELECT_MEDIAN_VALUE = DecisionStrategyProto.DomainReductionStrategy.V(4)

    class AffineTransformation(google.protobuf.message.Message):
        """Advanced usage. Some of the variable listed above may have been transformed
        by the presolve so this is needed to properly follow the given selection
        strategy. Instead of using a value X for variables[index], we will use
        positive_coeff * X + offset instead.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        INDEX_FIELD_NUMBER: builtins.int
        OFFSET_FIELD_NUMBER: builtins.int
        POSITIVE_COEFF_FIELD_NUMBER: builtins.int
        index: builtins.int = ...
        offset: builtins.int = ...
        positive_coeff: builtins.int = ...
        def __init__(self,
            *,
            index : builtins.int = ...,
            offset : builtins.int = ...,
            positive_coeff : builtins.int = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["index",b"index","offset",b"offset","positive_coeff",b"positive_coeff"]) -> None: ...

    VARIABLES_FIELD_NUMBER: builtins.int
    VARIABLE_SELECTION_STRATEGY_FIELD_NUMBER: builtins.int
    DOMAIN_REDUCTION_STRATEGY_FIELD_NUMBER: builtins.int
    TRANSFORMATIONS_FIELD_NUMBER: builtins.int
    @property
    def variables(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The variables to be considered for the next decision. The order matter and
        is always used as a tie-breaker after the variable selection strategy
        criteria defined below.
        """
        pass
    variable_selection_strategy: global___DecisionStrategyProto.VariableSelectionStrategy.V = ...
    domain_reduction_strategy: global___DecisionStrategyProto.DomainReductionStrategy.V = ...
    @property
    def transformations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DecisionStrategyProto.AffineTransformation]: ...
    def __init__(self,
        *,
        variables : typing.Optional[typing.Iterable[builtins.int]] = ...,
        variable_selection_strategy : global___DecisionStrategyProto.VariableSelectionStrategy.V = ...,
        domain_reduction_strategy : global___DecisionStrategyProto.DomainReductionStrategy.V = ...,
        transformations : typing.Optional[typing.Iterable[global___DecisionStrategyProto.AffineTransformation]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["domain_reduction_strategy",b"domain_reduction_strategy","transformations",b"transformations","variable_selection_strategy",b"variable_selection_strategy","variables",b"variables"]) -> None: ...
global___DecisionStrategyProto = DecisionStrategyProto

class PartialVariableAssignment(google.protobuf.message.Message):
    """This message encodes a partial (or full) assignment of the variables of a
    CpModelProto. The variable indices should be unique and valid variable
    indices.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VARS_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    @property
    def vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        vars : typing.Optional[typing.Iterable[builtins.int]] = ...,
        values : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values",b"values","vars",b"vars"]) -> None: ...
global___PartialVariableAssignment = PartialVariableAssignment

class SparsePermutationProto(google.protobuf.message.Message):
    """A permutation of integers encoded as a list of cycles, hence the "sparse"
    format. The image of an element cycle[i] is cycle[(i + 1) % cycle_length].
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    SUPPORT_FIELD_NUMBER: builtins.int
    CYCLE_SIZES_FIELD_NUMBER: builtins.int
    @property
    def support(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Each cycle is listed one after the other in the support field.
        The size of each cycle is given (in order) in the cycle_sizes field.
        """
        pass
    @property
    def cycle_sizes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        support : typing.Optional[typing.Iterable[builtins.int]] = ...,
        cycle_sizes : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cycle_sizes",b"cycle_sizes","support",b"support"]) -> None: ...
global___SparsePermutationProto = SparsePermutationProto

class DenseMatrixProto(google.protobuf.message.Message):
    """A dense matrix of numbers encoded in a flat way, row by row.
    That is matrix[i][j] = entries[i * num_cols + j];
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NUM_ROWS_FIELD_NUMBER: builtins.int
    NUM_COLS_FIELD_NUMBER: builtins.int
    ENTRIES_FIELD_NUMBER: builtins.int
    num_rows: builtins.int = ...
    num_cols: builtins.int = ...
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        num_rows : builtins.int = ...,
        num_cols : builtins.int = ...,
        entries : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entries",b"entries","num_cols",b"num_cols","num_rows",b"num_rows"]) -> None: ...
global___DenseMatrixProto = DenseMatrixProto

class SymmetryProto(google.protobuf.message.Message):
    """EXPERIMENTAL. For now, this is meant to be used by the solver and not filled
    by clients.

    Hold symmetry information about the set of feasible solutions. If we permute
    the variable values of any feasible solution using one of the permutation
    described here, we should always get another feasible solution.

    We usually also enforce that the objective of the new solution is the same.

    The group of permutations encoded here is usually computed from the encoding
    of the model, so it is not meant to be a complete representation of the
    feasible solution symmetries, just a valid subgroup.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    PERMUTATIONS_FIELD_NUMBER: builtins.int
    ORBITOPES_FIELD_NUMBER: builtins.int
    @property
    def permutations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SparsePermutationProto]:
        """A list of variable indices permutations that leave the feasible space of
        solution invariant. Usually, we only encode a set of generators of the
        group.
        """
        pass
    @property
    def orbitopes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DenseMatrixProto]:
        """An orbitope is a special symmetry structure of the solution space. If the
        variable indices are arranged in a matrix (with no duplicates), then any
        permutation of the columns will be a valid permutation of the feasible
        space.

        This arise quite often. The typical example is a graph coloring problem
        where for each node i, you have j booleans to indicate its color. If the
        variables color_of_i_is_j are arranged in a matrix[i][j], then any columns
        permutations leave the problem invariant.
        """
        pass
    def __init__(self,
        *,
        permutations : typing.Optional[typing.Iterable[global___SparsePermutationProto]] = ...,
        orbitopes : typing.Optional[typing.Iterable[global___DenseMatrixProto]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["orbitopes",b"orbitopes","permutations",b"permutations"]) -> None: ...
global___SymmetryProto = SymmetryProto

class CpModelProto(google.protobuf.message.Message):
    """A constraint programming problem."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    CONSTRAINTS_FIELD_NUMBER: builtins.int
    OBJECTIVE_FIELD_NUMBER: builtins.int
    SEARCH_STRATEGY_FIELD_NUMBER: builtins.int
    SOLUTION_HINT_FIELD_NUMBER: builtins.int
    ASSUMPTIONS_FIELD_NUMBER: builtins.int
    SYMMETRY_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """For debug/logging only. Can be empty."""

    @property
    def variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IntegerVariableProto]:
        """The associated Protos should be referred by their index in these fields."""
        pass
    @property
    def constraints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConstraintProto]: ...
    @property
    def objective(self) -> global___CpObjectiveProto:
        """The objective to minimize. Can be empty for pure decision problems."""
        pass
    @property
    def search_strategy(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DecisionStrategyProto]:
        """Defines the strategy that the solver should follow when the
        search_branching parameter is set to FIXED_SEARCH. Note that this strategy
        is also used as a heuristic when we are not in fixed search.

        Advanced Usage: if not all variables appears and the parameter
        "instantiate_all_variables" is set to false, then the solver will not try
        to instantiate the variables that do not appear. Thus, at the end of the
        search, not all variables may be fixed and this is why we have the
        solution_lower_bounds and solution_upper_bounds fields in the
        CpSolverResponse.
        """
        pass
    @property
    def solution_hint(self) -> global___PartialVariableAssignment:
        """Solution hint.

        If a feasible or almost-feasible solution to the problem is already known,
        it may be helpful to pass it to the solver so that it can be used. The
        solver will try to use this information to create its initial feasible
        solution.

        Note that it may not always be faster to give a hint like this to the
        solver. There is also no guarantee that the solver will use this hint or
        try to return a solution "close" to this assignment in case of multiple
        optimal solutions.
        """
        pass
    @property
    def assumptions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """A list of literals. The model will be solved assuming all these literals
        are true. Compared to just fixing the domain of these literals, using this
        mechanism is slower but allows in case the model is INFEASIBLE to get a
        potentially small subset of them that can be used to explain the
        infeasibility.

        Think (IIS), except when you are only concerned by the provided
        assumptions. This is powerful as it allows to group a set of logicially
        related constraint under only one enforcement literal which can potentially
        give you a good and interpretable explanation for infeasiblity.

        Such infeasibility explanation will be available in the
        sufficient_assumptions_for_infeasibility response field.
        """
        pass
    @property
    def symmetry(self) -> global___SymmetryProto:
        """For now, this is not meant to be filled by a client writing a model, but
        by our preprocessing step.

        Information about the symmetries of the feasible solution space.
        These usually leaves the objective invariant.
        """
        pass
    def __init__(self,
        *,
        name : typing.Text = ...,
        variables : typing.Optional[typing.Iterable[global___IntegerVariableProto]] = ...,
        constraints : typing.Optional[typing.Iterable[global___ConstraintProto]] = ...,
        objective : typing.Optional[global___CpObjectiveProto] = ...,
        search_strategy : typing.Optional[typing.Iterable[global___DecisionStrategyProto]] = ...,
        solution_hint : typing.Optional[global___PartialVariableAssignment] = ...,
        assumptions : typing.Optional[typing.Iterable[builtins.int]] = ...,
        symmetry : typing.Optional[global___SymmetryProto] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["objective",b"objective","solution_hint",b"solution_hint","symmetry",b"symmetry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["assumptions",b"assumptions","constraints",b"constraints","name",b"name","objective",b"objective","search_strategy",b"search_strategy","solution_hint",b"solution_hint","symmetry",b"symmetry","variables",b"variables"]) -> None: ...
global___CpModelProto = CpModelProto

class CpSolverResponse(google.protobuf.message.Message):
    """The response returned by a solver trying to solve a CpModelProto.

    TODO(user): support returning multiple solutions. Look at the Stubby
    streaming API as we probably wants to get them as they are found.
    Next id: 27
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    STATUS_FIELD_NUMBER: builtins.int
    SOLUTION_FIELD_NUMBER: builtins.int
    OBJECTIVE_VALUE_FIELD_NUMBER: builtins.int
    BEST_OBJECTIVE_BOUND_FIELD_NUMBER: builtins.int
    SOLUTION_LOWER_BOUNDS_FIELD_NUMBER: builtins.int
    SOLUTION_UPPER_BOUNDS_FIELD_NUMBER: builtins.int
    TIGHTENED_VARIABLES_FIELD_NUMBER: builtins.int
    SUFFICIENT_ASSUMPTIONS_FOR_INFEASIBILITY_FIELD_NUMBER: builtins.int
    ALL_SOLUTIONS_WERE_FOUND_FIELD_NUMBER: builtins.int
    NUM_BOOLEANS_FIELD_NUMBER: builtins.int
    NUM_CONFLICTS_FIELD_NUMBER: builtins.int
    NUM_BRANCHES_FIELD_NUMBER: builtins.int
    NUM_BINARY_PROPAGATIONS_FIELD_NUMBER: builtins.int
    NUM_INTEGER_PROPAGATIONS_FIELD_NUMBER: builtins.int
    NUM_RESTARTS_FIELD_NUMBER: builtins.int
    NUM_LP_ITERATIONS_FIELD_NUMBER: builtins.int
    WALL_TIME_FIELD_NUMBER: builtins.int
    USER_TIME_FIELD_NUMBER: builtins.int
    DETERMINISTIC_TIME_FIELD_NUMBER: builtins.int
    PRIMAL_INTEGRAL_FIELD_NUMBER: builtins.int
    SOLUTION_INFO_FIELD_NUMBER: builtins.int
    SOLVE_LOG_FIELD_NUMBER: builtins.int
    status: global___CpSolverStatus.V = ...
    """The status of the solve."""

    @property
    def solution(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """A feasible solution to the given problem. Depending on the returned status
        it may be optimal or just feasible. This is in one-to-one correspondence
        with a CpModelProto::variables repeated field and list the values of all
        the variables.
        """
        pass
    objective_value: builtins.float = ...
    """Only make sense for an optimization problem. The objective value of the
    returned solution if it is non-empty. If there is no solution, then for a
    minimization problem, this will be an upper-bound of the objective of any
    feasible solution, and a lower-bound for a maximization problem.
    """

    best_objective_bound: builtins.float = ...
    """Only make sense for an optimization problem. A proven lower-bound on the
    objective for a minimization problem, or a proven upper-bound for a
    maximization problem.
    """

    @property
    def solution_lower_bounds(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Advanced usage.

        If the problem has some variables that are not fixed at the end of the
        search (because of a particular search strategy in the CpModelProto) then
        this will be used instead of filling the solution above. The two fields
        will then contains the lower and upper bounds of each variable as they were
        when the best "solution" was found.
        """
        pass
    @property
    def solution_upper_bounds(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def tightened_variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IntegerVariableProto]:
        """Advanced usage.

        If the option fill_tightened_domains_in_response is set, then this field
        will be a copy of the CpModelProto.variables where each domain has been
        reduced using the information the solver was able to derive. Note that this
        is only filled with the info derived during a normal search and we do not
        have any dedicated algorithm to improve it.

        If the problem is a feasibility problem, then these bounds will be valid
        for any feasible solution. If the problem is an optimization problem, then
        these bounds will only be valid for any OPTIMAL solutions, it can exclude
        sub-optimal feasible ones.
        """
        pass
    @property
    def sufficient_assumptions_for_infeasibility(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """A subset of the model "assumptions" field. This will only be filled if the
        status is INFEASIBLE. This subset of assumption will be enough to still get
        an infeasible problem.

        This is related to what is called the irreducible inconsistent subsystem or
        IIS. Except one is only concerned by the provided assumptions. There is
        also no guarantee that we return an irreducible (aka minimal subset).
        However, this is based on SAT explanation and there is a good chance it is
        not too large.

        If you really want a minimal subset, a possible way to get one is by
        changing your model to minimize the number of assumptions at false, but
        this is likely an harder problem to solve.

        Important: Currently, this is minimized only in single-thread and if the
        problem is not an optimization problem, otherwise, it will always include
        all the assumptions.

        TODO(user): Allows for returning multiple core at once.
        """
        pass
    all_solutions_were_found: builtins.bool = ...
    """This will be true iff the solver was asked to find all solutions to a
    satisfiability problem (or all optimal solutions to an optimization
    problem), and it was successful in doing so.

    TODO(user): Remove as we also use the OPTIMAL vs FEASIBLE status for that.
    """

    num_booleans: builtins.int = ...
    """Some statistics about the solve."""

    num_conflicts: builtins.int = ...
    num_branches: builtins.int = ...
    num_binary_propagations: builtins.int = ...
    num_integer_propagations: builtins.int = ...
    num_restarts: builtins.int = ...
    num_lp_iterations: builtins.int = ...
    wall_time: builtins.float = ...
    user_time: builtins.float = ...
    deterministic_time: builtins.float = ...
    primal_integral: builtins.float = ...
    solution_info: typing.Text = ...
    """Additional information about how the solution was found."""

    solve_log: typing.Text = ...
    """The solve log will be filled if the parameter log_to_response is set to
    true.
    """

    def __init__(self,
        *,
        status : global___CpSolverStatus.V = ...,
        solution : typing.Optional[typing.Iterable[builtins.int]] = ...,
        objective_value : builtins.float = ...,
        best_objective_bound : builtins.float = ...,
        solution_lower_bounds : typing.Optional[typing.Iterable[builtins.int]] = ...,
        solution_upper_bounds : typing.Optional[typing.Iterable[builtins.int]] = ...,
        tightened_variables : typing.Optional[typing.Iterable[global___IntegerVariableProto]] = ...,
        sufficient_assumptions_for_infeasibility : typing.Optional[typing.Iterable[builtins.int]] = ...,
        all_solutions_were_found : builtins.bool = ...,
        num_booleans : builtins.int = ...,
        num_conflicts : builtins.int = ...,
        num_branches : builtins.int = ...,
        num_binary_propagations : builtins.int = ...,
        num_integer_propagations : builtins.int = ...,
        num_restarts : builtins.int = ...,
        num_lp_iterations : builtins.int = ...,
        wall_time : builtins.float = ...,
        user_time : builtins.float = ...,
        deterministic_time : builtins.float = ...,
        primal_integral : builtins.float = ...,
        solution_info : typing.Text = ...,
        solve_log : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["all_solutions_were_found",b"all_solutions_were_found","best_objective_bound",b"best_objective_bound","deterministic_time",b"deterministic_time","num_binary_propagations",b"num_binary_propagations","num_booleans",b"num_booleans","num_branches",b"num_branches","num_conflicts",b"num_conflicts","num_integer_propagations",b"num_integer_propagations","num_lp_iterations",b"num_lp_iterations","num_restarts",b"num_restarts","objective_value",b"objective_value","primal_integral",b"primal_integral","solution",b"solution","solution_info",b"solution_info","solution_lower_bounds",b"solution_lower_bounds","solution_upper_bounds",b"solution_upper_bounds","solve_log",b"solve_log","status",b"status","sufficient_assumptions_for_infeasibility",b"sufficient_assumptions_for_infeasibility","tightened_variables",b"tightened_variables","user_time",b"user_time","wall_time",b"wall_time"]) -> None: ...
global___CpSolverResponse = CpSolverResponse
