"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import ortools.util.optional_boolean_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class MPSolverResponseStatus(_MPSolverResponseStatus, metaclass=_MPSolverResponseStatusEnumTypeWrapper):
    """Status returned by the solver. They follow a hierarchical nomenclature, to
    allow us to add more enum values in the future. Clients should use
    InCategory() to match these enums, with the following C++ pseudo-code:

    bool InCategory(MPSolverResponseStatus status, MPSolverResponseStatus cat) {
      if (cat == MPSOLVER_OPTIMAL) return status == MPSOLVER_OPTIMAL;
      while (status > cat) status >>= 4;
      return status == cat;
    }
    Normal responses -- the model was valid, and the solver ran.
    These statuses should be "somewhat" repeatable, modulo the fact that the
    solver's time limit makes it undeterministic, and could change a FEASIBLE
    model to an OPTIMAL and vice-versa (the others, except NOT_SOLVED, should
    normally be deterministic). Also, the solver libraries can be buggy.
    """
    pass
class _MPSolverResponseStatus:
    V = typing.NewType('V', builtins.int)
class _MPSolverResponseStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MPSolverResponseStatus.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    MPSOLVER_OPTIMAL = MPSolverResponseStatus.V(0)
    """The solver found the proven optimal solution. This is what should be
    returned in most cases.

    WARNING: for historical reason, the value is zero, which means that this
    value can't have any subcategories.
    """

    MPSOLVER_FEASIBLE = MPSolverResponseStatus.V(1)
    """The solver had enough time to find some solution that satisfies all
    constraints, but it did not prove optimality (which means it may or may
    not have reached the optimal).

    This can happen for large LP models (Linear Programming), and is a frequent
    response for time-limited MIPs (Mixed Integer Programming). In the MIP
    case, the difference between the solution 'objective_value' and
    'best_objective_bound' fields of the MPSolutionResponse will give an
    indication of how far this solution is from the optimal one.
    """

    MPSOLVER_INFEASIBLE = MPSolverResponseStatus.V(2)
    """The model does not have any solution, according to the solver (which
    "proved" it, with the caveat that numerical proofs aren't actual proofs),
    or based on trivial considerations (eg. a variable whose lower bound is
    strictly greater than its upper bound).
    """

    MPSOLVER_UNBOUNDED = MPSolverResponseStatus.V(3)
    """There exist solutions that make the magnitude of the objective value
    as large as wanted (i.e. -infinity (resp. +infinity) for a minimization
    (resp. maximization) problem.
    """

    MPSOLVER_ABNORMAL = MPSolverResponseStatus.V(4)
    """An error (most probably numerical) occurred.
    One likely cause for such errors is a large numerical range among variable
    coefficients (eg. 1e-16, 1e20), in which case one should try to shrink it.
    """

    MPSOLVER_NOT_SOLVED = MPSolverResponseStatus.V(6)
    """The solver did not have a chance to diagnose the model in one of the
    categories above.
    """

    MPSOLVER_MODEL_IS_VALID = MPSolverResponseStatus.V(97)
    """Like "NOT_SOLVED", but typically used by model validation functions
    returning a "model status", to enhance readability of the client code.
    """

    MPSOLVER_CANCELLED_BY_USER = MPSolverResponseStatus.V(98)
    """The solve was interrupted by the user, and the solver didn't have time to
    return a proper status.
    """

    MPSOLVER_UNKNOWN_STATUS = MPSolverResponseStatus.V(99)
    """Special value: the solver status could not be properly translated and is
    unknown.
    """

    MPSOLVER_MODEL_INVALID = MPSolverResponseStatus.V(5)
    """Model errors. These are always deterministic and repeatable.
    They should be accompanied with a string description of the error.
    """

    MPSOLVER_MODEL_INVALID_SOLUTION_HINT = MPSolverResponseStatus.V(84)
    """Something is wrong with the fields "solution_hint_var_index" and/or
    "solution_hint_var_value".
    """

    MPSOLVER_MODEL_INVALID_SOLVER_PARAMETERS = MPSolverResponseStatus.V(85)
    """Something is wrong with the solver_specific_parameters request field."""

    MPSOLVER_SOLVER_TYPE_UNAVAILABLE = MPSolverResponseStatus.V(7)
    """Implementation error: the requested solver implementation is not
    available (see MPModelRequest.solver_type).
    The linear solver binary was probably not linked with the required library,
    eg //ortools/linear_solver:linear_solver_scip for SCIP.
    """

    MPSOLVER_INCOMPATIBLE_OPTIONS = MPSolverResponseStatus.V(113)
    """Some of the selected options were incompatible, e.g. a cancellable solve
    was requested via SolverClient::SolveMipRemotely() with an underlying
    solver that doesn't support cancellation. status_str should contain a
    description of the issue.
    """


MPSOLVER_OPTIMAL = MPSolverResponseStatus.V(0)
"""The solver found the proven optimal solution. This is what should be
returned in most cases.

WARNING: for historical reason, the value is zero, which means that this
value can't have any subcategories.
"""

MPSOLVER_FEASIBLE = MPSolverResponseStatus.V(1)
"""The solver had enough time to find some solution that satisfies all
constraints, but it did not prove optimality (which means it may or may
not have reached the optimal).

This can happen for large LP models (Linear Programming), and is a frequent
response for time-limited MIPs (Mixed Integer Programming). In the MIP
case, the difference between the solution 'objective_value' and
'best_objective_bound' fields of the MPSolutionResponse will give an
indication of how far this solution is from the optimal one.
"""

MPSOLVER_INFEASIBLE = MPSolverResponseStatus.V(2)
"""The model does not have any solution, according to the solver (which
"proved" it, with the caveat that numerical proofs aren't actual proofs),
or based on trivial considerations (eg. a variable whose lower bound is
strictly greater than its upper bound).
"""

MPSOLVER_UNBOUNDED = MPSolverResponseStatus.V(3)
"""There exist solutions that make the magnitude of the objective value
as large as wanted (i.e. -infinity (resp. +infinity) for a minimization
(resp. maximization) problem.
"""

MPSOLVER_ABNORMAL = MPSolverResponseStatus.V(4)
"""An error (most probably numerical) occurred.
One likely cause for such errors is a large numerical range among variable
coefficients (eg. 1e-16, 1e20), in which case one should try to shrink it.
"""

MPSOLVER_NOT_SOLVED = MPSolverResponseStatus.V(6)
"""The solver did not have a chance to diagnose the model in one of the
categories above.
"""

MPSOLVER_MODEL_IS_VALID = MPSolverResponseStatus.V(97)
"""Like "NOT_SOLVED", but typically used by model validation functions
returning a "model status", to enhance readability of the client code.
"""

MPSOLVER_CANCELLED_BY_USER = MPSolverResponseStatus.V(98)
"""The solve was interrupted by the user, and the solver didn't have time to
return a proper status.
"""

MPSOLVER_UNKNOWN_STATUS = MPSolverResponseStatus.V(99)
"""Special value: the solver status could not be properly translated and is
unknown.
"""

MPSOLVER_MODEL_INVALID = MPSolverResponseStatus.V(5)
"""Model errors. These are always deterministic and repeatable.
They should be accompanied with a string description of the error.
"""

MPSOLVER_MODEL_INVALID_SOLUTION_HINT = MPSolverResponseStatus.V(84)
"""Something is wrong with the fields "solution_hint_var_index" and/or
"solution_hint_var_value".
"""

MPSOLVER_MODEL_INVALID_SOLVER_PARAMETERS = MPSolverResponseStatus.V(85)
"""Something is wrong with the solver_specific_parameters request field."""

MPSOLVER_SOLVER_TYPE_UNAVAILABLE = MPSolverResponseStatus.V(7)
"""Implementation error: the requested solver implementation is not
available (see MPModelRequest.solver_type).
The linear solver binary was probably not linked with the required library,
eg //ortools/linear_solver:linear_solver_scip for SCIP.
"""

MPSOLVER_INCOMPATIBLE_OPTIONS = MPSolverResponseStatus.V(113)
"""Some of the selected options were incompatible, e.g. a cancellable solve
was requested via SolverClient::SolveMipRemotely() with an underlying
solver that doesn't support cancellation. status_str should contain a
description of the issue.
"""

global___MPSolverResponseStatus = MPSolverResponseStatus


class MPVariableProto(google.protobuf.message.Message):
    """A variable is always constrained in the form:
       lower_bound <= x <= upper_bound
    where lower_bound and upper_bound:
    - Can form a singleton: x = constant = lower_bound = upper_bound.
    - Can form a finite interval: lower_bound <= x <= upper_bound. (x is boxed.)
    - Can form a semi-infinite interval.
        - lower_bound = -infinity: x <= upper_bound.
        - upper_bound = +infinity: x >= lower_bound.
    - Can form the infinite interval: lower_bound = -infinity and
      upper_bound = +infinity, x is free.
    MPVariableProto furthermore stores:
     - The coefficient of the variable in the objective.
     - Whether the variable is integer.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    LOWER_BOUND_FIELD_NUMBER: builtins.int
    UPPER_BOUND_FIELD_NUMBER: builtins.int
    OBJECTIVE_COEFFICIENT_FIELD_NUMBER: builtins.int
    IS_INTEGER_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    BRANCHING_PRIORITY_FIELD_NUMBER: builtins.int
    lower_bound: builtins.float = ...
    """lower_bound must be <= upper_bound."""

    upper_bound: builtins.float = ...
    objective_coefficient: builtins.float = ...
    """The coefficient of the variable in the objective. Must be finite."""

    is_integer: builtins.bool = ...
    """True if the variable is constrained to be integer.
    Ignored if MPModelProto::solver_type is *LINEAR_PROGRAMMING*.
    """

    name: typing.Text = ...
    """The name of the variable."""

    branching_priority: builtins.int = ...
    def __init__(self,
        *,
        lower_bound : typing.Optional[builtins.float] = ...,
        upper_bound : typing.Optional[builtins.float] = ...,
        objective_coefficient : typing.Optional[builtins.float] = ...,
        is_integer : typing.Optional[builtins.bool] = ...,
        name : typing.Optional[typing.Text] = ...,
        branching_priority : typing.Optional[builtins.int] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["branching_priority",b"branching_priority","is_integer",b"is_integer","lower_bound",b"lower_bound","name",b"name","objective_coefficient",b"objective_coefficient","upper_bound",b"upper_bound"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branching_priority",b"branching_priority","is_integer",b"is_integer","lower_bound",b"lower_bound","name",b"name","objective_coefficient",b"objective_coefficient","upper_bound",b"upper_bound"]) -> None: ...
global___MPVariableProto = MPVariableProto

class MPConstraintProto(google.protobuf.message.Message):
    """A linear constraint is always of the form:
    lower_bound <= sum of linear term elements <= upper_bound,
    where lower_bound and upper_bound:
    - Can form a singleton: lower_bound == upper_bound. The constraint is an
      equation.
    - Can form a finite interval [lower_bound, upper_bound]. The constraint is
      both lower- and upper-bounded, i.e. "boxed".
    - Can form a semi-infinite interval. lower_bound = -infinity: the constraint
      is upper-bounded. upper_bound = +infinity: the constraint is lower-bounded.
    - Can form the infinite interval: lower_bound = -infinity and
      upper_bound = +infinity. The constraint is free.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VAR_INDEX_FIELD_NUMBER: builtins.int
    COEFFICIENT_FIELD_NUMBER: builtins.int
    LOWER_BOUND_FIELD_NUMBER: builtins.int
    UPPER_BOUND_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    IS_LAZY_FIELD_NUMBER: builtins.int
    @property
    def var_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """var_index[i] is the variable index (w.r.t. to "variable" field of
        MPModelProto) of the i-th linear term involved in this constraint, and
        coefficient[i] is its coefficient. Only the terms with non-zero
        coefficients need to appear. var_index may not contain duplicates.
        """
        pass
    @property
    def coefficient(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Must be finite."""
        pass
    lower_bound: builtins.float = ...
    """lower_bound must be <= upper_bound."""

    upper_bound: builtins.float = ...
    name: typing.Text = ...
    """The name of the constraint."""

    is_lazy: builtins.bool = ...
    """[Advanced usage: do not use this if you don't know what you're doing.]
    A lazy constraint is handled differently by the core solving engine, but
    it does not change the result. It may or may not impact the performance.
    For more info see: http://tinyurl.com/lazy-constraints.
    """

    def __init__(self,
        *,
        var_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        coefficient : typing.Optional[typing.Iterable[builtins.float]] = ...,
        lower_bound : typing.Optional[builtins.float] = ...,
        upper_bound : typing.Optional[builtins.float] = ...,
        name : typing.Optional[typing.Text] = ...,
        is_lazy : typing.Optional[builtins.bool] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["is_lazy",b"is_lazy","lower_bound",b"lower_bound","name",b"name","upper_bound",b"upper_bound"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["coefficient",b"coefficient","is_lazy",b"is_lazy","lower_bound",b"lower_bound","name",b"name","upper_bound",b"upper_bound","var_index",b"var_index"]) -> None: ...
global___MPConstraintProto = MPConstraintProto

class MPGeneralConstraintProto(google.protobuf.message.Message):
    """General constraints. See each individual proto type for more information."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    INDICATOR_CONSTRAINT_FIELD_NUMBER: builtins.int
    SOS_CONSTRAINT_FIELD_NUMBER: builtins.int
    QUADRATIC_CONSTRAINT_FIELD_NUMBER: builtins.int
    ABS_CONSTRAINT_FIELD_NUMBER: builtins.int
    AND_CONSTRAINT_FIELD_NUMBER: builtins.int
    OR_CONSTRAINT_FIELD_NUMBER: builtins.int
    MIN_CONSTRAINT_FIELD_NUMBER: builtins.int
    MAX_CONSTRAINT_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """The name of the constraint."""

    @property
    def indicator_constraint(self) -> global___MPIndicatorConstraint: ...
    @property
    def sos_constraint(self) -> global___MPSosConstraint: ...
    @property
    def quadratic_constraint(self) -> global___MPQuadraticConstraint: ...
    @property
    def abs_constraint(self) -> global___MPAbsConstraint: ...
    @property
    def and_constraint(self) -> global___MPArrayConstraint:
        """All variables in "and" constraints must be Boolean.
        resultant_var = and(var_1, var_2... var_n)
        """
        pass
    @property
    def or_constraint(self) -> global___MPArrayConstraint:
        """All variables in "or" constraints must be Boolean.
        resultant_var = or(var_1, var_2... var_n)
        """
        pass
    @property
    def min_constraint(self) -> global___MPArrayWithConstantConstraint:
        """resultant_var = min(var_1, var_2, ..., constant)"""
        pass
    @property
    def max_constraint(self) -> global___MPArrayWithConstantConstraint:
        """resultant_var = max(var_1, var_2, ..., constant)"""
        pass
    def __init__(self,
        *,
        name : typing.Optional[typing.Text] = ...,
        indicator_constraint : typing.Optional[global___MPIndicatorConstraint] = ...,
        sos_constraint : typing.Optional[global___MPSosConstraint] = ...,
        quadratic_constraint : typing.Optional[global___MPQuadraticConstraint] = ...,
        abs_constraint : typing.Optional[global___MPAbsConstraint] = ...,
        and_constraint : typing.Optional[global___MPArrayConstraint] = ...,
        or_constraint : typing.Optional[global___MPArrayConstraint] = ...,
        min_constraint : typing.Optional[global___MPArrayWithConstantConstraint] = ...,
        max_constraint : typing.Optional[global___MPArrayWithConstantConstraint] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["abs_constraint",b"abs_constraint","and_constraint",b"and_constraint","general_constraint",b"general_constraint","indicator_constraint",b"indicator_constraint","max_constraint",b"max_constraint","min_constraint",b"min_constraint","name",b"name","or_constraint",b"or_constraint","quadratic_constraint",b"quadratic_constraint","sos_constraint",b"sos_constraint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["abs_constraint",b"abs_constraint","and_constraint",b"and_constraint","general_constraint",b"general_constraint","indicator_constraint",b"indicator_constraint","max_constraint",b"max_constraint","min_constraint",b"min_constraint","name",b"name","or_constraint",b"or_constraint","quadratic_constraint",b"quadratic_constraint","sos_constraint",b"sos_constraint"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["general_constraint",b"general_constraint"]) -> typing.Optional[typing_extensions.Literal["indicator_constraint","sos_constraint","quadratic_constraint","abs_constraint","and_constraint","or_constraint","min_constraint","max_constraint"]]: ...
global___MPGeneralConstraintProto = MPGeneralConstraintProto

class MPIndicatorConstraint(google.protobuf.message.Message):
    """Indicator constraints encode the activation or deactivation of linear
    constraints given the value of one Boolean variable in the model. For
    example:
        y = 0 => 2 * x1 + 3 * x2 >= 42
    The 2 * x1 + 3 * x2 >= 42 constraint is only active if the variable y is
    equal to 0.
    As of 2019/04, only SCIP, CP-SAT and Gurobi support this constraint type.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VAR_INDEX_FIELD_NUMBER: builtins.int
    VAR_VALUE_FIELD_NUMBER: builtins.int
    CONSTRAINT_FIELD_NUMBER: builtins.int
    var_index: builtins.int = ...
    """Variable index (w.r.t. the "variable" field of MPModelProto) of the Boolean
    variable used as indicator.
    """

    var_value: builtins.int = ...
    """Value the above variable should take. Must be 0 or 1."""

    @property
    def constraint(self) -> global___MPConstraintProto:
        """The constraint activated by the indicator variable."""
        pass
    def __init__(self,
        *,
        var_index : typing.Optional[builtins.int] = ...,
        var_value : typing.Optional[builtins.int] = ...,
        constraint : typing.Optional[global___MPConstraintProto] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["constraint",b"constraint","var_index",b"var_index","var_value",b"var_value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["constraint",b"constraint","var_index",b"var_index","var_value",b"var_value"]) -> None: ...
global___MPIndicatorConstraint = MPIndicatorConstraint

class MPSosConstraint(google.protobuf.message.Message):
    """Special Ordered Set (SOS) constraints of type 1 or 2.
    See https://en.wikipedia.org/wiki/Special_ordered_set
    As of 2019/04, only SCIP and Gurobi support this constraint type.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        pass
    class _Type:
        V = typing.NewType('V', builtins.int)
    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Type.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        SOS1_DEFAULT = MPSosConstraint.Type.V(0)
        """At most one variable in `var_index` must be non-zero."""

        SOS2 = MPSosConstraint.Type.V(1)
        """At most two consecutive variables from `var_index` can be non-zero (i.e.
        for some i, var_index[i] and var_index[i+1]). See
        https://en.wikipedia.org/wiki/Special_ordered_set#Types_of_SOS
        """


    SOS1_DEFAULT = MPSosConstraint.Type.V(0)
    """At most one variable in `var_index` must be non-zero."""

    SOS2 = MPSosConstraint.Type.V(1)
    """At most two consecutive variables from `var_index` can be non-zero (i.e.
    for some i, var_index[i] and var_index[i+1]). See
    https://en.wikipedia.org/wiki/Special_ordered_set#Types_of_SOS
    """


    TYPE_FIELD_NUMBER: builtins.int
    VAR_INDEX_FIELD_NUMBER: builtins.int
    WEIGHT_FIELD_NUMBER: builtins.int
    type: global___MPSosConstraint.Type.V = ...
    @property
    def var_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Variable index (w.r.t. the "variable" field of MPModelProto) of the
        variables in the SOS.
        """
        pass
    @property
    def weight(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Optional: SOS weights. If non-empty, must be of the same size as
        "var_index", and strictly increasing. If empty and required by the
        underlying solver, the 1..n sequence will be given as weights.
        SUBTLE: The weights can help the solver make branch-and-bound decisions
        that fit the underlying optimization model: after each LP relaxation, it
        will compute the "average weight" of the SOS variables, weighted by value
        (this is confusing: here we're using the values as weights), and the binary
        branch decision will be: is the non-zero variable above or below that?
        (weights are strictly monotonous, so the "cutoff" average weight
        corresponds to a "cutoff" index in the var_index sequence).
        """
        pass
    def __init__(self,
        *,
        type : typing.Optional[global___MPSosConstraint.Type.V] = ...,
        var_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        weight : typing.Optional[typing.Iterable[builtins.float]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type",b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["type",b"type","var_index",b"var_index","weight",b"weight"]) -> None: ...
global___MPSosConstraint = MPSosConstraint

class MPQuadraticConstraint(google.protobuf.message.Message):
    """Quadratic constraints of the form lb <= sum a_i x_i + sum b_ij x_i x_j <= ub,
    where a, b, lb and ub are constants, and x are the model's variables.
    Quadratic matrices that are Positive Semi-Definite, Second-Order Cones or
    rotated Second-Order Cones are always accepted. Other forms may or may not be
    accepted depending on the underlying solver used.
    See https://scip.zib.de/doc/html/cons__quadratic_8h.php and
    https://www.gurobi.com/documentation/9.0/refman/constraints.html#subsubsection:QuadraticConstraints
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VAR_INDEX_FIELD_NUMBER: builtins.int
    COEFFICIENT_FIELD_NUMBER: builtins.int
    QVAR1_INDEX_FIELD_NUMBER: builtins.int
    QVAR2_INDEX_FIELD_NUMBER: builtins.int
    QCOEFFICIENT_FIELD_NUMBER: builtins.int
    LOWER_BOUND_FIELD_NUMBER: builtins.int
    UPPER_BOUND_FIELD_NUMBER: builtins.int
    @property
    def var_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Sparse representation of linear terms in the quadratic constraint, where
        term i is var_index[i] * coefficient[i].
        `var_index` are variable indices w.r.t the "variable" field in
        MPModelProto, and should be unique.
        """
        pass
    @property
    def coefficient(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Must be finite."""
        pass
    @property
    def qvar1_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Sparse representation of quadratic terms in the quadratic constraint, where
        term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
        `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
        field in MPModelProto.
        `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
        If the same unordered pair (qvar1_index, qvar2_index) appears several
        times, the sum of all of the associated coefficients will be applied.
        """
        pass
    @property
    def qvar2_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def qcoefficient(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Must be finite."""
        pass
    lower_bound: builtins.float = ...
    """lower_bound must be <= upper_bound."""

    upper_bound: builtins.float = ...
    def __init__(self,
        *,
        var_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        coefficient : typing.Optional[typing.Iterable[builtins.float]] = ...,
        qvar1_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        qvar2_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        qcoefficient : typing.Optional[typing.Iterable[builtins.float]] = ...,
        lower_bound : typing.Optional[builtins.float] = ...,
        upper_bound : typing.Optional[builtins.float] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["lower_bound",b"lower_bound","upper_bound",b"upper_bound"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["coefficient",b"coefficient","lower_bound",b"lower_bound","qcoefficient",b"qcoefficient","qvar1_index",b"qvar1_index","qvar2_index",b"qvar2_index","upper_bound",b"upper_bound","var_index",b"var_index"]) -> None: ...
global___MPQuadraticConstraint = MPQuadraticConstraint

class MPAbsConstraint(google.protobuf.message.Message):
    """Sets a variable's value to the absolute value of another variable."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VAR_INDEX_FIELD_NUMBER: builtins.int
    RESULTANT_VAR_INDEX_FIELD_NUMBER: builtins.int
    var_index: builtins.int = ...
    """Variable indices are relative to the "variable" field in MPModelProto.
    resultant_var = abs(var)
    """

    resultant_var_index: builtins.int = ...
    def __init__(self,
        *,
        var_index : typing.Optional[builtins.int] = ...,
        resultant_var_index : typing.Optional[builtins.int] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resultant_var_index",b"resultant_var_index","var_index",b"var_index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["resultant_var_index",b"resultant_var_index","var_index",b"var_index"]) -> None: ...
global___MPAbsConstraint = MPAbsConstraint

class MPArrayConstraint(google.protobuf.message.Message):
    """Sets a variable's value equal to a function on a set of variables."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VAR_INDEX_FIELD_NUMBER: builtins.int
    RESULTANT_VAR_INDEX_FIELD_NUMBER: builtins.int
    @property
    def var_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Variable indices are relative to the "variable" field in MPModelProto."""
        pass
    resultant_var_index: builtins.int = ...
    def __init__(self,
        *,
        var_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        resultant_var_index : typing.Optional[builtins.int] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resultant_var_index",b"resultant_var_index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["resultant_var_index",b"resultant_var_index","var_index",b"var_index"]) -> None: ...
global___MPArrayConstraint = MPArrayConstraint

class MPArrayWithConstantConstraint(google.protobuf.message.Message):
    """Sets a variable's value equal to a function on a set of variables and,
    optionally, a constant.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VAR_INDEX_FIELD_NUMBER: builtins.int
    CONSTANT_FIELD_NUMBER: builtins.int
    RESULTANT_VAR_INDEX_FIELD_NUMBER: builtins.int
    @property
    def var_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Variable indices are relative to the "variable" field in MPModelProto.
        resultant_var = f(var_1, var_2, ..., constant)
        """
        pass
    constant: builtins.float = ...
    resultant_var_index: builtins.int = ...
    def __init__(self,
        *,
        var_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        constant : typing.Optional[builtins.float] = ...,
        resultant_var_index : typing.Optional[builtins.int] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["constant",b"constant","resultant_var_index",b"resultant_var_index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["constant",b"constant","resultant_var_index",b"resultant_var_index","var_index",b"var_index"]) -> None: ...
global___MPArrayWithConstantConstraint = MPArrayWithConstantConstraint

class MPQuadraticObjective(google.protobuf.message.Message):
    """Quadratic part of a model's objective. Added with other objectives (such as
    linear), this creates the model's objective function to be optimized.
    Note: the linear part of the objective currently needs to be specified in the
    MPVariableProto.objective_coefficient fields. If you'd rather have a
    dedicated linear array here, talk to or-core-team@
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    QVAR1_INDEX_FIELD_NUMBER: builtins.int
    QVAR2_INDEX_FIELD_NUMBER: builtins.int
    COEFFICIENT_FIELD_NUMBER: builtins.int
    @property
    def qvar1_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Sparse representation of quadratic terms in the objective function, where
        term i is qvar1_index[i] * qvar2_index[i] * coefficient[i].
        `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
        field in MPModelProto.
        `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
        If the same unordered pair (qvar1_index, qvar2_index) appears several
        times, the sum of all of the associated coefficients will be applied.
        """
        pass
    @property
    def qvar2_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def coefficient(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Must be finite."""
        pass
    def __init__(self,
        *,
        qvar1_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        qvar2_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        coefficient : typing.Optional[typing.Iterable[builtins.float]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["coefficient",b"coefficient","qvar1_index",b"qvar1_index","qvar2_index",b"qvar2_index"]) -> None: ...
global___MPQuadraticObjective = MPQuadraticObjective

class PartialVariableAssignment(google.protobuf.message.Message):
    """This message encodes a partial (or full) assignment of the variables of a
    MPModelProto problem. The indices in var_index should be unique and valid
    variable indices of the associated problem.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VAR_INDEX_FIELD_NUMBER: builtins.int
    VAR_VALUE_FIELD_NUMBER: builtins.int
    @property
    def var_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def var_value(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(self,
        *,
        var_index : typing.Optional[typing.Iterable[builtins.int]] = ...,
        var_value : typing.Optional[typing.Iterable[builtins.float]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["var_index",b"var_index","var_value",b"var_value"]) -> None: ...
global___PartialVariableAssignment = PartialVariableAssignment

class MPModelProto(google.protobuf.message.Message):
    """MPModelProto contains all the information for a Linear Programming model."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VARIABLE_FIELD_NUMBER: builtins.int
    CONSTRAINT_FIELD_NUMBER: builtins.int
    GENERAL_CONSTRAINT_FIELD_NUMBER: builtins.int
    MAXIMIZE_FIELD_NUMBER: builtins.int
    OBJECTIVE_OFFSET_FIELD_NUMBER: builtins.int
    QUADRATIC_OBJECTIVE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SOLUTION_HINT_FIELD_NUMBER: builtins.int
    @property
    def variable(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MPVariableProto]:
        """All the variables appearing in the model."""
        pass
    @property
    def constraint(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MPConstraintProto]:
        """All the constraints appearing in the model."""
        pass
    @property
    def general_constraint(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MPGeneralConstraintProto]:
        """All the general constraints appearing in the model. Note that not all
        solvers support all types of general constraints.
        """
        pass
    maximize: builtins.bool = ...
    """True if the problem is a maximization problem. Minimize by default."""

    objective_offset: builtins.float = ...
    """Offset for the objective function. Must be finite."""

    @property
    def quadratic_objective(self) -> global___MPQuadraticObjective:
        """Optionally, a quadratic objective.
        As of 2019/06, only SCIP and Gurobi support quadratic objectives.
        """
        pass
    name: typing.Text = ...
    """Name of the model."""

    @property
    def solution_hint(self) -> global___PartialVariableAssignment:
        """Solution hint.

        If a feasible or almost-feasible solution to the problem is already known,
        it may be helpful to pass it to the solver so that it can be used. A solver
        that supports this feature will try to use this information to create its
        initial feasible solution.

        Note that it may not always be faster to give a hint like this to the
        solver. There is also no guarantee that the solver will use this hint or
        try to return a solution "close" to this assignment in case of multiple
        optimal solutions.
        """
        pass
    def __init__(self,
        *,
        variable : typing.Optional[typing.Iterable[global___MPVariableProto]] = ...,
        constraint : typing.Optional[typing.Iterable[global___MPConstraintProto]] = ...,
        general_constraint : typing.Optional[typing.Iterable[global___MPGeneralConstraintProto]] = ...,
        maximize : typing.Optional[builtins.bool] = ...,
        objective_offset : typing.Optional[builtins.float] = ...,
        quadratic_objective : typing.Optional[global___MPQuadraticObjective] = ...,
        name : typing.Optional[typing.Text] = ...,
        solution_hint : typing.Optional[global___PartialVariableAssignment] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["maximize",b"maximize","name",b"name","objective_offset",b"objective_offset","quadratic_objective",b"quadratic_objective","solution_hint",b"solution_hint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["constraint",b"constraint","general_constraint",b"general_constraint","maximize",b"maximize","name",b"name","objective_offset",b"objective_offset","quadratic_objective",b"quadratic_objective","solution_hint",b"solution_hint","variable",b"variable"]) -> None: ...
global___MPModelProto = MPModelProto

class OptionalDouble(google.protobuf.message.Message):
    """To support 'unspecified' double value in proto3, the simplest is to wrap
    any double value in a nested message (has_XXX works for message fields).
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.float = ...
    def __init__(self,
        *,
        value : typing.Optional[builtins.float] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["value",b"value"]) -> None: ...
global___OptionalDouble = OptionalDouble

class MPSolverCommonParameters(google.protobuf.message.Message):
    """MPSolverCommonParameters holds advanced usage parameters that apply to any of
    the solvers we support.
    All of the fields in this proto can have a value of unspecified. In this
    case each inner solver will use their own safe defaults.
    Some values won't be supported by some solvers. The behavior in that case is
    not defined yet.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class LPAlgorithmValues(_LPAlgorithmValues, metaclass=_LPAlgorithmValuesEnumTypeWrapper):
        pass
    class _LPAlgorithmValues:
        V = typing.NewType('V', builtins.int)
    class _LPAlgorithmValuesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LPAlgorithmValues.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        LP_ALGO_UNSPECIFIED = MPSolverCommonParameters.LPAlgorithmValues.V(0)
        LP_ALGO_DUAL = MPSolverCommonParameters.LPAlgorithmValues.V(1)
        """Dual simplex."""

        LP_ALGO_PRIMAL = MPSolverCommonParameters.LPAlgorithmValues.V(2)
        """Primal simplex."""

        LP_ALGO_BARRIER = MPSolverCommonParameters.LPAlgorithmValues.V(3)
        """Barrier algorithm."""


    LP_ALGO_UNSPECIFIED = MPSolverCommonParameters.LPAlgorithmValues.V(0)
    LP_ALGO_DUAL = MPSolverCommonParameters.LPAlgorithmValues.V(1)
    """Dual simplex."""

    LP_ALGO_PRIMAL = MPSolverCommonParameters.LPAlgorithmValues.V(2)
    """Primal simplex."""

    LP_ALGO_BARRIER = MPSolverCommonParameters.LPAlgorithmValues.V(3)
    """Barrier algorithm."""


    RELATIVE_MIP_GAP_FIELD_NUMBER: builtins.int
    PRIMAL_TOLERANCE_FIELD_NUMBER: builtins.int
    DUAL_TOLERANCE_FIELD_NUMBER: builtins.int
    LP_ALGORITHM_FIELD_NUMBER: builtins.int
    PRESOLVE_FIELD_NUMBER: builtins.int
    SCALING_FIELD_NUMBER: builtins.int
    @property
    def relative_mip_gap(self) -> global___OptionalDouble:
        """The solver stops if the relative MIP gap reaches this value or below.
        The relative MIP gap is an upper bound of the relative distance to the
        optimum, and it is defined as:

          abs(best_bound - incumbent) / abs(incumbent) [Gurobi]
          abs(best_bound - incumbent) / min(abs(best_bound), abs(incumbent)) [SCIP]

        where "incumbent" is the objective value of the best solution found so far
        (i.e., lowest when minimizing, highest when maximizing), and "best_bound"
        is the tightest bound of the objective determined so far (i.e., highest
        when minimizing, and lowest when maximizing). The MIP Gap is sensitive to
        objective offset. If the denominator is 0 the MIP Gap is INFINITY for SCIP
        and Gurobi. Of note, "incumbent" and "best bound" are called "primal bound"
        and "dual bound" in SCIP, respectively.
        Ask or-core-team@ for other solvers.
        """
        pass
    @property
    def primal_tolerance(self) -> global___OptionalDouble:
        """Tolerance for primal feasibility of basic solutions: this is the maximum
        allowed error in constraint satisfiability.
        For SCIP this includes integrality constraints. For Gurobi it does not, you
        need to set the custom parameter IntFeasTol.
        """
        pass
    @property
    def dual_tolerance(self) -> global___OptionalDouble:
        """Tolerance for dual feasibility.
        For SCIP and Gurobi this is the feasibility tolerance for reduced costs in
        LP solution: reduced costs must all be smaller than this value in the
        improving direction in order for a model to be declared optimal.
        Not supported for other solvers.
        """
        pass
    lp_algorithm: global___MPSolverCommonParameters.LPAlgorithmValues.V = ...
    """Algorithm to solve linear programs.
    Ask or-core-team@ if you want to know what this does exactly.
    """

    presolve: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
    """Gurobi and SCIP enable presolve by default.
    Ask or-core-team@ for other solvers.
    """

    scaling: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
    """Enable automatic scaling of matrix coefficients and objective. Available
    for Gurobi and GLOP.
    Ask or-core-team@ if you want more details.
    """

    def __init__(self,
        *,
        relative_mip_gap : typing.Optional[global___OptionalDouble] = ...,
        primal_tolerance : typing.Optional[global___OptionalDouble] = ...,
        dual_tolerance : typing.Optional[global___OptionalDouble] = ...,
        lp_algorithm : typing.Optional[global___MPSolverCommonParameters.LPAlgorithmValues.V] = ...,
        presolve : typing.Optional[ortools.util.optional_boolean_pb2.OptionalBoolean.V] = ...,
        scaling : typing.Optional[ortools.util.optional_boolean_pb2.OptionalBoolean.V] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["dual_tolerance",b"dual_tolerance","lp_algorithm",b"lp_algorithm","presolve",b"presolve","primal_tolerance",b"primal_tolerance","relative_mip_gap",b"relative_mip_gap","scaling",b"scaling"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dual_tolerance",b"dual_tolerance","lp_algorithm",b"lp_algorithm","presolve",b"presolve","primal_tolerance",b"primal_tolerance","relative_mip_gap",b"relative_mip_gap","scaling",b"scaling"]) -> None: ...
global___MPSolverCommonParameters = MPSolverCommonParameters

class MPModelDeltaProto(google.protobuf.message.Message):
    """Encodes a full MPModelProto by way of referencing to a "baseline"
    MPModelProto stored in a file, and a "delta" to apply to this model.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class VariableOverridesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int = ...
        @property
        def value(self) -> global___MPVariableProto: ...
        def __init__(self,
            *,
            key : typing.Optional[builtins.int] = ...,
            value : typing.Optional[global___MPVariableProto] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class ConstraintOverridesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int = ...
        @property
        def value(self) -> global___MPConstraintProto: ...
        def __init__(self,
            *,
            key : typing.Optional[builtins.int] = ...,
            value : typing.Optional[global___MPConstraintProto] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    BASELINE_MODEL_FILE_PATH_FIELD_NUMBER: builtins.int
    VARIABLE_OVERRIDES_FIELD_NUMBER: builtins.int
    CONSTRAINT_OVERRIDES_FIELD_NUMBER: builtins.int
    baseline_model_file_path: typing.Text = ...
    @property
    def variable_overrides(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___MPVariableProto]:
        """The variable protos listed here will override (via MergeFrom()) the ones
        in the baseline model: you only need to specify the fields that change.
        To add a new variable, add it with a new variable index (variable indices
        still need to span a dense integer interval).
        You can't "delete" a variable but you can "neutralize" it by fixing its
        value, setting its objective coefficient to zero, and by nullifying all
        the terms involving it in the constraints.
        """
        pass
    @property
    def constraint_overrides(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___MPConstraintProto]:
        """Constraints can be changed (or added) in the same way as variables, see
        above. It's mostly like applying MergeFrom(), except that:
        - the "var_index" and "coefficient" fields will be overridden like a map:
          if a key pre-exists, we overwrite its value, otherwise we add it.
        - if you set the lower bound to -inf and the upper bound to +inf, thus
          effectively neutralizing the constraint, the solver will implicitly
          remove all of the constraint's terms.
        """
        pass
    def __init__(self,
        *,
        baseline_model_file_path : typing.Optional[typing.Text] = ...,
        variable_overrides : typing.Optional[typing.Mapping[builtins.int, global___MPVariableProto]] = ...,
        constraint_overrides : typing.Optional[typing.Mapping[builtins.int, global___MPConstraintProto]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["baseline_model_file_path",b"baseline_model_file_path"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["baseline_model_file_path",b"baseline_model_file_path","constraint_overrides",b"constraint_overrides","variable_overrides",b"variable_overrides"]) -> None: ...
global___MPModelDeltaProto = MPModelDeltaProto

class MPModelRequest(google.protobuf.message.Message):
    """Next id: 15."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class SolverType(_SolverType, metaclass=_SolverTypeEnumTypeWrapper):
        """The solver type, which will select a specific implementation, and will also
        impact the interpretation of the model (i.e. are we solving the problem
        as a mixed integer program or are we relaxing it as a continuous linear
        program?).
        This must remain consistent with MPSolver::OptimizationProblemType.
        """
        pass
    class _SolverType:
        V = typing.NewType('V', builtins.int)
    class _SolverTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SolverType.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        GLOP_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(2)
        """Recommended default for LP models."""

        CLP_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(0)
        GLPK_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(1)
        GUROBI_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(6)
        """Commercial, needs a valid license."""

        XPRESS_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(101)
        """Commercial, needs a valid license. NOLINT"""

        CPLEX_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(10)
        """Commercial, needs a valid license. NOLINT"""

        SCIP_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(3)
        """Recommended default for MIP models."""

        GLPK_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(4)
        CBC_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(5)
        GUROBI_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(7)
        """Commercial, needs a valid license."""

        XPRESS_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(102)
        """Commercial, needs a valid license. NOLINT"""

        CPLEX_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(11)
        """Commercial, needs a valid license. NOLINT"""

        BOP_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(12)
        SAT_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(14)
        """WARNING: This solver will currently interpret all variables as integer,
        so any solution you get will be valid, but the optimal might be far away
        for the real one (when you authorise non-integer value for continuous
        variables).
        """

        KNAPSACK_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(13)

    GLOP_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(2)
    """Recommended default for LP models."""

    CLP_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(0)
    GLPK_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(1)
    GUROBI_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(6)
    """Commercial, needs a valid license."""

    XPRESS_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(101)
    """Commercial, needs a valid license. NOLINT"""

    CPLEX_LINEAR_PROGRAMMING = MPModelRequest.SolverType.V(10)
    """Commercial, needs a valid license. NOLINT"""

    SCIP_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(3)
    """Recommended default for MIP models."""

    GLPK_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(4)
    CBC_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(5)
    GUROBI_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(7)
    """Commercial, needs a valid license."""

    XPRESS_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(102)
    """Commercial, needs a valid license. NOLINT"""

    CPLEX_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(11)
    """Commercial, needs a valid license. NOLINT"""

    BOP_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(12)
    SAT_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(14)
    """WARNING: This solver will currently interpret all variables as integer,
    so any solution you get will be valid, but the optimal might be far away
    for the real one (when you authorise non-integer value for continuous
    variables).
    """

    KNAPSACK_MIXED_INTEGER_PROGRAMMING = MPModelRequest.SolverType.V(13)

    MODEL_FIELD_NUMBER: builtins.int
    SOLVER_TYPE_FIELD_NUMBER: builtins.int
    SOLVER_TIME_LIMIT_SECONDS_FIELD_NUMBER: builtins.int
    ENABLE_INTERNAL_SOLVER_OUTPUT_FIELD_NUMBER: builtins.int
    SOLVER_SPECIFIC_PARAMETERS_FIELD_NUMBER: builtins.int
    IGNORE_SOLVER_SPECIFIC_PARAMETERS_FAILURE_FIELD_NUMBER: builtins.int
    MODEL_DELTA_FIELD_NUMBER: builtins.int
    POPULATE_ADDITIONAL_SOLUTIONS_UP_TO_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___MPModelProto:
        """The model to be optimized by the server."""
        pass
    solver_type: global___MPModelRequest.SolverType.V = ...
    solver_time_limit_seconds: builtins.float = ...
    """Maximum time to be spent by the solver to solve 'model'. If the server is
    busy and the RPC's deadline_left is less than this, it will immediately
    give up and return an error, without even trying to solve.

    The client can use this to have a guarantee on how much time the
    solver will spend on the problem (unless it finds and proves
    an optimal solution more quickly).

    If not specified, the time limit on the solver is the RPC's deadline_left.
    """

    enable_internal_solver_output: builtins.bool = ...
    """If this is set, then EnableOutput() will be set on the internal MPSolver
    that solves the model.
    WARNING: if you set this on a request to prod servers, it will be rejected
    and yield the RPC Application Error code MPSOLVER_SOLVER_TYPE_UNAVAILABLE.
    """

    solver_specific_parameters: typing.Text = ...
    """Advanced usage. Solver-specific parameters in the solver's own format,
    different for each solver. For example, if you use SCIP and you want to
    stop the solve earlier than the time limit if it reached a solution that is
    at most 1% away from the optimal, you can set this to "limits/gap=0.01".

    Note however that there is no "security" mechanism in place so it is up to
    the client to make sure that the given options don't make the solve
    non thread safe or use up too much memory for instance.

    If the option format is not understood by the solver, the request will be
    rejected and yield an RPC Application error with code
    MPSOLVER_MODEL_INVALID_SOLVER_PARAMETERS, unless you have set
    ignore_solver_specific_parameters_failure=true (in which case they are
    simply ignored).
    """

    ignore_solver_specific_parameters_failure: builtins.bool = ...
    @property
    def model_delta(self) -> global___MPModelDeltaProto:
        """Advanced usage: model "delta". If used, "model" must be unset. See the
        definition of MPModelDeltaProto.
        """
        pass
    populate_additional_solutions_up_to: builtins.int = ...
    """Controls the recovery of additional solutions, if any, saved by the
    underlying solver back in the MPSolutionResponse.additional_solutions.
    The repeated field will be length
       min(populate_addition_solutions_up_to,
           #additional_solutions_available_in_underlying_solver)
    These additional solutions may have a worse objective than the main
    solution returned in the response.
    """

    def __init__(self,
        *,
        model : typing.Optional[global___MPModelProto] = ...,
        solver_type : typing.Optional[global___MPModelRequest.SolverType.V] = ...,
        solver_time_limit_seconds : typing.Optional[builtins.float] = ...,
        enable_internal_solver_output : typing.Optional[builtins.bool] = ...,
        solver_specific_parameters : typing.Optional[typing.Text] = ...,
        ignore_solver_specific_parameters_failure : typing.Optional[builtins.bool] = ...,
        model_delta : typing.Optional[global___MPModelDeltaProto] = ...,
        populate_additional_solutions_up_to : typing.Optional[builtins.int] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["enable_internal_solver_output",b"enable_internal_solver_output","ignore_solver_specific_parameters_failure",b"ignore_solver_specific_parameters_failure","model",b"model","model_delta",b"model_delta","populate_additional_solutions_up_to",b"populate_additional_solutions_up_to","solver_specific_parameters",b"solver_specific_parameters","solver_time_limit_seconds",b"solver_time_limit_seconds","solver_type",b"solver_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["enable_internal_solver_output",b"enable_internal_solver_output","ignore_solver_specific_parameters_failure",b"ignore_solver_specific_parameters_failure","model",b"model","model_delta",b"model_delta","populate_additional_solutions_up_to",b"populate_additional_solutions_up_to","solver_specific_parameters",b"solver_specific_parameters","solver_time_limit_seconds",b"solver_time_limit_seconds","solver_type",b"solver_type"]) -> None: ...
global___MPModelRequest = MPModelRequest

class MPSolution(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    OBJECTIVE_VALUE_FIELD_NUMBER: builtins.int
    VARIABLE_VALUE_FIELD_NUMBER: builtins.int
    objective_value: builtins.float = ...
    @property
    def variable_value(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(self,
        *,
        objective_value : typing.Optional[builtins.float] = ...,
        variable_value : typing.Optional[typing.Iterable[builtins.float]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["objective_value",b"objective_value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["objective_value",b"objective_value","variable_value",b"variable_value"]) -> None: ...
global___MPSolution = MPSolution

class MPSolveInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    SOLVE_WALL_TIME_SECONDS_FIELD_NUMBER: builtins.int
    SOLVE_USER_TIME_SECONDS_FIELD_NUMBER: builtins.int
    solve_wall_time_seconds: builtins.float = ...
    """How much wall time (resp. user time) elapsed during the Solve() of the
    underlying solver library. "wall" time and "user" time are to be
    interpreted like for the "time" command in bash (see "help time").
    In particular, "user time" is CPU time and can be greater than wall time
    when using several threads.
    """

    solve_user_time_seconds: builtins.float = ...
    def __init__(self,
        *,
        solve_wall_time_seconds : typing.Optional[builtins.float] = ...,
        solve_user_time_seconds : typing.Optional[builtins.float] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["solve_user_time_seconds",b"solve_user_time_seconds","solve_wall_time_seconds",b"solve_wall_time_seconds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["solve_user_time_seconds",b"solve_user_time_seconds","solve_wall_time_seconds",b"solve_wall_time_seconds"]) -> None: ...
global___MPSolveInfo = MPSolveInfo

class MPSolutionResponse(google.protobuf.message.Message):
    """Next id: 11."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    STATUS_FIELD_NUMBER: builtins.int
    STATUS_STR_FIELD_NUMBER: builtins.int
    OBJECTIVE_VALUE_FIELD_NUMBER: builtins.int
    BEST_OBJECTIVE_BOUND_FIELD_NUMBER: builtins.int
    VARIABLE_VALUE_FIELD_NUMBER: builtins.int
    SOLVE_INFO_FIELD_NUMBER: builtins.int
    DUAL_VALUE_FIELD_NUMBER: builtins.int
    REDUCED_COST_FIELD_NUMBER: builtins.int
    ADDITIONAL_SOLUTIONS_FIELD_NUMBER: builtins.int
    status: global___MPSolverResponseStatus.V = ...
    """Result of the optimization."""

    status_str: typing.Text = ...
    """Human-readable string giving more details about the status. For example,
    when the status is MPSOLVER_INVALID_MODE, this can hold a description of
    why the model is invalid.
    This isn't always filled: don't depend on its value or even its presence.
    """

    objective_value: builtins.float = ...
    """Objective value corresponding to the "variable_value" below, taking into
    account the source "objective_offset" and "objective_coefficient".
    This is set iff 'status' is OPTIMAL or FEASIBLE.
    """

    best_objective_bound: builtins.float = ...
    """This field is only filled for MIP problems. For a minimization problem,
    this is a lower bound on the optimal objective value. For a maximization
    problem, it is an upper bound. It is only filled if the status is OPTIMAL
    or FEASIBLE. In the former case, best_objective_bound should be equal to
    objective_value (modulo numerical errors).
    """

    @property
    def variable_value(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Variable values in the same order as the MPModelProto::variable field.
        This is a dense representation. These are set iff 'status' is OPTIMAL or
        FEASIBLE.
        """
        pass
    @property
    def solve_info(self) -> global___MPSolveInfo:
        """Contains extra information about the solve, populated if the underlying
        solver (and its interface) supports it. As of 2021/07/19 this is supported
        by SCIP and Gurobi proto solves.
        """
        pass
    @property
    def dual_value(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """[Advanced usage.]
        Values of the dual variables values in the same order as the
        MPModelProto::constraint field. This is a dense representation.
        These are not set if the problem was solved with a MIP solver (even if
        it is actually a linear program).
        These are set iff 'status' is OPTIMAL or FEASIBLE.
        """
        pass
    @property
    def reduced_cost(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """[Advanced usage.]
        Values of the reduced cost of the variables in the same order as the
        MPModelProto::variable. This is a dense representation.
        These are not set if the problem was solved with a MIP solver (even if it
        is actually a linear program).
        These are set iff 'status' is OPTIMAL or FEASIBLE.
        """
        pass
    @property
    def additional_solutions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MPSolution]:
        """[Advanced usage.]
        If `MPModelRequest.populate_additional_solutions_up_to` > 0, up to that
        number of additional solutions may be populated here, if available. These
        additional solutions are different than the main solution described by the
        above fields `objective_value` and `variable_value`.
        """
        pass
    def __init__(self,
        *,
        status : typing.Optional[global___MPSolverResponseStatus.V] = ...,
        status_str : typing.Optional[typing.Text] = ...,
        objective_value : typing.Optional[builtins.float] = ...,
        best_objective_bound : typing.Optional[builtins.float] = ...,
        variable_value : typing.Optional[typing.Iterable[builtins.float]] = ...,
        solve_info : typing.Optional[global___MPSolveInfo] = ...,
        dual_value : typing.Optional[typing.Iterable[builtins.float]] = ...,
        reduced_cost : typing.Optional[typing.Iterable[builtins.float]] = ...,
        additional_solutions : typing.Optional[typing.Iterable[global___MPSolution]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["best_objective_bound",b"best_objective_bound","objective_value",b"objective_value","solve_info",b"solve_info","status",b"status","status_str",b"status_str"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["additional_solutions",b"additional_solutions","best_objective_bound",b"best_objective_bound","dual_value",b"dual_value","objective_value",b"objective_value","reduced_cost",b"reduced_cost","solve_info",b"solve_info","status",b"status","status_str",b"status_str","variable_value",b"variable_value"]) -> None: ...
global___MPSolutionResponse = MPSolutionResponse
