"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class LocalSearchStatistics(google.protobuf.message.Message):
    """Statistics on local search."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class LocalSearchOperatorStatistics(google.protobuf.message.Message):
        """Statistics on local search operators called during the search."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        LOCAL_SEARCH_OPERATOR_FIELD_NUMBER: builtins.int
        NUM_NEIGHBORS_FIELD_NUMBER: builtins.int
        NUM_FILTERED_NEIGHBORS_FIELD_NUMBER: builtins.int
        NUM_ACCEPTED_NEIGHBORS_FIELD_NUMBER: builtins.int
        DURATION_SECONDS_FIELD_NUMBER: builtins.int
        local_search_operator: typing.Text = ...
        """Name of the operator."""

        num_neighbors: builtins.int = ...
        """Number of neighbors generated by the operator."""

        num_filtered_neighbors: builtins.int = ...
        """Number of neighbors which were filtered."""

        num_accepted_neighbors: builtins.int = ...
        """Number of neighbors eventually accepted."""

        duration_seconds: builtins.float = ...
        """Time spent in the operator."""

        def __init__(self,
            *,
            local_search_operator : typing.Text = ...,
            num_neighbors : builtins.int = ...,
            num_filtered_neighbors : builtins.int = ...,
            num_accepted_neighbors : builtins.int = ...,
            duration_seconds : builtins.float = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["duration_seconds",b"duration_seconds","local_search_operator",b"local_search_operator","num_accepted_neighbors",b"num_accepted_neighbors","num_filtered_neighbors",b"num_filtered_neighbors","num_neighbors",b"num_neighbors"]) -> None: ...

    class LocalSearchFilterStatistics(google.protobuf.message.Message):
        """Statistics on local search filters called during the search."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        LOCAL_SEARCH_FILTER_FIELD_NUMBER: builtins.int
        NUM_CALLS_FIELD_NUMBER: builtins.int
        NUM_REJECTS_FIELD_NUMBER: builtins.int
        DURATION_SECONDS_FIELD_NUMBER: builtins.int
        local_search_filter: typing.Text = ...
        """Name of the filter."""

        num_calls: builtins.int = ...
        """Number of times the filter was called."""

        num_rejects: builtins.int = ...
        """Number of times the filter rejected a neighbor."""

        duration_seconds: builtins.float = ...
        """Time spent in the filter."""

        def __init__(self,
            *,
            local_search_filter : typing.Text = ...,
            num_calls : builtins.int = ...,
            num_rejects : builtins.int = ...,
            duration_seconds : builtins.float = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["duration_seconds",b"duration_seconds","local_search_filter",b"local_search_filter","num_calls",b"num_calls","num_rejects",b"num_rejects"]) -> None: ...

    LOCAL_SEARCH_OPERATOR_STATISTICS_FIELD_NUMBER: builtins.int
    LOCAL_SEARCH_FILTER_STATISTICS_FIELD_NUMBER: builtins.int
    TOTAL_NUM_NEIGHBORS_FIELD_NUMBER: builtins.int
    TOTAL_NUM_FILTERED_NEIGHBORS_FIELD_NUMBER: builtins.int
    TOTAL_NUM_ACCEPTED_NEIGHBORS_FIELD_NUMBER: builtins.int
    @property
    def local_search_operator_statistics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LocalSearchStatistics.LocalSearchOperatorStatistics]:
        """Statistics for each operator called during the search."""
        pass
    @property
    def local_search_filter_statistics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LocalSearchStatistics.LocalSearchFilterStatistics]:
        """Statistics for each filter called during the search."""
        pass
    total_num_neighbors: builtins.int = ...
    """Total number of (filtered/accepted) neighbors created during the search."""

    total_num_filtered_neighbors: builtins.int = ...
    total_num_accepted_neighbors: builtins.int = ...
    def __init__(self,
        *,
        local_search_operator_statistics : typing.Optional[typing.Iterable[global___LocalSearchStatistics.LocalSearchOperatorStatistics]] = ...,
        local_search_filter_statistics : typing.Optional[typing.Iterable[global___LocalSearchStatistics.LocalSearchFilterStatistics]] = ...,
        total_num_neighbors : builtins.int = ...,
        total_num_filtered_neighbors : builtins.int = ...,
        total_num_accepted_neighbors : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["local_search_filter_statistics",b"local_search_filter_statistics","local_search_operator_statistics",b"local_search_operator_statistics","total_num_accepted_neighbors",b"total_num_accepted_neighbors","total_num_filtered_neighbors",b"total_num_filtered_neighbors","total_num_neighbors",b"total_num_neighbors"]) -> None: ...
global___LocalSearchStatistics = LocalSearchStatistics

class ConstraintSolverStatistics(google.protobuf.message.Message):
    """Statistics on the search in the constraint solver."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NUM_BRANCHES_FIELD_NUMBER: builtins.int
    NUM_FAILURES_FIELD_NUMBER: builtins.int
    NUM_SOLUTIONS_FIELD_NUMBER: builtins.int
    BYTES_USED_FIELD_NUMBER: builtins.int
    DURATION_SECONDS_FIELD_NUMBER: builtins.int
    num_branches: builtins.int = ...
    """Number of branches explored."""

    num_failures: builtins.int = ...
    """Number of failures/backtracks."""

    num_solutions: builtins.int = ...
    """Number of solutions found."""

    bytes_used: builtins.int = ...
    """Memory usage of the solver."""

    duration_seconds: builtins.float = ...
    """Time spent in the filter."""

    def __init__(self,
        *,
        num_branches : builtins.int = ...,
        num_failures : builtins.int = ...,
        num_solutions : builtins.int = ...,
        bytes_used : builtins.int = ...,
        duration_seconds : builtins.float = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bytes_used",b"bytes_used","duration_seconds",b"duration_seconds","num_branches",b"num_branches","num_failures",b"num_failures","num_solutions",b"num_solutions"]) -> None: ...
global___ConstraintSolverStatistics = ConstraintSolverStatistics

class SearchStatistics(google.protobuf.message.Message):
    """Search statistics."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    LOCAL_SEARCH_STATISTICS_FIELD_NUMBER: builtins.int
    CONSTRAINT_SOLVER_STATISTICS_FIELD_NUMBER: builtins.int
    @property
    def local_search_statistics(self) -> global___LocalSearchStatistics:
        """Local search statistics."""
        pass
    @property
    def constraint_solver_statistics(self) -> global___ConstraintSolverStatistics:
        """Constraint solver statistics."""
        pass
    def __init__(self,
        *,
        local_search_statistics : typing.Optional[global___LocalSearchStatistics] = ...,
        constraint_solver_statistics : typing.Optional[global___ConstraintSolverStatistics] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["constraint_solver_statistics",b"constraint_solver_statistics","local_search_statistics",b"local_search_statistics"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["constraint_solver_statistics",b"constraint_solver_statistics","local_search_statistics",b"local_search_statistics"]) -> None: ...
global___SearchStatistics = SearchStatistics
