"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import ortools.constraint_solver.routing_enums_pb2
import ortools.constraint_solver.solver_parameters_pb2
import ortools.sat.sat_parameters_pb2
import ortools.util.optional_boolean_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class RoutingSearchParameters(google.protobuf.message.Message):
    """Parameters defining the search used to solve vehicle routing problems.

    If a parameter is unset (or, equivalently, set to its default value),
    then the routing library will pick its preferred value for that parameter
    automatically: this should be the case for most parameters.
    To see those "default" parameters, call GetDefaultRoutingSearchParameters().
    Next ID: 49
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class SchedulingSolver(_SchedulingSolver, metaclass=_SchedulingSolverEnumTypeWrapper):
        """Underlying solver to use in dimension scheduling, respectively for
        continuous and mixed models.
        """
        pass
    class _SchedulingSolver:
        V = typing.NewType('V', builtins.int)
    class _SchedulingSolverEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SchedulingSolver.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        UNSET = RoutingSearchParameters.SchedulingSolver.V(0)
        GLOP = RoutingSearchParameters.SchedulingSolver.V(1)
        CP_SAT = RoutingSearchParameters.SchedulingSolver.V(2)

    UNSET = RoutingSearchParameters.SchedulingSolver.V(0)
    GLOP = RoutingSearchParameters.SchedulingSolver.V(1)
    CP_SAT = RoutingSearchParameters.SchedulingSolver.V(2)

    class LocalSearchNeighborhoodOperators(google.protobuf.message.Message):
        """Local search neighborhood operators used to build a solutions neighborhood.
        Next ID: 34
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        USE_RELOCATE_FIELD_NUMBER: builtins.int
        USE_RELOCATE_PAIR_FIELD_NUMBER: builtins.int
        USE_LIGHT_RELOCATE_PAIR_FIELD_NUMBER: builtins.int
        USE_RELOCATE_NEIGHBORS_FIELD_NUMBER: builtins.int
        USE_RELOCATE_SUBTRIP_FIELD_NUMBER: builtins.int
        USE_EXCHANGE_FIELD_NUMBER: builtins.int
        USE_EXCHANGE_PAIR_FIELD_NUMBER: builtins.int
        USE_EXCHANGE_SUBTRIP_FIELD_NUMBER: builtins.int
        USE_CROSS_FIELD_NUMBER: builtins.int
        USE_CROSS_EXCHANGE_FIELD_NUMBER: builtins.int
        USE_RELOCATE_EXPENSIVE_CHAIN_FIELD_NUMBER: builtins.int
        USE_TWO_OPT_FIELD_NUMBER: builtins.int
        USE_OR_OPT_FIELD_NUMBER: builtins.int
        USE_LIN_KERNIGHAN_FIELD_NUMBER: builtins.int
        USE_TSP_OPT_FIELD_NUMBER: builtins.int
        USE_MAKE_ACTIVE_FIELD_NUMBER: builtins.int
        USE_RELOCATE_AND_MAKE_ACTIVE_FIELD_NUMBER: builtins.int
        USE_MAKE_INACTIVE_FIELD_NUMBER: builtins.int
        USE_MAKE_CHAIN_INACTIVE_FIELD_NUMBER: builtins.int
        USE_SWAP_ACTIVE_FIELD_NUMBER: builtins.int
        USE_EXTENDED_SWAP_ACTIVE_FIELD_NUMBER: builtins.int
        USE_NODE_PAIR_SWAP_ACTIVE_FIELD_NUMBER: builtins.int
        USE_PATH_LNS_FIELD_NUMBER: builtins.int
        USE_FULL_PATH_LNS_FIELD_NUMBER: builtins.int
        USE_TSP_LNS_FIELD_NUMBER: builtins.int
        USE_INACTIVE_LNS_FIELD_NUMBER: builtins.int
        USE_GLOBAL_CHEAPEST_INSERTION_PATH_LNS_FIELD_NUMBER: builtins.int
        USE_LOCAL_CHEAPEST_INSERTION_PATH_LNS_FIELD_NUMBER: builtins.int
        USE_RELOCATE_PATH_GLOBAL_CHEAPEST_INSERTION_INSERT_UNPERFORMED_FIELD_NUMBER: builtins.int
        USE_GLOBAL_CHEAPEST_INSERTION_EXPENSIVE_CHAIN_LNS_FIELD_NUMBER: builtins.int
        USE_LOCAL_CHEAPEST_INSERTION_EXPENSIVE_CHAIN_LNS_FIELD_NUMBER: builtins.int
        USE_GLOBAL_CHEAPEST_INSERTION_CLOSE_NODES_LNS_FIELD_NUMBER: builtins.int
        USE_LOCAL_CHEAPEST_INSERTION_CLOSE_NODES_LNS_FIELD_NUMBER: builtins.int
        use_relocate: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """--- Inter-route operators ---
        Operator which moves a single node to another position.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 -> 5
        (where (1, 5) are first and last nodes of the path and can therefore not
        be moved):
          1 ->  3  -> [2] ->  4  -> 5
          1 ->  3  ->  4  -> [2] -> 5
          1 ->  2  ->  4  -> [3] -> 5
          1 -> [4] ->  2  ->  3  -> 5
        """

        use_relocate_pair: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which moves a pair of pickup and delivery nodes to another
        position where the first node of the pair must be before the second node
        on the same path. Compared to the light_relocate_pair operator, tries all
        possible positions of insertion of a pair (not only after another pair).
        Possible neighbors for the path 1 -> A -> B -> 2 -> 3 (where (1, 3) are
        first and last nodes of the path and can therefore not be moved, and
        (A, B) is a pair of nodes):
          1 -> [A] ->  2  -> [B] -> 3
          1 ->  2  -> [A] -> [B] -> 3
        """

        use_light_relocate_pair: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which moves a pair of pickup and delivery nodes after another
        pair.
        Possible neighbors for paths 1 -> A -> B -> 2, 3 -> C -> D -> 4 (where
        (1, 2) and (3, 4) are first and last nodes of paths and can therefore not
        be moved, and (A, B) and (C, D) are pair of nodes):
          1 -> 2, 3 -> C -> [A] -> D -> [B] -> 4
          1 -> A -> [C] -> B -> [D] -> 2, 3 -> 4
        """

        use_relocate_neighbors: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Relocate neighborhood which moves chains of neighbors.
        The operator starts by relocating a node n after a node m, then continues
        moving nodes which were after n as long as the "cost" added is less than
        the "cost" of the arc (m, n). If the new chain doesn't respect the domain
        of next variables, it will try reordering the nodes until it finds a
        valid path.
        Possible neighbors for path 1 -> A -> B -> C -> D -> E -> 2 (where (1, 2)
        are first and last nodes of the path and can therefore not be moved, A
        must be performed before B, and A, D and E are located at the same
        place):
        1 -> A -> C -> [B] -> D -> E -> 2
        1 -> A -> C -> D -> [B] -> E -> 2
        1 -> A -> C -> D -> E -> [B] -> 2
        1 -> A -> B -> D -> [C] -> E -> 2
        1 -> A -> B -> D -> E -> [C] -> 2
        1 -> A -> [D] -> [E] -> B -> C -> 2
        1 -> A -> B -> [D] -> [E] ->  C -> 2
        1 -> A -> [E] -> B -> C -> D -> 2
        1 -> A -> B -> [E] -> C -> D -> 2
        1 -> A -> B -> C -> [E] -> D -> 2
        This operator is extremelly useful to move chains of nodes which are
        located at the same place (for instance nodes part of a same stop).
        """

        use_relocate_subtrip: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Relocate neighborhood that moves subpaths all pickup and delivery
        pairs have both pickup and delivery inside the subpath or both outside
        the subpath. For instance, for given paths:
        0 -> A -> B -> A' -> B' -> 5 -> 6 -> 8
        7 -> 9
        Pairs (A,A') and (B,B') are interleaved, so the expected neighbors are:
        0 -> 5 -> A -> B -> A' -> B' -> 6 -> 8
        7 -> 9

        0 -> 5 -> 6 -> A -> B -> A' -> B' -> 8
        7 -> 9

        0 -> 5 -> 6 -> 8
        7 -> A -> B -> A' -> B' -> 9
        """

        use_exchange: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which exchanges the positions of two nodes.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 -> 5
        (where (1, 5) are first and last nodes of the path and can therefore not
        be moved):
          1 -> [3] -> [2] ->  4  -> 5
          1 -> [4] ->  3  -> [2] -> 5
          1 ->  2  -> [4] -> [3] -> 5
        """

        use_exchange_pair: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which exchanges the positions of two pair of nodes. Pairs
        correspond to the pickup and delivery pairs defined in the routing model.
        Possible neighbor for the paths
        1 -> A -> B -> 2 -> 3 and 4 -> C -> D -> 5
        (where (1, 3) and (4, 5) are first and last nodes of the paths and can
        therefore not be moved, and (A, B) and (C,D) are pairs of nodes):
          1 -> [C] ->  [D] -> 2 -> 3, 4 -> [A] -> [B] -> 5
        """

        use_exchange_subtrip: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which exchanges subtrips associated to two pairs of nodes,
        see use_relocate_subtrip for a definition of subtrips.
        """

        use_cross: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which cross exchanges the starting chains of 2 paths, including
        exchanging the whole paths.
        First and last nodes are not moved.
        Possible neighbors for the paths 1 -> 2 -> 3 -> 4 -> 5 and 6 -> 7 -> 8
        (where (1, 5) and (6, 8) are first and last nodes of the paths and can
        therefore not be moved):
          1 -> [7] -> 3 -> 4 -> 5  6 -> [2] -> 8
          1 -> [7] -> 4 -> 5       6 -> [2 -> 3] -> 8
          1 -> [7] -> 5            6 -> [2 -> 3 -> 4] -> 8
        """

        use_cross_exchange: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Not implemented yet. TODO(b/68128619): Implement."""

        use_relocate_expensive_chain: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which detects the relocate_expensive_chain_num_arcs_to_consider
        most expensive arcs on a path, and moves the chain resulting from cutting
        pairs of arcs among these to another position.
        Possible neighbors for paths 1 -> 2 (empty) and
        3 -> A ------> B --> C -----> D -> 4 (where A -> B and C -> D are the 2
        most expensive arcs, and the chain resulting from breaking them is
        B -> C):
          1 -> [B -> C] -> 2     3 -> A -> D -> 4
          1 -> 2      3 -> [B -> C] -> A -> D -> 4
          1 -> 2      3 -> A -> D -> [B -> C] -> 4
        """

        use_two_opt: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """--- Intra-route operators ---
        Operator which reverves a sub-chain of a path. It is called TwoOpt
        because it breaks two arcs on the path; resulting paths are called
        two-optimal.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 -> 5
        (where (1, 5) are first and last nodes of the path and can therefore not
        be moved):
          1 -> [3 -> 2] -> 4  -> 5
          1 -> [4 -> 3  -> 2] -> 5
          1 ->  2 -> [4 -> 3] -> 5
        """

        use_or_opt: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which moves sub-chains of a path of length 1, 2 and 3 to another
        position in the same path.
        When the length of the sub-chain is 1, the operator simply moves a node
        to another position.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 -> 5, for a sub-chain
        length of 2 (where (1, 5) are first and last nodes of the path and can
        therefore not be moved):
          1 ->  4 -> [2 -> 3] -> 5
          1 -> [3 -> 4] -> 2  -> 5
        The OR_OPT operator is a limited version of 3-Opt (breaks 3 arcs on a
        path).
        """

        use_lin_kernighan: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Lin-Kernighan operator.
        While the accumulated local gain is positive, performs a 2-OPT or a 3-OPT
        move followed by a series of 2-OPT moves. Returns a neighbor for which
        the global gain is positive.
        """

        use_tsp_opt: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Sliding TSP operator.
        Uses an exact dynamic programming algorithm to solve the TSP
        corresponding to path sub-chains.
        For a subchain 1 -> 2 -> 3 -> 4 -> 5 -> 6, solves the TSP on
        nodes A, 2, 3, 4, 5, where A is a merger of nodes 1 and 6 such that
        cost(A,i) = cost(1,i) and cost(i,A) = cost(i,6).
        """

        use_make_active: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """--- Operators on inactive nodes ---
        Operator which inserts an inactive node into a path.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 with 5 inactive
        (where 1 and 4 are first and last nodes of the path) are:
          1 -> [5] ->  2  ->  3  -> 4
          1 ->  2  -> [5] ->  3  -> 4
          1 ->  2  ->  3  -> [5] -> 4
        """

        use_relocate_and_make_active: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which relocates a node while making an inactive one active.
        As of 3/2017, the operator is limited to two kinds of moves:
        - Relocating a node and replacing it by an inactive node.
          Possible neighbor for path 1 -> 5, 2 -> 3 -> 6 and 4 inactive
          (where 1,2 and 5,6 are first and last nodes of paths) is:
          1 -> 3 -> 5, 2 -> 4 -> 6.
        - Relocating a node and inserting an inactive node next to it.
          Possible neighbor for path 1 -> 5, 2 -> 3 -> 6 and 4 inactive
          (where 1,2 and 5,6 are first and last nodes of paths) is:
          1 -> 4 -> 3 -> 5, 2 -> 6.
        """

        use_make_inactive: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which makes path nodes inactive.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 (where 1 and 4 are first
        and last nodes of the path) are:
          1 -> 3 -> 4 with 2 inactive
          1 -> 2 -> 4 with 3 inactive
        """

        use_make_chain_inactive: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which makes a "chain" of path nodes inactive.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 (where 1 and 4 are first
        and last nodes of the path) are:
          1 -> 3 -> 4 with 2 inactive
          1 -> 2 -> 4 with 3 inactive
          1 -> 4 with 2 and 3 inactive
        """

        use_swap_active: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which replaces an active node by an inactive one.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 with 5 inactive
        (where 1 and 4 are first and last nodes of the path) are:
          1 -> [5] ->  3  -> 4 with 2 inactive
          1 ->  2  -> [5] -> 4 with 3 inactive
        """

        use_extended_swap_active: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which makes an inactive node active and an active one inactive.
        It is similar to SwapActiveOperator excepts that it tries to insert the
        inactive node in all possible positions instead of just the position of
        the node made inactive.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 with 5 inactive
        (where 1 and 4 are first and last nodes of the path) are:
          1 -> [5] ->  3  -> 4 with 2 inactive
          1 ->  3  -> [5] -> 4 with 2 inactive
          1 -> [5] ->  2  -> 4 with 3 inactive
          1 ->  2  -> [5] -> 4 with 3 inactive
        """

        use_node_pair_swap_active: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which makes an inactive node active and an active pair of nodes
        inactive OR makes an inactive pair of nodes active and an active node
        inactive.
        Possible neighbors for the path 1 -> 2 -> 3 -> 4 with 5 inactive
        (where 1 and 4 are first and last nodes of the path and (2,3) is a pair
        of nodes) are:
          1 -> [5] -> 4 with (2,3) inactive
        Possible neighbors for the path 1 -> 2 -> 3 with (4,5) inactive
        (where 1 and 3 are first and last nodes of the path and (4,5) is a pair
        of nodes) are:
          1 -> [4] -> [5] -> 3 with 2 inactive
        """

        use_path_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """--- Large neighborhood search operators ---
        Operator which relaxes two sub-chains of three consecutive arcs each.
        Each sub-chain is defined by a start node and the next three arcs. Those
        six arcs are relaxed to build a new neighbor.
        PATH_LNS explores all possible pairs of starting nodes and so defines
        n^2 neighbors, n being the number of nodes.
        Note that the two sub-chains can be part of the same path; they even may
        overlap.
        """

        use_full_path_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which relaxes one entire path and all unactive nodes."""

        use_tsp_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """TSP-base LNS.
        Randomly merges consecutive nodes until n "meta"-nodes remain and solves
        the corresponding TSP.
        This defines an "unlimited" neighborhood which must be stopped by search
        limits. To force diversification, the operator iteratively forces each
        node to serve as base of a meta-node.
        """

        use_inactive_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Operator which relaxes all inactive nodes and one sub-chain of six
        consecutive arcs. That way the path can be improved by inserting inactive
        nodes or swaping arcs.
        """

        use_global_cheapest_insertion_path_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """--- LNS-like large neighborhood search operators using heuristics ---
        Operator which makes all nodes on a route unperformed, and reinserts them
        using the GlobalCheapestInsertion heuristic.
        """

        use_local_cheapest_insertion_path_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Same as above but using LocalCheapestInsertion as a heuristic."""

        use_relocate_path_global_cheapest_insertion_insert_unperformed: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """The following operator relocates an entire route to an empty path and
        then tries to insert the unperformed nodes using the global cheapest
        insertion heuristic.
        """

        use_global_cheapest_insertion_expensive_chain_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """This operator finds heuristic_expensive_chain_lns_num_arcs_to_consider
        most expensive arcs on a route, makes the nodes in between pairs of these
        expensive arcs unperformed, and reinserts them using the
        GlobalCheapestInsertion heuristic.
        """

        use_local_cheapest_insertion_expensive_chain_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Same as above but using LocalCheapestInsertion as a heuristic for
        insertion.
        """

        use_global_cheapest_insertion_close_nodes_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """The following operator makes a node and its
        heuristic_close_nodes_lns_num_nodes closest neighbors unperformed along
        with each of their corresponding performed pickup/delivery pairs, and
        then reinserts them using the GlobalCheapestInsertion heuristic.
        """

        use_local_cheapest_insertion_close_nodes_lns: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
        """Same as above, but insertion positions for nodes are determined by the
        LocalCheapestInsertion heuristic.
        """

        def __init__(self,
            *,
            use_relocate : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_relocate_pair : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_light_relocate_pair : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_relocate_neighbors : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_relocate_subtrip : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_exchange : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_exchange_pair : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_exchange_subtrip : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_cross : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_cross_exchange : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_relocate_expensive_chain : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_two_opt : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_or_opt : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_lin_kernighan : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_tsp_opt : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_make_active : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_relocate_and_make_active : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_make_inactive : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_make_chain_inactive : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_swap_active : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_extended_swap_active : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_node_pair_swap_active : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_path_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_full_path_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_tsp_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_inactive_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_global_cheapest_insertion_path_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_local_cheapest_insertion_path_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_relocate_path_global_cheapest_insertion_insert_unperformed : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_global_cheapest_insertion_expensive_chain_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_local_cheapest_insertion_expensive_chain_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_global_cheapest_insertion_close_nodes_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            use_local_cheapest_insertion_close_nodes_lns : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["use_cross",b"use_cross","use_cross_exchange",b"use_cross_exchange","use_exchange",b"use_exchange","use_exchange_pair",b"use_exchange_pair","use_exchange_subtrip",b"use_exchange_subtrip","use_extended_swap_active",b"use_extended_swap_active","use_full_path_lns",b"use_full_path_lns","use_global_cheapest_insertion_close_nodes_lns",b"use_global_cheapest_insertion_close_nodes_lns","use_global_cheapest_insertion_expensive_chain_lns",b"use_global_cheapest_insertion_expensive_chain_lns","use_global_cheapest_insertion_path_lns",b"use_global_cheapest_insertion_path_lns","use_inactive_lns",b"use_inactive_lns","use_light_relocate_pair",b"use_light_relocate_pair","use_lin_kernighan",b"use_lin_kernighan","use_local_cheapest_insertion_close_nodes_lns",b"use_local_cheapest_insertion_close_nodes_lns","use_local_cheapest_insertion_expensive_chain_lns",b"use_local_cheapest_insertion_expensive_chain_lns","use_local_cheapest_insertion_path_lns",b"use_local_cheapest_insertion_path_lns","use_make_active",b"use_make_active","use_make_chain_inactive",b"use_make_chain_inactive","use_make_inactive",b"use_make_inactive","use_node_pair_swap_active",b"use_node_pair_swap_active","use_or_opt",b"use_or_opt","use_path_lns",b"use_path_lns","use_relocate",b"use_relocate","use_relocate_and_make_active",b"use_relocate_and_make_active","use_relocate_expensive_chain",b"use_relocate_expensive_chain","use_relocate_neighbors",b"use_relocate_neighbors","use_relocate_pair",b"use_relocate_pair","use_relocate_path_global_cheapest_insertion_insert_unperformed",b"use_relocate_path_global_cheapest_insertion_insert_unperformed","use_relocate_subtrip",b"use_relocate_subtrip","use_swap_active",b"use_swap_active","use_tsp_lns",b"use_tsp_lns","use_tsp_opt",b"use_tsp_opt","use_two_opt",b"use_two_opt"]) -> None: ...

    class ImprovementSearchLimitParameters(google.protobuf.message.Message):
        """Parameters required for the improvement search limit."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        IMPROVEMENT_RATE_COEFFICIENT_FIELD_NUMBER: builtins.int
        IMPROVEMENT_RATE_SOLUTIONS_DISTANCE_FIELD_NUMBER: builtins.int
        improvement_rate_coefficient: builtins.float = ...
        """Parameter that regulates exchange rate between objective improvement and
        number of neighbors spent. The smaller the value, the sooner the limit
        stops the search. Must be positive.
        """

        improvement_rate_solutions_distance: builtins.int = ...
        """Parameter that specifies the distance between improvements taken into
        consideration for calculating the improvement rate.
        Example: For 5 objective improvements = (10, 8, 6, 4, 2), and the
        solutions_distance parameter of 2, then the improvement_rate will be
        computed for (10, 6), (8, 4), and (6, 2).
        """

        def __init__(self,
            *,
            improvement_rate_coefficient : builtins.float = ...,
            improvement_rate_solutions_distance : builtins.int = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["improvement_rate_coefficient",b"improvement_rate_coefficient","improvement_rate_solutions_distance",b"improvement_rate_solutions_distance"]) -> None: ...

    FIRST_SOLUTION_STRATEGY_FIELD_NUMBER: builtins.int
    USE_UNFILTERED_FIRST_SOLUTION_STRATEGY_FIELD_NUMBER: builtins.int
    SAVINGS_NEIGHBORS_RATIO_FIELD_NUMBER: builtins.int
    SAVINGS_MAX_MEMORY_USAGE_BYTES_FIELD_NUMBER: builtins.int
    SAVINGS_ADD_REVERSE_ARCS_FIELD_NUMBER: builtins.int
    SAVINGS_ARC_COEFFICIENT_FIELD_NUMBER: builtins.int
    SAVINGS_PARALLEL_ROUTES_FIELD_NUMBER: builtins.int
    CHEAPEST_INSERTION_FARTHEST_SEEDS_RATIO_FIELD_NUMBER: builtins.int
    CHEAPEST_INSERTION_FIRST_SOLUTION_NEIGHBORS_RATIO_FIELD_NUMBER: builtins.int
    CHEAPEST_INSERTION_FIRST_SOLUTION_MIN_NEIGHBORS_FIELD_NUMBER: builtins.int
    CHEAPEST_INSERTION_LS_OPERATOR_NEIGHBORS_RATIO_FIELD_NUMBER: builtins.int
    CHEAPEST_INSERTION_LS_OPERATOR_MIN_NEIGHBORS_FIELD_NUMBER: builtins.int
    CHEAPEST_INSERTION_FIRST_SOLUTION_USE_NEIGHBORS_RATIO_FOR_INITIALIZATION_FIELD_NUMBER: builtins.int
    CHEAPEST_INSERTION_ADD_UNPERFORMED_ENTRIES_FIELD_NUMBER: builtins.int
    CHRISTOFIDES_USE_MINIMUM_MATCHING_FIELD_NUMBER: builtins.int
    LOCAL_SEARCH_OPERATORS_FIELD_NUMBER: builtins.int
    USE_MULTI_ARMED_BANDIT_CONCATENATE_OPERATORS_FIELD_NUMBER: builtins.int
    MULTI_ARMED_BANDIT_COMPOUND_OPERATOR_MEMORY_COEFFICIENT_FIELD_NUMBER: builtins.int
    MULTI_ARMED_BANDIT_COMPOUND_OPERATOR_EXPLORATION_COEFFICIENT_FIELD_NUMBER: builtins.int
    RELOCATE_EXPENSIVE_CHAIN_NUM_ARCS_TO_CONSIDER_FIELD_NUMBER: builtins.int
    HEURISTIC_EXPENSIVE_CHAIN_LNS_NUM_ARCS_TO_CONSIDER_FIELD_NUMBER: builtins.int
    HEURISTIC_CLOSE_NODES_LNS_NUM_NODES_FIELD_NUMBER: builtins.int
    LOCAL_SEARCH_METAHEURISTIC_FIELD_NUMBER: builtins.int
    GUIDED_LOCAL_SEARCH_LAMBDA_COEFFICIENT_FIELD_NUMBER: builtins.int
    USE_DEPTH_FIRST_SEARCH_FIELD_NUMBER: builtins.int
    USE_CP_FIELD_NUMBER: builtins.int
    USE_CP_SAT_FIELD_NUMBER: builtins.int
    USE_GENERALIZED_CP_SAT_FIELD_NUMBER: builtins.int
    SAT_PARAMETERS_FIELD_NUMBER: builtins.int
    CONTINUOUS_SCHEDULING_SOLVER_FIELD_NUMBER: builtins.int
    MIXED_INTEGER_SCHEDULING_SOLVER_FIELD_NUMBER: builtins.int
    OPTIMIZATION_STEP_FIELD_NUMBER: builtins.int
    NUMBER_OF_SOLUTIONS_TO_COLLECT_FIELD_NUMBER: builtins.int
    SOLUTION_LIMIT_FIELD_NUMBER: builtins.int
    TIME_LIMIT_FIELD_NUMBER: builtins.int
    LNS_TIME_LIMIT_FIELD_NUMBER: builtins.int
    IMPROVEMENT_LIMIT_PARAMETERS_FIELD_NUMBER: builtins.int
    USE_FULL_PROPAGATION_FIELD_NUMBER: builtins.int
    LOG_SEARCH_FIELD_NUMBER: builtins.int
    LOG_COST_SCALING_FACTOR_FIELD_NUMBER: builtins.int
    LOG_COST_OFFSET_FIELD_NUMBER: builtins.int
    LOG_TAG_FIELD_NUMBER: builtins.int
    first_solution_strategy: ortools.constraint_solver.routing_enums_pb2.FirstSolutionStrategy.Value.V = ...
    """First solution strategies, used as starting point of local search."""

    use_unfiltered_first_solution_strategy: builtins.bool = ...
    """--- Advanced first solutions strategy settings ---
    Don't touch these unless you know what you are doing.

    Use filtered version of first solution strategy if available.
    """

    savings_neighbors_ratio: builtins.float = ...
    """Parameters specific to the Savings first solution heuristic.
    Ratio (in ]0, 1]) of neighbors to consider for each node when constructing
    the savings. If unspecified, its value is considered to be 1.0.
    """

    savings_max_memory_usage_bytes: builtins.float = ...
    """The number of neighbors considered for each node in the Savings heuristic
    is chosen so that the space used to store the savings doesn't exceed
    savings_max_memory_usage_bytes, which must be in ]0, 1e10].
    NOTE: If both savings_neighbors_ratio and savings_max_memory_usage_bytes
    are specified, the number of neighbors considered for each node will be the
    minimum of the two numbers determined by these parameters.
    """

    savings_add_reverse_arcs: builtins.bool = ...
    """Add savings related to reverse arcs when finding the nearest neighbors
    of the nodes.
    """

    savings_arc_coefficient: builtins.float = ...
    """Coefficient of the cost of the arc for which the saving value is being
    computed:
    Saving(a-->b) = Cost(a-->end) + Cost(start-->b)
                    - savings_arc_coefficient * Cost(a-->b)
    This parameter must be greater than 0, and its default value is 1.
    """

    savings_parallel_routes: builtins.bool = ...
    """When true, the routes are built in parallel, sequentially otherwise."""

    cheapest_insertion_farthest_seeds_ratio: builtins.float = ...
    """Ratio (between 0 and 1) of available vehicles in the model on which
    farthest nodes of the model are inserted as seeds in the
    GlobalCheapestInsertion first solution heuristic.
    """

    cheapest_insertion_first_solution_neighbors_ratio: builtins.float = ...
    """Ratio (in ]0, 1]) of closest non start/end nodes to consider as neighbors
    for each node when creating new insertions in the parallel/sequential
    cheapest insertion heuristic.
    If not overridden, its default value is 1, meaning all neighbors will be
    considered.
    The neighborhood ratio is coupled with the corresponding min_neighbors
    integer, indicating the minimum number of neighbors to consider for each
    node:
    num_closest_neighbors =
           max(min_neighbors, neighbors_ratio * NUM_NON_START_END_NODES)
    This minimum number of neighbors must be greater or equal to 1, its
    default value.

    Neighbors ratio and minimum number of neighbors for the first solution
    heuristic.
    """

    cheapest_insertion_first_solution_min_neighbors: builtins.int = ...
    cheapest_insertion_ls_operator_neighbors_ratio: builtins.float = ...
    """Neighbors ratio and minimum number of neighbors for the heuristic when used
    in a local search operator (see
    local_search_operators.use_global_cheapest_insertion_path_lns and
    local_search_operators.use_global_cheapest_insertion_chain_lns below).
    """

    cheapest_insertion_ls_operator_min_neighbors: builtins.int = ...
    cheapest_insertion_first_solution_use_neighbors_ratio_for_initialization: builtins.bool = ...
    """Whether or not to only consider closest neighbors when initializing the
    assignment for the first solution.
    """

    cheapest_insertion_add_unperformed_entries: builtins.bool = ...
    """Whether or not to consider entries making the nodes/pairs unperformed in
    the GlobalCheapestInsertion heuristic.
    """

    christofides_use_minimum_matching: builtins.bool = ...
    """If true use minimum matching instead of minimal matching in the
    Christofides algorithm.
    """

    @property
    def local_search_operators(self) -> global___RoutingSearchParameters.LocalSearchNeighborhoodOperators: ...
    use_multi_armed_bandit_concatenate_operators: builtins.bool = ...
    """If true, the solver will use multi-armed bandit concatenate operators. It
    dynamically chooses the next neighbor operator in order to get the best
    objective improvement.
    """

    multi_armed_bandit_compound_operator_memory_coefficient: builtins.float = ...
    """Memory coefficient related to the multi-armed bandit compound operator.
    Sets how much the objective improvement of previous accepted neighbors
    influence the current average improvement.
    This parameter should be between 0 and 1.
    """

    multi_armed_bandit_compound_operator_exploration_coefficient: builtins.float = ...
    """Positive parameter defining the exploration coefficient of the multi-armed
    bandit compound operator. Sets how often we explore rarely used and
    unsuccessful in the past operators
    """

    relocate_expensive_chain_num_arcs_to_consider: builtins.int = ...
    """Number of expensive arcs to consider cutting in the RelocateExpensiveChain
    neighborhood operator (see
    LocalSearchNeighborhoodOperators.use_relocate_expensive_chain()).
    This parameter must be greater than 2.
    NOTE(user): The number of neighbors generated by the operator for
    relocate_expensive_chain_num_arcs_to_consider = K is around
    K*(K-1)/2 * number_of_routes * number_of_nodes.
    """

    heuristic_expensive_chain_lns_num_arcs_to_consider: builtins.int = ...
    """Number of expensive arcs to consider cutting in the
    FilteredHeuristicExpensiveChainLNSOperator operator.
    """

    heuristic_close_nodes_lns_num_nodes: builtins.int = ...
    """Number of closest nodes to consider for each node during the destruction
    phase of the FilteredHeuristicCloseNodesLNSOperator.
    """

    local_search_metaheuristic: ortools.constraint_solver.routing_enums_pb2.LocalSearchMetaheuristic.Value.V = ...
    """Local search metaheuristics used to guide the search."""

    guided_local_search_lambda_coefficient: builtins.float = ...
    """These are advanced settings which should not be modified unless you know
    what you are doing.
    Lambda coefficient used to penalize arc costs when GUIDED_LOCAL_SEARCH is
    used. Must be positive.
    """

    use_depth_first_search: builtins.bool = ...
    """--- Search control ---

    If true, the solver should use depth-first search rather than local search
    to solve the problem.
    """

    use_cp: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
    """If true, use the CP solver to find a solution. Either local or depth-first
    search will be used depending on the value of use_depth_first_search. Will
    be run before the CP-SAT solver (cf. use_cp_sat).
    """

    use_cp_sat: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
    """If true, use the CP-SAT solver to find a solution. If use_cp is also true,
    the CP-SAT solver will be run after the CP solver if there is time
    remaining and will use the CP solution as a hint for the CP-SAT search.
    As of 5/2019, only TSP models can be solved.
    """

    use_generalized_cp_sat: ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...
    """If true, use the CP-SAT solver to find a solution on generalized routing
    model. If use_cp is also true, the CP-SAT solver will be run after the CP
    solver if there is time remaining and will use the CP solution as a hint
    for the CP-SAT search.
    """

    @property
    def sat_parameters(self) -> ortools.sat.sat_parameters_pb2.SatParameters:
        """If use_cp_sat or use_generalized_cp_sat is true, contains the SAT algorithm
        parameters which will be used.
        """
        pass
    continuous_scheduling_solver: global___RoutingSearchParameters.SchedulingSolver.V = ...
    mixed_integer_scheduling_solver: global___RoutingSearchParameters.SchedulingSolver.V = ...
    optimization_step: builtins.float = ...
    """Minimum step by which the solution must be improved in local search. 0
    means "unspecified". If this value is fractional, it will get rounded to
    the nearest integer.
    """

    number_of_solutions_to_collect: builtins.int = ...
    """Number of solutions to collect during the search. Corresponds to the best
    solutions found during the search. 0 means "unspecified".
    """

    solution_limit: builtins.int = ...
    """-- Search limits --
    Limit to the number of solutions generated during the search. 0 means
    "unspecified".
    """

    @property
    def time_limit(self) -> google.protobuf.duration_pb2.Duration:
        """Limit to the time spent in the search."""
        pass
    @property
    def lns_time_limit(self) -> google.protobuf.duration_pb2.Duration:
        """Limit to the time spent in the completion search for each local search
        neighbor.
        """
        pass
    @property
    def improvement_limit_parameters(self) -> global___RoutingSearchParameters.ImprovementSearchLimitParameters:
        """The improvement search limit is added to the solver if the following
        parameters are set.
        """
        pass
    use_full_propagation: builtins.bool = ...
    """--- Propagation control ---
    These are advanced settings which should not be modified unless you know
    what you are doing.

    Use constraints with full propagation in routing model (instead of 'light'
    propagation only). Full propagation is only necessary when using
    depth-first search or for models which require strong propagation to
    finalize the value of secondary variables.
    Changing this setting to true will slow down the search in most cases and
    increase memory consumption in all cases.
    """

    log_search: builtins.bool = ...
    """--- Miscellaneous ---
    Some of these are advanced settings which should not be modified unless you
    know what you are doing.

    Activates search logging. For each solution found during the search, the
    following will be displayed: its objective value, the maximum objective
    value since the beginning of the search, the elapsed time since the
    beginning of the search, the number of branches explored in the search
    tree, the number of failures in the search tree, the depth of the search
    tree, the number of local search neighbors explored, the number of local
    search neighbors filtered by local search filters, the number of local
    search neighbors accepted, the total memory used and the percentage of the
    search done.
    """

    log_cost_scaling_factor: builtins.float = ...
    """In logs, cost values will be scaled and offset by the given values in the
    following way: log_cost_scaling_factor * (cost + log_cost_offset)
    """

    log_cost_offset: builtins.float = ...
    log_tag: typing.Text = ...
    """In logs, this tag will be appended to each line corresponding to a new
    solution. Useful to sort out logs when several solves are run in parallel.
    """

    def __init__(self,
        *,
        first_solution_strategy : ortools.constraint_solver.routing_enums_pb2.FirstSolutionStrategy.Value.V = ...,
        use_unfiltered_first_solution_strategy : builtins.bool = ...,
        savings_neighbors_ratio : builtins.float = ...,
        savings_max_memory_usage_bytes : builtins.float = ...,
        savings_add_reverse_arcs : builtins.bool = ...,
        savings_arc_coefficient : builtins.float = ...,
        savings_parallel_routes : builtins.bool = ...,
        cheapest_insertion_farthest_seeds_ratio : builtins.float = ...,
        cheapest_insertion_first_solution_neighbors_ratio : builtins.float = ...,
        cheapest_insertion_first_solution_min_neighbors : builtins.int = ...,
        cheapest_insertion_ls_operator_neighbors_ratio : builtins.float = ...,
        cheapest_insertion_ls_operator_min_neighbors : builtins.int = ...,
        cheapest_insertion_first_solution_use_neighbors_ratio_for_initialization : builtins.bool = ...,
        cheapest_insertion_add_unperformed_entries : builtins.bool = ...,
        christofides_use_minimum_matching : builtins.bool = ...,
        local_search_operators : typing.Optional[global___RoutingSearchParameters.LocalSearchNeighborhoodOperators] = ...,
        use_multi_armed_bandit_concatenate_operators : builtins.bool = ...,
        multi_armed_bandit_compound_operator_memory_coefficient : builtins.float = ...,
        multi_armed_bandit_compound_operator_exploration_coefficient : builtins.float = ...,
        relocate_expensive_chain_num_arcs_to_consider : builtins.int = ...,
        heuristic_expensive_chain_lns_num_arcs_to_consider : builtins.int = ...,
        heuristic_close_nodes_lns_num_nodes : builtins.int = ...,
        local_search_metaheuristic : ortools.constraint_solver.routing_enums_pb2.LocalSearchMetaheuristic.Value.V = ...,
        guided_local_search_lambda_coefficient : builtins.float = ...,
        use_depth_first_search : builtins.bool = ...,
        use_cp : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
        use_cp_sat : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
        use_generalized_cp_sat : ortools.util.optional_boolean_pb2.OptionalBoolean.V = ...,
        sat_parameters : typing.Optional[ortools.sat.sat_parameters_pb2.SatParameters] = ...,
        continuous_scheduling_solver : global___RoutingSearchParameters.SchedulingSolver.V = ...,
        mixed_integer_scheduling_solver : global___RoutingSearchParameters.SchedulingSolver.V = ...,
        optimization_step : builtins.float = ...,
        number_of_solutions_to_collect : builtins.int = ...,
        solution_limit : builtins.int = ...,
        time_limit : typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
        lns_time_limit : typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
        improvement_limit_parameters : typing.Optional[global___RoutingSearchParameters.ImprovementSearchLimitParameters] = ...,
        use_full_propagation : builtins.bool = ...,
        log_search : builtins.bool = ...,
        log_cost_scaling_factor : builtins.float = ...,
        log_cost_offset : builtins.float = ...,
        log_tag : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["improvement_limit_parameters",b"improvement_limit_parameters","lns_time_limit",b"lns_time_limit","local_search_operators",b"local_search_operators","sat_parameters",b"sat_parameters","time_limit",b"time_limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cheapest_insertion_add_unperformed_entries",b"cheapest_insertion_add_unperformed_entries","cheapest_insertion_farthest_seeds_ratio",b"cheapest_insertion_farthest_seeds_ratio","cheapest_insertion_first_solution_min_neighbors",b"cheapest_insertion_first_solution_min_neighbors","cheapest_insertion_first_solution_neighbors_ratio",b"cheapest_insertion_first_solution_neighbors_ratio","cheapest_insertion_first_solution_use_neighbors_ratio_for_initialization",b"cheapest_insertion_first_solution_use_neighbors_ratio_for_initialization","cheapest_insertion_ls_operator_min_neighbors",b"cheapest_insertion_ls_operator_min_neighbors","cheapest_insertion_ls_operator_neighbors_ratio",b"cheapest_insertion_ls_operator_neighbors_ratio","christofides_use_minimum_matching",b"christofides_use_minimum_matching","continuous_scheduling_solver",b"continuous_scheduling_solver","first_solution_strategy",b"first_solution_strategy","guided_local_search_lambda_coefficient",b"guided_local_search_lambda_coefficient","heuristic_close_nodes_lns_num_nodes",b"heuristic_close_nodes_lns_num_nodes","heuristic_expensive_chain_lns_num_arcs_to_consider",b"heuristic_expensive_chain_lns_num_arcs_to_consider","improvement_limit_parameters",b"improvement_limit_parameters","lns_time_limit",b"lns_time_limit","local_search_metaheuristic",b"local_search_metaheuristic","local_search_operators",b"local_search_operators","log_cost_offset",b"log_cost_offset","log_cost_scaling_factor",b"log_cost_scaling_factor","log_search",b"log_search","log_tag",b"log_tag","mixed_integer_scheduling_solver",b"mixed_integer_scheduling_solver","multi_armed_bandit_compound_operator_exploration_coefficient",b"multi_armed_bandit_compound_operator_exploration_coefficient","multi_armed_bandit_compound_operator_memory_coefficient",b"multi_armed_bandit_compound_operator_memory_coefficient","number_of_solutions_to_collect",b"number_of_solutions_to_collect","optimization_step",b"optimization_step","relocate_expensive_chain_num_arcs_to_consider",b"relocate_expensive_chain_num_arcs_to_consider","sat_parameters",b"sat_parameters","savings_add_reverse_arcs",b"savings_add_reverse_arcs","savings_arc_coefficient",b"savings_arc_coefficient","savings_max_memory_usage_bytes",b"savings_max_memory_usage_bytes","savings_neighbors_ratio",b"savings_neighbors_ratio","savings_parallel_routes",b"savings_parallel_routes","solution_limit",b"solution_limit","time_limit",b"time_limit","use_cp",b"use_cp","use_cp_sat",b"use_cp_sat","use_depth_first_search",b"use_depth_first_search","use_full_propagation",b"use_full_propagation","use_generalized_cp_sat",b"use_generalized_cp_sat","use_multi_armed_bandit_concatenate_operators",b"use_multi_armed_bandit_concatenate_operators","use_unfiltered_first_solution_strategy",b"use_unfiltered_first_solution_strategy"]) -> None: ...
global___RoutingSearchParameters = RoutingSearchParameters

class RoutingModelParameters(google.protobuf.message.Message):
    """Parameters which have to be set when creating a RoutingModel."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    SOLVER_PARAMETERS_FIELD_NUMBER: builtins.int
    REDUCE_VEHICLE_COST_MODEL_FIELD_NUMBER: builtins.int
    MAX_CALLBACK_CACHE_SIZE_FIELD_NUMBER: builtins.int
    @property
    def solver_parameters(self) -> ortools.constraint_solver.solver_parameters_pb2.ConstraintSolverParameters:
        """Parameters to use in the underlying constraint solver."""
        pass
    reduce_vehicle_cost_model: builtins.bool = ...
    """Advanced settings.
    If set to true reduction of the underlying constraint model will be
    attempted when all vehicles have exactly the same cost structure. This can
    result in significant speedups.
    """

    max_callback_cache_size: builtins.int = ...
    """Cache callback calls if the number of nodes in the model is less or equal
    to this value.
    """

    def __init__(self,
        *,
        solver_parameters : typing.Optional[ortools.constraint_solver.solver_parameters_pb2.ConstraintSolverParameters] = ...,
        reduce_vehicle_cost_model : builtins.bool = ...,
        max_callback_cache_size : builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["solver_parameters",b"solver_parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_callback_cache_size",b"max_callback_cache_size","reduce_vehicle_cost_model",b"reduce_vehicle_cost_model","solver_parameters",b"solver_parameters"]) -> None: ...
global___RoutingModelParameters = RoutingModelParameters
