# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _pywrapcp
else:
    import _pywrapcp

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class DefaultPhaseParameters(object):
    r"""
    This struct holds all parameters for the default search.
    DefaultPhaseParameters is only used by Solver::MakeDefaultPhase methods.
    Note this is for advanced users only.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    CHOOSE_MAX_SUM_IMPACT = _pywrapcp.DefaultPhaseParameters_CHOOSE_MAX_SUM_IMPACT
    CHOOSE_MAX_AVERAGE_IMPACT = _pywrapcp.DefaultPhaseParameters_CHOOSE_MAX_AVERAGE_IMPACT
    CHOOSE_MAX_VALUE_IMPACT = _pywrapcp.DefaultPhaseParameters_CHOOSE_MAX_VALUE_IMPACT
    SELECT_MIN_IMPACT = _pywrapcp.DefaultPhaseParameters_SELECT_MIN_IMPACT
    SELECT_MAX_IMPACT = _pywrapcp.DefaultPhaseParameters_SELECT_MAX_IMPACT
    NONE = _pywrapcp.DefaultPhaseParameters_NONE
    NORMAL = _pywrapcp.DefaultPhaseParameters_NORMAL
    VERBOSE = _pywrapcp.DefaultPhaseParameters_VERBOSE
    var_selection_schema = property(_pywrapcp.DefaultPhaseParameters_var_selection_schema_get, _pywrapcp.DefaultPhaseParameters_var_selection_schema_set, doc=r"""
    This parameter describes how the next variable to instantiate
    will be chosen.
    """)
    value_selection_schema = property(_pywrapcp.DefaultPhaseParameters_value_selection_schema_get, _pywrapcp.DefaultPhaseParameters_value_selection_schema_set, doc=r""" This parameter describes which value to select for a given var.""")
    initialization_splits = property(_pywrapcp.DefaultPhaseParameters_initialization_splits_get, _pywrapcp.DefaultPhaseParameters_initialization_splits_set, doc=r"""
    Maximum number of intervals that the initialization of impacts will scan
    per variable.
    """)
    run_all_heuristics = property(_pywrapcp.DefaultPhaseParameters_run_all_heuristics_get, _pywrapcp.DefaultPhaseParameters_run_all_heuristics_set, doc=r"""
    The default phase will run heuristics periodically. This parameter
    indicates if we should run all heuristics, or a randomly selected
    one.
    """)
    heuristic_period = property(_pywrapcp.DefaultPhaseParameters_heuristic_period_get, _pywrapcp.DefaultPhaseParameters_heuristic_period_set, doc=r"""
    The distance in nodes between each run of the heuristics. A
    negative or null value will mean that we will not run heuristics
    at all.
    """)
    heuristic_num_failures_limit = property(_pywrapcp.DefaultPhaseParameters_heuristic_num_failures_limit_get, _pywrapcp.DefaultPhaseParameters_heuristic_num_failures_limit_set, doc=r""" The failure limit for each heuristic that we run.""")
    persistent_impact = property(_pywrapcp.DefaultPhaseParameters_persistent_impact_get, _pywrapcp.DefaultPhaseParameters_persistent_impact_set, doc=r"""
    Whether to keep the impact from the first search for other searches,
    or to recompute the impact for each new search.
    """)
    random_seed = property(_pywrapcp.DefaultPhaseParameters_random_seed_get, _pywrapcp.DefaultPhaseParameters_random_seed_set, doc=r""" Seed used to initialize the random part in some heuristics.""")
    display_level = property(_pywrapcp.DefaultPhaseParameters_display_level_get, _pywrapcp.DefaultPhaseParameters_display_level_set, doc=r"""
    This represents the amount of information displayed by the default search.
    NONE means no display, VERBOSE means extra information.
    """)
    decision_builder = property(_pywrapcp.DefaultPhaseParameters_decision_builder_get, _pywrapcp.DefaultPhaseParameters_decision_builder_set, doc=r""" When defined, this overrides the default impact based decision builder.""")

    def __init__(self):
        _pywrapcp.DefaultPhaseParameters_swiginit(self, _pywrapcp.new_DefaultPhaseParameters())
    __swig_destroy__ = _pywrapcp.delete_DefaultPhaseParameters

# Register DefaultPhaseParameters in _pywrapcp:
_pywrapcp.DefaultPhaseParameters_swigregister(DefaultPhaseParameters)

class Solver(object):
    r"""
    Solver Class

    A solver represents the main computation engine. It implements the entire
    range of Constraint Programming protocols:
      - Reversibility
      - Propagation
      - Search

    Usually, Constraint Programming code consists of
      - the creation of the Solver,
      - the creation of the decision variables of the model,
      - the creation of the constraints of the model and their addition to the
        solver() through the AddConstraint() method,
      - the creation of the main DecisionBuilder class,
      - the launch of the solve() method with the decision builder.

    For the time being, Solver is neither MT_SAFE nor MT_HOT.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    INT_VAR_DEFAULT = _pywrapcp.Solver_INT_VAR_DEFAULT
    r""" The default behavior is CHOOSE_FIRST_UNBOUND."""
    INT_VAR_SIMPLE = _pywrapcp.Solver_INT_VAR_SIMPLE
    r""" The simple selection is CHOOSE_FIRST_UNBOUND."""
    CHOOSE_FIRST_UNBOUND = _pywrapcp.Solver_CHOOSE_FIRST_UNBOUND
    r"""
    Select the first unbound variable.
    Variables are considered in the order of the vector of IntVars used
    to create the selector.
    """
    CHOOSE_RANDOM = _pywrapcp.Solver_CHOOSE_RANDOM
    r""" Randomly select one of the remaining unbound variables."""
    CHOOSE_MIN_SIZE_LOWEST_MIN = _pywrapcp.Solver_CHOOSE_MIN_SIZE_LOWEST_MIN
    r"""
    Among unbound variables, select the variable with the smallest size,
    i.e., the smallest number of possible values.
    In case of a tie, the selected variables is the one with the lowest min
    value.
    In case of a tie, the first one is selected, first being defined by the
    order in the vector of IntVars used to create the selector.
    """
    CHOOSE_MIN_SIZE_HIGHEST_MIN = _pywrapcp.Solver_CHOOSE_MIN_SIZE_HIGHEST_MIN
    r"""
    Among unbound variables, select the variable with the smallest size,
    i.e., the smallest number of possible values.
    In case of a tie, the selected variable is the one with the highest min
    value.
    In case of a tie, the first one is selected, first being defined by the
    order in the vector of IntVars used to create the selector.
    """
    CHOOSE_MIN_SIZE_LOWEST_MAX = _pywrapcp.Solver_CHOOSE_MIN_SIZE_LOWEST_MAX
    r"""
    Among unbound variables, select the variable with the smallest size,
    i.e., the smallest number of possible values.
    In case of a tie, the selected variables is the one with the lowest max
    value.
    In case of a tie, the first one is selected, first being defined by the
    order in the vector of IntVars used to create the selector.
    """
    CHOOSE_MIN_SIZE_HIGHEST_MAX = _pywrapcp.Solver_CHOOSE_MIN_SIZE_HIGHEST_MAX
    r"""
    Among unbound variables, select the variable with the smallest size,
    i.e., the smallest number of possible values.
    In case of a tie, the selected variable is the one with the highest max
    value.
    In case of a tie, the first one is selected, first being defined by the
    order in the vector of IntVars used to create the selector.
    """
    CHOOSE_LOWEST_MIN = _pywrapcp.Solver_CHOOSE_LOWEST_MIN
    r"""
    Among unbound variables, select the variable with the smallest minimal
    value.
    In case of a tie, the first one is selected, "first" defined by the
    order in the vector of IntVars used to create the selector.
    """
    CHOOSE_HIGHEST_MAX = _pywrapcp.Solver_CHOOSE_HIGHEST_MAX
    r"""
    Among unbound variables, select the variable with the highest maximal
    value.
    In case of a tie, the first one is selected, first being defined by the
    order in the vector of IntVars used to create the selector.
    """
    CHOOSE_MIN_SIZE = _pywrapcp.Solver_CHOOSE_MIN_SIZE
    r"""
    Among unbound variables, select the variable with the smallest size.
    In case of a tie, the first one is selected, first being defined by the
    order in the vector of IntVars used to create the selector.
    """
    CHOOSE_MAX_SIZE = _pywrapcp.Solver_CHOOSE_MAX_SIZE
    r"""
    Among unbound variables, select the variable with the highest size.
    In case of a tie, the first one is selected, first being defined by the
    order in the vector of IntVars used to create the selector.
    """
    CHOOSE_MAX_REGRET_ON_MIN = _pywrapcp.Solver_CHOOSE_MAX_REGRET_ON_MIN
    r"""
    Among unbound variables, select the variable with the largest
    gap between the first and the second values of the domain.
    """
    CHOOSE_PATH = _pywrapcp.Solver_CHOOSE_PATH
    r"""
    Selects the next unbound variable on a path, the path being defined by
    the variables: var[i] corresponds to the index of the next of i.
    """
    INT_VALUE_DEFAULT = _pywrapcp.Solver_INT_VALUE_DEFAULT
    r""" The default behavior is ASSIGN_MIN_VALUE."""
    INT_VALUE_SIMPLE = _pywrapcp.Solver_INT_VALUE_SIMPLE
    r""" The simple selection is ASSIGN_MIN_VALUE."""
    ASSIGN_MIN_VALUE = _pywrapcp.Solver_ASSIGN_MIN_VALUE
    r""" Selects the min value of the selected variable."""
    ASSIGN_MAX_VALUE = _pywrapcp.Solver_ASSIGN_MAX_VALUE
    r""" Selects the max value of the selected variable."""
    ASSIGN_RANDOM_VALUE = _pywrapcp.Solver_ASSIGN_RANDOM_VALUE
    r""" Selects randomly one of the possible values of the selected variable."""
    ASSIGN_CENTER_VALUE = _pywrapcp.Solver_ASSIGN_CENTER_VALUE
    r"""
    Selects the first possible value which is the closest to the center
    of the domain of the selected variable.
    The center is defined as (min + max) / 2.
    """
    SPLIT_LOWER_HALF = _pywrapcp.Solver_SPLIT_LOWER_HALF
    r"""
    Split the domain in two around the center, and choose the lower
    part first.
    """
    SPLIT_UPPER_HALF = _pywrapcp.Solver_SPLIT_UPPER_HALF
    r"""
    Split the domain in two around the center, and choose the lower
    part first.
    """
    SEQUENCE_DEFAULT = _pywrapcp.Solver_SEQUENCE_DEFAULT
    SEQUENCE_SIMPLE = _pywrapcp.Solver_SEQUENCE_SIMPLE
    CHOOSE_MIN_SLACK_RANK_FORWARD = _pywrapcp.Solver_CHOOSE_MIN_SLACK_RANK_FORWARD
    CHOOSE_RANDOM_RANK_FORWARD = _pywrapcp.Solver_CHOOSE_RANDOM_RANK_FORWARD
    INTERVAL_DEFAULT = _pywrapcp.Solver_INTERVAL_DEFAULT
    r""" The default is INTERVAL_SET_TIMES_FORWARD."""
    INTERVAL_SIMPLE = _pywrapcp.Solver_INTERVAL_SIMPLE
    r""" The simple is INTERVAL_SET_TIMES_FORWARD."""
    INTERVAL_SET_TIMES_FORWARD = _pywrapcp.Solver_INTERVAL_SET_TIMES_FORWARD
    r"""
    Selects the variable with the lowest starting time of all variables,
    and fixes its starting time to this lowest value.
    """
    INTERVAL_SET_TIMES_BACKWARD = _pywrapcp.Solver_INTERVAL_SET_TIMES_BACKWARD
    r"""
    Selects the variable with the highest ending time of all variables,
    and fixes the ending time to this highest values.
    """
    TWOOPT = _pywrapcp.Solver_TWOOPT
    r"""
    Operator which reverses a sub-chain of a path. It is called TwoOpt
    because it breaks two arcs on the path; resulting paths are called
    two-optimal.
    Possible neighbors for the path 1 -> 2 -> 3 -> 4 -> 5
    (where (1, 5) are first and last nodes of the path and can therefore not
    be moved):
      1 -> [3 -> 2] -> 4  -> 5
      1 -> [4 -> 3  -> 2] -> 5
      1 ->  2 -> [4 -> 3] -> 5
    """
    OROPT = _pywrapcp.Solver_OROPT
    r"""
    Relocate: OROPT and RELOCATE.
    Operator which moves a sub-chain of a path to another position; the
    specified chain length is the fixed length of the chains being moved.
    When this length is 1, the operator simply moves a node to another
    position.
    Possible neighbors for the path 1 -> 2 -> 3 -> 4 -> 5, for a chain
    length of 2 (where (1, 5) are first and last nodes of the path and can
    therefore not be moved):
      1 ->  4 -> [2 -> 3] -> 5
      1 -> [3 -> 4] -> 2  -> 5

    Using Relocate with chain lengths of 1, 2 and 3 together is equivalent
    to the OrOpt operator on a path. The OrOpt operator is a limited
     version of 3Opt (breaks 3 arcs on a path).
    """
    RELOCATE = _pywrapcp.Solver_RELOCATE
    r""" Relocate neighborhood with length of 1 (see OROPT comment)."""
    EXCHANGE = _pywrapcp.Solver_EXCHANGE
    r"""
    Operator which exchanges the positions of two nodes.
    Possible neighbors for the path 1 -> 2 -> 3 -> 4 -> 5
    (where (1, 5) are first and last nodes of the path and can therefore not
    be moved):
      1 -> [3] -> [2] ->  4  -> 5
      1 -> [4] ->  3  -> [2] -> 5
      1 ->  2  -> [4] -> [3] -> 5
    """
    CROSS = _pywrapcp.Solver_CROSS
    r"""
    Operator which cross exchanges the starting chains of 2 paths, including
    exchanging the whole paths.
    First and last nodes are not moved.
    Possible neighbors for the paths 1 -> 2 -> 3 -> 4 -> 5 and 6 -> 7 -> 8
    (where (1, 5) and (6, 8) are first and last nodes of the paths and can
    therefore not be moved):
      1 -> [7] -> 3 -> 4 -> 5  6 -> [2] -> 8
      1 -> [7] -> 4 -> 5       6 -> [2 -> 3] -> 8
      1 -> [7] -> 5            6 -> [2 -> 3 -> 4] -> 8
    """
    MAKEACTIVE = _pywrapcp.Solver_MAKEACTIVE
    r"""
    Operator which inserts an inactive node into a path.
    Possible neighbors for the path 1 -> 2 -> 3 -> 4 with 5 inactive
    (where 1 and 4 are first and last nodes of the path) are:
      1 -> [5] ->  2  ->  3  -> 4
      1 ->  2  -> [5] ->  3  -> 4
      1 ->  2  ->  3  -> [5] -> 4
    """
    MAKEINACTIVE = _pywrapcp.Solver_MAKEINACTIVE
    r"""
    Operator which makes path nodes inactive.
    Possible neighbors for the path 1 -> 2 -> 3 -> 4 (where 1 and 4 are
    first and last nodes of the path) are:
      1 -> 3 -> 4 with 2 inactive
      1 -> 2 -> 4 with 3 inactive
    """
    MAKECHAININACTIVE = _pywrapcp.Solver_MAKECHAININACTIVE
    r"""
    Operator which makes a "chain" of path nodes inactive.
    Possible neighbors for the path 1 -> 2 -> 3 -> 4 (where 1 and 4 are
    first and last nodes of the path) are:
      1 -> 3 -> 4 with 2 inactive
      1 -> 2 -> 4 with 3 inactive
      1 -> 4 with 2 and 3 inactive
    """
    SWAPACTIVE = _pywrapcp.Solver_SWAPACTIVE
    r"""
    Operator which replaces an active node by an inactive one.
    Possible neighbors for the path 1 -> 2 -> 3 -> 4 with 5 inactive
    (where 1 and 4 are first and last nodes of the path) are:
      1 -> [5] ->  3  -> 4 with 2 inactive
      1 ->  2  -> [5] -> 4 with 3 inactive
    """
    EXTENDEDSWAPACTIVE = _pywrapcp.Solver_EXTENDEDSWAPACTIVE
    r"""
    Operator which makes an inactive node active and an active one inactive.
    It is similar to SwapActiveOperator except that it tries to insert the
    inactive node in all possible positions instead of just the position of
    the node made inactive.
    Possible neighbors for the path 1 -> 2 -> 3 -> 4 with 5 inactive
    (where 1 and 4 are first and last nodes of the path) are:
      1 -> [5] ->  3  -> 4 with 2 inactive
      1 ->  3  -> [5] -> 4 with 2 inactive
      1 -> [5] ->  2  -> 4 with 3 inactive
      1 ->  2  -> [5] -> 4 with 3 inactive
    """
    PATHLNS = _pywrapcp.Solver_PATHLNS
    r"""
    Operator which relaxes two sub-chains of three consecutive arcs each.
    Each sub-chain is defined by a start node and the next three arcs. Those
    six arcs are relaxed to build a new neighbor.
    PATHLNS explores all possible pairs of starting nodes and so defines
    n^2 neighbors, n being the number of nodes.
    Note that the two sub-chains can be part of the same path; they even may
    overlap.
    """
    FULLPATHLNS = _pywrapcp.Solver_FULLPATHLNS
    r"""
    Operator which relaxes one entire path and all inactive nodes, thus
    defining num_paths neighbors.
    """
    UNACTIVELNS = _pywrapcp.Solver_UNACTIVELNS
    r"""
    Operator which relaxes all inactive nodes and one sub-chain of six
    consecutive arcs. That way the path can be improved by inserting
    inactive nodes or swapping arcs.
    """
    INCREMENT = _pywrapcp.Solver_INCREMENT
    r"""
    Operator which defines one neighbor per variable. Each neighbor tries to
    increment by one the value of the corresponding variable. When a new
    solution is found the neighborhood is rebuilt from scratch, i.e., tries
    to increment values in the variable order.
    Consider for instance variables x and y. x is incremented one by one to
    its max, and when it is not possible to increment x anymore, y is
    incremented once. If this is a solution, then next neighbor tries to
    increment x.
    """
    DECREMENT = _pywrapcp.Solver_DECREMENT
    r"""
    Operator which defines a neighborhood to decrement values.
    The behavior is the same as INCREMENT, except values are decremented
    instead of incremented.
    """
    SIMPLELNS = _pywrapcp.Solver_SIMPLELNS
    r"""
    Operator which defines one neighbor per variable. Each neighbor relaxes
    one variable.
    When a new solution is found the neighborhood is rebuilt from scratch.
    Consider for instance variables x and y. First x is relaxed and the
    solver is looking for the best possible solution (with only x relaxed).
    Then y is relaxed, and the solver is looking for a new solution.
    If a new solution is found, then the next variable to be relaxed is x.
    """
    GE = _pywrapcp.Solver_GE
    r""" Move is accepted when the current objective value >= objective.Min."""
    LE = _pywrapcp.Solver_LE
    r""" Move is accepted when the current objective value <= objective.Max."""
    EQ = _pywrapcp.Solver_EQ
    r"""
    Move is accepted when the current objective value is in the interval
    objective.Min .. objective.Max.
    """
    DELAYED_PRIORITY = _pywrapcp.Solver_DELAYED_PRIORITY
    r"""
    DELAYED_PRIORITY is the lowest priority: Demons will be processed after
    VAR_PRIORITY and NORMAL_PRIORITY demons.
    """
    VAR_PRIORITY = _pywrapcp.Solver_VAR_PRIORITY
    r""" VAR_PRIORITY is between DELAYED_PRIORITY and NORMAL_PRIORITY."""
    NORMAL_PRIORITY = _pywrapcp.Solver_NORMAL_PRIORITY
    r""" NORMAL_PRIORITY is the highest priority: Demons will be processed first."""

    def __init__(self, *args):
        _pywrapcp.Solver_swiginit(self, _pywrapcp.new_Solver(*args))

        self.__python_constraints = []



    __swig_destroy__ = _pywrapcp.delete_Solver

    def Parameters(self) -> "operations_research::ConstraintSolverParameters":
        r""" Stored Parameters."""
        return _pywrapcp.Solver_Parameters(self)

    @staticmethod
    def DefaultSolverParameters() -> "operations_research::ConstraintSolverParameters":
        r""" Create a ConstraintSolverParameters proto with all the default values."""
        return _pywrapcp.Solver_DefaultSolverParameters()

    def AddConstraint(self, c: "Constraint") -> "void":
        r"""
        Adds the constraint 'c' to the model.

        After calling this method, and until there is a backtrack that undoes the
        addition, any assignment of variables to values must satisfy the given
        constraint in order to be considered feasible. There are two fairly
        different use cases:

        - the most common use case is modeling: the given constraint is really
        part of the problem that the user is trying to solve. In this use case,
        AddConstraint is called outside of search (i.e., with state() ==
        OUTSIDE_SEARCH). Most users should only use AddConstraint in this
        way. In this case, the constraint will belong to the model forever: it
        cannot not be removed by backtracking.

        - a rarer use case is that 'c' is not a real constraint of the model. It
        may be a constraint generated by a branching decision (a constraint whose
        goal is to restrict the search space), a symmetry breaking constraint (a
        constraint that does restrict the search space, but in a way that cannot
        have an impact on the quality of the solutions in the subtree), or an
        inferred constraint that, while having no semantic value to the model (it
        does not restrict the set of solutions), is worth having because we
        believe it may strengthen the propagation. In these cases, it happens
        that the constraint is added during the search (i.e., with state() ==
        IN_SEARCH or state() == IN_ROOT_NODE). When a constraint is
        added during a search, it applies only to the subtree of the search tree
        rooted at the current node, and will be automatically removed by
        backtracking.

        This method does not take ownership of the constraint. If the constraint
        has been created by any factory method (Solver::MakeXXX), it will
        automatically be deleted. However, power users who implement their own
        constraints should do: solver.AddConstraint(solver.RevAlloc(new
        MyConstraint(...));
        """
        return _pywrapcp.Solver_AddConstraint(self, c)

    def Solve(self, *args) -> "bool":
        return _pywrapcp.Solver_Solve(self, *args)

    def NewSearch(self, *args) -> "void":
        return _pywrapcp.Solver_NewSearch(self, *args)

    def NextSolution(self) -> "bool":
        return _pywrapcp.Solver_NextSolution(self)

    def RestartSearch(self) -> "void":
        return _pywrapcp.Solver_RestartSearch(self)

    def EndSearch(self) -> "void":
        return _pywrapcp.Solver_EndSearch(self)

    def SolveAndCommit(self, *args) -> "bool":
        return _pywrapcp.Solver_SolveAndCommit(self, *args)

    def CheckAssignment(self, solution: "Assignment") -> "bool":
        r""" Checks whether the given assignment satisfies all relevant constraints."""
        return _pywrapcp.Solver_CheckAssignment(self, solution)

    def CheckConstraint(self, ct: "Constraint") -> "bool":
        r"""
        Checks whether adding this constraint will lead to an immediate
        failure. It will return false if the model is already inconsistent, or if
        adding the constraint makes it inconsistent.
        """
        return _pywrapcp.Solver_CheckConstraint(self, ct)

    def Fail(self) -> "void":
        r""" Abandon the current branch in the search tree. A backtrack will follow."""
        return _pywrapcp.Solver_Fail(self)

    @staticmethod
    def MemoryUsage() -> "int64_t":
        r""" Current memory usage in bytes"""
        return _pywrapcp.Solver_MemoryUsage()

    def WallTime(self) -> "int64_t":
        r"""
        DEPRECATED: Use Now() instead.
        Time elapsed, in ms since the creation of the solver.
        """
        return _pywrapcp.Solver_WallTime(self)

    def Branches(self) -> "int64_t":
        r""" The number of branches explored since the creation of the solver."""
        return _pywrapcp.Solver_Branches(self)

    def Solutions(self) -> "int64_t":
        r""" The number of solutions found since the start of the search."""
        return _pywrapcp.Solver_Solutions(self)

    def Failures(self) -> "int64_t":
        r""" The number of failures encountered since the creation of the solver."""
        return _pywrapcp.Solver_Failures(self)

    def AcceptedNeighbors(self) -> "int64_t":
        r""" The number of accepted neighbors."""
        return _pywrapcp.Solver_AcceptedNeighbors(self)

    def Stamp(self) -> "uint64_t":
        r"""
        The stamp indicates how many moves in the search tree we have performed.
        It is useful to detect if we need to update same lazy structures.
        """
        return _pywrapcp.Solver_Stamp(self)

    def FailStamp(self) -> "uint64_t":
        r""" The fail_stamp() is incremented after each backtrack."""
        return _pywrapcp.Solver_FailStamp(self)

    def IntVar(self, *args) -> "operations_research::IntVar *":
        r"""
        *Overload 1:*
        MakeIntVar will create the best range based int var for the bounds given.

        |

        *Overload 2:*
        MakeIntVar will create a variable with the given sparse domain.

        |

        *Overload 3:*
        MakeIntVar will create a variable with the given sparse domain.

        |

        *Overload 4:*
        MakeIntVar will create the best range based int var for the bounds given.

        |

        *Overload 5:*
        MakeIntVar will create a variable with the given sparse domain.

        |

        *Overload 6:*
        MakeIntVar will create a variable with the given sparse domain.
        """
        return _pywrapcp.Solver_IntVar(self, *args)

    def BoolVar(self, *args) -> "operations_research::IntVar *":
        r"""
        *Overload 1:*
        MakeBoolVar will create a variable with a {0, 1} domain.

        |

        *Overload 2:*
        MakeBoolVar will create a variable with a {0, 1} domain.
        """
        return _pywrapcp.Solver_BoolVar(self, *args)

    def IntConst(self, *args) -> "operations_research::IntVar *":
        r"""
        *Overload 1:*
        IntConst will create a constant expression.

        |

        *Overload 2:*
        IntConst will create a constant expression.
        """
        return _pywrapcp.Solver_IntConst(self, *args)

    def Sum(self, vars: "std::vector< operations_research::IntVar * > const &") -> "operations_research::IntExpr *":
        r""" sum of all vars."""
        return _pywrapcp.Solver_Sum(self, vars)

    def ScalProd(self, *args) -> "operations_research::IntExpr *":
        r"""
        *Overload 1:*
        scalar product

        |

        *Overload 2:*
        scalar product
        """
        return _pywrapcp.Solver_ScalProd(self, *args)

    def MonotonicElement(self, values: "operations_research::Solver::IndexEvaluator1", increasing: "bool", index: "IntVar") -> "operations_research::IntExpr *":
        r"""
        Function based element. The constraint takes ownership of the
        callback.  The callback must be monotonic. It must be able to
        cope with any possible value in the domain of 'index'
        (potentially negative ones too). Furtermore, monotonicity is not
        checked. Thus giving a non-monotonic function, or specifying an
        incorrect increasing parameter will result in undefined behavior.
        """
        return _pywrapcp.Solver_MonotonicElement(self, values, increasing, index)

    def Element(self, *args) -> "operations_research::IntExpr *":
        r"""
        *Overload 1:*
        values[index]

        |

        *Overload 2:*
        values[index]

        |

        *Overload 3:*
        Function-based element. The constraint takes ownership of the
        callback. The callback must be able to cope with any possible
        value in the domain of 'index' (potentially negative ones too).

        |

        *Overload 4:*
        2D version of function-based element expression, values(expr1, expr2).

        |

        *Overload 5:*
        vars[expr]
        """
        return _pywrapcp.Solver_Element(self, *args)

    def IndexExpression(self, vars: "std::vector< operations_research::IntVar * > const &", value: "int64_t") -> "operations_research::IntExpr *":
        r"""
        Returns the expression expr such that vars[expr] == value.
        It assumes that vars are all different.
        """
        return _pywrapcp.Solver_IndexExpression(self, vars, value)

    def Min(self, *args) -> "operations_research::IntExpr *":
        r"""
        *Overload 1:*
        std::min(vars)

        |

        *Overload 2:*
        std::min (left, right)

        |

        *Overload 3:*
        std::min(expr, value)

        |

        *Overload 4:*
        std::min(expr, value)
        """
        return _pywrapcp.Solver_Min(self, *args)

    def Max(self, *args) -> "operations_research::IntExpr *":
        r"""
        *Overload 1:*
        std::max(vars)

        |

        *Overload 2:*
        std::max(left, right)

        |

        *Overload 3:*
        std::max(expr, value)

        |

        *Overload 4:*
        std::max(expr, value)
        """
        return _pywrapcp.Solver_Max(self, *args)

    def ConvexPiecewiseExpr(self, expr: "IntExpr", early_cost: "int64_t", early_date: "int64_t", late_date: "int64_t", late_cost: "int64_t") -> "operations_research::IntExpr *":
        r""" Convex piecewise function."""
        return _pywrapcp.Solver_ConvexPiecewiseExpr(self, expr, early_cost, early_date, late_date, late_cost)

    def SemiContinuousExpr(self, expr: "IntExpr", fixed_charge: "int64_t", step: "int64_t") -> "operations_research::IntExpr *":
        r"""
        Semi continuous Expression (x <= 0 -> f(x) = 0; x > 0 -> f(x) = ax + b)
        a >= 0 and b >= 0
        """
        return _pywrapcp.Solver_SemiContinuousExpr(self, expr, fixed_charge, step)

    def ConditionalExpression(self, condition: "IntVar", expr: "IntExpr", unperformed_value: "int64_t") -> "operations_research::IntExpr *":
        r""" Conditional Expr condition ? expr : unperformed_value"""
        return _pywrapcp.Solver_ConditionalExpression(self, condition, expr, unperformed_value)

    def TrueConstraint(self) -> "operations_research::Constraint *":
        r""" This constraint always succeeds."""
        return _pywrapcp.Solver_TrueConstraint(self)

    def FalseConstraint(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_FalseConstraint(self, *args)

    def IsEqualCstCt(self, var: "IntExpr", value: "int64_t", boolvar: "IntVar") -> "operations_research::Constraint *":
        r""" boolvar == (var == value)"""
        return _pywrapcp.Solver_IsEqualCstCt(self, var, value, boolvar)

    def IsEqualCstVar(self, var: "IntExpr", value: "int64_t") -> "operations_research::IntVar *":
        r""" status var of (var == value)"""
        return _pywrapcp.Solver_IsEqualCstVar(self, var, value)

    def IsEqualCt(self, v1: "IntExpr", v2: "IntExpr", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (v1 == v2)"""
        return _pywrapcp.Solver_IsEqualCt(self, v1, v2, b)

    def IsEqualVar(self, v1: "IntExpr", v2: "IntExpr") -> "operations_research::IntVar *":
        r""" status var of (v1 == v2)"""
        return _pywrapcp.Solver_IsEqualVar(self, v1, v2)

    def IsDifferentCstCt(self, var: "IntExpr", value: "int64_t", boolvar: "IntVar") -> "operations_research::Constraint *":
        r""" boolvar == (var != value)"""
        return _pywrapcp.Solver_IsDifferentCstCt(self, var, value, boolvar)

    def IsDifferentCstVar(self, var: "IntExpr", value: "int64_t") -> "operations_research::IntVar *":
        r""" status var of (var != value)"""
        return _pywrapcp.Solver_IsDifferentCstVar(self, var, value)

    def IsDifferentVar(self, v1: "IntExpr", v2: "IntExpr") -> "operations_research::IntVar *":
        r""" status var of (v1 != v2)"""
        return _pywrapcp.Solver_IsDifferentVar(self, v1, v2)

    def IsDifferentCt(self, v1: "IntExpr", v2: "IntExpr", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (v1 != v2)"""
        return _pywrapcp.Solver_IsDifferentCt(self, v1, v2, b)

    def IsLessOrEqualCstCt(self, var: "IntExpr", value: "int64_t", boolvar: "IntVar") -> "operations_research::Constraint *":
        r""" boolvar == (var <= value)"""
        return _pywrapcp.Solver_IsLessOrEqualCstCt(self, var, value, boolvar)

    def IsLessOrEqualCstVar(self, var: "IntExpr", value: "int64_t") -> "operations_research::IntVar *":
        r""" status var of (var <= value)"""
        return _pywrapcp.Solver_IsLessOrEqualCstVar(self, var, value)

    def IsLessOrEqualVar(self, left: "IntExpr", right: "IntExpr") -> "operations_research::IntVar *":
        r""" status var of (left <= right)"""
        return _pywrapcp.Solver_IsLessOrEqualVar(self, left, right)

    def IsLessOrEqualCt(self, left: "IntExpr", right: "IntExpr", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (left <= right)"""
        return _pywrapcp.Solver_IsLessOrEqualCt(self, left, right, b)

    def IsGreaterOrEqualCstCt(self, var: "IntExpr", value: "int64_t", boolvar: "IntVar") -> "operations_research::Constraint *":
        r""" boolvar == (var >= value)"""
        return _pywrapcp.Solver_IsGreaterOrEqualCstCt(self, var, value, boolvar)

    def IsGreaterOrEqualCstVar(self, var: "IntExpr", value: "int64_t") -> "operations_research::IntVar *":
        r""" status var of (var >= value)"""
        return _pywrapcp.Solver_IsGreaterOrEqualCstVar(self, var, value)

    def IsGreaterOrEqualVar(self, left: "IntExpr", right: "IntExpr") -> "operations_research::IntVar *":
        r""" status var of (left >= right)"""
        return _pywrapcp.Solver_IsGreaterOrEqualVar(self, left, right)

    def IsGreaterOrEqualCt(self, left: "IntExpr", right: "IntExpr", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (left >= right)"""
        return _pywrapcp.Solver_IsGreaterOrEqualCt(self, left, right, b)

    def IsGreaterCstCt(self, v: "IntExpr", c: "int64_t", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (v > c)"""
        return _pywrapcp.Solver_IsGreaterCstCt(self, v, c, b)

    def IsGreaterCstVar(self, var: "IntExpr", value: "int64_t") -> "operations_research::IntVar *":
        r""" status var of (var > value)"""
        return _pywrapcp.Solver_IsGreaterCstVar(self, var, value)

    def IsGreaterVar(self, left: "IntExpr", right: "IntExpr") -> "operations_research::IntVar *":
        r""" status var of (left > right)"""
        return _pywrapcp.Solver_IsGreaterVar(self, left, right)

    def IsGreaterCt(self, left: "IntExpr", right: "IntExpr", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (left > right)"""
        return _pywrapcp.Solver_IsGreaterCt(self, left, right, b)

    def IsLessCstCt(self, v: "IntExpr", c: "int64_t", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (v < c)"""
        return _pywrapcp.Solver_IsLessCstCt(self, v, c, b)

    def IsLessCstVar(self, var: "IntExpr", value: "int64_t") -> "operations_research::IntVar *":
        r""" status var of (var < value)"""
        return _pywrapcp.Solver_IsLessCstVar(self, var, value)

    def IsLessVar(self, left: "IntExpr", right: "IntExpr") -> "operations_research::IntVar *":
        r""" status var of (left < right)"""
        return _pywrapcp.Solver_IsLessVar(self, left, right)

    def IsLessCt(self, left: "IntExpr", right: "IntExpr", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (left < right)"""
        return _pywrapcp.Solver_IsLessCt(self, left, right, b)

    def SumLessOrEqual(self, vars: "std::vector< operations_research::IntVar * > const &", cst: "int64_t") -> "operations_research::Constraint *":
        r""" Variation on arrays."""
        return _pywrapcp.Solver_SumLessOrEqual(self, vars, cst)

    def SumGreaterOrEqual(self, vars: "std::vector< operations_research::IntVar * > const &", cst: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.Solver_SumGreaterOrEqual(self, vars, cst)

    def SumEquality(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_SumEquality(self, *args)

    def ScalProdEquality(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_ScalProdEquality(self, *args)

    def ScalProdGreaterOrEqual(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_ScalProdGreaterOrEqual(self, *args)

    def ScalProdLessOrEqual(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_ScalProdLessOrEqual(self, *args)

    def MinEquality(self, vars: "std::vector< operations_research::IntVar * > const &", min_var: "IntVar") -> "operations_research::Constraint *":
        return _pywrapcp.Solver_MinEquality(self, vars, min_var)

    def MaxEquality(self, vars: "std::vector< operations_research::IntVar * > const &", max_var: "IntVar") -> "operations_research::Constraint *":
        return _pywrapcp.Solver_MaxEquality(self, vars, max_var)

    def ElementEquality(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_ElementEquality(self, *args)

    def AbsEquality(self, var: "IntVar", abs_var: "IntVar") -> "operations_research::Constraint *":
        r""" Creates the constraint abs(var) == abs_var."""
        return _pywrapcp.Solver_AbsEquality(self, var, abs_var)

    def IndexOfConstraint(self, vars: "std::vector< operations_research::IntVar * > const &", index: "IntVar", target: "int64_t") -> "operations_research::Constraint *":
        r"""
        This constraint is a special case of the element constraint with
        an array of integer variables, where the variables are all
        different and the index variable is constrained such that
        vars[index] == target.
        """
        return _pywrapcp.Solver_IndexOfConstraint(self, vars, index, target)

    def ConstraintInitialPropagateCallback(self, ct: "Constraint") -> "operations_research::Demon *":
        r"""
        This method is a specialized case of the MakeConstraintDemon
        method to call the InitiatePropagate of the constraint 'ct'.
        """
        return _pywrapcp.Solver_ConstraintInitialPropagateCallback(self, ct)

    def DelayedConstraintInitialPropagateCallback(self, ct: "Constraint") -> "operations_research::Demon *":
        r"""
        This method is a specialized case of the MakeConstraintDemon
        method to call the InitiatePropagate of the constraint 'ct' with
        low priority.
        """
        return _pywrapcp.Solver_DelayedConstraintInitialPropagateCallback(self, ct)

    def ClosureDemon(self, closure: "operations_research::Solver::Closure") -> "operations_research::Demon *":
        r""" Creates a demon from a closure."""
        return _pywrapcp.Solver_ClosureDemon(self, closure)

    def BetweenCt(self, expr: "IntExpr", l: "int64_t", u: "int64_t") -> "operations_research::Constraint *":
        r""" (l <= expr <= u)"""
        return _pywrapcp.Solver_BetweenCt(self, expr, l, u)

    def IsBetweenCt(self, expr: "IntExpr", l: "int64_t", u: "int64_t", b: "IntVar") -> "operations_research::Constraint *":
        r""" b == (l <= expr <= u)"""
        return _pywrapcp.Solver_IsBetweenCt(self, expr, l, u, b)

    def IsBetweenVar(self, v: "IntExpr", l: "int64_t", u: "int64_t") -> "operations_research::IntVar *":
        return _pywrapcp.Solver_IsBetweenVar(self, v, l, u)

    def MemberCt(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_MemberCt(self, *args)

    def NotMemberCt(self, *args) -> "operations_research::Constraint *":
        r"""
        *Overload 1:*
        expr not in set.

        |

        *Overload 2:*
        expr should not be in the list of forbidden intervals [start[i]..end[i]].

        |

        *Overload 3:*
        expr should not be in the list of forbidden intervals [start[i]..end[i]].
        """
        return _pywrapcp.Solver_NotMemberCt(self, *args)

    def IsMemberCt(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_IsMemberCt(self, *args)

    def IsMemberVar(self, *args) -> "operations_research::IntVar *":
        return _pywrapcp.Solver_IsMemberVar(self, *args)

    def Count(self, *args) -> "operations_research::Constraint *":
        r"""
        *Overload 1:*
        |{i | vars[i] == value}| == max_count

        |

        *Overload 2:*
        |{i | vars[i] == value}| == max_count
        """
        return _pywrapcp.Solver_Count(self, *args)

    def Distribute(self, *args) -> "operations_research::Constraint *":
        r"""
        *Overload 1:*
        Aggregated version of count:  |{i | v[i] == values[j]}| == cards[j]

        |

        *Overload 2:*
        Aggregated version of count:  |{i | v[i] == values[j]}| == cards[j]

        |

        *Overload 3:*
        Aggregated version of count:  |{i | v[i] == j}| == cards[j]

        |

        *Overload 4:*
        Aggregated version of count with bounded cardinalities:
        forall j in 0 .. card_size - 1: card_min <= |{i | v[i] == j}| <= card_max

        |

        *Overload 5:*
        Aggregated version of count with bounded cardinalities:
        forall j in 0 .. card_size - 1:
           card_min[j] <= |{i | v[i] == j}| <= card_max[j]

        |

        *Overload 6:*
        Aggregated version of count with bounded cardinalities:
        forall j in 0 .. card_size - 1:
           card_min[j] <= |{i | v[i] == j}| <= card_max[j]

        |

        *Overload 7:*
        Aggregated version of count with bounded cardinalities:
        forall j in 0 .. card_size - 1:
           card_min[j] <= |{i | v[i] == values[j]}| <= card_max[j]

        |

        *Overload 8:*
        Aggregated version of count with bounded cardinalities:
        forall j in 0 .. card_size - 1:
           card_min[j] <= |{i | v[i] == values[j]}| <= card_max[j]
        """
        return _pywrapcp.Solver_Distribute(self, *args)

    def Deviation(self, vars: "std::vector< operations_research::IntVar * > const &", deviation_var: "IntVar", total_sum: "int64_t") -> "operations_research::Constraint *":
        r"""
        Deviation constraint:
        sum_i |n * vars[i] - total_sum| <= deviation_var and
        sum_i vars[i] == total_sum
        n = #vars
        """
        return _pywrapcp.Solver_Deviation(self, vars, deviation_var, total_sum)

    def AllDifferent(self, *args) -> "operations_research::Constraint *":
        r"""
        *Overload 1:*
        All variables are pairwise different. This corresponds to the
        stronger version of the propagation algorithm.

        |

        *Overload 2:*
        All variables are pairwise different.  If 'stronger_propagation'
        is true, stronger, and potentially slower propagation will
        occur. This API will be deprecated in the future.
        """
        return _pywrapcp.Solver_AllDifferent(self, *args)

    def AllDifferentExcept(self, vars: "std::vector< operations_research::IntVar * > const &", escape_value: "int64_t") -> "operations_research::Constraint *":
        r"""
        All variables are pairwise different, unless they are assigned to
        the escape value.
        """
        return _pywrapcp.Solver_AllDifferentExcept(self, vars, escape_value)

    def SortingConstraint(self, vars: "std::vector< operations_research::IntVar * > const &", sorted: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        r"""
        Creates a constraint binding the arrays of variables "vars" and
        "sorted_vars": sorted_vars[0] must be equal to the minimum of all
        variables in vars, and so on: the value of sorted_vars[i] must be
        equal to the i-th value of variables invars.

        This constraint propagates in both directions: from "vars" to
        "sorted_vars" and vice-versa.

        Behind the scenes, this constraint maintains that:
          - sorted is always increasing.
          - whatever the values of vars, there exists a permutation that
            injects its values into the sorted variables.

        For more info, please have a look at:
          https://mpi-inf.mpg.de/~mehlhorn/ftp/Mehlhorn-Thiel.pdf
        """
        return _pywrapcp.Solver_SortingConstraint(self, vars, sorted)

    def LexicalLess(self, left: "std::vector< operations_research::IntVar * > const &", right: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        r"""
        Creates a constraint that enforces that left is lexicographically less
        than right.
        """
        return _pywrapcp.Solver_LexicalLess(self, left, right)

    def LexicalLessOrEqual(self, left: "std::vector< operations_research::IntVar * > const &", right: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        r"""
        Creates a constraint that enforces that left is lexicographically less
        than or equal to right.
        """
        return _pywrapcp.Solver_LexicalLessOrEqual(self, left, right)

    def InversePermutationConstraint(self, left: "std::vector< operations_research::IntVar * > const &", right: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        r"""
        Creates a constraint that enforces that 'left' and 'right' both
        represent permutations of [0..left.size()-1], and that 'right' is
        the inverse permutation of 'left', i.e. for all i in
        [0..left.size()-1], right[left[i]] = i.
        """
        return _pywrapcp.Solver_InversePermutationConstraint(self, left, right)

    def NullIntersect(self, first_vars: "std::vector< operations_research::IntVar * > const &", second_vars: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        r"""
        Creates a constraint that states that all variables in the first
        vector are different from all variables in the second
        group. Thus the set of values in the first vector does not
        intersect with the set of values in the second vector.
        """
        return _pywrapcp.Solver_NullIntersect(self, first_vars, second_vars)

    def NullIntersectExcept(self, first_vars: "std::vector< operations_research::IntVar * > const &", second_vars: "std::vector< operations_research::IntVar * > const &", escape_value: "int64_t") -> "operations_research::Constraint *":
        r"""
        Creates a constraint that states that all variables in the first
        vector are different from all variables from the second group,
        unless they are assigned to the escape value. Thus the set of
        values in the first vector minus the escape value does not
        intersect with the set of values in the second vector.
        """
        return _pywrapcp.Solver_NullIntersectExcept(self, first_vars, second_vars, escape_value)

    def Circuit(self, nexts: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        r""" Force the "nexts" variable to create a complete Hamiltonian path."""
        return _pywrapcp.Solver_Circuit(self, nexts)

    def SubCircuit(self, nexts: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        r"""
        Force the "nexts" variable to create a complete Hamiltonian path
        for those that do not loop upon themselves.
        """
        return _pywrapcp.Solver_SubCircuit(self, nexts)

    def DelayedPathCumul(self, nexts: "std::vector< operations_research::IntVar * > const &", active: "std::vector< operations_research::IntVar * > const &", cumuls: "std::vector< operations_research::IntVar * > const &", transits: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        r"""
        Delayed version of the same constraint: propagation on the nexts variables
        is delayed until all constraints have propagated.
        """
        return _pywrapcp.Solver_DelayedPathCumul(self, nexts, active, cumuls, transits)

    def PathCumul(self, *args) -> "operations_research::Constraint *":
        r"""
        *Overload 1:*
        Creates a constraint which accumulates values along a path such that:
        cumuls[next[i]] = cumuls[i] + transits[i].
        Active variables indicate if the corresponding next variable is active;
        this could be useful to model unperformed nodes in a routing problem.

        |

        *Overload 2:*
        Creates a constraint which accumulates values along a path such that:
        cumuls[next[i]] = cumuls[i] + transit_evaluator(i, next[i]).
        Active variables indicate if the corresponding next variable is active;
        this could be useful to model unperformed nodes in a routing problem.
        Ownership of transit_evaluator is taken and it must be a repeatable
        callback.

        |

        *Overload 3:*
        Creates a constraint which accumulates values along a path such that:
        cumuls[next[i]] = cumuls[i] + transit_evaluator(i, next[i]) + slacks[i].
        Active variables indicate if the corresponding next variable is active;
        this could be useful to model unperformed nodes in a routing problem.
        Ownership of transit_evaluator is taken and it must be a repeatable
        callback.
        """
        return _pywrapcp.Solver_PathCumul(self, *args)

    def AllowedAssignments(self, *args) -> "operations_research::Constraint *":
        r"""
        *Overload 1:*
        This method creates a constraint where the graph of the relation
        between the variables is given in extension. There are 'arity'
        variables involved in the relation and the graph is given by a
        integer tuple set.

        |

        *Overload 2:*
        Compatibility layer for Python API.
        """
        return _pywrapcp.Solver_AllowedAssignments(self, *args)

    def TransitionConstraint(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_TransitionConstraint(self, *args)

    def NonOverlappingBoxesConstraint(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_NonOverlappingBoxesConstraint(self, *args)

    def Pack(self, vars: "std::vector< operations_research::IntVar * > const &", number_of_bins: "int") -> "operations_research::Pack *":
        r"""
        This constraint packs all variables onto 'number_of_bins'
        variables.  For any given variable, a value of 'number_of_bins'
        indicates that the variable is not assigned to any bin.
        Dimensions, i.e., cumulative constraints on this packing, can be
        added directly from the pack class.
        """
        return _pywrapcp.Solver_Pack(self, vars, number_of_bins)

    def FixedDurationIntervalVar(self, *args) -> "operations_research::IntervalVar *":
        r"""
        *Overload 1:*
        Creates an interval var with a fixed duration. The duration must
        be greater than 0. If optional is true, then the interval can be
        performed or unperformed. If optional is false, then the interval
        is always performed.

        |

        *Overload 2:*
        Creates a performed interval var with a fixed duration. The duration must
        be greater than 0.

        |

        *Overload 3:*
        Creates an interval var with a fixed duration, and performed_variable.
        The duration must be greater than 0.
        """
        return _pywrapcp.Solver_FixedDurationIntervalVar(self, *args)

    def FixedInterval(self, start: "int64_t", duration: "int64_t", name: "std::string const &") -> "operations_research::IntervalVar *":
        r""" Creates a fixed and performed interval."""
        return _pywrapcp.Solver_FixedInterval(self, start, duration, name)

    def IntervalVar(self, start_min: "int64_t", start_max: "int64_t", duration_min: "int64_t", duration_max: "int64_t", end_min: "int64_t", end_max: "int64_t", optional: "bool", name: "std::string const &") -> "operations_research::IntervalVar *":
        r"""
        Creates an interval var by specifying the bounds on start,
        duration, and end.
        """
        return _pywrapcp.Solver_IntervalVar(self, start_min, start_max, duration_min, duration_max, end_min, end_max, optional, name)

    def MirrorInterval(self, interval_var: "IntervalVar") -> "operations_research::IntervalVar *":
        r"""
        Creates an interval var that is the mirror image of the given one, that
        is, the interval var obtained by reversing the axis.
        """
        return _pywrapcp.Solver_MirrorInterval(self, interval_var)

    def FixedDurationStartSyncedOnStartIntervalVar(self, interval_var: "IntervalVar", duration: "int64_t", offset: "int64_t") -> "operations_research::IntervalVar *":
        r"""
        Creates an interval var with a fixed duration whose start is
        synchronized with the start of another interval, with a given
        offset. The performed status is also in sync with the performed
        status of the given interval variable.
        """
        return _pywrapcp.Solver_FixedDurationStartSyncedOnStartIntervalVar(self, interval_var, duration, offset)

    def FixedDurationStartSyncedOnEndIntervalVar(self, interval_var: "IntervalVar", duration: "int64_t", offset: "int64_t") -> "operations_research::IntervalVar *":
        r"""
        Creates an interval var with a fixed duration whose start is
        synchronized with the end of another interval, with a given
        offset. The performed status is also in sync with the performed
        status of the given interval variable.
        """
        return _pywrapcp.Solver_FixedDurationStartSyncedOnEndIntervalVar(self, interval_var, duration, offset)

    def FixedDurationEndSyncedOnStartIntervalVar(self, interval_var: "IntervalVar", duration: "int64_t", offset: "int64_t") -> "operations_research::IntervalVar *":
        r"""
        Creates an interval var with a fixed duration whose end is
        synchronized with the start of another interval, with a given
        offset. The performed status is also in sync with the performed
        status of the given interval variable.
        """
        return _pywrapcp.Solver_FixedDurationEndSyncedOnStartIntervalVar(self, interval_var, duration, offset)

    def FixedDurationEndSyncedOnEndIntervalVar(self, interval_var: "IntervalVar", duration: "int64_t", offset: "int64_t") -> "operations_research::IntervalVar *":
        r"""
        Creates an interval var with a fixed duration whose end is
        synchronized with the end of another interval, with a given
        offset. The performed status is also in sync with the performed
        status of the given interval variable.
        """
        return _pywrapcp.Solver_FixedDurationEndSyncedOnEndIntervalVar(self, interval_var, duration, offset)

    def IntervalRelaxedMin(self, interval_var: "IntervalVar") -> "operations_research::IntervalVar *":
        r"""
         Creates and returns an interval variable that wraps around the given one,
         relaxing the min start and end. Relaxing means making unbounded when
         optional. If the variable is non-optional, this method returns
         interval_var.

         More precisely, such an interval variable behaves as follows:
        When the underlying must be performed, the returned interval variable
             behaves exactly as the underlying;
        When the underlying may or may not be performed, the returned interval
             variable behaves like the underlying, except that it is unbounded on
             the min side;
        When the underlying cannot be performed, the returned interval variable
             is of duration 0 and must be performed in an interval unbounded on
             both sides.

         This is very useful to implement propagators that may only modify
         the start max or end max.
        """
        return _pywrapcp.Solver_IntervalRelaxedMin(self, interval_var)

    def IntervalRelaxedMax(self, interval_var: "IntervalVar") -> "operations_research::IntervalVar *":
        r"""
         Creates and returns an interval variable that wraps around the given one,
         relaxing the max start and end. Relaxing means making unbounded when
         optional. If the variable is non optional, this method returns
         interval_var.

         More precisely, such an interval variable behaves as follows:
        When the underlying must be performed, the returned interval variable
             behaves exactly as the underlying;
        When the underlying may or may not be performed, the returned interval
             variable behaves like the underlying, except that it is unbounded on
             the max side;
        When the underlying cannot be performed, the returned interval variable
             is of duration 0 and must be performed in an interval unbounded on
             both sides.

         This is very useful for implementing propagators that may only modify
         the start min or end min.
        """
        return _pywrapcp.Solver_IntervalRelaxedMax(self, interval_var)

    def TemporalDisjunction(self, *args) -> "operations_research::Constraint *":
        r"""
        *Overload 1:*
        This constraint implements a temporal disjunction between two
        interval vars t1 and t2. 'alt' indicates which alternative was
        chosen (alt == 0 is equivalent to t1 before t2).

        |

        *Overload 2:*
        This constraint implements a temporal disjunction between two
        interval vars.
        """
        return _pywrapcp.Solver_TemporalDisjunction(self, *args)

    def DisjunctiveConstraint(self, intervals: "std::vector< operations_research::IntervalVar * > const &", name: "std::string const &") -> "operations_research::DisjunctiveConstraint *":
        r"""
        This constraint forces all interval vars into an non-overlapping
        sequence. Intervals with zero duration can be scheduled anywhere.
        """
        return _pywrapcp.Solver_DisjunctiveConstraint(self, intervals, name)

    def Cumulative(self, *args) -> "operations_research::Constraint *":
        r"""
        *Overload 1:*
        This constraint forces that, for any integer t, the sum of the demands
        corresponding to an interval containing t does not exceed the given
        capacity.

        Intervals and demands should be vectors of equal size.

        Demands should only contain non-negative values. Zero values are
        supported, and the corresponding intervals are filtered out, as they
        neither impact nor are impacted by this constraint.

        |

        *Overload 2:*
        This constraint forces that, for any integer t, the sum of the demands
        corresponding to an interval containing t does not exceed the given
        capacity.

        Intervals and demands should be vectors of equal size.

        Demands should only contain non-negative values. Zero values are
        supported, and the corresponding intervals are filtered out, as they
        neither impact nor are impacted by this constraint.

        |

        *Overload 3:*
        This constraint forces that, for any integer t, the sum of the demands
        corresponding to an interval containing t does not exceed the given
        capacity.

        Intervals and demands should be vectors of equal size.

        Demands should only contain non-negative values. Zero values are
        supported, and the corresponding intervals are filtered out, as they
        neither impact nor are impacted by this constraint.

        |

        *Overload 4:*
        This constraint enforces that, for any integer t, the sum of the demands
        corresponding to an interval containing t does not exceed the given
        capacity.

        Intervals and demands should be vectors of equal size.

        Demands should only contain non-negative values. Zero values are
        supported, and the corresponding intervals are filtered out, as they
        neither impact nor are impacted by this constraint.

        |

        *Overload 5:*
        This constraint enforces that, for any integer t, the sum of demands
        corresponding to an interval containing t does not exceed the given
        capacity.

        Intervals and demands should be vectors of equal size.

        Demands should be positive.

        |

        *Overload 6:*
        This constraint enforces that, for any integer t, the sum of demands
        corresponding to an interval containing t does not exceed the given
        capacity.

        Intervals and demands should be vectors of equal size.

        Demands should be positive.
        """
        return _pywrapcp.Solver_Cumulative(self, *args)

    def Cover(self, vars: "std::vector< operations_research::IntervalVar * > const &", target_var: "IntervalVar") -> "operations_research::Constraint *":
        r"""
        This constraint states that the target_var is the convex hull of
        the intervals. If none of the interval variables is performed,
        then the target var is unperformed too. Also, if the target
        variable is unperformed, then all the intervals variables are
        unperformed too.
        """
        return _pywrapcp.Solver_Cover(self, vars, target_var)

    def Assignment(self, *args) -> "operations_research::Assignment *":
        r"""
        *Overload 1:*
        This method creates an empty assignment.

        |

        *Overload 2:*
        This method creates an assignment which is a copy of 'a'.
        """
        return _pywrapcp.Solver_Assignment(self, *args)

    def FirstSolutionCollector(self, *args) -> "operations_research::SolutionCollector *":
        r"""
        *Overload 1:*
        Collect the first solution of the search.

        |

        *Overload 2:*
        Collect the first solution of the search. The variables will need to
        be added later.
        """
        return _pywrapcp.Solver_FirstSolutionCollector(self, *args)

    def LastSolutionCollector(self, *args) -> "operations_research::SolutionCollector *":
        r"""
        *Overload 1:*
        Collect the last solution of the search.

        |

        *Overload 2:*
        Collect the last solution of the search. The variables will need to
        be added later.
        """
        return _pywrapcp.Solver_LastSolutionCollector(self, *args)

    def BestValueSolutionCollector(self, *args) -> "operations_research::SolutionCollector *":
        r"""
        *Overload 1:*
        Collect the solution corresponding to the optimal value of the objective
        of 'assignment'; if 'assignment' does not have an objective no solution is
        collected. This collector only collects one solution corresponding to the
        best objective value (the first one found).

        |

        *Overload 2:*
        Collect the solution corresponding to the optimal value of the
        objective of 'assignment'; if 'assignment' does not have an objective no
        solution is collected. This collector only collects one solution
        corresponding to the best objective value (the first one
        found). The variables will need to be added later.
        """
        return _pywrapcp.Solver_BestValueSolutionCollector(self, *args)

    def AllSolutionCollector(self, *args) -> "operations_research::SolutionCollector *":
        r"""
        *Overload 1:*
        Collect all solutions of the search.

        |

        *Overload 2:*
        Collect all solutions of the search. The variables will need to
        be added later.
        """
        return _pywrapcp.Solver_AllSolutionCollector(self, *args)

    def Minimize(self, v: "IntVar", step: "int64_t") -> "operations_research::OptimizeVar *":
        r""" Creates a minimization objective."""
        return _pywrapcp.Solver_Minimize(self, v, step)

    def Maximize(self, v: "IntVar", step: "int64_t") -> "operations_research::OptimizeVar *":
        r""" Creates a maximization objective."""
        return _pywrapcp.Solver_Maximize(self, v, step)

    def Optimize(self, maximize: "bool", v: "IntVar", step: "int64_t") -> "operations_research::OptimizeVar *":
        r""" Creates a objective with a given sense (true = maximization)."""
        return _pywrapcp.Solver_Optimize(self, maximize, v, step)

    def WeightedMinimize(self, *args) -> "operations_research::OptimizeVar *":
        r"""
        *Overload 1:*
        Creates a minimization weighted objective. The actual objective is
        scalar_prod(sub_objectives, weights).

        |

        *Overload 2:*
        Creates a minimization weighted objective. The actual objective is
        scalar_prod(sub_objectives, weights).
        """
        return _pywrapcp.Solver_WeightedMinimize(self, *args)

    def WeightedMaximize(self, *args) -> "operations_research::OptimizeVar *":
        r"""
        *Overload 1:*
        Creates a maximization weigthed objective.

        |

        *Overload 2:*
        Creates a maximization weigthed objective.
        """
        return _pywrapcp.Solver_WeightedMaximize(self, *args)

    def WeightedOptimize(self, *args) -> "operations_research::OptimizeVar *":
        r"""
        *Overload 1:*
        Creates a weighted objective with a given sense (true = maximization).

        |

        *Overload 2:*
        Creates a weighted objective with a given sense (true = maximization).
        """
        return _pywrapcp.Solver_WeightedOptimize(self, *args)

    def TabuSearch(self, maximize: "bool", v: "IntVar", step: "int64_t", vars: "std::vector< operations_research::IntVar * > const &", keep_tenure: "int64_t", forbid_tenure: "int64_t", tabu_factor: "double") -> "operations_research::SearchMonitor *":
        r"""
        MetaHeuristics which try to get the search out of local optima.
        Creates a Tabu Search monitor.
        In the context of local search the behavior is similar to MakeOptimize(),
        creating an objective in a given sense. The behavior differs once a local
        optimum is reached: thereafter solutions which degrade the value of the
        objective are allowed if they are not "tabu". A solution is "tabu" if it
        doesn't respect the following rules:
        - improving the best solution found so far
        - variables in the "keep" list must keep their value, variables in the
        "forbid" list must not take the value they have in the list.
        Variables with new values enter the tabu lists after each new solution
        found and leave the lists after a given number of iterations (called
        tenure). Only the variables passed to the method can enter the lists.
        The tabu criterion is softened by the tabu factor which gives the number
        of "tabu" violations which is tolerated; a factor of 1 means no violations
        allowed; a factor of 0 means all violations are allowed.
        """
        return _pywrapcp.Solver_TabuSearch(self, maximize, v, step, vars, keep_tenure, forbid_tenure, tabu_factor)

    def SimulatedAnnealing(self, maximize: "bool", v: "IntVar", step: "int64_t", initial_temperature: "int64_t") -> "operations_research::SearchMonitor *":
        r""" Creates a Simulated Annealing monitor."""
        return _pywrapcp.Solver_SimulatedAnnealing(self, maximize, v, step, initial_temperature)

    def LubyRestart(self, scale_factor: "int") -> "operations_research::SearchMonitor *":
        r"""
        This search monitor will restart the search periodically.
        At the iteration n, it will restart after scale_factor * Luby(n) failures
        where Luby is the Luby Strategy (i.e. 1 1 2 1 1 2 4 1 1 2 1 1 2 4 8...).
        """
        return _pywrapcp.Solver_LubyRestart(self, scale_factor)

    def ConstantRestart(self, frequency: "int") -> "operations_research::SearchMonitor *":
        r"""
        This search monitor will restart the search periodically after 'frequency'
        failures.
        """
        return _pywrapcp.Solver_ConstantRestart(self, frequency)

    def TimeLimit(self, *args) -> "operations_research::RegularLimit *":
        return _pywrapcp.Solver_TimeLimit(self, *args)

    def BranchesLimit(self, branches: "int64_t") -> "operations_research::RegularLimit *":
        r"""
        Creates a search limit that constrains the number of branches
        explored in the search tree.
        """
        return _pywrapcp.Solver_BranchesLimit(self, branches)

    def FailuresLimit(self, failures: "int64_t") -> "operations_research::RegularLimit *":
        r"""
        Creates a search limit that constrains the number of failures
        that can happen when exploring the search tree.
        """
        return _pywrapcp.Solver_FailuresLimit(self, failures)

    def SolutionsLimit(self, solutions: "int64_t") -> "operations_research::RegularLimit *":
        r"""
        Creates a search limit that constrains the number of solutions found
        during the search.
        """
        return _pywrapcp.Solver_SolutionsLimit(self, solutions)

    def Limit(self, *args) -> "operations_research::SearchLimit *":
        r"""
        *Overload 1:*
        Limits the search with the 'time', 'branches', 'failures' and
        'solutions' limits. 'smart_time_check' reduces the calls to the wall

        |

        *Overload 2:*
        Creates a search limit from its protobuf description

        |

        *Overload 3:*
        Creates a search limit that is reached when either of the underlying limit
        is reached. That is, the returned limit is more stringent than both
        argument limits.
        """
        return _pywrapcp.Solver_Limit(self, *args)

    def CustomLimit(self, limiter: "std::function< bool () >") -> "operations_research::SearchLimit *":
        r"""
        Callback-based search limit. Search stops when limiter returns true; if
        this happens at a leaf the corresponding solution will be rejected.
        """
        return _pywrapcp.Solver_CustomLimit(self, limiter)

    def SearchLog(self, *args) -> "operations_research::SearchMonitor *":
        return _pywrapcp.Solver_SearchLog(self, *args)

    def SearchTrace(self, prefix: "std::string const &") -> "operations_research::SearchMonitor *":
        r"""
        Creates a search monitor that will trace precisely the behavior of the
        search. Use this only for low level debugging.
        """
        return _pywrapcp.Solver_SearchTrace(self, prefix)

    def PrintModelVisitor(self) -> "operations_research::ModelVisitor *":
        r""" Prints the model."""
        return _pywrapcp.Solver_PrintModelVisitor(self)

    def StatisticsModelVisitor(self) -> "operations_research::ModelVisitor *":
        r""" Displays some nice statistics on the model."""
        return _pywrapcp.Solver_StatisticsModelVisitor(self)

    def AssignVariableValue(self, var: "IntVar", val: "int64_t") -> "operations_research::Decision *":
        r""" Decisions."""
        return _pywrapcp.Solver_AssignVariableValue(self, var, val)

    def VariableLessOrEqualValue(self, var: "IntVar", value: "int64_t") -> "operations_research::Decision *":
        return _pywrapcp.Solver_VariableLessOrEqualValue(self, var, value)

    def VariableGreaterOrEqualValue(self, var: "IntVar", value: "int64_t") -> "operations_research::Decision *":
        return _pywrapcp.Solver_VariableGreaterOrEqualValue(self, var, value)

    def SplitVariableDomain(self, var: "IntVar", val: "int64_t", start_with_lower_half: "bool") -> "operations_research::Decision *":
        return _pywrapcp.Solver_SplitVariableDomain(self, var, val, start_with_lower_half)

    def AssignVariableValueOrFail(self, var: "IntVar", value: "int64_t") -> "operations_research::Decision *":
        return _pywrapcp.Solver_AssignVariableValueOrFail(self, var, value)

    def AssignVariablesValues(self, vars: "std::vector< operations_research::IntVar * > const &", values: "std::vector< int64_t > const &") -> "operations_research::Decision *":
        return _pywrapcp.Solver_AssignVariablesValues(self, vars, values)

    def FailDecision(self) -> "operations_research::Decision *":
        return _pywrapcp.Solver_FailDecision(self)

    def Decision(self, apply: "operations_research::Solver::Action", refute: "operations_research::Solver::Action") -> "operations_research::Decision *":
        return _pywrapcp.Solver_Decision(self, apply, refute)

    def Compose(self, dbs: "std::vector< operations_research::DecisionBuilder * > const &") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_Compose(self, dbs)

    def Try(self, dbs: "std::vector< operations_research::DecisionBuilder * > const &") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_Try(self, dbs)

    def DefaultPhase(self, *args) -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_DefaultPhase(self, *args)

    def ScheduleOrPostpone(self, var: "IntervalVar", est: "int64_t", marker: "int64_t *const") -> "operations_research::Decision *":
        r"""
        Returns a decision that tries to schedule a task at a given time.
        On the Apply branch, it will set that interval var as performed and set
        its start to 'est'. On the Refute branch, it will just update the
        'marker' to 'est' + 1. This decision is used in the
        INTERVAL_SET_TIMES_FORWARD strategy.
        """
        return _pywrapcp.Solver_ScheduleOrPostpone(self, var, est, marker)

    def ScheduleOrExpedite(self, var: "IntervalVar", est: "int64_t", marker: "int64_t *const") -> "operations_research::Decision *":
        r"""
        Returns a decision that tries to schedule a task at a given time.
        On the Apply branch, it will set that interval var as performed and set
        its end to 'est'. On the Refute branch, it will just update the
        'marker' to 'est' - 1. This decision is used in the
        INTERVAL_SET_TIMES_BACKWARD strategy.
        """
        return _pywrapcp.Solver_ScheduleOrExpedite(self, var, est, marker)

    def RankFirstInterval(self, sequence: "SequenceVar", index: "int") -> "operations_research::Decision *":
        r"""
        Returns a decision that tries to rank first the ith interval var
        in the sequence variable.
        """
        return _pywrapcp.Solver_RankFirstInterval(self, sequence, index)

    def RankLastInterval(self, sequence: "SequenceVar", index: "int") -> "operations_research::Decision *":
        r"""
        Returns a decision that tries to rank last the ith interval var
        in the sequence variable.
        """
        return _pywrapcp.Solver_RankLastInterval(self, sequence, index)

    def Phase(self, *args) -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_Phase(self, *args)

    def DecisionBuilderFromAssignment(self, assignment: "Assignment", db: "DecisionBuilder", vars: "std::vector< operations_research::IntVar * > const &") -> "operations_research::DecisionBuilder *":
        r"""
        Returns a decision builder for which the left-most leaf corresponds
        to assignment, the rest of the tree being explored using 'db'.
        """
        return _pywrapcp.Solver_DecisionBuilderFromAssignment(self, assignment, db, vars)

    def ConstraintAdder(self, ct: "Constraint") -> "operations_research::DecisionBuilder *":
        r"""
        Returns a decision builder that will add the given constraint to
        the model.
        """
        return _pywrapcp.Solver_ConstraintAdder(self, ct)

    def SolveOnce(self, db: "DecisionBuilder", monitors: "std::vector< operations_research::SearchMonitor * > const &") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_SolveOnce(self, db, monitors)

    def NestedOptimize(self, *args) -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_NestedOptimize(self, *args)

    def RestoreAssignment(self, assignment: "Assignment") -> "operations_research::DecisionBuilder *":
        r"""
        Returns a DecisionBuilder which restores an Assignment
        (calls void Assignment::Restore())
        """
        return _pywrapcp.Solver_RestoreAssignment(self, assignment)

    def StoreAssignment(self, assignment: "Assignment") -> "operations_research::DecisionBuilder *":
        r"""
        Returns a DecisionBuilder which stores an Assignment
        (calls void Assignment::Store())
        """
        return _pywrapcp.Solver_StoreAssignment(self, assignment)

    def Operator(self, *args) -> "operations_research::LocalSearchOperator *":
        return _pywrapcp.Solver_Operator(self, *args)

    def RandomLnsOperator(self, *args) -> "operations_research::LocalSearchOperator *":
        return _pywrapcp.Solver_RandomLnsOperator(self, *args)

    def MoveTowardTargetOperator(self, *args) -> "operations_research::LocalSearchOperator *":
        r"""
        *Overload 1:*
        Creates a local search operator that tries to move the assignment of some
        variables toward a target. The target is given as an Assignment. This
        operator generates neighbors in which the only difference compared to the
        current state is that one variable that belongs to the target assignment
        is set to its target value.

        |

        *Overload 2:*
        Creates a local search operator that tries to move the assignment of some
        variables toward a target. The target is given either as two vectors: a
        vector of variables and a vector of associated target values. The two
        vectors should be of the same length. This operator generates neighbors in
        which the only difference compared to the current state is that one
        variable that belongs to the given vector is set to its target value.
        """
        return _pywrapcp.Solver_MoveTowardTargetOperator(self, *args)

    def ConcatenateOperators(self, *args) -> "operations_research::LocalSearchOperator *":
        return _pywrapcp.Solver_ConcatenateOperators(self, *args)

    def RandomConcatenateOperators(self, *args) -> "operations_research::LocalSearchOperator *":
        r"""
        *Overload 1:*
        Randomized version of local search concatenator; calls a random operator
        at each call to MakeNextNeighbor().

        |

        *Overload 2:*
        Randomized version of local search concatenator; calls a random operator
        at each call to MakeNextNeighbor(). The provided seed is used to
        initialize the random number generator.
        """
        return _pywrapcp.Solver_RandomConcatenateOperators(self, *args)

    def NeighborhoodLimit(self, op: "LocalSearchOperator", limit: "int64_t") -> "operations_research::LocalSearchOperator *":
        r"""
        Creates a local search operator that wraps another local search
        operator and limits the number of neighbors explored (i.e., calls
        to MakeNextNeighbor from the current solution (between two calls
        to Start()). When this limit is reached, MakeNextNeighbor()
        returns false. The counter is cleared when Start() is called.
        """
        return _pywrapcp.Solver_NeighborhoodLimit(self, op, limit)

    def LocalSearchPhase(self, *args) -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_LocalSearchPhase(self, *args)

    def LocalSearchPhaseParameters(self, *args) -> "operations_research::LocalSearchPhaseParameters *":
        return _pywrapcp.Solver_LocalSearchPhaseParameters(self, *args)

    def SearchDepth(self) -> "int":
        r"""
        Gets the search depth of the current active search. Returns -1 if
        there is no active search opened.
        """
        return _pywrapcp.Solver_SearchDepth(self)

    def SearchLeftDepth(self) -> "int":
        r"""
        Gets the search left depth of the current active search. Returns -1 if
        there is no active search opened.
        """
        return _pywrapcp.Solver_SearchLeftDepth(self)

    def SolveDepth(self) -> "int":
        r"""
        Gets the number of nested searches. It returns 0 outside search,
        1 during the top level search, 2 or more in case of nested searches.
        """
        return _pywrapcp.Solver_SolveDepth(self)

    def Rand64(self, size: "int64_t") -> "int64_t":
        r""" Returns a random value between 0 and 'size' - 1;"""
        return _pywrapcp.Solver_Rand64(self, size)

    def Rand32(self, size: "int32_t") -> "int32_t":
        r""" Returns a random value between 0 and 'size' - 1;"""
        return _pywrapcp.Solver_Rand32(self, size)

    def ReSeed(self, seed: "int32_t") -> "void":
        r""" Reseed the solver random generator."""
        return _pywrapcp.Solver_ReSeed(self, seed)

    def LocalSearchProfile(self) -> "std::string":
        r""" Returns local search profiling information in a human readable format."""
        return _pywrapcp.Solver_LocalSearchProfile(self)

    def Constraints(self) -> "int":
        r"""
        Counts the number of constraints that have been added
        to the solver before the search.
        """
        return _pywrapcp.Solver_Constraints(self)

    def Accept(self, visitor: "operations_research::ModelVisitor *const") -> "void":
        r""" Accepts the given model visitor."""
        return _pywrapcp.Solver_Accept(self, visitor)

    def FinishCurrentSearch(self) -> "void":
        r""" Tells the solver to kill or restart the current search."""
        return _pywrapcp.Solver_FinishCurrentSearch(self)

    def RestartCurrentSearch(self) -> "void":
        return _pywrapcp.Solver_RestartCurrentSearch(self)

    def ShouldFail(self) -> "void":
        r"""
        These methods are only useful for the SWIG wrappers, which need a way
        to externally cause the Solver to fail.
        """
        return _pywrapcp.Solver_ShouldFail(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.Solver___str__(self)

    def Add(self, ct):
      if isinstance(ct, PyConstraint):
        self.__python_constraints.append(ct)
      self.AddConstraint(ct)


    def TreeNoCycle(self, nexts: "std::vector< operations_research::IntVar * > const &", active: "std::vector< operations_research::IntVar * > const &", callback: "operations_research::Solver::IndexFilter1"=0) -> "operations_research::Constraint *":
        return _pywrapcp.Solver_TreeNoCycle(self, nexts, active, callback)

    def SearchLogWithCallback(self, period: "int", callback: "std::function< std::string () >") -> "operations_research::SearchMonitor *":
        return _pywrapcp.Solver_SearchLogWithCallback(self, period, callback)

    def ElementFunction(self, values: "std::function< int64_t (int64_t) >", index: "IntVar") -> "operations_research::IntExpr *":
        return _pywrapcp.Solver_ElementFunction(self, values, index)

    def VarEvalValStrPhase(self, vars: "std::vector< operations_research::IntVar * > const &", var_evaluator: "std::function< int64_t (int64_t) >", val_str: "operations_research::Solver::IntValueStrategy") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_VarEvalValStrPhase(self, vars, var_evaluator, val_str)

    def VarStrValEvalPhase(self, vars: "std::vector< operations_research::IntVar * > const &", var_str: "operations_research::Solver::IntVarStrategy", val_eval: "operations_research::Solver::IndexEvaluator2") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_VarStrValEvalPhase(self, vars, var_str, val_eval)

    def VarEvalValEvalPhase(self, vars: "std::vector< operations_research::IntVar * > const &", var_eval: "std::function< int64_t (int64_t) >", val_eval: "operations_research::Solver::IndexEvaluator2") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_VarEvalValEvalPhase(self, vars, var_eval, val_eval)

    def VarStrValEvalTieBreakPhase(self, vars: "std::vector< operations_research::IntVar * > const &", var_str: "operations_research::Solver::IntVarStrategy", val_eval: "operations_research::Solver::IndexEvaluator2", tie_breaker: "std::function< int64_t (int64_t) >") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_VarStrValEvalTieBreakPhase(self, vars, var_str, val_eval, tie_breaker)

    def VarEvalValEvalTieBreakPhase(self, vars: "std::vector< operations_research::IntVar * > const &", var_eval: "std::function< int64_t (int64_t) >", val_eval: "operations_research::Solver::IndexEvaluator2", tie_breaker: "std::function< int64_t (int64_t) >") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_VarEvalValEvalTieBreakPhase(self, vars, var_eval, val_eval, tie_breaker)

    def EvalEvalStrPhase(self, vars: "std::vector< operations_research::IntVar * > const &", evaluator: "operations_research::Solver::IndexEvaluator2", str: "operations_research::Solver::EvaluatorStrategy") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_EvalEvalStrPhase(self, vars, evaluator, str)

    def EvalEvalStrTieBreakPhase(self, vars: "std::vector< operations_research::IntVar * > const &", evaluator: "operations_research::Solver::IndexEvaluator2", tie_breaker: "operations_research::Solver::IndexEvaluator1", str: "operations_research::Solver::EvaluatorStrategy") -> "operations_research::DecisionBuilder *":
        return _pywrapcp.Solver_EvalEvalStrTieBreakPhase(self, vars, evaluator, tie_breaker, str)

    def GuidedLocalSearch(self, *args) -> "operations_research::SearchMonitor *":
        return _pywrapcp.Solver_GuidedLocalSearch(self, *args)

    def SumObjectiveFilter(self, vars: "std::vector< operations_research::IntVar * > const &", values: "operations_research::Solver::IndexEvaluator2", filter_enum: "operations_research::Solver::LocalSearchFilterBound") -> "operations_research::LocalSearchFilter *":
        return _pywrapcp.Solver_SumObjectiveFilter(self, vars, values, filter_enum)

# Register Solver in _pywrapcp:
_pywrapcp.Solver_swigregister(Solver)

def Solver_DefaultSolverParameters() -> "operations_research::ConstraintSolverParameters":
    r""" Create a ConstraintSolverParameters proto with all the default values."""
    return _pywrapcp.Solver_DefaultSolverParameters()

def Solver_MemoryUsage() -> "int64_t":
    r""" Current memory usage in bytes"""
    return _pywrapcp.Solver_MemoryUsage()

class BaseObject(object):
    r"""
    A BaseObject is the root of all reversibly allocated objects.
    A DebugString method and the associated << operator are implemented
    as a convenience.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        if self.__class__ == BaseObject:
            _self = None
        else:
            _self = self
        _pywrapcp.BaseObject_swiginit(self, _pywrapcp.new_BaseObject(_self, ))
    __swig_destroy__ = _pywrapcp.delete_BaseObject

    def DebugString(self) -> "std::string":
        return _pywrapcp.BaseObject_DebugString(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.BaseObject___str__(self)

    def __repr__(self) -> "std::string":
        return _pywrapcp.BaseObject___repr__(self)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_BaseObject(self)
        return weakref.proxy(self)

# Register BaseObject in _pywrapcp:
_pywrapcp.BaseObject_swigregister(BaseObject)

class PropagationBaseObject(BaseObject):
    r"""
    NOLINT
    The PropagationBaseObject is a subclass of BaseObject that is also
    friend to the Solver class. It allows accessing methods useful when
    writing new constraints or new expressions.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, s: "Solver"):
        if self.__class__ == PropagationBaseObject:
            _self = None
        else:
            _self = self
        _pywrapcp.PropagationBaseObject_swiginit(self, _pywrapcp.new_PropagationBaseObject(_self, s))
    __swig_destroy__ = _pywrapcp.delete_PropagationBaseObject

    def DebugString(self) -> "std::string":
        return _pywrapcp.PropagationBaseObject_DebugString(self)

    def solver(self) -> "operations_research::Solver *":
        return _pywrapcp.PropagationBaseObject_solver(self)

    def Name(self) -> "std::string":
        r""" Object naming."""
        return _pywrapcp.PropagationBaseObject_Name(self)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_PropagationBaseObject(self)
        return weakref.proxy(self)

# Register PropagationBaseObject in _pywrapcp:
_pywrapcp.PropagationBaseObject_swigregister(PropagationBaseObject)

class Decision(BaseObject):
    r"""
    A Decision represents a choice point in the search tree. The two main
    methods are Apply() to go left, or Refute() to go right.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        if self.__class__ == Decision:
            _self = None
        else:
            _self = self
        _pywrapcp.Decision_swiginit(self, _pywrapcp.new_Decision(_self, ))
    __swig_destroy__ = _pywrapcp.delete_Decision

    def ApplyWrapper(self, s: "Solver") -> "void":
        r""" Apply will be called first when the decision is executed."""
        return _pywrapcp.Decision_ApplyWrapper(self, s)

    def RefuteWrapper(self, s: "Solver") -> "void":
        r""" Refute will be called after a backtrack."""
        return _pywrapcp.Decision_RefuteWrapper(self, s)

    def DebugString(self) -> "std::string":
        return _pywrapcp.Decision_DebugString(self)

    def __repr__(self) -> "std::string":
        return _pywrapcp.Decision___repr__(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.Decision___str__(self)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_Decision(self)
        return weakref.proxy(self)

# Register Decision in _pywrapcp:
_pywrapcp.Decision_swigregister(Decision)

class DecisionBuilder(BaseObject):
    r"""
    A DecisionBuilder is responsible for creating the search tree. The
    important method is Next(), which returns the next decision to execute.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        if self.__class__ == DecisionBuilder:
            _self = None
        else:
            _self = self
        _pywrapcp.DecisionBuilder_swiginit(self, _pywrapcp.new_DecisionBuilder(_self, ))
    __swig_destroy__ = _pywrapcp.delete_DecisionBuilder

    def NextWrapper(self, s: "Solver") -> "operations_research::Decision *":
        r"""
        This is the main method of the decision builder class. It must
        return a decision (an instance of the class Decision). If it
        returns nullptr, this means that the decision builder has finished
        its work.
        """
        return _pywrapcp.DecisionBuilder_NextWrapper(self, s)

    def DebugString(self) -> "std::string":
        return _pywrapcp.DecisionBuilder_DebugString(self)

    def __repr__(self) -> "std::string":
        return _pywrapcp.DecisionBuilder___repr__(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.DecisionBuilder___str__(self)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_DecisionBuilder(self)
        return weakref.proxy(self)

# Register DecisionBuilder in _pywrapcp:
_pywrapcp.DecisionBuilder_swigregister(DecisionBuilder)

class Demon(BaseObject):
    r"""
    A Demon is the base element of a propagation queue. It is the main
      object responsible for implementing the actual propagation
      of the constraint and pruning the inconsistent values in the domains
      of the variables. The main concept is that demons are listeners that are
      attached to the variables and listen to their modifications.
    There are two methods:
     - Run() is the actual method called when the demon is processed.
     - priority() returns its priority. Standard priorities are slow, normal
       or fast. "immediate" is reserved for variables and is treated separately.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        This indicates the priority of a demon. Immediate demons are treated
        separately and corresponds to variables.
        """
        if self.__class__ == Demon:
            _self = None
        else:
            _self = self
        _pywrapcp.Demon_swiginit(self, _pywrapcp.new_Demon(_self, ))
    __swig_destroy__ = _pywrapcp.delete_Demon

    def RunWrapper(self, s: "Solver") -> "void":
        r""" This is the main callback of the demon."""
        return _pywrapcp.Demon_RunWrapper(self, s)

    def Priority(self) -> "operations_research::Solver::DemonPriority":
        r"""
        This method returns the priority of the demon. Usually a demon is
        fast, slow or normal. Immediate demons are reserved for internal
        use to maintain variables.
        """
        return _pywrapcp.Demon_Priority(self)

    def DebugString(self) -> "std::string":
        return _pywrapcp.Demon_DebugString(self)

    def Inhibit(self, s: "Solver") -> "void":
        r"""
        This method inhibits the demon in the search tree below the
        current position.
        """
        return _pywrapcp.Demon_Inhibit(self, s)

    def Desinhibit(self, s: "Solver") -> "void":
        r""" This method un-inhibits the demon that was previously inhibited."""
        return _pywrapcp.Demon_Desinhibit(self, s)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_Demon(self)
        return weakref.proxy(self)

# Register Demon in _pywrapcp:
_pywrapcp.Demon_swigregister(Demon)

class Constraint(PropagationBaseObject):
    r"""
    A constraint is the main modeling object. It provides two methods:
      - Post() is responsible for creating the demons and attaching them to
        immediate demons().
      - InitialPropagate() is called once just after Post and performs
        the initial propagation. The subsequent propagations will be performed
        by the demons Posted during the post() method.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, solver: "Solver"):
        if self.__class__ == Constraint:
            _self = None
        else:
            _self = self
        _pywrapcp.Constraint_swiginit(self, _pywrapcp.new_Constraint(_self, solver))
    __swig_destroy__ = _pywrapcp.delete_Constraint

    def Post(self) -> "void":
        r"""
        This method is called when the constraint is processed by the
        solver. Its main usage is to attach demons to variables.
        """
        return _pywrapcp.Constraint_Post(self)

    def InitialPropagateWrapper(self) -> "void":
        r"""
        This method performs the initial propagation of the
        constraint. It is called just after the post.
        """
        return _pywrapcp.Constraint_InitialPropagateWrapper(self)

    def DebugString(self) -> "std::string":
        return _pywrapcp.Constraint_DebugString(self)

    def Var(self) -> "operations_research::IntVar *":
        r"""
        Creates a Boolean variable representing the status of the constraint
        (false = constraint is violated, true = constraint is satisfied). It
        returns nullptr if the constraint does not support this API.
        """
        return _pywrapcp.Constraint_Var(self)

    def __repr__(self) -> "std::string":
        return _pywrapcp.Constraint___repr__(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.Constraint___str__(self)

    def __add__(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___add__(self, *args)

    def __radd__(self, v: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___radd__(self, v)

    def __sub__(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___sub__(self, *args)

    def __rsub__(self, v: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___rsub__(self, v)

    def __mul__(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___mul__(self, *args)

    def __rmul__(self, v: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___rmul__(self, v)

    def __floordiv__(self, v: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___floordiv__(self, v)

    def __neg__(self) -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___neg__(self)

    def __abs__(self) -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint___abs__(self)

    def Square(self) -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint_Square(self)

    def __eq__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Constraint___eq__(self, *args)

    def __ne__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Constraint___ne__(self, *args)

    def __ge__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Constraint___ge__(self, *args)

    def __gt__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Constraint___gt__(self, *args)

    def __le__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Constraint___le__(self, *args)

    def __lt__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.Constraint___lt__(self, *args)

    def MapTo(self, vars: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        return _pywrapcp.Constraint_MapTo(self, vars)

    def IndexOf(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.Constraint_IndexOf(self, *args)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_Constraint(self)
        return weakref.proxy(self)

# Register Constraint in _pywrapcp:
_pywrapcp.Constraint_swigregister(Constraint)

class SearchMonitor(BaseObject):
    r""" A search monitor is a simple set of callbacks to monitor all search events"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, s: "Solver"):
        if self.__class__ == SearchMonitor:
            _self = None
        else:
            _self = self
        _pywrapcp.SearchMonitor_swiginit(self, _pywrapcp.new_SearchMonitor(_self, s))
    __swig_destroy__ = _pywrapcp.delete_SearchMonitor

    def EnterSearch(self) -> "void":
        r""" Beginning of the search."""
        return _pywrapcp.SearchMonitor_EnterSearch(self)

    def RestartSearch(self) -> "void":
        r""" Restart the search."""
        return _pywrapcp.SearchMonitor_RestartSearch(self)

    def ExitSearch(self) -> "void":
        r""" End of the search."""
        return _pywrapcp.SearchMonitor_ExitSearch(self)

    def BeginNextDecision(self, b: "DecisionBuilder") -> "void":
        r""" Before calling DecisionBuilder::Next."""
        return _pywrapcp.SearchMonitor_BeginNextDecision(self, b)

    def EndNextDecision(self, b: "DecisionBuilder", d: "Decision") -> "void":
        r""" After calling DecisionBuilder::Next, along with the returned decision."""
        return _pywrapcp.SearchMonitor_EndNextDecision(self, b, d)

    def ApplyDecision(self, d: "Decision") -> "void":
        r""" Before applying the decision."""
        return _pywrapcp.SearchMonitor_ApplyDecision(self, d)

    def RefuteDecision(self, d: "Decision") -> "void":
        r""" Before refuting the decision."""
        return _pywrapcp.SearchMonitor_RefuteDecision(self, d)

    def AfterDecision(self, d: "Decision", apply: "bool") -> "void":
        r"""
        Just after refuting or applying the decision, apply is true after Apply.
        This is called only if the Apply() or Refute() methods have not failed.
        """
        return _pywrapcp.SearchMonitor_AfterDecision(self, d, apply)

    def BeginFail(self) -> "void":
        r""" Just when the failure occurs."""
        return _pywrapcp.SearchMonitor_BeginFail(self)

    def EndFail(self) -> "void":
        r""" After completing the backtrack."""
        return _pywrapcp.SearchMonitor_EndFail(self)

    def BeginInitialPropagation(self) -> "void":
        r""" Before the initial propagation."""
        return _pywrapcp.SearchMonitor_BeginInitialPropagation(self)

    def EndInitialPropagation(self) -> "void":
        r""" After the initial propagation."""
        return _pywrapcp.SearchMonitor_EndInitialPropagation(self)

    def AcceptSolution(self) -> "bool":
        r"""
        This method is called when a solution is found. It asserts whether the
        solution is valid. A value of false indicates that the solution
        should be discarded.
        """
        return _pywrapcp.SearchMonitor_AcceptSolution(self)

    def AtSolution(self) -> "bool":
        r"""
        This method is called when a valid solution is found. If the
        return value is true, then search will resume after. If the result
        is false, then search will stop there.
        """
        return _pywrapcp.SearchMonitor_AtSolution(self)

    def NoMoreSolutions(self) -> "void":
        r""" When the search tree is finished."""
        return _pywrapcp.SearchMonitor_NoMoreSolutions(self)

    def LocalOptimum(self) -> "bool":
        r"""
        When a local optimum is reached. If 'true' is returned, the last solution
        is discarded and the search proceeds with the next one.
        """
        return _pywrapcp.SearchMonitor_LocalOptimum(self)

    def AcceptDelta(self, delta: "Assignment", deltadelta: "Assignment") -> "bool":
        
        return _pywrapcp.SearchMonitor_AcceptDelta(self, delta, deltadelta)

    def AcceptNeighbor(self) -> "void":
        r""" After accepting a neighbor during local search."""
        return _pywrapcp.SearchMonitor_AcceptNeighbor(self)

    def solver(self) -> "operations_research::Solver *":
        return _pywrapcp.SearchMonitor_solver(self)

    def __repr__(self) -> "std::string":
        return _pywrapcp.SearchMonitor___repr__(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.SearchMonitor___str__(self)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_SearchMonitor(self)
        return weakref.proxy(self)

# Register SearchMonitor in _pywrapcp:
_pywrapcp.SearchMonitor_swigregister(SearchMonitor)

class IntExpr(PropagationBaseObject):
    r"""
    The class IntExpr is the base of all integer expressions in
    constraint programming.
    It contains the basic protocol for an expression:
      - setting and modifying its bound
      - querying if it is bound
      - listening to events modifying its bounds
      - casting it into a variable (instance of IntVar)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def Min(self) -> "int64_t":
        return _pywrapcp.IntExpr_Min(self)

    def SetMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntExpr_SetMin(self, m)

    def Max(self) -> "int64_t":
        return _pywrapcp.IntExpr_Max(self)

    def SetMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntExpr_SetMax(self, m)

    def SetRange(self, l: "int64_t", u: "int64_t") -> "void":
        r""" This method sets both the min and the max of the expression."""
        return _pywrapcp.IntExpr_SetRange(self, l, u)

    def SetValue(self, v: "int64_t") -> "void":
        r""" This method sets the value of the expression."""
        return _pywrapcp.IntExpr_SetValue(self, v)

    def Bound(self) -> "bool":
        r""" Returns true if the min and the max of the expression are equal."""
        return _pywrapcp.IntExpr_Bound(self)

    def IsVar(self) -> "bool":
        r""" Returns true if the expression is indeed a variable."""
        return _pywrapcp.IntExpr_IsVar(self)

    def Var(self) -> "operations_research::IntVar *":
        r""" Creates a variable from the expression."""
        return _pywrapcp.IntExpr_Var(self)

    def VarWithName(self, name: "std::string const &") -> "operations_research::IntVar *":
        r"""
        Creates a variable from the expression and set the name of the
        resulting var. If the expression is already a variable, then it
        will set the name of the expression, possibly overwriting it.
        This is just a shortcut to Var() followed by set_name().
        """
        return _pywrapcp.IntExpr_VarWithName(self, name)

    def WhenRange(self, *args) -> "void":
        r"""
        *Overload 1:*
        Attach a demon that will watch the min or the max of the expression.

        |

        *Overload 2:*
        Attach a demon that will watch the min or the max of the expression.
        """
        return _pywrapcp.IntExpr_WhenRange(self, *args)

    def __repr__(self) -> "std::string":
        return _pywrapcp.IntExpr___repr__(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.IntExpr___str__(self)

    def __add__(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___add__(self, *args)

    def __radd__(self, v: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___radd__(self, v)

    def __sub__(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___sub__(self, *args)

    def __rsub__(self, v: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___rsub__(self, v)

    def __mul__(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___mul__(self, *args)

    def __rmul__(self, v: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___rmul__(self, v)

    def __floordiv__(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___floordiv__(self, *args)

    def __mod__(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___mod__(self, *args)

    def __neg__(self) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___neg__(self)

    def __abs__(self) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr___abs__(self)

    def Square(self) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr_Square(self)

    def __eq__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr___eq__(self, *args)

    def __ne__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr___ne__(self, *args)

    def __ge__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr___ge__(self, *args)

    def __gt__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr___gt__(self, *args)

    def __le__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr___le__(self, *args)

    def __lt__(self, *args) -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr___lt__(self, *args)

    def MapTo(self, vars: "std::vector< operations_research::IntVar * > const &") -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr_MapTo(self, vars)

    def IndexOf(self, *args) -> "operations_research::IntExpr *":
        return _pywrapcp.IntExpr_IndexOf(self, *args)

    def IsMember(self, values: "std::vector< int64_t > const &") -> "operations_research::IntVar *":
        return _pywrapcp.IntExpr_IsMember(self, values)

    def Member(self, values: "std::vector< int64_t > const &") -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr_Member(self, values)

    def NotMember(self, starts: "std::vector< int64_t > const &", ends: "std::vector< int64_t > const &") -> "operations_research::Constraint *":
        return _pywrapcp.IntExpr_NotMember(self, starts, ends)

# Register IntExpr in _pywrapcp:
_pywrapcp.IntExpr_swigregister(IntExpr)

class IntVarIterator(BaseObject):
    r"""
     The class Iterator has two direct subclasses. HoleIterators
     iterates over all holes, that is value removed between the
     current min and max of the variable since the last time the
     variable was processed in the queue. DomainIterators iterates
     over all elements of the variable domain. Both iterators are not
     robust to domain changes. Hole iterators can also report values outside
     the current min and max of the variable.
     HoleIterators should only be called from a demon attached to the
     variable that has created this iterator.
     IntVar* current_var;
     std::unique_ptr<IntVarIterator> it(current_var->MakeHoleIterator(false));
     for (const int64_t hole : InitAndGetValues(it)) {
    use the hole
     }
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Init(self) -> "void":
        r""" This method must be called before each loop."""
        return _pywrapcp.IntVarIterator_Init(self)

    def Ok(self) -> "bool":
        r""" This method indicates if we can call Value() or not."""
        return _pywrapcp.IntVarIterator_Ok(self)

    def Value(self) -> "int64_t":
        r""" This method returns the current value of the iterator."""
        return _pywrapcp.IntVarIterator_Value(self)

    def Next(self) -> "void":
        r""" This method moves the iterator to the next value."""
        return _pywrapcp.IntVarIterator_Next(self)

    def DebugString(self) -> "std::string":
        r""" Pretty Print."""
        return _pywrapcp.IntVarIterator_DebugString(self)

    def __iter__(self):
      self.Init()
      return self

    def next(self):
      if self.Ok():
        result = self.Value()
        self.Next()
        return result
      else:
        raise StopIteration()

    def __next__(self):
      return self.next()


# Register IntVarIterator in _pywrapcp:
_pywrapcp.IntVarIterator_swigregister(IntVarIterator)

class IntVar(IntExpr):
    r"""
    The class IntVar is a subset of IntExpr. In addition to the
    IntExpr protocol, it offers persistence, removing values from the domains,
    and a finer model for events.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def IsVar(self) -> "bool":
        return _pywrapcp.IntVar_IsVar(self)

    def Var(self) -> "operations_research::IntVar *":
        return _pywrapcp.IntVar_Var(self)

    def Value(self) -> "int64_t":
        r"""
        This method returns the value of the variable. This method checks
        before that the variable is bound.
        """
        return _pywrapcp.IntVar_Value(self)

    def RemoveValue(self, v: "int64_t") -> "void":
        r""" This method removes the value 'v' from the domain of the variable."""
        return _pywrapcp.IntVar_RemoveValue(self, v)

    def RemoveInterval(self, l: "int64_t", u: "int64_t") -> "void":
        r"""
        This method removes the interval 'l' .. 'u' from the domain of
        the variable. It assumes that 'l' <= 'u'.
        """
        return _pywrapcp.IntVar_RemoveInterval(self, l, u)

    def RemoveValues(self, values: "std::vector< int64_t > const &") -> "void":
        r""" This method remove the values from the domain of the variable."""
        return _pywrapcp.IntVar_RemoveValues(self, values)

    def SetValues(self, values: "std::vector< int64_t > const &") -> "void":
        r""" This method intersects the current domain with the values in the array."""
        return _pywrapcp.IntVar_SetValues(self, values)

    def WhenBound(self, *args) -> "void":
        r"""
        *Overload 1:*
        This method attaches a demon that will be awakened when the
        variable is bound.

        |

        *Overload 2:*
        This method attaches a closure that will be awakened when the
        variable is bound.
        """
        return _pywrapcp.IntVar_WhenBound(self, *args)

    def WhenDomain(self, *args) -> "void":
        r"""
        *Overload 1:*
        This method attaches a demon that will watch any domain
        modification of the domain of the variable.

        |

        *Overload 2:*
        This method attaches a closure that will watch any domain
        modification of the domain of the variable.
        """
        return _pywrapcp.IntVar_WhenDomain(self, *args)

    def Size(self) -> "uint64_t":
        r""" This method returns the number of values in the domain of the variable."""
        return _pywrapcp.IntVar_Size(self)

    def Contains(self, v: "int64_t") -> "bool":
        r"""
        This method returns whether the value 'v' is in the domain of the
        variable.
        """
        return _pywrapcp.IntVar_Contains(self, v)

    def HoleIteratorAux(self, reversible: "bool") -> "operations_research::IntVarIterator *":
        r"""
        Creates a hole iterator. When 'reversible' is false, the returned
        object is created on the normal C++ heap and the solver does NOT
        take ownership of the object.
        """
        return _pywrapcp.IntVar_HoleIteratorAux(self, reversible)

    def DomainIteratorAux(self, reversible: "bool") -> "operations_research::IntVarIterator *":
        r"""
        Creates a domain iterator. When 'reversible' is false, the
        returned object is created on the normal C++ heap and the solver
        does NOT take ownership of the object.
        """
        return _pywrapcp.IntVar_DomainIteratorAux(self, reversible)

    def OldMin(self) -> "int64_t":
        r""" Returns the previous min."""
        return _pywrapcp.IntVar_OldMin(self)

    def OldMax(self) -> "int64_t":
        r""" Returns the previous max."""
        return _pywrapcp.IntVar_OldMax(self)

    def __repr__(self) -> "std::string":
        return _pywrapcp.IntVar___repr__(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.IntVar___str__(self)

    def DomainIterator(self):
      return iter(self.DomainIteratorAux(False))

    def HoleIterator(self):
      return iter(self.HoleIteratorAux(False))


# Register IntVar in _pywrapcp:
_pywrapcp.IntVar_swigregister(IntVar)

class SolutionCollector(SearchMonitor):
    r"""
    This class is the root class of all solution collectors.
    It implements a basic query API to be used independently
    of the collector used.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def DebugString(self) -> "std::string":
        return _pywrapcp.SolutionCollector_DebugString(self)

    def Add(self, *args) -> "void":
        return _pywrapcp.SolutionCollector_Add(self, *args)

    def AddObjective(self, objective: "IntVar") -> "void":
        return _pywrapcp.SolutionCollector_AddObjective(self, objective)

    def EnterSearch(self) -> "void":
        r""" Beginning of the search."""
        return _pywrapcp.SolutionCollector_EnterSearch(self)

    def SolutionCount(self) -> "int":
        r""" Returns how many solutions were stored during the search."""
        return _pywrapcp.SolutionCollector_SolutionCount(self)

    def Solution(self, n: "int") -> "operations_research::Assignment *":
        r""" Returns the nth solution."""
        return _pywrapcp.SolutionCollector_Solution(self, n)

    def WallTime(self, n: "int") -> "int64_t":
        r""" Returns the wall time in ms for the nth solution."""
        return _pywrapcp.SolutionCollector_WallTime(self, n)

    def Branches(self, n: "int") -> "int64_t":
        r""" Returns the number of branches when the nth solution was found."""
        return _pywrapcp.SolutionCollector_Branches(self, n)

    def Failures(self, n: "int") -> "int64_t":
        r"""
        Returns the number of failures encountered at the time of the nth
        solution.
        """
        return _pywrapcp.SolutionCollector_Failures(self, n)

    def ObjectiveValue(self, n: "int") -> "int64_t":
        r""" Returns the objective value of the nth solution."""
        return _pywrapcp.SolutionCollector_ObjectiveValue(self, n)

    def Value(self, n: "int", var: "IntVar") -> "int64_t":
        r""" This is a shortcut to get the Value of 'var' in the nth solution."""
        return _pywrapcp.SolutionCollector_Value(self, n, var)

    def StartValue(self, n: "int", var: "IntervalVar") -> "int64_t":
        r""" This is a shortcut to get the StartValue of 'var' in the nth solution."""
        return _pywrapcp.SolutionCollector_StartValue(self, n, var)

    def EndValue(self, n: "int", var: "IntervalVar") -> "int64_t":
        r""" This is a shortcut to get the EndValue of 'var' in the nth solution."""
        return _pywrapcp.SolutionCollector_EndValue(self, n, var)

    def DurationValue(self, n: "int", var: "IntervalVar") -> "int64_t":
        r""" This is a shortcut to get the DurationValue of 'var' in the nth solution."""
        return _pywrapcp.SolutionCollector_DurationValue(self, n, var)

    def PerformedValue(self, n: "int", var: "IntervalVar") -> "int64_t":
        r""" This is a shortcut to get the PerformedValue of 'var' in the nth solution."""
        return _pywrapcp.SolutionCollector_PerformedValue(self, n, var)

    def ForwardSequence(self, n: "int", var: "SequenceVar") -> "std::vector< int > const &":
        r"""
        This is a shortcut to get the ForwardSequence of 'var' in the
        nth solution. The forward sequence is the list of ranked interval
        variables starting from the start of the sequence.
        """
        return _pywrapcp.SolutionCollector_ForwardSequence(self, n, var)

    def BackwardSequence(self, n: "int", var: "SequenceVar") -> "std::vector< int > const &":
        r"""
        This is a shortcut to get the BackwardSequence of 'var' in the
        nth solution. The backward sequence is the list of ranked interval
        variables starting from the end of the sequence.
        """
        return _pywrapcp.SolutionCollector_BackwardSequence(self, n, var)

    def Unperformed(self, n: "int", var: "SequenceVar") -> "std::vector< int > const &":
        r"""
        This is a shortcut to get the list of unperformed of 'var' in the
        nth solution.
        """
        return _pywrapcp.SolutionCollector_Unperformed(self, n, var)

# Register SolutionCollector in _pywrapcp:
_pywrapcp.SolutionCollector_swigregister(SolutionCollector)

class OptimizeVar(SearchMonitor):
    r"""
    This class encapsulates an objective. It requires the direction
    (minimize or maximize), the variable to optimize, and the
    improvement step.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Best(self) -> "int64_t":
        r""" Returns the best value found during search."""
        return _pywrapcp.OptimizeVar_Best(self)

    def Var(self) -> "operations_research::IntVar *":
        r""" Returns the variable that is optimized."""
        return _pywrapcp.OptimizeVar_Var(self)

    def AcceptDelta(self, delta: "Assignment", deltadelta: "Assignment") -> "bool":
        r""" Internal methods."""
        return _pywrapcp.OptimizeVar_AcceptDelta(self, delta, deltadelta)

    def EnterSearch(self) -> "void":
        return _pywrapcp.OptimizeVar_EnterSearch(self)

    def BeginNextDecision(self, db: "DecisionBuilder") -> "void":
        return _pywrapcp.OptimizeVar_BeginNextDecision(self, db)

    def RefuteDecision(self, d: "Decision") -> "void":
        return _pywrapcp.OptimizeVar_RefuteDecision(self, d)

    def AtSolution(self) -> "bool":
        return _pywrapcp.OptimizeVar_AtSolution(self)

    def AcceptSolution(self) -> "bool":
        return _pywrapcp.OptimizeVar_AcceptSolution(self)

    def DebugString(self) -> "std::string":
        return _pywrapcp.OptimizeVar_DebugString(self)

# Register OptimizeVar in _pywrapcp:
_pywrapcp.OptimizeVar_swigregister(OptimizeVar)

class SearchLimit(SearchMonitor):
    r""" Base class of all search limits."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pywrapcp.delete_SearchLimit

    def Crossed(self) -> "bool":
        r""" Returns true if the limit has been crossed."""
        return _pywrapcp.SearchLimit_Crossed(self)

    def Check(self) -> "bool":
        r"""
        This method is called to check the status of the limit. A return
        value of true indicates that we have indeed crossed the limit. In
        that case, this method will not be called again and the remaining
        search will be discarded.
        """
        return _pywrapcp.SearchLimit_Check(self)

    def Init(self) -> "void":
        r""" This method is called when the search limit is initialized."""
        return _pywrapcp.SearchLimit_Init(self)

    def EnterSearch(self) -> "void":
        r""" Internal methods."""
        return _pywrapcp.SearchLimit_EnterSearch(self)

    def BeginNextDecision(self, b: "DecisionBuilder") -> "void":
        return _pywrapcp.SearchLimit_BeginNextDecision(self, b)

    def RefuteDecision(self, d: "Decision") -> "void":
        return _pywrapcp.SearchLimit_RefuteDecision(self, d)

    def DebugString(self) -> "std::string":
        return _pywrapcp.SearchLimit_DebugString(self)

# Register SearchLimit in _pywrapcp:
_pywrapcp.SearchLimit_swigregister(SearchLimit)

class IntervalVar(PropagationBaseObject):
    r"""
    Interval variables are often used in scheduling. The main characteristics
    of an IntervalVar are the start position, duration, and end
    date. All these characteristics can be queried and set, and demons can
    be posted on their modifications.

    An important aspect is optionality: an IntervalVar can be performed or not.
    If unperformed, then it simply does not exist, and its characteristics
    cannot be accessed any more. An interval var is automatically marked
    as unperformed when it is not consistent anymore (start greater
    than end, duration < 0...)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def StartMin(self) -> "int64_t":
        r"""
        These methods query, set, and watch the start position of the
        interval var.
        """
        return _pywrapcp.IntervalVar_StartMin(self)

    def StartMax(self) -> "int64_t":
        return _pywrapcp.IntervalVar_StartMax(self)

    def SetStartMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetStartMin(self, m)

    def SetStartMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetStartMax(self, m)

    def SetStartRange(self, mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetStartRange(self, mi, ma)

    def OldStartMin(self) -> "int64_t":
        return _pywrapcp.IntervalVar_OldStartMin(self)

    def OldStartMax(self) -> "int64_t":
        return _pywrapcp.IntervalVar_OldStartMax(self)

    def WhenStartRange(self, *args) -> "void":
        return _pywrapcp.IntervalVar_WhenStartRange(self, *args)

    def WhenStartBound(self, *args) -> "void":
        return _pywrapcp.IntervalVar_WhenStartBound(self, *args)

    def DurationMin(self) -> "int64_t":
        r""" These methods query, set, and watch the duration of the interval var."""
        return _pywrapcp.IntervalVar_DurationMin(self)

    def DurationMax(self) -> "int64_t":
        return _pywrapcp.IntervalVar_DurationMax(self)

    def SetDurationMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetDurationMin(self, m)

    def SetDurationMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetDurationMax(self, m)

    def SetDurationRange(self, mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetDurationRange(self, mi, ma)

    def OldDurationMin(self) -> "int64_t":
        return _pywrapcp.IntervalVar_OldDurationMin(self)

    def OldDurationMax(self) -> "int64_t":
        return _pywrapcp.IntervalVar_OldDurationMax(self)

    def WhenDurationRange(self, *args) -> "void":
        return _pywrapcp.IntervalVar_WhenDurationRange(self, *args)

    def WhenDurationBound(self, *args) -> "void":
        return _pywrapcp.IntervalVar_WhenDurationBound(self, *args)

    def EndMin(self) -> "int64_t":
        r""" These methods query, set, and watch the end position of the interval var."""
        return _pywrapcp.IntervalVar_EndMin(self)

    def EndMax(self) -> "int64_t":
        return _pywrapcp.IntervalVar_EndMax(self)

    def SetEndMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetEndMin(self, m)

    def SetEndMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetEndMax(self, m)

    def SetEndRange(self, mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.IntervalVar_SetEndRange(self, mi, ma)

    def OldEndMin(self) -> "int64_t":
        return _pywrapcp.IntervalVar_OldEndMin(self)

    def OldEndMax(self) -> "int64_t":
        return _pywrapcp.IntervalVar_OldEndMax(self)

    def WhenEndRange(self, *args) -> "void":
        return _pywrapcp.IntervalVar_WhenEndRange(self, *args)

    def WhenEndBound(self, *args) -> "void":
        return _pywrapcp.IntervalVar_WhenEndBound(self, *args)

    def MustBePerformed(self) -> "bool":
        r"""
        These methods query, set, and watch the performed status of the
        interval var.
        """
        return _pywrapcp.IntervalVar_MustBePerformed(self)

    def MayBePerformed(self) -> "bool":
        return _pywrapcp.IntervalVar_MayBePerformed(self)

    def CannotBePerformed(self) -> "bool":
        return _pywrapcp.IntervalVar_CannotBePerformed(self)

    def IsPerformedBound(self) -> "bool":
        return _pywrapcp.IntervalVar_IsPerformedBound(self)

    def SetPerformed(self, val: "bool") -> "void":
        return _pywrapcp.IntervalVar_SetPerformed(self, val)

    def WasPerformedBound(self) -> "bool":
        return _pywrapcp.IntervalVar_WasPerformedBound(self)

    def WhenPerformedBound(self, *args) -> "void":
        return _pywrapcp.IntervalVar_WhenPerformedBound(self, *args)

    def WhenAnything(self, *args) -> "void":
        r"""
        *Overload 1:*
        Attaches a demon awakened when anything about this interval changes.

        |

        *Overload 2:*
        Attaches a closure awakened when anything about this interval changes.
        """
        return _pywrapcp.IntervalVar_WhenAnything(self, *args)

    def StartExpr(self) -> "operations_research::IntExpr *":
        r"""
        These methods create expressions encapsulating the start, end
        and duration of the interval var. Please note that these must not
        be used if the interval var is unperformed.
        """
        return _pywrapcp.IntervalVar_StartExpr(self)

    def DurationExpr(self) -> "operations_research::IntExpr *":
        return _pywrapcp.IntervalVar_DurationExpr(self)

    def EndExpr(self) -> "operations_research::IntExpr *":
        return _pywrapcp.IntervalVar_EndExpr(self)

    def PerformedExpr(self) -> "operations_research::IntExpr *":
        return _pywrapcp.IntervalVar_PerformedExpr(self)

    def SafeStartExpr(self, unperformed_value: "int64_t") -> "operations_research::IntExpr *":
        r"""
        These methods create expressions encapsulating the start, end
        and duration of the interval var. If the interval var is
        unperformed, they will return the unperformed_value.
        """
        return _pywrapcp.IntervalVar_SafeStartExpr(self, unperformed_value)

    def SafeDurationExpr(self, unperformed_value: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.IntervalVar_SafeDurationExpr(self, unperformed_value)

    def SafeEndExpr(self, unperformed_value: "int64_t") -> "operations_research::IntExpr *":
        return _pywrapcp.IntervalVar_SafeEndExpr(self, unperformed_value)

    def EndsAfterEnd(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAfterEnd(self, other)

    def EndsAfterEndWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAfterEndWithDelay(self, other, delay)

    def EndsAfterStart(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAfterStart(self, other)

    def EndsAfterStartWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAfterStartWithDelay(self, other, delay)

    def EndsAtEnd(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAtEnd(self, other)

    def EndsAtEndWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAtEndWithDelay(self, other, delay)

    def EndsAtStart(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAtStart(self, other)

    def EndsAtStartWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAtStartWithDelay(self, other, delay)

    def StartsAfterEnd(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAfterEnd(self, other)

    def StartsAfterEndWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAfterEndWithDelay(self, other, delay)

    def StartsAfterStart(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAfterStart(self, other)

    def StartsAfterStartWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAfterStartWithDelay(self, other, delay)

    def StartsAtEnd(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAtEnd(self, other)

    def StartsAtEndWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAtEndWithDelay(self, other, delay)

    def StartsAtStart(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAtStart(self, other)

    def StartsAtStartWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAtStartWithDelay(self, other, delay)

    def StaysInSync(self, other: "IntervalVar") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StaysInSync(self, other)

    def StaysInSyncWithDelay(self, other: "IntervalVar", delay: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StaysInSyncWithDelay(self, other, delay)

    def EndsAfter(self, date: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAfter(self, date)

    def EndsAt(self, date: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsAt(self, date)

    def EndsBefore(self, date: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_EndsBefore(self, date)

    def StartsAfter(self, date: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAfter(self, date)

    def StartsAt(self, date: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsAt(self, date)

    def StartsBefore(self, date: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_StartsBefore(self, date)

    def CrossesDate(self, date: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_CrossesDate(self, date)

    def AvoidsDate(self, date: "int64_t") -> "operations_research::Constraint *":
        return _pywrapcp.IntervalVar_AvoidsDate(self, date)

    def __repr__(self) -> "std::string":
        return _pywrapcp.IntervalVar___repr__(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.IntervalVar___str__(self)

# Register IntervalVar in _pywrapcp:
_pywrapcp.IntervalVar_swigregister(IntervalVar)

class SequenceVar(PropagationBaseObject):
    r"""
    A sequence variable is a variable whose domain is a set of possible
    orderings of the interval variables. It allows ordering of tasks. It
    has two sets of methods: ComputePossibleFirstsAndLasts(), which
    returns the list of interval variables that can be ranked first or
    last; and RankFirst/RankNotFirst/RankLast/RankNotLast, which can be
    used to create the search decision.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    def DebugString(self) -> "std::string":
        return _pywrapcp.SequenceVar_DebugString(self)

    def RankFirst(self, index: "int") -> "void":
        r"""
        Ranks the index_th interval var first of all unranked interval
        vars. After that, it will no longer be considered ranked.
        """
        return _pywrapcp.SequenceVar_RankFirst(self, index)

    def RankNotFirst(self, index: "int") -> "void":
        r"""
        Indicates that the index_th interval var will not be ranked first
        of all currently unranked interval vars.
        """
        return _pywrapcp.SequenceVar_RankNotFirst(self, index)

    def RankLast(self, index: "int") -> "void":
        r"""
        Ranks the index_th interval var first of all unranked interval
        vars. After that, it will no longer be considered ranked.
        """
        return _pywrapcp.SequenceVar_RankLast(self, index)

    def RankNotLast(self, index: "int") -> "void":
        r"""
        Indicates that the index_th interval var will not be ranked first
        of all currently unranked interval vars.
        """
        return _pywrapcp.SequenceVar_RankNotLast(self, index)

    def Interval(self, index: "int") -> "operations_research::IntervalVar *":
        r""" Returns the index_th interval of the sequence."""
        return _pywrapcp.SequenceVar_Interval(self, index)

    def Next(self, index: "int") -> "operations_research::IntVar *":
        r""" Returns the next of the index_th interval of the sequence."""
        return _pywrapcp.SequenceVar_Next(self, index)

    def Size(self) -> "int64_t":
        r""" Returns the number of interval vars in the sequence."""
        return _pywrapcp.SequenceVar_Size(self)

    def __repr__(self) -> "std::string":
        return _pywrapcp.SequenceVar___repr__(self)

    def __str__(self) -> "std::string":
        return _pywrapcp.SequenceVar___str__(self)

# Register SequenceVar in _pywrapcp:
_pywrapcp.SequenceVar_swigregister(SequenceVar)

class AssignmentElement(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Activate(self) -> "void":
        return _pywrapcp.AssignmentElement_Activate(self)

    def Deactivate(self) -> "void":
        return _pywrapcp.AssignmentElement_Deactivate(self)

    def Activated(self) -> "bool":
        return _pywrapcp.AssignmentElement_Activated(self)
    __swig_destroy__ = _pywrapcp.delete_AssignmentElement

# Register AssignmentElement in _pywrapcp:
_pywrapcp.AssignmentElement_swigregister(AssignmentElement)

class IntVarElement(AssignmentElement):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Var(self) -> "operations_research::IntVar *":
        return _pywrapcp.IntVarElement_Var(self)

    def Min(self) -> "int64_t":
        return _pywrapcp.IntVarElement_Min(self)

    def SetMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntVarElement_SetMin(self, m)

    def Max(self) -> "int64_t":
        return _pywrapcp.IntVarElement_Max(self)

    def SetMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntVarElement_SetMax(self, m)

    def Value(self) -> "int64_t":
        return _pywrapcp.IntVarElement_Value(self)

    def Bound(self) -> "bool":
        return _pywrapcp.IntVarElement_Bound(self)

    def SetRange(self, l: "int64_t", u: "int64_t") -> "void":
        return _pywrapcp.IntVarElement_SetRange(self, l, u)

    def SetValue(self, v: "int64_t") -> "void":
        return _pywrapcp.IntVarElement_SetValue(self, v)

    def __eq__(self, element: "IntVarElement") -> "bool":
        return _pywrapcp.IntVarElement___eq__(self, element)

    def __ne__(self, element: "IntVarElement") -> "bool":
        return _pywrapcp.IntVarElement___ne__(self, element)
    __swig_destroy__ = _pywrapcp.delete_IntVarElement

# Register IntVarElement in _pywrapcp:
_pywrapcp.IntVarElement_swigregister(IntVarElement)

class IntervalVarElement(AssignmentElement):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Var(self) -> "operations_research::IntervalVar *":
        return _pywrapcp.IntervalVarElement_Var(self)

    def StartMin(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_StartMin(self)

    def StartMax(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_StartMax(self)

    def StartValue(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_StartValue(self)

    def DurationMin(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_DurationMin(self)

    def DurationMax(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_DurationMax(self)

    def DurationValue(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_DurationValue(self)

    def EndMin(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_EndMin(self)

    def EndMax(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_EndMax(self)

    def EndValue(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_EndValue(self)

    def PerformedMin(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_PerformedMin(self)

    def PerformedMax(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_PerformedMax(self)

    def PerformedValue(self) -> "int64_t":
        return _pywrapcp.IntervalVarElement_PerformedValue(self)

    def SetStartMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetStartMin(self, m)

    def SetStartMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetStartMax(self, m)

    def SetStartRange(self, mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetStartRange(self, mi, ma)

    def SetStartValue(self, v: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetStartValue(self, v)

    def SetDurationMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetDurationMin(self, m)

    def SetDurationMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetDurationMax(self, m)

    def SetDurationRange(self, mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetDurationRange(self, mi, ma)

    def SetDurationValue(self, v: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetDurationValue(self, v)

    def SetEndMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetEndMin(self, m)

    def SetEndMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetEndMax(self, m)

    def SetEndRange(self, mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetEndRange(self, mi, ma)

    def SetEndValue(self, v: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetEndValue(self, v)

    def SetPerformedMin(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetPerformedMin(self, m)

    def SetPerformedMax(self, m: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetPerformedMax(self, m)

    def SetPerformedRange(self, mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetPerformedRange(self, mi, ma)

    def SetPerformedValue(self, v: "int64_t") -> "void":
        return _pywrapcp.IntervalVarElement_SetPerformedValue(self, v)

    def __eq__(self, element: "IntervalVarElement") -> "bool":
        return _pywrapcp.IntervalVarElement___eq__(self, element)

    def __ne__(self, element: "IntervalVarElement") -> "bool":
        return _pywrapcp.IntervalVarElement___ne__(self, element)
    __swig_destroy__ = _pywrapcp.delete_IntervalVarElement

# Register IntervalVarElement in _pywrapcp:
_pywrapcp.IntervalVarElement_swigregister(IntervalVarElement)

class SequenceVarElement(AssignmentElement):
    r"""
    The SequenceVarElement stores a partial representation of ranked
    interval variables in the underlying sequence variable.
    This representation consists of three vectors:
      - the forward sequence. That is the list of interval variables
        ranked first in the sequence.  The first element of the backward
        sequence is the first interval in the sequence variable.
      - the backward sequence. That is the list of interval variables
        ranked last in the sequence. The first element of the backward
        sequence is the last interval in the sequence variable.
      - The list of unperformed interval variables.
     Furthermore, if all performed variables are ranked, then by
     convention, the forward_sequence will contain all such variables
     and the backward_sequence will be empty.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Var(self) -> "operations_research::SequenceVar *":
        return _pywrapcp.SequenceVarElement_Var(self)

    def ForwardSequence(self) -> "std::vector< int > const &":
        return _pywrapcp.SequenceVarElement_ForwardSequence(self)

    def BackwardSequence(self) -> "std::vector< int > const &":
        return _pywrapcp.SequenceVarElement_BackwardSequence(self)

    def Unperformed(self) -> "std::vector< int > const &":
        return _pywrapcp.SequenceVarElement_Unperformed(self)

    def SetSequence(self, forward_sequence: "std::vector< int > const &", backward_sequence: "std::vector< int > const &", unperformed: "std::vector< int > const &") -> "void":
        return _pywrapcp.SequenceVarElement_SetSequence(self, forward_sequence, backward_sequence, unperformed)

    def SetForwardSequence(self, forward_sequence: "std::vector< int > const &") -> "void":
        return _pywrapcp.SequenceVarElement_SetForwardSequence(self, forward_sequence)

    def SetBackwardSequence(self, backward_sequence: "std::vector< int > const &") -> "void":
        return _pywrapcp.SequenceVarElement_SetBackwardSequence(self, backward_sequence)

    def SetUnperformed(self, unperformed: "std::vector< int > const &") -> "void":
        return _pywrapcp.SequenceVarElement_SetUnperformed(self, unperformed)

    def __eq__(self, element: "SequenceVarElement") -> "bool":
        return _pywrapcp.SequenceVarElement___eq__(self, element)

    def __ne__(self, element: "SequenceVarElement") -> "bool":
        return _pywrapcp.SequenceVarElement___ne__(self, element)
    __swig_destroy__ = _pywrapcp.delete_SequenceVarElement

# Register SequenceVarElement in _pywrapcp:
_pywrapcp.SequenceVarElement_swigregister(SequenceVarElement)

class Assignment(PropagationBaseObject):
    r"""
    An Assignment is a variable -> domains mapping, used
    to report solutions to the user.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Clear(self) -> "void":
        return _pywrapcp.Assignment_Clear(self)

    def Empty(self) -> "bool":
        return _pywrapcp.Assignment_Empty(self)

    def Size(self) -> "int":
        return _pywrapcp.Assignment_Size(self)

    def NumIntVars(self) -> "int":
        return _pywrapcp.Assignment_NumIntVars(self)

    def NumIntervalVars(self) -> "int":
        return _pywrapcp.Assignment_NumIntervalVars(self)

    def NumSequenceVars(self) -> "int":
        return _pywrapcp.Assignment_NumSequenceVars(self)

    def Store(self) -> "void":
        return _pywrapcp.Assignment_Store(self)

    def Restore(self) -> "void":
        return _pywrapcp.Assignment_Restore(self)

    def Load(self, *args) -> "void":
        return _pywrapcp.Assignment_Load(self, *args)

    def Save(self, *args) -> "void":
        return _pywrapcp.Assignment_Save(self, *args)

    def AddObjective(self, v: "IntVar") -> "void":
        return _pywrapcp.Assignment_AddObjective(self, v)

    def Objective(self) -> "operations_research::IntVar *":
        return _pywrapcp.Assignment_Objective(self)

    def HasObjective(self) -> "bool":
        return _pywrapcp.Assignment_HasObjective(self)

    def ObjectiveMin(self) -> "int64_t":
        return _pywrapcp.Assignment_ObjectiveMin(self)

    def ObjectiveMax(self) -> "int64_t":
        return _pywrapcp.Assignment_ObjectiveMax(self)

    def ObjectiveValue(self) -> "int64_t":
        return _pywrapcp.Assignment_ObjectiveValue(self)

    def ObjectiveBound(self) -> "bool":
        return _pywrapcp.Assignment_ObjectiveBound(self)

    def SetObjectiveMin(self, m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetObjectiveMin(self, m)

    def SetObjectiveMax(self, m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetObjectiveMax(self, m)

    def SetObjectiveValue(self, value: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetObjectiveValue(self, value)

    def SetObjectiveRange(self, l: "int64_t", u: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetObjectiveRange(self, l, u)

    def Min(self, var: "IntVar") -> "int64_t":
        return _pywrapcp.Assignment_Min(self, var)

    def Max(self, var: "IntVar") -> "int64_t":
        return _pywrapcp.Assignment_Max(self, var)

    def Value(self, var: "IntVar") -> "int64_t":
        return _pywrapcp.Assignment_Value(self, var)

    def Bound(self, var: "IntVar") -> "bool":
        return _pywrapcp.Assignment_Bound(self, var)

    def SetMin(self, var: "IntVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetMin(self, var, m)

    def SetMax(self, var: "IntVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetMax(self, var, m)

    def SetRange(self, var: "IntVar", l: "int64_t", u: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetRange(self, var, l, u)

    def SetValue(self, var: "IntVar", value: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetValue(self, var, value)

    def StartMin(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_StartMin(self, var)

    def StartMax(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_StartMax(self, var)

    def StartValue(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_StartValue(self, var)

    def DurationMin(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_DurationMin(self, var)

    def DurationMax(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_DurationMax(self, var)

    def DurationValue(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_DurationValue(self, var)

    def EndMin(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_EndMin(self, var)

    def EndMax(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_EndMax(self, var)

    def EndValue(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_EndValue(self, var)

    def PerformedMin(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_PerformedMin(self, var)

    def PerformedMax(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_PerformedMax(self, var)

    def PerformedValue(self, var: "IntervalVar") -> "int64_t":
        return _pywrapcp.Assignment_PerformedValue(self, var)

    def SetStartMin(self, var: "IntervalVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetStartMin(self, var, m)

    def SetStartMax(self, var: "IntervalVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetStartMax(self, var, m)

    def SetStartRange(self, var: "IntervalVar", mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetStartRange(self, var, mi, ma)

    def SetStartValue(self, var: "IntervalVar", value: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetStartValue(self, var, value)

    def SetDurationMin(self, var: "IntervalVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetDurationMin(self, var, m)

    def SetDurationMax(self, var: "IntervalVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetDurationMax(self, var, m)

    def SetDurationRange(self, var: "IntervalVar", mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetDurationRange(self, var, mi, ma)

    def SetDurationValue(self, var: "IntervalVar", value: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetDurationValue(self, var, value)

    def SetEndMin(self, var: "IntervalVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetEndMin(self, var, m)

    def SetEndMax(self, var: "IntervalVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetEndMax(self, var, m)

    def SetEndRange(self, var: "IntervalVar", mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetEndRange(self, var, mi, ma)

    def SetEndValue(self, var: "IntervalVar", value: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetEndValue(self, var, value)

    def SetPerformedMin(self, var: "IntervalVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetPerformedMin(self, var, m)

    def SetPerformedMax(self, var: "IntervalVar", m: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetPerformedMax(self, var, m)

    def SetPerformedRange(self, var: "IntervalVar", mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetPerformedRange(self, var, mi, ma)

    def SetPerformedValue(self, var: "IntervalVar", value: "int64_t") -> "void":
        return _pywrapcp.Assignment_SetPerformedValue(self, var, value)

    def Add(self, *args) -> "void":
        return _pywrapcp.Assignment_Add(self, *args)

    def ForwardSequence(self, var: "SequenceVar") -> "std::vector< int > const &":
        return _pywrapcp.Assignment_ForwardSequence(self, var)

    def BackwardSequence(self, var: "SequenceVar") -> "std::vector< int > const &":
        return _pywrapcp.Assignment_BackwardSequence(self, var)

    def Unperformed(self, var: "SequenceVar") -> "std::vector< int > const &":
        return _pywrapcp.Assignment_Unperformed(self, var)

    def SetSequence(self, var: "SequenceVar", forward_sequence: "std::vector< int > const &", backward_sequence: "std::vector< int > const &", unperformed: "std::vector< int > const &") -> "void":
        return _pywrapcp.Assignment_SetSequence(self, var, forward_sequence, backward_sequence, unperformed)

    def SetForwardSequence(self, var: "SequenceVar", forward_sequence: "std::vector< int > const &") -> "void":
        return _pywrapcp.Assignment_SetForwardSequence(self, var, forward_sequence)

    def SetBackwardSequence(self, var: "SequenceVar", backward_sequence: "std::vector< int > const &") -> "void":
        return _pywrapcp.Assignment_SetBackwardSequence(self, var, backward_sequence)

    def SetUnperformed(self, var: "SequenceVar", unperformed: "std::vector< int > const &") -> "void":
        return _pywrapcp.Assignment_SetUnperformed(self, var, unperformed)

    def Activate(self, *args) -> "void":
        return _pywrapcp.Assignment_Activate(self, *args)

    def Deactivate(self, *args) -> "void":
        return _pywrapcp.Assignment_Deactivate(self, *args)

    def Activated(self, *args) -> "bool":
        return _pywrapcp.Assignment_Activated(self, *args)

    def DebugString(self) -> "std::string":
        return _pywrapcp.Assignment_DebugString(self)

    def IntVarContainer(self) -> "operations_research::Assignment::IntContainer const &":
        return _pywrapcp.Assignment_IntVarContainer(self)

    def MutableIntVarContainer(self) -> "operations_research::Assignment::IntContainer *":
        return _pywrapcp.Assignment_MutableIntVarContainer(self)

    def IntervalVarContainer(self) -> "operations_research::Assignment::IntervalContainer const &":
        return _pywrapcp.Assignment_IntervalVarContainer(self)

    def MutableIntervalVarContainer(self) -> "operations_research::Assignment::IntervalContainer *":
        return _pywrapcp.Assignment_MutableIntervalVarContainer(self)

    def SequenceVarContainer(self) -> "operations_research::Assignment::SequenceContainer const &":
        return _pywrapcp.Assignment_SequenceVarContainer(self)

    def MutableSequenceVarContainer(self) -> "operations_research::Assignment::SequenceContainer *":
        return _pywrapcp.Assignment_MutableSequenceVarContainer(self)

    def __eq__(self, assignment: "Assignment") -> "bool":
        return _pywrapcp.Assignment___eq__(self, assignment)

    def __ne__(self, assignment: "Assignment") -> "bool":
        return _pywrapcp.Assignment___ne__(self, assignment)

# Register Assignment in _pywrapcp:
_pywrapcp.Assignment_swigregister(Assignment)


def __lshift__(*args) -> "std::ostream &":
    return _pywrapcp.__lshift__(*args)
class Pack(Constraint):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddWeightedSumLessOrEqualConstantDimension(self, *args) -> "void":
        r"""
        *Overload 1:*
        Dimensions are additional constraints than can restrict what is
        possible with the pack constraint. It can be used to set capacity
        limits, to count objects per bin, to compute unassigned
        penalties...
        This dimension imposes that for all bins b, the weighted sum
        (weights[i]) of all objects i assigned to 'b' is less or equal
        'bounds[b]'.

        |

        *Overload 2:*
        This dimension imposes that for all bins b, the weighted sum
        (weights->Run(i)) of all objects i assigned to 'b' is less or
        equal to 'bounds[b]'. Ownership of the callback is transferred to
        the pack constraint.

        |

        *Overload 3:*
        This dimension imposes that for all bins b, the weighted sum
        (weights->Run(i, b) of all objects i assigned to 'b' is less or
        equal to 'bounds[b]'. Ownership of the callback is transferred to
        the pack constraint.
        """
        return _pywrapcp.Pack_AddWeightedSumLessOrEqualConstantDimension(self, *args)

    def AddWeightedSumEqualVarDimension(self, *args) -> "void":
        r"""
        *Overload 1:*
        This dimension imposes that for all bins b, the weighted sum
        (weights[i]) of all objects i assigned to 'b' is equal to loads[b].

        |

        *Overload 2:*
        This dimension imposes that for all bins b, the weighted sum
        (weights->Run(i, b)) of all objects i assigned to 'b' is equal to
        loads[b].
        """
        return _pywrapcp.Pack_AddWeightedSumEqualVarDimension(self, *args)

    def AddSumVariableWeightsLessOrEqualConstantDimension(self, usage: "std::vector< operations_research::IntVar * > const &", capacity: "std::vector< int64_t > const &") -> "void":
        r"""
        This dimension imposes:
        forall b in bins,
           sum (i in items: usage[i] * is_assigned(i, b)) <= capacity[b]
        where is_assigned(i, b) is true if and only if item i is assigned
        to the bin b.

        This can be used to model shapes of items by linking variables of
        the same item on parallel dimensions with an allowed assignment
        constraint.
        """
        return _pywrapcp.Pack_AddSumVariableWeightsLessOrEqualConstantDimension(self, usage, capacity)

    def AddWeightedSumOfAssignedDimension(self, weights: "std::vector< int64_t > const &", cost_var: "IntVar") -> "void":
        r"""
        This dimension enforces that cost_var == sum of weights[i] for
        all objects 'i' assigned to a bin.
        """
        return _pywrapcp.Pack_AddWeightedSumOfAssignedDimension(self, weights, cost_var)

    def AddCountUsedBinDimension(self, count_var: "IntVar") -> "void":
        r"""
        This dimension links 'count_var' to the actual number of bins used in the
        pack.
        """
        return _pywrapcp.Pack_AddCountUsedBinDimension(self, count_var)

    def AddCountAssignedItemsDimension(self, count_var: "IntVar") -> "void":
        r"""
        This dimension links 'count_var' to the actual number of items
        assigned to a bin in the pack.
        """
        return _pywrapcp.Pack_AddCountAssignedItemsDimension(self, count_var)

    def Post(self) -> "void":
        return _pywrapcp.Pack_Post(self)

    def InitialPropagateWrapper(self) -> "void":
        return _pywrapcp.Pack_InitialPropagateWrapper(self)

    def DebugString(self) -> "std::string":
        return _pywrapcp.Pack_DebugString(self)

# Register Pack in _pywrapcp:
_pywrapcp.Pack_swigregister(Pack)

class DisjunctiveConstraint(Constraint):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def SequenceVar(self) -> "operations_research::SequenceVar *":
        r""" Creates a sequence variable from the constraint."""
        return _pywrapcp.DisjunctiveConstraint_SequenceVar(self)

    def SetTransitionTime(self, transition_time: "operations_research::Solver::IndexEvaluator2") -> "void":
        r"""
        Add a transition time between intervals.  It forces the distance between
        the end of interval a and start of interval b that follows it to be at
        least transition_time(a, b). This function must always return
        a positive or null value.
        """
        return _pywrapcp.DisjunctiveConstraint_SetTransitionTime(self, transition_time)

    def TransitionTime(self, before_index: "int", after_index: "int") -> "int64_t":
        return _pywrapcp.DisjunctiveConstraint_TransitionTime(self, before_index, after_index)

# Register DisjunctiveConstraint in _pywrapcp:
_pywrapcp.DisjunctiveConstraint_swigregister(DisjunctiveConstraint)

class RevInteger(object):
    r"""
    This class adds reversibility to a POD type.
    It contains the stamp optimization. i.e. the SaveValue call is done
    only once per node of the search tree.  Please note that actual
    stamps always starts at 1, thus an initial value of 0 will always
    trigger the first SaveValue.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, val: "long const &"):
        _pywrapcp.RevInteger_swiginit(self, _pywrapcp.new_RevInteger(val))

    def Value(self) -> "long const &":
        return _pywrapcp.RevInteger_Value(self)

    def SetValue(self, s: "Solver", val: "long const &") -> "void":
        return _pywrapcp.RevInteger_SetValue(self, s, val)
    __swig_destroy__ = _pywrapcp.delete_RevInteger

# Register RevInteger in _pywrapcp:
_pywrapcp.RevInteger_swigregister(RevInteger)

class NumericalRevInteger(RevInteger):
    r""" Subclass of Rev<T> which adds numerical operations."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, val: "long const &"):
        _pywrapcp.NumericalRevInteger_swiginit(self, _pywrapcp.new_NumericalRevInteger(val))

    def Add(self, s: "Solver", to_add: "long const &") -> "void":
        return _pywrapcp.NumericalRevInteger_Add(self, s, to_add)

    def Incr(self, s: "Solver") -> "void":
        return _pywrapcp.NumericalRevInteger_Incr(self, s)

    def Decr(self, s: "Solver") -> "void":
        return _pywrapcp.NumericalRevInteger_Decr(self, s)
    __swig_destroy__ = _pywrapcp.delete_NumericalRevInteger

# Register NumericalRevInteger in _pywrapcp:
_pywrapcp.NumericalRevInteger_swigregister(NumericalRevInteger)

class RevBool(object):
    r"""
    This class adds reversibility to a POD type.
    It contains the stamp optimization. i.e. the SaveValue call is done
    only once per node of the search tree.  Please note that actual
    stamps always starts at 1, thus an initial value of 0 will always
    trigger the first SaveValue.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, val: "bool const &"):
        _pywrapcp.RevBool_swiginit(self, _pywrapcp.new_RevBool(val))

    def Value(self) -> "bool const &":
        return _pywrapcp.RevBool_Value(self)

    def SetValue(self, s: "Solver", val: "bool const &") -> "void":
        return _pywrapcp.RevBool_SetValue(self, s, val)
    __swig_destroy__ = _pywrapcp.delete_RevBool

# Register RevBool in _pywrapcp:
_pywrapcp.RevBool_swigregister(RevBool)

class IntVarContainer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Contains(self, var: "IntVar") -> "bool":
        return _pywrapcp.IntVarContainer_Contains(self, var)

    def Element(self, index: "int") -> "operations_research::IntVarElement *":
        return _pywrapcp.IntVarContainer_Element(self, index)

    def Size(self) -> "int":
        return _pywrapcp.IntVarContainer_Size(self)

    def Store(self) -> "void":
        return _pywrapcp.IntVarContainer_Store(self)

    def Restore(self) -> "void":
        return _pywrapcp.IntVarContainer_Restore(self)

    def __eq__(self, container: "IntVarContainer") -> "bool":
        r"""
        Returns true if this and 'container' both represent the same V* -> E map.
        Runs in linear time; requires that the == operator on the type E is well
        defined.
        """
        return _pywrapcp.IntVarContainer___eq__(self, container)

    def __ne__(self, container: "IntVarContainer") -> "bool":
        return _pywrapcp.IntVarContainer___ne__(self, container)
    __swig_destroy__ = _pywrapcp.delete_IntVarContainer

# Register IntVarContainer in _pywrapcp:
_pywrapcp.IntVarContainer_swigregister(IntVarContainer)

class IntervalVarContainer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Contains(self, var: "IntervalVar") -> "bool":
        return _pywrapcp.IntervalVarContainer_Contains(self, var)

    def Element(self, index: "int") -> "operations_research::IntervalVarElement *":
        return _pywrapcp.IntervalVarContainer_Element(self, index)

    def Size(self) -> "int":
        return _pywrapcp.IntervalVarContainer_Size(self)

    def Store(self) -> "void":
        return _pywrapcp.IntervalVarContainer_Store(self)

    def Restore(self) -> "void":
        return _pywrapcp.IntervalVarContainer_Restore(self)

    def __eq__(self, container: "IntervalVarContainer") -> "bool":
        r"""
        Returns true if this and 'container' both represent the same V* -> E map.
        Runs in linear time; requires that the == operator on the type E is well
        defined.
        """
        return _pywrapcp.IntervalVarContainer___eq__(self, container)

    def __ne__(self, container: "IntervalVarContainer") -> "bool":
        return _pywrapcp.IntervalVarContainer___ne__(self, container)
    __swig_destroy__ = _pywrapcp.delete_IntervalVarContainer

# Register IntervalVarContainer in _pywrapcp:
_pywrapcp.IntervalVarContainer_swigregister(IntervalVarContainer)

class SequenceVarContainer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Contains(self, var: "SequenceVar") -> "bool":
        return _pywrapcp.SequenceVarContainer_Contains(self, var)

    def Element(self, index: "int") -> "operations_research::SequenceVarElement *":
        return _pywrapcp.SequenceVarContainer_Element(self, index)

    def Size(self) -> "int":
        return _pywrapcp.SequenceVarContainer_Size(self)

    def Store(self) -> "void":
        return _pywrapcp.SequenceVarContainer_Store(self)

    def Restore(self) -> "void":
        return _pywrapcp.SequenceVarContainer_Restore(self)

    def __eq__(self, container: "SequenceVarContainer") -> "bool":
        r"""
        Returns true if this and 'container' both represent the same V* -> E map.
        Runs in linear time; requires that the == operator on the type E is well
        defined.
        """
        return _pywrapcp.SequenceVarContainer___eq__(self, container)

    def __ne__(self, container: "SequenceVarContainer") -> "bool":
        return _pywrapcp.SequenceVarContainer___ne__(self, container)
    __swig_destroy__ = _pywrapcp.delete_SequenceVarContainer

# Register SequenceVarContainer in _pywrapcp:
_pywrapcp.SequenceVarContainer_swigregister(SequenceVarContainer)

class LocalSearchOperator(BaseObject):
    r"""
    This class represent a reversible FIFO structure.
    The main difference w.r.t a standard FIFO structure is that a Solver is
    given as parameter to the modifiers such that the solver can store the
    backtrack information
    Iterator's traversing order should not be changed, as some algorithm
    depend on it to be consistent.
    It's main use is to store a list of demons in the various classes of
    variables.
    The base class for all local search operators.

    A local search operator is an object that defines the neighborhood of a
    solution. In other words, a neighborhood is the set of solutions which can
    be reached from a given solution using an operator.

    The behavior of the LocalSearchOperator class is similar to iterators.
    The operator is synchronized with an assignment (gives the
    current values of the variables); this is done in the Start() method.

    Then one can iterate over the neighbors using the MakeNextNeighbor method.
    This method returns an assignment which represents the incremental changes
    to the current solution. It also returns a second assignment representing
    the changes to the last solution defined by the neighborhood operator; this
    assignment is empty if the neighborhood operator cannot track this
    information.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def NextNeighbor(self, delta: "Assignment", deltadelta: "Assignment") -> "bool":
        return _pywrapcp.LocalSearchOperator_NextNeighbor(self, delta, deltadelta)

    def Start(self, assignment: "Assignment") -> "void":
        return _pywrapcp.LocalSearchOperator_Start(self, assignment)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_LocalSearchOperator(self)
        return weakref.proxy(self)

# Register LocalSearchOperator in _pywrapcp:
_pywrapcp.LocalSearchOperator_swigregister(LocalSearchOperator)

class IntVarLocalSearchOperatorTemplate(LocalSearchOperator):
    r""" Base operator class for operators manipulating variables."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Start(self, assignment: "Assignment") -> "void":
        r"""
        This method should not be overridden. Override OnStart() instead which is
        called before exiting this method.
        """
        return _pywrapcp.IntVarLocalSearchOperatorTemplate_Start(self, assignment)

    def IsIncremental(self) -> "bool":
        return _pywrapcp.IntVarLocalSearchOperatorTemplate_IsIncremental(self)

    def Size(self) -> "int":
        return _pywrapcp.IntVarLocalSearchOperatorTemplate_Size(self)

    def Value(self, index: "int64_t") -> "long const &":
        r"""
        Returns the value in the current assignment of the variable of given
        index.
        """
        return _pywrapcp.IntVarLocalSearchOperatorTemplate_Value(self, index)

    def OldValue(self, index: "int64_t") -> "long const &":
        return _pywrapcp.IntVarLocalSearchOperatorTemplate_OldValue(self, index)

    def SetValue(self, index: "int64_t", value: "long const &") -> "void":
        return _pywrapcp.IntVarLocalSearchOperatorTemplate_SetValue(self, index, value)

    def OnStart(self) -> "void":
        r"""
        Called by Start() after synchronizing the operator with the current
        assignment. Should be overridden instead of Start() to avoid calling
        VarLocalSearchOperator::Start explicitly.
        """
        return _pywrapcp.IntVarLocalSearchOperatorTemplate_OnStart(self)

# Register IntVarLocalSearchOperatorTemplate in _pywrapcp:
_pywrapcp.IntVarLocalSearchOperatorTemplate_swigregister(IntVarLocalSearchOperatorTemplate)

class IntVarLocalSearchOperator(IntVarLocalSearchOperatorTemplate):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        if self.__class__ == IntVarLocalSearchOperator:
            _self = None
        else:
            _self = self
        _pywrapcp.IntVarLocalSearchOperator_swiginit(self, _pywrapcp.new_IntVarLocalSearchOperator(_self, *args))
    __swig_destroy__ = _pywrapcp.delete_IntVarLocalSearchOperator

    def NextNeighbor(self, delta: "Assignment", deltadelta: "Assignment") -> "bool":
        r"""
        Redefines MakeNextNeighbor to export a simpler interface. The calls to
        ApplyChanges() and RevertChanges() are factored in this method, hiding
        both delta and deltadelta from subclasses which only need to override
        MakeOneNeighbor().
        Therefore this method should not be overridden. Override MakeOneNeighbor()
        instead.
        """
        return _pywrapcp.IntVarLocalSearchOperator_NextNeighbor(self, delta, deltadelta)

    def OneNeighbor(self) -> "bool":
        r"""
        Creates a new neighbor. It returns false when the neighborhood is
        completely explored.
        MakeNextNeighbor() in a subclass of IntVarLocalSearchOperator.
        """
        return _pywrapcp.IntVarLocalSearchOperator_OneNeighbor(self)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_IntVarLocalSearchOperator(self)
        return weakref.proxy(self)

# Register IntVarLocalSearchOperator in _pywrapcp:
_pywrapcp.IntVarLocalSearchOperator_swigregister(IntVarLocalSearchOperator)

class SequenceVarLocalSearchOperatorTemplate(LocalSearchOperator):
    r""" Base operator class for operators manipulating variables."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Start(self, assignment: "Assignment") -> "void":
        r"""
        This method should not be overridden. Override OnStart() instead which is
        called before exiting this method.
        """
        return _pywrapcp.SequenceVarLocalSearchOperatorTemplate_Start(self, assignment)

    def IsIncremental(self) -> "bool":
        return _pywrapcp.SequenceVarLocalSearchOperatorTemplate_IsIncremental(self)

    def Size(self) -> "int":
        return _pywrapcp.SequenceVarLocalSearchOperatorTemplate_Size(self)

    def Value(self, index: "int64_t") -> "std::vector< int > const &":
        r"""
        Returns the value in the current assignment of the variable of given
        index.
        """
        return _pywrapcp.SequenceVarLocalSearchOperatorTemplate_Value(self, index)

    def OldValue(self, index: "int64_t") -> "std::vector< int > const &":
        return _pywrapcp.SequenceVarLocalSearchOperatorTemplate_OldValue(self, index)

    def SetValue(self, index: "int64_t", value: "std::vector< int > const &") -> "void":
        return _pywrapcp.SequenceVarLocalSearchOperatorTemplate_SetValue(self, index, value)

    def OnStart(self) -> "void":
        r"""
        Called by Start() after synchronizing the operator with the current
        assignment. Should be overridden instead of Start() to avoid calling
        VarLocalSearchOperator::Start explicitly.
        """
        return _pywrapcp.SequenceVarLocalSearchOperatorTemplate_OnStart(self)

# Register SequenceVarLocalSearchOperatorTemplate in _pywrapcp:
_pywrapcp.SequenceVarLocalSearchOperatorTemplate_swigregister(SequenceVarLocalSearchOperatorTemplate)

class SequenceVarLocalSearchOperator(SequenceVarLocalSearchOperatorTemplate):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

# Register SequenceVarLocalSearchOperator in _pywrapcp:
_pywrapcp.SequenceVarLocalSearchOperator_swigregister(SequenceVarLocalSearchOperator)

class BaseLns(IntVarLocalSearchOperator):
    r"""
    This is the base class for building an Lns operator. An Lns fragment is a
    collection of variables which will be relaxed. Fragments are built with
    NextFragment(), which returns false if there are no more fragments to build.
    Optionally one can override InitFragments, which is called from
    LocalSearchOperator::Start to initialize fragment data.

    Here's a sample relaxing one variable at a time:

    class OneVarLns : public BaseLns {
     public:
      OneVarLns(const std::vector<IntVar*>& vars) : BaseLns(vars), index_(0) {}
      virtual ~OneVarLns() {}
      virtual void InitFragments() { index_ = 0; }
      virtual bool NextFragment() {
        const int size = Size();
        if (index_ < size) {
          AppendToFragment(index_);
          ++index_;
          return true;
        } else {
          return false;
        }
      }

     private:
      int index_;
    };
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, vars: "std::vector< operations_research::IntVar * > const &"):
        if self.__class__ == BaseLns:
            _self = None
        else:
            _self = self
        _pywrapcp.BaseLns_swiginit(self, _pywrapcp.new_BaseLns(_self, vars))
    __swig_destroy__ = _pywrapcp.delete_BaseLns

    def InitFragments(self) -> "void":
        return _pywrapcp.BaseLns_InitFragments(self)

    def NextFragment(self) -> "bool":
        return _pywrapcp.BaseLns_NextFragment(self)

    def AppendToFragment(self, index: "int") -> "void":
        return _pywrapcp.BaseLns_AppendToFragment(self, index)

    def FragmentSize(self) -> "int":
        return _pywrapcp.BaseLns_FragmentSize(self)

    def __getitem__(self, index: "int") -> "int64_t":
        return _pywrapcp.BaseLns___getitem__(self, index)

    def __len__(self) -> "int":
        return _pywrapcp.BaseLns___len__(self)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_BaseLns(self)
        return weakref.proxy(self)

# Register BaseLns in _pywrapcp:
_pywrapcp.BaseLns_swigregister(BaseLns)

class ChangeValue(IntVarLocalSearchOperator):
    r"""
    Defines operators which change the value of variables;
    each neighbor corresponds to *one* modified variable.
    Sub-classes have to define ModifyValue which determines what the new
    variable value is going to be (given the current value and the variable).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, vars: "std::vector< operations_research::IntVar * > const &"):
        if self.__class__ == ChangeValue:
            _self = None
        else:
            _self = self
        _pywrapcp.ChangeValue_swiginit(self, _pywrapcp.new_ChangeValue(_self, vars))
    __swig_destroy__ = _pywrapcp.delete_ChangeValue

    def ModifyValue(self, index: "int64_t", value: "int64_t") -> "int64_t":
        return _pywrapcp.ChangeValue_ModifyValue(self, index, value)

    def OneNeighbor(self) -> "bool":
        r""" This method should not be overridden. Override ModifyValue() instead."""
        return _pywrapcp.ChangeValue_OneNeighbor(self)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_ChangeValue(self)
        return weakref.proxy(self)

# Register ChangeValue in _pywrapcp:
_pywrapcp.ChangeValue_swigregister(ChangeValue)

class PathOperator(IntVarLocalSearchOperator):
    r"""
    Base class of the local search operators dedicated to path modifications
    (a path is a set of nodes linked together by arcs).
    This family of neighborhoods supposes they are handling next variables
    representing the arcs (var[i] represents the node immediately after i on
    a path).
    Several services are provided:
    - arc manipulators (SetNext(), ReverseChain(), MoveChain())
    - path inspectors (Next(), Prev(), IsPathEnd())
    - path iterators: operators need a given number of nodes to define a
      neighbor; this class provides the iteration on a given number of (base)
      nodes which can be used to define a neighbor (through the BaseNode method)
    Subclasses only need to override MakeNeighbor to create neighbors using
    the services above (no direct manipulation of assignments).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Neighbor(self) -> "bool":
        return _pywrapcp.PathOperator_Neighbor(self)

# Register PathOperator in _pywrapcp:
_pywrapcp.PathOperator_swigregister(PathOperator)

class LocalSearchFilter(BaseObject):
    r"""
    Classes to which this template function can be applied to as of 04/2014.
    Usage: LocalSearchOperator* op = MakeLocalSearchOperator<Relocate>(...);
    class TwoOpt;
    class Relocate;
    class Exchange;
    class Cross;
    class MakeActiveOperator;
    class MakeInactiveOperator;
    class MakeChainInactiveOperator;
    class SwapActiveOperator;
    class ExtendedSwapActiveOperator;
    class MakeActiveAndRelocate;
    class RelocateAndMakeActiveOperator;
    class RelocateAndMakeInactiveOperator;
    Local Search Filters are used for fast neighbor pruning.
    Filtering a move is done in several phases:
    - in the Relax phase, filters determine which parts of their internals
      will be changed by the candidate, and modify intermediary State
    - in the Accept phase, filters check that the candidate is feasible,
    - if the Accept phase succeeds, the solver may decide to trigger a
      Synchronize phase that makes filters change their internal representation
      to the last candidate,
    - otherwise (Accept fails or the solver does not want to synchronize),
      a Revert phase makes filters erase any intermediary State generated by the
      Relax and Accept phases.
    A given filter has phases called with the following pattern:
    (Relax.Accept.Synchronize | Relax.Accept.Revert | Relax.Revert)*.
    Filters's Revert() is always called in the reverse order their Accept() was
    called, to allow late filters to use state done/undone by early filters'
    Accept()/Revert().
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Accept(self, delta: "Assignment", deltadelta: "Assignment", objective_min: "int64_t", objective_max: "int64_t") -> "bool":
        r"""
        Accepts a "delta" given the assignment with which the filter has been
        synchronized; the delta holds the variables which have been modified and
        their new value.
        If the filter represents a part of the global objective, its contribution
        must be between objective_min and objective_max.
        Sample: supposing one wants to maintain a[0,1] + b[0,1] <= 1,
        for the assignment (a,1), (b,0), the delta (b,1) will be rejected
        but the delta (a,0) will be accepted.
        TODO(user): Remove arguments when there are no more need for those.
        """
        return _pywrapcp.LocalSearchFilter_Accept(self, delta, deltadelta, objective_min, objective_max)

    def IsIncremental(self) -> "bool":
        return _pywrapcp.LocalSearchFilter_IsIncremental(self)

    def Synchronize(self, assignment: "Assignment", delta: "Assignment") -> "void":
        r"""
        Synchronizes the filter with the current solution, delta being the
        difference with the solution passed to the previous call to Synchronize()
        or IncrementalSynchronize(). 'delta' can be used to incrementally
        synchronizing the filter with the new solution by only considering the
        changes in delta.
        """
        return _pywrapcp.LocalSearchFilter_Synchronize(self, assignment, delta)
    __swig_destroy__ = _pywrapcp.delete_LocalSearchFilter

# Register LocalSearchFilter in _pywrapcp:
_pywrapcp.LocalSearchFilter_swigregister(LocalSearchFilter)

class LocalSearchFilterManager(BaseObject):
    r"""
    Filter manager: when a move is made, filters are executed to decide whether
    the solution is feasible and compute parts of the new cost. This class
    schedules filter execution and composes costs as a sum.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def DebugString(self) -> "std::string":
        return _pywrapcp.LocalSearchFilterManager_DebugString(self)

    def __init__(self, *args):
        _pywrapcp.LocalSearchFilterManager_swiginit(self, _pywrapcp.new_LocalSearchFilterManager(*args))

    def Accept(self, monitor: "operations_research::LocalSearchMonitor *const", delta: "Assignment", deltadelta: "Assignment", objective_min: "int64_t", objective_max: "int64_t") -> "bool":
        r"""
        Returns true iff all filters return true, and the sum of their accepted
        objectives is between objective_min and objective_max.
        The monitor has its Begin/EndFiltering events triggered.
        """
        return _pywrapcp.LocalSearchFilterManager_Accept(self, monitor, delta, deltadelta, objective_min, objective_max)

    def Synchronize(self, assignment: "Assignment", delta: "Assignment") -> "void":
        r""" Synchronizes all filters to assignment."""
        return _pywrapcp.LocalSearchFilterManager_Synchronize(self, assignment, delta)
    __swig_destroy__ = _pywrapcp.delete_LocalSearchFilterManager

# Register LocalSearchFilterManager in _pywrapcp:
_pywrapcp.LocalSearchFilterManager_swigregister(LocalSearchFilterManager)

class IntVarLocalSearchFilter(LocalSearchFilter):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, vars: "std::vector< operations_research::IntVar * > const &"):
        if self.__class__ == IntVarLocalSearchFilter:
            _self = None
        else:
            _self = self
        _pywrapcp.IntVarLocalSearchFilter_swiginit(self, _pywrapcp.new_IntVarLocalSearchFilter(_self, vars))
    __swig_destroy__ = _pywrapcp.delete_IntVarLocalSearchFilter

    def Synchronize(self, assignment: "Assignment", delta: "Assignment") -> "void":
        r"""
        This method should not be overridden. Override OnSynchronize() instead
        which is called before exiting this method.
        """
        return _pywrapcp.IntVarLocalSearchFilter_Synchronize(self, assignment, delta)

    def Size(self) -> "int":
        return _pywrapcp.IntVarLocalSearchFilter_Size(self)

    def Value(self, index: "int") -> "int64_t":
        return _pywrapcp.IntVarLocalSearchFilter_Value(self, index)

    def IndexFromVar(self, var: "IntVar") -> "int64_t":
        return _pywrapcp.IntVarLocalSearchFilter_IndexFromVar(self, var)
    def __disown__(self):
        self.this.disown()
        _pywrapcp.disown_IntVarLocalSearchFilter(self)
        return weakref.proxy(self)

# Register IntVarLocalSearchFilter in _pywrapcp:
_pywrapcp.IntVarLocalSearchFilter_swigregister(IntVarLocalSearchFilter)

class BooleanVar(IntVar):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Min(self) -> "int64_t":
        return _pywrapcp.BooleanVar_Min(self)

    def SetMin(self, m: "int64_t") -> "void":
        return _pywrapcp.BooleanVar_SetMin(self, m)

    def Max(self) -> "int64_t":
        return _pywrapcp.BooleanVar_Max(self)

    def SetMax(self, m: "int64_t") -> "void":
        return _pywrapcp.BooleanVar_SetMax(self, m)

    def SetRange(self, mi: "int64_t", ma: "int64_t") -> "void":
        return _pywrapcp.BooleanVar_SetRange(self, mi, ma)

    def Bound(self) -> "bool":
        return _pywrapcp.BooleanVar_Bound(self)

    def Value(self) -> "int64_t":
        return _pywrapcp.BooleanVar_Value(self)

    def RemoveValue(self, v: "int64_t") -> "void":
        return _pywrapcp.BooleanVar_RemoveValue(self, v)

    def RemoveInterval(self, l: "int64_t", u: "int64_t") -> "void":
        return _pywrapcp.BooleanVar_RemoveInterval(self, l, u)

    def WhenBound(self, d: "Demon") -> "void":
        return _pywrapcp.BooleanVar_WhenBound(self, d)

    def WhenRange(self, d: "Demon") -> "void":
        return _pywrapcp.BooleanVar_WhenRange(self, d)

    def WhenDomain(self, d: "Demon") -> "void":
        return _pywrapcp.BooleanVar_WhenDomain(self, d)

    def Size(self) -> "uint64_t":
        return _pywrapcp.BooleanVar_Size(self)

    def Contains(self, v: "int64_t") -> "bool":
        return _pywrapcp.BooleanVar_Contains(self, v)

    def HoleIteratorAux(self, reversible: "bool") -> "operations_research::IntVarIterator *":
        return _pywrapcp.BooleanVar_HoleIteratorAux(self, reversible)

    def DomainIteratorAux(self, reversible: "bool") -> "operations_research::IntVarIterator *":
        return _pywrapcp.BooleanVar_DomainIteratorAux(self, reversible)

    def DebugString(self) -> "std::string":
        return _pywrapcp.BooleanVar_DebugString(self)

# Register BooleanVar in _pywrapcp:
_pywrapcp.BooleanVar_swigregister(BooleanVar)


class PyDecision(Decision):

  def __init__(self):
    Decision.__init__(self)

  def ApplyWrapper(self, solver):
    try:
       self.Apply(solver)
    except Exception as e:
      if 'CP Solver fail' in str(e):
        solver.ShouldFail()
      else:
        raise

  def RefuteWrapper(self, solver):
    try:
       self.Refute(solver)
    except Exception as e:
      if 'CP Solver fail' in str(e):
        solver.ShouldFail()
      else:
        raise

  def DebugString(self):
    return "PyDecision"


class PyDecisionBuilder(DecisionBuilder):

  def __init__(self):
    DecisionBuilder.__init__(self)

  def NextWrapper(self, solver):
    try:
      return self.Next(solver)
    except Exception as e:
      if 'CP Solver fail' in str(e):
        return solver.FailDecision()
      else:
        raise

  def DebugString(self):
    return "PyDecisionBuilder"


class PyDemon(Demon):

  def RunWrapper(self, solver):
    try:
      self.Run(solver)
    except Exception as e:
      if 'CP Solver fail' in str(e):
        solver.ShouldFail()
      else:
        raise

  def DebugString(self):
    return "PyDemon"


class PyConstraintDemon(PyDemon):

  def __init__(self, ct, method, delayed, *args):
    PyDemon.__init__(self)
    self.__constraint = ct
    self.__method = method
    self.__delayed = delayed
    self.__args = args

  def Run(self, solver):
    self.__method(self.__constraint, *self.__args)

  def Priority(self):
    return Solver.DELAYED_PRIORITY if self.__delayed else Solver.NORMAL_PRIORITY

  def DebugString(self):
    return 'PyConstraintDemon'


class PyConstraint(Constraint):

  def __init__(self, solver):
    Constraint.__init__(self, solver)
    self.__demons = []

  def Demon(self, method, *args):
    demon = PyConstraintDemon(self, method, False, *args)
    self.__demons.append(demon)
    return demon

  def DelayedDemon(self, method, *args):
    demon = PyConstraintDemon(self, method, True, *args)
    self.__demons.append(demon)
    return demon

  def InitialPropagateDemon(self):
    return self.solver().ConstraintInitialPropagateCallback(self)

  def DelayedInitialPropagateDemon(self):
    return self.solver().DelayedConstraintInitialPropagateCallback(self)

  def InitialPropagateWrapper(self):
    try:
      self.InitialPropagate()
    except Exception as e:
      if 'CP Solver fail' in str(e):
        self.solver().ShouldFail()
      else:
        raise

  def DebugString(self):
    return "PyConstraint"



class RoutingIndexManager(object):
    r"""
    Manager for any NodeIndex <-> variable index conversion. The routing solver
    uses variable indices internally and through its API. These variable indices
    are tricky to manage directly because one Node can correspond to a multitude
    of variables, depending on the number of times they appear in the model, and
    if they're used as start and/or end points. This class aims to simplify
    variable index usage, allowing users to use NodeIndex instead.

    Usage:

      .. code-block:: c++

          auto starts_ends = ...;  /// These are NodeIndex.
          RoutingIndexManager manager(10, 4, starts_ends);  // 10 nodes, 4 vehicles.
          RoutingModel model(manager);

    Then, use 'manager.NodeToIndex(node)' whenever model requires a variable
    index.

    Note: the mapping between node indices and variables indices is subject to
    change so no assumption should be made on it. The only guarantee is that
    indices range between 0 and n-1, where n = number of vehicles * 2 (for start
    and end nodes) + number of non-start or end nodes.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _pywrapcp.RoutingIndexManager_swiginit(self, _pywrapcp.new_RoutingIndexManager(*args))
    __swig_destroy__ = _pywrapcp.delete_RoutingIndexManager

    def GetNumberOfNodes(self) -> "int":
        return _pywrapcp.RoutingIndexManager_GetNumberOfNodes(self)

    def GetNumberOfVehicles(self) -> "int":
        return _pywrapcp.RoutingIndexManager_GetNumberOfVehicles(self)

    def GetNumberOfIndices(self) -> "int":
        return _pywrapcp.RoutingIndexManager_GetNumberOfIndices(self)

    def GetStartIndex(self, vehicle: "int") -> "int64_t":
        return _pywrapcp.RoutingIndexManager_GetStartIndex(self, vehicle)

    def GetEndIndex(self, vehicle: "int") -> "int64_t":
        return _pywrapcp.RoutingIndexManager_GetEndIndex(self, vehicle)

    def NodeToIndex(self, node: "operations_research::RoutingIndexManager::NodeIndex") -> "int64_t":
        return _pywrapcp.RoutingIndexManager_NodeToIndex(self, node)

    def IndexToNode(self, index: "int64_t") -> "operations_research::RoutingIndexManager::NodeIndex":
        return _pywrapcp.RoutingIndexManager_IndexToNode(self, index)

# Register RoutingIndexManager in _pywrapcp:
_pywrapcp.RoutingIndexManager_swigregister(RoutingIndexManager)


def DefaultRoutingModelParameters() -> "operations_research::RoutingModelParameters":
    return _pywrapcp.DefaultRoutingModelParameters()

def DefaultRoutingSearchParameters() -> "operations_research::RoutingSearchParameters":
    return _pywrapcp.DefaultRoutingSearchParameters()

def FindErrorInRoutingSearchParameters(search_parameters: "operations_research::RoutingSearchParameters const &") -> "std::string":
    r"""
    Returns an empty std::string if the routing search parameters are valid, and
    a non-empty, human readable error description if they're not.
    """
    return _pywrapcp.FindErrorInRoutingSearchParameters(search_parameters)
BOOL_UNSPECIFIED = _pywrapcp.BOOL_UNSPECIFIED
BOOL_FALSE = _pywrapcp.BOOL_FALSE
BOOL_TRUE = _pywrapcp.BOOL_TRUE
class RoutingModel(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ROUTING_NOT_SOLVED = _pywrapcp.RoutingModel_ROUTING_NOT_SOLVED
    r""" Problem not solved yet (before calling RoutingModel::Solve())."""
    ROUTING_SUCCESS = _pywrapcp.RoutingModel_ROUTING_SUCCESS
    r""" Problem solved successfully after calling RoutingModel::Solve()."""
    ROUTING_FAIL = _pywrapcp.RoutingModel_ROUTING_FAIL
    r""" No solution found to the problem after calling RoutingModel::Solve()."""
    ROUTING_FAIL_TIMEOUT = _pywrapcp.RoutingModel_ROUTING_FAIL_TIMEOUT
    r""" Time limit reached before finding a solution with RoutingModel::Solve()."""
    ROUTING_INVALID = _pywrapcp.RoutingModel_ROUTING_INVALID
    r""" Model, model parameters or flags are not valid."""
    PICKUP_AND_DELIVERY_NO_ORDER = _pywrapcp.RoutingModel_PICKUP_AND_DELIVERY_NO_ORDER
    r""" Any precedence is accepted."""
    PICKUP_AND_DELIVERY_LIFO = _pywrapcp.RoutingModel_PICKUP_AND_DELIVERY_LIFO
    r""" Deliveries must be performed in reverse order of pickups."""
    PICKUP_AND_DELIVERY_FIFO = _pywrapcp.RoutingModel_PICKUP_AND_DELIVERY_FIFO
    r""" Deliveries must be performed in the same order as pickups."""

    def __init__(self, *args):
        _pywrapcp.RoutingModel_swiginit(self, _pywrapcp.new_RoutingModel(*args))
    __swig_destroy__ = _pywrapcp.delete_RoutingModel

    def RegisterUnaryTransitVector(self, values: "std::vector< int64_t >") -> "int":
        r""" Registers 'callback' and returns its index."""
        return _pywrapcp.RoutingModel_RegisterUnaryTransitVector(self, values)

    def RegisterUnaryTransitCallback(self, callback: "operations_research::RoutingModel::TransitCallback1") -> "int":
        return _pywrapcp.RoutingModel_RegisterUnaryTransitCallback(self, callback)

    def RegisterPositiveUnaryTransitCallback(self, callback: "operations_research::RoutingModel::TransitCallback1") -> "int":
        return _pywrapcp.RoutingModel_RegisterPositiveUnaryTransitCallback(self, callback)

    def RegisterTransitMatrix(self, values: "std::vector< std::vector< int64_t > >") -> "int":
        return _pywrapcp.RoutingModel_RegisterTransitMatrix(self, values)

    def RegisterTransitCallback(self, callback: "operations_research::RoutingModel::TransitCallback2") -> "int":
        return _pywrapcp.RoutingModel_RegisterTransitCallback(self, callback)

    def RegisterPositiveTransitCallback(self, callback: "operations_research::RoutingModel::TransitCallback2") -> "int":
        return _pywrapcp.RoutingModel_RegisterPositiveTransitCallback(self, callback)

    def TransitCallback(self, callback_index: "int") -> "operations_research::RoutingModel::TransitCallback2 const &":
        return _pywrapcp.RoutingModel_TransitCallback(self, callback_index)

    def UnaryTransitCallbackOrNull(self, callback_index: "int") -> "operations_research::RoutingModel::TransitCallback1 const &":
        return _pywrapcp.RoutingModel_UnaryTransitCallbackOrNull(self, callback_index)

    def AddDimension(self, evaluator_index: "int", slack_max: "int64_t", capacity: "int64_t", fix_start_cumul_to_zero: "bool", name: "std::string const &") -> "bool":
        r"""
        Model creation
        Methods to add dimensions to routes; dimensions represent quantities
        accumulated at nodes along the routes. They represent quantities such as
        weights or volumes carried along the route, or distance or times.
        Quantities at a node are represented by "cumul" variables and the increase
        or decrease of quantities between nodes are represented by "transit"
        variables. These variables are linked as follows:
        if j == next(i), cumul(j) = cumul(i) + transit(i) + slack(i)
        where slack is a positive slack variable (can represent waiting times for
        a time dimension).
        Setting the value of fix_start_cumul_to_zero to true will force the
        "cumul" variable of the start node of all vehicles to be equal to 0.
        Creates a dimension where the transit variable is constrained to be
        equal to evaluator(i, next(i)); 'slack_max' is the upper bound of the
        slack variable and 'capacity' is the upper bound of the cumul variables.
        'name' is the name used to reference the dimension; this name is used to
        get cumul and transit variables from the routing model.
        Returns false if a dimension with the same name has already been created
        (and doesn't create the new dimension).
        Takes ownership of the callback 'evaluator'.
        """
        return _pywrapcp.RoutingModel_AddDimension(self, evaluator_index, slack_max, capacity, fix_start_cumul_to_zero, name)

    def AddDimensionWithVehicleTransits(self, evaluator_indices: "std::vector< int > const &", slack_max: "int64_t", capacity: "int64_t", fix_start_cumul_to_zero: "bool", name: "std::string const &") -> "bool":
        return _pywrapcp.RoutingModel_AddDimensionWithVehicleTransits(self, evaluator_indices, slack_max, capacity, fix_start_cumul_to_zero, name)

    def AddDimensionWithVehicleCapacity(self, evaluator_index: "int", slack_max: "int64_t", vehicle_capacities: "std::vector< int64_t >", fix_start_cumul_to_zero: "bool", name: "std::string const &") -> "bool":
        return _pywrapcp.RoutingModel_AddDimensionWithVehicleCapacity(self, evaluator_index, slack_max, vehicle_capacities, fix_start_cumul_to_zero, name)

    def AddDimensionWithVehicleTransitAndCapacity(self, evaluator_indices: "std::vector< int > const &", slack_max: "int64_t", vehicle_capacities: "std::vector< int64_t >", fix_start_cumul_to_zero: "bool", name: "std::string const &") -> "bool":
        return _pywrapcp.RoutingModel_AddDimensionWithVehicleTransitAndCapacity(self, evaluator_indices, slack_max, vehicle_capacities, fix_start_cumul_to_zero, name)

    def AddConstantDimensionWithSlack(self, value: "int64_t", capacity: "int64_t", slack_max: "int64_t", fix_start_cumul_to_zero: "bool", name: "std::string const &") -> "std::pair< int,bool >":
        r"""
        Creates a dimension where the transit variable is constrained to be
        equal to 'value'; 'capacity' is the upper bound of the cumul variables.
        'name' is the name used to reference the dimension; this name is used to
        get cumul and transit variables from the routing model.
        Returns a pair consisting of an index to the registered unary transit
        callback and a bool denoting whether the dimension has been created.
        It is false if a dimension with the same name has already been created
        (and doesn't create the new dimension but still register a new callback).
        """
        return _pywrapcp.RoutingModel_AddConstantDimensionWithSlack(self, value, capacity, slack_max, fix_start_cumul_to_zero, name)

    def AddConstantDimension(self, value: "int64_t", capacity: "int64_t", fix_start_cumul_to_zero: "bool", name: "std::string const &") -> "std::pair< int,bool >":
        return _pywrapcp.RoutingModel_AddConstantDimension(self, value, capacity, fix_start_cumul_to_zero, name)

    def AddVectorDimension(self, values: "std::vector< int64_t >", capacity: "int64_t", fix_start_cumul_to_zero: "bool", name: "std::string const &") -> "std::pair< int,bool >":
        r"""
        Creates a dimension where the transit variable is constrained to be
        equal to 'values[i]' for node i; 'capacity' is the upper bound of
        the cumul variables. 'name' is the name used to reference the dimension;
        this name is used to get cumul and transit variables from the routing
        model.
        Returns a pair consisting of an index to the registered unary transit
        callback and a bool denoting whether the dimension has been created.
        It is false if a dimension with the same name has already been created
        (and doesn't create the new dimension but still register a new callback).
        """
        return _pywrapcp.RoutingModel_AddVectorDimension(self, values, capacity, fix_start_cumul_to_zero, name)

    def AddMatrixDimension(self, values: "std::vector< std::vector< int64_t > >", capacity: "int64_t", fix_start_cumul_to_zero: "bool", name: "std::string const &") -> "std::pair< int,bool >":
        r"""
        Creates a dimension where the transit variable is constrained to be
        equal to 'values[i][next(i)]' for node i; 'capacity' is the upper bound of
        the cumul variables. 'name' is the name used to reference the dimension;
        this name is used to get cumul and transit variables from the routing
        model.
        Returns a pair consisting of an index to the registered transit callback
        and a bool denoting whether the dimension has been created.
        It is false if a dimension with the same name has already been created
        (and doesn't create the new dimension but still register a new callback).
        """
        return _pywrapcp.RoutingModel_AddMatrixDimension(self, values, capacity, fix_start_cumul_to_zero, name)

    def MakePathSpansAndTotalSlacks(self, dimension: "RoutingDimension", spans: "std::vector< operations_research::IntVar * >", total_slacks: "std::vector< operations_research::IntVar * >") -> "operations_research::Constraint *":
        r"""
        For every vehicle of the routing model:
        - if total_slacks[vehicle] is not nullptr, constrains it to be the sum of
          slacks on that vehicle, that is,
          dimension->CumulVar(end) - dimension->CumulVar(start) -
          sum_{node in path of vehicle} dimension->FixedTransitVar(node).
        - if spans[vehicle] is not nullptr, constrains it to be
          dimension->CumulVar(end) - dimension->CumulVar(start)
        This does stronger propagation than a decomposition, and takes breaks into
        account.
        """
        return _pywrapcp.RoutingModel_MakePathSpansAndTotalSlacks(self, dimension, spans, total_slacks)

    def GetAllDimensionNames(self) -> "std::vector< std::string >":
        r""" Outputs the names of all dimensions added to the routing engine."""
        return _pywrapcp.RoutingModel_GetAllDimensionNames(self)

    def GetDimensions(self) -> "std::vector< operations_research::RoutingDimension * > const &":
        r""" Returns all dimensions of the model."""
        return _pywrapcp.RoutingModel_GetDimensions(self)

    def GetDimensionsWithSoftOrSpanCosts(self) -> "std::vector< operations_research::RoutingDimension * >":
        r""" Returns dimensions with soft or vehicle span costs."""
        return _pywrapcp.RoutingModel_GetDimensionsWithSoftOrSpanCosts(self)

    def GetGlobalDimensionCumulOptimizers(self) -> "std::vector< std::unique_ptr< operations_research::GlobalDimensionCumulOptimizer > > const &":
        r"""
        Returns [global|local]_dimension_optimizers_, which are empty if the model
        has not been closed.
        """
        return _pywrapcp.RoutingModel_GetGlobalDimensionCumulOptimizers(self)

    def GetGlobalDimensionCumulMPOptimizers(self) -> "std::vector< std::unique_ptr< operations_research::GlobalDimensionCumulOptimizer > > const &":
        return _pywrapcp.RoutingModel_GetGlobalDimensionCumulMPOptimizers(self)

    def GetLocalDimensionCumulOptimizers(self) -> "std::vector< std::unique_ptr< operations_research::LocalDimensionCumulOptimizer > > const &":
        return _pywrapcp.RoutingModel_GetLocalDimensionCumulOptimizers(self)

    def GetLocalDimensionCumulMPOptimizers(self) -> "std::vector< std::unique_ptr< operations_research::LocalDimensionCumulOptimizer > > const &":
        return _pywrapcp.RoutingModel_GetLocalDimensionCumulMPOptimizers(self)

    def GetMutableGlobalCumulOptimizer(self, dimension: "RoutingDimension") -> "operations_research::GlobalDimensionCumulOptimizer *":
        r"""
        Returns the global/local dimension cumul optimizer for a given dimension,
        or nullptr if there is none.
        """
        return _pywrapcp.RoutingModel_GetMutableGlobalCumulOptimizer(self, dimension)

    def GetMutableGlobalCumulMPOptimizer(self, dimension: "RoutingDimension") -> "operations_research::GlobalDimensionCumulOptimizer *":
        return _pywrapcp.RoutingModel_GetMutableGlobalCumulMPOptimizer(self, dimension)

    def GetMutableLocalCumulOptimizer(self, dimension: "RoutingDimension") -> "operations_research::LocalDimensionCumulOptimizer *":
        return _pywrapcp.RoutingModel_GetMutableLocalCumulOptimizer(self, dimension)

    def GetMutableLocalCumulMPOptimizer(self, dimension: "RoutingDimension") -> "operations_research::LocalDimensionCumulOptimizer *":
        return _pywrapcp.RoutingModel_GetMutableLocalCumulMPOptimizer(self, dimension)

    def HasDimension(self, dimension_name: "std::string const &") -> "bool":
        r""" Returns true if a dimension exists for a given dimension name."""
        return _pywrapcp.RoutingModel_HasDimension(self, dimension_name)

    def GetDimensionOrDie(self, dimension_name: "std::string const &") -> "operations_research::RoutingDimension const &":
        r""" Returns a dimension from its name. Dies if the dimension does not exist."""
        return _pywrapcp.RoutingModel_GetDimensionOrDie(self, dimension_name)

    def GetMutableDimension(self, dimension_name: "std::string const &") -> "operations_research::RoutingDimension *":
        r"""
        Returns a dimension from its name. Returns nullptr if the dimension does
        not exist.
        """
        return _pywrapcp.RoutingModel_GetMutableDimension(self, dimension_name)

    def SetPrimaryConstrainedDimension(self, dimension_name: "std::string const &") -> "void":
        r"""
        Set the given dimension as "primary constrained". As of August 2013, this
        is only used by ArcIsMoreConstrainedThanArc().
        "dimension" must be the name of an existing dimension, or be empty, in
        which case there will not be a primary dimension after this call.
        """
        return _pywrapcp.RoutingModel_SetPrimaryConstrainedDimension(self, dimension_name)

    def GetPrimaryConstrainedDimension(self) -> "std::string const &":
        r""" Get the primary constrained dimension, or an empty string if it is unset."""
        return _pywrapcp.RoutingModel_GetPrimaryConstrainedDimension(self)

    def GetDimensionResourceGroupIndices(self, dimension: "RoutingDimension") -> "std::vector< int > const &":
        r"""
        Returns the indices of resource groups for this dimension. This method can
        only be called after the model has been closed.
        """
        return _pywrapcp.RoutingModel_GetDimensionResourceGroupIndices(self, dimension)

    def AddDisjunction(self, *args) -> "operations_research::RoutingModel::DisjunctionIndex":
        r"""
        Adds a disjunction constraint on the indices: exactly 'max_cardinality' of
        the indices are active. Start and end indices of any vehicle cannot be
        part of a disjunction.

        If a penalty is given, at most 'max_cardinality' of the indices can be
        active, and if less are active, 'penalty' is payed per inactive index.
        This is equivalent to adding the constraint:
            p + Sum(i)active[i] == max_cardinality
        where p is an integer variable, and the following cost to the cost
        function:
            p * penalty.
        'penalty' must be positive to make the disjunction optional; a negative
        penalty will force 'max_cardinality' indices of the disjunction to be
        performed, and therefore p == 0.
        Note: passing a vector with a single index will model an optional index
        with a penalty cost if it is not visited.
        """
        return _pywrapcp.RoutingModel_AddDisjunction(self, *args)

    def GetDisjunctionIndices(self, index: "int64_t") -> "std::vector< operations_research::RoutingModel::DisjunctionIndex > const &":
        r""" Returns the indices of the disjunctions to which an index belongs."""
        return _pywrapcp.RoutingModel_GetDisjunctionIndices(self, index)

    def GetDisjunctionPenalty(self, index: "operations_research::RoutingModel::DisjunctionIndex") -> "int64_t":
        r""" Returns the penalty of the node disjunction of index 'index'."""
        return _pywrapcp.RoutingModel_GetDisjunctionPenalty(self, index)

    def GetDisjunctionMaxCardinality(self, index: "operations_research::RoutingModel::DisjunctionIndex") -> "int64_t":
        r"""
        Returns the maximum number of possible active nodes of the node
        disjunction of index 'index'.
        """
        return _pywrapcp.RoutingModel_GetDisjunctionMaxCardinality(self, index)

    def GetNumberOfDisjunctions(self) -> "int":
        r""" Returns the number of node disjunctions in the model."""
        return _pywrapcp.RoutingModel_GetNumberOfDisjunctions(self)

    def GetPerfectBinaryDisjunctions(self) -> "std::vector< std::pair< int64_t,int64_t > >":
        r"""
        Returns the list of all perfect binary disjunctions, as pairs of variable
        indices: a disjunction is "perfect" when its variables do not appear in
        any other disjunction. Each pair is sorted (lowest variable index first),
        and the output vector is also sorted (lowest pairs first).
        """
        return _pywrapcp.RoutingModel_GetPerfectBinaryDisjunctions(self)

    def IgnoreDisjunctionsAlreadyForcedToZero(self) -> "void":
        r"""
        SPECIAL: Makes the solver ignore all the disjunctions whose active
        variables are all trivially zero (i.e. Max() == 0), by setting their
        max_cardinality to 0.
        This can be useful when using the BaseBinaryDisjunctionNeighborhood
        operators, in the context of arc-based routing.
        """
        return _pywrapcp.RoutingModel_IgnoreDisjunctionsAlreadyForcedToZero(self)

    def AddSoftSameVehicleConstraint(self, indices: "std::vector< int64_t > const &", cost: "int64_t") -> "void":
        r"""
        Adds a soft constraint to force a set of variable indices to be on the
        same vehicle. If all nodes are not on the same vehicle, each extra vehicle
        used adds 'cost' to the cost function.
        """
        return _pywrapcp.RoutingModel_AddSoftSameVehicleConstraint(self, indices, cost)

    def SetAllowedVehiclesForIndex(self, vehicles: "std::vector< int > const &", index: "int64_t") -> "void":
        r"""
        Sets the vehicles which can visit a given node. If the node is in a
        disjunction, this will not prevent it from being unperformed.
        Specifying an empty vector of vehicles has no effect (all vehicles
        will be allowed to visit the node).
        """
        return _pywrapcp.RoutingModel_SetAllowedVehiclesForIndex(self, vehicles, index)

    def IsVehicleAllowedForIndex(self, vehicle: "int", index: "int64_t") -> "bool":
        r""" Returns true if a vehicle is allowed to visit a given node."""
        return _pywrapcp.RoutingModel_IsVehicleAllowedForIndex(self, vehicle, index)

    def AddPickupAndDelivery(self, pickup: "int64_t", delivery: "int64_t") -> "void":
        r"""
        Notifies that index1 and index2 form a pair of nodes which should belong
        to the same route. This methods helps the search find better solutions,
        especially in the local search phase.
        It should be called each time you have an equality constraint linking
        the vehicle variables of two node (including for instance pickup and
        delivery problems):
            Solver* const solver = routing.solver();
            int64_t index1 = manager.NodeToIndex(node1);
            int64_t index2 = manager.NodeToIndex(node2);
            solver->AddConstraint(solver->MakeEquality(
                routing.VehicleVar(index1),
                routing.VehicleVar(index2)));
            routing.AddPickupAndDelivery(index1, index2);
        """
        return _pywrapcp.RoutingModel_AddPickupAndDelivery(self, pickup, delivery)

    def AddPickupAndDeliverySets(self, pickup_disjunction: "operations_research::RoutingModel::DisjunctionIndex", delivery_disjunction: "operations_research::RoutingModel::DisjunctionIndex") -> "void":
        r"""
        Same as AddPickupAndDelivery but notifying that the performed node from
        the disjunction of index 'pickup_disjunction' is on the same route as the
        performed node from the disjunction of index 'delivery_disjunction'.
        """
        return _pywrapcp.RoutingModel_AddPickupAndDeliverySets(self, pickup_disjunction, delivery_disjunction)

    def GetPickupIndexPairs(self, node_index: "int64_t") -> "std::vector< std::pair< int,int > > const &":
        r"""
        Returns pairs for which the node is a pickup; the first element of each
        pair is the index in the pickup and delivery pairs list in which the
        pickup appears, the second element is its index in the pickups list.
        """
        return _pywrapcp.RoutingModel_GetPickupIndexPairs(self, node_index)

    def GetDeliveryIndexPairs(self, node_index: "int64_t") -> "std::vector< std::pair< int,int > > const &":
        r""" Same as above for deliveries."""
        return _pywrapcp.RoutingModel_GetDeliveryIndexPairs(self, node_index)

    def SetPickupAndDeliveryPolicyOfAllVehicles(self, policy: "operations_research::RoutingModel::PickupAndDeliveryPolicy") -> "void":
        r"""
        Sets the Pickup and delivery policy of all vehicles. It is equivalent to
        calling SetPickupAndDeliveryPolicyOfVehicle on all vehicles.
        """
        return _pywrapcp.RoutingModel_SetPickupAndDeliveryPolicyOfAllVehicles(self, policy)

    def SetPickupAndDeliveryPolicyOfVehicle(self, policy: "operations_research::RoutingModel::PickupAndDeliveryPolicy", vehicle: "int") -> "void":
        return _pywrapcp.RoutingModel_SetPickupAndDeliveryPolicyOfVehicle(self, policy, vehicle)

    def GetPickupAndDeliveryPolicyOfVehicle(self, vehicle: "int") -> "operations_research::RoutingModel::PickupAndDeliveryPolicy":
        return _pywrapcp.RoutingModel_GetPickupAndDeliveryPolicyOfVehicle(self, vehicle)

    def GetNumOfSingletonNodes(self) -> "int":
        r"""
        Returns the number of non-start/end nodes which do not appear in a
        pickup/delivery pair.
        """
        return _pywrapcp.RoutingModel_GetNumOfSingletonNodes(self)
    TYPE_ADDED_TO_VEHICLE = _pywrapcp.RoutingModel_TYPE_ADDED_TO_VEHICLE
    r""" When visited, the number of types 'T' on the vehicle increases by one."""
    ADDED_TYPE_REMOVED_FROM_VEHICLE = _pywrapcp.RoutingModel_ADDED_TYPE_REMOVED_FROM_VEHICLE
    r"""
    When visited, one instance of type 'T' previously added to the route
    (TYPE_ADDED_TO_VEHICLE), if any, is removed from the vehicle.
    If the type was not previously added to the route or all added instances
    have already been removed, this visit has no effect on the types.
    """
    TYPE_ON_VEHICLE_UP_TO_VISIT = _pywrapcp.RoutingModel_TYPE_ON_VEHICLE_UP_TO_VISIT
    r"""
    With the following policy, the visit enforces that type 'T' is
    considered on the route from its start until this node is visited.
    """
    TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED = _pywrapcp.RoutingModel_TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED
    r"""
    The visit doesn't have an impact on the number of types 'T' on the
    route, as it's (virtually) added and removed directly.
    This policy can be used for visits which are part of an incompatibility
    or requirement set without affecting the type count on the route.
    """

    def SetVisitType(self, index: "int64_t", type: "int", type_policy: "operations_research::RoutingModel::VisitTypePolicy") -> "void":
        return _pywrapcp.RoutingModel_SetVisitType(self, index, type, type_policy)

    def GetVisitType(self, index: "int64_t") -> "int":
        return _pywrapcp.RoutingModel_GetVisitType(self, index)

    def GetSingleNodesOfType(self, type: "int") -> "std::vector< int > const &":
        return _pywrapcp.RoutingModel_GetSingleNodesOfType(self, type)

    def GetPairIndicesOfType(self, type: "int") -> "std::vector< int > const &":
        return _pywrapcp.RoutingModel_GetPairIndicesOfType(self, type)

    def GetVisitTypePolicy(self, index: "int64_t") -> "operations_research::RoutingModel::VisitTypePolicy":
        return _pywrapcp.RoutingModel_GetVisitTypePolicy(self, index)

    def CloseVisitTypes(self) -> "void":
        r"""
        This function should be called once all node visit types have been set and
        prior to adding any incompatibilities/requirements.
        "close" types.
        """
        return _pywrapcp.RoutingModel_CloseVisitTypes(self)

    def GetNumberOfVisitTypes(self) -> "int":
        return _pywrapcp.RoutingModel_GetNumberOfVisitTypes(self)

    def AddHardTypeIncompatibility(self, type1: "int", type2: "int") -> "void":
        r"""
        Incompatibilities:
        Two nodes with "hard" incompatible types cannot share the same route at
        all, while with a "temporal" incompatibility they can't be on the same
        route at the same time.
        """
        return _pywrapcp.RoutingModel_AddHardTypeIncompatibility(self, type1, type2)

    def AddTemporalTypeIncompatibility(self, type1: "int", type2: "int") -> "void":
        return _pywrapcp.RoutingModel_AddTemporalTypeIncompatibility(self, type1, type2)

    def GetHardTypeIncompatibilitiesOfType(self, type: "int") -> "absl::flat_hash_set< int > const &":
        r""" Returns visit types incompatible with a given type."""
        return _pywrapcp.RoutingModel_GetHardTypeIncompatibilitiesOfType(self, type)

    def GetTemporalTypeIncompatibilitiesOfType(self, type: "int") -> "absl::flat_hash_set< int > const &":
        return _pywrapcp.RoutingModel_GetTemporalTypeIncompatibilitiesOfType(self, type)

    def HasHardTypeIncompatibilities(self) -> "bool":
        r"""
        Returns true iff any hard (resp. temporal) type incompatibilities have
        been added to the model.
        """
        return _pywrapcp.RoutingModel_HasHardTypeIncompatibilities(self)

    def HasTemporalTypeIncompatibilities(self) -> "bool":
        return _pywrapcp.RoutingModel_HasTemporalTypeIncompatibilities(self)

    def AddSameVehicleRequiredTypeAlternatives(self, dependent_type: "int", required_type_alternatives: "absl::flat_hash_set< int >") -> "void":
        r"""
        Requirements:
        NOTE: As of 2019-04, cycles in the requirement graph are not supported,
        and lead to the dependent nodes being skipped if possible (otherwise
        the model is considered infeasible).
        The following functions specify that "dependent_type" requires at least
        one of the types in "required_type_alternatives".

        For same-vehicle requirements, a node of dependent type type_D requires at
        least one node of type type_R among the required alternatives on the same
        route.
        """
        return _pywrapcp.RoutingModel_AddSameVehicleRequiredTypeAlternatives(self, dependent_type, required_type_alternatives)

    def AddRequiredTypeAlternativesWhenAddingType(self, dependent_type: "int", required_type_alternatives: "absl::flat_hash_set< int >") -> "void":
        r"""
        If type_D depends on type_R when adding type_D, any node_D of type_D and
        VisitTypePolicy TYPE_ADDED_TO_VEHICLE or
        TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED requires at least one type_R on its
        vehicle at the time node_D is visited.
        """
        return _pywrapcp.RoutingModel_AddRequiredTypeAlternativesWhenAddingType(self, dependent_type, required_type_alternatives)

    def AddRequiredTypeAlternativesWhenRemovingType(self, dependent_type: "int", required_type_alternatives: "absl::flat_hash_set< int >") -> "void":
        r"""
        The following requirements apply when visiting dependent nodes that remove
        their type from the route, i.e. type_R must be on the vehicle when type_D
        of VisitTypePolicy ADDED_TYPE_REMOVED_FROM_VEHICLE,
        TYPE_ON_VEHICLE_UP_TO_VISIT or TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED is
        visited.
        """
        return _pywrapcp.RoutingModel_AddRequiredTypeAlternativesWhenRemovingType(self, dependent_type, required_type_alternatives)

    def GetSameVehicleRequiredTypeAlternativesOfType(self, type: "int") -> "std::vector< absl::flat_hash_set< int > > const &":
        r"""
        Returns the set of same-vehicle requirement alternatives for the given
        type.
        """
        return _pywrapcp.RoutingModel_GetSameVehicleRequiredTypeAlternativesOfType(self, type)

    def GetRequiredTypeAlternativesWhenAddingType(self, type: "int") -> "std::vector< absl::flat_hash_set< int > > const &":
        r""" Returns the set of requirement alternatives when adding the given type."""
        return _pywrapcp.RoutingModel_GetRequiredTypeAlternativesWhenAddingType(self, type)

    def GetRequiredTypeAlternativesWhenRemovingType(self, type: "int") -> "std::vector< absl::flat_hash_set< int > > const &":
        r""" Returns the set of requirement alternatives when removing the given type."""
        return _pywrapcp.RoutingModel_GetRequiredTypeAlternativesWhenRemovingType(self, type)

    def HasSameVehicleTypeRequirements(self) -> "bool":
        r"""
        Returns true iff any same-route (resp. temporal) type requirements have
        been added to the model.
        """
        return _pywrapcp.RoutingModel_HasSameVehicleTypeRequirements(self)

    def HasTemporalTypeRequirements(self) -> "bool":
        return _pywrapcp.RoutingModel_HasTemporalTypeRequirements(self)

    def HasTypeRegulations(self) -> "bool":
        r"""
        Returns true iff the model has any incompatibilities or requirements set
        on node types.
        """
        return _pywrapcp.RoutingModel_HasTypeRegulations(self)

    def UnperformedPenalty(self, var_index: "int64_t") -> "int64_t":
        r"""
        Get the "unperformed" penalty of a node. This is only well defined if the
        node is only part of a single Disjunction, and that disjunction has a
        penalty. For forced active nodes returns max int64_t. In all other cases,
        this returns 0.
        """
        return _pywrapcp.RoutingModel_UnperformedPenalty(self, var_index)

    def UnperformedPenaltyOrValue(self, default_value: "int64_t", var_index: "int64_t") -> "int64_t":
        r"""
        Same as above except that it returns default_value instead of 0 when
        penalty is not well defined (default value is passed as first argument to
        simplify the usage of the method in a callback).
        """
        return _pywrapcp.RoutingModel_UnperformedPenaltyOrValue(self, default_value, var_index)

    def GetDepot(self) -> "int64_t":
        r"""
        Returns the variable index of the first starting or ending node of all
        routes. If all routes start  and end at the same node (single depot), this
        is the node returned.
        """
        return _pywrapcp.RoutingModel_GetDepot(self)

    def SetMaximumNumberOfActiveVehicles(self, max_active_vehicles: "int") -> "void":
        r"""
        Constrains the maximum number of active vehicles, aka the number of
        vehicles which do not have an empty route. For instance, this can be used
        to limit the number of routes in the case where there are fewer drivers
        than vehicles and that the fleet of vehicle is heterogeneous.
        """
        return _pywrapcp.RoutingModel_SetMaximumNumberOfActiveVehicles(self, max_active_vehicles)

    def GetMaximumNumberOfActiveVehicles(self) -> "int":
        r""" Returns the maximum number of active vehicles."""
        return _pywrapcp.RoutingModel_GetMaximumNumberOfActiveVehicles(self)

    def SetArcCostEvaluatorOfAllVehicles(self, evaluator_index: "int") -> "void":
        r"""
        Sets the cost function of the model such that the cost of a segment of a
        route between node 'from' and 'to' is evaluator(from, to), whatever the
        route or vehicle performing the route.
        """
        return _pywrapcp.RoutingModel_SetArcCostEvaluatorOfAllVehicles(self, evaluator_index)

    def SetArcCostEvaluatorOfVehicle(self, evaluator_index: "int", vehicle: "int") -> "void":
        r""" Sets the cost function for a given vehicle route."""
        return _pywrapcp.RoutingModel_SetArcCostEvaluatorOfVehicle(self, evaluator_index, vehicle)

    def SetFixedCostOfAllVehicles(self, cost: "int64_t") -> "void":
        r"""
        Sets the fixed cost of all vehicle routes. It is equivalent to calling
        SetFixedCostOfVehicle on all vehicle routes.
        """
        return _pywrapcp.RoutingModel_SetFixedCostOfAllVehicles(self, cost)

    def SetFixedCostOfVehicle(self, cost: "int64_t", vehicle: "int") -> "void":
        r""" Sets the fixed cost of one vehicle route."""
        return _pywrapcp.RoutingModel_SetFixedCostOfVehicle(self, cost, vehicle)

    def GetFixedCostOfVehicle(self, vehicle: "int") -> "int64_t":
        r"""
        Returns the route fixed cost taken into account if the route of the
        vehicle is not empty, aka there's at least one node on the route other
        than the first and last nodes.
        """
        return _pywrapcp.RoutingModel_GetFixedCostOfVehicle(self, vehicle)

    def SetAmortizedCostFactorsOfAllVehicles(self, linear_cost_factor: "int64_t", quadratic_cost_factor: "int64_t") -> "void":
        r"""
        The following methods set the linear and quadratic cost factors of
        vehicles (must be positive values). The default value of these parameters
        is zero for all vehicles.

        When set, the cost_ of the model will contain terms aiming at reducing the
        number of vehicles used in the model, by adding the following to the
        objective for every vehicle v:
        INDICATOR(v used in the model) *
          [linear_cost_factor_of_vehicle_[v]
           - quadratic_cost_factor_of_vehicle_[v]*(square of length of route v)]
        i.e. for every used vehicle, we add the linear factor as fixed cost, and
        subtract the square of the route length multiplied by the quadratic
        factor. This second term aims at making the routes as dense as possible.

        Sets the linear and quadratic cost factor of all vehicles.
        """
        return _pywrapcp.RoutingModel_SetAmortizedCostFactorsOfAllVehicles(self, linear_cost_factor, quadratic_cost_factor)

    def SetAmortizedCostFactorsOfVehicle(self, linear_cost_factor: "int64_t", quadratic_cost_factor: "int64_t", vehicle: "int") -> "void":
        r""" Sets the linear and quadratic cost factor of the given vehicle."""
        return _pywrapcp.RoutingModel_SetAmortizedCostFactorsOfVehicle(self, linear_cost_factor, quadratic_cost_factor, vehicle)

    def GetAmortizedLinearCostFactorOfVehicles(self) -> "std::vector< int64_t > const &":
        return _pywrapcp.RoutingModel_GetAmortizedLinearCostFactorOfVehicles(self)

    def GetAmortizedQuadraticCostFactorOfVehicles(self) -> "std::vector< int64_t > const &":
        return _pywrapcp.RoutingModel_GetAmortizedQuadraticCostFactorOfVehicles(self)

    def ConsiderEmptyRouteCostsForVehicle(self, consider_costs: "bool", vehicle: "int") -> "void":
        return _pywrapcp.RoutingModel_ConsiderEmptyRouteCostsForVehicle(self, consider_costs, vehicle)

    def AreEmptyRouteCostsConsideredForVehicle(self, vehicle: "int") -> "bool":
        return _pywrapcp.RoutingModel_AreEmptyRouteCostsConsideredForVehicle(self, vehicle)

    def SetFirstSolutionEvaluator(self, evaluator: "operations_research::Solver::IndexEvaluator2") -> "void":
        r"""
        Gets/sets the evaluator used during the search. Only relevant when
        RoutingSearchParameters.first_solution_strategy = EVALUATOR_STRATEGY.
        Takes ownership of evaluator.
        """
        return _pywrapcp.RoutingModel_SetFirstSolutionEvaluator(self, evaluator)

    def AddLocalSearchOperator(self, ls_operator: "LocalSearchOperator") -> "void":
        r"""
        Adds a local search operator to the set of operators used to solve the
        vehicle routing problem.
        """
        return _pywrapcp.RoutingModel_AddLocalSearchOperator(self, ls_operator)

    def AddSearchMonitor(self, monitor: "SearchMonitor") -> "void":
        r""" Adds a search monitor to the search used to solve the routing model."""
        return _pywrapcp.RoutingModel_AddSearchMonitor(self, monitor)

    def AddAtSolutionCallback(self, callback: "std::function< void () >") -> "void":
        r"""
        Adds a callback called each time a solution is found during the search.
        This is a shortcut to creating a monitor to call the callback on
        AtSolution() and adding it with AddSearchMonitor.
        """
        return _pywrapcp.RoutingModel_AddAtSolutionCallback(self, callback)

    def AddVariableMinimizedByFinalizer(self, var: "IntVar") -> "void":
        r"""
        Adds a variable to minimize in the solution finalizer. The solution
        finalizer is called each time a solution is found during the search and
        allows to instantiate secondary variables (such as dimension cumul
        variables).
        """
        return _pywrapcp.RoutingModel_AddVariableMinimizedByFinalizer(self, var)

    def AddVariableMaximizedByFinalizer(self, var: "IntVar") -> "void":
        r"""
        Adds a variable to maximize in the solution finalizer (see above for
        information on the solution finalizer).
        """
        return _pywrapcp.RoutingModel_AddVariableMaximizedByFinalizer(self, var)

    def AddWeightedVariableMinimizedByFinalizer(self, var: "IntVar", cost: "int64_t") -> "void":
        r"""
        Adds a variable to minimize in the solution finalizer, with a weighted
        priority: the higher the more priority it has.
        """
        return _pywrapcp.RoutingModel_AddWeightedVariableMinimizedByFinalizer(self, var, cost)

    def AddVariableTargetToFinalizer(self, var: "IntVar", target: "int64_t") -> "void":
        r"""
        Add a variable to set the closest possible to the target value in the
        solution finalizer.
        """
        return _pywrapcp.RoutingModel_AddVariableTargetToFinalizer(self, var, target)

    def CloseModel(self) -> "void":
        r"""
        Closes the current routing model; after this method is called, no
        modification to the model can be done, but RoutesToAssignment becomes
        available. Note that CloseModel() is automatically called by Solve() and
        other methods that produce solution.
        This is equivalent to calling
        CloseModelWithParameters(DefaultRoutingSearchParameters()).
        """
        return _pywrapcp.RoutingModel_CloseModel(self)

    def CloseModelWithParameters(self, search_parameters: "operations_research::RoutingSearchParameters const &") -> "void":
        r"""
        Same as above taking search parameters (as of 10/2015 some the parameters
        have to be set when closing the model).
        """
        return _pywrapcp.RoutingModel_CloseModelWithParameters(self, search_parameters)

    def Solve(self, assignment: "Assignment"=None) -> "operations_research::Assignment const *":
        r"""
        Solves the current routing model; closes the current model.
        This is equivalent to calling
        SolveWithParameters(DefaultRoutingSearchParameters())
        or
        SolveFromAssignmentWithParameters(assignment,
                                          DefaultRoutingSearchParameters()).
        """
        return _pywrapcp.RoutingModel_Solve(self, assignment)

    def SolveWithParameters(self, search_parameters: "operations_research::RoutingSearchParameters const &", solutions: "std::vector< operations_research::Assignment const * > *"=None) -> "operations_research::Assignment const *":
        r"""
        Solves the current routing model with the given parameters. If 'solutions'
        is specified, it will contain the k best solutions found during the search
        (from worst to best, including the one returned by this method), where k
        corresponds to the 'number_of_solutions_to_collect' in
        'search_parameters'. Note that the Assignment returned by the method and
        the ones in solutions are owned by the underlying solver and should not be
        deleted.
        """
        return _pywrapcp.RoutingModel_SolveWithParameters(self, search_parameters, solutions)

    def SolveFromAssignmentWithParameters(self, assignment: "Assignment", search_parameters: "operations_research::RoutingSearchParameters const &", solutions: "std::vector< operations_research::Assignment const * > *"=None) -> "operations_research::Assignment const *":
        r"""
        Same as above, except that if assignment is not null, it will be used as
        the initial solution.
        """
        return _pywrapcp.RoutingModel_SolveFromAssignmentWithParameters(self, assignment, search_parameters, solutions)

    def SolveFromAssignmentsWithParameters(self, assignments: "std::vector< operations_research::Assignment const * > const &", search_parameters: "operations_research::RoutingSearchParameters const &", solutions: "std::vector< operations_research::Assignment const * > *"=None) -> "operations_research::Assignment const *":
        r"""
        Same as above but will try all assignments in order as first solutions
        until one succeeds.
        """
        return _pywrapcp.RoutingModel_SolveFromAssignmentsWithParameters(self, assignments, search_parameters, solutions)

    def SetAssignmentFromOtherModelAssignment(self, target_assignment: "Assignment", source_model: "RoutingModel", source_assignment: "Assignment") -> "void":
        r"""
        Given a "source_model" and its "source_assignment", resets
        "target_assignment" with the IntVar variables (nexts_, and vehicle_vars_
        if costs aren't homogeneous across vehicles) of "this" model, with the
        values set according to those in "other_assignment".
        The objective_element of target_assignment is set to this->cost_.
        """
        return _pywrapcp.RoutingModel_SetAssignmentFromOtherModelAssignment(self, target_assignment, source_model, source_assignment)

    def ComputeLowerBound(self) -> "int64_t":
        r"""
        Computes a lower bound to the routing problem solving a linear assignment
        problem. The routing model must be closed before calling this method.
        Note that problems with node disjunction constraints (including optional
        nodes) and non-homogenous costs are not supported (the method returns 0 in
        these cases).
        """
        return _pywrapcp.RoutingModel_ComputeLowerBound(self)

    def status(self) -> "operations_research::RoutingModel::Status":
        r""" Returns the current status of the routing model."""
        return _pywrapcp.RoutingModel_status(self)

    def ApplyLocks(self, locks: "std::vector< int64_t > const &") -> "operations_research::IntVar *":
        r"""
        Applies a lock chain to the next search. 'locks' represents an ordered
        vector of nodes representing a partial route which will be fixed during
        the next search; it will constrain next variables such that:
        next[locks[i]] == locks[i+1].

        Returns the next variable at the end of the locked chain; this variable is
        not locked. An assignment containing the locks can be obtained by calling
        PreAssignment().
        """
        return _pywrapcp.RoutingModel_ApplyLocks(self, locks)

    def ApplyLocksToAllVehicles(self, locks: "std::vector< std::vector< int64_t > > const &", close_routes: "bool") -> "bool":
        r"""
        Applies lock chains to all vehicles to the next search, such that locks[p]
        is the lock chain for route p. Returns false if the locks do not contain
        valid routes; expects that the routes do not contain the depots,
        i.e. there are empty vectors in place of empty routes.
        If close_routes is set to true, adds the end nodes to the route of each
        vehicle and deactivates other nodes.
        An assignment containing the locks can be obtained by calling
        PreAssignment().
        """
        return _pywrapcp.RoutingModel_ApplyLocksToAllVehicles(self, locks, close_routes)

    def PreAssignment(self) -> "operations_research::Assignment const *const":
        r"""
        Returns an assignment used to fix some of the variables of the problem.
        In practice, this assignment locks partial routes of the problem. This
        can be used in the context of locking the parts of the routes which have
        already been driven in online routing problems.
        """
        return _pywrapcp.RoutingModel_PreAssignment(self)

    def MutablePreAssignment(self) -> "operations_research::Assignment *":
        return _pywrapcp.RoutingModel_MutablePreAssignment(self)

    def WriteAssignment(self, file_name: "std::string const &") -> "bool":
        r"""
        Writes the current solution to a file containing an AssignmentProto.
        Returns false if the file cannot be opened or if there is no current
        solution.
        """
        return _pywrapcp.RoutingModel_WriteAssignment(self, file_name)

    def ReadAssignment(self, file_name: "std::string const &") -> "operations_research::Assignment *":
        r"""
        Reads an assignment from a file and returns the current solution.
        Returns nullptr if the file cannot be opened or if the assignment is not
        valid.
        """
        return _pywrapcp.RoutingModel_ReadAssignment(self, file_name)

    def RestoreAssignment(self, solution: "Assignment") -> "operations_research::Assignment *":
        r"""
        Restores an assignment as a solution in the routing model and returns the
        new solution. Returns nullptr if the assignment is not valid.
        """
        return _pywrapcp.RoutingModel_RestoreAssignment(self, solution)

    def ReadAssignmentFromRoutes(self, routes: "std::vector< std::vector< int64_t > > const &", ignore_inactive_indices: "bool") -> "operations_research::Assignment *":
        r"""
        Restores the routes as the current solution. Returns nullptr if the
        solution cannot be restored (routes do not contain a valid solution). Note
        that calling this method will run the solver to assign values to the
        dimension variables; this may take considerable amount of time, especially
        when using dimensions with slack.
        """
        return _pywrapcp.RoutingModel_ReadAssignmentFromRoutes(self, routes, ignore_inactive_indices)

    def RoutesToAssignment(self, routes: "std::vector< std::vector< int64_t > > const &", ignore_inactive_indices: "bool", close_routes: "bool", assignment: "Assignment") -> "bool":
        r"""
        Fills an assignment from a specification of the routes of the
        vehicles. The routes are specified as lists of variable indices that
        appear on the routes of the vehicles. The indices of the outer vector in
        'routes' correspond to vehicles IDs, the inner vector contains the
        variable indices on the routes for the given vehicle. The inner vectors
        must not contain the start and end indices, as these are determined by the
        routing model.  Sets the value of NextVars in the assignment, adding the
        variables to the assignment if necessary. The method does not touch other
        variables in the assignment. The method can only be called after the model
        is closed.  With ignore_inactive_indices set to false, this method will
        fail (return nullptr) in case some of the route contain indices that are
        deactivated in the model; when set to true, these indices will be
        skipped.  Returns true if routes were successfully
        loaded. However, such assignment still might not be a valid
        solution to the routing problem due to more complex constraints;
        it is advisible to call solver()->CheckSolution() afterwards.
        """
        return _pywrapcp.RoutingModel_RoutesToAssignment(self, routes, ignore_inactive_indices, close_routes, assignment)

    def AssignmentToRoutes(self, assignment: "Assignment", routes: "std::vector< std::vector< int64_t > > *const") -> "void":
        r"""
        Converts the solution in the given assignment to routes for all vehicles.
        Expects that assignment contains a valid solution (i.e. routes for all
        vehicles end with an end index for that vehicle).
        """
        return _pywrapcp.RoutingModel_AssignmentToRoutes(self, assignment, routes)

    def CompactAssignment(self, assignment: "Assignment") -> "operations_research::Assignment *":
        r"""
        Converts the solution in the given assignment to routes for all vehicles.
        If the returned vector is route_indices, route_indices[i][j] is the index
        for jth location visited on route i. Note that contrary to
        AssignmentToRoutes, the vectors do include start and end locations.
        Returns a compacted version of the given assignment, in which all vehicles
        with id lower or equal to some N have non-empty routes, and all vehicles
        with id greater than N have empty routes. Does not take ownership of the
        returned object.
        If found, the cost of the compact assignment is the same as in the
        original assignment and it preserves the values of 'active' variables.
        Returns nullptr if a compact assignment was not found.
        This method only works in homogenous mode, and it only swaps equivalent
        vehicles (vehicles with the same start and end nodes). When creating the
        compact assignment, the empty plan is replaced by the route assigned to
        the compatible vehicle with the highest id. Note that with more complex
        constraints on vehicle variables, this method might fail even if a compact
        solution exists.
        This method changes the vehicle and dimension variables as necessary.
        While compacting the solution, only basic checks on vehicle variables are
        performed; if one of these checks fails no attempts to repair it are made
        (instead, the method returns nullptr).
        """
        return _pywrapcp.RoutingModel_CompactAssignment(self, assignment)

    def CompactAndCheckAssignment(self, assignment: "Assignment") -> "operations_research::Assignment *":
        r"""
        Same as CompactAssignment() but also checks the validity of the final
        compact solution; if it is not valid, no attempts to repair it are made
        (instead, the method returns nullptr).
        """
        return _pywrapcp.RoutingModel_CompactAndCheckAssignment(self, assignment)

    def AddToAssignment(self, var: "IntVar") -> "void":
        r""" Adds an extra variable to the vehicle routing assignment."""
        return _pywrapcp.RoutingModel_AddToAssignment(self, var)

    def AddIntervalToAssignment(self, interval: "IntervalVar") -> "void":
        return _pywrapcp.RoutingModel_AddIntervalToAssignment(self, interval)

    def PackCumulsOfOptimizerDimensionsFromAssignment(self, original_assignment: "Assignment", duration_limit: "absl::Duration") -> "operations_research::Assignment const *":
        r"""
        For every dimension in the model with an optimizer in
        local/global_dimension_optimizers_, this method tries to pack the cumul
        values of the dimension, such that:
        - The cumul costs (span costs, soft lower and upper bound costs, etc) are
          minimized.
        - The cumuls of the ends of the routes are minimized for this given
          minimal cumul cost.
        - Given these minimal end cumuls, the route start cumuls are maximized.
        Returns the assignment resulting from allocating these packed cumuls with
        the solver, and nullptr if these cumuls could not be set by the solver.
        """
        return _pywrapcp.RoutingModel_PackCumulsOfOptimizerDimensionsFromAssignment(self, original_assignment, duration_limit)

    def AddLocalSearchFilter(self, filter: "LocalSearchFilter") -> "void":
        r"""
        Adds a custom local search filter to the list of filters used to speed up
        local search by pruning unfeasible variable assignments.
        Calling this method after the routing model has been closed (CloseModel()
        or Solve() has been called) has no effect.
        The routing model does not take ownership of the filter.
        """
        return _pywrapcp.RoutingModel_AddLocalSearchFilter(self, filter)

    def Start(self, vehicle: "int") -> "int64_t":
        r"""
        Model inspection.
        Returns the variable index of the starting node of a vehicle route.
        """
        return _pywrapcp.RoutingModel_Start(self, vehicle)

    def End(self, vehicle: "int") -> "int64_t":
        r""" Returns the variable index of the ending node of a vehicle route."""
        return _pywrapcp.RoutingModel_End(self, vehicle)

    def IsStart(self, index: "int64_t") -> "bool":
        r""" Returns true if 'index' represents the first node of a route."""
        return _pywrapcp.RoutingModel_IsStart(self, index)

    def IsEnd(self, index: "int64_t") -> "bool":
        r""" Returns true if 'index' represents the last node of a route."""
        return _pywrapcp.RoutingModel_IsEnd(self, index)

    def VehicleIndex(self, index: "int64_t") -> "int":
        r"""
        Returns the vehicle of the given start/end index, and -1 if the given
        index is not a vehicle start/end.
        """
        return _pywrapcp.RoutingModel_VehicleIndex(self, index)

    def Next(self, assignment: "Assignment", index: "int64_t") -> "int64_t":
        r"""
        Assignment inspection
        Returns the variable index of the node directly after the node
        corresponding to 'index' in 'assignment'.
        """
        return _pywrapcp.RoutingModel_Next(self, assignment, index)

    def IsVehicleUsed(self, assignment: "Assignment", vehicle: "int") -> "bool":
        r""" Returns true if the route of 'vehicle' is non empty in 'assignment'."""
        return _pywrapcp.RoutingModel_IsVehicleUsed(self, assignment, vehicle)

    def NextVar(self, index: "int64_t") -> "operations_research::IntVar *":
        r"""
        Returns the next variable of the node corresponding to index. Note that
        NextVar(index) == index is equivalent to ActiveVar(index) == 0.
        """
        return _pywrapcp.RoutingModel_NextVar(self, index)

    def ActiveVar(self, index: "int64_t") -> "operations_research::IntVar *":
        r""" Returns the active variable of the node corresponding to index."""
        return _pywrapcp.RoutingModel_ActiveVar(self, index)

    def ActiveVehicleVar(self, vehicle: "int") -> "operations_research::IntVar *":
        r"""
        Returns the active variable of the vehicle. It will be equal to 1 iff the
        route of the vehicle is not empty, 0 otherwise.
        """
        return _pywrapcp.RoutingModel_ActiveVehicleVar(self, vehicle)

    def VehicleCostsConsideredVar(self, vehicle: "int") -> "operations_research::IntVar *":
        r"""
        Returns the variable specifying whether or not costs are considered for
        vehicle.
        """
        return _pywrapcp.RoutingModel_VehicleCostsConsideredVar(self, vehicle)

    def VehicleVar(self, index: "int64_t") -> "operations_research::IntVar *":
        r"""
        Returns the vehicle variable of the node corresponding to index. Note that
        VehicleVar(index) == -1 is equivalent to ActiveVar(index) == 0.
        """
        return _pywrapcp.RoutingModel_VehicleVar(self, index)

    def CostVar(self) -> "operations_research::IntVar *":
        r""" Returns the global cost variable which is being minimized."""
        return _pywrapcp.RoutingModel_CostVar(self)

    def GetArcCostForVehicle(self, from_index: "int64_t", to_index: "int64_t", vehicle: "int64_t") -> "int64_t":
        r"""
        Returns the cost of the transit arc between two nodes for a given vehicle.
        Input are variable indices of node. This returns 0 if vehicle < 0.
        """
        return _pywrapcp.RoutingModel_GetArcCostForVehicle(self, from_index, to_index, vehicle)

    def CostsAreHomogeneousAcrossVehicles(self) -> "bool":
        r""" Whether costs are homogeneous across all vehicles."""
        return _pywrapcp.RoutingModel_CostsAreHomogeneousAcrossVehicles(self)

    def GetHomogeneousCost(self, from_index: "int64_t", to_index: "int64_t") -> "int64_t":
        r"""
        Returns the cost of the segment between two nodes supposing all vehicle
        costs are the same (returns the cost for the first vehicle otherwise).
        """
        return _pywrapcp.RoutingModel_GetHomogeneousCost(self, from_index, to_index)

    def GetArcCostForFirstSolution(self, from_index: "int64_t", to_index: "int64_t") -> "int64_t":
        r"""
        Returns the cost of the arc in the context of the first solution strategy.
        This is typically a simplification of the actual cost; see the .cc.
        """
        return _pywrapcp.RoutingModel_GetArcCostForFirstSolution(self, from_index, to_index)

    def GetArcCostForClass(self, from_index: "int64_t", to_index: "int64_t", cost_class_index: "int64_t") -> "int64_t":
        r"""
        Returns the cost of the segment between two nodes for a given cost
        class. Input are variable indices of nodes and the cost class.
        Unlike GetArcCostForVehicle(), if cost_class is kNoCost, then the
        returned cost won't necessarily be zero: only some of the components
        of the cost that depend on the cost class will be omited. See the code
        for details.
        """
        return _pywrapcp.RoutingModel_GetArcCostForClass(self, from_index, to_index, cost_class_index)

    def GetCostClassIndexOfVehicle(self, vehicle: "int64_t") -> "operations_research::RoutingModel::CostClassIndex":
        r""" Get the cost class index of the given vehicle."""
        return _pywrapcp.RoutingModel_GetCostClassIndexOfVehicle(self, vehicle)

    def HasVehicleWithCostClassIndex(self, cost_class_index: "operations_research::RoutingModel::CostClassIndex") -> "bool":
        r"""
        Returns true iff the model contains a vehicle with the given
        cost_class_index.
        """
        return _pywrapcp.RoutingModel_HasVehicleWithCostClassIndex(self, cost_class_index)

    def GetCostClassesCount(self) -> "int":
        r""" Returns the number of different cost classes in the model."""
        return _pywrapcp.RoutingModel_GetCostClassesCount(self)

    def GetNonZeroCostClassesCount(self) -> "int":
        r""" Ditto, minus the 'always zero', built-in cost class."""
        return _pywrapcp.RoutingModel_GetNonZeroCostClassesCount(self)

    def GetVehicleClassIndexOfVehicle(self, vehicle: "int64_t") -> "operations_research::RoutingModel::VehicleClassIndex":
        return _pywrapcp.RoutingModel_GetVehicleClassIndexOfVehicle(self, vehicle)

    def GetVehicleOfClass(self, vehicle_class: "operations_research::RoutingModel::VehicleClassIndex") -> "int":
        r"""
        Returns a vehicle of the given vehicle class, and -1 if there are no
        vehicles for this class.
        """
        return _pywrapcp.RoutingModel_GetVehicleOfClass(self, vehicle_class)

    def GetVehicleClassesCount(self) -> "int":
        r""" Returns the number of different vehicle classes in the model."""
        return _pywrapcp.RoutingModel_GetVehicleClassesCount(self)

    def GetSameVehicleIndicesOfIndex(self, node: "int") -> "std::vector< int > const &":
        r""" Returns variable indices of nodes constrained to be on the same route."""
        return _pywrapcp.RoutingModel_GetSameVehicleIndicesOfIndex(self, node)

    def GetVehicleTypeContainer(self) -> "operations_research::RoutingModel::VehicleTypeContainer const &":
        return _pywrapcp.RoutingModel_GetVehicleTypeContainer(self)

    def ArcIsMoreConstrainedThanArc(self, _from: "int64_t", to1: "int64_t", to2: "int64_t") -> "bool":
        r"""
        Returns whether the arc from->to1 is more constrained than from->to2,
        taking into account, in order:
        - whether the destination node isn't an end node
        - whether the destination node is mandatory
        - whether the destination node is bound to the same vehicle as the source
        - the "primary constrained" dimension (see SetPrimaryConstrainedDimension)
        It then breaks ties using, in order:
        - the arc cost (taking unperformed penalties into account)
        - the size of the vehicle vars of "to1" and "to2" (lowest size wins)
        - the value: the lowest value of the indices to1 and to2 wins.
        See the .cc for details.
        The more constrained arc is typically preferable when building a
        first solution. This method is intended to be used as a callback for the
        BestValueByComparisonSelector value selector.
        Args:
          from: the variable index of the source node
          to1: the variable index of the first candidate destination node.
          to2: the variable index of the second candidate destination node.
        """
        return _pywrapcp.RoutingModel_ArcIsMoreConstrainedThanArc(self, _from, to1, to2)

    def DebugOutputAssignment(self, solution_assignment: "Assignment", dimension_to_print: "std::string const &") -> "std::string":
        r"""
        Print some debugging information about an assignment, including the
        feasible intervals of the CumulVar for dimension "dimension_to_print"
        at each step of the routes.
        If "dimension_to_print" is omitted, all dimensions will be printed.
        """
        return _pywrapcp.RoutingModel_DebugOutputAssignment(self, solution_assignment, dimension_to_print)

    def solver(self) -> "operations_research::Solver *":
        r"""
        Returns a vector cumul_bounds, for which cumul_bounds[i][j] is a pair
        containing the minimum and maximum of the CumulVar of the jth node on
        route i.
        - cumul_bounds[i][j].first is the minimum.
        - cumul_bounds[i][j].second is the maximum.
        Returns the underlying constraint solver. Can be used to add extra
        constraints and/or modify search algorithms.
        """
        return _pywrapcp.RoutingModel_solver(self)

    def CheckLimit(self) -> "bool":
        r""" Returns true if the search limit has been crossed."""
        return _pywrapcp.RoutingModel_CheckLimit(self)

    def RemainingTime(self) -> "absl::Duration":
        r""" Returns the time left in the search limit."""
        return _pywrapcp.RoutingModel_RemainingTime(self)

    def nodes(self) -> "int":
        r"""
        Sizes and indices
        Returns the number of nodes in the model.
        """
        return _pywrapcp.RoutingModel_nodes(self)

    def vehicles(self) -> "int":
        r""" Returns the number of vehicle routes in the model."""
        return _pywrapcp.RoutingModel_vehicles(self)

    def Size(self) -> "int64_t":
        r""" Returns the number of next variables in the model."""
        return _pywrapcp.RoutingModel_Size(self)

    def GetNumberOfDecisionsInFirstSolution(self, search_parameters: "operations_research::RoutingSearchParameters const &") -> "int64_t":
        r"""
        Returns statistics on first solution search, number of decisions sent to
        filters, number of decisions rejected by filters.
        """
        return _pywrapcp.RoutingModel_GetNumberOfDecisionsInFirstSolution(self, search_parameters)

    def GetNumberOfRejectsInFirstSolution(self, search_parameters: "operations_research::RoutingSearchParameters const &") -> "int64_t":
        return _pywrapcp.RoutingModel_GetNumberOfRejectsInFirstSolution(self, search_parameters)

    def GetAutomaticFirstSolutionStrategy(self) -> "operations_research::FirstSolutionStrategy::Value":
        r""" Returns the automatic first solution strategy selected."""
        return _pywrapcp.RoutingModel_GetAutomaticFirstSolutionStrategy(self)

    def IsMatchingModel(self) -> "bool":
        r""" Returns true if a vehicle/node matching problem is detected."""
        return _pywrapcp.RoutingModel_IsMatchingModel(self)

    def MakeGuidedSlackFinalizer(self, dimension: "RoutingDimension", initializer: "std::function< int64_t (int64_t) >") -> "operations_research::DecisionBuilder *":
        r"""
        The next few members are in the public section only for testing purposes.

        MakeGuidedSlackFinalizer creates a DecisionBuilder for the slacks of a
        dimension using a callback to choose which values to start with.
        The finalizer works only when all next variables in the model have
        been fixed. It has the following two characteristics:
        1. It follows the routes defined by the nexts variables when choosing a
           variable to make a decision on.
        2. When it comes to choose a value for the slack of node i, the decision
           builder first calls the callback with argument i, and supposingly the
           returned value is x it creates decisions slack[i] = x, slack[i] = x +
           1, slack[i] = x - 1, slack[i] = x + 2, etc.
        """
        return _pywrapcp.RoutingModel_MakeGuidedSlackFinalizer(self, dimension, initializer)

    def MakeSelfDependentDimensionFinalizer(self, dimension: "RoutingDimension") -> "operations_research::DecisionBuilder *":
        r"""
        MakeSelfDependentDimensionFinalizer is a finalizer for the slacks of a
        self-dependent dimension. It makes an extensive use of the caches of the
        state dependent transits.
        In detail, MakeSelfDependentDimensionFinalizer returns a composition of a
        local search decision builder with a greedy descent operator for the cumul
        of the start of each route and a guided slack finalizer. Provided there
        are no time windows and the maximum slacks are large enough, once the
        cumul of the start of route is fixed, the guided finalizer can find
        optimal values of the slacks for the rest of the route in time
        proportional to the length of the route. Therefore the composed finalizer
        generally works in time O(log(t)*n*m), where t is the latest possible
        departute time, n is the number of nodes in the network and m is the
        number of vehicles.
        """
        return _pywrapcp.RoutingModel_MakeSelfDependentDimensionFinalizer(self, dimension)

# Register RoutingModel in _pywrapcp:
_pywrapcp.RoutingModel_swigregister(RoutingModel)
cvar = _pywrapcp.cvar
RoutingModel.kNoPenalty = _pywrapcp.cvar.RoutingModel_kNoPenalty
RoutingModel.kNoDisjunction = _pywrapcp.cvar.RoutingModel_kNoDisjunction
RoutingModel.kNoDimension = _pywrapcp.cvar.RoutingModel_kNoDimension

class RoutingModelVisitor(BaseObject):
    r""" Routing model visitor."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _pywrapcp.RoutingModelVisitor_swiginit(self, _pywrapcp.new_RoutingModelVisitor())
    __swig_destroy__ = _pywrapcp.delete_RoutingModelVisitor

# Register RoutingModelVisitor in _pywrapcp:
_pywrapcp.RoutingModelVisitor_swigregister(RoutingModelVisitor)
RoutingModelVisitor.kLightElement = _pywrapcp.cvar.RoutingModelVisitor_kLightElement
RoutingModelVisitor.kLightElement2 = _pywrapcp.cvar.RoutingModelVisitor_kLightElement2
RoutingModelVisitor.kRemoveValues = _pywrapcp.cvar.RoutingModelVisitor_kRemoveValues

class GlobalVehicleBreaksConstraint(Constraint):
    r"""
    GlobalVehicleBreaksConstraint ensures breaks constraints are enforced on
    all vehicles in the dimension passed to its constructor.
    It is intended to be used for dimensions representing time.
    A break constraint ensures break intervals fit on the route of a vehicle.
    For a given vehicle, it forces break intervals to be disjoint from visit
    intervals, where visit intervals start at CumulVar(node) and last for
    node_visit_transit[node]. Moreover, it ensures that there is enough time
    between two consecutive nodes of a route to do transit and vehicle breaks,
    i.e. if Next(nodeA) = nodeB, CumulVar(nodeA) = tA and CumulVar(nodeB) = tB,
    then SlackVar(nodeA) >= sum_{breaks [tA, tB)} duration(break).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, dimension: "RoutingDimension"):
        _pywrapcp.GlobalVehicleBreaksConstraint_swiginit(self, _pywrapcp.new_GlobalVehicleBreaksConstraint(dimension))

    def DebugString(self) -> "std::string":
        return _pywrapcp.GlobalVehicleBreaksConstraint_DebugString(self)

    def Post(self) -> "void":
        return _pywrapcp.GlobalVehicleBreaksConstraint_Post(self)

    def InitialPropagateWrapper(self) -> "void":
        return _pywrapcp.GlobalVehicleBreaksConstraint_InitialPropagateWrapper(self)
    __swig_destroy__ = _pywrapcp.delete_GlobalVehicleBreaksConstraint

# Register GlobalVehicleBreaksConstraint in _pywrapcp:
_pywrapcp.GlobalVehicleBreaksConstraint_swigregister(GlobalVehicleBreaksConstraint)

class TypeRegulationsChecker(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pywrapcp.delete_TypeRegulationsChecker

    def CheckVehicle(self, vehicle: "int", next_accessor: "std::function< int64_t (int64_t) > const &") -> "bool":
        return _pywrapcp.TypeRegulationsChecker_CheckVehicle(self, vehicle, next_accessor)

# Register TypeRegulationsChecker in _pywrapcp:
_pywrapcp.TypeRegulationsChecker_swigregister(TypeRegulationsChecker)

class TypeIncompatibilityChecker(TypeRegulationsChecker):
    r""" Checker for type incompatibilities."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, model: "RoutingModel", check_hard_incompatibilities: "bool"):
        _pywrapcp.TypeIncompatibilityChecker_swiginit(self, _pywrapcp.new_TypeIncompatibilityChecker(model, check_hard_incompatibilities))
    __swig_destroy__ = _pywrapcp.delete_TypeIncompatibilityChecker

# Register TypeIncompatibilityChecker in _pywrapcp:
_pywrapcp.TypeIncompatibilityChecker_swigregister(TypeIncompatibilityChecker)

class TypeRequirementChecker(TypeRegulationsChecker):
    r""" Checker for type requirements."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, model: "RoutingModel"):
        _pywrapcp.TypeRequirementChecker_swiginit(self, _pywrapcp.new_TypeRequirementChecker(model))
    __swig_destroy__ = _pywrapcp.delete_TypeRequirementChecker

# Register TypeRequirementChecker in _pywrapcp:
_pywrapcp.TypeRequirementChecker_swigregister(TypeRequirementChecker)

class TypeRegulationsConstraint(Constraint):
    r"""
    The following constraint ensures that incompatibilities and requirements
    between types are respected.

    It verifies both "hard" and "temporal" incompatibilities.
    Two nodes with hard incompatible types cannot be served by the same vehicle
    at all, while with a temporal incompatibility they can't be on the same
    route at the same time.
    The VisitTypePolicy of a node determines how visiting it impacts the type
    count on the route.

    For example, for
    - three temporally incompatible types T1 T2 and T3
    - 2 pairs of nodes a1/r1 and a2/r2 of type T1 and T2 respectively, with
        - a1 and a2 of VisitTypePolicy TYPE_ADDED_TO_VEHICLE
        - r1 and r2 of policy ADDED_TYPE_REMOVED_FROM_VEHICLE
    - 3 nodes A, UV and AR of type T3, respectively with type policies
      TYPE_ADDED_TO_VEHICLE, TYPE_ON_VEHICLE_UP_TO_VISIT and
      TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED
    the configurations
    UV --> a1 --> r1 --> a2 --> r2,   a1 --> r1 --> a2 --> r2 --> A and
    a1 --> r1 --> AR --> a2 --> r2 are acceptable, whereas the configurations
    a1 --> a2 --> r1 --> ..., or A --> a1 --> r1 --> ..., or
    a1 --> r1 --> UV --> ... are not feasible.

    It also verifies same-vehicle and temporal type requirements.
    A node of type T_d with a same-vehicle requirement for type T_r needs to be
    served by the same vehicle as a node of type T_r.
    Temporal requirements, on the other hand, can take effect either when the
    dependent type is being added to the route or when it's removed from it,
    which is determined by the dependent node's VisitTypePolicy.
    In the above example:
    - If T3 is required on the same vehicle as T1, A, AR or UV must be on the
      same vehicle as a1.
    - If T2 is required when adding T1, a2 must be visited *before* a1, and if
      r2 is also visited on the route, it must be *after* a1, i.e. T2 must be on
      the vehicle when a1 is visited:
      ... --> a2 --> ... --> a1 --> ... --> r2 --> ...
    - If T3 is required when removing T1, T3 needs to be on the vehicle when
      r1 is visited:
      ... --> A --> ... --> r1 --> ...   OR   ... --> r1 --> ... --> UV --> ...
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, model: "RoutingModel"):
        _pywrapcp.TypeRegulationsConstraint_swiginit(self, _pywrapcp.new_TypeRegulationsConstraint(model))

    def Post(self) -> "void":
        return _pywrapcp.TypeRegulationsConstraint_Post(self)

    def InitialPropagateWrapper(self) -> "void":
        return _pywrapcp.TypeRegulationsConstraint_InitialPropagateWrapper(self)
    __swig_destroy__ = _pywrapcp.delete_TypeRegulationsConstraint

# Register TypeRegulationsConstraint in _pywrapcp:
_pywrapcp.TypeRegulationsConstraint_swigregister(TypeRegulationsConstraint)

class RoutingDimension(object):
    r"""
    Dimensions represent quantities accumulated at nodes along the routes. They
    represent quantities such as weights or volumes carried along the route, or
    distance or times.

    Quantities at a node are represented by "cumul" variables and the increase
    or decrease of quantities between nodes are represented by "transit"
    variables. These variables are linked as follows:

    if j == next(i),
    cumuls(j) = cumuls(i) + transits(i) + slacks(i) +
                state_dependent_transits(i)

    where slack is a positive slack variable (can represent waiting times for
    a time dimension), and state_dependent_transits is a non-purely functional
    version of transits_. Favour transits over state_dependent_transits when
    possible, because purely functional callbacks allow more optimisations and
    make the model faster and easier to solve.
    for a given vehicle, it is passed as an external vector, it would be better
    to have this information here.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _pywrapcp.delete_RoutingDimension

    def model(self) -> "operations_research::RoutingModel *":
        r""" Returns the model on which the dimension was created."""
        return _pywrapcp.RoutingDimension_model(self)

    def GetTransitValue(self, from_index: "int64_t", to_index: "int64_t", vehicle: "int64_t") -> "int64_t":
        r"""
        Returns the transition value for a given pair of nodes (as var index);
        this value is the one taken by the corresponding transit variable when
        the 'next' variable for 'from_index' is bound to 'to_index'.
        """
        return _pywrapcp.RoutingDimension_GetTransitValue(self, from_index, to_index, vehicle)

    def GetTransitValueFromClass(self, from_index: "int64_t", to_index: "int64_t", vehicle_class: "int64_t") -> "int64_t":
        r"""
        Same as above but taking a vehicle class of the dimension instead of a
        vehicle (the class of a vehicle can be obtained with vehicle_to_class()).
        """
        return _pywrapcp.RoutingDimension_GetTransitValueFromClass(self, from_index, to_index, vehicle_class)

    def CumulVar(self, index: "int64_t") -> "operations_research::IntVar *":
        r"""
        Get the cumul, transit and slack variables for the given node (given as
        int64_t var index).
        """
        return _pywrapcp.RoutingDimension_CumulVar(self, index)

    def TransitVar(self, index: "int64_t") -> "operations_research::IntVar *":
        return _pywrapcp.RoutingDimension_TransitVar(self, index)

    def FixedTransitVar(self, index: "int64_t") -> "operations_research::IntVar *":
        return _pywrapcp.RoutingDimension_FixedTransitVar(self, index)

    def SlackVar(self, index: "int64_t") -> "operations_research::IntVar *":
        return _pywrapcp.RoutingDimension_SlackVar(self, index)

    def SetSpanUpperBoundForVehicle(self, upper_bound: "int64_t", vehicle: "int") -> "void":
        r"""
        Sets an upper bound on the dimension span on a given vehicle. This is the
        preferred way to limit the "length" of the route of a vehicle according to
        a dimension.
        """
        return _pywrapcp.RoutingDimension_SetSpanUpperBoundForVehicle(self, upper_bound, vehicle)

    def SetSpanCostCoefficientForVehicle(self, coefficient: "int64_t", vehicle: "int") -> "void":
        r"""
        Sets a cost proportional to the dimension span on a given vehicle,
        or on all vehicles at once. "coefficient" must be nonnegative.
        This is handy to model costs proportional to idle time when the dimension
        represents time.
        The cost for a vehicle is
          span_cost = coefficient * (dimension end value - dimension start value).
        """
        return _pywrapcp.RoutingDimension_SetSpanCostCoefficientForVehicle(self, coefficient, vehicle)

    def SetSpanCostCoefficientForAllVehicles(self, coefficient: "int64_t") -> "void":
        return _pywrapcp.RoutingDimension_SetSpanCostCoefficientForAllVehicles(self, coefficient)

    def SetGlobalSpanCostCoefficient(self, coefficient: "int64_t") -> "void":
        r"""
        Sets a cost proportional to the *global* dimension span, that is the
        difference between the largest value of route end cumul variables and
        the smallest value of route start cumul variables.
        In other words:
        global_span_cost =
          coefficient * (Max(dimension end value) - Min(dimension start value)).
        """
        return _pywrapcp.RoutingDimension_SetGlobalSpanCostCoefficient(self, coefficient)

    def SetCumulVarSoftUpperBound(self, index: "int64_t", upper_bound: "int64_t", coefficient: "int64_t") -> "void":
        r"""
        Sets a soft upper bound to the cumul variable of a given variable index.
        If the value of the cumul variable is greater than the bound, a cost
        proportional to the difference between this value and the bound is added
        to the cost function of the model:
          cumulVar <= upper_bound -> cost = 0
           cumulVar > upper_bound -> cost = coefficient * (cumulVar - upper_bound)
        This is also handy to model tardiness costs when the dimension represents
        time.
        """
        return _pywrapcp.RoutingDimension_SetCumulVarSoftUpperBound(self, index, upper_bound, coefficient)

    def HasCumulVarSoftUpperBound(self, index: "int64_t") -> "bool":
        r"""
        Returns true if a soft upper bound has been set for a given variable
        index.
        """
        return _pywrapcp.RoutingDimension_HasCumulVarSoftUpperBound(self, index)

    def GetCumulVarSoftUpperBound(self, index: "int64_t") -> "int64_t":
        r"""
        Returns the soft upper bound of a cumul variable for a given variable
        index. The "hard" upper bound of the variable is returned if no soft upper
        bound has been set.
        """
        return _pywrapcp.RoutingDimension_GetCumulVarSoftUpperBound(self, index)

    def GetCumulVarSoftUpperBoundCoefficient(self, index: "int64_t") -> "int64_t":
        r"""
        Returns the cost coefficient of the soft upper bound of a cumul variable
        for a given variable index. If no soft upper bound has been set, 0 is
        returned.
        """
        return _pywrapcp.RoutingDimension_GetCumulVarSoftUpperBoundCoefficient(self, index)

    def SetCumulVarSoftLowerBound(self, index: "int64_t", lower_bound: "int64_t", coefficient: "int64_t") -> "void":
        r"""
        Sets a soft lower bound to the cumul variable of a given variable index.
        If the value of the cumul variable is less than the bound, a cost
        proportional to the difference between this value and the bound is added
        to the cost function of the model:
          cumulVar > lower_bound -> cost = 0
          cumulVar <= lower_bound -> cost = coefficient * (lower_bound -
                      cumulVar).
        This is also handy to model earliness costs when the dimension represents
        time.
        """
        return _pywrapcp.RoutingDimension_SetCumulVarSoftLowerBound(self, index, lower_bound, coefficient)

    def HasCumulVarSoftLowerBound(self, index: "int64_t") -> "bool":
        r"""
        Returns true if a soft lower bound has been set for a given variable
        index.
        """
        return _pywrapcp.RoutingDimension_HasCumulVarSoftLowerBound(self, index)

    def GetCumulVarSoftLowerBound(self, index: "int64_t") -> "int64_t":
        r"""
        Returns the soft lower bound of a cumul variable for a given variable
        index. The "hard" lower bound of the variable is returned if no soft lower
        bound has been set.
        """
        return _pywrapcp.RoutingDimension_GetCumulVarSoftLowerBound(self, index)

    def GetCumulVarSoftLowerBoundCoefficient(self, index: "int64_t") -> "int64_t":
        r"""
        Returns the cost coefficient of the soft lower bound of a cumul variable
        for a given variable index. If no soft lower bound has been set, 0 is
        returned.
        """
        return _pywrapcp.RoutingDimension_GetCumulVarSoftLowerBoundCoefficient(self, index)

    def SetBreakIntervalsOfVehicle(self, breaks: "std::vector< operations_research::IntervalVar * >", vehicle: "int", node_visit_transits: "std::vector< int64_t >") -> "void":
        r"""
        Sets the breaks for a given vehicle. Breaks are represented by
        IntervalVars. They may interrupt transits between nodes and increase
        the value of corresponding slack variables.
        A break may take place before the start of a vehicle, after the end of
        a vehicle, or during a travel i -> j.

        In that case, the interval [break.Start(), break.End()) must be a subset
        of [CumulVar(i) + pre_travel(i, j), CumulVar(j) - post_travel(i, j)). In
        other words, a break may not overlap any node n's visit, given by
        [CumulVar(n) - post_travel(_, n), CumulVar(n) + pre_travel(n, _)).
        This formula considers post_travel(_, start) and pre_travel(end, _) to be
        0; pre_travel will never be called on any (_, start) and post_travel will
        never we called on any (end, _). If pre_travel_evaluator or
        post_travel_evaluator is -1, it will be taken as a function that always
        returns 0.
        Deprecated, sets pre_travel(i, j) = node_visit_transit[i].
        """
        return _pywrapcp.RoutingDimension_SetBreakIntervalsOfVehicle(self, breaks, vehicle, node_visit_transits)

    def SetBreakDistanceDurationOfVehicle(self, distance: "int64_t", duration: "int64_t", vehicle: "int") -> "void":
        r"""
        With breaks supposed to be consecutive, this forces the distance between
        breaks of size at least minimum_break_duration to be at most distance.
        This supposes that the time until route start and after route end are
        infinite breaks.
        """
        return _pywrapcp.RoutingDimension_SetBreakDistanceDurationOfVehicle(self, distance, duration, vehicle)

    def InitializeBreaks(self) -> "void":
        r"""
        Sets up vehicle_break_intervals_, vehicle_break_distance_duration_,
        pre_travel_evaluators and post_travel_evaluators.
        """
        return _pywrapcp.RoutingDimension_InitializeBreaks(self)

    def HasBreakConstraints(self) -> "bool":
        r""" Returns true if any break interval or break distance was defined."""
        return _pywrapcp.RoutingDimension_HasBreakConstraints(self)

    def GetPreTravelEvaluatorOfVehicle(self, vehicle: "int") -> "int":
        return _pywrapcp.RoutingDimension_GetPreTravelEvaluatorOfVehicle(self, vehicle)

    def GetPostTravelEvaluatorOfVehicle(self, vehicle: "int") -> "int":
        return _pywrapcp.RoutingDimension_GetPostTravelEvaluatorOfVehicle(self, vehicle)

    def base_dimension(self) -> "operations_research::RoutingDimension const *":
        r""" Returns the parent in the dependency tree if any or nullptr otherwise."""
        return _pywrapcp.RoutingDimension_base_dimension(self)

    def ShortestTransitionSlack(self, node: "int64_t") -> "int64_t":
        r"""
        It makes sense to use the function only for self-dependent dimension.
        For such dimensions the value of the slack of a node determines the
        transition cost of the next transit. Provided that
          1. cumul[node] is fixed,
          2. next[node] and next[next[node]] (if exists) are fixed,
        the value of slack[node] for which cumul[next[node]] + transit[next[node]]
        is minimized can be found in O(1) using this function.
        """
        return _pywrapcp.RoutingDimension_ShortestTransitionSlack(self, node)

    def name(self) -> "std::string const &":
        r""" Returns the name of the dimension."""
        return _pywrapcp.RoutingDimension_name(self)

    def SetPickupToDeliveryLimitFunctionForPair(self, limit_function: "operations_research::RoutingDimension::PickupToDeliveryLimitFunction", pair_index: "int") -> "void":
        return _pywrapcp.RoutingDimension_SetPickupToDeliveryLimitFunctionForPair(self, limit_function, pair_index)

    def HasPickupToDeliveryLimits(self) -> "bool":
        return _pywrapcp.RoutingDimension_HasPickupToDeliveryLimits(self)

    def AddNodePrecedence(self, first_node: "int64_t", second_node: "int64_t", offset: "int64_t") -> "void":
        return _pywrapcp.RoutingDimension_AddNodePrecedence(self, first_node, second_node, offset)

    def GetSpanUpperBoundForVehicle(self, vehicle: "int") -> "int64_t":
        return _pywrapcp.RoutingDimension_GetSpanUpperBoundForVehicle(self, vehicle)

    def GetSpanCostCoefficientForVehicle(self, vehicle: "int") -> "int64_t":
        return _pywrapcp.RoutingDimension_GetSpanCostCoefficientForVehicle(self, vehicle)

    def global_span_cost_coefficient(self) -> "int64_t":
        return _pywrapcp.RoutingDimension_global_span_cost_coefficient(self)

    def GetGlobalOptimizerOffset(self) -> "int64_t":
        return _pywrapcp.RoutingDimension_GetGlobalOptimizerOffset(self)

    def GetLocalOptimizerOffsetForVehicle(self, vehicle: "int") -> "int64_t":
        return _pywrapcp.RoutingDimension_GetLocalOptimizerOffsetForVehicle(self, vehicle)

# Register RoutingDimension in _pywrapcp:
_pywrapcp.RoutingDimension_swigregister(RoutingDimension)


def MakeSetValuesFromTargets(solver: "Solver", variables: "std::vector< operations_research::IntVar * >", targets: "std::vector< int64_t >") -> "operations_research::DecisionBuilder *":
    r"""
    A decision builder which tries to assign values to variables as close as
    possible to target values first.
    """
    return _pywrapcp.MakeSetValuesFromTargets(solver, variables, targets)

def SolveModelWithSat(model: "RoutingModel", search_parameters: "operations_research::RoutingSearchParameters const &", initial_solution: "Assignment", solution: "Assignment") -> "bool":
    r"""
    Attempts to solve the model using the cp-sat solver. As of 5/2019, will
    solve the TSP corresponding to the model if it has a single vehicle.
    Therefore the resulting solution might not actually be feasible. Will return
    false if a solution could not be found.
    """
    return _pywrapcp.SolveModelWithSat(model, search_parameters, initial_solution, solution)


