// Copyright 2010-2021 Google LLC
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef OR_TOOLS_BASE_STATUS_BUILDER_H_
#define OR_TOOLS_BASE_STATUS_BUILDER_H_

#include <sstream>

#include "absl/status/status.h"

namespace util {

class StatusBuilder {
 public:
  explicit StatusBuilder(const absl::Status& status) : code_(status.code()) {
    ss_ << std::string(status.message());
  }

  operator absl::Status() const {  // NOLINT
    return absl::Status(code_, ss_.str());
  }

  template <class T>
  StatusBuilder& operator<<(const T& t) {
    ss_ << t;
    return *this;
  }

  StatusBuilder& SetAppend() { return *this; }

 private:
  const absl::StatusCode code_;
  std::ostringstream ss_;
};

}  // namespace util

#endif  // OR_TOOLS_BASE_STATUS_BUILDER_H_
