#ifndef DCGP_NIST_DATA_H
#define DCGP_NIST_DATA_H

#include <vector>

// chwirut1
inline std::vector<std::vector<double>> chwirut1_points
    = {{0.5000E0}, {0.6250E0}, {0.7500E0}, {0.8750E0}, {1.0000E0}, {1.2500E0}, {1.7500E0}, {2.2500E0}, {1.7500E0},
       {2.2500E0}, {2.7500E0}, {3.2500E0}, {3.7500E0}, {4.2500E0}, {4.7500E0}, {5.2500E0}, {5.7500E0}, {0.5000E0},
       {0.6250E0}, {0.7500E0}, {0.8750E0}, {1.0000E0}, {1.2500E0}, {1.7500E0}, {2.2500E0}, {1.7500E0}, {2.2500E0},
       {2.7500E0}, {3.2500E0}, {3.7500E0}, {4.2500E0}, {4.7500E0}, {5.2500E0}, {5.7500E0}, {0.5000E0}, {0.6250E0},
       {0.7500E0}, {0.8750E0}, {1.0000E0}, {1.2500E0}, {1.7500E0}, {2.2500E0}, {1.7500E0}, {2.2500E0}, {2.7500E0},
       {3.2500E0}, {3.7500E0}, {4.2500E0}, {4.7500E0}, {5.2500E0}, {5.7500E0}, {0.5000E0}, {0.6250E0}, {0.7500E0},
       {0.8750E0}, {1.0000E0}, {1.2500E0}, {1.7500E0}, {2.2500E0}, {1.7500E0}, {2.2500E0}, {2.7500E0}, {3.2500E0},
       {3.7500E0}, {4.2500E0}, {4.7500E0}, {5.2500E0}, {5.7500E0}, {.5000E0},  {.7500E0},  {1.5000E0}, {3.0000E0},
       {3.0000E0}, {3.0000E0}, {6.0000E0}, {.5000E0},  {.7500E0},  {1.5000E0}, {3.0000E0}, {3.0000E0}, {3.0000E0},
       {6.0000E0}, {.5000E0},  {.7500E0},  {1.5000E0}, {3.0000E0}, {3.0000E0}, {3.0000E0}, {6.0000E0}, {.5000E0},
       {.7500E0},  {1.5000E0}, {3.0000E0}, {6.0000E0}, {3.0000E0}, {3.0000E0}, {6.0000E0}, {.5000E0},  {.7500E0},
       {1.0000E0}, {1.5000E0}, {2.0000E0}, {2.0000E0}, {2.5000E0}, {3.0000E0}, {4.0000E0}, {5.0000E0}, {6.0000E0},
       {.5000E0},  {.7500E0},  {1.0000E0}, {1.5000E0}, {2.0000E0}, {2.0000E0}, {2.5000E0}, {3.0000E0}, {4.0000E0},
       {5.0000E0}, {6.0000E0}, {.5000E0},  {.7500E0},  {1.0000E0}, {1.5000E0}, {2.0000E0}, {2.0000E0}, {2.5000E0},
       {3.0000E0}, {4.0000E0}, {5.0000E0}, {6.0000E0}, {.5000E0},  {.6250E0},  {.7500E0},  {.8750E0},  {1.0000E0},
       {1.2500E0}, {2.2500E0}, {2.2500E0}, {2.7500E0}, {3.2500E0}, {3.7500E0}, {4.2500E0}, {4.7500E0}, {5.2500E0},
       {5.7500E0}, {3.0000E0}, {3.0000E0}, {3.0000E0}, {3.0000E0}, {3.0000E0}, {3.0000E0}, {.5000E0},  {.7500E0},
       {1.0000E0}, {1.5000E0}, {2.0000E0}, {2.5000E0}, {2.0000E0}, {2.5000E0}, {3.0000E0}, {4.0000E0}, {5.0000E0},
       {6.0000E0}, {.5000E0},  {.7500E0},  {1.0000E0}, {1.5000E0}, {2.0000E0}, {2.5000E0}, {2.0000E0}, {2.5000E0},
       {3.0000E0}, {4.0000E0}, {5.0000E0}, {6.0000E0}, {.5000E0},  {.7500E0},  {1.0000E0}, {1.5000E0}, {2.0000E0},
       {2.5000E0}, {2.0000E0}, {2.5000E0}, {3.0000E0}, {4.0000E0}, {5.0000E0}, {6.0000E0}, {3.0000E0}, {.5000E0},
       {.7500E0},  {1.5000E0}, {3.0000E0}, {6.0000E0}, {3.0000E0}, {6.0000E0}, {3.0000E0}, {3.0000E0}, {3.0000E0},
       {1.7500E0}, {1.7500E0}, {.5000E0},  {.7500E0},  {1.7500E0}, {1.7500E0}, {2.7500E0}, {3.7500E0}, {1.7500E0},
       {1.7500E0}, {.5000E0},  {.7500E0},  {2.7500E0}, {3.7500E0}, {1.7500E0}, {1.7500E0}};
inline std::vector<std::vector<double>> chwirut1_labels = {
    {92.9000E0}, {78.7000E0}, {64.2000E0}, {64.9000E0}, {57.1000E0}, {43.3000E0}, {31.1000E0}, {23.6000E0}, {31.0500E0},
    {23.7750E0}, {17.7375E0}, {13.8000E0}, {11.5875E0}, {9.4125E0},  {7.7250E0},  {7.3500E0},  {8.0250E0},  {90.6000E0},
    {76.9000E0}, {71.6000E0}, {63.6000E0}, {54.0000E0}, {39.2000E0}, {29.3000E0}, {21.4000E0}, {29.1750E0}, {22.1250E0},
    {17.5125E0}, {14.2500E0}, {9.4500E0},  {9.1500E0},  {7.9125E0},  {8.4750E0},  {6.1125E0},  {80.0000E0}, {79.0000E0},
    {63.8000E0}, {57.2000E0}, {53.2000E0}, {42.5000E0}, {26.8000E0}, {20.4000E0}, {26.8500E0}, {21.0000E0}, {16.4625E0},
    {12.5250E0}, {10.5375E0}, {8.5875E0},  {7.1250E0},  {6.1125E0},  {5.9625E0},  {74.1000E0}, {67.3000E0}, {60.8000E0},
    {55.5000E0}, {50.3000E0}, {41.0000E0}, {29.4000E0}, {20.4000E0}, {29.3625E0}, {21.1500E0}, {16.7625E0}, {13.2000E0},
    {10.8750E0}, {8.1750E0},  {7.3500E0},  {5.9625E0},  {5.6250E0},  {81.5000E0}, {62.4000E0}, {32.5000E0}, {12.4100E0},
    {13.1200E0}, {15.5600E0}, {5.6300E0},  {78.0000E0}, {59.9000E0}, {33.2000E0}, {13.8400E0}, {12.7500E0}, {14.6200E0},
    {3.9400E0},  {76.8000E0}, {61.0000E0}, {32.9000E0}, {13.8700E0}, {11.8100E0}, {13.3100E0}, {5.4400E0},  {78.0000E0},
    {63.5000E0}, {33.8000E0}, {12.5600E0}, {5.6300E0},  {12.7500E0}, {13.1200E0}, {5.4400E0},  {76.8000E0}, {60.0000E0},
    {47.8000E0}, {32.0000E0}, {22.2000E0}, {22.5700E0}, {18.8200E0}, {13.9500E0}, {11.2500E0}, {9.0000E0},  {6.6700E0},
    {75.8000E0}, {62.0000E0}, {48.8000E0}, {35.2000E0}, {20.0000E0}, {20.3200E0}, {19.3100E0}, {12.7500E0}, {10.4200E0},
    {7.3100E0},  {7.4200E0},  {70.5000E0}, {59.5000E0}, {48.5000E0}, {35.8000E0}, {21.0000E0}, {21.6700E0}, {21.0000E0},
    {15.6400E0}, {8.1700E0},  {8.5500E0},  {10.1200E0}, {78.0000E0}, {66.0000E0}, {62.0000E0}, {58.0000E0}, {47.7000E0},
    {37.8000E0}, {20.2000E0}, {21.0700E0}, {13.8700E0}, {9.6700E0},  {7.7600E0},  {5.4400E0},  {4.8700E0},  {4.0100E0},
    {3.7500E0},  {24.1900E0}, {25.7600E0}, {18.0700E0}, {11.8100E0}, {12.0700E0}, {16.1200E0}, {70.8000E0}, {54.7000E0},
    {48.0000E0}, {39.8000E0}, {29.8000E0}, {23.7000E0}, {29.6200E0}, {23.8100E0}, {17.7000E0}, {11.5500E0}, {12.0700E0},
    {8.7400E0},  {80.7000E0}, {61.3000E0}, {47.5000E0}, {29.0000E0}, {24.0000E0}, {17.7000E0}, {24.5600E0}, {18.6700E0},
    {16.2400E0}, {8.7400E0},  {7.8700E0},  {8.5100E0},  {66.7000E0}, {59.2000E0}, {40.8000E0}, {30.7000E0}, {25.7000E0},
    {16.3000E0}, {25.9900E0}, {16.9500E0}, {13.3500E0}, {8.6200E0},  {7.2000E0},  {6.6400E0},  {13.6900E0}, {81.0000E0},
    {64.5000E0}, {35.5000E0}, {13.3100E0}, {4.8700E0},  {12.9400E0}, {5.0600E0},  {15.1900E0}, {14.6200E0}, {15.6400E0},
    {25.5000E0}, {25.9500E0}, {81.7000E0}, {61.6000E0}, {29.8000E0}, {29.8100E0}, {17.1700E0}, {10.3900E0}, {28.4000E0},
    {28.6900E0}, {81.3000E0}, {60.9000E0}, {16.6500E0}, {10.0500E0}, {28.9000E0}, {28.9500E0}};

// chwirut2
inline std::vector<std::vector<double>> chwirut2_points
    = {{0.500E0}, {1.000E0}, {1.750E0}, {3.750E0}, {5.750E0}, {0.875E0}, {2.250E0}, {3.250E0}, {5.250E0},
       {0.750E0}, {1.750E0}, {2.750E0}, {4.750E0}, {0.625E0}, {1.250E0}, {2.250E0}, {4.250E0}, {0.500E0},
       {3.000E0}, {0.750E0}, {3.000E0}, {1.500E0}, {6.000E0}, {3.000E0}, {6.000E0}, {1.500E0}, {3.000E0},
       {0.500E0}, {2.000E0}, {4.000E0}, {0.750E0}, {2.000E0}, {5.000E0}, {0.750E0}, {2.250E0}, {3.750E0},
       {5.750E0}, {3.000E0}, {0.750E0}, {2.500E0}, {4.000E0}, {0.750E0}, {2.500E0}, {4.000E0}, {0.750E0},
       {2.500E0}, {4.000E0}, {0.500E0}, {6.000E0}, {3.000E0}, {0.500E0}, {2.750E0}, {0.500E0}, {1.750E0}};
inline std::vector<std::vector<double>> chwirut2_labels
    = {{92.9000E0}, {57.1000E0}, {31.0500E0}, {11.5875E0}, {8.0250E0},  {63.6000E0}, {21.4000E0}, {14.2500E0},
       {8.4750E0},  {63.8000E0}, {26.8000E0}, {16.4625E0}, {7.1250E0},  {67.3000E0}, {41.0000E0}, {21.1500E0},
       {8.1750E0},  {81.5000E0}, {13.1200E0}, {59.9000E0}, {14.6200E0}, {32.9000E0}, {5.4400E0},  {12.5600E0},
       {5.4400E0},  {32.0000E0}, {13.9500E0}, {75.8000E0}, {20.0000E0}, {10.4200E0}, {59.5000E0}, {21.6700E0},
       {8.5500E0},  {62.0000E0}, {20.2000E0}, {7.7600E0},  {3.7500E0},  {11.8100E0}, {54.7000E0}, {23.7000E0},
       {11.5500E0}, {61.3000E0}, {17.7000E0}, {8.7400E0},  {59.2000E0}, {16.3000E0}, {8.6200E0},  {81.0000E0},
       {4.8700E0},  {14.6200E0}, {81.7000E0}, {17.1700E0}, {81.3000E0}, {28.9000E0}};

// daniel_wood
inline std::vector<std::vector<double>> daniel_wood_points
    = {{1.309E0}, {1.471E0}, {1.490E0}, {1.565E0}, {1.611E0}, {1.680E0}};
inline std::vector<std::vector<double>> daniel_wood_labels
    = {{2.138E0}, {3.421E0}, {3.597E0}, {4.340E0}, {4.882E0}, {5.660E0}};

// gauss1
inline std::vector<std::vector<double>> gauss1_points
    = {{1.000000},  {2.000000},  {3.000000},  {4.000000},  {5.000000},  {6.000000},  {7.000000}, {8.000000}, {9.000000},
       {10.000000}, {11.00000},  {12.00000},  {13.00000},  {14.00000},  {15.00000},  {16.00000}, {17.00000}, {18.00000},
       {19.00000},  {20.00000},  {21.00000},  {22.00000},  {23.00000},  {24.00000},  {25.00000}, {26.00000}, {27.00000},
       {28.00000},  {29.00000},  {30.00000},  {31.00000},  {32.00000},  {33.00000},  {34.00000}, {35.00000}, {36.00000},
       {37.00000},  {38.00000},  {39.00000},  {40.00000},  {41.00000},  {42.00000},  {43.00000}, {44.00000}, {45.00000},
       {46.00000},  {47.00000},  {48.00000},  {49.00000},  {50.00000},  {51.00000},  {52.00000}, {53.00000}, {54.00000},
       {55.00000},  {56.00000},  {57.00000},  {58.00000},  {59.00000},  {60.00000},  {61.00000}, {62.00000}, {63.00000},
       {64.00000},  {65.00000},  {66.00000},  {67.00000},  {68.00000},  {69.00000},  {70.00000}, {71.00000}, {72.00000},
       {73.00000},  {74.00000},  {75.00000},  {76.00000},  {77.00000},  {78.00000},  {79.00000}, {80.00000}, {81.00000},
       {82.00000},  {83.00000},  {84.00000},  {85.00000},  {86.00000},  {87.00000},  {88.00000}, {89.00000}, {90.00000},
       {91.00000},  {92.00000},  {93.00000},  {94.00000},  {95.00000},  {96.00000},  {97.00000}, {98.00000}, {99.00000},
       {100.00000}, {101.00000}, {102.00000}, {103.00000}, {104.00000}, {105.00000}, {106.0000}, {107.0000}, {108.0000},
       {109.0000},  {110.0000},  {111.0000},  {112.0000},  {113.0000},  {114.0000},  {115.0000}, {116.0000}, {117.0000},
       {118.0000},  {119.0000},  {120.0000},  {121.0000},  {122.0000},  {123.0000},  {124.0000}, {125.0000}, {126.0000},
       {127.0000},  {128.0000},  {129.0000},  {130.0000},  {131.0000},  {132.0000},  {133.0000}, {134.0000}, {135.0000},
       {136.0000},  {137.0000},  {138.0000},  {139.0000},  {140.0000},  {141.0000},  {142.0000}, {143.0000}, {144.0000},
       {145.0000},  {146.0000},  {147.0000},  {148.0000},  {149.0000},  {150.0000},  {151.0000}, {152.0000}, {153.0000},
       {154.0000},  {155.0000},  {156.0000},  {157.0000},  {158.0000},  {159.0000},  {160.0000}, {161.0000}, {162.0000},
       {163.0000},  {164.0000},  {165.0000},  {166.0000},  {167.0000},  {168.0000},  {169.0000}, {170.0000}, {171.0000},
       {172.0000},  {173.0000},  {174.0000},  {175.0000},  {176.0000},  {177.0000},  {178.0000}, {179.0000}, {180.0000},
       {181.0000},  {182.0000},  {183.0000},  {184.0000},  {185.0000},  {186.0000},  {187.0000}, {188.0000}, {189.0000},
       {190.0000},  {191.0000},  {192.0000},  {193.0000},  {194.0000},  {195.0000},  {196.0000}, {197.0000}, {198.0000},
       {199.0000},  {200.0000},  {201.0000},  {202.0000},  {203.0000},  {204.0000},  {205.0000}, {206.0000}, {207.0000},
       {208.0000},  {209.0000},  {210.0000},  {211.0000},  {212.0000},  {213.0000},  {214.0000}, {215.0000}, {216.0000},
       {217.0000},  {218.0000},  {219.0000},  {220.0000},  {221.0000},  {222.0000},  {223.0000}, {224.0000}, {225.0000},
       {226.0000},  {227.0000},  {228.0000},  {229.0000},  {230.0000},  {231.0000},  {232.0000}, {233.0000}, {234.0000},
       {235.0000},  {236.0000},  {237.0000},  {238.0000},  {239.0000},  {240.0000},  {241.0000}, {242.0000}, {243.0000},
       {244.0000},  {245.0000},  {246.0000},  {247.0000},  {248.0000},  {249.0000},  {250.0000}};
inline std::vector<std::vector<double>> gauss1_labels
    = {{97.62227},  {97.80724}, {96.62247},  {92.59022}, {91.23869},  {95.32704}, {90.35040},  {89.46235}, {91.72520},
       {89.86916},  {86.88076}, {85.94360},  {87.60686}, {86.25839},  {80.74976}, {83.03551},  {88.25837}, {82.01316},
       {82.74098},  {83.30034}, {81.27850},  {81.85506}, {80.75195},  {80.09573}, {81.07633},  {78.81542}, {78.38596},
       {79.93386},  {79.48474}, {79.95942},  {76.10691}, {78.39830},  {81.43060}, {82.48867},  {81.65462}, {80.84323},
       {88.68663},  {84.74438}, {86.83934},  {85.97739}, {91.28509},  {97.22411}, {93.51733},  {94.10159}, {101.91760},
       {98.43134},  {110.4214}, {107.6628},  {111.7288}, {116.5115},  {120.7609}, {123.9553},  {124.2437}, {130.7996},
       {133.2960},  {130.7788}, {132.0565},  {138.6584}, {142.9252},  {142.7215}, {144.1249},  {147.4377}, {148.2647},
       {152.0519},  {147.3863}, {149.2074},  {148.9537}, {144.5876},  {148.1226}, {148.0144},  {143.8893}, {140.9088},
       {143.4434},  {139.3938}, {135.9878},  {136.3927}, {126.7262},  {124.4487}, {122.8647},  {113.8557}, {113.7037},
       {106.8407},  {107.0034}, {102.46290}, {96.09296}, {94.57555},  {86.98824}, {84.90154},  {81.18023}, {76.40117},
       {67.09200},  {72.67155}, {68.10848},  {67.99088}, {63.34094},  {60.55253}, {56.18687},  {53.64482}, {53.70307},
       {48.07893},  {42.21258}, {45.65181},  {41.69728}, {41.24946},  {39.21349}, {37.71696},  {36.68395}, {37.30393},
       {37.43277},  {37.45012}, {32.64648},  {31.84347}, {31.39951},  {26.68912}, {32.25323},  {27.61008}, {33.58649},
       {28.10714},  {30.26428}, {28.01648},  {29.11021}, {23.02099},  {25.65091}, {28.50295},  {25.23701}, {26.13828},
       {33.53260},  {29.25195}, {27.09847},  {26.52999}, {25.52401},  {26.69218}, {24.55269},  {27.71763}, {25.20297},
       {25.61483},  {25.06893}, {27.63930},  {24.94851}, {25.86806},  {22.48183}, {26.90045},  {25.39919}, {17.90614},
       {23.76039},  {25.89689}, {27.64231},  {22.86101}, {26.47003},  {23.72888}, {27.54334},  {30.52683}, {28.07261},
       {34.92815},  {28.29194}, {34.19161},  {35.41207}, {37.09336},  {40.98330}, {39.53923},  {47.80123}, {47.46305},
       {51.04166},  {54.58065}, {57.53001},  {61.42089}, {62.79032},  {68.51455}, {70.23053},  {74.42776}, {76.59911},
       {81.62053},  {83.42208}, {79.17451},  {88.56985}, {85.66525},  {86.55502}, {90.65907},  {84.27290}, {85.72220},
       {83.10702},  {82.16884}, {80.42568},  {78.15692}, {79.79691},  {77.84378}, {74.50327},  {71.57289}, {65.88031},
       {65.01385},  {60.19582}, {59.66726},  {52.95478}, {53.87792},  {44.91274}, {41.09909},  {41.68018}, {34.53379},
       {34.86419},  {33.14787}, {29.58864},  {27.29462}, {21.91439},  {19.08159}, {24.90290},  {19.82341}, {16.75551},
       {18.24558},  {17.23549}, {16.34934},  {13.71285}, {14.75676},  {13.97169}, {12.42867},  {14.35519}, {7.703309},
       {10.234410}, {11.78315}, {13.87768},  {4.535700}, {10.059280}, {8.424824}, {10.533120}, {9.602255}, {7.877514},
       {6.258121},  {8.899865}, {7.877754},  {12.51191}, {10.66205},  {6.035400}, {6.790655},  {8.783535}, {4.600288},
       {8.400915},  {7.216561}, {10.017410}, {7.331278}, {6.527863},  {2.842001}, {10.325070}, {4.790995}, {8.377101},
       {6.264445},  {2.706213}, {8.362329},  {8.983658}, {3.362571},  {1.182746}, {4.875359}};

// gauss2
inline std::vector<std::vector<double>> gauss2_points
    = {{1.000000},  {2.000000},  {3.000000},  {4.000000},  {5.000000},  {6.000000},  {7.000000}, {8.000000}, {9.000000},
       {10.000000}, {11.00000},  {12.00000},  {13.00000},  {14.00000},  {15.00000},  {16.00000}, {17.00000}, {18.00000},
       {19.00000},  {20.00000},  {21.00000},  {22.00000},  {23.00000},  {24.00000},  {25.00000}, {26.00000}, {27.00000},
       {28.00000},  {29.00000},  {30.00000},  {31.00000},  {32.00000},  {33.00000},  {34.00000}, {35.00000}, {36.00000},
       {37.00000},  {38.00000},  {39.00000},  {40.00000},  {41.00000},  {42.00000},  {43.00000}, {44.00000}, {45.00000},
       {46.00000},  {47.00000},  {48.00000},  {49.00000},  {50.00000},  {51.00000},  {52.00000}, {53.00000}, {54.00000},
       {55.00000},  {56.00000},  {57.00000},  {58.00000},  {59.00000},  {60.00000},  {61.00000}, {62.00000}, {63.00000},
       {64.00000},  {65.00000},  {66.00000},  {67.00000},  {68.00000},  {69.00000},  {70.00000}, {71.00000}, {72.00000},
       {73.00000},  {74.00000},  {75.00000},  {76.00000},  {77.00000},  {78.00000},  {79.00000}, {80.00000}, {81.00000},
       {82.00000},  {83.00000},  {84.00000},  {85.00000},  {86.00000},  {87.00000},  {88.00000}, {89.00000}, {90.00000},
       {91.00000},  {92.00000},  {93.00000},  {94.00000},  {95.00000},  {96.00000},  {97.00000}, {98.00000}, {99.00000},
       {100.00000}, {101.00000}, {102.00000}, {103.00000}, {104.00000}, {105.00000}, {106.0000}, {107.0000}, {108.0000},
       {109.0000},  {110.0000},  {111.0000},  {112.0000},  {113.0000},  {114.0000},  {115.0000}, {116.0000}, {117.0000},
       {118.0000},  {119.0000},  {120.0000},  {121.0000},  {122.0000},  {123.0000},  {124.0000}, {125.0000}, {126.0000},
       {127.0000},  {128.0000},  {129.0000},  {130.0000},  {131.0000},  {132.0000},  {133.0000}, {134.0000}, {135.0000},
       {136.0000},  {137.0000},  {138.0000},  {139.0000},  {140.0000},  {141.0000},  {142.0000}, {143.0000}, {144.0000},
       {145.0000},  {146.0000},  {147.0000},  {148.0000},  {149.0000},  {150.0000},  {151.0000}, {152.0000}, {153.0000},
       {154.0000},  {155.0000},  {156.0000},  {157.0000},  {158.0000},  {159.0000},  {160.0000}, {161.0000}, {162.0000},
       {163.0000},  {164.0000},  {165.0000},  {166.0000},  {167.0000},  {168.0000},  {169.0000}, {170.0000}, {171.0000},
       {172.0000},  {173.0000},  {174.0000},  {175.0000},  {176.0000},  {177.0000},  {178.0000}, {179.0000}, {180.0000},
       {181.0000},  {182.0000},  {183.0000},  {184.0000},  {185.0000},  {186.0000},  {187.0000}, {188.0000}, {189.0000},
       {190.0000},  {191.0000},  {192.0000},  {193.0000},  {194.0000},  {195.0000},  {196.0000}, {197.0000}, {198.0000},
       {199.0000},  {200.0000},  {201.0000},  {202.0000},  {203.0000},  {204.0000},  {205.0000}, {206.0000}, {207.0000},
       {208.0000},  {209.0000},  {210.0000},  {211.0000},  {212.0000},  {213.0000},  {214.0000}, {215.0000}, {216.0000},
       {217.0000},  {218.0000},  {219.0000},  {220.0000},  {221.0000},  {222.0000},  {223.0000}, {224.0000}, {225.0000},
       {226.0000},  {227.0000},  {228.0000},  {229.0000},  {230.0000},  {231.0000},  {232.0000}, {233.0000}, {234.0000},
       {235.0000},  {236.0000},  {237.0000},  {238.0000},  {239.0000},  {240.0000},  {241.0000}, {242.0000}, {243.0000},
       {244.0000},  {245.0000},  {246.0000},  {247.0000},  {248.0000},  {249.0000},  {250.0000}};
inline std::vector<std::vector<double>> gauss2_labels
    = {{97.58776}, {97.76344}, {96.56705},  {92.52037},  {91.15097}, {95.21728},  {90.21355},  {89.29235}, {91.51479},
       {89.60966}, {86.56187}, {85.55316},  {87.13054},  {85.67940}, {80.04851},  {82.18925},  {87.24081}, {80.79407},
       {81.28570}, {81.56940}, {79.22715},  {79.43275},  {77.90195}, {76.75468},  {77.17377},  {74.27348}, {73.11900},
       {73.84826}, {72.47870}, {71.92292},  {66.92176},  {67.93835}, {69.56207},  {69.07066},  {66.53983}, {63.87883},
       {69.71537}, {63.60588}, {63.37154},  {60.01835},  {62.67481}, {65.80666},  {59.14304},  {56.62951}, {61.21785},
       {54.38790}, {62.93443}, {56.65144},  {57.13362},  {58.29689}, {58.91744},  {58.50172},  {55.22885}, {58.30375},
       {57.43237}, {51.69407}, {49.93132},  {53.70760},  {55.39712}, {52.89709},  {52.31649},  {53.98720}, {53.54158},
       {56.45046}, {51.32276}, {53.11676},  {53.28631},  {49.80555}, {54.69564},  {56.41627},  {54.59362}, {54.38520},
       {60.15354}, {59.78773}, {60.49995},  {65.43885},  {60.70001}, {63.71865},  {67.77139},  {64.70934}, {70.78193},
       {70.38651}, {77.22359}, {79.52665},  {80.13077},  {85.67823}, {85.20647},  {90.24548},  {93.61953}, {95.86509},
       {93.46992}, {105.8137}, {107.8269},  {114.0607},  {115.5019}, {118.5110},  {119.6177},  {122.1940}, {126.9903},
       {125.7005}, {123.7447}, {130.6543},  {129.7168},  {131.8240}, {131.8759},  {131.9994},  {132.1221}, {133.4414},
       {133.8252}, {133.6695}, {128.2851},  {126.5182},  {124.7550}, {118.4016},  {122.0334},  {115.2059}, {118.7856},
       {110.7387}, {110.2003}, {105.17290}, {103.44720}, {94.54280}, {94.40526},  {94.57964},  {88.76605}, {87.28747},
       {92.50443}, {86.27997}, {82.44307},  {80.47367},  {78.36608}, {78.74307},  {76.12786},  {79.13108}, {76.76062},
       {77.60769}, {77.76633}, {81.28220},  {79.74307},  {81.97964}, {80.02952},  {85.95232},  {85.96838}, {79.94789},
       {87.17023}, {90.50992}, {93.23373},  {89.14803},  {93.11492}, {90.34337},  {93.69421},  {95.74256}, {91.85105},
       {96.74503}, {87.60996}, {90.47012},  {88.11690},  {85.70673}, {85.01361},  {78.53040},  {81.34148}, {75.19295},
       {72.66115}, {69.85504}, {66.29476},  {63.58502},  {58.33847}, {57.50766},  {52.80498},  {50.79319}, {47.03490},
       {46.47090}, {43.09016}, {34.11531},  {39.28235},  {32.68386}, {30.44056},  {31.98932},  {23.63330}, {23.69643},
       {20.26812}, {19.07074}, {17.59544},  {16.08785},  {18.94267}, {18.61354},  {17.25800},  {16.62285}, {13.48367},
       {15.37647}, {13.47208}, {15.96188},  {12.32547},  {16.33880}, {10.438330}, {9.628715},  {13.12268}, {8.772417},
       {11.76143}, {12.55020}, {11.33108},  {11.20493},  {7.816916}, {6.800675},  {14.26581},  {10.66285}, {8.911574},
       {11.56733}, {11.58207}, {11.59071},  {9.730134},  {11.44237}, {11.22912},  {10.172130}, {12.50905}, {6.201493},
       {9.019605}, {10.80607}, {13.09625},  {3.914271},  {9.567886}, {8.038448},  {10.231040}, {9.367410}, {7.695971},
       {6.118575}, {8.793207}, {7.796692},  {12.45065},  {10.61601}, {6.001003},  {6.765098},  {8.764653}, {4.586418},
       {8.390783}, {7.209202}, {10.012090}, {7.327461},  {6.525136}, {2.840065},  {10.323710}, {4.790035}, {8.376431},
       {6.263980}, {2.705892}, {8.362109},  {8.983507},  {3.362469}, {1.182678},  {4.875312}};

// Kirby2
inline std::vector<std::vector<double>> kirby2_points
    = {{9.65E0},   {10.74E0},  {11.81E0},  {12.88E0},  {14.06E0},  {15.28E0},  {16.63E0},  {18.19E0},  {19.88E0},
       {21.84E0},  {24.00E0},  {26.25E0},  {28.86E0},  {31.85E0},  {35.79E0},  {40.18E0},  {44.74E0},  {49.53E0},
       {53.94E0},  {58.29E0},  {62.63E0},  {67.03E0},  {71.25E0},  {75.22E0},  {79.33E0},  {83.56E0},  {87.75E0},
       {91.93E0},  {96.10E0},  {100.28E0}, {104.46E0}, {108.66E0}, {112.71E0}, {116.88E0}, {121.33E0}, {125.79E0},
       {125.79E0}, {128.74E0}, {130.27E0}, {133.33E0}, {134.79E0}, {137.93E0}, {139.33E0}, {142.46E0}, {143.90E0},
       {146.91E0}, {148.51E0}, {151.41E0}, {153.17E0}, {155.97E0}, {157.76E0}, {160.56E0}, {162.30E0}, {165.21E0},
       {166.90E0}, {169.92E0}, {170.32E0}, {171.54E0}, {173.79E0}, {174.57E0}, {176.25E0}, {177.34E0}, {179.19E0},
       {181.02E0}, {182.08E0}, {183.88E0}, {185.75E0}, {186.80E0}, {188.63E0}, {190.45E0}, {191.48E0}, {193.35E0},
       {195.22E0}, {196.23E0}, {198.05E0}, {199.97E0}, {201.06E0}, {202.83E0}, {204.69E0}, {205.86E0}, {207.58E0},
       {209.50E0}, {210.65E0}, {212.33E0}, {215.43E0}, {217.16E0}, {220.21E0}, {221.98E0}, {225.06E0}, {226.79E0},
       {229.92E0}, {231.69E0}, {234.77E0}, {236.60E0}, {239.63E0}, {241.50E0}, {244.48E0}, {246.40E0}, {249.35E0},
       {251.32E0}, {254.22E0}, {256.24E0}, {259.11E0}, {261.18E0}, {264.02E0}, {266.13E0}, {268.94E0}, {271.09E0},
       {273.87E0}, {276.08E0}, {278.83E0}, {281.08E0}, {283.81E0}, {286.11E0}, {288.81E0}, {291.08E0}, {293.75E0},
       {295.99E0}, {298.64E0}, {300.84E0}, {302.02E0}, {303.48E0}, {305.65E0}, {308.27E0}, {310.41E0}, {313.01E0},
       {315.12E0}, {317.71E0}, {319.79E0}, {322.36E0}, {324.42E0}, {326.98E0}, {329.01E0}, {331.56E0}, {333.56E0},
       {336.10E0}, {338.08E0}, {340.60E0}, {342.57E0}, {345.08E0}, {347.02E0}, {349.52E0}, {351.44E0}, {353.93E0},
       {355.83E0}, {358.32E0}, {360.20E0}, {362.67E0}, {364.53E0}, {367.00E0}, {371.30E0}};
inline std::vector<std::vector<double>> kirby2_labels = {
    {0.0082E0},  {0.0112E0},  {0.0149E0},  {0.0198E0},  {0.0248E0},  {0.0324E0},  {0.0420E0},  {0.0549E0},  {0.0719E0},
    {0.0963E0},  {0.1291E0},  {0.1710E0},  {0.2314E0},  {0.3227E0},  {0.4809E0},  {0.7084E0},  {1.0220E0},  {1.4580E0},
    {1.9520E0},  {2.5410E0},  {3.2230E0},  {3.9990E0},  {4.8520E0},  {5.7320E0},  {6.7270E0},  {7.8350E0},  {9.0250E0},
    {10.2670E0}, {11.5780E0}, {12.9440E0}, {14.3770E0}, {15.8560E0}, {17.3310E0}, {18.8850E0}, {20.5750E0}, {22.3200E0},
    {22.3030E0}, {23.4600E0}, {24.0600E0}, {25.2720E0}, {25.8530E0}, {27.1100E0}, {27.6580E0}, {28.9240E0}, {29.5110E0},
    {30.7100E0}, {31.3500E0}, {32.5200E0}, {33.2300E0}, {34.3300E0}, {35.0600E0}, {36.1700E0}, {36.8400E0}, {38.0100E0},
    {38.6700E0}, {39.8700E0}, {40.0300E0}, {40.5000E0}, {41.3700E0}, {41.6700E0}, {42.3100E0}, {42.7300E0}, {43.4600E0},
    {44.1400E0}, {44.5500E0}, {45.2200E0}, {45.9200E0}, {46.3000E0}, {47.0000E0}, {47.6800E0}, {48.0600E0}, {48.7400E0},
    {49.4100E0}, {49.7600E0}, {50.4300E0}, {51.1100E0}, {51.5000E0}, {52.1200E0}, {52.7600E0}, {53.1800E0}, {53.7800E0},
    {54.4600E0}, {54.8300E0}, {55.4000E0}, {56.4300E0}, {57.0300E0}, {58.0000E0}, {58.6100E0}, {59.5800E0}, {60.1100E0},
    {61.1000E0}, {61.6500E0}, {62.5900E0}, {63.1200E0}, {64.0300E0}, {64.6200E0}, {65.4900E0}, {66.0300E0}, {66.8900E0},
    {67.4200E0}, {68.2300E0}, {68.7700E0}, {69.5900E0}, {70.1100E0}, {70.8600E0}, {71.4300E0}, {72.1600E0}, {72.7000E0},
    {73.4000E0}, {73.9300E0}, {74.6000E0}, {75.1600E0}, {75.8200E0}, {76.3400E0}, {76.9800E0}, {77.4800E0}, {78.0800E0},
    {78.6000E0}, {79.1700E0}, {79.6200E0}, {79.8800E0}, {80.1900E0}, {80.6600E0}, {81.2200E0}, {81.6600E0}, {82.1600E0},
    {82.5900E0}, {83.1400E0}, {83.5000E0}, {84.0000E0}, {84.4000E0}, {84.8900E0}, {85.2600E0}, {85.7400E0}, {86.0700E0},
    {86.5400E0}, {86.8900E0}, {87.3200E0}, {87.6500E0}, {88.1000E0}, {88.4300E0}, {88.8300E0}, {89.1200E0}, {89.5400E0},
    {89.8500E0}, {90.2500E0}, {90.5500E0}, {90.9300E0}, {91.2000E0}, {91.5500E0}, {92.2000E0}};

// lanczos2
inline std::vector<std::vector<double>> lanczos2_points
    = {{0.00000E+00}, {5.00000E-02}, {1.00000E-01}, {1.50000E-01}, {2.00000E-01}, {2.50000E-01},
       {3.00000E-01}, {3.50000E-01}, {4.00000E-01}, {4.50000E-01}, {5.00000E-01}, {5.50000E-01},
       {6.00000E-01}, {6.50000E-01}, {7.00000E-01}, {7.50000E-01}, {8.00000E-01}, {8.50000E-01},
       {9.00000E-01}, {9.50000E-01}, {1.00000E+00}, {1.05000E+00}, {1.10000E+00}, {1.15000E+00}};
inline std::vector<std::vector<double>> lanczos2_labels
    = {{2.5134E+00}, {2.0443E+00}, {1.6684E+00}, {1.3664E+00}, {1.1232E+00}, {0.9269E+00}, {0.7679E+00}, {0.6389E+00},
       {0.5338E+00}, {0.4479E+00}, {0.3776E+00}, {0.3197E+00}, {0.2720E+00}, {0.2325E+00}, {0.1997E+00}, {0.1723E+00},
       {0.1493E+00}, {0.1301E+00}, {0.1138E+00}, {0.1000E+00}, {0.0883E+00}, {0.0783E+00}, {0.0698E+00}, {0.0624E+00}};

// misra1b
inline std::vector<std::vector<double>> misra1b_points
    = {{77.6E0},  {114.9E0}, {141.1E0}, {190.8E0}, {239.9E0}, {289.0E0}, {332.8E0},
       {378.4E0}, {434.8E0}, {477.3E0}, {536.8E0}, {593.1E0}, {689.1E0}, {760.0E0}};
inline std::vector<std::vector<double>> misra1b_labels
    = {{10.07E0}, {14.73E0}, {17.94E0}, {23.93E0}, {29.61E0}, {35.18E0}, {40.02E0},
       {44.82E0}, {50.76E0}, {55.05E0}, {61.01E0}, {66.40E0}, {75.47E0}, {81.78E0}};

#endif // NIST_DATA_H
