/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.SerializableCharset;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BasicSqlType
extends AbstractSqlType {
    private final int precision;
    private final int scale;
    private final RelDataTypeSystem typeSystem;
    private final @Nullable SqlCollation collation;
    private final @Nullable SerializableCharset wrappedCharset;

    public BasicSqlType(RelDataTypeSystem typeSystem, SqlTypeName typeName) {
        this(typeSystem, typeName, false, -1, Integer.MIN_VALUE, null, null);
        BasicSqlType.checkPrecScale(typeName, false, false);
    }

    protected static void checkPrecScale(SqlTypeName typeName, boolean precisionSpecified, boolean scaleSpecified) {
        if (!typeName.allowsPrecScale(precisionSpecified, scaleSpecified)) {
            throw new AssertionError((Object)("typeName.allowsPrecScale(" + precisionSpecified + ", " + scaleSpecified + "): " + (Object)((Object)typeName)));
        }
    }

    public BasicSqlType(RelDataTypeSystem typeSystem, SqlTypeName typeName, int precision) {
        this(typeSystem, typeName, false, precision, Integer.MIN_VALUE, null, null);
        BasicSqlType.checkPrecScale(typeName, true, false);
    }

    public BasicSqlType(RelDataTypeSystem typeSystem, SqlTypeName typeName, int precision, int scale) {
        this(typeSystem, typeName, false, precision, scale, null, null);
        BasicSqlType.checkPrecScale(typeName, true, true);
    }

    private BasicSqlType(RelDataTypeSystem typeSystem, SqlTypeName typeName, boolean nullable, int precision, int scale, @Nullable SqlCollation collation, @Nullable SerializableCharset wrappedCharset) {
        super(typeName, nullable, null);
        this.typeSystem = Objects.requireNonNull(typeSystem, "typeSystem");
        this.precision = precision;
        this.scale = scale;
        this.collation = collation;
        this.wrappedCharset = wrappedCharset;
        this.computeDigest();
    }

    BasicSqlType createWithNullability(boolean nullable) {
        if (nullable == this.isNullable) {
            return this;
        }
        return new BasicSqlType(this.typeSystem, this.typeName, nullable, this.precision, this.scale, this.collation, this.wrappedCharset);
    }

    BasicSqlType createWithCharsetAndCollation(Charset charset, SqlCollation collation) {
        Preconditions.checkArgument(SqlTypeUtil.inCharFamily(this));
        return new BasicSqlType(this.typeSystem, this.typeName, this.isNullable, this.precision, this.scale, collation, SerializableCharset.forCharset(charset));
    }

    @Override
    public int getPrecision() {
        if (this.precision == -1) {
            return this.typeSystem.getDefaultPrecision(this.typeName);
        }
        return this.precision;
    }

    @Override
    public int getScale() {
        if (this.scale == Integer.MIN_VALUE) {
            switch (this.typeName) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case DECIMAL: {
                    return 0;
                }
            }
        }
        return this.scale;
    }

    @Override
    public @Nullable Charset getCharset() {
        return this.wrappedCharset == null ? null : this.wrappedCharset.getCharset();
    }

    @Override
    public @Nullable SqlCollation getCollation() {
        return this.collation;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        boolean printScale;
        sb.append(this.typeName.name());
        boolean printPrecision = this.precision != -1;
        boolean bl = printScale = this.scale != Integer.MIN_VALUE;
        if (printPrecision) {
            sb.append('(');
            sb.append(this.getPrecision());
            if (printScale) {
                sb.append(", ");
                sb.append(this.getScale());
            }
            sb.append(')');
        }
        if (!withDetail) {
            return;
        }
        if (this.wrappedCharset != null && !SqlCollation.IMPLICIT.getCharset().equals(this.wrappedCharset.getCharset())) {
            sb.append(" CHARACTER SET \"");
            sb.append(this.wrappedCharset.getCharset().name());
            sb.append("\"");
        }
        if (this.collation != null && this.collation != SqlCollation.IMPLICIT && this.collation != SqlCollation.COERCIBLE) {
            sb.append(" COLLATE \"");
            sb.append(this.collation.getCollationName());
            sb.append("\"");
        }
    }

    public @Nullable Object getLimit(boolean sign, SqlTypeName.Limit limit, boolean beyond) {
        int precision = this.typeName.allowsPrec() ? this.getPrecision() : -1;
        int scale = this.typeName.allowsScale() ? this.getScale() : -1;
        return this.typeName.getLimit(sign, limit, beyond, precision, scale);
    }
}

