/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SqlWriterConfig", generator="Immutables")
@Immutable
final class ImmutableSqlWriterConfig
implements SqlWriterConfig {
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlDialect dialect;
    private final boolean keywordsLowerCase;
    private final boolean quoteAllIdentifiers;
    private final int indentation;
    private final boolean clauseStartsLine;
    private final boolean clauseEndsLine;
    private final boolean selectListItemsOnSeparateLines;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding lineFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding selectFolding;
    private final SqlWriterConfig.LineFolding fromFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding whereFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding groupByFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding havingFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding windowFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding matchFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding orderByFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding overFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding valuesFolding;
    private final @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding updateSetFolding;
    private final boolean selectListExtraIndentFlag;
    private final boolean windowDeclListNewline;
    private final boolean valuesListNewline;
    private final boolean updateSetListNewline;
    private final boolean windowNewline;
    private final boolean leadingComma;
    private final SqlWriter.SubQueryStyle subQueryStyle;
    private final boolean whereListItemsOnSeparateLines;
    private final boolean alwaysUseParentheses;
    private final int lineLength;
    private final int foldLength;
    private final boolean caseClausesOnNewLines;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableSqlWriterConfig INSTANCE = ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig());

    private ImmutableSqlWriterConfig() {
        this.dialect = null;
        this.lineFolding = null;
        this.selectFolding = null;
        this.whereFolding = null;
        this.groupByFolding = null;
        this.havingFolding = null;
        this.windowFolding = null;
        this.matchFolding = null;
        this.orderByFolding = null;
        this.overFolding = null;
        this.valuesFolding = null;
        this.updateSetFolding = null;
        this.keywordsLowerCase = this.initShim.keywordsLowerCase();
        this.quoteAllIdentifiers = this.initShim.quoteAllIdentifiers();
        this.indentation = this.initShim.indentation();
        this.clauseStartsLine = this.initShim.clauseStartsLine();
        this.clauseEndsLine = this.initShim.clauseEndsLine();
        this.selectListItemsOnSeparateLines = this.initShim.selectListItemsOnSeparateLines();
        this.fromFolding = this.initShim.fromFolding();
        this.selectListExtraIndentFlag = this.initShim.selectListExtraIndentFlag();
        this.windowDeclListNewline = this.initShim.windowDeclListNewline();
        this.valuesListNewline = this.initShim.valuesListNewline();
        this.updateSetListNewline = this.initShim.updateSetListNewline();
        this.windowNewline = this.initShim.windowNewline();
        this.leadingComma = this.initShim.leadingComma();
        this.subQueryStyle = this.initShim.subQueryStyle();
        this.whereListItemsOnSeparateLines = this.initShim.whereListItemsOnSeparateLines();
        this.alwaysUseParentheses = this.initShim.alwaysUseParentheses();
        this.lineLength = this.initShim.lineLength();
        this.foldLength = this.initShim.foldLength();
        this.caseClausesOnNewLines = this.initShim.caseClausesOnNewLines();
        this.initShim = null;
    }

    private ImmutableSqlWriterConfig(Builder builder) {
        this.dialect = builder.dialect;
        this.lineFolding = builder.lineFolding;
        this.selectFolding = builder.selectFolding;
        this.whereFolding = builder.whereFolding;
        this.groupByFolding = builder.groupByFolding;
        this.havingFolding = builder.havingFolding;
        this.windowFolding = builder.windowFolding;
        this.matchFolding = builder.matchFolding;
        this.orderByFolding = builder.orderByFolding;
        this.overFolding = builder.overFolding;
        this.valuesFolding = builder.valuesFolding;
        this.updateSetFolding = builder.updateSetFolding;
        if (builder.keywordsLowerCaseIsSet()) {
            this.initShim.withKeywordsLowerCase(builder.keywordsLowerCase);
        }
        if (builder.quoteAllIdentifiersIsSet()) {
            this.initShim.withQuoteAllIdentifiers(builder.quoteAllIdentifiers);
        }
        if (builder.indentationIsSet()) {
            this.initShim.withIndentation(builder.indentation);
        }
        if (builder.clauseStartsLineIsSet()) {
            this.initShim.withClauseStartsLine(builder.clauseStartsLine);
        }
        if (builder.clauseEndsLineIsSet()) {
            this.initShim.withClauseEndsLine(builder.clauseEndsLine);
        }
        if (builder.selectListItemsOnSeparateLinesIsSet()) {
            this.initShim.withSelectListItemsOnSeparateLines(builder.selectListItemsOnSeparateLines);
        }
        if (builder.fromFolding != null) {
            this.initShim.withFromFolding(builder.fromFolding);
        }
        if (builder.selectListExtraIndentFlagIsSet()) {
            this.initShim.withSelectListExtraIndentFlag(builder.selectListExtraIndentFlag);
        }
        if (builder.windowDeclListNewlineIsSet()) {
            this.initShim.withWindowDeclListNewline(builder.windowDeclListNewline);
        }
        if (builder.valuesListNewlineIsSet()) {
            this.initShim.withValuesListNewline(builder.valuesListNewline);
        }
        if (builder.updateSetListNewlineIsSet()) {
            this.initShim.withUpdateSetListNewline(builder.updateSetListNewline);
        }
        if (builder.windowNewlineIsSet()) {
            this.initShim.withWindowNewline(builder.windowNewline);
        }
        if (builder.leadingCommaIsSet()) {
            this.initShim.withLeadingComma(builder.leadingComma);
        }
        if (builder.subQueryStyle != null) {
            this.initShim.withSubQueryStyle(builder.subQueryStyle);
        }
        if (builder.whereListItemsOnSeparateLinesIsSet()) {
            this.initShim.withWhereListItemsOnSeparateLines(builder.whereListItemsOnSeparateLines);
        }
        if (builder.alwaysUseParenthesesIsSet()) {
            this.initShim.withAlwaysUseParentheses(builder.alwaysUseParentheses);
        }
        if (builder.lineLengthIsSet()) {
            this.initShim.withLineLength(builder.lineLength);
        }
        if (builder.foldLengthIsSet()) {
            this.initShim.withFoldLength(builder.foldLength);
        }
        if (builder.caseClausesOnNewLinesIsSet()) {
            this.initShim.withCaseClausesOnNewLines(builder.caseClausesOnNewLines);
        }
        this.keywordsLowerCase = this.initShim.keywordsLowerCase();
        this.quoteAllIdentifiers = this.initShim.quoteAllIdentifiers();
        this.indentation = this.initShim.indentation();
        this.clauseStartsLine = this.initShim.clauseStartsLine();
        this.clauseEndsLine = this.initShim.clauseEndsLine();
        this.selectListItemsOnSeparateLines = this.initShim.selectListItemsOnSeparateLines();
        this.fromFolding = this.initShim.fromFolding();
        this.selectListExtraIndentFlag = this.initShim.selectListExtraIndentFlag();
        this.windowDeclListNewline = this.initShim.windowDeclListNewline();
        this.valuesListNewline = this.initShim.valuesListNewline();
        this.updateSetListNewline = this.initShim.updateSetListNewline();
        this.windowNewline = this.initShim.windowNewline();
        this.leadingComma = this.initShim.leadingComma();
        this.subQueryStyle = this.initShim.subQueryStyle();
        this.whereListItemsOnSeparateLines = this.initShim.whereListItemsOnSeparateLines();
        this.alwaysUseParentheses = this.initShim.alwaysUseParentheses();
        this.lineLength = this.initShim.lineLength();
        this.foldLength = this.initShim.foldLength();
        this.caseClausesOnNewLines = this.initShim.caseClausesOnNewLines();
        this.initShim = null;
    }

    private ImmutableSqlWriterConfig(@org.checkerframework.checker.nullness.qual.Nullable SqlDialect dialect, boolean keywordsLowerCase, boolean quoteAllIdentifiers, int indentation, boolean clauseStartsLine, boolean clauseEndsLine, boolean selectListItemsOnSeparateLines, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding lineFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding selectFolding, SqlWriterConfig.LineFolding fromFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding whereFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding groupByFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding havingFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding windowFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding matchFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding orderByFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding overFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding valuesFolding, @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding updateSetFolding, boolean selectListExtraIndentFlag, boolean windowDeclListNewline, boolean valuesListNewline, boolean updateSetListNewline, boolean windowNewline, boolean leadingComma, SqlWriter.SubQueryStyle subQueryStyle, boolean whereListItemsOnSeparateLines, boolean alwaysUseParentheses, int lineLength, int foldLength, boolean caseClausesOnNewLines) {
        this.dialect = dialect;
        this.keywordsLowerCase = keywordsLowerCase;
        this.quoteAllIdentifiers = quoteAllIdentifiers;
        this.indentation = indentation;
        this.clauseStartsLine = clauseStartsLine;
        this.clauseEndsLine = clauseEndsLine;
        this.selectListItemsOnSeparateLines = selectListItemsOnSeparateLines;
        this.lineFolding = lineFolding;
        this.selectFolding = selectFolding;
        this.fromFolding = fromFolding;
        this.whereFolding = whereFolding;
        this.groupByFolding = groupByFolding;
        this.havingFolding = havingFolding;
        this.windowFolding = windowFolding;
        this.matchFolding = matchFolding;
        this.orderByFolding = orderByFolding;
        this.overFolding = overFolding;
        this.valuesFolding = valuesFolding;
        this.updateSetFolding = updateSetFolding;
        this.selectListExtraIndentFlag = selectListExtraIndentFlag;
        this.windowDeclListNewline = windowDeclListNewline;
        this.valuesListNewline = valuesListNewline;
        this.updateSetListNewline = updateSetListNewline;
        this.windowNewline = windowNewline;
        this.leadingComma = leadingComma;
        this.subQueryStyle = subQueryStyle;
        this.whereListItemsOnSeparateLines = whereListItemsOnSeparateLines;
        this.alwaysUseParentheses = alwaysUseParentheses;
        this.lineLength = lineLength;
        this.foldLength = foldLength;
        this.caseClausesOnNewLines = caseClausesOnNewLines;
        this.initShim = null;
    }

    private boolean keywordsLowerCaseInitialize() {
        return SqlWriterConfig.super.keywordsLowerCase();
    }

    private boolean quoteAllIdentifiersInitialize() {
        return SqlWriterConfig.super.quoteAllIdentifiers();
    }

    private int indentationInitialize() {
        return SqlWriterConfig.super.indentation();
    }

    private boolean clauseStartsLineInitialize() {
        return SqlWriterConfig.super.clauseStartsLine();
    }

    private boolean clauseEndsLineInitialize() {
        return SqlWriterConfig.super.clauseEndsLine();
    }

    private boolean selectListItemsOnSeparateLinesInitialize() {
        return SqlWriterConfig.super.selectListItemsOnSeparateLines();
    }

    private SqlWriterConfig.LineFolding fromFoldingInitialize() {
        return SqlWriterConfig.super.fromFolding();
    }

    private boolean selectListExtraIndentFlagInitialize() {
        return SqlWriterConfig.super.selectListExtraIndentFlag();
    }

    private boolean windowDeclListNewlineInitialize() {
        return SqlWriterConfig.super.windowDeclListNewline();
    }

    private boolean valuesListNewlineInitialize() {
        return SqlWriterConfig.super.valuesListNewline();
    }

    private boolean updateSetListNewlineInitialize() {
        return SqlWriterConfig.super.updateSetListNewline();
    }

    private boolean windowNewlineInitialize() {
        return SqlWriterConfig.super.windowNewline();
    }

    private boolean leadingCommaInitialize() {
        return SqlWriterConfig.super.leadingComma();
    }

    private SqlWriter.SubQueryStyle subQueryStyleInitialize() {
        return SqlWriterConfig.super.subQueryStyle();
    }

    private boolean whereListItemsOnSeparateLinesInitialize() {
        return SqlWriterConfig.super.whereListItemsOnSeparateLines();
    }

    private boolean alwaysUseParenthesesInitialize() {
        return SqlWriterConfig.super.alwaysUseParentheses();
    }

    private int lineLengthInitialize() {
        return SqlWriterConfig.super.lineLength();
    }

    private int foldLengthInitialize() {
        return SqlWriterConfig.super.foldLength();
    }

    private boolean caseClausesOnNewLinesInitialize() {
        return SqlWriterConfig.super.caseClausesOnNewLines();
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlDialect dialect() {
        return this.dialect;
    }

    @Override
    public boolean keywordsLowerCase() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keywordsLowerCase() : this.keywordsLowerCase;
    }

    @Override
    public boolean quoteAllIdentifiers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.quoteAllIdentifiers() : this.quoteAllIdentifiers;
    }

    @Override
    public int indentation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indentation() : this.indentation;
    }

    @Override
    public boolean clauseStartsLine() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clauseStartsLine() : this.clauseStartsLine;
    }

    @Override
    public boolean clauseEndsLine() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clauseEndsLine() : this.clauseEndsLine;
    }

    @Override
    public boolean selectListItemsOnSeparateLines() {
        InitShim shim = this.initShim;
        return shim != null ? shim.selectListItemsOnSeparateLines() : this.selectListItemsOnSeparateLines;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding lineFolding() {
        return this.lineFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding selectFolding() {
        return this.selectFolding;
    }

    @Override
    public SqlWriterConfig.LineFolding fromFolding() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fromFolding() : this.fromFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding whereFolding() {
        return this.whereFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding groupByFolding() {
        return this.groupByFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding havingFolding() {
        return this.havingFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding windowFolding() {
        return this.windowFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding matchFolding() {
        return this.matchFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding orderByFolding() {
        return this.orderByFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding overFolding() {
        return this.overFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding valuesFolding() {
        return this.valuesFolding;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding updateSetFolding() {
        return this.updateSetFolding;
    }

    @Override
    public boolean selectListExtraIndentFlag() {
        InitShim shim = this.initShim;
        return shim != null ? shim.selectListExtraIndentFlag() : this.selectListExtraIndentFlag;
    }

    @Override
    public boolean windowDeclListNewline() {
        InitShim shim = this.initShim;
        return shim != null ? shim.windowDeclListNewline() : this.windowDeclListNewline;
    }

    @Override
    public boolean valuesListNewline() {
        InitShim shim = this.initShim;
        return shim != null ? shim.valuesListNewline() : this.valuesListNewline;
    }

    @Override
    public boolean updateSetListNewline() {
        InitShim shim = this.initShim;
        return shim != null ? shim.updateSetListNewline() : this.updateSetListNewline;
    }

    @Override
    public boolean windowNewline() {
        InitShim shim = this.initShim;
        return shim != null ? shim.windowNewline() : this.windowNewline;
    }

    @Override
    public boolean leadingComma() {
        InitShim shim = this.initShim;
        return shim != null ? shim.leadingComma() : this.leadingComma;
    }

    @Override
    public SqlWriter.SubQueryStyle subQueryStyle() {
        InitShim shim = this.initShim;
        return shim != null ? shim.subQueryStyle() : this.subQueryStyle;
    }

    @Override
    public boolean whereListItemsOnSeparateLines() {
        InitShim shim = this.initShim;
        return shim != null ? shim.whereListItemsOnSeparateLines() : this.whereListItemsOnSeparateLines;
    }

    @Override
    public boolean alwaysUseParentheses() {
        InitShim shim = this.initShim;
        return shim != null ? shim.alwaysUseParentheses() : this.alwaysUseParentheses;
    }

    @Override
    public int lineLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lineLength() : this.lineLength;
    }

    @Override
    public int foldLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.foldLength() : this.foldLength;
    }

    @Override
    public boolean caseClausesOnNewLines() {
        InitShim shim = this.initShim;
        return shim != null ? shim.caseClausesOnNewLines() : this.caseClausesOnNewLines;
    }

    @Override
    public final ImmutableSqlWriterConfig withDialect(@org.checkerframework.checker.nullness.qual.Nullable SqlDialect value) {
        if (this.dialect == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(value, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withKeywordsLowerCase(boolean value) {
        if (this.keywordsLowerCase == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, value, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withQuoteAllIdentifiers(boolean value) {
        if (this.quoteAllIdentifiers == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, value, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withIndentation(int value) {
        if (this.indentation == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, value, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withClauseStartsLine(boolean value) {
        if (this.clauseStartsLine == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, value, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withClauseEndsLine(boolean value) {
        if (this.clauseEndsLine == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, value, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withSelectListItemsOnSeparateLines(boolean value) {
        if (this.selectListItemsOnSeparateLines == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, value, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withLineFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.lineFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.lineFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, value, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withSelectFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.selectFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.selectFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, value, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withFromFolding(SqlWriterConfig.LineFolding value) {
        if (this.fromFolding == value) {
            return this;
        }
        SqlWriterConfig.LineFolding newValue = Objects.requireNonNull(value, "fromFolding");
        if (this.fromFolding.equals((Object)newValue)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, newValue, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withWhereFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.whereFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.whereFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, value, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withGroupByFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.groupByFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.groupByFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, value, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withHavingFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.havingFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.havingFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, value, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withWindowFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.windowFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.windowFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, value, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withMatchFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.matchFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.matchFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, value, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withOrderByFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.orderByFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.orderByFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, value, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withOverFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.overFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.overFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, value, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withValuesFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.valuesFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.valuesFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, value, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withUpdateSetFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding value) {
        if (this.updateSetFolding == value) {
            return this;
        }
        if (Objects.equals((Object)this.updateSetFolding, (Object)value)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, value, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withSelectListExtraIndentFlag(boolean value) {
        if (this.selectListExtraIndentFlag == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, value, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withWindowDeclListNewline(boolean value) {
        if (this.windowDeclListNewline == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, value, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withValuesListNewline(boolean value) {
        if (this.valuesListNewline == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, value, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withUpdateSetListNewline(boolean value) {
        if (this.updateSetListNewline == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, value, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withWindowNewline(boolean value) {
        if (this.windowNewline == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, value, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withLeadingComma(boolean value) {
        if (this.leadingComma == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, value, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withSubQueryStyle(SqlWriter.SubQueryStyle value) {
        if (this.subQueryStyle == value) {
            return this;
        }
        SqlWriter.SubQueryStyle newValue = Objects.requireNonNull(value, "subQueryStyle");
        if (this.subQueryStyle.equals((Object)newValue)) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, newValue, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withWhereListItemsOnSeparateLines(boolean value) {
        if (this.whereListItemsOnSeparateLines == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, value, this.alwaysUseParentheses, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withAlwaysUseParentheses(boolean value) {
        if (this.alwaysUseParentheses == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, value, this.lineLength, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withLineLength(int value) {
        if (this.lineLength == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, value, this.foldLength, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withFoldLength(int value) {
        if (this.foldLength == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, value, this.caseClausesOnNewLines));
    }

    @Override
    public final ImmutableSqlWriterConfig withCaseClausesOnNewLines(boolean value) {
        if (this.caseClausesOnNewLines == value) {
            return this;
        }
        return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this.dialect, this.keywordsLowerCase, this.quoteAllIdentifiers, this.indentation, this.clauseStartsLine, this.clauseEndsLine, this.selectListItemsOnSeparateLines, this.lineFolding, this.selectFolding, this.fromFolding, this.whereFolding, this.groupByFolding, this.havingFolding, this.windowFolding, this.matchFolding, this.orderByFolding, this.overFolding, this.valuesFolding, this.updateSetFolding, this.selectListExtraIndentFlag, this.windowDeclListNewline, this.valuesListNewline, this.updateSetListNewline, this.windowNewline, this.leadingComma, this.subQueryStyle, this.whereListItemsOnSeparateLines, this.alwaysUseParentheses, this.lineLength, this.foldLength, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlWriterConfig && this.equalTo((ImmutableSqlWriterConfig)another);
    }

    private boolean equalTo(ImmutableSqlWriterConfig another) {
        return Objects.equals(this.dialect, another.dialect) && this.keywordsLowerCase == another.keywordsLowerCase && this.quoteAllIdentifiers == another.quoteAllIdentifiers && this.indentation == another.indentation && this.clauseStartsLine == another.clauseStartsLine && this.clauseEndsLine == another.clauseEndsLine && this.selectListItemsOnSeparateLines == another.selectListItemsOnSeparateLines && Objects.equals((Object)this.lineFolding, (Object)another.lineFolding) && Objects.equals((Object)this.selectFolding, (Object)another.selectFolding) && this.fromFolding.equals((Object)another.fromFolding) && Objects.equals((Object)this.whereFolding, (Object)another.whereFolding) && Objects.equals((Object)this.groupByFolding, (Object)another.groupByFolding) && Objects.equals((Object)this.havingFolding, (Object)another.havingFolding) && Objects.equals((Object)this.windowFolding, (Object)another.windowFolding) && Objects.equals((Object)this.matchFolding, (Object)another.matchFolding) && Objects.equals((Object)this.orderByFolding, (Object)another.orderByFolding) && Objects.equals((Object)this.overFolding, (Object)another.overFolding) && Objects.equals((Object)this.valuesFolding, (Object)another.valuesFolding) && Objects.equals((Object)this.updateSetFolding, (Object)another.updateSetFolding) && this.selectListExtraIndentFlag == another.selectListExtraIndentFlag && this.windowDeclListNewline == another.windowDeclListNewline && this.valuesListNewline == another.valuesListNewline && this.updateSetListNewline == another.updateSetListNewline && this.windowNewline == another.windowNewline && this.leadingComma == another.leadingComma && this.subQueryStyle.equals((Object)another.subQueryStyle) && this.whereListItemsOnSeparateLines == another.whereListItemsOnSeparateLines && this.alwaysUseParentheses == another.alwaysUseParentheses && this.lineLength == another.lineLength && this.foldLength == another.foldLength && this.caseClausesOnNewLines == another.caseClausesOnNewLines;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.dialect);
        h2 += (h2 << 5) + Booleans.hashCode(this.keywordsLowerCase);
        h2 += (h2 << 5) + Booleans.hashCode(this.quoteAllIdentifiers);
        h2 += (h2 << 5) + this.indentation;
        h2 += (h2 << 5) + Booleans.hashCode(this.clauseStartsLine);
        h2 += (h2 << 5) + Booleans.hashCode(this.clauseEndsLine);
        h2 += (h2 << 5) + Booleans.hashCode(this.selectListItemsOnSeparateLines);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.lineFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.selectFolding);
        h2 += (h2 << 5) + this.fromFolding.hashCode();
        h2 += (h2 << 5) + Objects.hashCode((Object)this.whereFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.groupByFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.havingFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.windowFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.matchFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.orderByFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.overFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.valuesFolding);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.updateSetFolding);
        h2 += (h2 << 5) + Booleans.hashCode(this.selectListExtraIndentFlag);
        h2 += (h2 << 5) + Booleans.hashCode(this.windowDeclListNewline);
        h2 += (h2 << 5) + Booleans.hashCode(this.valuesListNewline);
        h2 += (h2 << 5) + Booleans.hashCode(this.updateSetListNewline);
        h2 += (h2 << 5) + Booleans.hashCode(this.windowNewline);
        h2 += (h2 << 5) + Booleans.hashCode(this.leadingComma);
        h2 += (h2 << 5) + this.subQueryStyle.hashCode();
        h2 += (h2 << 5) + Booleans.hashCode(this.whereListItemsOnSeparateLines);
        h2 += (h2 << 5) + Booleans.hashCode(this.alwaysUseParentheses);
        h2 += (h2 << 5) + this.lineLength;
        h2 += (h2 << 5) + this.foldLength;
        h2 += (h2 << 5) + Booleans.hashCode(this.caseClausesOnNewLines);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SqlWriterConfig").omitNullValues().add("dialect", this.dialect).add("keywordsLowerCase", this.keywordsLowerCase).add("quoteAllIdentifiers", this.quoteAllIdentifiers).add("indentation", this.indentation).add("clauseStartsLine", this.clauseStartsLine).add("clauseEndsLine", this.clauseEndsLine).add("selectListItemsOnSeparateLines", this.selectListItemsOnSeparateLines).add("lineFolding", (Object)this.lineFolding).add("selectFolding", (Object)this.selectFolding).add("fromFolding", (Object)this.fromFolding).add("whereFolding", (Object)this.whereFolding).add("groupByFolding", (Object)this.groupByFolding).add("havingFolding", (Object)this.havingFolding).add("windowFolding", (Object)this.windowFolding).add("matchFolding", (Object)this.matchFolding).add("orderByFolding", (Object)this.orderByFolding).add("overFolding", (Object)this.overFolding).add("valuesFolding", (Object)this.valuesFolding).add("updateSetFolding", (Object)this.updateSetFolding).add("selectListExtraIndentFlag", this.selectListExtraIndentFlag).add("windowDeclListNewline", this.windowDeclListNewline).add("valuesListNewline", this.valuesListNewline).add("updateSetListNewline", this.updateSetListNewline).add("windowNewline", this.windowNewline).add("leadingComma", this.leadingComma).add("subQueryStyle", (Object)this.subQueryStyle).add("whereListItemsOnSeparateLines", this.whereListItemsOnSeparateLines).add("alwaysUseParentheses", this.alwaysUseParentheses).add("lineLength", this.lineLength).add("foldLength", this.foldLength).add("caseClausesOnNewLines", this.caseClausesOnNewLines).toString();
    }

    public static ImmutableSqlWriterConfig of() {
        return INSTANCE;
    }

    private static ImmutableSqlWriterConfig validate(ImmutableSqlWriterConfig instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static ImmutableSqlWriterConfig copyOf(SqlWriterConfig instance) {
        if (instance instanceof ImmutableSqlWriterConfig) {
            return (ImmutableSqlWriterConfig)instance;
        }
        return ImmutableSqlWriterConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SqlWriterConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_KEYWORDS_LOWER_CASE = 1L;
        private static final long OPT_BIT_QUOTE_ALL_IDENTIFIERS = 2L;
        private static final long OPT_BIT_INDENTATION = 4L;
        private static final long OPT_BIT_CLAUSE_STARTS_LINE = 8L;
        private static final long OPT_BIT_CLAUSE_ENDS_LINE = 16L;
        private static final long OPT_BIT_SELECT_LIST_ITEMS_ON_SEPARATE_LINES = 32L;
        private static final long OPT_BIT_SELECT_LIST_EXTRA_INDENT_FLAG = 64L;
        private static final long OPT_BIT_WINDOW_DECL_LIST_NEWLINE = 128L;
        private static final long OPT_BIT_VALUES_LIST_NEWLINE = 256L;
        private static final long OPT_BIT_UPDATE_SET_LIST_NEWLINE = 512L;
        private static final long OPT_BIT_WINDOW_NEWLINE = 1024L;
        private static final long OPT_BIT_LEADING_COMMA = 2048L;
        private static final long OPT_BIT_WHERE_LIST_ITEMS_ON_SEPARATE_LINES = 4096L;
        private static final long OPT_BIT_ALWAYS_USE_PARENTHESES = 8192L;
        private static final long OPT_BIT_LINE_LENGTH = 16384L;
        private static final long OPT_BIT_FOLD_LENGTH = 32768L;
        private static final long OPT_BIT_CASE_CLAUSES_ON_NEW_LINES = 65536L;
        private long optBits;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlDialect dialect;
        private boolean keywordsLowerCase;
        private boolean quoteAllIdentifiers;
        private int indentation;
        private boolean clauseStartsLine;
        private boolean clauseEndsLine;
        private boolean selectListItemsOnSeparateLines;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding lineFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding selectFolding;
        @Nullable
        private SqlWriterConfig.LineFolding fromFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding whereFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding groupByFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding havingFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding windowFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding matchFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding orderByFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding overFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding valuesFolding;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding updateSetFolding;
        private boolean selectListExtraIndentFlag;
        private boolean windowDeclListNewline;
        private boolean valuesListNewline;
        private boolean updateSetListNewline;
        private boolean windowNewline;
        private boolean leadingComma;
        @Nullable
        private SqlWriter.SubQueryStyle subQueryStyle;
        private boolean whereListItemsOnSeparateLines;
        private boolean alwaysUseParentheses;
        private int lineLength;
        private int foldLength;
        private boolean caseClausesOnNewLines;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SqlWriterConfig instance) {
            SqlWriterConfig.LineFolding updateSetFoldingValue;
            SqlWriterConfig.LineFolding valuesFoldingValue;
            SqlWriterConfig.LineFolding overFoldingValue;
            SqlWriterConfig.LineFolding orderByFoldingValue;
            SqlWriterConfig.LineFolding matchFoldingValue;
            SqlWriterConfig.LineFolding windowFoldingValue;
            SqlWriterConfig.LineFolding havingFoldingValue;
            SqlWriterConfig.LineFolding groupByFoldingValue;
            SqlWriterConfig.LineFolding selectFoldingValue;
            Objects.requireNonNull(instance, "instance");
            @org.checkerframework.checker.nullness.qual.Nullable SqlDialect dialectValue = instance.dialect();
            if (dialectValue != null) {
                this.withDialect(dialectValue);
            }
            this.withKeywordsLowerCase(instance.keywordsLowerCase());
            this.withQuoteAllIdentifiers(instance.quoteAllIdentifiers());
            this.withIndentation(instance.indentation());
            this.withClauseStartsLine(instance.clauseStartsLine());
            this.withClauseEndsLine(instance.clauseEndsLine());
            this.withSelectListItemsOnSeparateLines(instance.selectListItemsOnSeparateLines());
            @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding lineFoldingValue = instance.lineFolding();
            if (lineFoldingValue != null) {
                this.withLineFolding(lineFoldingValue);
            }
            if ((selectFoldingValue = instance.selectFolding()) != null) {
                this.withSelectFolding(selectFoldingValue);
            }
            this.withFromFolding(instance.fromFolding());
            @org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding whereFoldingValue = instance.whereFolding();
            if (whereFoldingValue != null) {
                this.withWhereFolding(whereFoldingValue);
            }
            if ((groupByFoldingValue = instance.groupByFolding()) != null) {
                this.withGroupByFolding(groupByFoldingValue);
            }
            if ((havingFoldingValue = instance.havingFolding()) != null) {
                this.withHavingFolding(havingFoldingValue);
            }
            if ((windowFoldingValue = instance.windowFolding()) != null) {
                this.withWindowFolding(windowFoldingValue);
            }
            if ((matchFoldingValue = instance.matchFolding()) != null) {
                this.withMatchFolding(matchFoldingValue);
            }
            if ((orderByFoldingValue = instance.orderByFolding()) != null) {
                this.withOrderByFolding(orderByFoldingValue);
            }
            if ((overFoldingValue = instance.overFolding()) != null) {
                this.withOverFolding(overFoldingValue);
            }
            if ((valuesFoldingValue = instance.valuesFolding()) != null) {
                this.withValuesFolding(valuesFoldingValue);
            }
            if ((updateSetFoldingValue = instance.updateSetFolding()) != null) {
                this.withUpdateSetFolding(updateSetFoldingValue);
            }
            this.withSelectListExtraIndentFlag(instance.selectListExtraIndentFlag());
            this.withWindowDeclListNewline(instance.windowDeclListNewline());
            this.withValuesListNewline(instance.valuesListNewline());
            this.withUpdateSetListNewline(instance.updateSetListNewline());
            this.withWindowNewline(instance.windowNewline());
            this.withLeadingComma(instance.leadingComma());
            this.withSubQueryStyle(instance.subQueryStyle());
            this.withWhereListItemsOnSeparateLines(instance.whereListItemsOnSeparateLines());
            this.withAlwaysUseParentheses(instance.alwaysUseParentheses());
            this.withLineLength(instance.lineLength());
            this.withFoldLength(instance.foldLength());
            this.withCaseClausesOnNewLines(instance.caseClausesOnNewLines());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withDialect(@org.checkerframework.checker.nullness.qual.Nullable SqlDialect dialect) {
            this.dialect = dialect;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withKeywordsLowerCase(boolean keywordsLowerCase) {
            this.keywordsLowerCase = keywordsLowerCase;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withQuoteAllIdentifiers(boolean quoteAllIdentifiers) {
            this.quoteAllIdentifiers = quoteAllIdentifiers;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withIndentation(int indentation) {
            this.indentation = indentation;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withClauseStartsLine(boolean clauseStartsLine) {
            this.clauseStartsLine = clauseStartsLine;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withClauseEndsLine(boolean clauseEndsLine) {
            this.clauseEndsLine = clauseEndsLine;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withSelectListItemsOnSeparateLines(boolean selectListItemsOnSeparateLines) {
            this.selectListItemsOnSeparateLines = selectListItemsOnSeparateLines;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withLineFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding lineFolding) {
            this.lineFolding = lineFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withSelectFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding selectFolding) {
            this.selectFolding = selectFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withFromFolding(SqlWriterConfig.LineFolding fromFolding) {
            this.fromFolding = Objects.requireNonNull(fromFolding, "fromFolding");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withWhereFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding whereFolding) {
            this.whereFolding = whereFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withGroupByFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding groupByFolding) {
            this.groupByFolding = groupByFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withHavingFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding havingFolding) {
            this.havingFolding = havingFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withWindowFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding windowFolding) {
            this.windowFolding = windowFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withMatchFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding matchFolding) {
            this.matchFolding = matchFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withOrderByFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding orderByFolding) {
            this.orderByFolding = orderByFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withOverFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding overFolding) {
            this.overFolding = overFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withValuesFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding valuesFolding) {
            this.valuesFolding = valuesFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withUpdateSetFolding(@org.checkerframework.checker.nullness.qual.Nullable SqlWriterConfig.LineFolding updateSetFolding) {
            this.updateSetFolding = updateSetFolding;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withSelectListExtraIndentFlag(boolean selectListExtraIndentFlag) {
            this.selectListExtraIndentFlag = selectListExtraIndentFlag;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withWindowDeclListNewline(boolean windowDeclListNewline) {
            this.windowDeclListNewline = windowDeclListNewline;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withValuesListNewline(boolean valuesListNewline) {
            this.valuesListNewline = valuesListNewline;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withUpdateSetListNewline(boolean updateSetListNewline) {
            this.updateSetListNewline = updateSetListNewline;
            this.optBits |= 0x200L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withWindowNewline(boolean windowNewline) {
            this.windowNewline = windowNewline;
            this.optBits |= 0x400L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withLeadingComma(boolean leadingComma) {
            this.leadingComma = leadingComma;
            this.optBits |= 0x800L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withSubQueryStyle(SqlWriter.SubQueryStyle subQueryStyle) {
            this.subQueryStyle = Objects.requireNonNull(subQueryStyle, "subQueryStyle");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withWhereListItemsOnSeparateLines(boolean whereListItemsOnSeparateLines) {
            this.whereListItemsOnSeparateLines = whereListItemsOnSeparateLines;
            this.optBits |= 0x1000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withAlwaysUseParentheses(boolean alwaysUseParentheses) {
            this.alwaysUseParentheses = alwaysUseParentheses;
            this.optBits |= 0x2000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withLineLength(int lineLength) {
            this.lineLength = lineLength;
            this.optBits |= 0x4000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withFoldLength(int foldLength) {
            this.foldLength = foldLength;
            this.optBits |= 0x8000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withCaseClausesOnNewLines(boolean caseClausesOnNewLines) {
            this.caseClausesOnNewLines = caseClausesOnNewLines;
            this.optBits |= 0x10000L;
            return this;
        }

        public ImmutableSqlWriterConfig build() {
            return ImmutableSqlWriterConfig.validate(new ImmutableSqlWriterConfig(this));
        }

        private boolean keywordsLowerCaseIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean quoteAllIdentifiersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean indentationIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean clauseStartsLineIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean clauseEndsLineIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean selectListItemsOnSeparateLinesIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean selectListExtraIndentFlagIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean windowDeclListNewlineIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean valuesListNewlineIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean updateSetListNewlineIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean windowNewlineIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean leadingCommaIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean whereListItemsOnSeparateLinesIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean alwaysUseParenthesesIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean lineLengthIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private boolean foldLengthIsSet() {
            return (this.optBits & 0x8000L) != 0L;
        }

        private boolean caseClausesOnNewLinesIsSet() {
            return (this.optBits & 0x10000L) != 0L;
        }
    }

    @Generated(from="SqlWriterConfig", generator="Immutables")
    private final class InitShim {
        private byte keywordsLowerCaseBuildStage = 0;
        private boolean keywordsLowerCase;
        private byte quoteAllIdentifiersBuildStage = 0;
        private boolean quoteAllIdentifiers;
        private byte indentationBuildStage = 0;
        private int indentation;
        private byte clauseStartsLineBuildStage = 0;
        private boolean clauseStartsLine;
        private byte clauseEndsLineBuildStage = 0;
        private boolean clauseEndsLine;
        private byte selectListItemsOnSeparateLinesBuildStage = 0;
        private boolean selectListItemsOnSeparateLines;
        private byte fromFoldingBuildStage = 0;
        private SqlWriterConfig.LineFolding fromFolding;
        private byte selectListExtraIndentFlagBuildStage = 0;
        private boolean selectListExtraIndentFlag;
        private byte windowDeclListNewlineBuildStage = 0;
        private boolean windowDeclListNewline;
        private byte valuesListNewlineBuildStage = 0;
        private boolean valuesListNewline;
        private byte updateSetListNewlineBuildStage = 0;
        private boolean updateSetListNewline;
        private byte windowNewlineBuildStage = 0;
        private boolean windowNewline;
        private byte leadingCommaBuildStage = 0;
        private boolean leadingComma;
        private byte subQueryStyleBuildStage = 0;
        private SqlWriter.SubQueryStyle subQueryStyle;
        private byte whereListItemsOnSeparateLinesBuildStage = 0;
        private boolean whereListItemsOnSeparateLines;
        private byte alwaysUseParenthesesBuildStage = 0;
        private boolean alwaysUseParentheses;
        private byte lineLengthBuildStage = 0;
        private int lineLength;
        private byte foldLengthBuildStage = 0;
        private int foldLength;
        private byte caseClausesOnNewLinesBuildStage = 0;
        private boolean caseClausesOnNewLines;

        private InitShim() {
        }

        boolean keywordsLowerCase() {
            if (this.keywordsLowerCaseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keywordsLowerCaseBuildStage == 0) {
                this.keywordsLowerCaseBuildStage = (byte)-1;
                this.keywordsLowerCase = ImmutableSqlWriterConfig.this.keywordsLowerCaseInitialize();
                this.keywordsLowerCaseBuildStage = 1;
            }
            return this.keywordsLowerCase;
        }

        void withKeywordsLowerCase(boolean keywordsLowerCase) {
            this.keywordsLowerCase = keywordsLowerCase;
            this.keywordsLowerCaseBuildStage = 1;
        }

        boolean quoteAllIdentifiers() {
            if (this.quoteAllIdentifiersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.quoteAllIdentifiersBuildStage == 0) {
                this.quoteAllIdentifiersBuildStage = (byte)-1;
                this.quoteAllIdentifiers = ImmutableSqlWriterConfig.this.quoteAllIdentifiersInitialize();
                this.quoteAllIdentifiersBuildStage = 1;
            }
            return this.quoteAllIdentifiers;
        }

        void withQuoteAllIdentifiers(boolean quoteAllIdentifiers) {
            this.quoteAllIdentifiers = quoteAllIdentifiers;
            this.quoteAllIdentifiersBuildStage = 1;
        }

        int indentation() {
            if (this.indentationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indentationBuildStage == 0) {
                this.indentationBuildStage = (byte)-1;
                this.indentation = ImmutableSqlWriterConfig.this.indentationInitialize();
                this.indentationBuildStage = 1;
            }
            return this.indentation;
        }

        void withIndentation(int indentation) {
            this.indentation = indentation;
            this.indentationBuildStage = 1;
        }

        boolean clauseStartsLine() {
            if (this.clauseStartsLineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clauseStartsLineBuildStage == 0) {
                this.clauseStartsLineBuildStage = (byte)-1;
                this.clauseStartsLine = ImmutableSqlWriterConfig.this.clauseStartsLineInitialize();
                this.clauseStartsLineBuildStage = 1;
            }
            return this.clauseStartsLine;
        }

        void withClauseStartsLine(boolean clauseStartsLine) {
            this.clauseStartsLine = clauseStartsLine;
            this.clauseStartsLineBuildStage = 1;
        }

        boolean clauseEndsLine() {
            if (this.clauseEndsLineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clauseEndsLineBuildStage == 0) {
                this.clauseEndsLineBuildStage = (byte)-1;
                this.clauseEndsLine = ImmutableSqlWriterConfig.this.clauseEndsLineInitialize();
                this.clauseEndsLineBuildStage = 1;
            }
            return this.clauseEndsLine;
        }

        void withClauseEndsLine(boolean clauseEndsLine) {
            this.clauseEndsLine = clauseEndsLine;
            this.clauseEndsLineBuildStage = 1;
        }

        boolean selectListItemsOnSeparateLines() {
            if (this.selectListItemsOnSeparateLinesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selectListItemsOnSeparateLinesBuildStage == 0) {
                this.selectListItemsOnSeparateLinesBuildStage = (byte)-1;
                this.selectListItemsOnSeparateLines = ImmutableSqlWriterConfig.this.selectListItemsOnSeparateLinesInitialize();
                this.selectListItemsOnSeparateLinesBuildStage = 1;
            }
            return this.selectListItemsOnSeparateLines;
        }

        void withSelectListItemsOnSeparateLines(boolean selectListItemsOnSeparateLines) {
            this.selectListItemsOnSeparateLines = selectListItemsOnSeparateLines;
            this.selectListItemsOnSeparateLinesBuildStage = 1;
        }

        SqlWriterConfig.LineFolding fromFolding() {
            if (this.fromFoldingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fromFoldingBuildStage == 0) {
                this.fromFoldingBuildStage = (byte)-1;
                this.fromFolding = Objects.requireNonNull(ImmutableSqlWriterConfig.this.fromFoldingInitialize(), "fromFolding");
                this.fromFoldingBuildStage = 1;
            }
            return this.fromFolding;
        }

        void withFromFolding(SqlWriterConfig.LineFolding fromFolding) {
            this.fromFolding = fromFolding;
            this.fromFoldingBuildStage = 1;
        }

        boolean selectListExtraIndentFlag() {
            if (this.selectListExtraIndentFlagBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selectListExtraIndentFlagBuildStage == 0) {
                this.selectListExtraIndentFlagBuildStage = (byte)-1;
                this.selectListExtraIndentFlag = ImmutableSqlWriterConfig.this.selectListExtraIndentFlagInitialize();
                this.selectListExtraIndentFlagBuildStage = 1;
            }
            return this.selectListExtraIndentFlag;
        }

        void withSelectListExtraIndentFlag(boolean selectListExtraIndentFlag) {
            this.selectListExtraIndentFlag = selectListExtraIndentFlag;
            this.selectListExtraIndentFlagBuildStage = 1;
        }

        boolean windowDeclListNewline() {
            if (this.windowDeclListNewlineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.windowDeclListNewlineBuildStage == 0) {
                this.windowDeclListNewlineBuildStage = (byte)-1;
                this.windowDeclListNewline = ImmutableSqlWriterConfig.this.windowDeclListNewlineInitialize();
                this.windowDeclListNewlineBuildStage = 1;
            }
            return this.windowDeclListNewline;
        }

        void withWindowDeclListNewline(boolean windowDeclListNewline) {
            this.windowDeclListNewline = windowDeclListNewline;
            this.windowDeclListNewlineBuildStage = 1;
        }

        boolean valuesListNewline() {
            if (this.valuesListNewlineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.valuesListNewlineBuildStage == 0) {
                this.valuesListNewlineBuildStage = (byte)-1;
                this.valuesListNewline = ImmutableSqlWriterConfig.this.valuesListNewlineInitialize();
                this.valuesListNewlineBuildStage = 1;
            }
            return this.valuesListNewline;
        }

        void withValuesListNewline(boolean valuesListNewline) {
            this.valuesListNewline = valuesListNewline;
            this.valuesListNewlineBuildStage = 1;
        }

        boolean updateSetListNewline() {
            if (this.updateSetListNewlineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.updateSetListNewlineBuildStage == 0) {
                this.updateSetListNewlineBuildStage = (byte)-1;
                this.updateSetListNewline = ImmutableSqlWriterConfig.this.updateSetListNewlineInitialize();
                this.updateSetListNewlineBuildStage = 1;
            }
            return this.updateSetListNewline;
        }

        void withUpdateSetListNewline(boolean updateSetListNewline) {
            this.updateSetListNewline = updateSetListNewline;
            this.updateSetListNewlineBuildStage = 1;
        }

        boolean windowNewline() {
            if (this.windowNewlineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.windowNewlineBuildStage == 0) {
                this.windowNewlineBuildStage = (byte)-1;
                this.windowNewline = ImmutableSqlWriterConfig.this.windowNewlineInitialize();
                this.windowNewlineBuildStage = 1;
            }
            return this.windowNewline;
        }

        void withWindowNewline(boolean windowNewline) {
            this.windowNewline = windowNewline;
            this.windowNewlineBuildStage = 1;
        }

        boolean leadingComma() {
            if (this.leadingCommaBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.leadingCommaBuildStage == 0) {
                this.leadingCommaBuildStage = (byte)-1;
                this.leadingComma = ImmutableSqlWriterConfig.this.leadingCommaInitialize();
                this.leadingCommaBuildStage = 1;
            }
            return this.leadingComma;
        }

        void withLeadingComma(boolean leadingComma) {
            this.leadingComma = leadingComma;
            this.leadingCommaBuildStage = 1;
        }

        SqlWriter.SubQueryStyle subQueryStyle() {
            if (this.subQueryStyleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.subQueryStyleBuildStage == 0) {
                this.subQueryStyleBuildStage = (byte)-1;
                this.subQueryStyle = Objects.requireNonNull(ImmutableSqlWriterConfig.this.subQueryStyleInitialize(), "subQueryStyle");
                this.subQueryStyleBuildStage = 1;
            }
            return this.subQueryStyle;
        }

        void withSubQueryStyle(SqlWriter.SubQueryStyle subQueryStyle) {
            this.subQueryStyle = subQueryStyle;
            this.subQueryStyleBuildStage = 1;
        }

        boolean whereListItemsOnSeparateLines() {
            if (this.whereListItemsOnSeparateLinesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.whereListItemsOnSeparateLinesBuildStage == 0) {
                this.whereListItemsOnSeparateLinesBuildStage = (byte)-1;
                this.whereListItemsOnSeparateLines = ImmutableSqlWriterConfig.this.whereListItemsOnSeparateLinesInitialize();
                this.whereListItemsOnSeparateLinesBuildStage = 1;
            }
            return this.whereListItemsOnSeparateLines;
        }

        void withWhereListItemsOnSeparateLines(boolean whereListItemsOnSeparateLines) {
            this.whereListItemsOnSeparateLines = whereListItemsOnSeparateLines;
            this.whereListItemsOnSeparateLinesBuildStage = 1;
        }

        boolean alwaysUseParentheses() {
            if (this.alwaysUseParenthesesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.alwaysUseParenthesesBuildStage == 0) {
                this.alwaysUseParenthesesBuildStage = (byte)-1;
                this.alwaysUseParentheses = ImmutableSqlWriterConfig.this.alwaysUseParenthesesInitialize();
                this.alwaysUseParenthesesBuildStage = 1;
            }
            return this.alwaysUseParentheses;
        }

        void withAlwaysUseParentheses(boolean alwaysUseParentheses) {
            this.alwaysUseParentheses = alwaysUseParentheses;
            this.alwaysUseParenthesesBuildStage = 1;
        }

        int lineLength() {
            if (this.lineLengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lineLengthBuildStage == 0) {
                this.lineLengthBuildStage = (byte)-1;
                this.lineLength = ImmutableSqlWriterConfig.this.lineLengthInitialize();
                this.lineLengthBuildStage = 1;
            }
            return this.lineLength;
        }

        void withLineLength(int lineLength) {
            this.lineLength = lineLength;
            this.lineLengthBuildStage = 1;
        }

        int foldLength() {
            if (this.foldLengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.foldLengthBuildStage == 0) {
                this.foldLengthBuildStage = (byte)-1;
                this.foldLength = ImmutableSqlWriterConfig.this.foldLengthInitialize();
                this.foldLengthBuildStage = 1;
            }
            return this.foldLength;
        }

        void withFoldLength(int foldLength) {
            this.foldLength = foldLength;
            this.foldLengthBuildStage = 1;
        }

        boolean caseClausesOnNewLines() {
            if (this.caseClausesOnNewLinesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.caseClausesOnNewLinesBuildStage == 0) {
                this.caseClausesOnNewLinesBuildStage = (byte)-1;
                this.caseClausesOnNewLines = ImmutableSqlWriterConfig.this.caseClausesOnNewLinesInitialize();
                this.caseClausesOnNewLinesBuildStage = 1;
            }
            return this.caseClausesOnNewLines;
        }

        void withCaseClausesOnNewLines(boolean caseClausesOnNewLines) {
            this.caseClausesOnNewLines = caseClausesOnNewLines;
            this.caseClausesOnNewLinesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.keywordsLowerCaseBuildStage == -1) {
                attributes.add("keywordsLowerCase");
            }
            if (this.quoteAllIdentifiersBuildStage == -1) {
                attributes.add("quoteAllIdentifiers");
            }
            if (this.indentationBuildStage == -1) {
                attributes.add("indentation");
            }
            if (this.clauseStartsLineBuildStage == -1) {
                attributes.add("clauseStartsLine");
            }
            if (this.clauseEndsLineBuildStage == -1) {
                attributes.add("clauseEndsLine");
            }
            if (this.selectListItemsOnSeparateLinesBuildStage == -1) {
                attributes.add("selectListItemsOnSeparateLines");
            }
            if (this.fromFoldingBuildStage == -1) {
                attributes.add("fromFolding");
            }
            if (this.selectListExtraIndentFlagBuildStage == -1) {
                attributes.add("selectListExtraIndentFlag");
            }
            if (this.windowDeclListNewlineBuildStage == -1) {
                attributes.add("windowDeclListNewline");
            }
            if (this.valuesListNewlineBuildStage == -1) {
                attributes.add("valuesListNewline");
            }
            if (this.updateSetListNewlineBuildStage == -1) {
                attributes.add("updateSetListNewline");
            }
            if (this.windowNewlineBuildStage == -1) {
                attributes.add("windowNewline");
            }
            if (this.leadingCommaBuildStage == -1) {
                attributes.add("leadingComma");
            }
            if (this.subQueryStyleBuildStage == -1) {
                attributes.add("subQueryStyle");
            }
            if (this.whereListItemsOnSeparateLinesBuildStage == -1) {
                attributes.add("whereListItemsOnSeparateLines");
            }
            if (this.alwaysUseParenthesesBuildStage == -1) {
                attributes.add("alwaysUseParentheses");
            }
            if (this.lineLengthBuildStage == -1) {
                attributes.add("lineLength");
            }
            if (this.foldLengthBuildStage == -1) {
                attributes.add("foldLength");
            }
            if (this.caseClausesOnNewLinesBuildStage == -1) {
                attributes.add("caseClausesOnNewLines");
            }
            return "Cannot build SqlWriterConfig, attribute initializers form cycle " + attributes;
        }
    }
}

